/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.EventHubManagementService;
import com.parablu.bp.service.BackupFolderService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.element.BackupFolderElement;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BackupFolderController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(BackupFolderController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private BackupFolderService backupFolderService;
    @Autowired
    private EventHubManagementService eventHubManagementService;

    @RequestMapping(value={"cloud/{cloudName}/backupFolder/save"}, method={RequestMethod.POST})
    public void saveBackupFolder(@PathVariable(value="cloudName") String cloudName1, @RequestBody BackupFolderElement backupFolderElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling save Schedule ...");
        String cloudName = cloudName1;
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return;
            }
            this.backupFolderService.saveBackupFolder(cloudId, cloudName, backupFolderElement);
            this.eventHubManagementService.saveActionFromBackupFolder(cloudId, cloudName, backupFolderElement, this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token).getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling /authenticateOneDrive ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/backupFolder/load/{folderPath}/"}, method={RequestMethod.GET})
    public ModelAndView getBackupFolders(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="folderPath") String folderPath, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load BackupFolder ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            BackupFolderElement backupFolderElement = this.backupFolderService.getBackupFolder(cloudId, cloudName, folderPath);
            if (backupFolderElement == null) {
                response.setStatus(400);
                return null;
            }
            modelAndView.addObject((Object)backupFolderElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug("Error failed to load BackupFolder ..." + (Object)((Object)e));
            logger.error("Error failed to load BackupFolder ..." + e.getMessage());
        }
        logger.debug("end of loading BackupFolder ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/backupFolder/load/all"}, method={RequestMethod.GET})
    public ModelAndView getAllBackupFolders(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load all BackupFolders ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<BackupFolderElement> backupFolderElementElements = this.backupFolderService.getAllBackupFolders(cloudId, cloudName);
            if (backupFolderElementElements.isEmpty()) {
                backupFolderElementElements = new ArrayList<BackupFolderElement>();
            }
            modelAndView.addObject(backupFolderElementElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load all BackupFolders  ..." + (Object)((Object)e));
            logger.error("Error failed to load all BackupFolders  ..." + e.getMessage());
        }
        logger.debug("end of load all BackupFolders ...");
        return modelAndView;
    }
}

