/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.OfficeBackupPolicyService;
import com.parablu.helper.utils.OfficeBackupPolicyDiffFinder;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.BackupFolderElement;
import com.parablu.paracloud.element.BluSyncScheduleElement;
import com.parablu.paracloud.element.OfficeBackupPolicyElement;
import com.parablu.paracloud.element.PrivacyGatewayMappingElement;
import com.parablu.paracloud.element.ScheduleDaysArrayElement;
import com.parablu.paracloud.element.bp.EditUserBackupPolicyMappingElement;
import com.parablu.paracloud.element.bp.ExcludedFolderElement;
import com.parablu.paracloud.element.bp.UserBackupPolicyMappingElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackupFoldersDao;
import com.parablu.pcbd.dao.BluVaultDao;
import com.parablu.pcbd.dao.CalloutScriptDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.ExcludedFoldersDao;
import com.parablu.pcbd.dao.InclusionFilterDao;
import com.parablu.pcbd.dao.NetworkThrottlingDao;
import com.parablu.pcbd.dao.OfficeBackupPolicyDao;
import com.parablu.pcbd.dao.PrivacyGateWayDao;
import com.parablu.pcbd.dao.ReleaseDao;
import com.parablu.pcbd.dao.SchedulesDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserDefinedFoldersDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.CalloutScript;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OfficeBackupPolicyServiceImpl
implements OfficeBackupPolicyService {
    private static Logger logger = LoggerFactory.getLogger(OfficeBackupPolicyServiceImpl.class);
    @Resource
    private OfficeBackupPolicyDao oneDriveBackupPolicyDao;
    @Resource
    private BackupFoldersDao backupFoldersDao;
    @Resource
    private CalloutScriptDao calloutScriptDao;
    @Resource
    private SchedulesDao schedulesDao;
    @Resource
    private NetworkThrottlingDao networkThrottlingDao;
    @Resource
    private InclusionFilterDao inclusionFilterDao;
    @Resource
    private PrivacyGateWayDao privacyGateWayDao;
    @Resource
    private UserDefinedFoldersDao userDefinedFoldersDao;
    @Resource
    private ExcludedFoldersDao excludedFoldersDao;
    @Resource
    private ReleaseDao releaseDao;
    @Resource
    private UserDao userDao;
    @Resource
    private BluVaultDao bluVaultDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private CloudDao cloudDao;

    @Override
    public void saveBackupPolicy(int cloudId, String cloudName, OfficeBackupPolicyElement backupPolicyElement, String userName) {
        List odbackupFolderPaths = backupPolicyElement.getOdBackupFolderPaths();
        List odexcludedFolderPaths = backupPolicyElement.getExcludedOdFolderpaths();
        List mailbackupFolderPaths = backupPolicyElement.getMailBackupFolderPaths();
        List mailexcludedFolderPaths = backupPolicyElement.getExcludedMailFolderpaths();
        List calloutScripts = backupPolicyElement.getCalloutScripts();
        OfficeBackupPolicy existingOfficeBackupPolicy = this.oneDriveBackupPolicyDao.getOfficeBackupPolicy(cloudId, backupPolicyElement.getPolicygroupName());
        List odscheduleNames = backupPolicyElement.getOdScheduleNames();
        List odschedules = this.schedulesDao.getSchedules(cloudId, cloudName, odscheduleNames);
        List mailscheduleNames = backupPolicyElement.getMailScheduleNames();
        List mailschedules = this.schedulesDao.getSchedules(cloudId, cloudName, mailscheduleNames);
        List odFilterNames = backupPolicyElement.getOdFilterInclusionName();
        ArrayList<Object> odFilters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)odFilterNames)) {
            odFilters = this.getFiltersbyName(cloudId, cloudName, odFilterNames);
        }
        List searchFilterInclusionNames = backupPolicyElement.getSearchFilterInclusionName();
        ArrayList<Object> odSearchfilters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)searchFilterInclusionNames)) {
            odSearchfilters = this.getFiltersbyName(cloudId, cloudName, searchFilterInclusionNames);
        }
        List mailFilterNames = backupPolicyElement.getMailFilterInclusionName();
        ArrayList<Object> mailFilters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)mailFilterNames)) {
            mailFilters = this.getFiltersbyName(cloudId, cloudName, mailFilterNames);
        }
        Object cloudCredentials = null;
        String changedFields = "";
        OfficeBackupPolicyElement existingOfficeBackupPolicyElement = new OfficeBackupPolicyElement();
        ArrayList<ObjectId> existingOdBackFoldersList = new ArrayList<ObjectId>();
        ArrayList<String> existingOdBackupFolderPath = new ArrayList<String>();
        ArrayList<ObjectId> existingMailBackFoldersList = new ArrayList<ObjectId>();
        ArrayList<String> existingMailBackupFolderPath = new ArrayList<String>();
        ArrayList existingCalloutScriptList = new ArrayList();
        ArrayList<String> existingOdExcludedFolderPath = new ArrayList<String>();
        ArrayList<String> existingMailExcludedFolderPath = new ArrayList<String>();
        ArrayList<String> existingPrivacyGateways = new ArrayList<String>();
        ArrayList<String> existingodScheduleNames = new ArrayList<String>();
        ArrayList<String> existingmailScheduleNames = new ArrayList<String>();
        if (existingOfficeBackupPolicy != null) {
            BeanUtils.copyProperties((Object)existingOfficeBackupPolicy, (Object)existingOfficeBackupPolicyElement);
            for (Schedule sch : existingOfficeBackupPolicy.getOdSchedules()) {
                existingodScheduleNames.add(sch.getScheduleName());
            }
            existingOfficeBackupPolicyElement.setOdScheduleNames(existingodScheduleNames);
            for (Schedule sch : existingOfficeBackupPolicy.getMailSchedules()) {
                existingmailScheduleNames.add(sch.getScheduleName());
            }
            existingOfficeBackupPolicyElement.setMailScheduleNames(existingmailScheduleNames);
            existingOfficeBackupPolicyElement.setEndpointUiPreferences((List)existingOfficeBackupPolicy.getEndpointUiPreferences());
            for (BackupFolders backupFolders : existingOfficeBackupPolicy.getOdBackupFolders()) {
                existingOdBackFoldersList.add(backupFolders.getId());
                existingOdBackupFolderPath.add(backupFolders.getFolderPath());
            }
            for (BackupFolders backupFolders : existingOfficeBackupPolicy.getMailBackupFolders()) {
                existingMailBackFoldersList.add(backupFolders.getId());
                existingMailBackupFolderPath.add(backupFolders.getFolderPath());
            }
            if (existingOfficeBackupPolicy.getMailExcludedFolders() != null) {
                for (ExcludedFolders excludedFolders : existingOfficeBackupPolicy.getMailExcludedFolders()) {
                    existingMailExcludedFolderPath.add(excludedFolders.getFolderPath());
                }
            }
            if (existingOfficeBackupPolicy.getOdExcludedFolders() != null) {
                for (ExcludedFolders excludedFolders : existingOfficeBackupPolicy.getOdExcludedFolders()) {
                    existingOdExcludedFolderPath.add(excludedFolders.getFolderPath());
                }
            }
            if (StringUtils.isEmpty((Object)backupPolicyElement.getExcludedOdFolderpaths())) {
                backupPolicyElement.setExcludedOdFolderpaths(new ArrayList());
            }
            if (StringUtils.isEmpty((Object)backupPolicyElement.getExcludedMailFolderpaths())) {
                backupPolicyElement.setExcludedMailFolderpaths(new ArrayList());
            }
            existingOfficeBackupPolicy.setCanAdminRestore(backupPolicyElement.isCanAdminRestore());
            this.oneDriveBackupPolicyDao.saveOfficeBackupPolicy(cloudId, existingOfficeBackupPolicy);
        }
        List<BackupFolders> odbackupFolders = this.getBackupFolders(cloudId, cloudName, backupPolicyElement, odbackupFolderPaths);
        List<Object> oduserExcludedFodlers = new ArrayList();
        if (!StringUtils.isEmpty((Object)odexcludedFolderPaths)) {
            oduserExcludedFodlers = this.getUserExclusionFolders(cloudId, backupPolicyElement, odexcludedFolderPaths);
        }
        List<BackupFolders> mailbackupFolders = this.getBackupFolders(cloudId, cloudName, backupPolicyElement, mailbackupFolderPaths);
        List<Object> mailuserExcludedFodlers = new ArrayList();
        if (!StringUtils.isEmpty((Object)mailexcludedFolderPaths)) {
            mailuserExcludedFodlers = this.getUserExclusionFolders(cloudId, backupPolicyElement, mailexcludedFolderPaths);
        }
        OfficeBackupPolicy backupPolicy = new OfficeBackupPolicy();
        BeanUtils.copyProperties((Object)backupPolicyElement, (Object)backupPolicy);
        backupPolicy.setPolicyName(backupPolicyElement.getPolicygroupName());
        backupPolicy.setOdBackupFolders(new ArrayList());
        backupPolicy.getOdBackupFolders().addAll(odbackupFolders);
        backupPolicy.setMailBackupFolders(new ArrayList());
        backupPolicy.getMailBackupFolders().addAll(mailbackupFolders);
        backupPolicy.setOdSchedules(new ArrayList());
        backupPolicy.getOdSchedules().addAll(odschedules);
        backupPolicy.setMailSchedules(new ArrayList());
        backupPolicy.getMailSchedules().addAll(mailschedules);
        backupPolicy.setCanAdminRestore(backupPolicyElement.isCanAdminRestore());
        backupPolicy.setOdInclusionFilter(odFilters);
        backupPolicy.setOdSearchInclusionFilter(odSearchfilters);
        backupPolicy.setMailInclusionFilter(mailFilters);
        backupPolicy.setInPlaceMailArchiveEnabled(backupPolicyElement.isInPlaceMailArchiveEnabled());
        backupPolicy.setContactsEnabled(backupPolicyElement.isContactsEnabled());
        backupPolicy.setTasksEnabled(backupPolicyElement.isTasksEnabled());
        backupPolicy.setShareEnabled(backupPolicyElement.isShareEnabled());
        backupPolicy.setAllowDownload(backupPolicyElement.isAllowDownload());
        backupPolicy.setComplexPassword(backupPolicyElement.isComplexPassword());
        backupPolicy.setShareExpireDateEnable(backupPolicyElement.isShareExpireDateEnable());
        backupPolicy.setHighSecureShareEnabled(backupPolicyElement.isHighSecureShareEnabled());
        backupPolicy.setSearchAlgoForPg(backupPolicyElement.getSearchAlgoForPg());
        backupPolicy.setEndpointUiPreferences(new ArrayList(backupPolicyElement.getEndpointUiPreferences()));
        backupPolicy.setCanAdminRestore(backupPolicyElement.isCanAdminRestore());
        if (!CollectionUtils.isEmpty(oduserExcludedFodlers)) {
            backupPolicy.setOdExcludedFolders(new ArrayList());
            backupPolicy.getOdExcludedFolders().addAll(oduserExcludedFodlers);
        }
        if (!CollectionUtils.isEmpty(mailuserExcludedFodlers)) {
            backupPolicy.setMailExcludedFolders(new ArrayList());
            backupPolicy.getMailExcludedFolders().addAll(mailuserExcludedFodlers);
        }
        if (existingOfficeBackupPolicy != null) {
            PrivacyGatewayMappingElement privacyGatewayMappingElement;
            if (StringUtils.isEmpty((Object)existingOfficeBackupPolicy.getOdPrivacyGateways())) {
                existingOfficeBackupPolicy.setOdPrivacyGateways(new ArrayList());
            } else {
                privacyGatewayMappingElement = new PrivacyGatewayMappingElement();
                for (PrivacyGateway pb : existingOfficeBackupPolicy.getOdPrivacyGateways()) {
                    if (pb == null || StringUtils.isEmpty((Object)pb.getGatewayName())) continue;
                    existingPrivacyGateways.add(pb.getGatewayName());
                }
                privacyGatewayMappingElement.setPrivacyGatewayNames(existingPrivacyGateways);
                existingOfficeBackupPolicyElement.setOdPrivacyGatewayMappingElement(privacyGatewayMappingElement);
            }
            if (StringUtils.isEmpty((Object)existingOfficeBackupPolicy.getMailPrivacyGateways())) {
                existingOfficeBackupPolicy.setMailPrivacyGateways(new ArrayList());
            } else {
                privacyGatewayMappingElement = new PrivacyGatewayMappingElement();
                for (PrivacyGateway pb : existingOfficeBackupPolicy.getMailPrivacyGateways()) {
                    if (pb == null || StringUtils.isEmpty((Object)pb.getGatewayName())) continue;
                    existingPrivacyGateways.add(pb.getGatewayName());
                }
                privacyGatewayMappingElement.setPrivacyGatewayNames(existingPrivacyGateways);
                existingOfficeBackupPolicyElement.setMailPrivacyGatewayMappingElement(privacyGatewayMappingElement);
            }
            OfficeBackupPolicyElement tempOfficeBackupPolicyElement = new OfficeBackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)tempOfficeBackupPolicyElement);
            tempOfficeBackupPolicyElement.setOdBackupFolderPaths(odbackupFolderPaths);
            if (!StringUtils.isEmpty((Object)backupPolicy.getOdExcludedFolders())) {
                tempOfficeBackupPolicyElement.setExcludedOdFolderpaths(backupPolicy.getOdExcludedFolders().stream().filter(folder -> Objects.nonNull(folder.getFolderPath())).map(folder -> folder.getFolderPath()).collect(Collectors.toList()));
            }
            if (!StringUtils.isEmpty(existingOdBackupFolderPath)) {
                existingOfficeBackupPolicyElement.setOdBackupFolderPaths(existingOdBackupFolderPath);
            }
            if (!StringUtils.isEmpty(existingOdExcludedFolderPath)) {
                existingOfficeBackupPolicyElement.setExcludedOdFolderpaths(existingOdExcludedFolderPath);
            }
            tempOfficeBackupPolicyElement.setOdBackupFolderPaths(odbackupFolderPaths);
            if (!StringUtils.isEmpty((Object)backupPolicy.getOdExcludedFolders())) {
                tempOfficeBackupPolicyElement.setExcludedOdFolderpaths(backupPolicy.getOdExcludedFolders().stream().filter(folder -> Objects.nonNull(folder.getFolderPath())).map(folder -> folder.getFolderPath()).collect(Collectors.toList()));
            }
            if (!StringUtils.isEmpty(existingOdBackupFolderPath)) {
                existingOfficeBackupPolicyElement.setOdBackupFolderPaths(existingOdBackupFolderPath);
            }
            if (!StringUtils.isEmpty(existingOdExcludedFolderPath)) {
                existingOfficeBackupPolicyElement.setExcludedOdFolderpaths(existingOdExcludedFolderPath);
            }
            tempOfficeBackupPolicyElement.setOdPrivacyGatewayMappingElement(backupPolicyElement.getOdPrivacyGatewayMappingElement());
            tempOfficeBackupPolicyElement.setOdScheduleNames(odscheduleNames);
            tempOfficeBackupPolicyElement.setMailBackupFolderPaths(mailbackupFolderPaths);
            if (!StringUtils.isEmpty((Object)backupPolicy.getMailExcludedFolders())) {
                tempOfficeBackupPolicyElement.setExcludedMailFolderpaths(backupPolicy.getMailExcludedFolders().stream().filter(folder -> Objects.nonNull(folder.getFolderPath())).map(folder -> folder.getFolderPath()).collect(Collectors.toList()));
            }
            if (!StringUtils.isEmpty(existingMailBackupFolderPath)) {
                existingOfficeBackupPolicyElement.setMailBackupFolderPaths(existingMailBackupFolderPath);
            }
            if (!StringUtils.isEmpty(existingMailExcludedFolderPath)) {
                existingOfficeBackupPolicyElement.setExcludedMailFolderpaths(existingMailExcludedFolderPath);
            }
            tempOfficeBackupPolicyElement.setMailBackupFolderPaths(mailbackupFolderPaths);
            if (!StringUtils.isEmpty((Object)backupPolicy.getMailExcludedFolders())) {
                tempOfficeBackupPolicyElement.setExcludedMailFolderpaths(backupPolicy.getMailExcludedFolders().stream().filter(folder -> Objects.nonNull(folder.getFolderPath())).map(folder -> folder.getFolderPath()).collect(Collectors.toList()));
            }
            if (!StringUtils.isEmpty(existingMailBackupFolderPath)) {
                existingOfficeBackupPolicyElement.setMailBackupFolderPaths(existingMailBackupFolderPath);
            }
            if (!StringUtils.isEmpty(existingMailExcludedFolderPath)) {
                existingOfficeBackupPolicyElement.setExcludedMailFolderpaths(existingMailExcludedFolderPath);
            }
            tempOfficeBackupPolicyElement.setMailPrivacyGatewayMappingElement(backupPolicyElement.getMailPrivacyGatewayMappingElement());
            tempOfficeBackupPolicyElement.setMailScheduleNames(mailscheduleNames);
            OfficeBackupPolicyDiffFinder backupPolicyDiffFinder = new OfficeBackupPolicyDiffFinder();
            changedFields = backupPolicyDiffFinder.findDiff(existingOfficeBackupPolicyElement, tempOfficeBackupPolicyElement);
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (existingOfficeBackupPolicy != null) {
            ObjectId id = existingOfficeBackupPolicy.getId();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)existingOfficeBackupPolicy);
            existingOfficeBackupPolicy.setId(id);
            existingOfficeBackupPolicy.getOdSchedules().clear();
            existingOfficeBackupPolicy.getOdSchedules().addAll(odschedules);
            existingOfficeBackupPolicy.getMailSchedules().clear();
            existingOfficeBackupPolicy.getMailSchedules().addAll(mailschedules);
            existingOfficeBackupPolicy.getOdBackupFolders().clear();
            existingOfficeBackupPolicy.getOdBackupFolders().addAll(odbackupFolders);
            if (!CollectionUtils.isEmpty(oduserExcludedFodlers)) {
                existingOfficeBackupPolicy.getOdExcludedFolders().clear();
                existingOfficeBackupPolicy.getOdExcludedFolders().addAll(oduserExcludedFodlers);
            }
            existingOfficeBackupPolicy.getMailBackupFolders().clear();
            existingOfficeBackupPolicy.getMailBackupFolders().addAll(mailbackupFolders);
            if (!CollectionUtils.isEmpty(mailuserExcludedFodlers)) {
                existingOfficeBackupPolicy.getMailExcludedFolders().clear();
                existingOfficeBackupPolicy.getMailExcludedFolders().addAll(mailuserExcludedFodlers);
            }
            existingOfficeBackupPolicy.setLastModifiedTimestamp(currentTimeMillis);
            this.setOdPrivacyGateWayElements(cloudId, cloudName, existingOfficeBackupPolicy, backupPolicyElement.getOdPrivacyGatewayMappingElement());
            this.setMailPrivacyGateWayElements(cloudId, cloudName, existingOfficeBackupPolicy, backupPolicyElement.getMailPrivacyGatewayMappingElement());
            existingOfficeBackupPolicy.setEndpointUiPreferences(new ArrayList(backupPolicyElement.getEndpointUiPreferences()));
            if (!StringUtils.isEmpty((Object)backupPolicyElement.getOdMsAppBluKrypt())) {
                existingOfficeBackupPolicy.setOdMsAppBluKrypt(backupPolicyElement.getOdMsAppBluKrypt());
            }
            if (!StringUtils.isEmpty((Object)backupPolicyElement.getMailMsAppBluKrypt())) {
                existingOfficeBackupPolicy.setMailMsAppBluKrypt(backupPolicyElement.getMailMsAppBluKrypt());
            }
            existingOfficeBackupPolicy.setSearchFilterType(backupPolicyElement.getSearchFilterType());
            existingOfficeBackupPolicy.setMailFilterType(backupPolicyElement.getMailFilterType());
            existingOfficeBackupPolicy.setOdFilterType(backupPolicyElement.getOdFilterType());
            existingOfficeBackupPolicy.setInPlaceMailArchiveEnabled(backupPolicyElement.isInPlaceMailArchiveEnabled());
            existingOfficeBackupPolicy.setContactsEnabled(backupPolicyElement.isContactsEnabled());
            existingOfficeBackupPolicy.setTasksEnabled(backupPolicyElement.isTasksEnabled());
            existingOfficeBackupPolicy.setCanAdminRestore(backupPolicyElement.isCanAdminRestore());
            this.oneDriveBackupPolicyDao.saveOfficeBackupPolicy(cloudId, existingOfficeBackupPolicy);
            this.userDao.updateBackupPolicyModifiedTime(cloudId, existingOfficeBackupPolicy.getPolicyName());
            if (!StringUtils.isEmpty((Object)changedFields)) {
                this.saveStatisticToDatabase(cloudId, cloudName, " modified backup policy " + backupPolicyElement.getPolicygroupName() + ". The changed fields are " + changedFields, userName, "", PCActionTypes.BACKUP_POLICY_UPDATE.getActionTypeValue());
            }
        } else {
            backupPolicy.setLastModifiedTimestamp(currentTimeMillis);
            this.setOdPrivacyGateWayElements(cloudId, cloudName, backupPolicy, backupPolicyElement.getOdPrivacyGatewayMappingElement());
            this.setMailPrivacyGateWayElements(cloudId, cloudName, backupPolicy, backupPolicyElement.getMailPrivacyGatewayMappingElement());
            if (!StringUtils.isEmpty((Object)backupPolicyElement.getOdMsAppBluKrypt())) {
                backupPolicy.setOdMsAppBluKrypt(backupPolicyElement.getOdMsAppBluKrypt());
            }
            if (!StringUtils.isEmpty((Object)backupPolicyElement.getMailMsAppBluKrypt())) {
                backupPolicy.setMailMsAppBluKrypt(backupPolicyElement.getMailMsAppBluKrypt());
            }
            backupPolicy.setSearchFilterType(backupPolicyElement.getSearchFilterType());
            backupPolicy.setMailFilterType(backupPolicyElement.getMailFilterType());
            backupPolicy.setOdFilterType(backupPolicyElement.getOdFilterType());
            backupPolicy.setInPlaceMailArchiveEnabled(backupPolicyElement.isInPlaceMailArchiveEnabled());
            backupPolicy.setInPlaceMailArchiveEnabled(backupPolicyElement.isInPlaceMailArchiveEnabled());
            backupPolicy.setContactsEnabled(backupPolicyElement.isContactsEnabled());
            backupPolicy.setTasksEnabled(backupPolicyElement.isTasksEnabled());
            backupPolicy.setCanAdminRestore(backupPolicyElement.isCanAdminRestore());
            this.oneDriveBackupPolicyDao.saveOfficeBackupPolicy(cloudId, backupPolicy);
            this.saveStatisticToDatabase(cloudId, cloudName, "created backup policy", userName, backupPolicyElement.getPolicygroupName(), PCActionTypes.BACKUP_POLICY_CREATE.getActionTypeValue());
        }
        if (!CollectionUtils.isEmpty(existingOdBackFoldersList)) {
            this.backupFoldersDao.deleteBackupFoldersForPolicyId(cloudId, cloudName, existingOdBackFoldersList);
        }
        if (!CollectionUtils.isEmpty(existingMailBackFoldersList)) {
            this.backupFoldersDao.deleteBackupFoldersForPolicyId(cloudId, cloudName, existingMailBackFoldersList);
        }
    }

    private ArrayList<InclusionFilter> getFiltersbyName(int cloudId, String cloudName, List<String> filterNames) {
        ArrayList<InclusionFilter> inclusionFilters = new ArrayList<InclusionFilter>();
        for (String filterName : filterNames) {
            InclusionFilter inclusionFilter = this.inclusionFilterDao.getInclusionFilter(cloudId, cloudName, filterName);
            if (inclusionFilter == null) continue;
            inclusionFilters.add(inclusionFilter);
        }
        return inclusionFilters;
    }

    private List<BackupFolders> getBackupFolders(int cloudId, String cloudName, OfficeBackupPolicyElement backupPolicyElement, List<String> backupFolderPaths) {
        ArrayList<BackupFolders> backupFolders = new ArrayList<BackupFolders>();
        for (String backupFolderPath : backupFolderPaths) {
            BackupFolders backupFoldersObj = this.backupFoldersDao.getBackupFolders(cloudId, cloudName, backupFolderPath);
            if (backupFoldersObj == null) {
                backupFoldersObj = new BackupFolders();
                backupFoldersObj.setFolderPath(backupFolderPath);
                backupFoldersObj.setOs(backupPolicyElement.getOsType());
                this.backupFoldersDao.saveBackupFolders(cloudId, cloudName, backupFoldersObj);
            }
            backupFolders.add(backupFoldersObj);
        }
        return backupFolders;
    }

    private List<ExcludedFolders> getUserExclusionFolders(int cloudId, OfficeBackupPolicyElement backupPolicyElement, List<String> userExcludedFoldersPath) {
        ArrayList<ExcludedFolders> userExcludedFoldersList = new ArrayList<ExcludedFolders>();
        for (String backupFolderPath : userExcludedFoldersPath) {
            ExcludedFolders excludedFolders = this.excludedFoldersDao.getExcludedFoldersByPath(cloudId, backupFolderPath);
            if (excludedFolders == null || StringUtils.isEmpty((Object)excludedFolders.getFolderPath())) {
                excludedFolders = new ExcludedFolders();
                excludedFolders.setFolderPath(backupFolderPath);
                this.excludedFoldersDao.saveExcludedFolders(cloudId, excludedFolders);
            }
            userExcludedFoldersList.add(excludedFolders);
        }
        return userExcludedFoldersList;
    }

    private List<CalloutScript> getCalloutScripts(int cloudId, String cloudName, OfficeBackupPolicyElement backupPolicyElement, List<String> calloutScripts) {
        ArrayList<CalloutScript> calloutScripts1 = new ArrayList<CalloutScript>();
        for (String calloutscriptstr : calloutScripts) {
            CalloutScript calloutScript;
            String[] stringList = calloutscriptstr.split("\\|");
            List<String> argsList = null;
            if (stringList.length > 2) {
                argsList = Arrays.asList(stringList[2].split(","));
            }
            if ((calloutScript = this.calloutScriptDao.getCalloutScript(cloudId, cloudName, stringList[0], argsList)) == null) {
                calloutScript = new CalloutScript();
                calloutScript.setScriptName(stringList[0]);
            }
            calloutScript.setScriptType(stringList[1]);
            calloutScript.setScriptArgs(argsList);
            this.calloutScriptDao.saveCalloutScript(cloudId, cloudName, calloutScript);
            calloutScripts1.add(calloutScript);
        }
        return calloutScripts1;
    }

    @Override
    public OfficeBackupPolicyElement getBackupPolicy(int cloudId, String cloudName, String policyName) {
        OfficeBackupPolicy backupPolicy = this.oneDriveBackupPolicyDao.getOfficeBackupPolicy(cloudId, policyName);
        return this.getOfficeBackupPolicyElement(cloudId, backupPolicy);
    }

    @Override
    public List<OfficeBackupPolicyElement> getAllBackupPolicies(int cloudId, String cloudName) {
        List backupPolicyList = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloudId);
        ArrayList<OfficeBackupPolicyElement> elements = new ArrayList<OfficeBackupPolicyElement>();
        for (OfficeBackupPolicy backupPolicy : backupPolicyList) {
            OfficeBackupPolicyElement element = this.getOfficeBackupPolicyElement(cloudId, backupPolicy);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public OfficeBackupPolicyElement getBackupPolicyForDevice(int cloudId, String cloudName, String deviceUUID) {
        return null;
    }

    private OfficeBackupPolicyElement getOfficeBackupPolicyElement(int cloudId, OfficeBackupPolicy backupPolicy) {
        BackupFolderElement backupFolderElement;
        OfficeBackupPolicyElement element = null;
        ArrayList<String> odfolderPaths = new ArrayList<String>();
        ArrayList<String> mailfolderPaths = new ArrayList<String>();
        ArrayList<String> oduserExcludedFolderPaths = new ArrayList<String>();
        ArrayList<String> mailuserExcludedFolderPaths = new ArrayList<String>();
        ArrayList<String> odScheduleNames = new ArrayList<String>();
        ArrayList<String> mailScheduleNames = new ArrayList<String>();
        ArrayList calloutScriptStrs = new ArrayList();
        if (backupPolicy == null) {
            return null;
        }
        for (Schedule schedule : backupPolicy.getOdSchedules()) {
            odScheduleNames.add(schedule.getScheduleName());
        }
        for (Schedule schedule : backupPolicy.getMailSchedules()) {
            mailScheduleNames.add(schedule.getScheduleName());
        }
        for (BackupFolders backupFolder : backupPolicy.getOdBackupFolders()) {
            backupFolderElement = new BackupFolderElement();
            if (backupFolder == null) continue;
            backupFolderElement.setFolderPath(backupFolder.getFolderPath());
            backupFolderElement.setOsType(backupFolder.getOs());
            odfolderPaths.add(backupFolder.getFolderPath());
        }
        for (BackupFolders backupFolder : backupPolicy.getMailBackupFolders()) {
            backupFolderElement = new BackupFolderElement();
            if (backupFolder == null) continue;
            backupFolderElement.setFolderPath(backupFolder.getFolderPath());
            backupFolderElement.setOsType(backupFolder.getOs());
            mailfolderPaths.add(backupFolder.getFolderPath());
        }
        if (backupPolicy != null) {
            List mailsearchFlterNames;
            ArrayList mailsearchFilters;
            ArrayList mailfilters;
            List mailfilterNames;
            List searchFlterNames;
            ArrayList searchFilters;
            ExcludedFolderElement userExcludedFolderElement;
            element = new OfficeBackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setSearchFilterType(backupPolicy.getSearchFilterType());
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setOdBackupFolderPaths(new ArrayList());
            element.getOdBackupFolderPaths().addAll(odfolderPaths);
            element.setMailBackupFolderPaths(new ArrayList());
            element.getMailBackupFolderPaths().addAll(mailfolderPaths);
            if (!StringUtils.isEmpty((Object)backupPolicy.getOdExcludedFolders())) {
                for (ExcludedFolders userExcludedFolders : backupPolicy.getOdExcludedFolders()) {
                    userExcludedFolderElement = new ExcludedFolderElement();
                    if (userExcludedFolders == null) continue;
                    userExcludedFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                    oduserExcludedFolderPaths.add(userExcludedFolders.getFolderPath());
                }
                if (!oduserExcludedFolderPaths.isEmpty()) {
                    element.setExcludedOdFolderpaths(oduserExcludedFolderPaths);
                }
            }
            if (!StringUtils.isEmpty((Object)backupPolicy.getMailExcludedFolders())) {
                for (ExcludedFolders userExcludedFolders : backupPolicy.getMailExcludedFolders()) {
                    userExcludedFolderElement = new ExcludedFolderElement();
                    if (userExcludedFolders == null) continue;
                    userExcludedFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                    mailuserExcludedFolderPaths.add(userExcludedFolders.getFolderPath());
                }
                if (!mailuserExcludedFolderPaths.isEmpty()) {
                    element.setExcludedMailFolderpaths(mailuserExcludedFolderPaths);
                }
            }
            element.setCalloutScripts(calloutScriptStrs);
            ArrayList filters = backupPolicy.getOdInclusionFilter();
            List filterNames = filters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterNames)) {
                element.setOdFilterInclusionName(filterNames);
            }
            if (!CollectionUtils.isEmpty((Collection)(searchFilters = backupPolicy.getOdSearchInclusionFilter())) && !CollectionUtils.isEmpty(searchFlterNames = searchFilters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList()))) {
                element.setSearchFilterInclusionName(searchFlterNames);
            }
            if (!CollectionUtils.isEmpty(mailfilterNames = (mailfilters = backupPolicy.getMailInclusionFilter()).stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList()))) {
                element.setMailFilterInclusionName(mailfilterNames);
            }
            if (!CollectionUtils.isEmpty((Collection)(mailsearchFilters = backupPolicy.getMailSearchInclusionFilter())) && !CollectionUtils.isEmpty(mailsearchFlterNames = mailsearchFilters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList()))) {
                element.setSearchFilterInclusionName(mailsearchFlterNames);
            }
            element.setOdScheduleNames(new ArrayList());
            element.getOdScheduleNames().addAll(odScheduleNames);
            element.setMailScheduleNames(new ArrayList());
            element.getMailScheduleNames().addAll(mailScheduleNames);
            element.setEndpointUiPreferences((List)backupPolicy.getEndpointUiPreferences());
            ArrayList list = backupPolicy.getOdPrivacyGateways();
            PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setOdPrivacyGatewayMappingElement(mappingElement);
            list = backupPolicy.getMailPrivacyGateways();
            mappingElement = new PrivacyGatewayMappingElement();
            pgList = new ArrayList();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setMailPrivacyGatewayMappingElement(mappingElement);
            element.setSearchAlgoForPg(backupPolicy.getSearchAlgoForPg());
            element.setContentIndexEnabled(backupPolicy.isContentIndexEnabled());
            element.setCanAdminRestore(backupPolicy.isCanAdminRestore());
        }
        element.setMailFilterType(backupPolicy.getMailFilterType());
        element.setOdFilterType(backupPolicy.getOdFilterType());
        logger.debug(element.getOdFilterType() + "...filt..." + element.getMailFilterType() + "...content index enabled ... " + backupPolicy.isContentIndexEnabled());
        return element;
    }

    private OfficeBackupPolicyElement loadAllOfficeBackupPolicyElements(int cloudId, OfficeBackupPolicy backupPolicy) {
        OfficeBackupPolicyElement element = null;
        ArrayList<String> odscheduleNames = new ArrayList<String>();
        ArrayList<String> mailscheduleNames = new ArrayList<String>();
        if (backupPolicy == null) {
            return null;
        }
        for (Schedule schedule : backupPolicy.getOdSchedules()) {
            odscheduleNames.add(schedule.getScheduleName());
        }
        for (Schedule schedule : backupPolicy.getMailSchedules()) {
            mailscheduleNames.add(schedule.getScheduleName());
        }
        if (backupPolicy != null) {
            element = new OfficeBackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setOdScheduleNames(new ArrayList());
            element.getOdScheduleNames().addAll(odscheduleNames);
            element.setMailScheduleNames(new ArrayList());
            element.getMailScheduleNames().addAll(mailscheduleNames);
        }
        return element;
    }

    private void setOdPrivacyGateWayElements(int cloudId, String cloudName, OfficeBackupPolicy backupPolicy, PrivacyGatewayMappingElement privacyGatewayMappingElement) {
        List list = this.privacyGateWayDao.getAllGateways(cloudId);
        backupPolicy.setOdPrivacyGateways(new ArrayList());
        List pgList = privacyGatewayMappingElement.getPrivacyGatewayNames();
        for (String pgname : pgList) {
            PrivacyGateway gateway = this.getPrivacyGateWay(list, pgname);
            backupPolicy.getOdPrivacyGateways().add(gateway);
        }
    }

    private void setMailPrivacyGateWayElements(int cloudId, String cloudName, OfficeBackupPolicy backupPolicy, PrivacyGatewayMappingElement privacyGatewayMappingElement) {
        List list = this.privacyGateWayDao.getAllGateways(cloudId);
        backupPolicy.setMailPrivacyGateways(new ArrayList());
        List pgList = privacyGatewayMappingElement.getPrivacyGatewayNames();
        for (String pgname : pgList) {
            PrivacyGateway gateway = this.getPrivacyGateWay(list, pgname);
            backupPolicy.getMailPrivacyGateways().add(gateway);
        }
    }

    private PrivacyGateway getPrivacyGateWay(List<PrivacyGateway> pgList, String gateWayName) {
        PrivacyGateway privacyGateway = null;
        for (PrivacyGateway gateway : pgList) {
            if (!gateway.getGatewayName().equals(gateWayName)) continue;
            privacyGateway = gateway;
            break;
        }
        return privacyGateway;
    }

    private List<BackupFolderElement> getOdBackupFolderElements(OfficeBackupPolicy backupPolicy) {
        List backupFolders = backupPolicy.getOdBackupFolders();
        ArrayList<BackupFolderElement> backupFolderElements = new ArrayList<BackupFolderElement>();
        for (BackupFolders folders : backupFolders) {
            BackupFolderElement backupFolderElement = new BackupFolderElement();
            backupFolderElement.setFolderPath(folders.getFolderPath());
            backupFolderElement.setOsType(folders.getOs());
            backupFolderElements.add(backupFolderElement);
        }
        return backupFolderElements;
    }

    private List<BluSyncScheduleElement> getOdScheduleElements(OfficeBackupPolicy backupPolicy) {
        List schedules = backupPolicy.getOdSchedules();
        ArrayList<BluSyncScheduleElement> scheduleElements = new ArrayList<BluSyncScheduleElement>();
        for (Schedule schedule : schedules) {
            BluSyncScheduleElement scheduleElement = new BluSyncScheduleElement();
            BeanUtils.copyProperties((Object)schedule, (Object)scheduleElement);
            List<ScheduleDaysArrayElement> arrayElements = this.getScheduleDays(schedule, scheduleElement);
            scheduleElement.setDayArray(arrayElements);
            scheduleElement.setBackupType(schedule.getBackupType());
            scheduleElements.add(scheduleElement);
        }
        return scheduleElements;
    }

    private List<ScheduleDaysArrayElement> getScheduleDays(Schedule schedule, BluSyncScheduleElement scheduleElement) {
        ArrayList<ScheduleDaysArrayElement> scheduleDaysArrayElements = new ArrayList<ScheduleDaysArrayElement>();
        for (Integer dayArray : schedule.getDayArray()) {
            ScheduleDaysArrayElement daysArrayElement = new ScheduleDaysArrayElement();
            daysArrayElement.setDay(dayArray);
            scheduleDaysArrayElements.add(daysArrayElement);
        }
        return scheduleDaysArrayElements;
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = this.auditHistoryDefaultValue(action, actionByUser, actionType);
        audit.setActionOnObject(actionOnUser);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public List<String> getAllBackupPolicyNames(int cloudId, String cloudName) {
        List backupPolicyList = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloudId);
        return backupPolicyList.stream().filter(policy -> !StringUtils.isEmpty((Object)policy.getPolicyName())).sorted(Comparator.comparing(OfficeBackupPolicy::getPolicyName)).map(policy -> policy.getPolicyName()).collect(Collectors.toList());
    }

    private void saveStatisticToDatabase(int cloudId, String action, String actionByUser, int actionType) {
        AuditHistory audit = this.auditHistoryDefaultValue(action, actionByUser, actionType);
        audit.setActionOnObject("");
        this.auditHistoryDao.saveAuditHistory(cloudId, audit);
    }

    private AuditHistory auditHistoryDefaultValue(String action, String actionByUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        return audit;
    }

    @Override
    public List<OfficeBackupPolicyElement> loadAllBackupPolicies(int cloudId) {
        List backupPolicyList = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloudId);
        ArrayList<OfficeBackupPolicyElement> elements = new ArrayList<OfficeBackupPolicyElement>();
        for (OfficeBackupPolicy backupPolicy : backupPolicyList) {
            OfficeBackupPolicyElement element = this.loadAllBackupPolicyElements(cloudId, backupPolicy);
            element.setMappedUserCount(Long.toString(this.userDao.getODBBackupPolicyMappedUserCountbyPolicyName(cloudId, backupPolicy.getPolicyName())));
            elements.add(element);
        }
        logger.debug("... total no of policies .." + elements.size());
        return elements;
    }

    @Override
    public List<OfficeBackupPolicyElement> getAllOfficePoliciesWithPagination(int cloudId, int pageNu) {
        List backupPolicyList = this.oneDriveBackupPolicyDao.getAllOfficePoliciesWithPagination(cloudId, pageNu);
        ArrayList<OfficeBackupPolicyElement> elements = new ArrayList<OfficeBackupPolicyElement>();
        for (OfficeBackupPolicy backupPolicy : backupPolicyList) {
            OfficeBackupPolicyElement element = this.loadAllBackupPolicyElements(cloudId, backupPolicy);
            element.setMappedUserCount(Long.toString(this.userDao.getODBBackupPolicyMappedUserCountbyPolicyName(cloudId, backupPolicy.getPolicyName())));
            elements.add(element);
        }
        logger.debug("... total no of policies .." + elements.size());
        return elements;
    }

    @Override
    public long getOfficeBkpPoliciesCount(int cloudId) {
        return this.oneDriveBackupPolicyDao.getOfficeBkpPoliciesCount(cloudId);
    }

    private OfficeBackupPolicyElement loadAllBackupPolicyElements(int cloudId, OfficeBackupPolicy backupPolicy) {
        OfficeBackupPolicyElement element = null;
        ArrayList<String> odscheduleNames = new ArrayList<String>();
        ArrayList<String> mailscheduleNames = new ArrayList<String>();
        if (backupPolicy == null) {
            return null;
        }
        if (!CollectionUtils.isEmpty((Collection)backupPolicy.getOdSchedules())) {
            for (Schedule schedule : backupPolicy.getOdSchedules()) {
                odscheduleNames.add(schedule.getScheduleName());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)backupPolicy.getMailSchedules())) {
            for (Schedule schedule : backupPolicy.getMailSchedules()) {
                mailscheduleNames.add(schedule.getScheduleName());
            }
        }
        if (backupPolicy != null) {
            element = new OfficeBackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setOdScheduleNames(new ArrayList());
            element.getOdScheduleNames().addAll(odscheduleNames);
            element.setMailScheduleNames(new ArrayList());
            element.getMailScheduleNames().addAll(mailscheduleNames);
        }
        return element;
    }

    @Override
    public EditUserBackupPolicyMappingElement getBackupPolicyElements(int cloudId, List<String> userNames, User userObj) {
        EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = new EditUserBackupPolicyMappingElement();
        List userList = this.userDao.getAllUsersForNames(cloudId, userNames);
        ArrayList<UserBackupPolicyMappingElement> elements = new ArrayList<UserBackupPolicyMappingElement>();
        for (User user : userList) {
            UserBackupPolicyMappingElement element = new UserBackupPolicyMappingElement();
            element.setBackupPolicyName(user.getOdbPolicyName());
            element.setOdbPolicyName(user.getOdbPolicyName());
            String userName = user.getUserName();
            element.setUserName(userName);
            elements.add(element);
        }
        List policyNamesList = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloudId).stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(policyNamesList)) {
            policyNamesList = new ArrayList();
        }
        editUserBackupPolicyMappingElement.setUserBackupPolicyMappingElements(elements);
        editUserBackupPolicyMappingElement.setExistingPolicies(policyNamesList);
        return editUserBackupPolicyMappingElement;
    }

    @Override
    public List<OfficeBackupPolicyElement> getAllOfficePoliciesWithPagination(int cloudId, List<String> policyNames, int skipValue) {
        List backupPolicyList = this.oneDriveBackupPolicyDao.getAllOfficePoliciesWithPagination(cloudId, policyNames, skipValue);
        ArrayList<OfficeBackupPolicyElement> elements = new ArrayList<OfficeBackupPolicyElement>();
        for (OfficeBackupPolicy backupPolicy : backupPolicyList) {
            OfficeBackupPolicyElement element = this.loadAllBackupPolicyElements(cloudId, backupPolicy);
            element.setMappedUserCount(Long.toString(this.userDao.getODBBackupPolicyMappedUserCountbyPolicyName(cloudId, backupPolicy.getPolicyName())));
            elements.add(element);
        }
        logger.debug("... total no of policies .." + elements.size());
        return elements;
    }

    @Override
    public long getOfficeBkpPoliciesCount(int cloudId, List<String> policyNames) {
        if (CollectionUtils.isEmpty(policyNames)) {
            return this.oneDriveBackupPolicyDao.getOfficeBkpPoliciesCount(cloudId);
        }
        return this.oneDriveBackupPolicyDao.getOfficeBkpPoliciesCount(cloudId, policyNames);
    }
}

