/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.NetworkThrottlingService;
import com.parablu.paracloud.element.NetworkThrottlingElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.NetworkThrottlingDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.NetworkThrottling;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NetworkThrottlingServiceImpl
implements NetworkThrottlingService {
    @Resource
    private NetworkThrottlingDao networkThrottlingDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private BackupPolicyDao backupPolicyDao;
    @Resource
    private UserDao userDao;

    @Override
    public void saveNetworkThrottling(int cloudId, String cloudName, NetworkThrottling networkThrottling, String userName) {
        NetworkThrottling existingNetworkThrottling = this.networkThrottlingDao.getNetworkThrottling(cloudId, cloudName, networkThrottling.getNetworkThrottlingName());
        if (existingNetworkThrottling != null) {
            ObjectId id = existingNetworkThrottling.getId();
            BeanUtils.copyProperties((Object)networkThrottling, (Object)existingNetworkThrottling);
            existingNetworkThrottling.setUploadSpeed(networkThrottling.getUploadSpeed().longValue());
            existingNetworkThrottling.setDownloadSpeed(networkThrottling.getDownloadSpeed().longValue());
            existingNetworkThrottling.setId(id);
            this.networkThrottlingDao.saveNetworkThrottling(cloudId, cloudName, existingNetworkThrottling);
            List backupPolicyList = this.backupPolicyDao.getAllBackupPolicies(cloudId);
            List<BackupPolicy> policiesAfterFilter = this.filterWithBackupPolicy(backupPolicyList, existingNetworkThrottling.getId());
            for (BackupPolicy backupPolicy : policiesAfterFilter) {
                this.userDao.updateBackupPolicyModifiedTime(cloudId, backupPolicy.getPolicyName());
            }
            this.saveStatisticToDatabase(cloudId, cloudName, "modifed network throttling", userName, existingNetworkThrottling.getNetworkThrottlingName());
        } else {
            this.networkThrottlingDao.saveNetworkThrottling(cloudId, cloudName, networkThrottling);
            this.saveStatisticToDatabase(cloudId, cloudName, "created network throttling", userName, networkThrottling.getNetworkThrottlingName());
        }
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public NetworkThrottlingElement getNetworkThrottling(int cloudId, String cloudName, String networkThrottlingName) {
        NetworkThrottling networkThrottling = this.networkThrottlingDao.getNetworkThrottling(cloudId, cloudName, networkThrottlingName);
        return this.getNetworkThrottlingElement(networkThrottling);
    }

    private NetworkThrottlingElement getNetworkThrottlingElement(NetworkThrottling networkThrottling) {
        NetworkThrottlingElement element = null;
        if (networkThrottling != null) {
            element = new NetworkThrottlingElement();
            element.setNetworkThrottlingName(networkThrottling.getNetworkThrottlingName());
            element.setEndTime(String.valueOf(networkThrottling.getEndTime()));
            element.setUploadSpeed(networkThrottling.getUploadSpeed());
            element.setDownloadSpeed(networkThrottling.getDownloadSpeed());
            element.setStartTime(String.valueOf(networkThrottling.getStartTime()));
            element.setPrivacyGatewayName(networkThrottling.getPrivacyGatewayName());
            element.setId(networkThrottling.getId().toString());
            element.setThrottleType(networkThrottling.getThrottleType());
        }
        return element;
    }

    @Override
    public List<NetworkThrottlingElement> getAllNetworkThrottling(int cloudId, String cloudName) {
        List networkThrottlingList = this.networkThrottlingDao.getAllNetworkThrottling(cloudId, cloudName);
        ArrayList<NetworkThrottlingElement> elements = new ArrayList<NetworkThrottlingElement>();
        for (NetworkThrottling networkThrottling : networkThrottlingList) {
            NetworkThrottlingElement element = this.getNetworkThrottlingElement(networkThrottling);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<NetworkThrottlingElement> getAllNetworkThrottling(int cloudId, String cloudName, List<String> names) {
        List networkThrottlingList = this.networkThrottlingDao.getNetworkThrottlings(cloudId, cloudName, names);
        ArrayList<NetworkThrottlingElement> elements = new ArrayList<NetworkThrottlingElement>();
        for (NetworkThrottling networkThrottling : networkThrottlingList) {
            NetworkThrottlingElement element = this.getNetworkThrottlingElement(networkThrottling);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public void savePGNetworkThrottling(int cloudId, String cloudName, NetworkThrottling networkThrottling, String userName) {
        this.networkThrottlingDao.saveNetworkThrottling(cloudId, cloudName, networkThrottling);
        this.saveStatisticToDatabase(cloudId, cloudName, "created network throttling", userName, networkThrottling.getStartTime() + " - " + networkThrottling.getEndTime());
    }

    @Override
    public List<NetworkThrottlingElement> getAllNetworkThrottlingForPG(int cloudId, String cloudName, String pgName) {
        List networkThrottlingList = this.networkThrottlingDao.getNetworkThrottlingsForPG(cloudId, cloudName, pgName);
        ArrayList<NetworkThrottlingElement> elements = new ArrayList<NetworkThrottlingElement>();
        for (NetworkThrottling networkThrottling : networkThrottlingList) {
            NetworkThrottlingElement element = this.getNetworkThrottlingElement(networkThrottling);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public void deletePGNetworkThrottling(int cloudId, String cloudName, String throttleId, String userName) {
        NetworkThrottling networkThrottling = this.networkThrottlingDao.getNetworkThrottle(cloudId, cloudName, throttleId);
        String throttleName = networkThrottling.getStartTime() + " - " + networkThrottling.getEndTime();
        this.networkThrottlingDao.deleteThrottle(cloudId, cloudName, throttleId);
        this.saveStatisticToDatabase(cloudId, cloudName, "deleted network throttling", userName, throttleName);
    }

    @Override
    public List<NetworkThrottlingElement> getAllNetworkThrottlingForPGByType(int cloudId, String cloudName, String pgName, String type) {
        List networkThrottlingList = this.networkThrottlingDao.getNetworkThrottlingsByType(cloudId, cloudName, pgName, type);
        ArrayList<NetworkThrottlingElement> elements = new ArrayList<NetworkThrottlingElement>();
        for (NetworkThrottling networkThrottling : networkThrottlingList) {
            NetworkThrottlingElement element = this.getNetworkThrottlingElement(networkThrottling);
            elements.add(element);
        }
        return elements;
    }

    private List<BackupPolicy> filterWithBackupPolicy(List<BackupPolicy> backupPolicyList, ObjectId nwId) {
        ArrayList<BackupPolicy> backupPolicies = new ArrayList<BackupPolicy>();
        for (BackupPolicy backupPolicy : backupPolicyList) {
            for (NetworkThrottling networkThrottling : backupPolicy.getNetworkThrottlings()) {
                if (!networkThrottling.getId().equals((Object)nwId)) continue;
                backupPolicies.add(backupPolicy);
            }
        }
        return backupPolicies;
    }
}

