/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.DeviceBackupJobService;
import com.parablu.paracloud.element.bp.DeviceBackupJobElement;
import com.parablu.pcbd.dao.BackupBatchDao;
import com.parablu.pcbd.dao.DeviceBackupJobDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupJob;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceBackupJobServiceImpl
implements DeviceBackupJobService {
    private static Logger logger = Logger.getLogger(DeviceBackupJobServiceImpl.class);
    @Autowired
    private DeviceBackupJobDao deviceBackupJobDao;
    @Autowired
    private DeviceDao deviceDao;
    @Autowired
    private BackupBatchDao backupBatchDao;

    public void setBackupBatchDao(BackupBatchDao backupBatchDao) {
        this.backupBatchDao = backupBatchDao;
    }

    @Override
    public String registerBackupJob(DeviceBackupJobElement deviceBackupJobElement, int cloudId) {
        logger.debug((Object)"registerBackupJob(DeviceBackupJobElement deviceBackupJobElement) > BEGIN");
        DeviceBackupJob deviceBackupJob = this.getDeviceBackupJobObj(deviceBackupJobElement);
        this.deviceBackupJobDao.registerJob(deviceBackupJob, cloudId);
        logger.debug((Object)("registerBackupJob(DeviceBackupJobElement deviceBackupJobElement) > BEGIN > " + deviceBackupJob.getId().toString()));
        return deviceBackupJob.getId().toString();
    }

    @Override
    public void updateDeviceBackupJob(int cloudId, String deviceUUID, String status, String currentStep, String jobId, long endTime, long sizeOnDiskInBytes) {
        logger.debug((Object)"updateDeviceBackupJob(int cloudId, String deviceUUID, String containerName, String currentStep) > BEGIN ");
        ObjectId jobObjId = new ObjectId(jobId);
        DeviceBackupJob deviceBackupJob = this.deviceBackupJobDao.getDeviceBackupJob(cloudId, deviceUUID, jobObjId);
        deviceBackupJob.setLastUpdatedTimeStamp(Long.valueOf(System.currentTimeMillis()));
        deviceBackupJob.setCurrentStep(currentStep);
        deviceBackupJob.setStatus(status.toLowerCase());
        deviceBackupJob.setEndTime(endTime);
        deviceBackupJob.setBackupSizeOnDiskInBytes(sizeOnDiskInBytes);
        this.deviceBackupJobDao.registerJob(deviceBackupJob, cloudId);
        logger.debug((Object)"updateDeviceBackupJob(int cloudId, String deviceUUID, String containerName, String currentStep) > END ");
    }

    private DeviceBackupJob getDeviceBackupJobObj(DeviceBackupJobElement deviceBackupJobElement) {
        logger.debug((Object)"getDeviceBackupJobObj(DeviceBackupJobElement deviceBackupJobElement) > BEGIN");
        DeviceBackupJob deviceBackupJob = new DeviceBackupJob();
        deviceBackupJob.setContainerName(deviceBackupJobElement.getContainerName());
        deviceBackupJob.setContainerType(deviceBackupJobElement.getContainerType());
        deviceBackupJob.setCurrentStep(deviceBackupJobElement.getCurrentStep());
        deviceBackupJob.setDeviceUUID(deviceBackupJobElement.getDeviceUUID());
        deviceBackupJob.setEndTime(deviceBackupJobElement.getEndTime());
        deviceBackupJob.setProcessId(deviceBackupJobElement.getProcessId());
        deviceBackupJob.setStartTime(deviceBackupJobElement.getStartTime());
        deviceBackupJob.setStatus(deviceBackupJobElement.getStatus());
        deviceBackupJob.setTotalSteps(deviceBackupJobElement.getTotalSteps());
        deviceBackupJob.setBackupJobType(deviceBackupJobElement.getBackupJobType());
        deviceBackupJob.setLastUpdatedTimeStamp(Long.valueOf(System.currentTimeMillis()));
        deviceBackupJob.setBackupSizeOnDiskInBytes(deviceBackupJobElement.getBackupSizeOnDiskInBytes());
        logger.debug((Object)"getDeviceBackupJobObj(DeviceBackupJobElement deviceBackupJobElement) > BEFORE RETURN");
        return deviceBackupJob;
    }

    @Override
    public List<DeviceBackupJobElement> getAllOngoingJobs(int cloudId, String deviceUUID, int skipValue, String status) {
        logger.debug((Object)"getDeviceBackupJobObj(DeviceBackupJobElement deviceBackupJobElement) > BEGIN");
        List deviceBackupJobs = this.deviceBackupJobDao.getAllOngoingBackupJobs(cloudId, deviceUUID, skipValue, status);
        List<DeviceBackupJobElement> deviceBackupJobElemets = this.getDeviceBackupJobElementObj(deviceBackupJobs, cloudId);
        logger.debug((Object)"getDeviceBackupJobObj(DeviceBackupJobElement deviceBackupJobElement) > BEFORE RETURN");
        return deviceBackupJobElemets;
    }

    private List<DeviceBackupJobElement> getDeviceBackupJobElementObj(List<DeviceBackupJob> deviceBackupJobs, int cloudId) {
        ArrayList<DeviceBackupJobElement> backupJobElements = new ArrayList<DeviceBackupJobElement>();
        for (DeviceBackupJob deviceBackupJob : deviceBackupJobs) {
            DeviceBackupJobElement backupJobElement = new DeviceBackupJobElement();
            backupJobElement.setBackupJobType(deviceBackupJob.getBackupJobType());
            backupJobElement.setContainerName(deviceBackupJob.getContainerName());
            backupJobElement.setContainerType(deviceBackupJob.getContainerType());
            backupJobElement.setCurrentStep(deviceBackupJob.getCurrentStep());
            backupJobElement.setTotalSteps(deviceBackupJob.getTotalSteps());
            backupJobElement.setDeviceUUID(deviceBackupJob.getDeviceUUID());
            Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, null, deviceBackupJob.getDeviceUUID());
            backupJobElement.setDeviceName(device.getDeviceName());
            backupJobElement.setStartTime(deviceBackupJob.getStartTime());
            backupJobElement.setEndTime(deviceBackupJob.getEndTime());
            backupJobElement.setProcessId(deviceBackupJob.getProcessId());
            backupJobElement.setStatus(deviceBackupJob.getStatus());
            backupJobElement.setBackupSizeOnDiskInBytes(deviceBackupJob.getBackupSizeOnDiskInBytes());
            backupJobElement.setBackupSizeOnCloudInBytes(deviceBackupJob.getBackupSizeOnCloudInBytes());
            logger.debug((Object)("backupJobElement.getBackupSizeOnCloudInKB()  " + backupJobElement.getBackupSizeOnCloudInBytes()));
            backupJobElements.add(backupJobElement);
        }
        return backupJobElements;
    }

    @Override
    public Long getNoOfSuccessfulBackups(int cloudId, String cloudName) {
        return this.backupBatchDao.getNoOfSuccessfulBackups(cloudId, cloudName);
    }
}

