/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class XhtmlBaseParser
extends AbstractXmlParser
implements HtmlMarkup {
    private boolean scriptBlock;
    private boolean isLink;
    private boolean isAnchor;
    private int orderedListDepth = 0;
    private int sectionLevel;
    private boolean inVerbatim;
    private boolean inFigure;
    private final SinkEventAttributeSet decoration = new SinkEventAttributeSet();
    private Map<String, Set<String>> warnMessages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader source, Sink sink) throws ParseException {
        this.init();
        try {
            super.parse(source, sink);
        }
        finally {
            this.logWarnings();
            this.setSecondParsing(false);
            this.init();
        }
    }

    protected boolean baseStartTag(XmlPullParser parser, Sink sink) {
        boolean visited = true;
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        if (parser.getName().equals(HtmlMarkup.H2.toString())) {
            this.handleSectionStart(sink, 1, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H3.toString())) {
            this.handleSectionStart(sink, 2, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H4.toString())) {
            this.handleSectionStart(sink, 3, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H5.toString())) {
            this.handleSectionStart(sink, 4, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H6.toString())) {
            this.handleSectionStart(sink, 5, attribs);
        } else if (parser.getName().equals(HtmlMarkup.U.toString())) {
            this.decoration.addAttribute("decoration", "underline");
        } else if (parser.getName().equals(HtmlMarkup.S.toString()) || parser.getName().equals(HtmlMarkup.STRIKE.toString()) || parser.getName().equals("del")) {
            this.decoration.addAttribute("decoration", "line-through");
        } else if (parser.getName().equals(HtmlMarkup.SUB.toString())) {
            this.decoration.addAttribute("valign", "sub");
        } else if (parser.getName().equals(HtmlMarkup.SUP.toString())) {
            this.decoration.addAttribute("valign", "sup");
        } else if (parser.getName().equals(HtmlMarkup.P.toString())) {
            this.handlePStart(sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.DIV.toString())) {
            visited = this.handleDivStart(parser, attribs, sink);
        } else if (parser.getName().equals(HtmlMarkup.PRE.toString())) {
            this.handlePreStart(attribs, sink);
        } else if (parser.getName().equals(HtmlMarkup.UL.toString())) {
            sink.list(attribs);
        } else if (parser.getName().equals(HtmlMarkup.OL.toString())) {
            this.handleOLStart(parser, sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.LI.toString())) {
            this.handleLIStart(sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.DL.toString())) {
            sink.definitionList(attribs);
        } else if (parser.getName().equals(HtmlMarkup.DT.toString())) {
            sink.definitionListItem(attribs);
            sink.definedTerm(attribs);
        } else if (parser.getName().equals(HtmlMarkup.DD.toString())) {
            sink.definition(attribs);
        } else if (parser.getName().equals(HtmlMarkup.B.toString()) || parser.getName().equals(HtmlMarkup.STRONG.toString())) {
            sink.bold();
        } else if (parser.getName().equals(HtmlMarkup.I.toString()) || parser.getName().equals(HtmlMarkup.EM.toString())) {
            this.handleFigureCaptionStart(sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.CODE.toString()) || parser.getName().equals(HtmlMarkup.SAMP.toString()) || parser.getName().equals(HtmlMarkup.TT.toString())) {
            sink.monospaced();
        } else if (parser.getName().equals(HtmlMarkup.A.toString())) {
            this.handleAStart(parser, sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.TABLE.toString())) {
            this.handleTableStart(sink, attribs, parser);
        } else if (parser.getName().equals(HtmlMarkup.TR.toString())) {
            sink.tableRow(attribs);
        } else if (parser.getName().equals(HtmlMarkup.TH.toString())) {
            sink.tableHeaderCell(attribs);
        } else if (parser.getName().equals(HtmlMarkup.TD.toString())) {
            sink.tableCell(attribs);
        } else if (parser.getName().equals(HtmlMarkup.CAPTION.toString())) {
            sink.tableCaption(attribs);
        } else if (parser.getName().equals(HtmlMarkup.BR.toString())) {
            sink.lineBreak(attribs);
        } else if (parser.getName().equals(HtmlMarkup.HR.toString())) {
            sink.horizontalRule(attribs);
        } else if (parser.getName().equals(HtmlMarkup.IMG.toString())) {
            this.handleImgStart(parser, sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.SCRIPT.toString())) {
            this.handleUnknown(parser, sink, 2);
            this.scriptBlock = true;
        } else {
            visited = false;
        }
        return visited;
    }

    protected boolean baseEndTag(XmlPullParser parser, Sink sink) {
        boolean visited = true;
        if (parser.getName().equals(HtmlMarkup.P.toString())) {
            if (!this.inFigure) {
                sink.paragraph_();
            }
        } else if (parser.getName().equals(HtmlMarkup.U.toString()) || parser.getName().equals(HtmlMarkup.S.toString()) || parser.getName().equals(HtmlMarkup.STRIKE.toString()) || parser.getName().equals("del")) {
            this.decoration.removeAttribute("decoration");
        } else if (parser.getName().equals(HtmlMarkup.SUB.toString()) || parser.getName().equals(HtmlMarkup.SUP.toString())) {
            this.decoration.removeAttribute("valign");
        } else if (parser.getName().equals(HtmlMarkup.DIV.toString())) {
            if (this.inFigure) {
                sink.figure_();
                this.inFigure = false;
            } else {
                visited = false;
            }
        } else if (parser.getName().equals(HtmlMarkup.PRE.toString())) {
            this.verbatim_();
            sink.verbatim_();
        } else if (parser.getName().equals(HtmlMarkup.UL.toString())) {
            sink.list_();
        } else if (parser.getName().equals(HtmlMarkup.OL.toString())) {
            sink.numberedList_();
            --this.orderedListDepth;
        } else if (parser.getName().equals(HtmlMarkup.LI.toString())) {
            this.handleListItemEnd(sink);
        } else if (parser.getName().equals(HtmlMarkup.DL.toString())) {
            sink.definitionList_();
        } else if (parser.getName().equals(HtmlMarkup.DT.toString())) {
            sink.definedTerm_();
        } else if (parser.getName().equals(HtmlMarkup.DD.toString())) {
            sink.definition_();
            sink.definitionListItem_();
        } else if (parser.getName().equals(HtmlMarkup.B.toString()) || parser.getName().equals(HtmlMarkup.STRONG.toString())) {
            sink.bold_();
        } else if (parser.getName().equals(HtmlMarkup.I.toString()) || parser.getName().equals(HtmlMarkup.EM.toString())) {
            this.handleFigureCaptionEnd(sink);
        } else if (parser.getName().equals(HtmlMarkup.CODE.toString()) || parser.getName().equals(HtmlMarkup.SAMP.toString()) || parser.getName().equals(HtmlMarkup.TT.toString())) {
            sink.monospaced_();
        } else if (parser.getName().equals(HtmlMarkup.A.toString())) {
            this.handleAEnd(sink);
        } else if (parser.getName().equals(HtmlMarkup.TABLE.toString())) {
            sink.tableRows_();
            sink.table_();
        } else if (parser.getName().equals(HtmlMarkup.TR.toString())) {
            sink.tableRow_();
        } else if (parser.getName().equals(HtmlMarkup.TH.toString())) {
            sink.tableHeaderCell_();
        } else if (parser.getName().equals(HtmlMarkup.TD.toString())) {
            sink.tableCell_();
        } else if (parser.getName().equals(HtmlMarkup.CAPTION.toString())) {
            sink.tableCaption_();
        } else if (parser.getName().equals(HtmlMarkup.H2.toString())) {
            sink.sectionTitle1_();
        } else if (parser.getName().equals(HtmlMarkup.H3.toString())) {
            sink.sectionTitle2_();
        } else if (parser.getName().equals(HtmlMarkup.H4.toString())) {
            sink.sectionTitle3_();
        } else if (parser.getName().equals(HtmlMarkup.H5.toString())) {
            sink.sectionTitle4_();
        } else if (parser.getName().equals(HtmlMarkup.H6.toString())) {
            sink.sectionTitle5_();
        } else if (parser.getName().equals(HtmlMarkup.SCRIPT.toString())) {
            this.handleUnknown(parser, sink, 3);
            this.scriptBlock = false;
        } else {
            visited = false;
        }
        return visited;
    }

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (!this.baseStartTag(parser, sink) && this.getLog().isWarnEnabled()) {
            String position = "[" + parser.getLineNumber() + ":" + parser.getColumnNumber() + "]";
            String tag = "<" + parser.getName() + ">";
            this.getLog().warn("Unrecognized xml tag: " + tag + " at " + position);
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (!this.baseEndTag(parser, sink)) {
            // empty if block
        }
    }

    protected void handleText(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if (StringUtils.isNotEmpty(text) && !this.isScriptBlock()) {
            sink.text(text, this.decoration);
        }
    }

    protected void handleComment(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser).trim();
        if ("PB".equals(text)) {
            sink.pageBreak();
        } else {
            sink.comment(text);
        }
    }

    protected void handleCdsect(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if (this.isScriptBlock()) {
            sink.unknown("CDATA", new Object[]{new Integer(5), text}, null);
        } else {
            sink.text(text);
        }
    }

    protected void consecutiveSections(int newLevel, Sink sink) {
        this.closeOpenSections(newLevel, sink);
        this.openMissingSections(newLevel, sink);
        this.sectionLevel = newLevel;
    }

    private void closeOpenSections(int newLevel, Sink sink) {
        while (this.sectionLevel >= newLevel) {
            if (this.sectionLevel == 5) {
                sink.section5_();
            } else if (this.sectionLevel == 4) {
                sink.section4_();
            } else if (this.sectionLevel == 3) {
                sink.section3_();
            } else if (this.sectionLevel == 2) {
                sink.section2_();
            } else if (this.sectionLevel == 1) {
                sink.section1_();
            }
            --this.sectionLevel;
        }
    }

    private void openMissingSections(int newLevel, Sink sink) {
        while (this.sectionLevel < newLevel - 1) {
            ++this.sectionLevel;
            if (this.sectionLevel == 5) {
                sink.section5();
                continue;
            }
            if (this.sectionLevel == 4) {
                sink.section4();
                continue;
            }
            if (this.sectionLevel == 3) {
                sink.section3();
                continue;
            }
            if (this.sectionLevel == 2) {
                sink.section2();
                continue;
            }
            if (this.sectionLevel != 1) continue;
            sink.section1();
        }
    }

    protected int getSectionLevel() {
        return this.sectionLevel;
    }

    protected void setSectionLevel(int newLevel) {
        this.sectionLevel = newLevel;
    }

    protected void verbatim_() {
        this.inVerbatim = false;
    }

    protected void verbatim() {
        this.inVerbatim = true;
    }

    protected boolean isVerbatim() {
        return this.inVerbatim;
    }

    protected boolean isScriptBlock() {
        return this.scriptBlock;
    }

    protected String validAnchor(String id) {
        if (!DoxiaUtils.isValidId(id)) {
            String linkAnchor = DoxiaUtils.encodeId(id, true);
            String msg = "Modified invalid link: '" + id + "' to '" + linkAnchor + "'";
            this.logMessage("modifiedLink", msg);
            return linkAnchor;
        }
        return id;
    }

    protected void init() {
        super.init();
        this.scriptBlock = false;
        this.isLink = false;
        this.isAnchor = false;
        this.orderedListDepth = 0;
        this.sectionLevel = 0;
        this.inVerbatim = false;
        this.inFigure = false;
        while (this.decoration.getAttributeNames().hasMoreElements()) {
            this.decoration.removeAttribute(this.decoration.getAttributeNames().nextElement());
        }
        this.warnMessages = null;
    }

    private void handleAEnd(Sink sink) {
        if (this.isLink) {
            sink.link_();
            this.isLink = false;
        } else if (this.isAnchor) {
            sink.anchor_();
            this.isAnchor = false;
        }
    }

    private void handleAStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        String href = parser.getAttributeValue(null, HTML.Attribute.HREF.toString());
        if (href != null) {
            String hash;
            int hashIndex = href.indexOf("#");
            if (hashIndex != -1 && !DoxiaUtils.isExternalLink(href) && !DoxiaUtils.isValidId(hash = href.substring(hashIndex + 1))) {
                href = href.substring(0, hashIndex) + "#" + DoxiaUtils.encodeId(hash, true);
                String msg = "Modified invalid link: '" + hash + "' to '" + href + "'";
                this.logMessage("modifiedLink", msg);
            }
            sink.link(href, attribs);
            this.isLink = true;
        } else {
            String name = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
            if (name != null) {
                sink.anchor(this.validAnchor(name), attribs);
                this.isAnchor = true;
            } else {
                String id = parser.getAttributeValue(null, HTML.Attribute.ID.toString());
                if (id != null) {
                    sink.anchor(this.validAnchor(id), attribs);
                    this.isAnchor = true;
                }
            }
        }
    }

    private boolean handleDivStart(XmlPullParser parser, SinkEventAttributeSet attribs, Sink sink) {
        boolean visited = true;
        String divclass = parser.getAttributeValue(null, HTML.Attribute.CLASS.toString());
        if ("figure".equals(divclass)) {
            this.inFigure = true;
            SinkEventAttributeSet atts = new SinkEventAttributeSet(attribs);
            atts.removeAttribute("class");
            sink.figure(atts);
        } else {
            visited = false;
        }
        return visited;
    }

    private void handleFigureCaptionEnd(Sink sink) {
        if (this.inFigure) {
            sink.figureCaption_();
        } else {
            sink.italic_();
        }
    }

    private void handleFigureCaptionStart(Sink sink, SinkEventAttributeSet attribs) {
        if (this.inFigure) {
            sink.figureCaption(attribs);
        } else {
            sink.italic();
        }
    }

    private void handleImgStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        String src = parser.getAttributeValue(null, HTML.Attribute.SRC.toString());
        if (src != null) {
            sink.figureGraphics(src, attribs);
        }
    }

    private void handleLIStart(Sink sink, SinkEventAttributeSet attribs) {
        if (this.orderedListDepth == 0) {
            sink.listItem(attribs);
        } else {
            sink.numberedListItem(attribs);
        }
    }

    private void handleListItemEnd(Sink sink) {
        if (this.orderedListDepth == 0) {
            sink.listItem_();
        } else {
            sink.numberedListItem_();
        }
    }

    private void handleOLStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        int numbering = 0;
        String style = parser.getAttributeValue(null, HTML.Attribute.STYLE.toString());
        if (style != null) {
            if ("list-style-type: upper-alpha".equals(style)) {
                numbering = 2;
            } else if ("list-style-type: lower-alpha".equals(style)) {
                numbering = 1;
            } else if ("list-style-type: upper-roman".equals(style)) {
                numbering = 4;
            } else if ("list-style-type: lower-roman".equals(style)) {
                numbering = 3;
            } else if ("list-style-type: decimal".equals(style)) {
                numbering = 0;
            }
        }
        sink.numberedList(numbering, attribs);
        ++this.orderedListDepth;
    }

    private void handlePStart(Sink sink, SinkEventAttributeSet attribs) {
        if (!this.inFigure) {
            sink.paragraph(attribs);
        }
    }

    private void handlePreStart(SinkEventAttributeSet attribs, Sink sink) {
        this.verbatim();
        attribs.removeAttribute("decoration");
        sink.verbatim(attribs);
    }

    private void handleSectionStart(Sink sink, int level, SinkEventAttributeSet attribs) {
        this.consecutiveSections(level, sink);
        sink.section(level, attribs);
        sink.sectionTitle(level, attribs);
    }

    private void handleTableStart(Sink sink, SinkEventAttributeSet attribs, XmlPullParser parser) {
        sink.table(attribs);
        String border = parser.getAttributeValue(null, HTML.Attribute.BORDER.toString());
        boolean grid = true;
        if (border == null || "0".equals(border)) {
            grid = false;
        }
        String align = parser.getAttributeValue(null, HTML.Attribute.ALIGN.toString());
        int[] justif = new int[]{1};
        if ("center".equals(align)) {
            justif[0] = 0;
        } else if ("right".equals(align)) {
            justif[0] = 2;
        }
        sink.tableRows(justif, grid);
    }

    private void logMessage(String key, String msg) {
        Set<String> set;
        msg = "[XHTML Parser] " + msg;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(msg);
            return;
        }
        if (this.warnMessages == null) {
            this.warnMessages = new HashMap<String, Set<String>>();
        }
        if ((set = this.warnMessages.get(key)) == null) {
            set = new TreeSet<String>();
        }
        set.add(msg);
        this.warnMessages.put(key, set);
    }

    private void logWarnings() {
        if (this.getLog().isWarnEnabled() && this.warnMessages != null && !this.isSecondParsing()) {
            for (Map.Entry<String, Set<String>> entry : this.warnMessages.entrySet()) {
                for (String msg : entry.getValue()) {
                    this.getLog().warn(msg);
                }
            }
            this.warnMessages = null;
        }
    }
}

