/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.util.CollectionUtils;

public class NewVersionUtility {
    private static List<Device> devList = null;
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    private Set<String> devicesUnderProcess = new HashSet<String>();
    static AtomicInteger devcount = new AtomicInteger();

    public static void main(String[] args) throws ConfigurationException {
        ExecutorService executor = null;
        try {
            long threadSize = 3L;
            int threadSizeVal = (int)threadSize;
            executor = Executors.newFixedThreadPool(threadSizeVal);
            PropertiesConfiguration config = null;
            config = new PropertiesConfiguration(args[0]);
            String mongoIP = config.getProperty("mongoIP").toString();
            String mongoPort = config.getProperty("mongoPort").toString();
            String deviceUUIDList = "";
            if (config.getProperty("deviceUUID") != null) {
                deviceUUIDList = config.getProperty("deviceUUID").toString();
            }
            if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
                System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
                throw new ArrayIndexOutOfBoundsException();
            }
            System.out.println("mongo IP:" + mongoIP);
            MongoDatabase db = NewVersionUtility.getMongodb(mongoIP, mongoPort);
            System.out.println("connectivity success  ");
            ArrayList<String> list = new ArrayList<String>();
            MongoCollection<Document> latestdeviceBkpOverviewColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
            DistinctIterable<String> iterable = latestdeviceBkpOverviewColl.distinct("deviceUUID", String.class);
            MongoCursor cursor = iterable.iterator();
            while (cursor.hasNext()) {
                String deviceUUID = (String)cursor.next();
                list.add(deviceUUID);
            }
            cursor.close();
            Object devices = null;
            MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
            devList = NewVersionUtility.getDevicesList(list, deviceColl);
            long devSize = devList.size();
            ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
            NewVersionUtility newVersionUtility = new NewVersionUtility();
            newVersionUtility.checkThreadStatusAndStartUpload(db, executor, pool, devSize);
            int i = 0;
            while (i < threadSizeVal) {
                System.out.println(String.valueOf(devList.size()) + "...Creating thread for first time>>>>>>>>> i value::" + i);
                newVersionUtility.callUploadFiles(db, executor, pool, devSize);
                ++i;
            }
            System.out.println(".... completed ..... ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<Device> getDevicesList(List<String> list, MongoCollection deviceColl) {
        FindIterable devices;
        if (!CollectionUtils.isEmpty(list)) {
            BasicDBObject ninQuery = new BasicDBObject();
            ninQuery.append("deviceUUID", new BasicDBObject("$nin", list));
            devices = deviceColl.find(ninQuery);
        } else {
            devices = deviceColl.find();
        }
        ArrayList<Device> devList = new ArrayList<Device>();
        for (Document dev : devices) {
            Device device = new Device();
            device.setDeviceUUID(dev.getString("deviceUUID"));
            device.setDestCollection(dev.getString("destCollection"));
            device.setUserName(dev.getString("userName"));
            devList.add(device);
        }
        return devList;
    }

    private static MongoDatabase getMongodb(String mongoIP, String mongoPort) {
        String connectionUri = "mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001";
        MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
        builder.threadsAllowedToBlockForConnectionMultiplier(5000);
        builder.connectionsPerHost(1000);
        builder.minConnectionsPerHost(250);
        MongoClientURI uri = new MongoClientURI(connectionUri, builder);
        MongoClient clientObj = new MongoClient(uri);
        MongoDatabase db = clientObj.getDatabase(uri.getDatabase());
        return db;
    }

    private void callUploadFiles(MongoDatabase db, ExecutorService executor, CompletionService<String> pool, long devices) {
        Runnable uploadJob = () -> this.uploadFiles(db, executor, pool, devices);
        pool.submit(uploadJob, "");
    }

    private static void updateLatestVerSizeForDevice(MongoDatabase db, String deviceUUID, String destCollection, String userName, long devices) {
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("userName", userName));
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("folder", true));
        whereQuery.add(new BasicDBObject("present", true));
        andQuery.put("$and", whereQuery);
        ArrayList allFoldersList = new ArrayList();
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");
        String strDate = dateFormat.format(date);
        System.out.println(String.valueOf(strDate) + "$$$$getting folders..........for device ......" + deviceUUID);
        MongoCollection<Document> bkpColl = db.getCollection(destCollection);
        FindIterable<Document> files = bkpColl.find(andQuery);
        files.forEach(document -> allFoldersList.add(document));
        files = null;
        date = Calendar.getInstance().getTime();
        strDate = dateFormat.format(date);
        System.out.println(String.valueOf(strDate) + "$$$$Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
        AtomicLong latestFileSizes = new AtomicLong();
        AtomicInteger folderCount = new AtomicInteger();
        AtomicLong allFileSizes = new AtomicLong();
        boolean isFailure = false;
        try {
            allFoldersList.parallelStream().forEach(folder -> NewVersionUtility.getAllFoldersSize(deviceUUID, allFoldersList, bkpColl, latestFileSizes, folderCount, folder, userName, allFileSizes));
        }
        catch (Exception e) {
            isFailure = true;
        }
        date = Calendar.getInstance().getTime();
        strDate = dateFormat.format(date);
        System.out.println(String.valueOf(strDate) + "$$$$Total size...................................... :" + latestFileSizes.get() + " for deviceUUID " + deviceUUID);
        if (isFailure) {
            System.out.println("....failure for deviceuuid.." + deviceUUID);
        }
        if (!isFailure) {
            MongoCollection<Document> latestDeviceBkpOverviewColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
            andQuery = new BasicDBObject();
            whereQuery = new ArrayList();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            andQuery.put("$and", whereQuery);
            latestDeviceBkpOverviewColl.deleteMany(andQuery);
            Document doc = new Document();
            doc.put("deviceUUID", (Object)deviceUUID);
            doc.put("latestVersionsSize", (Object)latestFileSizes.get());
            latestDeviceBkpOverviewColl.insertOne(doc);
            MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
            Document deviceBkpOverviewInfo = (Document)deviceBkpOverviewColl.find(andQuery).first();
            System.out.println("......existing storageutilized....and update...." + deviceBkpOverviewInfo.get("storageUtilized") + "/" + allFileSizes.get());
            BasicDBObject updateFields = new BasicDBObject();
            BasicDBObject updateQuery = new BasicDBObject();
            updateFields.append("storageUtilized", allFileSizes.get());
            updateQuery.append("$set", updateFields);
            deviceBkpOverviewColl.updateOne(andQuery, updateQuery);
            devcount.incrementAndGet();
            date = Calendar.getInstance().getTime();
            strDate = dateFormat.format(date);
            long freeMemory = Runtime.getRuntime().freeMemory();
            System.out.println(String.valueOf(strDate) + "...." + freeMemory + "...." + userName + "....device" + " to update .######################.. " + deviceUUID + "...size va..." + latestFileSizes.get() + "/" + allFileSizes.get() + "....." + devcount.get() + "/" + devices);
        }
    }

    private void uploadFiles(MongoDatabase db, ExecutorService executor, CompletionService<String> pool, long devices) {
        do {
            Device device = null;
            try {
                device = this.getDeviceForProcessing();
                if (device != null) {
                    String deviceUUID = device.getDeviceUUID();
                    NewVersionUtility.updateLatestVerSizeForDevice(db, deviceUUID, device.getDestCollection(), device.getUserName(), devices);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (device == null || !StringUtils.isNotEmpty(device.getDeviceUUID())) continue;
            this.devicesUnderProcess.remove(device.getDeviceUUID());
        } while (!CollectionUtils.isEmpty(devList));
        this.callUploadFiles(db, executor, pool, devices);
    }

    private synchronized Device getDeviceForProcessing() {
        Device device = null;
        if (!CollectionUtils.isEmpty(devList)) {
            device = devList.get(0);
        }
        if (device != null) {
            if (this.devicesUnderProcess.contains(device.getDeviceUUID())) {
                devList.remove(device);
                return this.getDeviceForProcessing();
            }
            devList.remove(device);
            this.devicesUnderProcess.add(device.getDeviceUUID());
        }
        return device;
    }

    private static void getAllFoldersSize(String deviceUUID, List<Document> allFoldersList, MongoCollection bkpColl, AtomicLong latestFileSizes, AtomicInteger folderCount, Document folder, String userName, AtomicLong allFileSizes) {
        String folderName = "";
        folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
        BasicDBObject andQuery = new BasicDBObject();
        System.out.println(String.valueOf(deviceUUID) + "... processing..." + folderName);
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("userName", userName));
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("devicePath", folderName));
        whereQuery.add(new BasicDBObject("present", true));
        whereQuery.add(new BasicDBObject("folder", false));
        andQuery.put("$and", whereQuery);
        FindIterable files = bkpColl.find(andQuery);
        ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
        ArrayList allDocsList = new ArrayList();
        files.forEach(document -> allDocsList.add(document));
        for (Document document2 : allDocsList) {
            NewVersionUtility.addFilesToList(allFilesList, document2);
            if (document2.getLong("size") == null) continue;
            allFileSizes.addAndGet(document2.getLong("size"));
        }
        List<BackUpImage> list = NewVersionUtility.getFilteredBackupImageList(allFilesList);
        long folderSize = 0L;
        for (BackUpImage image : list) {
            latestFileSizes.addAndGet(image.getSize());
            folderSize += image.getSize();
        }
        allFilesList = new ArrayList();
        bkpColl = null;
        folderCount.incrementAndGet();
        System.out.println("... completed folders for device..." + deviceUUID + "...." + folderCount.get() + "/" + allFoldersList.size());
    }

    private static void addFilesToList(List<BackUpImage> allFilesList, Document document) {
        BackUpImage backUpImage = new BackUpImage();
        backUpImage.setDevicePath(document.getString("devicePath"));
        backUpImage.setFileName(document.getString("fileName"));
        backUpImage.setLastServerModifiedTime(document.getLong("lastServerModifiedTime"));
        if (!StringUtils.isEmpty(backUpImage.getDevicePath()) && !StringUtils.isEmpty(backUpImage.getFileName())) {
            backUpImage.setSize(document.getLong("size"));
            allFilesList.add(backUpImage);
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    public void checkThreadStatusAndStartUpload(final MongoDatabase db, final ExecutorService executor, final CompletionService<String> pool, final long devices) {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        System.out.println("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            System.out.println("Thread is completed so assign new task>>>>>>>>>>>");
                            NewVersionUtility.this.callUploadFiles(db, executor, pool, devices);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }
}

