/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import Utility.com.parablu.HttpClientUtil;
import Utility.com.parablu.Office365;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import com.parablu.pcbd.domain.PciAuthorizationTokenElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Future;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.util.EntityUtils;
import org.bson.Document;
import org.json.JSONObject;

public class CheckSize {
    private static final String PERSONAL_URL = "/personal/";
    private static final String BEARER = "Bearer ";
    public static final String HEADER_KEY_ACCEPT = "Accept";
    public static final String HEADER_VALUE_APPLICATION_JSON = "application/json;odata=verbose";
    public static final String HEADER_KEY_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_KEY_GATEWAY_TYPE = "gatewayType";
    private static int skipValue;
    private static TimerTask backupTimerTask;
    private static Timer timer;
    private static int count;
    int deviceuuidCount = 0;
    private static int threads;
    private static int limit;
    private static int proccessCount;

    static {
        backupTimerTask = null;
        timer = null;
        count = 0;
        proccessCount = 0;
    }

    public static void main(String[] args) throws ConfigurationException, JsonParseException, JsonMappingException, IOException {
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@139.162.40.38:27017/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " connectivity success  ");
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        String userODBID = "druva@parablu.com";
        MongoCollection<Document> tokenCollection = db.getCollection("PCI_AUTHORIZATION_TOKENS");
        MongoCollection<Document> chunkCollDB = db.getCollection("CHUNK_DETAIL");
        Document tokenDoc = (Document)tokenCollection.find().first();
        PciAuthorizationTokenElement pciAuthorizationTokenElement = new PciAuthorizationTokenElement();
        pciAuthorizationTokenElement.setAccessToken(tokenDoc.getString("accessToken"));
        pciAuthorizationTokenElement.setAccountId(userODBID);
        pciAuthorizationTokenElement.setAuthenticationToken(tokenDoc.getString("authenticationToken"));
        pciAuthorizationTokenElement.setClientId(tokenDoc.getString("clientId"));
        pciAuthorizationTokenElement.setSharePointUrl(tokenDoc.getString("sharePointUrl"));
        pciAuthorizationTokenElement.setClientSecret(tokenDoc.getString("clientSecret"));
        pciAuthorizationTokenElement.setCloudName(tokenDoc.getString("cloudName"));
        pciAuthorizationTokenElement.setEmailId(userODBID);
        pciAuthorizationTokenElement.setRefreshToken(tokenDoc.getString("refreshToken"));
        pciAuthorizationTokenElement.setSharePointUrl("https://parablusys-my.sharepoint.com");
        int totalCount = 0;
        System.out.println("..." + CheckSize.getSizeOfFolder(pciAuthorizationTokenElement, "1"));
        int itemCount = CheckSize.getCountOfFilesInFolder(pciAuthorizationTokenElement, "1");
        totalCount = itemCount + totalCount;
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " ************* ITEM COUNT********* for " + 1 + " " + itemCount);
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " ................totalCount...." + totalCount);
    }

    public static void checkThreadStatusAndStartUpdate(final MongoDatabase db, final MongoCollection chunkCollDB, final PciAuthorizationTokenElement pciAuthorizationTokenElement, final MongoCollection chunksDBCollection, final CompletionService<String> pool) {
        if (timer == null) {
            timer = new Timer();
        }
        if (backupTimerTask == null) {
            backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Future future = pool.take();
                        if (future.isDone()) {
                            CheckSize.callcheckChunksInCloud(db, chunkCollDB, pciAuthorizationTokenElement, chunksDBCollection, pool);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            timer.schedule(backupTimerTask, 1000L, 1000L);
        }
    }

    private static void callcheckChunksInCloud(MongoDatabase db, MongoCollection chunkCollDB, PciAuthorizationTokenElement pciAuthorizationTokenElement, MongoCollection chunksDBCollection, CompletionService<String> pool) {
        Runnable uploadJob = () -> {
            try {
                CheckSize.checkChunksInCloud(db, chunkCollDB, pciAuthorizationTokenElement, chunksDBCollection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        pool.submit(uploadJob, "");
    }

    private static void checkChunksInCloud(MongoDatabase db, MongoCollection chunkColl, PciAuthorizationTokenElement pciAuthorizationTokenElement, MongoCollection chunksDBCollection) {
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("newRef", false));
        whereQuery.add(new BasicDBObject("deleted", new BasicDBObject("$exists", false)));
        andQuery.put("$and", whereQuery);
        int skip = CheckSize.getSkipValue();
        FindIterable chunksList = null;
        chunksList = skip > 0 ? chunksDBCollection.find(andQuery).skip(skip * limit).limit(limit) : chunksDBCollection.find(andQuery).limit(limit);
        for (Document chunkDetail : chunksList) {
            ++proccessCount;
            if (!StringUtils.isEmpty(chunkDetail.getString("md5"))) {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " *********************************************Started************************************" + chunkDetail.toJson());
                boolean respose = CheckSize.deleteFileFromODB(pciAuthorizationTokenElement, chunkDetail.getString("cloudChunkName"), chunkDetail.getString("cloudStoragePath"));
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " ````````!!!!!!!!!!!!!!!!!!!!!!!..................." + respose);
                if (respose) {
                    BasicDBObject idQuery = new BasicDBObject("_id", chunkDetail.getObjectId("_id"));
                    String md5 = chunkDetail.getString("md5");
                    MongoCollection<Document> chunkSharded = db.getCollection(CheckSize.getChunkDetailCollections(md5));
                    DeleteResult deleteOne = chunkSharded.deleteOne(idQuery);
                    if (deleteOne.getDeletedCount() == 0L) {
                        System.out.println(String.valueOf(Thread.currentThread().getName()) + " chunk delete in chunkDetail");
                        chunkColl.findOneAndDelete(idQuery);
                    } else {
                        System.out.println(String.valueOf(Thread.currentThread().getName()) + " chunk deleted in chunk sharded....");
                    }
                } else {
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + " File not present in cloud............" + chunkDetail.toJson());
                }
            }
            BasicDBObject chunkSearchQuery = new BasicDBObject();
            chunkSearchQuery.append("_id", chunkDetail.get("_id"));
            BasicDBObject chunkUpdateFields = new BasicDBObject();
            chunkUpdateFields.append("deleted", true);
            BasicDBObject updatebkpPolicyQuery = new BasicDBObject();
            updatebkpPolicyQuery.append("$set", chunkUpdateFields);
            chunksDBCollection.updateOne(chunkSearchQuery, updatebkpPolicyQuery);
            System.out.println(String.valueOf(Thread.currentThread().getName()) + " *********************************************ENDED************************************ " + proccessCount);
        }
        CheckSize.reduceSkip();
    }

    public static synchronized int getSkipValue() {
        return ++skipValue;
    }

    public static synchronized void reduceSkip() {
        if (skipValue >= threads) {
            System.out.println(String.valueOf(Thread.currentThread().getName()) + " Inside Skip to 0");
            skipValue = 0;
        }
    }

    private static String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5(name);
            byte[] bytesEncoded = Base64.encodeBase64(bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            base64EncodeString = base64EncodeString.replaceAll("/", "_");
        }
        return base64EncodeString;
    }

    public static String getLibraryDownloadUrl(String office365baseUrl, String fileName, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(office365baseUrl) + personalUrl + CheckSize.getEmailId(accountId) + "/_api/web/GetFolderByServerRelativeUrl('" + personalUrl + CheckSize.getEmailId(accountId) + "/" + pbFolderName + "/" + userName + "/" + suffixFolderPath + "')" + "/Files('" + fileName + "')/$value";
    }

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }

    private static int getRetryOdbFolderValue() {
        return 3000;
    }

    private static long sleepForGivenTime(long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return sleepTimeTemp;
    }

    public static boolean deleteFileFromODB(PciAuthorizationTokenElement pciTokenElement, String fileName, String cloudStoragePath) {
        boolean retry;
        String fileNameTemp = fileName;
        PciAuthorizationTokenElement authorizationTokenElementTemp = pciTokenElement;
        String deleteurl = CheckSize.getFilePathToDelete(pciTokenElement, fileNameTemp = CheckSize.convertStringTOBase64(fileNameTemp).replaceAll("/", "_"), cloudStoragePath);
        if (StringUtils.isEmpty(deleteurl)) {
            System.out.println(String.valueOf(Thread.currentThread().getName()) + " File not found on any path so return false ");
            return false;
        }
        String deleteFileUrl = deleteurl.substring(0, deleteurl.length() - 7);
        int retryCount = 0;
        boolean success = false;
        do {
            retry = false;
            System.out.println(String.valueOf(retryCount) + "..retrycount...url>>>>>>>>>>>" + deleteFileUrl);
            HttpPost httpPost = new HttpPost(deleteFileUrl);
            httpPost.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
            httpPost.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
            httpPost.addHeader("X-HTTP-Method", "DELETE");
            HttpResponse result = null;
            try {
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                int timeout = 3;
                RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
                httpPost.setConfig(config);
                result = httpclient.execute(httpPost);
                int responseCode = result.getStatusLine().getStatusCode();
                System.out.println(String.valueOf(Thread.currentThread().getName()) + "  Delete Response Code.." + responseCode);
                if (responseCode == 200) {
                    success = true;
                } else if (responseCode == 401) {
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + " inside get access token...");
                    retry = true;
                    ++retryCount;
                    authorizationTokenElementTemp = Office365.getAccessToken(authorizationTokenElementTemp);
                    CheckSize.deleteFileFromODB(pciTokenElement, fileName, cloudStoragePath);
                }
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " retry...." + retry + " count:" + retryCount);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " error while trying to delete file...." + e.getMessage());
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " error while trying to delete file...." + e);
                return success;
            }
        } while (retry && retryCount < 2);
        return success;
    }

    public static String getParabluLibrarySizeUrl(String office365baseUrl, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        pbFolderName = "";
        suffixFolderPath = "";
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = CheckSize.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(personalSite) + "/_api/web/getFolderByServerRelativeUrl('" + personalUrl + CheckSize.getEmailId(accountId) + "/" + pbFolderName + userName + "/" + suffixFolderPath + "/')?$select=StorageMetrics&$expand=StorageMetrics";
    }

    public static String getParabluLibraryUrl(String office365baseUrl, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = CheckSize.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(personalSite) + "/_api/web/GetFolderByServerRelativeUrl('" + personalUrl + CheckSize.getEmailId(accountId) + "/" + pbFolderName + userName + "/" + suffixFolderPath + "/')";
    }

    public static String getPersonalSite(String office365baseUrl, String accountId) {
        if (accountId.contains("sites/")) {
            return String.valueOf(office365baseUrl) + "/" + CheckSize.getEmailId(accountId);
        }
        return String.valueOf(office365baseUrl) + PERSONAL_URL + CheckSize.getEmailId(accountId);
    }

    public static String getFilePathToDelete(PciAuthorizationTokenElement authorizationTokenElement, String fileName, String chunkFilePath) {
        boolean retry;
        String pbFolderName = "PB";
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        String userNameInPath = "";
        String downloadurl = CheckSize.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), userNameInPath, chunkFilePath, pbFolderName);
        boolean incrementPath = false;
        boolean decrementPath = false;
        boolean newPathCheck = false;
        boolean oldStylePath = false;
        boolean customOldStylePath = false;
        boolean increOldStylePath = false;
        boolean decreOldStylePath = false;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 5000L * (long)sleepMultiplier;
        do {
            retry = false;
            HttpGet httpGet = null;
            String modifiedPath = chunkFilePath;
            try {
                int path;
                String cloudPath;
                System.out.println(String.valueOf(downloadurl) + "......attempt url........" + retryCount);
                httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
                httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
                httpGet.addHeader(HEADER_KEY_CONTENT_TYPE, "*/*");
                System.out.println(String.valueOf(Thread.currentThread().getName()) + "  without proxy ...");
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                HttpResponse result = httpclient.execute(httpGet);
                int responseCode = result.getStatusLine().getStatusCode();
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " >>>>>>>>>>>>>>>>>file Response status code: " + responseCode);
                if (responseCode == 200) {
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + " File found so return path is " + downloadurl);
                    return downloadurl;
                }
                if (responseCode == 401) {
                    retry = true;
                    ++retryCount;
                    sleepTime = CheckSize.sleepForGivenTime(sleepTime);
                    authorizationTokenElementTemp = Office365.getAccessToken(authorizationTokenElementTemp);
                    continue;
                }
                if (responseCode == 200) continue;
                retry = true;
                sleepTime = responseCode != 404 ? CheckSize.sleepForGivenTime(sleepTime) : 0L;
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " ..retry attempt for response code ...." + responseCode + "...." + ++retryCount);
                if (responseCode != 404) continue;
                if (!increOldStylePath) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = CheckSize.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), "", cloudPath, pbFolderName);
                    modifiedPath = cloudPath;
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + " ...increOldStylePath..." + modifiedPath);
                    increOldStylePath = true;
                    continue;
                }
                if (!newPathCheck && CheckSize.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + CheckSize.getRetryOdbFolderValue());
                    }
                    downloadurl = CheckSize.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    newPathCheck = true;
                    modifiedPath = cloudPath;
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + " ...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!decrementPath) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = CheckSize.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    decrementPath = true;
                    modifiedPath = cloudPath;
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + " ...decre new path..." + modifiedPath);
                    continue;
                }
                if (!incrementPath) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = CheckSize.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), userNameInPath, cloudPath, pbFolderName);
                    modifiedPath = cloudPath;
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + " ...incre new path..." + modifiedPath);
                    incrementPath = true;
                    continue;
                }
                if (!oldStylePath) {
                    downloadurl = CheckSize.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), "", chunkFilePath, pbFolderName);
                    oldStylePath = true;
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + " ...oldStylePath restore ...");
                    continue;
                }
                if (!customOldStylePath && CheckSize.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty(cloudPath)) {
                        path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + CheckSize.getRetryOdbFolderValue());
                    }
                    downloadurl = CheckSize.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), "", cloudPath, pbFolderName);
                    customOldStylePath = true;
                    modifiedPath = cloudPath;
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + " ...customOldStylePath retryodbValue ..." + modifiedPath);
                    continue;
                }
                if (decreOldStylePath) continue;
                cloudPath = chunkFilePath;
                if (StringUtils.isNotEmpty(cloudPath)) {
                    path = Integer.parseInt(cloudPath);
                    cloudPath = "" + (path - 1);
                }
                downloadurl = CheckSize.getLibraryDownloadUrl(authorizationTokenElementTemp.getSharePointUrl(), fileName, authorizationTokenElementTemp.getAccountId(), "", cloudPath, pbFolderName);
                decreOldStylePath = true;
                modifiedPath = cloudPath;
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " ...decreOldStylePath..." + modifiedPath);
            }
            catch (Exception e) {
                retry = true;
                ++retryCount;
                sleepTime = CheckSize.sleepForGivenTime(sleepTime);
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " Exception While Retying Download File From One Drive :" + e.getMessage());
            }
        } while (retry && retryCount < 8);
        return null;
    }

    public static int getCountOfFilesInFolder(PciAuthorizationTokenElement ppciTokenElement, String cloudStoragePath) {
        String userNameToGetUrl = "";
        PciAuthorizationTokenElement pciTokenElement = ppciTokenElement;
        String pbFolderName = "PB/1iev048pj2ptj";
        String paraBluFolderPath = CheckSize.getParabluLibraryUrl(pciTokenElement.getSharePointUrl(), pciTokenElement.getAccountId(), userNameToGetUrl, cloudStoragePath, pbFolderName);
        System.out.println(paraBluFolderPath);
        int count = 0;
        String fileUrl = String.valueOf(paraBluFolderPath) + "/itemcount";
        HttpGet httpGet = new HttpGet(fileUrl);
        httpGet.addHeader("Authorization", BEARER + pciTokenElement.getAccessToken());
        httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
        HttpResponse result = null;
        try {
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            result = httpclient.execute(httpGet);
            int statusCode = result.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                pciTokenElement = Office365.getAccessToken(pciTokenElement);
                int n = CheckSize.getCountOfFilesInFolder(pciTokenElement, cloudStoragePath);
                return n;
            }
            if (statusCode != 200) {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + "  path doesnot exists ......... " + statusCode);
                int n = count;
                return n;
            }
            try {
                String json = EntityUtils.toString(result.getEntity());
                JSONObject jsonObject = new JSONObject(json);
                String itemCount = jsonObject.optString("d");
                if (itemCount != null) {
                    jsonObject = new JSONObject(new String(itemCount));
                    itemCount = jsonObject.optString("ItemCount");
                    count = Integer.parseInt(itemCount);
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " " + e);
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " Exception While Getting Count of Files In Folder :" + e.getMessage());
            }
        }
        finally {
            httpGet.releaseConnection();
        }
        return count;
    }

    public static int getSizeOfFolder(PciAuthorizationTokenElement ppciTokenElement, String cloudStoragePath) {
        String userNameToGetUrl = "";
        PciAuthorizationTokenElement pciTokenElement = ppciTokenElement;
        String pbFolderName = "PB/1iev048pj2ptj";
        String paraBluFolderPath = CheckSize.getParabluLibrarySizeUrl(pciTokenElement.getSharePointUrl(), pciTokenElement.getAccountId(), userNameToGetUrl, cloudStoragePath, pbFolderName);
        System.out.println(paraBluFolderPath);
        int count = 0;
        String fileUrl = paraBluFolderPath;
        HttpGet httpGet = new HttpGet(fileUrl);
        httpGet.addHeader("Authorization", BEARER + pciTokenElement.getAccessToken());
        httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
        HttpResponse result = null;
        try {
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            result = httpclient.execute(httpGet);
            int statusCode = result.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                pciTokenElement = Office365.getAccessToken(pciTokenElement);
                int n = CheckSize.getCountOfFilesInFolder(pciTokenElement, cloudStoragePath);
                return n;
            }
            if (statusCode != 200) {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + "  path doesnot exists ......... " + statusCode);
                int n = count;
                return n;
            }
            try {
                String json = EntityUtils.toString(result.getEntity());
                JSONObject jsonObject = new JSONObject(json);
                String itemCount = jsonObject.optString("d");
                if (itemCount != null) {
                    jsonObject = new JSONObject(new String(itemCount));
                    String StorageMetrics = jsonObject.optString("StorageMetrics");
                    jsonObject = new JSONObject(new String(StorageMetrics));
                    itemCount = jsonObject.optString("TotalFileStreamSize");
                    count = Integer.parseInt(itemCount);
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " " + e);
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " Exception While Getting Count of Files In Folder :" + e.getMessage());
            }
        }
        finally {
            httpGet.releaseConnection();
        }
        return count;
    }

    private static String getChunkDetailCollections(String string) {
        throw new Error("Unresolved compilation problem: \n\tSyntax error on tokens, delete these tokens\n");
    }
}

