/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.jar;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.ModularJarArchiver;
import org.codehaus.plexus.archiver.util.ArchiveEntryUtils;
import org.codehaus.plexus.archiver.util.ResourceUtils;
import org.codehaus.plexus.archiver.zip.ConcurrentJarCreator;
import org.codehaus.plexus.util.FileUtils;

public class JarToolModularJarArchiver
extends ModularJarArchiver {
    private static final String MODULE_DESCRIPTOR_FILE_NAME = "module-info.class";
    private static final Pattern MRJAR_VERSION_AREA = Pattern.compile("META-INF/versions/\\d+/");
    private Object jarTool;
    private boolean moduleDescriptorFound;
    private Path tempDir;

    public JarToolModularJarArchiver() {
        try {
            Class<?> toolProviderClass = Class.forName("java.util.spi.ToolProvider");
            Object jarToolOptional = toolProviderClass.getMethod("findFirst", String.class).invoke(null, "jar");
            this.jarTool = jarToolOptional.getClass().getMethod("get", new Class[0]).invoke(jarToolOptional, new Object[0]);
        }
        catch (ReflectiveOperationException | SecurityException exception) {
            // empty catch block
        }
    }

    @Override
    protected void zipFile(InputStreamSupplier is, ConcurrentJarCreator zOut, String vPath, long lastModified, File fromArchive, int mode, String symlinkDestination, boolean addInParallel) throws IOException, ArchiverException {
        if (this.jarTool != null && this.isModuleDescriptor(vPath)) {
            this.getLogger().debug("Module descriptor found: " + vPath);
            this.moduleDescriptorFound = true;
            if (this.tempDir == null) {
                this.tempDir = Files.createTempDirectory("plexus-archiver-modular_jar-", new FileAttribute[0]);
                this.tempDir.toFile().deleteOnExit();
            }
            File destFile = this.tempDir.resolve(vPath).toFile();
            destFile.getParentFile().mkdirs();
            destFile.deleteOnExit();
            ResourceUtils.copyFile(is.get(), destFile);
            ArchiveEntryUtils.chmod(destFile, mode);
            destFile.setLastModified(lastModified == 0L ? System.currentTimeMillis() : lastModified);
        } else {
            super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode, symlinkDestination, addInParallel);
        }
    }

    @Override
    protected void postCreateArchive() throws ArchiverException {
        if (!this.moduleDescriptorFound) {
            return;
        }
        try {
            this.getLogger().debug("Using the jar tool to update the archive to modular JAR.");
            Integer result = (Integer)this.jarTool.getClass().getMethod("run", PrintStream.class, PrintStream.class, String[].class).invoke(this.jarTool, System.out, System.err, this.getJarToolArguments());
            if (result != null && result != 0) {
                throw new ArchiverException("Could not create modular JAR file. The JDK jar tool exited with " + result);
            }
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new ArchiverException("Exception occurred while creating modular JAR file", e);
        }
        finally {
            this.clearTempDirectory();
        }
    }

    private boolean isModuleDescriptor(String path) {
        if (path.endsWith(MODULE_DESCRIPTOR_FILE_NAME)) {
            String prefix = path.substring(0, path.lastIndexOf(MODULE_DESCRIPTOR_FILE_NAME));
            return prefix.isEmpty() || MRJAR_VERSION_AREA.matcher(prefix).matches();
        }
        return false;
    }

    private String[] getJarToolArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--update");
        args.add("--file");
        args.add(this.getDestFile().getAbsolutePath());
        if (this.getModuleMainClass() != null) {
            args.add("--main-class");
            args.add(this.getModuleMainClass());
        }
        if (this.getModuleVersion() != null) {
            args.add("--module-version");
            args.add(this.getModuleVersion());
        }
        if (!this.isCompress()) {
            args.add("--no-compress");
        }
        args.add("-C");
        args.add(this.tempDir.toFile().getAbsolutePath());
        args.add(".");
        return args.toArray(new String[0]);
    }

    private void clearTempDirectory() {
        try {
            if (this.tempDir != null) {
                FileUtils.deleteDirectory(this.tempDir.toFile());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

