/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.parablu.epa.common.dao.ActivityHistoryImpl;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackUpImageDAOImpl;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.BackupCrawlDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.dao.BackupStatisticsDAOImpl;
import com.parablu.epa.common.dao.DodTableImpl;
import com.parablu.epa.common.dao.DownloadTableImpl;
import com.parablu.epa.common.dao.FolderDaoImpl;
import com.parablu.epa.common.dao.MediaFolderDAOImpl;
import com.parablu.epa.common.dao.MediaImageDAOImpl;
import com.parablu.epa.common.dao.RestoreActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.SyncPolicyDAOImpl;
import com.parablu.epa.common.dao.UploadTableImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.BluVaultIPHelper;
import com.parablu.epa.common.service.settings.CipherHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SharedPreferences;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.BkPolicyFolderPathElement;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.service.network.CloudIPHelper;
import com.parablu.epa.core.service.registration.CloudRegistrationUtility;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.GatewayTO;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SettingHelper {
    private static final String CURRENT_PORT = "currentPort";
    private static final String BACKUP_LICENCED = "backupLicenced";
    private static final String SYNC_LICENCED = "syncLicenced";
    private static final String PARABLU = "Parablu";
    private static final String BLUSYNC = "Blusync";
    private static final String SERVER_BACKUP_LICENSED = "serverBackupLicensed";
    public static Process process;
    private static Logger logger;
    public static final String NULL_STRING_REPRESENTATION = "null";
    private static final String TRUE_VALUE_STRING_REPRESENTATION = "true";
    private static final String FALSE_STRING = "false";
    private static final String FALSE_VALUE_STRING_REPRESENTATION = "false";
    private static String keystorePath;
    private static boolean licenseActive;
    private static boolean deviceBlocked;
    private static String baseDBUrl;
    private static String activityDBUrl;
    private static String folderDBUrl;
    private static String syncedFilesDBUrl;
    private static String imageTableHistoryDBUrl;
    private static String downloadTableDBUrl;
    private static String uploadTableDBUrl;
    private static String dodTableDBUrl;
    private static String backUpDbUrl;
    private static String mediaDbUrl;
    private static String backUpCrawlDbUrl;
    private static String syncDbUrl;
    private static String chunkDbUrl;
    private static String parabluBlusyncAppDataFolderUrl;
    private static String parabluBaseAppDataFolderUrl;
    private static String parabluTempUploadFolder;
    private static String parabluTempDownloadFolder;
    private static String crawlGzipFolder;
    private static String tokenFileUrl;
    private static String sharedPreferencesUrl;
    private static String ipSettingsUrl;
    private static String userHome;
    private static String parabluSyncFolder;
    private static String userAppdataDir;
    private static String uiLockUrl;
    private static String mainLockUrl;
    private static String updateDownloadURL;
    private static String iconPath;
    private static String baseChunkFolderUrl;
    private static String programFilesDir;
    private static String installationDir;
    private static String osName;
    private static String osVersion;
    private static String userName;
    private static String cloudName;
    private static String deviceName;
    private static String regristrationID;
    private static String syncLicenced;
    private static String backupLicenced;
    private static String mediaUserName;
    private static String mediaPassword;
    private static String parabluScriptsFolder;
    private static String parabluVshadowPath;
    private static String currentCloudIpAddress;
    private static String localIpAddress;
    private static String publicIpAddress;
    private static String gaeLocalIpAddress;
    private static String httpPort;
    private static String httpsPort;
    private static String currentHttpsPort;
    private static GatewayTO syncUploadIpAddress;
    private static boolean enableBlusync;
    public static long lastSuccessfulBackup;
    public static boolean mediaHubEnabled;
    private static boolean tempEnableBlusync;
    private static boolean tempEnableAutomaticBackUp;
    private static boolean enableAutomaticBackUp;
    private static boolean addPreConfiguredFoldersForBackup;
    private static int tempCheckParacloudForUpdateTimerInMins;
    private static int tempBackUpIntervalInMins;
    private static int backUpIntervalInMins;
    private static int checkParacloudForUpdateTimerInMins;
    private static String webdevDrive;
    private static boolean enableMusicMediaSync;
    private static boolean tempEnableMusicMediaSync;
    private static boolean enablePicturesMediaSync;
    private static boolean tempEnablePicturesMediaSync;
    private static boolean enableVideosMediaSync;
    private static boolean tempEnableVideosMediaSync;
    private static Set<BackupFolderTO> backupFolderTOsExistingFolderPathsHolder;
    private static List<FileElement> backedUpFoldersList;
    private static File syncedFilesPathHandle;
    private static boolean errorOccuredDuringSync;
    private static BackupPolicyTO currentBackupPolicy;
    private static int tempPolicyRefreshIntervalInMins;
    private static int uiVersion;
    private static String isStatisticsEnabled;
    private static int statisticsRefreshIntervalInMins;
    private static long userMaxStorageLimit;
    private static int maxVersionsToKeep;
    private static boolean isDCMEnabled;
    private static String backupCrawlLimit;
    private static String productVersion;
    private static String isLegalHoldEnabled;
    private static String serverBackupLicensed;
    private static String isNoUi;
    private static String snapFolderPath;
    private static String isVssEnabled;
    private static List<BkPolicyFolderPathElement> backupPolicyFoldersList;
    private static String deviceUUId;
    private static String restoreEnabled;
    private static String isExternalStorageSelected;
    private static long nextBackupTimeStamp;
    private static final String MAP_KEY_LDAP_ENABLED = "ldapEnabled";
    private static final String DEVICE_UUID = "deviceUUId";
    private static final String RESTORE_ENABLED = "restoreEnabled";
    private static final String ISEXTERNAL_RESTORE_SELECTED = "isExternalStorageSelected";
    private static final String ISBACKUP_POLICY_EBABLED = "isBackupPolicyEnabled";
    private static int policySyncInterval;
    private static final String AGENT_BACKUP_UI_PERMISSIONS = "agentBackupUiDetails";
    private static final String AGENT_SYNC_UI_PERMISSIONS = "agentSyncUiDetails";
    private static String endpointBackupUiDetails;
    private static String endpointSyncUiDetails;
    private static boolean initiateBackupInterfaceEnabled;
    private static boolean restoreInterfaceEnabled;
    private static boolean pauseBackupInterfaceEnabled;
    private static boolean stopBackupInterfaceEnabled;
    private static boolean backupSettingsInterfaceEnabled;
    private static boolean backupFilesInterfaceEnabled;
    private static boolean refreshBackupPolicyInterfaceEnabled;
    private static boolean syncNowInterfaceEnabled;
    private static boolean syncSettingsInterfaceEnabled;
    private static boolean syncFilesInterfaceEnabled;
    private static boolean refreshSyncPolicyInterfaceEnabled;
    private static boolean searchInterfaceEnabled;
    private static boolean openSyncFolderInterfaceEnabled;
    private static boolean backupSystrayIconEnabled;
    private static boolean syncSystrayIconEnabled;
    private static boolean exitBackupInterfaceEnabled;
    private static boolean exitSyncInterfaceEnabled;
    private static boolean decoupleBackupInterfaceEnabled;
    private static boolean decoupleSyncInterfaceEnabled;
    private static boolean supportBackupInterfaceEnabled;
    private static boolean supportSyncInterfaceEnabled;
    private static boolean backuptoolTipNotificationBlocked;
    private static boolean synctoolTipNotificationBlocked;
    private static boolean updateAgentBackupInterfaceEnabled;
    private static boolean updateAgentSyncInterfaceEnabled;
    private static boolean aboutBackupInterfaceEnabled;
    private static boolean aboutSyncInterfaceEnabled;

    private SettingHelper() {
    }

    public static String getIsVssEnabled() {
        return isVssEnabled;
    }

    public static void setIsVssEnabled(String vssEnabled) {
        isVssEnabled = vssEnabled;
    }

    public static String getSnapFolderPath() {
        return snapFolderPath;
    }

    public static void setSnapFolderPath(String snapFolderPath) {
        SettingHelper.snapFolderPath = snapFolderPath;
    }

    public static String getIsNoUi() {
        return isNoUi;
    }

    public static void setIsNoUi(String isNoUi) {
        SettingHelper.isNoUi = isNoUi;
    }

    public static int getUiVersion() {
        return uiVersion;
    }

    public static void setUiVersion(int uiVersion) {
        SettingHelper.uiVersion = uiVersion;
    }

    public static boolean isMediaHubEnabled() {
        return mediaHubEnabled;
    }

    public static void setMediaHubEnabled(boolean mediaHubEnabled) {
        SettingHelper.mediaHubEnabled = mediaHubEnabled;
    }

    public static boolean isErrorOccuredDuringSync() {
        return errorOccuredDuringSync;
    }

    public static void setErrorOccuredDuringSync(boolean errorOccuredDuringSync) {
        SettingHelper.errorOccuredDuringSync = errorOccuredDuringSync;
    }

    public static File getSyncedFilesPathHandle() {
        return syncedFilesPathHandle;
    }

    public static void setSyncedFilesPathHandle(File synceFilesPathHandle) {
        syncedFilesPathHandle = synceFilesPathHandle;
    }

    public static String getSyncLicenced() {
        return syncLicenced;
    }

    public static void setSyncLicenced(String syncLicenced) {
        SettingHelper.syncLicenced = syncLicenced;
    }

    public static String getBackupLicenced() {
        return backupLicenced;
    }

    public static void setBackupLicenced(String backupLicenced) {
        SettingHelper.backupLicenced = backupLicenced;
    }

    public static String getUiLockUrl() {
        return uiLockUrl;
    }

    public static void setUiLockUrl(String uiLockUrl) {
        SettingHelper.uiLockUrl = uiLockUrl;
    }

    public static String getMainLockUrl() {
        return mainLockUrl;
    }

    public static void setMainLockUrl(String mainLockUrl) {
        SettingHelper.mainLockUrl = mainLockUrl;
    }

    public static String getParabluBlusyncAppDataFolderUrl() {
        return parabluBlusyncAppDataFolderUrl;
    }

    public static void setParabluBlusyncAppDataFolderUrl(String parabluBlusyncAppDataFolderUrl) {
        SettingHelper.parabluBlusyncAppDataFolderUrl = parabluBlusyncAppDataFolderUrl;
    }

    public static String getOsName() {
        return osName;
    }

    public static void setOsName(String osName) {
        SettingHelper.osName = osName;
    }

    public static String getParabluScriptsFolder() {
        return parabluScriptsFolder;
    }

    public static void setParabluScriptsFolder(String parabluScriptsFolder) {
        SettingHelper.parabluScriptsFolder = parabluScriptsFolder;
    }

    public static String getParabluVshadowPath() {
        return parabluVshadowPath;
    }

    public static void setParabluVshadowPath(String parabluVshadowPath) {
        SettingHelper.parabluVshadowPath = parabluVshadowPath;
    }

    public static boolean createFolders() {
        logger.debug("Creating  default folders");
        StringBuilder sb = new StringBuilder();
        StringBuilder sbSettings = new StringBuilder();
        StringBuilder sbBlusync = new StringBuilder();
        sb.append(userHome).append(StringLiterals.CONSTANTS_FILE_SEPARATOR);
        sbSettings.append(baseDBUrl);
        sbBlusync.append(SettingHelper.getParabluBlusyncAppDataFolderUrl()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("settings");
        String folderPath = new StringBuffer().append(sb.toString()).append("ParaBlu").toString();
        boolean success = SettingHelper.createFolder(folderPath);
        folderPath = new StringBuffer().append(sb.toString()).append("Music").toString();
        success = SettingHelper.createFolder(folderPath) ? success : false;
        folderPath = new StringBuffer().append(sb.toString()).append("Pictures").toString();
        success = SettingHelper.createFolder(folderPath) ? success : false;
        folderPath = new StringBuffer().append(sb.toString()).append("videos").toString();
        success = SettingHelper.createFolder(folderPath) ? success : false;
        success = SettingHelper.createFolder(sbSettings.toString()) ? success : false;
        success = SettingHelper.createFolder(sbBlusync.toString()) ? success : false;
        success = SettingHelper.createFolder(updateDownloadURL) ? success : false;
        return success;
    }

    public static String getUserAppdataDir() {
        return userAppdataDir;
    }

    public static void setUserAppdataDir(String userAppdataDir) {
        SettingHelper.userAppdataDir = userAppdataDir;
    }

    private static boolean createFolder(String filename) {
        boolean success = true;
        File file = new File(filename);
        if (!file.exists()) {
            success = file.mkdirs();
        }
        return success;
    }

    public static void deleteTokenFile() {
        File file = new File(SettingHelper.getTokenFileUrl());
        if (file.exists()) {
            file.delete();
        }
    }

    public static String readTokenFromFile() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        String token = null;
        Cipher cipher = CipherHelper.decryptionCipher();
        File file = new File(SettingHelper.getTokenFileUrl());
        if (!file.exists()) {
            return token;
        }
        try (CipherInputStream ci = new CipherInputStream(new FileInputStream(file), cipher);
             StringWriter stringWriter = new StringWriter();){
            int b = ci.read();
            while (b != -1) {
                stringWriter.write(b);
                b = ci.read();
            }
            token = stringWriter.toString();
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFoundException token file url: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException token file url: ", (Throwable)e);
        }
        return token;
    }

    public static void createTokenFile(CloudRegistrationUtility rs) throws IOException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] b = rs.getToken().getBytes("UTF-8");
        File file = new File(SettingHelper.getTokenFileUrl());
        Cipher cipher = CipherHelper.encryptionCipher();
        if (file.exists()) {
            file.delete();
        }
        new File(file.getParent()).mkdirs();
        file.createNewFile();
        try (CipherOutputStream co = new CipherOutputStream(new FileOutputStream(file), cipher);){
            co.write(b);
            co.close();
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFoundException while CipherOutputStream", (Throwable)e);
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            logger.error("IOException CipherOutputStream", (Throwable)e);
            throw new IOException();
        }
    }

    public static boolean readFromSharedPreferences() {
        if (!SettingHelper.readCommonDetails()) {
            return false;
        }
        if (!SettingHelper.readIpSettings()) {
            SettingHelper.resetIpSettings();
        }
        return true;
    }

    private static boolean resetIpSettings() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("local_ip", NULL_STRING_REPRESENTATION);
        map.put("public_ip", NULL_STRING_REPRESENTATION);
        map.put("gae_local_ip", NULL_STRING_REPRESENTATION);
        map.put("working_cloud_ip", NULL_STRING_REPRESENTATION);
        map.put("http_port", NULL_STRING_REPRESENTATION);
        map.put("https_port", NULL_STRING_REPRESENTATION);
        map.put(CURRENT_PORT, NULL_STRING_REPRESENTATION);
        SharedPreferences sp = new SharedPreferences(ipSettingsUrl);
        boolean success = sp.setDataUnencrypted(map);
        if (success) {
            success = SettingHelper.readIpSettings();
        }
        return success;
    }

    private static boolean readIpSettings() {
        SharedPreferences sp = new SharedPreferences(ipSettingsUrl);
        boolean success = true;
        Map<String, String> map = sp.readAllDataUnencrypted();
        if (map == null || map.isEmpty()) {
            logger.debug("IP Settings URL map is null OR empty");
            return false;
        }
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            String tempval = entry.getValue();
            if (key.equals("local_ip")) {
                if (tempval != null && !tempval.equals(NULL_STRING_REPRESENTATION)) {
                    localIpAddress = tempval;
                    continue;
                }
                localIpAddress = null;
                continue;
            }
            if (key.equals("public_ip")) {
                if (tempval != null && !tempval.equals(NULL_STRING_REPRESENTATION)) {
                    publicIpAddress = tempval;
                    continue;
                }
                publicIpAddress = null;
                continue;
            }
            if (key.equals("gae_local_ip")) {
                if (tempval != null && !tempval.equals(NULL_STRING_REPRESENTATION)) {
                    gaeLocalIpAddress = tempval;
                    continue;
                }
                gaeLocalIpAddress = null;
                continue;
            }
            if (key.equals("working_cloud_ip")) {
                if (tempval != null && !tempval.equals(NULL_STRING_REPRESENTATION)) {
                    currentCloudIpAddress = tempval;
                    continue;
                }
                currentCloudIpAddress = null;
                continue;
            }
            if (key.equals("http_port")) {
                if (tempval != null && !tempval.equals(NULL_STRING_REPRESENTATION)) {
                    httpPort = tempval;
                    continue;
                }
                httpPort = null;
                continue;
            }
            if (key.equals("https_port")) {
                if (tempval != null && !tempval.equals(NULL_STRING_REPRESENTATION)) {
                    httpsPort = tempval;
                    continue;
                }
                httpsPort = null;
                continue;
            }
            if (!key.equals(CURRENT_PORT)) continue;
            if (tempval != null && !tempval.equals(NULL_STRING_REPRESENTATION)) {
                logger.debug(currentHttpsPort);
                currentHttpsPort = tempval;
                continue;
            }
            currentHttpsPort = null;
        }
        return success;
    }

    private static boolean readCommonDetails() {
        SharedPreferences sp = new SharedPreferences(sharedPreferencesUrl);
        boolean success = true;
        Map<String, String> map = sp.readAllData();
        if (map == null || map.isEmpty() || map.get("cloud_name") == null) {
            logger.debug("Shared Preferences URL map is null OR empty OR CONSTANTS_SETTINGS_CLOUDNAME_NAME is null");
            return false;
        }
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            String tempval = entry.getValue();
            if (key.equals("timer_count")) {
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) {
                    return false;
                }
                try {
                    tempCheckParacloudForUpdateTimerInMins = checkParacloudForUpdateTimerInMins = Integer.valueOf(tempval).intValue();
                    continue;
                }
                catch (NumberFormatException e) {
                    logger.error("NumberFormatException while reading from settings file,the timer time is not an integer" + e);
                    return false;
                }
            }
            if (key.equals("backup_interval")) {
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) {
                    return false;
                }
                try {
                    tempBackUpIntervalInMins = backUpIntervalInMins = Integer.valueOf(tempval).intValue();
                    continue;
                }
                catch (NumberFormatException e) {
                    logger.error("NumberFormatException while reading from settings file,the timer time is not an integer" + e);
                    return false;
                }
            }
            if (key.equals("auto_back")) {
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION) || !tempval.equals(TRUE_VALUE_STRING_REPRESENTATION) && !tempval.equals("false")) {
                    return false;
                }
                tempEnableAutomaticBackUp = enableAutomaticBackUp = Boolean.valueOf(tempval).booleanValue();
                continue;
            }
            if (key.equals(SYNC_LICENCED)) {
                syncLicenced = null;
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                syncLicenced = tempval;
                continue;
            }
            if (key.equals(BACKUP_LICENCED)) {
                backupLicenced = null;
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                backupLicenced = tempval;
                continue;
            }
            if (key.equals("enable_blusync")) {
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION) || !tempval.equals(TRUE_VALUE_STRING_REPRESENTATION) && !tempval.equals("false")) {
                    return false;
                }
                tempEnableBlusync = enableBlusync = Boolean.valueOf(tempval).booleanValue();
                continue;
            }
            if (key.equals("user_name")) {
                userName = null;
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                userName = tempval;
                continue;
            }
            if (key.equals("media_user_name")) {
                mediaUserName = null;
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                mediaUserName = tempval;
                continue;
            }
            if (key.equals("media_password")) {
                mediaPassword = null;
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                mediaPassword = tempval;
                continue;
            }
            if (key.equals("device-name")) {
                deviceName = null;
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                deviceName = tempval;
                continue;
            }
            if (key.equals("cloud_name")) {
                cloudName = null;
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                cloudName = tempval;
                continue;
            }
            if (key.equals("reg_id")) {
                regristrationID = null;
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                regristrationID = tempval;
                continue;
            }
            if (key.equals("parablu-folder")) {
                parabluSyncFolder = null;
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                parabluSyncFolder = tempval;
                continue;
            }
            if (key.equals("mediaHubDrive")) {
                webdevDrive = null;
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                webdevDrive = tempval;
                continue;
            }
            if (key.equals("music")) {
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION) || !tempval.equals(TRUE_VALUE_STRING_REPRESENTATION) && !tempval.equals("false")) {
                    return false;
                }
                tempEnableMusicMediaSync = enableMusicMediaSync = Boolean.valueOf(tempval).booleanValue();
                continue;
            }
            if (key.equals("mediaHub")) {
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION) || !tempval.equals(TRUE_VALUE_STRING_REPRESENTATION) && !tempval.equals("false")) {
                    return false;
                }
                mediaHubEnabled = Boolean.valueOf(tempval);
                continue;
            }
            if (key.equals("video")) {
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION) || !tempval.equals(TRUE_VALUE_STRING_REPRESENTATION) && !tempval.equals("false")) {
                    return false;
                }
                tempEnableVideosMediaSync = enableVideosMediaSync = Boolean.valueOf(tempval).booleanValue();
                continue;
            }
            if (key.equals("picture")) {
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION) || !tempval.equals(TRUE_VALUE_STRING_REPRESENTATION) && !tempval.equals("false")) {
                    return false;
                }
                tempEnablePicturesMediaSync = enablePicturesMediaSync = Boolean.valueOf(tempval).booleanValue();
                continue;
            }
            if (key.equals(DEVICE_UUID)) {
                deviceUUId = null;
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                deviceUUId = tempval;
                continue;
            }
            if (key.equals(RESTORE_ENABLED)) {
                restoreEnabled = "false";
                if (tempval == null || tempval.equals("false")) continue;
                restoreEnabled = tempval;
                continue;
            }
            if (key.equals(ISEXTERNAL_RESTORE_SELECTED)) {
                isExternalStorageSelected = "false";
                if (tempval == null || tempval.equals("false")) continue;
                isExternalStorageSelected = tempval;
                continue;
            }
            if (key.equals("uiVersion")) {
                uiVersion = 1;
                if (tempval == null) continue;
                uiVersion = Integer.valueOf(tempval);
                continue;
            }
            if (key.equals(SERVER_BACKUP_LICENSED)) {
                serverBackupLicensed = "false";
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                serverBackupLicensed = tempval;
                continue;
            }
            if (key.equals(AGENT_BACKUP_UI_PERMISSIONS)) {
                endpointBackupUiDetails = null;
                if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
                endpointBackupUiDetails = tempval;
                continue;
            }
            if (!key.equals(AGENT_SYNC_UI_PERMISSIONS)) continue;
            endpointSyncUiDetails = null;
            if (tempval == null || tempval.equals(NULL_STRING_REPRESENTATION)) continue;
            endpointSyncUiDetails = tempval;
        }
        SettingHelper.refresh();
        return success;
    }

    public static boolean resetSharedPreferences() {
        return SettingHelper.resetCommonSettings() && SettingHelper.resetIpSettings();
    }

    private static boolean resetCommonSettings() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("enable_dod", String.valueOf(false));
        map.put("enable_blusync", String.valueOf(true));
        map.put("enable_selective_sync", String.valueOf(false));
        map.put("timer_count", String.valueOf(5));
        map.put("enable_system_folder_sync", String.valueOf(false));
        map.put("user_name", NULL_STRING_REPRESENTATION);
        map.put("media_user_name", NULL_STRING_REPRESENTATION);
        map.put("media_password", NULL_STRING_REPRESENTATION);
        map.put("cloud_name", NULL_STRING_REPRESENTATION);
        map.put("reg_id", NULL_STRING_REPRESENTATION);
        map.put("parablu-folder", NULL_STRING_REPRESENTATION);
        map.put("auto_back", String.valueOf(false));
        map.put("backup_interval", String.valueOf(60L));
        map.put("device-name", NULL_STRING_REPRESENTATION);
        map.put(SYNC_LICENCED, NULL_STRING_REPRESENTATION);
        map.put(BACKUP_LICENCED, NULL_STRING_REPRESENTATION);
        map.put(MAP_KEY_LDAP_ENABLED, "false");
        map.put(DEVICE_UUID, NULL_STRING_REPRESENTATION);
        map.put(RESTORE_ENABLED, "false");
        map.put(ISEXTERNAL_RESTORE_SELECTED, "false");
        map.put(ISBACKUP_POLICY_EBABLED, "false");
        map.put("uiVersion", "1");
        map.put(SERVER_BACKUP_LICENSED, NULL_STRING_REPRESENTATION);
        SharedPreferences sp = new SharedPreferences(sharedPreferencesUrl);
        boolean success = sp.setData(map);
        if (success) {
            success = SettingHelper.readCommonDetails();
        }
        return success;
    }

    public static String getUserSettingsFile() {
        String userSettingsFile = SettingHelper.getUserHome() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "AppData" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "Roaming" + StringLiterals.CONSTANTS_FILE_SEPARATOR + PARABLU + StringLiterals.CONSTANTS_FILE_SEPARATOR + BLUSYNC + StringLiterals.CONSTANTS_FILE_SEPARATOR + "settings" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "UserSetting.pbs";
        return userSettingsFile;
    }

    public static void deleteParaBluFolderPathTempFile() {
        String tempFile = SettingHelper.getUserHome() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "AppData" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "Roaming" + StringLiterals.CONSTANTS_FILE_SEPARATOR + PARABLU + StringLiterals.CONSTANTS_FILE_SEPARATOR + BLUSYNC + StringLiterals.CONSTANTS_FILE_SEPARATOR + "settings" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBluFolderPath.txt";
        File file = new File(tempFile);
        file.delete();
    }

    public static void deleteNotSyncedFile() {
        String parabluBaseAppDataFolderUrl = SettingHelper.getParabluBlusyncAppDataFolderUrl();
        String notSyncedFile = parabluBaseAppDataFolderUrl + StringLiterals.CONSTANTS_FILE_SEPARATOR + "settings" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "SyncedFilesPaths.txt";
        File file = new File(notSyncedFile);
        file.delete();
    }

    public static void resetBackupNotifications() {
        NotificationHelper.setBackUpStarted(false);
        NotificationHelper.setBackupChunkFileDetails("");
        NotificationHelper.setBackupFileChunkingStatus("");
    }

    public static synchronized boolean applyChangesToSharedPreferences(boolean saveAllSettings) {
        return saveAllSettings ? SettingHelper.applyChangesForIpSettings() && SettingHelper.applychangesForCommonDetails() : SettingHelper.applyChangesForIpSettings();
    }

    private static boolean applychangesForCommonDetails() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("music", String.valueOf(tempEnableMusicMediaSync));
        map.put("picture", String.valueOf(tempEnablePicturesMediaSync));
        map.put("enable_blusync", String.valueOf(tempEnableBlusync));
        map.put("video", String.valueOf(tempEnableVideosMediaSync));
        map.put("timer_count", String.valueOf(tempCheckParacloudForUpdateTimerInMins));
        map.put("auto_back", String.valueOf(tempEnableAutomaticBackUp));
        map.put("backup_interval", String.valueOf(tempBackUpIntervalInMins));
        map.put("mediaHub", String.valueOf(mediaHubEnabled));
        map.put("mediaHubDrive", String.valueOf(webdevDrive));
        map.put("user_name", userName);
        map.put("media_user_name", mediaUserName);
        map.put("media_password", mediaPassword);
        map.put("device-name", deviceName);
        map.put("cloud_name", cloudName);
        map.put("reg_id", regristrationID);
        map.put("local_ip", localIpAddress);
        map.put("public_ip", publicIpAddress);
        map.put("gae_local_ip", gaeLocalIpAddress);
        map.put("working_cloud_ip", currentCloudIpAddress);
        map.put("working_cloud_ip", currentCloudIpAddress);
        map.put("http_port", httpPort);
        map.put("https_port", httpsPort);
        map.put(CURRENT_PORT, currentHttpsPort);
        map.put("parablu-folder", parabluSyncFolder);
        map.put(SYNC_LICENCED, syncLicenced);
        map.put(BACKUP_LICENCED, backupLicenced);
        map.put(DEVICE_UUID, deviceUUId);
        map.put(RESTORE_ENABLED, restoreEnabled);
        map.put(ISEXTERNAL_RESTORE_SELECTED, isExternalStorageSelected);
        map.put("uiVersion", String.valueOf(uiVersion));
        map.put(SERVER_BACKUP_LICENSED, serverBackupLicensed);
        map.put(AGENT_BACKUP_UI_PERMISSIONS, endpointBackupUiDetails);
        map.put(AGENT_SYNC_UI_PERMISSIONS, endpointSyncUiDetails);
        SharedPreferences sp = new SharedPreferences(sharedPreferencesUrl);
        boolean success = sp.setData(map);
        if (success) {
            success = SettingHelper.readCommonDetails();
        }
        return success;
    }

    private static boolean applyChangesForIpSettings() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("local_ip", localIpAddress);
        map.put("public_ip", publicIpAddress);
        map.put("gae_local_ip", gaeLocalIpAddress);
        map.put("working_cloud_ip", currentCloudIpAddress);
        map.put("working_cloud_ip", currentCloudIpAddress);
        map.put("http_port", httpPort);
        map.put("https_port", httpsPort);
        map.put(CURRENT_PORT, currentHttpsPort);
        SharedPreferences sp = new SharedPreferences(ipSettingsUrl);
        boolean success = sp.setDataUnencrypted(map);
        if (success) {
            success = SettingHelper.readIpSettings();
        }
        return success;
    }

    public static void createParaBluPathFile() throws IOException {
        String tempFile = SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "settings" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBluFolderPath.txt";
        File file = new File(tempFile);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        if (parabluSyncFolder.endsWith("\\")) {
            parabluSyncFolder = parabluSyncFolder.substring(0, parabluSyncFolder.length() - 1);
        }
        bw.write(parabluSyncFolder);
        bw.close();
    }

    public static void initiateAndCreateDatabases() {
        ActivityHistoryImpl activityHistory = new ActivityHistoryImpl(activityDBUrl);
        DodTableImpl dodTable = new DodTableImpl(dodTableDBUrl);
        DownloadTableImpl downloadTable = new DownloadTableImpl(downloadTableDBUrl);
        UploadTableImpl uploadTable = new UploadTableImpl(uploadTableDBUrl);
        BackUpFolderDAOImpl backUpFolderDAOImpl = new BackUpFolderDAOImpl(backUpDbUrl);
        BackUpImageDAOImpl backUpImageDAOImpl = new BackUpImageDAOImpl(backUpDbUrl);
        MediaFolderDAOImpl mediaFolderDAOImpl = new MediaFolderDAOImpl(mediaDbUrl);
        MediaImageDAOImpl mediaImageDAOImpl = new MediaImageDAOImpl(mediaDbUrl);
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(activityDBUrl);
        backupActivityHistoryDAOImpl.createBackupActivityHistoryDB();
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(backUpDbUrl);
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(activityDBUrl);
        BackupCrawlDAOImpl backupCrawlDAOImpl = new BackupCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
        FolderDaoImpl folderImpl = new FolderDaoImpl(SettingHelper.getFolderDBUrl());
        BackupStatisticsDAOImpl backupStatisticsDAOImpl = new BackupStatisticsDAOImpl(backUpDbUrl);
        SyncPolicyDAOImpl syncPolicyDAOImpl = new SyncPolicyDAOImpl(syncDbUrl);
        activityHistory.createActivityHistoryDB();
        dodTable.createDodTable();
        downloadTable.createDownloadTable();
        uploadTable.createUploadTable();
        backUpImageDAOImpl.createTable();
        backUpFolderDAOImpl.createBackUpTable();
        mediaImageDAOImpl.createTable();
        mediaFolderDAOImpl.createMediaTable();
        backupPolicyDAOImpl.createBackupPolicyTable();
        restoreActivityHistoryDAOImpl.createRestoreActivityHistoryDB();
        backupPolicyDAOImpl.createInclusionsTable();
        backupPolicyDAOImpl.createNetworkThrottlingTable();
        backupPolicyDAOImpl.createPrivacyGatewayTable();
        backupPolicyDAOImpl.createDeviceBackupLicenseTable();
        backupPolicyDAOImpl.createSchedulesTable();
        backupCrawlDAOImpl.createBackUpCrawlTable();
        backupPolicyDAOImpl.createBackupPolicyDefaultFoldersTable();
        backupStatisticsDAOImpl.createBackupStatisticsTable();
        backupPolicyDAOImpl.createPolicyExcludedFolderTable();
        backupPolicyDAOImpl.createEBMSTable();
        backUpFolderDAOImpl.createCalloutScriptTable();
        backUpFolderDAOImpl.createFullBackupScheduleTable();
        backupPolicyDAOImpl.creatContainerTable();
        syncPolicyDAOImpl.createSyncPolicyTable();
        syncPolicyDAOImpl.createInclusionsTable();
        syncPolicyDAOImpl.createShareTable();
        backupCrawlDAOImpl.createSnapshotCrawlTable();
        folderImpl.createFolderDB();
    }

    public static List<BkPolicyFolderPathElement> getBackupPolicyFoldersList() {
        return backupPolicyFoldersList;
    }

    public static void setBackupPolicyFoldersList(List<BkPolicyFolderPathElement> backupPolicyFoldersList) {
        SettingHelper.backupPolicyFoldersList = backupPolicyFoldersList;
    }

    public static long loadLastSuccessfulCrawl() {
        ActivityHistoryImpl activityHistoryImpl = new ActivityHistoryImpl(SettingHelper.getActivityDBUrl());
        ActivityTO activityTO = activityHistoryImpl.getlastSuccessfullEntryFromActivityHistoryTable();
        if (activityTO == null || activityTO.getActivityTimeStamp() == null) {
            return 0L;
        }
        return activityTO.getActivityTimeStamp().getTime();
    }

    public static void refresh() {
        logger.debug("Refreshing initial values");
        tempCheckParacloudForUpdateTimerInMins = checkParacloudForUpdateTimerInMins;
        tempEnableBlusync = enableBlusync;
        tempEnableMusicMediaSync = enableMusicMediaSync;
        tempEnablePicturesMediaSync = enablePicturesMediaSync;
        tempEnableVideosMediaSync = enableVideosMediaSync;
        tempEnableAutomaticBackUp = enableAutomaticBackUp;
        tempBackUpIntervalInMins = backUpIntervalInMins;
        if (TRUE_VALUE_STRING_REPRESENTATION.equalsIgnoreCase(SettingHelper.getBackupLicenced())) {
            tempEnableAutomaticBackUp = true;
            enableAutomaticBackUp = true;
        }
    }

    public static String getBaseDBUrl() {
        return baseDBUrl;
    }

    public static void setBaseDBUrl(String baseDBUrl) {
        SettingHelper.baseDBUrl = baseDBUrl;
    }

    public static String getActivityDBUrl() {
        return activityDBUrl;
    }

    public static void setActivityDBUrl(String activityDBUrl) {
        SettingHelper.activityDBUrl = activityDBUrl;
    }

    public static String getCurrentHttpsPort() {
        return currentHttpsPort;
    }

    public static void setCurrentHttpsPort(String currentHttpsPort) {
        SettingHelper.currentHttpsPort = currentHttpsPort;
    }

    public static String getFolderDBUrl() {
        return folderDBUrl;
    }

    public static void setFolderDBUrl(String folderDBUrl) {
        SettingHelper.folderDBUrl = folderDBUrl;
    }

    public static String getSyncedFilesDBUrl() {
        return syncedFilesDBUrl;
    }

    public static void setSyncedFilesDBUrl(String syncedFilesDBUrl) {
        SettingHelper.syncedFilesDBUrl = syncedFilesDBUrl;
    }

    public static String getImageTableHistoryDBUrl() {
        return imageTableHistoryDBUrl;
    }

    public static void setImageTableHistoryDBUrl(String imageTableHistoryDBUrl) {
        SettingHelper.imageTableHistoryDBUrl = imageTableHistoryDBUrl;
    }

    public static String getDownloadTableDBUrl() {
        return downloadTableDBUrl;
    }

    public static void setDownloadTableDBUrl(String downloadTableDBUrl) {
        SettingHelper.downloadTableDBUrl = downloadTableDBUrl;
    }

    public static String getUploadTableDBUrl() {
        return uploadTableDBUrl;
    }

    public static void setUploadTableDBUrl(String uploadTableDBUrl) {
        SettingHelper.uploadTableDBUrl = uploadTableDBUrl;
    }

    public static String getDodTableDBUrl() {
        return dodTableDBUrl;
    }

    public static void setDodTableDBUrl(String dodTableDBUrl) {
        SettingHelper.dodTableDBUrl = dodTableDBUrl;
    }

    public static String getSharedPreferencesUrl() {
        return sharedPreferencesUrl;
    }

    public static void setSharedPreferencesUrl(String sharedPreferencesUrl) {
        SettingHelper.sharedPreferencesUrl = sharedPreferencesUrl;
    }

    public static String getUserHome() {
        return userHome;
    }

    public static void setUserHome(String userHome) {
        SettingHelper.userHome = userHome;
    }

    public static boolean isEnableBlusync() {
        return enableBlusync;
    }

    public static String getMediaUserName() {
        return mediaUserName;
    }

    public static void setMediaUserName(String mediaUserName) {
        SettingHelper.mediaUserName = mediaUserName;
    }

    public static String getMediaPassword() {
        return mediaPassword;
    }

    public static void setMediaPassword(String mediaPassword) {
        SettingHelper.mediaPassword = mediaPassword;
    }

    public static boolean isEnableMusicMediaSync() {
        return enableMusicMediaSync;
    }

    public static boolean isEnableVideosMediaSync() {
        return enableVideosMediaSync;
    }

    public static boolean isEnablePicturesMediaSync() {
        return enablePicturesMediaSync;
    }

    public static int getCheckParacloudForUpdateTimerInMins() {
        return checkParacloudForUpdateTimerInMins;
    }

    public static String getUserName() {
        return userName;
    }

    public static String getHttpPort() {
        return httpPort;
    }

    public static void setHttpPort(String httpPort) {
        SettingHelper.httpPort = httpPort;
    }

    public static String getHttpsPort() {
        return httpsPort;
    }

    public static void setHttpsPort(String httpsPort) {
        SettingHelper.httpsPort = httpsPort;
    }

    public static String getCloudName() {
        return cloudName;
    }

    public static String getRegristrationID() {
        return regristrationID;
    }

    public static void setUserName(String setUserName) {
        userName = setUserName;
    }

    public static void setCloudName(String setCloudName) {
        cloudName = setCloudName;
    }

    public static void setRegristrationID(String setRegristrationID) {
        regristrationID = setRegristrationID;
    }

    public static void setTempEnableBlusync(boolean setTempEnableBlusync) {
        tempEnableBlusync = setTempEnableBlusync;
    }

    public static void setTempEnableMusicMediaSync(boolean tempEnableMusicMediaSync) {
        SettingHelper.tempEnableMusicMediaSync = tempEnableMusicMediaSync;
    }

    public static void setTempEnableVideosMediaSync(boolean tempEnableVideosMediaSync) {
        SettingHelper.tempEnableVideosMediaSync = tempEnableVideosMediaSync;
    }

    public static void setTempEnablePicturesMediaSync(boolean tempEnablePicturesMediaSync) {
        SettingHelper.tempEnablePicturesMediaSync = tempEnablePicturesMediaSync;
    }

    public static void setTempCheckParacloudForUpdateTimerInMins(int setTempCheckParacloudForUpdateTimerInSeconds) {
        tempCheckParacloudForUpdateTimerInMins = setTempCheckParacloudForUpdateTimerInSeconds;
    }

    public static String getLocalIpAddress() {
        return localIpAddress;
    }

    public static void setLocalIpAddress(String localIpAddress) {
        SettingHelper.localIpAddress = localIpAddress;
    }

    public static String getPublicIpAddress() {
        return publicIpAddress;
    }

    public static void setPublicIpAddress(String publicIpAddress) {
        SettingHelper.publicIpAddress = publicIpAddress;
    }

    public static String getGaeLocalIpAddress() {
        return gaeLocalIpAddress;
    }

    public static void setGaeLocalIpAddress(String gaeLocalIpAddress) {
        SettingHelper.gaeLocalIpAddress = gaeLocalIpAddress;
    }

    public static boolean isTempEnableBlusync() {
        return tempEnableBlusync;
    }

    public static boolean isTempEnableMusicMediaSync() {
        return tempEnableMusicMediaSync;
    }

    public static boolean isTempEnableVideosMediaSync() {
        return tempEnableVideosMediaSync;
    }

    public static boolean isTempEnablePicturesMediaSync() {
        return tempEnablePicturesMediaSync;
    }

    public static int getTempCheckParacloudForUpdateTimerInMins() {
        return tempCheckParacloudForUpdateTimerInMins;
    }

    public static String getCurrentCloudIpAddress() {
        return currentCloudIpAddress;
    }

    public static void setCurrentCloudIpAddress(String currentCloudIpAddress) {
        SettingHelper.currentCloudIpAddress = currentCloudIpAddress;
    }

    public static String getParabluTempUploadFolder() {
        return parabluTempUploadFolder;
    }

    public static void setParabluTempUploadFolder(String parabluTempUploadFolder) {
        SettingHelper.parabluTempUploadFolder = parabluTempUploadFolder;
    }

    public static String getParabluTempDownloadFolder() {
        return parabluTempDownloadFolder;
    }

    public static void setParabluTempDownloadFolder(String parabluTempDownloadFolder) {
        SettingHelper.parabluTempDownloadFolder = parabluTempDownloadFolder;
    }

    public static String getCrawlGzipFolder() {
        return crawlGzipFolder;
    }

    public static void setCrawlGzipFolder(String crawlGzipFolder) {
        SettingHelper.crawlGzipFolder = crawlGzipFolder;
    }

    public static String getParabluSyncFolder() {
        return parabluSyncFolder;
    }

    public static void setParabluSyncFolder(String parabluSyncFolder) {
        SettingHelper.parabluSyncFolder = parabluSyncFolder;
    }

    public static String getUpdateDownloadURL() {
        return updateDownloadURL;
    }

    public static void setUpdateDownloadURL(String updateDownloadURL) {
        SettingHelper.updateDownloadURL = updateDownloadURL;
    }

    public static synchronized boolean isLicenseActive() {
        return licenseActive;
    }

    public static synchronized void setLicenseActive(boolean licenseActive) {
        SettingHelper.licenseActive = licenseActive;
    }

    public static synchronized String getTokenFileUrl() {
        return tokenFileUrl;
    }

    public static synchronized void setTokenFileUrl(String tokenFileUrl) {
        SettingHelper.tokenFileUrl = tokenFileUrl;
    }

    public static synchronized boolean isDeviceBlocked() {
        return deviceBlocked;
    }

    public static synchronized void setDeviceBlocked(boolean deviceBlocked) {
        SettingHelper.deviceBlocked = deviceBlocked;
    }

    public static synchronized String getBackUpDbUrl() {
        return backUpDbUrl;
    }

    public static synchronized String getMediaDbUrl() {
        return mediaDbUrl;
    }

    public static synchronized void setBackUpDbUrl(String backUpDbUrl) {
        SettingHelper.backUpDbUrl = backUpDbUrl;
    }

    public static synchronized void setMediaDbUrl(String mediaDbUrl) {
        SettingHelper.mediaDbUrl = mediaDbUrl;
    }

    public static synchronized void setTempEnableAutomaticBackUp(boolean tempEnableAutomaticBackUp) {
        SettingHelper.tempEnableAutomaticBackUp = tempEnableAutomaticBackUp;
    }

    public static synchronized void setTempBackUpIntervalInMins(int tempBackUpIntervalInSeconds) {
        tempBackUpIntervalInMins = tempBackUpIntervalInSeconds;
    }

    public static synchronized boolean isEnableAutomaticBackUp() {
        return enableAutomaticBackUp;
    }

    public static String getIpSettingsUrl() {
        return ipSettingsUrl;
    }

    public static void setIpSettingsUrl(String ipSettingsUrl) {
        SettingHelper.ipSettingsUrl = ipSettingsUrl;
    }

    public static synchronized int getBackUpIntervalInMins() {
        return backUpIntervalInMins;
    }

    public static String getParabluBaseAppDataFolderUrl() {
        return parabluBaseAppDataFolderUrl;
    }

    public static void setParabluBaseAppDataFolderUrl(String parabluBaseAppDataFolderUrl) {
        SettingHelper.parabluBaseAppDataFolderUrl = parabluBaseAppDataFolderUrl;
    }

    public static String getDeviceName() {
        return deviceName;
    }

    public static void setDeviceName(String deviceName) {
        SettingHelper.deviceName = deviceName;
    }

    public static synchronized boolean isTempEnableAutomaticBackUp() {
        return tempEnableAutomaticBackUp;
    }

    public static String getIconPath() {
        return iconPath;
    }

    public static void setIconPath(String iconPath) {
        SettingHelper.iconPath = iconPath;
    }

    public static void checkAndUpdateIpAddress() throws CrawlAdapterException {
        CloudIPHelper crs = new CloudIPHelper(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        if (!crs.searchForPublicIpOfCloud()) {
            if (!StringUtils.isEmpty((String)PropertyHelper.MAIN_EBMS_DOMAIN)) {
                BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
                String bluVaultIP = bluVaultIPHelper.getNearestBluVaultByResponseTime();
                if (!StringUtils.isEmpty((String)bluVaultIP)) {
                    SettingHelper.setGaeLocalIpAddress(bluVaultIP);
                    SettingHelper.setPublicIpAddress(bluVaultIP);
                    SettingHelper.setCurrentCloudIpAddress(bluVaultIP);
                    SettingHelper.applyChangesToSharedPreferences(false);
                }
                return;
            }
            logger.debug("Cloud Error; Searching For Public IP Of Cloud");
            throw new CrawlAdapterException("Http Exception occurred,probrably no internet connection");
        }
        SettingHelper.setGaeLocalIpAddress(crs.getGaeCloudLocalIP());
        SettingHelper.setPublicIpAddress(crs.getCloudPublicIP());
        SettingHelper.setHttpPort(crs.getHttpPort());
        SettingHelper.setHttpsPort(crs.getHttpsPort());
        SettingHelper.applyChangesToSharedPreferences(false);
    }

    public static String createUserValidityFilePath() {
        String userValidityFilePath = SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "settings" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "UserValidityFile.txt";
        return userValidityFilePath;
    }

    public static String createUserNotValidFilePath() {
        String userValidityFilePath = SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "settings" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "UserNotValidFile.txt";
        return userValidityFilePath;
    }

    public static void deleteUserValidityFilePath() {
        String tempFile = SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "settings" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "UserValidityFile.txt";
        File file = new File(tempFile);
        file.delete();
    }

    public static String getSyncedFilesPath() {
        String syncedFilesPath = SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "settings" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "SyncedFilesPaths.txt";
        return syncedFilesPath;
    }

    public static void setBackupFolderTOsExistingFolderPaths(Set<BackupFolderTO> backupFolderTOsExistingFolderPaths) {
        backupFolderTOsExistingFolderPathsHolder = backupFolderTOsExistingFolderPaths;
    }

    public static Set<BackupFolderTO> getBackupFolderTOsExistingFolderPaths() {
        return backupFolderTOsExistingFolderPathsHolder;
    }

    public static void setAddPreConfiguredFoldersForBackup() {
        addPreConfiguredFoldersForBackup = true;
    }

    public static boolean getAddPreConfiguredFoldersForBackup() {
        return addPreConfiguredFoldersForBackup;
    }

    public static void saveBackedUpFodlersList(List<FileElement> listFileElement) {
        backedUpFoldersList = listFileElement;
    }

    public static List<FileElement> getBackedUpFoldersList() {
        return backedUpFoldersList;
    }

    public static void setLastSuccessfulBackup(long currentTimeMillis) {
        lastSuccessfulBackup = currentTimeMillis;
    }

    public static long getLastSuccessfulBackup() {
        return lastSuccessfulBackup;
    }

    public static long loadLastSuccessfullBackup() {
        BackupActivityHistoryDAOImpl activityHistoryImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        BackupActivityTO activityTO = activityHistoryImpl.getlastSuccessfullEntryFromBackupActivityHistoryTable();
        if (activityTO == null || activityTO.getBackupActivityTimeStamp() == null) {
            return 0L;
        }
        return Long.valueOf(activityTO.getBackupActivityTimeStamp());
    }

    public static String getKeystorePath() {
        return keystorePath;
    }

    public static void setKeystorePath(String keystorePath) {
        SettingHelper.keystorePath = keystorePath;
    }

    public static void setWebdevDrive(String webdevDriveLetter) {
        logger.debug("Selected webdevDriveLetter: " + webdevDriveLetter);
        webdevDrive = webdevDriveLetter;
    }

    public static String getWebdevDrive() {
        return webdevDrive;
    }

    public static void createTokenFile(String token) throws IOException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] b = token.getBytes("UTF-8");
        File file = new File(SettingHelper.getTokenFileUrl());
        Cipher cipher = CipherHelper.encryptionCipher();
        if (file.exists()) {
            file.delete();
        }
        new File(file.getParent()).mkdirs();
        file.createNewFile();
        try (CipherOutputStream co = new CipherOutputStream(new FileOutputStream(file), cipher);){
            co.write(b);
            co.close();
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFoundException while CipherOutputStream", (Throwable)e);
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            logger.error("IOException CipherOutputStream", (Throwable)e);
            throw new IOException();
        }
    }

    public static String getBaseChunkFolderUrl() {
        return baseChunkFolderUrl;
    }

    public static void setBaseChunkFolderUrl(String baseChunkFolderUrl) {
        SettingHelper.baseChunkFolderUrl = baseChunkFolderUrl;
    }

    public static String getDeviceUUId() {
        return deviceUUId;
    }

    public static void setDeviceUUId(String deviceUUId) {
        SettingHelper.deviceUUId = deviceUUId;
    }

    public static String getRestoreEnabled() {
        return restoreEnabled;
    }

    public static void setRestoreEnabled(String restoreEnabled) {
        SettingHelper.restoreEnabled = restoreEnabled;
    }

    public static String getBackUpCrawlDbUrl() {
        return backUpCrawlDbUrl;
    }

    public static void setBackUpCrawlDbUrl(String backUpCrawlDbUrl) {
        SettingHelper.backUpCrawlDbUrl = backUpCrawlDbUrl;
    }

    public static String getIsExternalStorageSelected() {
        return isExternalStorageSelected;
    }

    public static void setIsExternalStorageSelected(String isExternalStorageSelected) {
        SettingHelper.isExternalStorageSelected = isExternalStorageSelected;
    }

    public static void alterTables() {
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(backUpDbUrl);
        BackUpFolderDAOImpl backUpFolderDAOImpl = new BackUpFolderDAOImpl(backUpDbUrl);
        BackupCrawlDAOImpl backupCrawlDAOImpl = new BackupCrawlDAOImpl(backUpCrawlDbUrl);
        BackupActivityHistoryDAOImpl activityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(activityDBUrl);
        SyncPolicyDAOImpl syncPolicyDAOImpl = new SyncPolicyDAOImpl(syncDbUrl);
        try {
            backupPolicyDAOImpl.alterTable();
            backupCrawlDAOImpl.alterTable();
            activityHistoryDAOImpl.alterTable();
            backUpFolderDAOImpl.newAlterTable();
            syncPolicyDAOImpl.alterTable();
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("error in alter table " + e.getMessage());
        }
    }

    public static long getNextBackupTimeStamp() {
        return nextBackupTimeStamp;
    }

    public static void setNextBackupTimeStamp(long nextBackupTimeStamp) {
        SettingHelper.nextBackupTimeStamp = nextBackupTimeStamp;
    }

    public static int getTempPolicyRefreshIntervalInMins() {
        return tempPolicyRefreshIntervalInMins;
    }

    public static void setTempPolicyRefreshIntervalInMins(int tempPolicyRefreshIntervalInMins) {
        SettingHelper.tempPolicyRefreshIntervalInMins = tempPolicyRefreshIntervalInMins;
    }

    public static String getIsStatisticsEnabled() {
        return isStatisticsEnabled;
    }

    public static void setIsStatisticsEnabled(String isStatisticsEnabled) {
        SettingHelper.isStatisticsEnabled = isStatisticsEnabled;
    }

    public static int getStatisticsRefreshIntervalInMins() {
        return statisticsRefreshIntervalInMins;
    }

    public static void setStatisticsRefreshIntervalInMins(int statisticsRefreshIntervalInMins) {
        SettingHelper.statisticsRefreshIntervalInMins = statisticsRefreshIntervalInMins;
    }

    public static long getUserMaxStorageLimit() {
        return userMaxStorageLimit;
    }

    public static void setUserMaxStorageLimit(long userMaxStorageLimit) {
        SettingHelper.userMaxStorageLimit = userMaxStorageLimit;
    }

    public static int getMaxVersionsToKeep() {
        return maxVersionsToKeep;
    }

    public static void setMaxVersionsToKeep(int maxVersionsToKeep) {
        SettingHelper.maxVersionsToKeep = maxVersionsToKeep;
    }

    public static boolean isDCMEnabled() {
        return isDCMEnabled;
    }

    public static void setDCMEnabled(boolean isDCMEnabled) {
        SettingHelper.isDCMEnabled = isDCMEnabled;
    }

    public static String getBackupCrawlLimit() {
        return backupCrawlLimit;
    }

    public static void setBackupCrawlLimit(String backupCrawlLimit) {
        SettingHelper.backupCrawlLimit = backupCrawlLimit;
    }

    public static String loadBackupCrawlLimit() {
        String crawlLimit = "";
        BackupPolicyTO currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        if (currentPolicy != null) {
            crawlLimit = currentPolicy.getCrawlLimit();
        }
        return crawlLimit;
    }

    public static String loadIsVssEnabled() {
        String vssEnabled = "false";
        BackupPolicyTO currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        if (currentPolicy != null) {
            vssEnabled = currentPolicy.getVssEnabled();
        }
        if (vssEnabled == null) {
            vssEnabled = "false";
        }
        return vssEnabled;
    }

    public static String loadStatisticsEnabled() {
        String isStatisticsEnabled = "false";
        return isStatisticsEnabled;
    }

    public static String getProductVersion() {
        return productVersion;
    }

    public static void setProductVersion(String productVersion) {
        SettingHelper.productVersion = productVersion;
    }

    public static String getIsLegalHoldEnabled() {
        return isLegalHoldEnabled;
    }

    public static void setIsLegalHoldEnabled(String isLegalHoldEnabled) {
        SettingHelper.isLegalHoldEnabled = isLegalHoldEnabled;
    }

    public static GatewayTO getSyncUploadIpAddress() {
        return syncUploadIpAddress;
    }

    public static void setSyncUploadIpAddress(GatewayTO syncUploadIpAddress) {
        SettingHelper.syncUploadIpAddress = syncUploadIpAddress;
    }

    public static String getServerBackupLicensed() {
        return serverBackupLicensed;
    }

    public static void setServerBackupLicensed(String serverBackupLicensed) {
        SettingHelper.serverBackupLicensed = serverBackupLicensed;
    }

    public static String getSystemIP() {
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
            logger.debug("Current IP address : " + ip.getHostAddress());
        }
        catch (UnknownHostException e) {
            logger.trace("" + e);
            logger.error("error in geting the system IP" + e.getMessage());
        }
        if (ip != null) {
            return ip.getHostAddress();
        }
        return "localhost";
    }

    public static String getSyncdburl() {
        return syncDbUrl;
    }

    public static void setSyncDbUrl(String syncDbUrl) {
        SettingHelper.syncDbUrl = syncDbUrl;
    }

    public static int getPolicySyncInterval() {
        return policySyncInterval;
    }

    public static void setPolicySyncInterval(int policySyncInterval) {
        SettingHelper.policySyncInterval = policySyncInterval;
    }

    public static boolean isRestoreInterfaceEnabled() {
        return restoreInterfaceEnabled;
    }

    public static void setRestoreInterfaceEnabled(boolean restoreInterfaceEnabled) {
        SettingHelper.restoreInterfaceEnabled = restoreInterfaceEnabled;
    }

    public static boolean isStopBackupInterfaceEnabled() {
        return stopBackupInterfaceEnabled;
    }

    public static void setStopBackupInterfaceEnabled(boolean stopBackupInterfaceEnabled) {
        SettingHelper.stopBackupInterfaceEnabled = stopBackupInterfaceEnabled;
    }

    public static boolean isBackupSettingsInterfaceEnabled() {
        return backupSettingsInterfaceEnabled;
    }

    public static void setBackupSettingsInterfaceEnabled(boolean backupSettingsInterfaceEnabled) {
        SettingHelper.backupSettingsInterfaceEnabled = backupSettingsInterfaceEnabled;
    }

    public static boolean isBackupFilesInterfaceEnabled() {
        return backupFilesInterfaceEnabled;
    }

    public static void setBackupFilesInterfaceEnabled(boolean backupFilesInterfaceEnabled) {
        SettingHelper.backupFilesInterfaceEnabled = backupFilesInterfaceEnabled;
    }

    public static boolean isRefreshBackupPolicyInterfaceEnabled() {
        return refreshBackupPolicyInterfaceEnabled;
    }

    public static void setRefreshBackupPolicyInterfaceEnabled(boolean refreshBackupPolicyInterfaceEnabled) {
        SettingHelper.refreshBackupPolicyInterfaceEnabled = refreshBackupPolicyInterfaceEnabled;
    }

    public static boolean isSyncNowInterfaceEnabled() {
        return syncNowInterfaceEnabled;
    }

    public static void setSyncNowInterfaceEnabled(boolean syncNowInterfaceEnabled) {
        SettingHelper.syncNowInterfaceEnabled = syncNowInterfaceEnabled;
    }

    public static boolean isSyncSettingsInterfaceEnabled() {
        return syncSettingsInterfaceEnabled;
    }

    public static void setSyncSettingsInterfaceEnabled(boolean syncSettingsInterfaceEnabled) {
        SettingHelper.syncSettingsInterfaceEnabled = syncSettingsInterfaceEnabled;
    }

    public static boolean isSyncFilesInterfaceEnabled() {
        return syncFilesInterfaceEnabled;
    }

    public static void setSyncFilesInterfaceEnabled(boolean syncFilesInterfaceEnabled) {
        SettingHelper.syncFilesInterfaceEnabled = syncFilesInterfaceEnabled;
    }

    public static boolean isRefreshSyncPolicyInterfaceEnabled() {
        return refreshSyncPolicyInterfaceEnabled;
    }

    public static void setRefreshSyncPolicyInterfaceEnabled(boolean refreshSyncPolicyInterfaceEnabled) {
        SettingHelper.refreshSyncPolicyInterfaceEnabled = refreshSyncPolicyInterfaceEnabled;
    }

    public static boolean isSearchInterfaceEnabled() {
        return searchInterfaceEnabled;
    }

    public static void setSearchInterfaceEnabled(boolean searchInterfaceEnabled) {
        SettingHelper.searchInterfaceEnabled = searchInterfaceEnabled;
    }

    public static boolean isOpenSyncFolderInterfaceEnabled() {
        return openSyncFolderInterfaceEnabled;
    }

    public static void setOpenSyncFolderInterfaceEnabled(boolean openSyncFolderInterfaceEnabled) {
        SettingHelper.openSyncFolderInterfaceEnabled = openSyncFolderInterfaceEnabled;
    }

    public static boolean isInitiateBackupInterfaceEnabled() {
        return initiateBackupInterfaceEnabled;
    }

    public static void setInitiateBackupInterfaceEnabled(boolean initiateBackupInterfaceEnabled) {
        SettingHelper.initiateBackupInterfaceEnabled = initiateBackupInterfaceEnabled;
    }

    public static String getEndpointBackupUiDetails() {
        return endpointBackupUiDetails;
    }

    public static void setEndpointBackupUiDetails(String endpointBackupUiDetails) {
        SettingHelper.endpointBackupUiDetails = endpointBackupUiDetails;
    }

    public static String getEndpointSyncUiDetails() {
        return endpointSyncUiDetails;
    }

    public static void setEndpointSyncUiDetails(String endpointSyncUiDetails) {
        SettingHelper.endpointSyncUiDetails = endpointSyncUiDetails;
    }

    public static boolean isExitBackupInterfaceEnabled() {
        return exitBackupInterfaceEnabled;
    }

    public static void setExitBackupInterfaceEnabled(boolean exitBackupInterfaceEnabled) {
        SettingHelper.exitBackupInterfaceEnabled = exitBackupInterfaceEnabled;
    }

    public static boolean isExitSyncInterfaceEnabled() {
        return exitSyncInterfaceEnabled;
    }

    public static void setExitSyncInterfaceEnabled(boolean exitSyncInterfaceEnabled) {
        SettingHelper.exitSyncInterfaceEnabled = exitSyncInterfaceEnabled;
    }

    public static boolean isDecoupleBackupInterfaceEnabled() {
        return decoupleBackupInterfaceEnabled;
    }

    public static void setDecoupleBackupInterfaceEnabled(boolean decoupleBackupInterfaceEnabled) {
        SettingHelper.decoupleBackupInterfaceEnabled = decoupleBackupInterfaceEnabled;
    }

    public static boolean isDecoupleSyncInterfaceEnabled() {
        return decoupleSyncInterfaceEnabled;
    }

    public static void setDecoupleSyncInterfaceEnabled(boolean decoupleSyncInterfaceEnabled) {
        SettingHelper.decoupleSyncInterfaceEnabled = decoupleSyncInterfaceEnabled;
    }

    public static boolean isSupportBackupInterfaceEnabled() {
        return supportBackupInterfaceEnabled;
    }

    public static void setSupportBackupInterfaceEnabled(boolean supportBackupInterfaceEnabled) {
        SettingHelper.supportBackupInterfaceEnabled = supportBackupInterfaceEnabled;
    }

    public static boolean isSupportSyncInterfaceEnabled() {
        return supportSyncInterfaceEnabled;
    }

    public static void setSupportSyncInterfaceEnabled(boolean supportSyncInterfaceEnabled) {
        SettingHelper.supportSyncInterfaceEnabled = supportSyncInterfaceEnabled;
    }

    public static boolean isBackuptoolTipNotificationBlocked() {
        return backuptoolTipNotificationBlocked;
    }

    public static void setBackuptoolTipNotificationBlocked(boolean backuptoolTipNotificationBlocked) {
        SettingHelper.backuptoolTipNotificationBlocked = backuptoolTipNotificationBlocked;
    }

    public static boolean isSynctoolTipNotificationBlocked() {
        return synctoolTipNotificationBlocked;
    }

    public static void setSynctoolTipNotificationBlocked(boolean synctoolTipNotificationBlocked) {
        SettingHelper.synctoolTipNotificationBlocked = synctoolTipNotificationBlocked;
    }

    public static String getOsVersion() {
        return osVersion;
    }

    public static void setOsVersion(String osVersion) {
        SettingHelper.osVersion = osVersion;
    }

    public static String getProgramFilesDir() {
        return programFilesDir;
    }

    public static void setProgramFilesDir(String programFilesDir) {
        SettingHelper.programFilesDir = programFilesDir;
    }

    public static String getInstallationDir() {
        return installationDir;
    }

    public static void setInstallationDir(String installationDir) {
        SettingHelper.installationDir = installationDir;
    }

    public static BackupPolicyTO getCurrentBackupPolicy() {
        if (currentBackupPolicy == null) {
            logger.debug("current backup policy is null so load it...");
            currentBackupPolicy = PolicyManagementServerHelper.getCurrentPolicy();
            logger.debug("current backup policy after loading..." + currentBackupPolicy);
        }
        return currentBackupPolicy;
    }

    public static void setCurrentBackupPolicy(BackupPolicyTO currentBackupPolicy) {
        SettingHelper.currentBackupPolicy = currentBackupPolicy;
    }

    public static boolean isPauseBackupInterfaceEnabled() {
        return pauseBackupInterfaceEnabled;
    }

    public static void setPauseBackupInterfaceEnabled(boolean pauseBackupInterfaceEnabled) {
        SettingHelper.pauseBackupInterfaceEnabled = pauseBackupInterfaceEnabled;
    }

    public static String getChunkDbUrl() {
        return chunkDbUrl;
    }

    public static void setChunkDbUrl(String chunkDbUrl) {
        SettingHelper.chunkDbUrl = chunkDbUrl;
    }

    public static boolean isUpdateAgentBackupInterfaceEnabled() {
        return updateAgentBackupInterfaceEnabled;
    }

    public static void setUpdateAgentBackupInterfaceEnabled(boolean updateAgentBackupInterfaceEnabled) {
        SettingHelper.updateAgentBackupInterfaceEnabled = updateAgentBackupInterfaceEnabled;
    }

    public static boolean isUpdateAgentSyncInterfaceEnabled() {
        return updateAgentSyncInterfaceEnabled;
    }

    public static void setUpdateAgentSyncInterfaceEnabled(boolean updateAgentSyncInterfaceEnabled) {
        SettingHelper.updateAgentSyncInterfaceEnabled = updateAgentSyncInterfaceEnabled;
    }

    public static boolean isAboutBackupInterfaceEnabled() {
        return aboutBackupInterfaceEnabled;
    }

    public static void setAboutBackupInterfaceEnabled(boolean aboutBackupInterfaceEnabled) {
        SettingHelper.aboutBackupInterfaceEnabled = aboutBackupInterfaceEnabled;
    }

    public static boolean isAboutSyncInterfaceEnabled() {
        return aboutSyncInterfaceEnabled;
    }

    public static void setAboutSyncInterfaceEnabled(boolean aboutSyncInterfaceEnabled) {
        SettingHelper.aboutSyncInterfaceEnabled = aboutSyncInterfaceEnabled;
    }

    public static boolean isBackupSystrayIconEnabled() {
        return backupSystrayIconEnabled;
    }

    public static void setBackupSystrayIconEnabled(boolean backupSystrayIconEnabled) {
        SettingHelper.backupSystrayIconEnabled = backupSystrayIconEnabled;
    }

    public static boolean isSyncSystrayIconEnabled() {
        return syncSystrayIconEnabled;
    }

    public static void setSyncSystrayIconEnabled(boolean syncSystrayIconEnabled) {
        SettingHelper.syncSystrayIconEnabled = syncSystrayIconEnabled;
    }

    static {
        logger = LoggerFactory.getLogger(SettingHelper.class);
        keystorePath = null;
        licenseActive = true;
        deviceBlocked = false;
        updateDownloadURL = null;
        userName = null;
        cloudName = null;
        deviceName = null;
        regristrationID = null;
        syncLicenced = TRUE_VALUE_STRING_REPRESENTATION;
        backupLicenced = "false";
        mediaUserName = null;
        mediaPassword = null;
        parabluScriptsFolder = null;
        parabluVshadowPath = null;
        currentCloudIpAddress = null;
        localIpAddress = null;
        publicIpAddress = null;
        gaeLocalIpAddress = null;
        httpPort = null;
        httpsPort = null;
        currentHttpsPort = null;
        syncUploadIpAddress = null;
        lastSuccessfulBackup = 0L;
        mediaHubEnabled = false;
        tempEnableAutomaticBackUp = false;
        enableAutomaticBackUp = false;
        addPreConfiguredFoldersForBackup = false;
        enableMusicMediaSync = false;
        tempEnableMusicMediaSync = false;
        enablePicturesMediaSync = false;
        tempEnablePicturesMediaSync = false;
        enableVideosMediaSync = false;
        tempEnableVideosMediaSync = false;
        backupFolderTOsExistingFolderPathsHolder = new HashSet<BackupFolderTO>();
        errorOccuredDuringSync = false;
        isDCMEnabled = false;
        serverBackupLicensed = "false";
        isNoUi = "";
        snapFolderPath = "";
        isVssEnabled = "";
        deviceUUId = null;
        restoreEnabled = "false";
        isExternalStorageSelected = "false";
        nextBackupTimeStamp = 0L;
        policySyncInterval = 3;
        initiateBackupInterfaceEnabled = false;
        restoreInterfaceEnabled = false;
        pauseBackupInterfaceEnabled = false;
        stopBackupInterfaceEnabled = false;
        backupSettingsInterfaceEnabled = false;
        backupFilesInterfaceEnabled = false;
        refreshBackupPolicyInterfaceEnabled = false;
        syncNowInterfaceEnabled = false;
        syncSettingsInterfaceEnabled = false;
        syncFilesInterfaceEnabled = false;
        refreshSyncPolicyInterfaceEnabled = false;
        searchInterfaceEnabled = false;
        openSyncFolderInterfaceEnabled = false;
        backupSystrayIconEnabled = false;
        syncSystrayIconEnabled = false;
        exitBackupInterfaceEnabled = false;
        exitSyncInterfaceEnabled = false;
        decoupleBackupInterfaceEnabled = false;
        decoupleSyncInterfaceEnabled = false;
        supportBackupInterfaceEnabled = false;
        supportSyncInterfaceEnabled = false;
        backuptoolTipNotificationBlocked = false;
        synctoolTipNotificationBlocked = false;
        updateAgentBackupInterfaceEnabled = false;
        updateAgentSyncInterfaceEnabled = false;
        aboutBackupInterfaceEnabled = false;
        aboutSyncInterfaceEnabled = false;
    }
}

