/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.runnables;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.GatewayTO;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(RestartRunnable.class);
    BackupAdapter backUpAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
    private AtomicInteger noOfBatches;
    private BlockingQueue<Future<BackupTO>> finishedBatchesQueue;
    private BackupPolicyTO currentPolicy;
    private Thread delegateThread;
    private Thread chunkDelegateThread;
    private AtomicBoolean interupted;

    public RestartRunnable(AtomicInteger noOfBatches, BlockingQueue<Future<BackupTO>> finishedBatchesQueue, GatewayTO uploadGatewayTO, String batchIdForBackup, BackupPolicyTO currentPolicy, Thread delegateThread, Thread chunkDelegateThread, AtomicBoolean interupted) {
        this.noOfBatches = noOfBatches;
        this.finishedBatchesQueue = finishedBatchesQueue;
        this.currentPolicy = currentPolicy;
        this.delegateThread = delegateThread;
        this.chunkDelegateThread = chunkDelegateThread;
        this.interupted = interupted;
    }

    @Override
    public void run() {
        int batchId = 0;
        while (!Thread.interrupted()) {
            try {
                this.logger.debug("No of batches > i value > : " + batchId + "batch size>" + this.noOfBatches.get());
                BackupTO lastFile = this.finishedBatchesQueue.take().get();
                if (lastFile != null && lastFile.getRestartId() == -1L) {
                    this.logger.debug("After taking BackupTo from finishedBatchesQueue>>>" + lastFile.getClientData() + ">>no of batches:" + this.noOfBatches.get());
                    break;
                }
                if (lastFile != null) {
                    ++batchId;
                    continue;
                }
                this.logger.debug("Last backup batch file is null so breaking the loop>>>>>>>");
                if ("SYNC".equalsIgnoreCase(this.currentPolicy.getPolicyGroupName())) break;
                this.logger.debug("Last backup batch file is null finished que size is:" + this.finishedBatchesQueue.size());
                this.interupted.set(true);
                this.delegateThread.interrupt();
                this.chunkDelegateThread.interrupt();
                break;
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                this.logger.trace("" + e);
                this.logger.error("interrupted or execution exception" + e.getMessage());
                this.logger.debug("sdsd");
                this.logger.trace("" + e);
                this.logger.error("Exception :" + e.getMessage());
                this.interupted.set(true);
                this.delegateThread.interrupt();
                this.chunkDelegateThread.interrupt();
            }
        }
        this.logger.error("Thread is been nudged inside Restart Runnable&&&&&&");
    }
}

