/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.notification;

import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.settings.BluVaultIPHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.to.BluVaultTO;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandler {
    private Logger logger = LoggerFactory.getLogger(EventHandler.class);

    public List<String> checkNotificationFromServer() {
        boolean retry;
        BackupAdapter backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        ArrayList<String> events = new ArrayList();
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        String currentIP = SettingHelper.getPublicIpAddress();
        BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BluVaultTO> ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
        do {
            retry = false;
            try {
                events = backupAdapter.getNotificationFromServer(currentIP, SettingHelper.getUserName(), SettingHelper.getDeviceUUId(), SettingHelper.readTokenFromFile());
                this.logger.debug("list of events>>" + events);
            }
            catch (Exception e) {
                this.logger.error("Exception : " + e.getMessage());
                this.logger.trace("", (Throwable)e);
                this.logger.debug("Retrying to get events information.");
                retry = true;
                ebmsList = this.removeCurrentIp(ebmsList, currentIP);
                this.logger.debug("ebms list size after removing the current ip:" + ebmsList.size());
                if (ebmsList.isEmpty()) {
                    this.logger.debug("inside ebms list empty cycle finished so sleep and reset");
                    sleepTime = ParabluFileSystemUtils.sleepForGivenTime((long)sleepTime);
                    ++retryCount;
                    ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
                }
                if (ebmsList.isEmpty()) continue;
                currentIP = ebmsList.get(0).getBluVaultName();
            }
        } while (retry && retryCount < 4);
        return events;
    }

    private List<BluVaultTO> removeCurrentIp(List<BluVaultTO> ebmsList, String currentIP) {
        List<BluVaultTO> ebmsList1 = ebmsList.stream().filter(p -> !p.getBluVaultName().equalsIgnoreCase(currentIP)).collect(Collectors.toList());
        this.logger.debug("After removing the ip size:" + ebmsList1.size() + "  current Ip:" + currentIP);
        return ebmsList1;
    }

    public static enum Actions {
        PULL_AGENTLOGS,
        SYNCPOLICY_REFRESH,
        BACKUPPOLICY_REFRESH,
        STOP_BACKUP,
        START_BACKUP,
        PULL_HISTORICAL_LOGS,
        HARD_STOP_BACKUP;

    }
}

