/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.parablu.epa.common.dao.BackupCrawlDAOImpl;
import com.parablu.epa.common.dao.BackupStatisticsDAOImpl;
import com.parablu.epa.common.dao.NewBackUpCrawlDAOImpl;
import com.parablu.epa.common.dao.NewBackupImageDAOImpl;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.element.BackupListResponseElement;
import com.parablu.epa.core.element.BackupStatusElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.service.sync.BaseJob;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.GzipTO;
import com.parablu.epa.helper.exceptions.BaseException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReSendFilesJob
extends BaseJob {
    private Logger logger = LoggerFactory.getLogger(ReSendFilesJob.class);
    private BackupAdapter backupAdapter = null;
    protected String currentIP = SettingHelper.getCurrentCloudIpAddress();
    boolean manual = false;
    protected Integer currentPort = null;
    BackupCrawlDAOImpl backupCrawlDAOImpl = new BackupCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
    BackupStatisticsDAOImpl backupStatisticsDAOImpl = new BackupStatisticsDAOImpl(SettingHelper.getBackUpDbUrl());
    NewBackUpCrawlDAOImpl newBackUpCrawlDAOImpl = new NewBackUpCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
    NewBackupImageDAOImpl newBackupImageDAOImpl = new NewBackupImageDAOImpl(SettingHelper.getBackUpDbUrl());
    BackupStatusElement backupStatusElement = null;
    private static final int BATCH_LIMIT_FOR_WEB_REQUEST = 500;

    public ReSendFilesJob(boolean manualVal) {
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        this.manual = manualVal;
    }

    public abstract void updateSystrayImageAccordingToStage(String var1);

    protected abstract void scanFileSystemByType(BackupFolderTO var1);

    public void run() {
        try {
            List<BackupTO> backUpList;
            do {
                this.logger.debug("start receiving resend files request.");
                backUpList = this.sendWebRequest();
                if (backUpList == null) break;
                this.logger.debug("received resend files request. backup file list..>" + backUpList.size());
                if (backUpList.isEmpty()) continue;
                Thread.sleep(10000L);
                this.startBackUpThread(backUpList);
            } while (backUpList.size() >= 500);
            this.logger.debug("BACKUP FINISHED");
            return;
        }
        catch (BaseException baseException) {
            this.logger.error("baseException ", (Throwable)baseException);
        }
        catch (RuntimeException e) {
            this.logger.trace("" + e);
            this.logger.error("Exception :", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Unkown Exception :", (Object)e.getMessage());
        }
    }

    public abstract void startBackUpThread(List<BackupTO> var1) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException;

    public abstract void pauseBackup(boolean var1);

    private List<BackupTO> sendWebRequest() throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        GzipTO gzipResponse;
        this.currentIP = SettingHelper.getCurrentCloudIpAddress();
        if (SettingHelper.getCurrentHttpsPort() != null) {
            this.currentPort = Integer.valueOf(SettingHelper.getCurrentHttpsPort());
        }
        if ((gzipResponse = this.backupAdapter.validateResendFilesForBackUp(this.currentIP, this.currentPort, SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName())) == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400 || gzipResponse.getResponseCode() == 503) {
            gzipResponse = this.retryUsingUpdatedIp(gzipResponse);
        }
        if (gzipResponse == null) {
            throw new CrawlAdapterException(" null gzipResponse (connection error)");
        }
        int responseCode = gzipResponse.getResponseCode();
        if (responseCode == 400 || responseCode == 404) {
            throw new CrawlAdapterException(" HTTP_DEVICE_SESSION_EXPIRED or HTTP_BAD_REQUEST or HTTP_NOT_FOUND:" + responseCode);
        }
        if (responseCode == 416) {
            this.licenseExpired = true;
            throw new CrawlAdapterException(" License Expired");
        }
        if (responseCode == 420) {
            this.deviceBlocked = true;
            throw new CrawlAdapterException(" User Device Blocked");
        }
        if (responseCode == 417) {
            throw new CrawlAdapterException("User Limit Reached");
        }
        if (responseCode == 421) {
            this.sessionExpired = true;
            throw new CrawlAdapterException("Session Expired");
        }
        if (responseCode == 401) {
            throw new CrawlAdapterException("Unauthorized");
        }
        if (responseCode != 200) {
            throw new CrawlAdapterException(" Server Error: " + responseCode);
        }
        byte[] responseByte = gzipResponse.getResponse();
        BackupListResponseElement backupListResponseElement = Xmlparser.parseBackupListResponse((byte[])responseByte);
        if (backupListResponseElement == null) {
            throw new CrawlAdapterException(" backupListResponseElement; parsed response null");
        }
        return ObjectUtils.convertFileElementToBackupTO((List)backupListResponseElement.getFilesNotToAddList().getFileElementList(), (String)"0");
    }

    private GzipTO retryUsingUpdatedIp(GzipTO gzipRes) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        SettingHelper.checkAndUpdateIpAddress();
        GzipTO gzipResponse = gzipRes;
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getGaeLocalIpAddress();
            this.currentPort = null;
            gzipResponse = this.backupAdapter.validateResendFilesForBackUp(this.currentIP, this.currentPort, SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName());
        }
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getPublicIpAddress();
            this.currentPort = null;
            gzipResponse = this.backupAdapter.validateResendFilesForBackUp(this.currentIP, this.currentPort, SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName());
        }
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400 && SettingHelper.getHttpsPort() != null) {
            this.currentIP = SettingHelper.getPublicIpAddress();
            this.currentPort = null;
            gzipResponse = this.backupAdapter.validateResendFilesForBackUp(this.currentIP, this.currentPort, SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName());
        }
        if (gzipResponse != null && gzipResponse.getResponseCode() != 404 && gzipResponse.getResponseCode() != 400) {
            SettingHelper.setCurrentHttpsPort(this.currentPort == null ? null : String.valueOf(this.currentPort));
            SettingHelper.setCurrentCloudIpAddress(this.currentIP);
            SettingHelper.applyChangesToSharedPreferences(false);
        }
        return gzipResponse;
    }

    public abstract void deleteVsnapshot(List<BackupFolderTO> var1);

    public abstract void createVsnapshot(List<BackupFolderTO> var1);

    public abstract boolean runScripts(String var1, boolean var2);
}

