/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.google.common.util.concurrent.RateLimiter;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.ChunkTableDAOImpl;
import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.common.service.dedup.rabincarb.ChunkerHelper;
import com.parablu.epa.common.service.dedup.rabincarb.Polynomial;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.MultiPartBackupAdapter;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.FileSystemUtility;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.ChunkFileTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.helper.utils.MD5Generator;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartUploadCallable
implements Callable<BackupTO> {
    private Logger logger = LoggerFactory.getLogger(MultipartUploadCallable.class);
    private static Logger failedFileLog = LoggerFactory.getLogger((String)"failedFileLogger");
    private long restartId;
    List<BackupTO> chunkFileBatch;
    GatewayTO uploadGatewayTo;
    String requestURL;
    String backupBatchID;
    AtomicInteger uploadCount;
    AtomicLong totalUploadSize;
    BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
    BackupActivityTO backupActivityTO = this.backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
    BackupPolicyTO backupPolicyTO;
    CleanupInterface<BackupTO> cleanupInterface;
    int priority;
    MultiPartBackupAdapter multiPartBackupAdapter = null;
    ChunkTableDAOImpl chunkTableDAOImpl = new ChunkTableDAOImpl(SettingHelper.getBackUpDbUrl());
    private RateLimiter rateLimiter;
    private static final String EXCEPTION_OCCURED = "Exception Occured";
    private static final String FALSE = "false";
    private int errorCode;
    private static boolean isFullBackup;
    private List<BackupTO> failedBackupTOs;
    private int uploadedChunkCount;
    private static String isBackupManual;
    private BlockingQueue<Future<BackupTO>> finishedBatchesQueue;
    private Polynomial p = new Polynomial();
    private long POLYNOMIAL = 17349423945073011L;
    private String tableNameHash = "";
    private List<String> chunkNamesInList = new ArrayList<String>();

    public MultipartUploadCallable(List<BackupTO> chuckFileBatch, GatewayTO uploadGatewayTo, String backupBatchID, AtomicInteger uploadCount, BackupPolicyTO currentPolicyTO, CleanupInterface<BackupTO> cleanupInterface, String requestURL, RateLimiter rateLimiter, int priority, boolean isFullBackup, AtomicLong totalUploadSize, String isBackupManual, BlockingQueue<Future<BackupTO>> finishedBatchesQueue) {
        this.restartId = NotificationHelper.getBackupRestartId();
        this.chunkFileBatch = chuckFileBatch;
        this.uploadGatewayTo = uploadGatewayTo;
        this.backupBatchID = backupBatchID;
        this.uploadCount = uploadCount;
        this.backupPolicyTO = currentPolicyTO;
        this.cleanupInterface = cleanupInterface;
        this.requestURL = requestURL;
        this.rateLimiter = rateLimiter;
        this.priority = priority;
        MultipartUploadCallable.isFullBackup = isFullBackup;
        this.totalUploadSize = totalUploadSize;
        this.failedBackupTOs = new ArrayList<BackupTO>();
        this.finishedBatchesQueue = finishedBatchesQueue;
        MultipartUploadCallable.isBackupManual = isBackupManual;
    }

    @Override
    public BackupTO call() {
        Thread.currentThread().setPriority(this.priority);
        this.createAdapterConnection();
        for (BackupTO backupTO : this.chunkFileBatch) {
            block27: {
                String filePath;
                if (Thread.currentThread().isInterrupted()) {
                    this.cleanupInterface.updateErrorCode(this.errorCode);
                    this.cancelUpload();
                    return null;
                }
                if (backupTO.getChunkFileList() == null) {
                    try {
                        this.logger.debug("########Before creating adapter connection" + this.chunkFileBatch.size());
                        this.logger.debug("chunk list is null so normal file backup fileName:" + backupTO.getFileName());
                        File fileToUpload = new File(backupTO.getClientData());
                        filePath = ObjectUtils.getFileSnapshotPath((String)fileToUpload.getAbsolutePath());
                        if (filePath == null || !ParabluFileSystemUtils.handleFileExist((String)filePath)) {
                            this.failedBackupTOs.add(backupTO);
                            this.logger.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + fileToUpload.getAbsolutePath());
                            failedFileLog.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + fileToUpload.getAbsolutePath());
                            continue;
                        }
                        this.cleanupInterface.updateChunkFileDetail(backupTO, 0);
                        File md5File = new File(filePath);
                        this.multiPartBackupAdapter.addFormField();
                        this.logger.debug("Before adding header in req");
                        MultipartUploadCallable.addHeaderToMultipart(this.multiPartBackupAdapter, backupTO, this.uploadGatewayTo, md5File, this.restartId, this.backupBatchID);
                        this.logger.debug("Before adding file part in req");
                        this.multiPartBackupAdapter.addFilePart(md5File, this.rateLimiter);
                        NotificationHelper.setBackupChunkFileDetails("");
                        this.logger.debug("After adding file part in req");
                        break block27;
                    }
                    catch (CrawlAdapterException e) {
                        this.logger.trace("" + (Object)((Object)e));
                        this.logger.debug(EXCEPTION_OCCURED + e.getMessage());
                        if (!"IO EXCeption".equalsIgnoreCase(e.getMessage())) {
                            this.errorCode = 909;
                            Thread.currentThread().interrupt();
                            this.cancelUpload();
                            break;
                        }
                        break block27;
                    }
                    catch (Exception e) {
                        this.errorCode = 909;
                        this.logger.trace("" + e);
                        this.logger.debug(EXCEPTION_OCCURED + e.getMessage());
                        break block27;
                    }
                }
                try {
                    this.logger.debug("Inside chunking of file :" + backupTO.getFileName());
                    boolean isCompressionEnabled = this.backupPolicyTO.isCompressionEnabled();
                    filePath = ObjectUtils.getFileSnapshotPath((String)backupTO.getClientData());
                    File willBeRead = new File(filePath);
                    long fileSize = willBeRead.length();
                    int numberOfChunks = 1;
                    byte[] temporaryData = new byte[]{};
                    long totalBytesRead = 0L;
                    long totalSize = 0L;
                    byte[] actualData = null;
                    if (!ParabluFileSystemUtils.handleFileExist((String)filePath)) {
                        this.failedBackupTOs.add(backupTO);
                        this.logger.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + filePath);
                        failedFileLog.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + filePath);
                        continue;
                    }
                    this.tableNameHash = MD5Generator.generateMD5OfString((String)willBeRead.getAbsolutePath());
                    this.chunkTableDAOImpl.createTempBackupChunkTable(this.tableNameHash);
                    try {
                        this.p.x = this.POLYNOMIAL;
                        ChunkerHelper.Chunker chunker = ChunkerHelper.New(willBeRead, this.p);
                        while (totalBytesRead < fileSize) {
                            if (Thread.currentThread().isInterrupted()) {
                                this.cleanupInterface.updateErrorCode(this.errorCode);
                                this.cancelUpload();
                                return null;
                            }
                            ChunkerHelper.Chunk chunk = chunker.Next(temporaryData);
                            int chunkLen = (int)chunk.Length;
                            this.logger.debug(chunk.Start + ":sTart chunk...." + chunkLen + ":Before Writng temp file: " + chunk.data.length);
                            temporaryData = this.readRandomWithoutCompression(willBeRead, chunk.Start, chunkLen);
                            Object[] obj = ParabluFileSystemUtils.writeOnStream((int)chunkLen, (boolean)isCompressionEnabled, (byte[])temporaryData, (long)totalSize);
                            actualData = (byte[])obj[0];
                            totalSize = (Long)obj[1];
                            this.logger.debug("Before adding file part in req" + totalSize);
                            this.addChunkDetailsForMultipart(backupTO, numberOfChunks, actualData, willBeRead, this.tableNameHash, chunk);
                            if (chunkLen > 0) {
                                totalBytesRead += (long)chunkLen;
                            }
                            this.updateChunkDetailForUI(backupTO, fileSize, totalBytesRead);
                            ++numberOfChunks;
                            this.logger.debug("Chunk Count :" + this.uploadedChunkCount + " and file Size " + fileSize);
                            if (totalBytesRead != fileSize) continue;
                            this.logger.debug("finished writing file");
                            break;
                        }
                        this.logger.debug("Chunk file uploaded");
                        this.uploadChunkNameListFile(backupTO, 0L, this.chunkNamesInList, null, FALSE);
                        break block27;
                    }
                    catch (SecurityException e) {
                        this.logger.debug("Access denied");
                        this.logger.trace("" + e);
                        this.failedBackupTOs.add(backupTO);
                        this.logger.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + willBeRead.getAbsolutePath());
                        failedFileLog.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + willBeRead.getAbsolutePath());
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        this.logger.debug("File not found");
                        this.logger.trace("" + e);
                        this.failedBackupTOs.add(backupTO);
                        this.logger.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + willBeRead.getAbsolutePath());
                        failedFileLog.error(this.failedBackupTOs.size() + ">> File is not accessible or not found.." + willBeRead.getAbsolutePath());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logger.trace("Exception", (Throwable)e);
                        this.failedBackupTOs.add(backupTO);
                        this.logger.error(this.failedBackupTOs.size() + ">> Exception accessing file : " + willBeRead.getAbsolutePath());
                        failedFileLog.error(this.failedBackupTOs.size() + ">> Exception accessing file : " + willBeRead.getAbsolutePath());
                        this.logger.debug(EXCEPTION_OCCURED + e.getMessage());
                        this.errorCode = 909;
                        if ("IO EXCeption".equalsIgnoreCase(e.getMessage())) continue;
                        Thread.currentThread().interrupt();
                        this.cancelUpload();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("" + e);
                    this.failedBackupTOs.add(backupTO);
                    this.logger.debug(EXCEPTION_OCCURED + e.getMessage());
                    this.errorCode = 909;
                    if ("IO EXCeption".equalsIgnoreCase(e.getMessage())) break block27;
                    Thread.currentThread().interrupt();
                    this.cancelUpload();
                }
                break;
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            this.cleanupInterface.updateErrorCode(this.errorCode);
            this.cancelUpload();
            Thread.currentThread().interrupt();
            return null;
        }
        int status = this.multiPartBackupAdapter.finish();
        this.logger.debug("Batch finished and status is : " + status);
        if (!this.failedBackupTOs.isEmpty()) {
            this.cleanupInterface.updateBackupCrawlTable(this.failedBackupTOs);
            this.logger.debug("after  cleaning up database> 1111111>>>before removinf list<" + this.chunkFileBatch.size());
            this.removeFailedBackupTOs();
            this.logger.debug("After cleaning up database> 222222222>>>" + this.chunkFileBatch.size());
            this.failedBackupTOs.clear();
        }
        if (status == 200) {
            try {
                List response = this.multiPartBackupAdapter.getResponse();
                String fileName = ObjectUtils.getFileSnapshotPath((String)this.chunkFileBatch.get(0).getClientData());
                File file = new File(fileName);
                this.createAdapterConnection();
                if (!response.isEmpty()) {
                    this.sendMissingChunks(response, file);
                }
                this.uploadChunkNameListFile(this.chunkFileBatch.get(0), 0L, this.chunkNamesInList, file, "true");
                status = this.multiPartBackupAdapter.finish();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.chunkTableDAOImpl.renameTable(this.tableNameHash);
            this.logger.debug("chunk file batch list>>>>>" + this.chunkFileBatch.size());
            if (this.chunkFileBatch.isEmpty()) {
                return new BackupTO();
            }
            BackupTO lastChunkFile = this.chunkFileBatch.get(this.chunkFileBatch.size() - 1);
            this.restartId = lastChunkFile.getRestartId();
            this.cleanupInterface.updateRestartId(this.restartId);
            for (BackupTO backupTO : this.chunkFileBatch) {
                this.cleanupInterface.updateUIWrapper(backupTO, this.uploadCount.addAndGet(1), this.totalUploadSize.addAndGet(backupTO.getFileSize()));
                this.cleanupInterface.runCleanup(backupTO, status);
            }
            this.cleanupInterface.updateTotalUploadSize();
            this.logger.debug("Batch finished returning backupTo to finished queue");
            return lastChunkFile;
        }
        this.errorCode = status == 449 ? 1981 : (status == 502 ? 1996 : (status == 428 ? 1992 : (status == 429 ? 1207 : status)));
        this.cleanupInterface.updateErrorCode(this.errorCode);
        this.cancelUpload();
        Thread.currentThread().interrupt();
        return null;
    }

    private void createAdapterConnection() {
        try {
            this.logger.debug("Before creating adapter connection");
            this.multiPartBackupAdapter = new MultiPartBackupAdapter(this.uploadGatewayTo.getGatewayName(), null, this.requestURL, SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            this.logger.info("rate limiter>>" + this.rateLimiter);
            this.logger.debug("After creating adapter connection");
            this.logger.debug(this.finishedBatchesQueue.size() + "After creating adapter connection" + this.chunkFileBatch.size());
        }
        catch (IOException e1) {
            this.errorCode = 909;
            this.logger.trace("" + e1);
            this.logger.error("error in multipart backup adapter call" + e1.getMessage());
        }
    }

    private void sendMissingChunks(List<String> response, File file) throws NumberFormatException, IOException {
        try {
            this.logger.debug("missing chunks......" + response.size());
            this.logger.debug("response::::::::::::::::::" + response.get(0));
            String chunkListResponse = response.get(0);
            String[] chunkList = chunkListResponse.split("\\|");
            BackupTO backupTO = this.chunkFileBatch.get(0);
            this.logger.debug("chunk list after spliting by delimitr" + chunkList.length);
            for (String chunk : chunkList) {
                if (StringUtils.isEmpty((String)chunk)) {
                    return;
                }
                String[] chunkDetails = chunk.split(",");
                this.logger.debug(file + "chunk list after spliting by delimitr" + chunkDetails.length + "...." + Long.valueOf(chunkDetails[1]) + "..." + Integer.valueOf(chunkDetails[2]));
                byte[] actualData = this.readRandom(file, Long.valueOf(chunkDetails[1]), Integer.valueOf(chunkDetails[2]));
                this.multiPartBackupAdapter.addFormField();
                MultipartUploadCallable.addHeaderToMultipart(this.multiPartBackupAdapter, backupTO, this.uploadGatewayTo, file, this.restartId, this.backupBatchID);
                String md5 = MD5Generator.generateMD5ForByteArray((byte[])actualData);
                String chunkName = chunkDetails[0];
                this.logger.debug("little hump:" + md5 + "Chunk Name is :" + chunkName + " for File Name is :" + backupTO.getFileName() + "tableNameHash:" + this.tableNameHash);
                this.addHeaderToMultipartforChunks(this.multiPartBackupAdapter, backupTO, md5, chunkName);
                this.multiPartBackupAdapter.addHeaderField("isAChunkFile", "true");
                this.multiPartBackupAdapter.addHeaderField("content-chunking", "true");
                this.multiPartBackupAdapter.addHeaderField("missing-chunk", "true");
                this.multiPartBackupAdapter.addHeaderField("content-chunk-data-present", "true");
                this.multiPartBackupAdapter.addHeaderField("offset", String.valueOf(chunkDetails[1]));
                this.multiPartBackupAdapter.addHeaderField("chunkFileSize", String.valueOf(actualData.length));
                this.multiPartBackupAdapter.addFilePart((InputStream)new ByteArrayInputStream(actualData), this.rateLimiter);
                this.logger.debug("inside chunk data  present missing chunks.....");
            }
        }
        catch (Exception e) {
            this.logger.error("Exception ..", (Throwable)e);
        }
    }

    private void removeFailedBackupTOs() {
        Iterator<BackupTO> iter = this.chunkFileBatch.iterator();
        block0: while (iter.hasNext()) {
            BackupTO to = iter.next();
            for (BackupTO backupTo : this.failedBackupTOs) {
                if (to.getRestartId() != backupTo.getRestartId()) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    private void uploadChunkNameListFile(BackupTO backupTO, long fileSize, List<String> chunkNamesInList, File file, String isChunkList) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        StringBuilder chunkNames = new StringBuilder();
        this.logger.debug("chunknames list size........." + chunkNamesInList.size());
        for (String name : chunkNamesInList) {
            chunkNames.append(name);
        }
        this.cleanupInterface.updateChunkFileDetail(backupTO, this.uploadedChunkCount);
        this.multiPartBackupAdapter.addFormField();
        this.logger.debug("Before adding header in req");
        MultipartUploadCallable.addHeaderToMultipart(this.multiPartBackupAdapter, backupTO, this.uploadGatewayTo, file, this.restartId, this.backupBatchID);
        this.logger.debug("Before adding chunk header in req");
        String md5 = MD5Generator.generateMD5ForByteArray((byte[])chunkNames.toString().getBytes());
        this.addHeaderToMultipartforChunks(this.multiPartBackupAdapter, backupTO, md5, "chunkvalues");
        this.multiPartBackupAdapter.addHeaderField("isAChunkFile", FALSE);
        this.multiPartBackupAdapter.addHeaderField("isChunkList", isChunkList);
        this.multiPartBackupAdapter.addFilePart((InputStream)new ByteArrayInputStream(chunkNames.toString().getBytes()), this.rateLimiter);
        this.logger.debug("Upload chunk name list file completed");
    }

    private void addChunkDetailsForMultipart(BackupTO backupTO, int numberOfChunks, byte[] actualData, File file, String tableNameHash, ChunkerHelper.Chunk chunk) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.multiPartBackupAdapter.addFormField();
        MultipartUploadCallable.addHeaderToMultipart(this.multiPartBackupAdapter, backupTO, this.uploadGatewayTo, file, this.restartId, this.backupBatchID);
        String md5 = MD5Generator.generateMD5ForByteArray((byte[])actualData);
        String chunkName = String.format("part%09d.%s", numberOfChunks, md5);
        this.logger.debug(md5 + ":Actual data md5...Chunk Name is :" + chunkName + " for File Name is :" + backupTO.getFileName() + "tableNameHash:" + tableNameHash);
        boolean isChunkExists = this.chunkTableDAOImpl.isChunkExists(tableNameHash, md5, "temp");
        this.logger.debug("chunk exists....11111" + isChunkExists);
        if (!isChunkExists) {
            isChunkExists = this.chunkTableDAOImpl.isChunkExists(tableNameHash, md5, "actual");
            this.logger.debug("chunk exists....11111" + isChunkExists);
        }
        this.addHeaderToMultipartforChunks(this.multiPartBackupAdapter, backupTO, md5, chunkName);
        this.multiPartBackupAdapter.addHeaderField("isAChunkFile", "true");
        this.multiPartBackupAdapter.addHeaderField("content-chunking", "true");
        if (!isChunkExists) {
            ChunkFileTO chunkFileTO = new ChunkFileTO();
            chunkFileTO.setMd5Checksum(md5);
            this.chunkTableDAOImpl.insertChunkFileTO(tableNameHash, "temp", chunkFileTO);
            this.multiPartBackupAdapter.addHeaderField("content-chunk-data-present", "true");
            this.multiPartBackupAdapter.addHeaderField("offset", String.valueOf(chunk.Start));
            this.multiPartBackupAdapter.addHeaderField("endOffset", String.valueOf(chunk.Length));
            this.multiPartBackupAdapter.addHeaderField("chunkFileSize", String.valueOf(actualData.length));
            this.multiPartBackupAdapter.addFilePart((InputStream)new ByteArrayInputStream(actualData), this.rateLimiter);
            this.logger.debug("inside chunk data  present.....");
        } else {
            this.multiPartBackupAdapter.addHeaderField("content-chunk-data-present", FALSE);
            this.multiPartBackupAdapter.addHeaderField("offset", String.valueOf(chunk.Start));
            this.multiPartBackupAdapter.addHeaderField("endOffset", String.valueOf(chunk.Length));
            this.multiPartBackupAdapter.addFilePart((InputStream)new ByteArrayInputStream("a".getBytes()), this.rateLimiter);
            this.logger.debug("inside chunk data not present.....");
        }
        this.chunkNamesInList.add(chunkName + ",");
    }

    private void updateChunkDetailForUI(BackupTO backupTO, long fileSize, long totalBytesRead) {
        this.uploadedChunkCount = (int)((double)totalBytesRead / (double)fileSize * 100.0);
        this.cleanupInterface.updateChunkFileDetail(backupTO, this.uploadedChunkCount);
    }

    private void addHeaderToMultipartforChunks(MultiPartBackupAdapter multiPartBackupAdapter, BackupTO fileToUpload, String md5, String fileName) {
        multiPartBackupAdapter.addHeaderField("fileChunkNamesa", "");
        multiPartBackupAdapter.addHeaderField("prevBackupId", fileToUpload.getBackupId());
        multiPartBackupAdapter.addHeaderField("chunkFileMD5", md5);
        multiPartBackupAdapter.addHeaderField("chunkFileName", fileName);
        multiPartBackupAdapter.addHeaderField("isNormalFile", FALSE);
        multiPartBackupAdapter.addHeaderField("isCompressed", String.valueOf(this.backupPolicyTO.isCompressionEnabled()));
    }

    private static void addHeaderToMultipart(MultiPartBackupAdapter multiPartBackupAdapter, BackupTO fileToUpload, GatewayTO currentUploadGatewayToUse, File file, long restartId, String batchIdForBackup) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        multiPartBackupAdapter.addHeaderField("gatewayName", currentUploadGatewayToUse.getGatewayName());
        multiPartBackupAdapter.addHeaderField("fileMD5", fileToUpload.getMd5checksum());
        multiPartBackupAdapter.addHeaderField("dedupifiedBackupId", "");
        multiPartBackupAdapter.addHeaderField("maxVersions", String.valueOf(SettingHelper.getMaxVersionsToKeep()));
        multiPartBackupAdapter.addHeaderField("is-base-folder", String.valueOf(fileToUpload.isBaseFolder()));
        multiPartBackupAdapter.addHeaderField("is-folder", String.valueOf(fileToUpload.isFolder()));
        multiPartBackupAdapter.addHeaderField("is-exists", String.valueOf(true));
        multiPartBackupAdapter.addHeaderField("modified", String.valueOf(fileToUpload.getLastModifiedTimestamp()));
        multiPartBackupAdapter.addHeaderField("accessTime", String.valueOf(file != null ? Long.valueOf(FileSystemUtility.getFileAccessTime((File)file)) : "0"));
        multiPartBackupAdapter.addHeaderField("backupBatchId", batchIdForBackup);
        multiPartBackupAdapter.addHeaderField("userUnderLegalHold", FALSE);
        multiPartBackupAdapter.addHeaderField("userName", SettingHelper.getUserName().toLowerCase());
        multiPartBackupAdapter.addHeaderField("deviceUUID", SettingHelper.getDeviceUUId());
        multiPartBackupAdapter.addHeaderField("file-path", fileToUpload.getAbstractFilePath());
        multiPartBackupAdapter.addHeaderField("file-name", fileToUpload.getFileName());
        multiPartBackupAdapter.addHeaderField("cloudName", SettingHelper.getCloudName());
        multiPartBackupAdapter.addHeaderField("prevGatewayName", "");
        multiPartBackupAdapter.addHeaderField("token", SettingHelper.readTokenFromFile());
        multiPartBackupAdapter.addHeaderField("osType", SettingHelper.getOsName());
        multiPartBackupAdapter.addHeaderField("file-size", String.valueOf(file != null ? Long.valueOf(file.length()) : "0"));
        multiPartBackupAdapter.addHeaderField("restartId", String.valueOf(fileToUpload.getRestartId()));
        multiPartBackupAdapter.addHeaderField("backupId", fileToUpload.getBackupId());
        multiPartBackupAdapter.addHeaderField("isFullBackup", Boolean.toString(isFullBackup));
        multiPartBackupAdapter.addHeaderField("gatewayType", currentUploadGatewayToUse.getType());
        multiPartBackupAdapter.addHeaderField("isBackupManual", isBackupManual);
    }

    public void cancelUpload() {
        this.cleanupInterface.updateBackupCrawlTable(this.failedBackupTOs);
        this.failedBackupTOs.clear();
        if (this.multiPartBackupAdapter != null) {
            this.logger.debug("Canceling upload>>>>>>>>");
            this.multiPartBackupAdapter.cancelUpload();
        } else {
            this.logger.debug("multiThreadBackupAdapter is null>>>>>>>>>>>>");
        }
    }

    private byte[] readRandom(File file, long offset, int length) throws Exception {
        RandomAccessFile raf = new RandomAccessFile(file.getAbsolutePath(), "rw");
        raf.seek(offset);
        byte[] data = new byte[length];
        this.logger.debug(length + ":length..............startOffset:" + offset);
        int bytesRead = raf.read(data, 0, length);
        this.logger.debug("bytes read...." + bytesRead);
        raf.close();
        Object[] obj = ParabluFileSystemUtils.writeOnStream((int)bytesRead, (boolean)this.backupPolicyTO.isCompressionEnabled(), (byte[])data, (long)0L);
        return (byte[])obj[0];
    }

    private byte[] readRandomWithoutCompression(File file, long offset, int length) throws Exception {
        RandomAccessFile raf = new RandomAccessFile(file.getAbsolutePath(), "rw");
        raf.seek(offset);
        byte[] data = new byte[length];
        this.logger.debug(length + ":length..............startOffset:" + offset);
        int bytesRead = raf.read(data, 0, length);
        this.logger.debug("bytes read...." + bytesRead);
        raf.close();
        return data;
    }
}

