/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.NewBackUpCrawlDAO;
import com.parablu.epa.core.to.BackupTO;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewBackUpCrawlDAOImpl
extends BaseDAO
implements NewBackUpCrawlDAO {
    private Logger logger = LoggerFactory.getLogger(NewBackUpCrawlDAOImpl.class);
    private static final String DELETEFROM = "delete from ";
    private static final String VAUES = " Values(?,?,?,?,?,?,?,?);";
    private static final String SELECT_COUNT_ALL_FROM = "SELECT COUNT(*) FROM ";
    private static final String SQLEXCEPTION_WHILE_SELECTIING_FROM_BACKUP = "SQLException while selcting from backup";
    private static final String IS_NULL_OR = " is NULL OR ";
    private static final String EQUALTO_FALSE = " = 'false'";
    private static final String DESC_LIMIT_1 = " ORDER BY Id DESC LIMIT 1";
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private static final String RENAME_TO = " RENAME TO ";
    private static final String DROP_TABLE = "DROP TABLE IF EXISTS ";

    public NewBackUpCrawlDAOImpl(String uRL) {
        super(uRL);
    }

    public void createTable() {
        String query = BluSyncSQLConstants.CREATE_NEW_BACKUP_CRAWL_TABLE_QUERY;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while creating new backup crawl table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
    }

    public void createTempTable() {
        String query = BluSyncSQLConstants.CREATE_NEW_BACKUP_CRAWL_TABLE_TEMP_QUERY;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while creating new backup crawl table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListIntoTable(List<BackupTO> fileTOs) {
        String query = new StringBuffer().append("insert into ").append("NewBkupCrawl_Temp").append(" (").append("filename").append(",").append("filepath").append(",").append("bkupfilestatus").append(",").append("gatewayIP").append(",").append("checksum").append(",").append("size").append(",").append("modifiedtimestamp").append(",").append("folder").append(")").append(VAUES).toString();
        boolean success = false;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                int listsize = fileTOs.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    BackupTO currentFilesTO = fileTOs.get(recordCount);
                    if (currentFilesTO.getMd5checksum() == null) {
                        this.logger.debug("md5 checksum of current file is null so continue");
                        continue;
                    }
                    String tempValueFolder = String.valueOf(currentFilesTO.isFolder());
                    this.statement.setString(1, currentFilesTO.getFileName());
                    this.statement.setString(2, currentFilesTO.getAbstractFilePath());
                    this.statement.setString(3, currentFilesTO.getBkupStatus());
                    this.statement.setString(4, currentFilesTO.getGatewayIP());
                    this.statement.setString(5, currentFilesTO.getMd5checksum());
                    this.statement.setString(6, String.valueOf(currentFilesTO.getFileSize()));
                    this.statement.setString(7, String.valueOf(currentFilesTO.getLastModifiedTimestamp()));
                    this.statement.setString(8, tempValueFolder);
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while inserting", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupTO> readAllEntriesFromBackupImageTable() {
        String query = "select * from NewBkupCrawl where bkupfilestatus not like '%STARTED%' OR bkupfilestatus is NULL";
        ResultSet selectImageTableResult = null;
        ArrayList<BackupTO> fileTOList = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("select * from NewBkupCrawl where bkupfilestatus not like '%STARTED%' OR bkupfilestatus is NULL");
                selectImageTableResult = this.statement.executeQuery();
                fileTOList = new ArrayList<BackupTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    BackupTO tempFile = new BackupTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(Boolean.valueOf(selectImageTableResult.getString("folder")).booleanValue());
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    tempFile.setBkupStatus(selectImageTableResult.getString("bkupfilestatus"));
                    tempFile.setClientData(selectImageTableResult.getString("filepath") + File.separator + selectImageTableResult.getString("filename"));
                    tempFile.setGatewayIP(selectImageTableResult.getString("gatewayIP"));
                    tempFile.setFileSize(Long.valueOf(selectImageTableResult.getString("size")).longValue());
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while read All Entries From Table", (Throwable)e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListFromTable(List<BackupTO> fileTOs) {
        String query = "delete from NewBkupCrawl where filename=? And filepath=?;";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from NewBkupCrawl where filename=? And filepath=?;");
                this.logger.debug("Beofore deleting the statemnent");
                int listsize = fileTOs.size();
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.logger.debug("Beofore deleting the statemnent111111111");
                    this.statement.setString(1, fileTOs.get(recordCount).getFileName());
                    this.statement.setString(2, fileTOs.get(recordCount).getAbstractFilePath());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.logger.debug("Beofore deleting the statemnent22222222");
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while removing List From Table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListFromTableByIds(List<Integer> removeIds) {
        String baseQuery = "delete from NewBkupCrawl where id in (";
        boolean success = false;
        this.statement = null;
        String comma = "";
        StringBuilder inQuery = new StringBuilder("");
        this.logger.debug("Query string:" + baseQuery);
        if (this.getConnection()) {
            try {
                String finalQuery;
                int listSize = removeIds.size();
                int recordCount = 0;
                int count = 0;
                for (Integer id : removeIds) {
                    inQuery.append(comma);
                    inQuery.append(id);
                    comma = ",";
                    if (++recordCount < 1000) continue;
                    finalQuery = baseQuery + inQuery.toString() + ");";
                    this.statement = this.conn.prepareStatement(finalQuery);
                    this.logger.debug("Beofore deleting the statemnent: " + (count += recordCount) + "/" + listSize);
                    this.statement.execute();
                    this.logger.debug("After deleting the statemnent");
                    recordCount = 0;
                    comma = "";
                    inQuery = new StringBuilder("");
                }
                if (StringUtils.isNotEmpty((String)inQuery.toString())) {
                    finalQuery = baseQuery + inQuery.toString() + ");";
                    this.statement = this.conn.prepareStatement(finalQuery);
                    this.logger.debug("Beofore deleting the statemnent: " + (count += recordCount) + "/" + listSize);
                    this.statement.execute();
                    this.logger.debug("After deleting the statemnent");
                    recordCount = 0;
                    comma = "";
                    inQuery = new StringBuilder("");
                }
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while removing List From Table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEventToNewBackupCrawlTable(BackupTO backupTO) {
        String bkupStatus = backupTO.getBkupStatus();
        String fileName = backupTO.getFileName();
        String filePath = backupTO.getAbstractFilePath();
        this.logger.debug("UPDATING  STATUS.");
        String sqlQuery = "Update NewBkupCrawl set bkupfilestatus=? where filename=? AND filepath =? ;";
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("Update NewBkupCrawl set bkupfilestatus=? where filename=? AND filepath =? ;");
                this.statement.setString(1, bkupStatus);
                this.statement.setString(2, fileName);
                this.statement.setString(3, filePath);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while updating activity Table" + e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertFileToNewBackupCrawlTable(BackupTO fileTO) {
        String query = new StringBuffer().append("insert into ").append("NewBkupCrawl").append(" (").append("filename").append(",").append("filepath").append(",").append("bkupfilestatus").append(",").append("gatewayIP").append(",").append("checksum").append(",").append("size").append(",").append("modifiedtimestamp").append(",").append("folder").append(")").append(VAUES).toString();
        boolean success = false;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.conn.setAutoCommit(false);
                String tempValueFolder = String.valueOf(fileTO.isFolder());
                this.statement.setString(1, fileTO.getFileName());
                this.statement.setString(2, fileTO.getAbstractFilePath());
                this.statement.setString(3, fileTO.getBkupStatus());
                this.statement.setString(4, fileTO.getGatewayIP());
                this.statement.setString(5, fileTO.getMd5checksum());
                this.statement.setString(6, String.valueOf(fileTO.getLastModifiedTimestamp()));
                this.statement.setString(7, tempValueFolder);
                this.statement.addBatch();
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while insert", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupTO> searchFilename() {
        String sqlQuery = " select * from NewBkupCrawl where bkupfilestatus = 'STARTED';";
        ResultSet selectImageTableResult = null;
        this.statement = null;
        ArrayList<BackupTO> fileTOList = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(" select * from NewBkupCrawl where bkupfilestatus = 'STARTED';");
                selectImageTableResult = this.statement.executeQuery();
                fileTOList = new ArrayList<BackupTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    BackupTO tempFile = new BackupTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(Boolean.valueOf(selectImageTableResult.getString("folder")).booleanValue());
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    tempFile.setBkupStatus(selectImageTableResult.getString("bkupfilestatus"));
                    tempFile.setGatewayIP(selectImageTableResult.getString("gatewayIP"));
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while geting file " + e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while cclosing resultset for geting file ", (Throwable)e);
                    }
                }
                this.closeConnection();
            }
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alterTable() {
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("ALTER table BKIT ADD COLUMN bkupfilestatus TEXT;");
                this.statement.execute();
                this.statement.close();
                this.statement = this.conn.prepareStatement("ALTER table BKIT ADD COLUMN gatewayIP TEXT;");
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("sqlExeception in creating activity table" + e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntireTable() {
        String query = "delete from NewBkupCrawl";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from NewBkupCrawl");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while deleting", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountOfTable(boolean fullCount) {
        String query = fullCount ? "SELECT COUNT(*) FROM NewBkupCrawl" : "SELECT COUNT(*) FROM NewBkupCrawl where folder = 'false'";
        this.statement = null;
        ResultSet resultSet = null;
        int count = 0;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                resultSet = this.statement.executeQuery();
                while (resultSet.next()) {
                    count = resultSet.getInt(1);
                }
                resultSet.close();
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_SELECTIING_FROM_BACKUP, (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing resultset for  selcting from backup", (Throwable)e);
                    }
                }
                this.closeConnection();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupTO getBackupFileFromTableWithID(long id) {
        String query = "select * from NewBkupCrawl where Id = " + id;
        ResultSet selectImageTableResult = null;
        BackupTO tempFile = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(query);
                selectImageTableResult = this.statement.executeQuery();
                if (selectImageTableResult != null && selectImageTableResult.next()) {
                    tempFile = new BackupTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(Boolean.valueOf(selectImageTableResult.getString("folder")).booleanValue());
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    tempFile.setBkupStatus(selectImageTableResult.getString("bkupfilestatus"));
                    tempFile.setClientData(selectImageTableResult.getString("filepath") + File.separator + selectImageTableResult.getString("filename"));
                    tempFile.setGatewayIP(selectImageTableResult.getString("gatewayIP"));
                    tempFile.setFileSize(Long.valueOf(selectImageTableResult.getString("size")).longValue());
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while reading All Entries From Table", (Throwable)e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateFailedEventForBackupList(List<BackupTO> backupTO) {
        String bkupStatus = "FAILED";
        String sqlQuery = "Update NewBkupCrawl set bkupfilestatus =? where filename=? AND filepath =? ;";
        this.statement = null;
        boolean success = false;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("Update NewBkupCrawl set bkupfilestatus =? where filename=? AND filepath =? ;");
                int listsize = backupTO.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    BackupTO currentFileTO = backupTO.get(recordCount);
                    this.statement.setString(1, bkupStatus);
                    this.statement.setString(2, currentFileTO.getFileName());
                    this.statement.setString(3, currentFileTO.getAbstractFilePath());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while inserting", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    public void createNewPrevBackupCrawlTable() {
        String query = BluSyncSQLConstants.CREATE_NEW_PREV_BACKUP_CRAWL_TABLE_QUERY;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while create", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyNewToPrevOrPrevToNewBkupCrawlTable(String constraint) {
        String query = null;
        if (constraint.contentEquals("NewBkupCrawlToPrevNewBackupCrawl")) {
            query = "insert into NewPrev_BkupCrawl select * from NewBkupCrawl";
        } else if (constraint.contentEquals("PrevNewBackupCrawlToNewBkupCrawl")) {
            query = "insert into NewBkupCrawl select * from NewPrev_BkupCrawl";
        }
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while copying backup Crawl table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntirePrevCrawlTable() {
        String query = "delete from NewPrev_BkupCrawl";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from NewPrev_BkupCrawl");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while deleting new backup crawl table:", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupTO> getFailedBackupListFromTable() {
        String sqlQuery = " select * from NewPrev_BkupCrawl where bkupfilestatus not like '%COMPLETED%' ";
        ResultSet selectImageTableResult = null;
        this.statement = null;
        ArrayList<BackupTO> fileTOList = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(" select * from NewPrev_BkupCrawl where bkupfilestatus not like '%COMPLETED%' ");
                selectImageTableResult = this.statement.executeQuery();
                fileTOList = new ArrayList<BackupTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    BackupTO tempFile = new BackupTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(Boolean.valueOf(selectImageTableResult.getString("folder")).booleanValue());
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    tempFile.setGatewayIP(selectImageTableResult.getString("gatewayIP"));
                    tempFile.setClientData(selectImageTableResult.getString("filepath") + File.separator + selectImageTableResult.getString("filename"));
                    tempFile.setFileSize(Long.valueOf(selectImageTableResult.getString("size")).longValue());
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while geting file " + e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing resultset for geting file", (Throwable)e);
                    }
                }
                this.closeConnection();
            }
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFileExistsAndInsertFiles(List<BackupTO> fileTOs) {
        String query = new StringBuffer().append("INSERT OR IGNORE INTO ").append("NewBkupCrawl").append(" (").append("filename").append(",").append("filepath").append(",").append("bkupfilestatus").append(",").append("gatewayIP").append(",").append("checksum").append(",").append("size").append(",").append("modifiedtimestamp").append(",").append("folder").append(")").append(VAUES).toString();
        boolean success = false;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                int listsize = fileTOs.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    BackupTO currentFilesTO = fileTOs.get(recordCount);
                    if (currentFilesTO.getMd5checksum() == null) {
                        this.logger.debug("md5 checksum is null so continue");
                        continue;
                    }
                    String tempValueFolder = String.valueOf(currentFilesTO.isFolder());
                    this.statement.setString(1, currentFilesTO.getFileName());
                    this.statement.setString(2, currentFilesTO.getAbstractFilePath());
                    this.statement.setString(3, currentFilesTO.getBkupStatus());
                    this.statement.setString(4, currentFilesTO.getGatewayIP());
                    this.statement.setString(5, currentFilesTO.getMd5checksum());
                    this.statement.setString(6, String.valueOf(currentFilesTO.getFileSize()));
                    this.statement.setString(7, String.valueOf(currentFilesTO.getLastModifiedTimestamp()));
                    this.statement.setString(8, tempValueFolder);
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while inserting into new backup crawl table:", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdForRestart() {
        String query = "SELECT Id FROM NewBkupCrawl where bkupfilestatus is NULL OR bkupfilestatus= 'STARTED'  order by Id asc limit 1";
        this.statement = null;
        ResultSet resultSet = null;
        int count = 0;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("SELECT Id FROM NewBkupCrawl where bkupfilestatus is NULL OR bkupfilestatus= 'STARTED'  order by Id asc limit 1");
                resultSet = this.statement.executeQuery();
                while (resultSet.next()) {
                    count = resultSet.getInt(1);
                }
                resultSet.close();
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_SELECTIING_FROM_BACKUP, (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing resultset for selcting from backup", (Throwable)e);
                    }
                }
                this.closeConnection();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountOfRemainingFilesForBackup(boolean excludeFolders) {
        String query = excludeFolders ? "SELECT COUNT(*) FROM NewBkupCrawl where (bkupfilestatus is NULL OR bkupfilestatus ='STARTED') AND folder = 'false'" : "SELECT COUNT(*) FROM NewBkupCrawl where bkupfilestatus is NULL OR bkupfilestatus ='STARTED';";
        this.statement = null;
        ResultSet resultSet = null;
        int count = 0;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                resultSet = this.statement.executeQuery();
                while (resultSet.next()) {
                    count = resultSet.getInt(1);
                }
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_SELECTIING_FROM_BACKUP + exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.debug("sql exception while closing result set" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupTO> getFailedBackupListFromTableForRemoveBkupImageTable() {
        String sqlQuery = " select * from NewBkupCrawl where bkupfilestatus = 'FAILED' ";
        ResultSet selectImageTableResult = null;
        this.statement = null;
        ArrayList<BackupTO> fileTOList = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(" select * from NewBkupCrawl where bkupfilestatus = 'FAILED' ");
                selectImageTableResult = this.statement.executeQuery();
                fileTOList = new ArrayList<BackupTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    BackupTO tempFile = new BackupTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(Boolean.valueOf(selectImageTableResult.getString("folder")).booleanValue());
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    tempFile.setGatewayIP(selectImageTableResult.getString("gatewayIP"));
                    tempFile.setClientData(selectImageTableResult.getString("filepath") + File.separator + selectImageTableResult.getString("filename"));
                    tempFile.setFileSize(Long.valueOf(selectImageTableResult.getString("size")).longValue());
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while geting failed file from bew backup crawl" + e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing resultset for selcting from backup media table", (Throwable)e);
                    }
                }
                this.closeConnection();
            }
        }
        return fileTOList;
    }

    public void createOldBackupCrawlTable() {
        String query = BluSyncSQLConstants.CREATE_OLD_PREV_BACKUP_CRAWL_TABLE_QUERY;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while creating", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyPrevToOldOrOldToPrevBkupCrawlTable(String constraint) {
        String query = null;
        if (constraint.contentEquals("NewPrevBkupToOldBkup")) {
            query = "insert into OldBkupCrawl select * from NewPrev_BkupCrawl";
        } else if (constraint.contentEquals("OldBkupToNewPrevBkup")) {
            query = "insert into NewPrev_BkupCrawl select * from OldBkupCrawl";
        }
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while copying backupCrawl table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntireOldBackpCrawlTable() {
        String query = "delete from OldBkupCrawl";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from OldBkupCrawl");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while deleting", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountOfTableForGivenId(int restartId) {
        String query = "SELECT COUNT(*) FROM NewBkupCrawl where Id>" + restartId + " AND " + "folder" + EQUALTO_FALSE;
        this.statement = null;
        ResultSet resultSet = null;
        int count = 0;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                resultSet = this.statement.executeQuery();
                while (resultSet.next()) {
                    count = resultSet.getInt(1);
                }
                resultSet.close();
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_SELECTIING_FROM_BACKUP, (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing resultset for selcting from backup ", (Throwable)e);
                    }
                }
                this.closeConnection();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastRecordIdFromTable() {
        String query = "SELECT Id FROM NewBkupCrawl where folder = 'false' ORDER BY Id DESC LIMIT 1";
        this.logger.debug("query is>>SELECT Id FROM NewBkupCrawl where folder = 'false' ORDER BY Id DESC LIMIT 1");
        this.statement = null;
        ResultSet resultSet = null;
        int count = 0;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("SELECT Id FROM NewBkupCrawl where folder = 'false' ORDER BY Id DESC LIMIT 1");
                resultSet = this.statement.executeQuery();
                while (resultSet.next()) {
                    count = resultSet.getInt(1);
                }
                resultSet.close();
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_SELECTIING_FROM_BACKUP, (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing resultset for selcting from backup ", (Throwable)e);
                    }
                }
                this.closeConnection();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameTable(String oldName, String newName) {
        String query = ALTER_TABLE + oldName + RENAME_TO + newName;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while renaming", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearEntireTempTable() {
        String query = "delete from NewBkupCrawl_Temp";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from NewBkupCrawl_Temp");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while deleting", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropTable(String tableName) {
        String query = DROP_TABLE + tableName;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while renaming", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalUploadSize() {
        String query = "SELECT SUM(size) FROM NewBkupCrawl";
        this.statement = null;
        ResultSet resultSet = null;
        long size = 0L;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                resultSet = this.statement.executeQuery();
                while (resultSet.next()) {
                    size = resultSet.getLong(1);
                }
                resultSet.close();
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_SELECTIING_FROM_BACKUP, (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing resultset for  selcting from backup", (Throwable)e);
                    }
                }
                this.closeConnection();
            }
        }
        return size;
    }
}

