/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.dao.MediaTableDAO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.MediaFolderTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaFolderDAOImpl
extends BaseDAO
implements MediaTableDAO {
    private Logger logger = LoggerFactory.getLogger(MediaFolderDAOImpl.class);
    private static final String DELETE_FROM = "delete from ";
    private static final String WHERE = " where ";

    public MediaFolderDAOImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearTable() {
        String query = "delete from MKFT";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from MKFT");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while deleting fromm media table:", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createMediaTable() {
        String query = BluSyncSQLConstants.CREATE_MEDIA_FOLDER_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while creating backup media folder table:", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaFolderTO> getAllFolderToBackUpFiles() {
        String[] mediaTypes;
        ArrayList<MediaFolderTO> mediaBackUpList = new ArrayList<MediaFolderTO>();
        for (String mediaType : mediaTypes = new String[]{"Music", "Picture", "Video"}) {
            String query = " select * from MKFT where mediaType = \"" + mediaType + "\";";
            MediaFolderTO mediaFolderTO = new MediaFolderTO();
            this.statement = null;
            ResultSet resultSet = null;
            if (!this.getConnection()) continue;
            try {
                this.statement = this.conn.prepareStatement(query);
                resultSet = this.statement.executeQuery();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        String filePath = resultSet.getString("completefolderpath");
                        long lastSyncTime = resultSet.getLong("lastSynced");
                        int id = resultSet.getInt("id");
                        String mediaType1 = resultSet.getString("mediaType");
                        mediaFolderTO.setFolderPath(filePath);
                        mediaFolderTO.setLastSyncTime(lastSyncTime);
                        mediaFolderTO.setId(id);
                        mediaFolderTO.setMediaType(mediaType1);
                        mediaBackUpList.add(mediaFolderTO);
                    }
                }
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while selcting from MKFT table", (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set for geting Oldest Image Table Name" + e);
                    }
                }
            }
            this.closeConnection();
        }
        return mediaBackUpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertAParentFolder(MediaFolderTO file) {
        String query = "insert into MKFT(completefolderpath,lastSynced,mediaType) values(?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into MKFT(completefolderpath,lastSynced,mediaType) values(?,?,?);");
                this.statement.setString(1, file.getFolderPath());
                this.statement.setLong(2, file.getLastSyncTime());
                this.statement.setString(3, file.getMediaType());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while inserting parent folder", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListOfParentFoldersToTable(List<BackupFolderTO> files) {
        String query = "insert into MKFT(completefolderpath,lastBackup) values(?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into MKFT(completefolderpath,lastBackup) values(?,?);");
                int listsize = files.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, files.get(recordCount).getFolderPath());
                    this.statement.setLong(2, files.get(recordCount).getLastSyncTime());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while inserting list of parent folders", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAParentFolder(MediaFolderTO file) {
        String query = "delete from MKFT where mediaType= ?;";
        String query2 = "delete from MKIT where filepath like ? or filepath like ?;";
        boolean success = false;
        this.statement = null;
        Statement statement2 = null;
        if (this.getConnection()) {
            try {
                this.conn.setAutoCommit(false);
                this.statement = this.conn.prepareStatement("delete from MKFT where mediaType= ?;");
                this.statement.setString(1, file.getMediaType());
                this.statement.execute();
                statement2 = this.conn.prepareStatement("delete from MKIT where filepath like ? or filepath like ?;");
                statement2.setString(1, file.getFolderPath());
                statement2.setString(2, file.getFolderPath() + StringLiterals.FILE_SEPARATOR + "%");
                statement2.execute();
                this.conn.commit();
                statement2.close();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.trace("" + exception);
                this.logger.error("SQLException while deleting", (Object)exception.getMessage());
            }
            finally {
                try {
                    if (statement2 != null) {
                        statement2.close();
                    }
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.error("SQLException while deleting parent folder", (Object)e.getMessage());
                }
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListOfFolderFromTable(List<BackupFolderTO> files) {
        String query = "delete from MKFT where completefolderpath=?;";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from MKFT where completefolderpath=?;");
                int listsize = files.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, files.get(recordCount).getFolderPath());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while removing List Of Folder From  Table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAll(List<BackupFolderTO> files) {
        String query = "update MKFT set lastBackup=? where id=?;";
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("update MKFT set lastBackup=? where id=?;");
                int listsize = files.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setLong(1, files.get(recordCount).getLastSyncTime());
                    this.statement.setInt(2, files.get(recordCount).getId());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while updating All to media table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfTableIsEmpty() {
        block20: {
            String query = " select * from MKFT;";
            this.statement = null;
            ResultSet resultSet = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(" select * from MKFT;");
                    resultSet = this.statement.executeQuery();
                    if (resultSet != null) {
                        if (resultSet.next()) {
                            resultSet.close();
                            boolean bl = false;
                            return bl;
                        }
                        break block20;
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while selcting from backup media table", (Throwable)exception);
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing resultset for selcting from backup media table", (Throwable)e);
                        }
                    }
                    this.closeConnection();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSyncPath(String mediaType) {
        String filePath = "";
        String query = " select * from MKFT where mediaType = \"" + mediaType + "\";";
        this.statement = null;
        ResultSet resultSet = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                resultSet = this.statement.executeQuery();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        filePath = resultSet.getString("completefolderpath");
                    }
                }
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while selcting from backup", (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set for geting Oldest Image Table Name" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return filePath;
    }
}

