/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.ChunkTableDAO;
import com.parablu.epa.core.to.ChunkFileTO;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkTableDAOImpl
extends BaseDAO
implements ChunkTableDAO {
    private Logger logger = LoggerFactory.getLogger(ChunkTableDAOImpl.class);
    private static final String DELETEFROM = "delete from ";
    private static final String SQLEXCEPTION_WHILE_DELETING = "SQLException while delete";
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private static final String RENAME_TO = " RENAME TO ";

    public ChunkTableDAOImpl(String uRL) {
        super(uRL);
    }

    public boolean alterTable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearBackupChunkTable(List<ChunkFileTO> chunkFileTOs) {
        String query = "delete from BKPCHUNK where checksum=?;";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from BKPCHUNK where checksum=?;");
                int listsize = chunkFileTOs.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, chunkFileTOs.get(recordCount).getMd5Checksum());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_DELETING, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    public boolean clearEntireBackupChunkTable(String tableName, String tableType) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createBackupChunkTable(String tableName) {
        String query = BluSyncSQLConstants.createBackupChunkTable((String)tableName);
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while creating backup chunk table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createTempBackupChunkTable(String tableName) {
        String query = BluSyncSQLConstants.createBackupTempChunkTable((String)tableName);
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while creating backup chunk table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChunkExists(String tableName, String checksum, String tableType) {
        String tableNameFull = this.getTableNameFull(tableName, tableType);
        String query = "select * from " + tableNameFull + " where " + "checksum" + " = \"" + checksum + "\"";
        this.statement = null;
        ResultSet resultSet = null;
        boolean isExists = false;
        if (this.getConnection()) {
            try {
                this.logger.debug("query......" + query);
                this.statement = this.conn.prepareStatement(query);
                resultSet = this.statement.executeQuery();
                if (resultSet != null && resultSet.next()) {
                    isExists = true;
                }
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while seelct from backup chunk table:" + exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set while seelct from backup chunk table :" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return isExists;
    }

    private String getTableNameFull(String tableName, String tableType) {
        String tableNameFull = tableType.equalsIgnoreCase("temp") ? BluSyncSQLConstants.getTempBackupChunkTable((String)tableName) : BluSyncSQLConstants.getBackupChunkTable((String)tableName);
        return tableNameFull;
    }

    public int getCountOfTable() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertChunkFileTO(String tableName, String tableType, ChunkFileTO chunkFileTO) {
        String tableNameFull = this.getTableNameFull(tableName, tableType);
        String query = "insert into " + tableNameFull + "(" + "checksum" + ") values(?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.setString(1, chunkFileTO.getMd5Checksum());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while insert parent folder into backup crawl table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    public boolean insertFileNameIntoTable(File arg0) {
        return false;
    }

    public boolean insertListOfChunksIntoTable(String tableName, String tableType, List<ChunkFileTO> arg0) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameTable(String tableName) {
        String oldName = BluSyncSQLConstants.getTempBackupChunkTable((String)tableName);
        String newName = BluSyncSQLConstants.getBackupChunkTable((String)tableName);
        String query = ALTER_TABLE + oldName + RENAME_TO + newName;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while renaming", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        if (!success) {
            String copyQuery = "insert into " + newName + " SELECT * FROM " + oldName;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(copyQuery);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while copying the values", (Throwable)exception);
                }
                finally {
                    this.closeConnection();
                }
            }
        }
        return success;
    }
}

