/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.dao.BackUpFolderDAO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.InclusionTO;
import com.parablu.epa.core.to.NWThrottlingTO;
import com.parablu.epa.core.to.ScheduleTO;
import com.parablu.epa.core.to.ScriptTo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackUpFolderDAOImpl
extends BaseDAO
implements BackUpFolderDAO {
    private Logger logger = LoggerFactory.getLogger(BackUpFolderDAOImpl.class);
    private static final String DELETEFROM = "delete from ";
    private static final String SQLEXCEPTION_WHILE_CREATINGBACKUP = "SQLException while creating backup";
    private static final String SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER = "SQLException while inserting parent folder";
    private static final String VALUES = ") values(?,?);";
    private static final String VALUES_WITH_FOUR_PLACEHOLDERS = ") values(?,?,?,?);";

    public BackUpFolderDAOImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearTable() {
        String query = "delete from BKFT";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from BKFT");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while deleting  from backp table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createBackUpTable() {
        String query = BluSyncSQLConstants.CREATE_BACKUP_FOLDER_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.trace("" + exception);
                this.logger.error(SQLEXCEPTION_WHILE_CREATINGBACKUP, (Object)exception.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getInclusionExtensions() {
        String query = "select * from INCLUSIONS";
        HashMap<String, String> filterMap = null;
        this.statement = null;
        ResultSet resultSet = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("select * from INCLUSIONS");
                resultSet = this.statement.executeQuery();
                if (resultSet != null) {
                    filterMap = new HashMap<String, String>();
                    while (resultSet.next()) {
                        filterMap.put("extensionName", String.valueOf(resultSet.getString("extensionName")));
                        filterMap.put("filterType", resultSet.getString("filterType"));
                    }
                }
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while selecting from Inclusions ", (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set for geting Previous Image Table Name" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return filterMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupFolderTO> getAllFolderToBackUpFiles() {
        String query = "select * from BKFT";
        ArrayList<BackupFolderTO> files = null;
        this.statement = null;
        ResultSet resultSet = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("select * from BKFT");
                resultSet = this.statement.executeQuery();
                files = new ArrayList<BackupFolderTO>();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        BackupFolderTO backupFolderTO = new BackupFolderTO();
                        String filePath = resultSet.getString("completefolderpath");
                        long lastSyncTime = resultSet.getLong("lastBackup");
                        int id = resultSet.getInt("id");
                        String createdBy = resultSet.getString("createdBy");
                        String policyName = resultSet.getString("policyGroupName");
                        backupFolderTO.setFolderPath(filePath);
                        backupFolderTO.setLastSyncTime(lastSyncTime);
                        backupFolderTO.setId(id);
                        backupFolderTO.setCreateBy(createdBy);
                        backupFolderTO.setPolicyName(policyName);
                        files.add(backupFolderTO);
                    }
                }
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while selcting from backup", (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set for geting folders to backup" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertAParentFolder(BackupFolderTO file) {
        String query = "insert into BKFT(completefolderpath,lastBackup,createdBy,policyGroupName) values(?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into BKFT(completefolderpath,lastBackup,createdBy,policyGroupName) values(?,?,?,?);");
                this.statement.setString(1, file.getFolderPath());
                this.statement.setLong(2, file.getLastSyncTime());
                this.statement.setString(3, file.getCreateBy());
                this.statement.setString(4, file.getPolicyName());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertNetworkThrottling(NWThrottlingTO nwThrottlingTO) {
        String query = "insert into NETWORKTHROTTLING(NTName,maxSpeed,uploadSpeed,downloadSpeed,startTime,endTime) values(?,?,?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into NETWORKTHROTTLING(NTName,maxSpeed,uploadSpeed,downloadSpeed,startTime,endTime) values(?,?,?,?,?,?);");
                this.statement.setString(1, nwThrottlingTO.getNwName());
                this.statement.setString(2, nwThrottlingTO.getMaxSpeed());
                this.statement.setString(3, nwThrottlingTO.getUploadSpeed());
                this.statement.setString(4, nwThrottlingTO.getDownloadSpeed());
                this.statement.setString(5, nwThrottlingTO.getStartTime());
                this.statement.setString(6, nwThrottlingTO.getEndTime());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertSchedules(ScheduleTO scheduleTO) {
        String query = "insert into SCHEDULES(scheduleName,startTime,dayArray,backupType,containerName) values(?,?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into SCHEDULES(scheduleName,startTime,dayArray,backupType,containerName) values(?,?,?,?,?);");
                this.statement.setString(1, scheduleTO.getScheduleName());
                this.statement.setString(2, scheduleTO.getStartTime());
                this.statement.setString(3, scheduleTO.getDayArray());
                this.statement.setString(4, scheduleTO.getBackupType());
                this.statement.setString(5, scheduleTO.getContainerName());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while inserting Schedules", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertInclusions(InclusionTO inclusionTO) {
        String query = "insert into INCLUSIONS(filterName,extensionName,policyGroupName,filterType) values(?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into INCLUSIONS(filterName,extensionName,policyGroupName,filterType) values(?,?,?,?);");
                this.statement.setString(1, inclusionTO.getFilterName());
                this.statement.setString(2, inclusionTO.getExtensionName());
                this.statement.setString(3, inclusionTO.getPolicyName());
                this.statement.setString(4, inclusionTO.getFilterType());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListOfParentFoldersToTable(List<BackupFolderTO> files) {
        String query = "insert into BKFT(completefolderpath,lastBackup) values(?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into BKFT(completefolderpath,lastBackup) values(?,?);");
                int listsize = files.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, files.get(recordCount).getFolderPath());
                    this.statement.setLong(2, files.get(recordCount).getLastSyncTime());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while inserting list of parent folders", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAParentFolder(BackupFolderTO file) {
        String query = "delete from BKFT where completefolderpath= ?;";
        String query2 = "delete from BKIT where filepath like ? or filepath like ?;";
        boolean success = false;
        this.statement = null;
        Statement statement2 = null;
        if (this.getConnection()) {
            try {
                this.conn.setAutoCommit(false);
                this.statement = this.conn.prepareStatement("delete from BKFT where completefolderpath= ?;");
                this.statement.setString(1, file.getFolderPath());
                this.statement.execute();
                statement2 = this.conn.prepareStatement("delete from BKIT where filepath like ? or filepath like ?;");
                statement2.setString(1, file.getFolderPath());
                statement2.setString(2, file.getFolderPath() + StringLiterals.FILE_SEPARATOR + "%");
                statement2.execute();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.trace("" + exception);
                this.logger.error("SQLException while deleting parent folder", (Object)exception.getMessage());
            }
            finally {
                if (statement2 != null) {
                    try {
                        statement2.close();
                    }
                    catch (SQLException e) {
                        this.logger.trace("" + e);
                        this.logger.error("SQLException while deleting parent folder", (Object)e.getMessage());
                    }
                }
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListOfFolderFromTable(List<BackupFolderTO> files) {
        String query = "delete from BKFT where completefolderpath=?;";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from BKFT where completefolderpath=?;");
                int listsize = files.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, files.get(recordCount).getFolderPath());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while removeListOfFolderFromTable", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAll(List<BackupFolderTO> files) {
        String query = "update BKFT set lastBackup=? where id=?;";
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("update BKFT set lastBackup=? where id=?;");
                int listsize = files.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setLong(1, files.get(recordCount).getLastSyncTime());
                    this.statement.setInt(2, files.get(recordCount).getId());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while updateAll", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertGatewayNames(GatewayTO gatewayTO) {
        String query = "insert into GATEWAYLIST(GatewayName,Type,policyGroupName,ProductType) values(?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into GATEWAYLIST(GatewayName,Type,policyGroupName,ProductType) values(?,?,?,?);");
                this.statement.setString(1, gatewayTO.getGatewayName());
                this.statement.setString(2, gatewayTO.getType());
                this.statement.setString(3, gatewayTO.getPolicyName());
                this.statement.setString(4, gatewayTO.getProductType());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while insert parent folder", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHitTime(GatewayTO gatewayTO) {
        String query = "update GATEWAYLIST set HitTime=? where GatewayName=?;";
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("update GATEWAYLIST set HitTime=? where GatewayName=?;");
                this.conn.setAutoCommit(false);
                this.statement.setLong(1, gatewayTO.getHitTime());
                this.statement.setString(2, gatewayTO.getGatewayName());
                this.statement.addBatch();
                this.statement.executeBatch();
                this.conn.commit();
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while updating Privacy gateway", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alterTable() {
        this.statement = null;
        String query = "ALTER table SCHEDULES ADD COLUMN dayArray TEXT;";
        String query1 = "ALTER table SCHEDULES ADD COLUMN backupType TEXT;";
        boolean success = false;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.logger.debug("alter table query: " + query);
                this.logger.debug("alter table query1: " + query1);
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                this.statement.close();
                this.statement = this.conn.prepareStatement(query1);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("sqlExeception in CREATE_ACTIVITY_TABLE" + e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createCalloutScriptTable() {
        String query = BluSyncSQLConstants.CREATE_CALLOUT_SCRIPT_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.trace("" + exception);
                this.logger.error(SQLEXCEPTION_WHILE_CREATINGBACKUP, (Object)exception.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertScripts(ScriptTo scriptTo) {
        String query = "insert into SCRIPTS(scriptname,type,arguments,timestamp) values(?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into SCRIPTS(scriptname,type,arguments,timestamp) values(?,?,?,?);");
                this.statement.setString(1, scriptTo.getScriptName());
                this.statement.setString(2, scriptTo.getScriptType());
                this.statement.setString(3, scriptTo.getScriptArgs().toString());
                this.statement.setString(4, scriptTo.getScriptTimestamp());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createFullBackupScheduleTable() {
        String query = BluSyncSQLConstants.CREATE_FULL_BACKUP_SCHEDULES_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.trace("" + exception);
                this.logger.error(SQLEXCEPTION_WHILE_CREATINGBACKUP, (Object)exception.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertFullBackupSchedule(String scriptSchedules) {
        String query = "insert into SCRIPTSCHEDULE (id , schedules) values(?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into SCRIPTSCHEDULE (id , schedules) values(?,?);");
                this.statement.setInt(1, 1);
                this.statement.setString(2, scriptSchedules);
                success = this.statement.execute();
            }
            catch (SQLException exception) {
                this.logger.trace("" + exception);
                this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Object)exception.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean newAlterTable() {
        this.statement = null;
        String query = "ALTER table BKFT ADD COLUMN policyGroupName TEXT;";
        boolean success = false;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.logger.debug("alter table query: " + query);
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("sqlExeception in Alter folder table" + e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }
}

