/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper.utils;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryUtils {
    private static Logger logger = LoggerFactory.getLogger(RegistryUtils.class);

    public static void setRegistryValue(String hKeyType, String regKeyPath, String keyName, String value) {
        WinReg.HKEY hKey = null;
        if (StringUtils.isEmpty((String)hKeyType) || StringUtils.isEmpty((String)regKeyPath) || StringUtils.isEmpty((String)value)) {
            return;
        }
        if ("HKLM".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_LOCAL_MACHINE;
        } else if ("HKCU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_CURRENT_USER;
        } else if ("HKU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_USERS;
        }
        Advapi32Util.registrySetStringValue((WinReg.HKEY)hKey, (String)regKeyPath, (String)keyName, (String)value);
    }

    public static String getRegistryValue(String hKeyType, String regKeyPath, String key) {
        WinReg.HKEY hKey = null;
        if (StringUtils.isEmpty((String)hKeyType) || StringUtils.isEmpty((String)regKeyPath) || StringUtils.isEmpty((String)key)) {
            return null;
        }
        if ("HKLM".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_LOCAL_MACHINE;
        } else if ("HKCU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_CURRENT_USER;
        } else if ("HKU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_USERS;
        }
        String value = Advapi32Util.registryGetStringValue((WinReg.HKEY)hKey, (String)regKeyPath, (String)key);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        return "null";
    }

    public static void setRegistryIntvalues(int value) {
        try {
            WinReg.HKEY hKey = WinReg.HKEY_LOCAL_MACHINE;
            Advapi32Util.registrySetIntValue((WinReg.HKEY)hKey, (String)"SOFTWARE\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}}_is1", (String)"SystemComponent", (int)value);
        }
        catch (Exception e) {
            logger.debug("error in adding registry value.. to hide agent" + e.getMessage());
        }
    }
}

