/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MD5Generator {
    private static Logger logger = LoggerFactory.getLogger(MD5Generator.class);
    private static final String FUNC_GENERATEMD5OFFILE = "generateMD5OfFile";

    private MD5Generator() {
    }

    public static String generateMD5OfFile(File file) {
        String md5 = null;
        if (!MD5Generator.handleFileExist(file)) {
            logger.error("File not found while creating md5>>" + file.getAbsolutePath());
            return null;
        }
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
            md5 = new String(Hex.encodeHex((byte[])DigestUtils.md5((InputStream)input)));
        }
        catch (Exception exception) {
            logger.trace(FUNC_GENERATEMD5OFFILE + exception);
            logger.error(exception.getMessage() + "(File Name:" + file.getAbsolutePath() + ")");
        }
        return md5;
    }

    public static String generateMD5OfString(String convertTo) {
        return new String(Hex.encodeHex((byte[])DigestUtils.md5((String)convertTo)));
    }

    public static String generateMD5HexOfString(byte[] convertTo) {
        return new String(DigestUtils.md5Hex((byte[])convertTo));
    }

    private static boolean handleFileExist(File file) {
        if (!file.exists()) {
            logger.error("file doesnt exist: " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    public static String getSHA512hash(String passHash) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] digesta = null;
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-512", "BC");
            digesta = mda.digest(passHash.getBytes());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            logger.trace("getSHA512hash : " + e);
            logger.trace(e.getMessage());
        }
        return Hex.encodeHexString((byte[])digesta);
    }

    public static String generateMD5ForByteArray(byte[] bytes) {
        String md5 = null;
        try {
            md5 = new String(Hex.encodeHex((byte[])DigestUtils.md5((InputStream)new ByteArrayInputStream(bytes))));
        }
        catch (Exception exception) {
            logger.trace("execption while genrating MD5 for stream" + exception);
            logger.error(exception.getMessage());
        }
        return md5;
    }
}

