/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DPIUtil {
    static final int DPI_ZOOM_200 = 192;
    static final int DPI_ZOOM_150 = 144;
    static final int DPI_ZOOM_100 = 96;
    private static boolean autoScaleEnable = true;
    private static int deviceZoom = 100;
    static final String SWT_ENABLE_AUTOSCALE = "swt.enable.autoScale";

    public static ImageData autoScaleDown(ImageData imageData) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || imageData == null) {
            return imageData;
        }
        float f = DPIUtil.getScalingFactor();
        return imageData.scaledTo(Math.round((float)imageData.width / f), Math.round((float)imageData.height / f));
    }

    public static int[] autoScaleDown(int[] nArray) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || nArray == null) {
            return nArray;
        }
        float f = DPIUtil.getScalingFactor();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = Math.round((float)nArray[i] / f);
        }
        return nArray2;
    }

    public static float[] autoScaleDown(float[] fArray) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || fArray == null) {
            return fArray;
        }
        float f = DPIUtil.getScalingFactor();
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i] = fArray[i] / f;
        }
        return fArray2;
    }

    public static int autoScaleDown(int n) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || n == -1) {
            return n;
        }
        float f = DPIUtil.getScalingFactor();
        return Math.round((float)n / f);
    }

    public static float autoScaleDown(float f) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || f == -1.0f) {
            return f;
        }
        float f2 = DPIUtil.getScalingFactor();
        return f / f2;
    }

    public static Point autoScaleDown(Point point) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || point == null) {
            return point;
        }
        float f = DPIUtil.getScalingFactor();
        Point point2 = new Point(0, 0);
        point2.x = Math.round((float)point.x / f);
        point2.y = Math.round((float)point.y / f);
        return point2;
    }

    public static Rectangle autoScaleDown(Rectangle rectangle) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || rectangle == null) {
            return rectangle;
        }
        float f = DPIUtil.getScalingFactor();
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        rectangle2.x = Math.round((float)rectangle.x / f);
        rectangle2.y = Math.round((float)rectangle.y / f);
        rectangle2.width = Math.round((float)rectangle.width / f);
        rectangle2.height = Math.round((float)rectangle.height / f);
        return rectangle2;
    }

    public static ImageData autoScaleImageData(ImageData imageData, int n, int n2) {
        if (!DPIUtil.isAutoScaleEnable() || imageData == null || n == n2) {
            return imageData;
        }
        float f = (float)n / (float)n2;
        return imageData.scaledTo(Math.round((float)imageData.width * f), Math.round((float)imageData.height * f));
    }

    public static Rectangle autoScaleBounds(Rectangle rectangle, int n, int n2) {
        if (!DPIUtil.isAutoScaleEnable() || rectangle == null || n == n2) {
            return rectangle;
        }
        float f = (float)n / (float)n2;
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        rectangle2.x = Math.round((float)rectangle.x * f);
        rectangle2.y = Math.round((float)rectangle.y * f);
        rectangle2.width = Math.round((float)rectangle.width * f);
        rectangle2.height = Math.round((float)rectangle.height * f);
        return rectangle2;
    }

    public static ImageData autoScaleUp(ImageData imageData) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || imageData == null) {
            return imageData;
        }
        float f = DPIUtil.getScalingFactor();
        return imageData.scaledTo(Math.round((float)imageData.width * f), Math.round((float)imageData.height * f));
    }

    public static int[] autoScaleUp(int[] nArray) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || nArray == null) {
            return nArray;
        }
        float f = DPIUtil.getScalingFactor();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = Math.round((float)nArray[i] * f);
        }
        return nArray2;
    }

    public static int autoScaleUp(int n) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || n == -1) {
            return n;
        }
        float f = DPIUtil.getScalingFactor();
        return Math.round((float)n * f);
    }

    public static float autoScaleUp(float f) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || f == -1.0f) {
            return f;
        }
        float f2 = DPIUtil.getScalingFactor();
        return f * f2;
    }

    public static Point autoScaleUp(Point point) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || point == null) {
            return point;
        }
        float f = DPIUtil.getScalingFactor();
        Point point2 = new Point(0, 0);
        point2.x = Math.round((float)point.x * f);
        point2.y = Math.round((float)point.y * f);
        return point2;
    }

    public static Rectangle autoScaleUp(Rectangle rectangle) {
        if (deviceZoom == 100 || !DPIUtil.isAutoScaleEnable() || rectangle == null) {
            return rectangle;
        }
        float f = DPIUtil.getScalingFactor();
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        rectangle2.x = Math.round((float)rectangle.x * f);
        rectangle2.y = Math.round((float)rectangle.y * f);
        rectangle2.width = Math.round((float)rectangle.width * f);
        rectangle2.height = Math.round((float)rectangle.height * f);
        return rectangle2;
    }

    public static boolean isAutoScaleEnable() {
        return autoScaleEnable;
    }

    private static float getScalingFactor() {
        float f = 1.0f;
        if (DPIUtil.isAutoScaleEnable()) {
            f = (float)DPIUtil.getDeviceZoom() / 100.0f;
        }
        return f;
    }

    public static int mapSFToZoom(float f) {
        return DPIUtil.mapDPIToZoom((int)(f * 96.0f));
    }

    public static int mapDPIToZoom(int n) {
        int n2 = n >= 192 ? 200 : (n >= 144 ? 150 : 100);
        return n2;
    }

    public static ImageData validateAndGetImageDataAtZoom(ImageDataProvider imageDataProvider, int n, boolean[] blArray) {
        ImageData imageData;
        if (imageDataProvider == null) {
            SWT.error(4);
        }
        boolean bl = blArray[0] = (imageData = imageDataProvider.getImageData(n)) != null;
        if (n != 100 && !blArray[0]) {
            imageData = imageDataProvider.getImageData(100);
        }
        if (imageData == null) {
            SWT.error(5);
        }
        return imageData;
    }

    public static String validateAndGetImagePathAtZoom(ImageFileNameProvider imageFileNameProvider, int n, boolean[] blArray) {
        String string;
        if (imageFileNameProvider == null) {
            SWT.error(4);
        }
        boolean bl = blArray[0] = (string = imageFileNameProvider.getImagePath(n)) != null;
        if (n != 100 && !blArray[0]) {
            string = imageFileNameProvider.getImagePath(100);
        }
        if (string == null) {
            SWT.error(5);
        }
        return string;
    }

    public static int getDeviceZoom() {
        return DPIUtil.isAutoScaleEnable() ? deviceZoom : 100;
    }

    public static void setDeviceZoom(int n) {
        deviceZoom = n;
    }

    static {
        String string = System.getProperty(SWT_ENABLE_AUTOSCALE);
        if (string != null && "false".equalsIgnoreCase(string)) {
            autoScaleEnable = false;
        }
    }

    public static final class AutoScaleImageDataProvider
    implements ImageDataProvider {
        ImageData imageData;
        int currentZoom;

        public AutoScaleImageDataProvider(ImageData imageData, int n) {
            this.imageData = imageData;
            this.currentZoom = n;
        }

        @Override
        public ImageData getImageData(int n) {
            return DPIUtil.autoScaleImageData(this.imageData, n, this.currentZoom);
        }
    }
}

