/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.support.SupportHelper;
import com.parablu.epa.common.view.BaseView;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.service.notifications.DirectoryRefreshHelper;
import com.parablu.epa.service.settings.VersionHelper;
import com.parablu.epa.service.settings.WindowsSettingsHelper;
import com.parablu.epa.view.BluSyncLauncher;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.SupportDialog;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccountManagementView
extends BaseView {
    protected static final Shell Shell = null;
    private static Logger logger = LoggerFactory.getLogger(AccountManagementView.class);
    private Composite aboutParabluPanel = null;
    private Label aboutParabluLabel = null;
    private Link websiteHelpLink = null;
    private Group accountDiscriptionPanel = null;
    private Label accountCloudNameStatementLabel = null;
    private Label currentUserNameStatementLabel = null;
    private Label currentDeviceNameStatementLabel = null;
    private Label currentDevicePublicIPLabel = null;
    FontsManager fontsManager;
    private Composite disconnectFromParaCloudButtonPanel = null;
    private Button disconnectFromParaCloudButton = null;
    private Composite aboutParabluPanel1 = null;
    private Label aboutParabluLabel1 = null;

    public AccountManagementView(Composite composite) {
        this.mainParentComposite = composite;
    }

    public void generateUI() {
        GridData curUserNameStatLabelGridData = new GridData();
        GridData curCloudNameStatLabelGridData = new GridData();
        GridData accountPanelGridData = new GridData(768);
        GridLayout accountDiscriptionPanelGridLayout = new GridLayout();
        Display display = this.mainParentComposite.getDisplay();
        this.fontsManager = new FontsManager(display);
        String userName = SettingHelper.getUserName();
        String cloudName = SettingHelper.getCloudName();
        String deviceName = SettingHelper.getDeviceName();
        String publicIp = SettingHelper.getPublicIpAddress();
        this.baseGroup = new Composite(this.mainParentComposite, 16);
        GridLayout accountPanelCompositeLayout = new GridLayout();
        accountPanelCompositeLayout.marginWidth = 5;
        accountPanelCompositeLayout.marginRight = 1;
        accountPanelCompositeLayout.marginLeft = 1;
        accountPanelCompositeLayout.marginTop = 2;
        accountPanelCompositeLayout.marginBottom = 5;
        accountPanelCompositeLayout.marginHeight = 0;
        accountPanelCompositeLayout.makeColumnsEqualWidth = false;
        accountPanelCompositeLayout.horizontalSpacing = 2;
        this.baseGroup.setLayout((Layout)accountPanelCompositeLayout);
        this.baseGroup.setLayoutData((Object)new GridData(1808));
        this.accountDiscriptionPanel = new Group(this.baseGroup, 8);
        accountDiscriptionPanelGridLayout.makeColumnsEqualWidth = false;
        accountDiscriptionPanelGridLayout.marginLeft = 5;
        accountDiscriptionPanelGridLayout.horizontalSpacing = 7;
        accountDiscriptionPanelGridLayout.verticalSpacing = 6;
        accountDiscriptionPanelGridLayout.marginTop = 6;
        accountDiscriptionPanelGridLayout.marginBottom = 1;
        this.accountDiscriptionPanel.setLayout((Layout)accountDiscriptionPanelGridLayout);
        accountPanelGridData.grabExcessHorizontalSpace = true;
        this.accountDiscriptionPanel.setText("Account Details");
        this.accountDiscriptionPanel.setFont(this.fontsManager.getSmallNormalFont());
        this.accountDiscriptionPanel.setLayoutData((Object)accountPanelGridData);
        this.accountCloudNameStatementLabel = new Label((Composite)this.accountDiscriptionPanel, 64);
        curCloudNameStatLabelGridData.verticalSpan = 2;
        curCloudNameStatLabelGridData.grabExcessHorizontalSpace = true;
        this.accountCloudNameStatementLabel.setLayoutData((Object)curCloudNameStatLabelGridData);
        this.accountCloudNameStatementLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.accountCloudNameStatementLabel.setText("Connected to " + cloudName);
        this.currentUserNameStatementLabel = new Label((Composite)this.accountDiscriptionPanel, 64);
        curUserNameStatLabelGridData.verticalSpan = 2;
        curUserNameStatLabelGridData.grabExcessHorizontalSpace = true;
        this.currentUserNameStatementLabel.setLayoutData((Object)curUserNameStatLabelGridData);
        this.currentUserNameStatementLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.currentUserNameStatementLabel.setText("Connected as " + userName);
        this.currentDeviceNameStatementLabel = new Label((Composite)this.accountDiscriptionPanel, 64);
        this.currentDeviceNameStatementLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.currentDeviceNameStatementLabel.setText("Device registered as " + deviceName);
        this.currentDevicePublicIPLabel = new Label((Composite)this.accountDiscriptionPanel, 64);
        this.currentDevicePublicIPLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.currentDevicePublicIPLabel.setText("Last known Server is " + publicIp);
        this.disconnectFromParaCloudButtonPanel = new Composite(this.baseGroup, 0x1000000);
        GridLayout disconnectFromParaCloudButtonPanelGridLayout = new GridLayout();
        disconnectFromParaCloudButtonPanelGridLayout.marginTop = 3;
        disconnectFromParaCloudButtonPanelGridLayout.marginLeft = 15;
        this.disconnectFromParaCloudButtonPanel.setLayout((Layout)disconnectFromParaCloudButtonPanelGridLayout);
        this.disconnectFromParaCloudButton = new Button(this.disconnectFromParaCloudButtonPanel, 72);
        GridData disconnectFromParaCloudButtonGridData = new GridData();
        disconnectFromParaCloudButtonGridData.verticalSpan = 1;
        disconnectFromParaCloudButtonGridData.horizontalIndent = 27;
        this.disconnectFromParaCloudButton.setLayoutData((Object)disconnectFromParaCloudButtonGridData);
        this.disconnectFromParaCloudButton.setText(PropertyHelper.DECOUPLE_CONFIRMATION_LABEL);
        this.disconnectFromParaCloudButton.setFont(this.fontsManager.getMediumNormalFont());
        this.disconnectFromParaCloudButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MessageBox dialog = new MessageBox(AccountManagementView.this.disconnectFromParaCloudButtonPanel.getShell(), 200);
                dialog.setText("Decouple Device");
                dialog.setMessage("This action will de-couple the device from Parablu server and will trigger a full backup if you choose to re-couple it again later.\nAre you sure you want to proceed?");
                int result = dialog.open();
                if (result == 64) {
                    logger.debug("Clicked on disconnect button");
                    int response = AccountManagementView.this.sendDecoupleRequest();
                    if (response == 200) {
                        if (NotificationHelper.isBackUpStarted()) {
                            PolicyManagementServerHelper.updateFailCodeToActivityHistory((int)911);
                            PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit((String)"STOPPED", (boolean)false);
                        }
                        WindowsSettingsHelper.dsconnectWebDAVasNetworkDrive();
                        DirectoryRefreshHelper directoryRefreshHelper = new DirectoryRefreshHelper();
                        directoryRefreshHelper.refreshDirectory();
                        BluSyncLauncher.changeAccount();
                    } else {
                        AccountManagementView.this.showDecoupleErrorMessage();
                    }
                }
            }
        });
    }

    public void generateUISupportdata() {
        StringBuilder aboutDisplayLabelText = new StringBuilder();
        this.readAboutStringFromFile(aboutDisplayLabelText);
        GridLayout aboutParabluPanelGridLayout = new GridLayout();
        aboutParabluPanelGridLayout.marginTop = 2;
        aboutParabluPanelGridLayout.marginLeft = 2;
        aboutParabluPanelGridLayout.verticalSpacing = 2;
        aboutParabluPanelGridLayout.numColumns = 2;
        aboutParabluPanelGridLayout.horizontalSpacing = 4;
        Display display = this.mainParentComposite.getDisplay();
        this.fontsManager = new FontsManager(display);
        this.aboutParabluPanel = new Composite(this.baseGroup, 2048);
        this.aboutParabluPanel.setLayoutData((Object)new GridData(768));
        this.aboutParabluPanel.setLayout((Layout)aboutParabluPanelGridLayout);
        this.aboutParabluLabel = new Label(this.aboutParabluPanel, 320);
        GridData gridData = new GridData(512);
        gridData.horizontalSpan = 2;
        this.aboutParabluLabel.setLayoutData((Object)gridData);
        this.aboutParabluLabel.setText(aboutDisplayLabelText.toString());
        this.aboutParabluLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.websiteHelpLink = new Link(this.aboutParabluPanel, 4);
        this.websiteHelpLink.setLayoutData((Object)new GridData(768));
        this.websiteHelpLink.setText("<a>Support Request</a>");
        this.websiteHelpLink.setFont(this.fontsManager.getMediumNormalFont());
        this.websiteHelpLink.setVisible(true);
        Listener listener = event -> {
            MessageBox supportLogAttachMsgBox = new MessageBox(this.mainParentComposite.getShell(), 196);
            supportLogAttachMsgBox.setMessage("Do you want to add end point logs with request?");
            supportLogAttachMsgBox.setText("Support request");
            int response = supportLogAttachMsgBox.open();
            if (response == 64) {
                if (SupportHelper.isSupportRequestInitiated()) {
                    logger.debug("Support Request Initiated = " + SupportHelper.isSupportRequestInitiated());
                    return;
                }
                SupportDialog supportDialog = new SupportDialog(this.mainParentComposite.getShell());
                supportDialog.sendLogsAndShowAppropriateDialog();
            }
            logger.debug("Clicked on Help Hyperlink");
            String mailto = PropertyHelper.HELP_LINK_SEND_MAIL + "?subject=" + AccountManagementView.encode(SupportHelper.getSupportRequestId());
            Program.launch((String)mailto);
            SupportHelper.setSupportRequestId(null);
        };
        this.websiteHelpLink.addListener(13, listener);
    }

    private static String encode(String strData) {
        String data = strData;
        if (data == null) {
            data = "";
        }
        try {
            return URLEncoder.encode(data, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.debug("UnsupportedEncodingException:" + e.getMessage());
            return data;
        }
    }

    public void readAboutStringFromFile(StringBuilder aboutDisplayLabelText) {
        try {
            aboutDisplayLabelText.append("Parablu Endpoint Agent").append("\n");
            aboutDisplayLabelText.append("Version: " + VersionHelper.getProductVersion()).append("\n");
            aboutDisplayLabelText.append("\n");
            aboutDisplayLabelText.append("Parablu Inc 2019");
        }
        catch (Exception e) {
            logger.error("Error in display about details>>>>" + e);
        }
    }

    public void disposeAllAccountWidgets() {
        this.fontsManager.disposeFonts();
        this.disposeAllaccountDiscriptionFields();
        if (this.accountDiscriptionPanel != null && !this.accountDiscriptionPanel.isDisposed()) {
            this.accountDiscriptionPanel.dispose();
        }
        if (this.disconnectFromParaCloudButtonPanel != null && !this.disconnectFromParaCloudButtonPanel.isDisposed()) {
            this.disconnectFromParaCloudButtonPanel.dispose();
        }
        this.disconnectFromParaCloudButtonPanel = null;
        this.accountDiscriptionPanel = null;
    }

    private void disposeAllaccountDiscriptionFields() {
        if (this.accountCloudNameStatementLabel != null && !this.accountCloudNameStatementLabel.isDisposed()) {
            this.accountCloudNameStatementLabel.dispose();
        }
        if (this.currentUserNameStatementLabel != null && !this.currentUserNameStatementLabel.isDisposed()) {
            this.currentUserNameStatementLabel.dispose();
        }
        if (this.disconnectFromParaCloudButton != null && !this.disconnectFromParaCloudButton.isDisposed()) {
            this.disconnectFromParaCloudButton.dispose();
        }
        this.accountCloudNameStatementLabel = null;
        this.currentUserNameStatementLabel = null;
        this.disconnectFromParaCloudButton = null;
    }

    public void disposeAllAboutParabluFields() {
        this.fontsManager.disposeFonts();
        this.disposeAllAboutParabluPanelFields();
        if (this.aboutParabluPanel != null && !this.aboutParabluPanel.isDisposed()) {
            this.aboutParabluPanel.dispose();
        }
        this.aboutParabluPanel = null;
    }

    private void disposeAllAboutParabluPanelFields() {
        if (this.aboutParabluLabel != null && !this.aboutParabluLabel.isDisposed()) {
            this.aboutParabluLabel.dispose();
        }
        if (this.websiteHelpLink != null && !this.websiteHelpLink.isDisposed()) {
            this.websiteHelpLink.dispose();
        }
        this.aboutParabluLabel = null;
        this.websiteHelpLink = null;
    }

    private int sendDecoupleRequest() {
        BackupAdapter backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        int response = 0;
        try {
            response = backupAdapter.getDecoupleResponse(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), SettingHelper.readTokenFromFile());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception" + e.getMessage());
        }
        return response;
    }

    private void showDecoupleErrorMessage() {
        MessageBox msg = new MessageBox(this.disconnectFromParaCloudButtonPanel.getShell(), 34);
        msg.setText("Cannot Decouple");
        msg.setMessage("Could not connect to server. User will not be decoupled from the device.");
        msg.open();
    }

    public void generateUIforAbout() {
        GridData curUserNameStatLabelGridData = new GridData();
        GridData curCloudNameStatLabelGridData = new GridData();
        GridData accountPanelGridData = new GridData(768);
        GridLayout accountDiscriptionPanelGridLayout = new GridLayout();
        Display display = this.mainParentComposite.getDisplay();
        this.fontsManager = new FontsManager(display);
        String userName = SettingHelper.getUserName();
        String cloudName = SettingHelper.getCloudName();
        String deviceName = SettingHelper.getDeviceName();
        String publicIp = SettingHelper.getPublicIpAddress();
        this.baseGroup = new Composite(this.mainParentComposite, 16);
        GridLayout accountPanelCompositeLayout = new GridLayout();
        accountPanelCompositeLayout.marginWidth = 5;
        accountPanelCompositeLayout.marginRight = 1;
        accountPanelCompositeLayout.marginLeft = 1;
        accountPanelCompositeLayout.marginTop = 2;
        accountPanelCompositeLayout.marginBottom = 5;
        accountPanelCompositeLayout.marginHeight = 0;
        accountPanelCompositeLayout.makeColumnsEqualWidth = false;
        accountPanelCompositeLayout.horizontalSpacing = 2;
        this.baseGroup.setLayout((Layout)accountPanelCompositeLayout);
        this.baseGroup.setLayoutData((Object)new GridData(1808));
        this.accountDiscriptionPanel = new Group(this.baseGroup, 8);
        accountDiscriptionPanelGridLayout.makeColumnsEqualWidth = false;
        accountDiscriptionPanelGridLayout.marginLeft = 5;
        accountDiscriptionPanelGridLayout.horizontalSpacing = 7;
        accountDiscriptionPanelGridLayout.verticalSpacing = 6;
        accountDiscriptionPanelGridLayout.marginTop = 6;
        accountDiscriptionPanelGridLayout.marginBottom = 1;
        this.accountDiscriptionPanel.setLayout((Layout)accountDiscriptionPanelGridLayout);
        accountPanelGridData.grabExcessHorizontalSpace = true;
        this.accountDiscriptionPanel.setText("Account Details");
        this.accountDiscriptionPanel.setFont(this.fontsManager.getSmallNormalFont());
        this.accountDiscriptionPanel.setLayoutData((Object)accountPanelGridData);
        this.accountCloudNameStatementLabel = new Label((Composite)this.accountDiscriptionPanel, 64);
        curCloudNameStatLabelGridData.verticalSpan = 2;
        curCloudNameStatLabelGridData.grabExcessHorizontalSpace = true;
        this.accountCloudNameStatementLabel.setLayoutData((Object)curCloudNameStatLabelGridData);
        this.accountCloudNameStatementLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.accountCloudNameStatementLabel.setText("Connected to " + cloudName);
        this.currentUserNameStatementLabel = new Label((Composite)this.accountDiscriptionPanel, 64);
        curUserNameStatLabelGridData.verticalSpan = 2;
        curUserNameStatLabelGridData.grabExcessHorizontalSpace = true;
        this.currentUserNameStatementLabel.setLayoutData((Object)curUserNameStatLabelGridData);
        this.currentUserNameStatementLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.currentUserNameStatementLabel.setText("Connected as " + userName);
        this.currentDeviceNameStatementLabel = new Label((Composite)this.accountDiscriptionPanel, 64);
        this.currentDeviceNameStatementLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.currentDeviceNameStatementLabel.setText("Device registered as " + deviceName);
        this.currentDevicePublicIPLabel = new Label((Composite)this.accountDiscriptionPanel, 64);
        this.currentDevicePublicIPLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.currentDevicePublicIPLabel.setText("Last known Server is " + publicIp);
    }

    public void generateUISupportdataforAbout() {
        StringBuilder aboutDisplayLabelText = new StringBuilder();
        this.readAboutStringFromFile(aboutDisplayLabelText);
        GridLayout aboutParabluPanelGridLayout = new GridLayout();
        aboutParabluPanelGridLayout.marginTop = 2;
        aboutParabluPanelGridLayout.marginLeft = 2;
        aboutParabluPanelGridLayout.verticalSpacing = 2;
        aboutParabluPanelGridLayout.numColumns = 2;
        aboutParabluPanelGridLayout.horizontalSpacing = 4;
        Display display = this.mainParentComposite.getDisplay();
        this.fontsManager = new FontsManager(display);
        this.aboutParabluPanel = new Composite(this.baseGroup, 2048);
        this.aboutParabluPanel.setLayoutData((Object)new GridData(768));
        this.aboutParabluPanel.setLayout((Layout)aboutParabluPanelGridLayout);
        this.aboutParabluLabel = new Label(this.aboutParabluPanel, 320);
        GridData gridData = new GridData(512);
        gridData.horizontalSpan = 2;
        this.aboutParabluLabel.setLayoutData((Object)gridData);
        this.aboutParabluLabel.setText(aboutDisplayLabelText.toString());
        this.aboutParabluLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.aboutParabluLabel1 = new Label(this.baseGroup, 0x1000100);
        GridData gridData11 = new GridData(4, 0x1000000, true, true, 1, 1);
        this.aboutParabluLabel1.setLayoutData((Object)gridData11);
        this.aboutParabluLabel1.setText("Copyright \u00a9 2019 Parablu Inc. All rights reserved.");
        this.aboutParabluLabel1.setFont(this.fontsManager.getLargeNormalFont());
    }
}

