/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.support;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.api.SupportAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.NewSupportElement;
import com.parablu.epa.core.element.SupportElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SupportHelper {
    private static SupportAdapter supportAdapter = new SupportAdapter(SettingHelper.getKeystorePath());
    private static boolean supportRequestInitiated = false;
    private static String supportRequestId = null;
    private static Logger logger = LoggerFactory.getLogger(SupportHelper.class);

    private SupportHelper() {
    }

    public static int sendLogs(String message, String text, String cloudName, String name, String emailAddress, boolean sendLogs) {
        if (StringUtils.isEmpty((String)text) && StringUtils.isEmpty((String)message) && !sendLogs) {
            supportRequestInitiated = false;
            return 0;
        }
        boolean logsSent = SupportHelper.sendSupportLogs(message, text, cloudName, name, emailAddress, sendLogs);
        supportRequestInitiated = false;
        if (logsSent) {
            return 2;
        }
        logger.debug("SEND LOG REQUEST FAILED");
        return 1;
    }

    private static boolean sendSupportLogs(String message, String text, String cloudName, String name, String emailAddress, boolean sendLogs) {
        supportRequestInitiated = true;
        String requestId = null;
        SupportElement supportElement = new SupportElement();
        supportElement.setCloudName(cloudName);
        supportElement.setCustomerName(name);
        supportElement.setRequestDescription(message);
        supportElement.setRequestSubject(text);
        supportElement.setEmailAddress(emailAddress);
        String token = null;
        try {
            token = SettingHelper.readTokenFromFile();
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception geting token:" + e.getMessage());
        }
        logger.debug("Sending prelim request");
        NewSupportElement element = new NewSupportElement();
        if (supportAdapter.sendSupportMessage(cloudName, element, SettingHelper.getCurrentCloudIpAddress(), token)) {
            requestId = supportAdapter.getRequestID();
        }
        if (requestId == null) {
            logger.debug("supportAdapter.getRequestID() = null");
            return false;
        }
        supportRequestId = requestId;
        if (!sendLogs) {
            return true;
        }
        logger.debug("Compressing Files");
        File file = SupportHelper.compressLogs();
        if (file == null) {
            return false;
        }
        logger.debug("Sending Support File");
        if (supportAdapter.sendSupportLogs(file, cloudName)) {
            file.delete();
            return true;
        }
        file.delete();
        return false;
    }

    private static File compressLogs() {
        File debugFile = new File(SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.FILE_SEPARATOR + "BluSync.debug");
        File warnFile = new File(SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.FILE_SEPARATOR + "BluSync.warn");
        File errorFile = new File(SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.FILE_SEPARATOR + "BluSync.error");
        File infoFile = new File(SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.FILE_SEPARATOR + "BluSync.info");
        File logZip = new File(SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.FILE_SEPARATOR + "pblog.zip");
        if (logZip.exists()) {
            logZip.delete();
        }
        try {
            logZip.createNewFile();
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(logZip));){
                SupportHelper.addEntryToZip(debugFile, zipOutputStream);
                SupportHelper.addEntryToZip(warnFile, zipOutputStream);
                SupportHelper.addEntryToZip(errorFile, zipOutputStream);
                SupportHelper.addEntryToZip(infoFile, zipOutputStream);
            }
            return logZip;
        }
        catch (IOException e) {
            logger.error("IOException while entering to zip", (Throwable)e);
            return null;
        }
    }

    private static void addEntryToZip(File logFile, ZipOutputStream zipOutputStream) throws IOException {
        if (logFile.exists()) {
            ZipEntry zipEntry = new ZipEntry(logFile.getName());
            zipOutputStream.putNextEntry(zipEntry);
            FileInputStream fileInputStream = new FileInputStream(logFile);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
            fileInputStream.close();
            zipOutputStream.closeEntry();
        }
    }

    public static boolean isSupportRequestInitiated() {
        return supportRequestInitiated;
    }

    public static void setSupportRequestInitiated(boolean supportRequestInitiated) {
        SupportHelper.supportRequestInitiated = supportRequestInitiated;
    }

    public static String getSupportRequestId() {
        return supportRequestId;
    }
}

