/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.notifications;

import com.parablu.epa.common.service.notification.EventHandler;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.support.SupportHelper;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.alarm.ManualSyncHelper;
import com.parablu.epa.service.backup.WindowsCheckBackupPolicy;
import com.parablu.epa.service.backup.WindowsCheckSyncPolicy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsEventsManagement {
    private Logger logger = LoggerFactory.getLogger(WindowsEventsManagement.class);
    private EventHandler eventHandler = new EventHandler();

    public void refreshPolicyTask() {
        List events = this.eventHandler.checkNotificationFromServer();
        events.forEach(action -> {
            if (EventHandler.Actions.PULL_AGENTLOGS.name().equalsIgnoreCase((String)action)) {
                if (SupportHelper.isSupportRequestInitiated()) {
                    this.logger.debug("isSupportRequestInitiated: " + SupportHelper.isSupportRequestInitiated());
                    return;
                }
                SupportHelper.sendNewSupportLogs((String)SettingHelper.getCloudName(), (String)SettingHelper.getUserName(), (String)SettingHelper.getDeviceName(), (boolean)true);
            }
            if (EventHandler.Actions.BACKUPPOLICY_REFRESH.name().equalsIgnoreCase((String)action)) {
                if (NotificationHelper.backUpStarted) {
                    WindowsCheckBackupPolicy.resetTimers();
                } else {
                    WindowsCheckBackupPolicy.checkGroupPolicy();
                }
                BlusyncThreadHelper.resetBackupTimer();
            }
            if (EventHandler.Actions.STOP_BACKUP.name().equalsIgnoreCase((String)action) && NotificationHelper.isBackUpStarted()) {
                this.logger.debug("Calling stop backup.");
                BlusyncThreadHelper.cancelCurrentBackupProcess(true, false);
            }
            if (EventHandler.Actions.START_BACKUP.name().equalsIgnoreCase((String)action)) {
                this.logger.debug("Calling start backup.");
                ManualSyncHelper.startManualBackup();
            }
            if (EventHandler.Actions.SYNCPOLICY_REFRESH.name().equalsIgnoreCase((String)action) && SettingHelper.getSyncLicenced().equals("true")) {
                WindowsCheckSyncPolicy.pullSyncPolicy();
                BlusyncThreadHelper.resetSyncTimer();
            }
            if (EventHandler.Actions.PULL_HISTORICAL_LOGS.name().equalsIgnoreCase((String)action)) {
                SupportHelper.sendHistoricalLogs((String)SettingHelper.getCloudName(), (String)SettingHelper.getUserName(), (String)SettingHelper.getDeviceName(), (boolean)true);
            }
            if (EventHandler.Actions.HARD_STOP_BACKUP.name().equalsIgnoreCase((String)action) && NotificationHelper.isBackUpStarted()) {
                this.logger.debug("Calling stop backup.");
                BlusyncThreadHelper.cancelCurrentBackupProcess(true, false);
            }
        });
    }
}

