/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper;

import com.parablu.epa.common.dao.BackupCrawlDAOImpl;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.helper.enumeration.BackupFoldersToBeSkipped;
import com.parablu.epa.core.to.FileTO;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupCrawlUtility {
    private Logger logger = LoggerFactory.getLogger(BackupCrawlUtility.class);
    private int lastSuccessfulCrawledTime = 0;
    BackupCrawlDAOImpl backupCrawlDAOImpl = new BackupCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());

    public void crawlFolderEfficientStoringFullPaths(String completeParentPath, Map<String, Long> fileHashMap) {
        ArrayList<File> crawledfiles = new ArrayList<File>();
        Boolean checkList = true;
        File currentFolder = new File(completeParentPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return;
        }
        Arrays.sort(childFileAndFolderNames, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        for (File currentProcessingFile : childFileAndFolderNames) {
            Long prevModifiedValue;
            if (currentProcessingFile.getName().startsWith(".pbsdn")) {
                currentProcessingFile.delete();
                continue;
            }
            boolean isfileHidden = "CHUNK".equals(currentProcessingFile.getName()) || currentProcessingFile.isHidden();
            boolean fileToBeSkipped = this.fileSkip(currentProcessingFile.getName());
            if (isfileHidden || fileToBeSkipped) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            if (checkList.booleanValue() && !isFileADirectory && (prevModifiedValue = fileHashMap.get(absPath)) != null && prevModifiedValue.equals(currentProcessingFile.lastModified())) continue;
            crawledfiles.add(currentProcessingFile);
            if (crawledfiles.size() > 500) {
                this.logger.debug("Exceeding file size list");
                this.backupCrawlDAOImpl.insertListOfFileNamesIntoTable(crawledfiles);
                crawledfiles = new ArrayList();
            }
            if (!isFileADirectory) continue;
            this.crawlFolderEfficientStoringFullPaths(currentProcessingFile.getAbsolutePath(), fileHashMap);
        }
        if (CollectionUtils.isNotEmpty(crawledfiles)) {
            this.logger.debug("Inside list of files less than 500 ");
            this.backupCrawlDAOImpl.insertListOfFileNamesIntoTable(crawledfiles);
            crawledfiles.clear();
        }
    }

    private boolean fileSkip(String fileName) {
        for (BackupFoldersToBeSkipped.WindowsBackupFoldersToBeSkipped beSkipped : BackupFoldersToBeSkipped.WindowsBackupFoldersToBeSkipped.values()) {
            if (!beSkipped.value().equalsIgnoreCase(fileName) && !fileName.toLowerCase().startsWith(beSkipped.value().toLowerCase())) continue;
            this.logger.debug("LIST OF FILES FROM ENUM SKIPPING FILE " + fileName);
            return true;
        }
        return false;
    }

    public List<FileTO> showFolderContent() {
        return Collections.emptyList();
    }

    public int getLastSuccessfulCrawledTime() {
        return this.lastSuccessfulCrawledTime;
    }
}

