/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.helper;

import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.RestoreElement;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreHelper {
    static String osType = System.getProperty("os.name");
    private static Logger logger = LoggerFactory.getLogger(RestoreHelper.class);
    private static final String USER_HOME_DIR = "user.home";
    private static final String FILESEPARATOR = StringLiterals.FILE_SEPARATOR;
    private static final String DEFAULT_RESTORE_PATH = System.getProperty("user.home") + FILESEPARATOR + "/Downloads/Parablu_Restore/";
    public static boolean licenseExpired = false;
    public static boolean deviceBlocked = false;
    public static boolean sessionExpired = false;
    public static boolean serviceUnavailable = false;

    public String restoreToExistingPath(String filePath, String fileName, RestoreElement restoreElement) {
        String filePathTemp = filePath;
        if (osType.toLowerCase().contains("linux")) {
            logger.debug("inside linux restore");
            String checkRootInSystem = filePathTemp.substring(0, 3);
            if (!checkRootInSystem.contains(":")) {
                File[] list;
                checkRootInSystem = filePathTemp.substring(5);
                String[] checkRoot = checkRootInSystem.split("/", 2);
                File rootDir = new File("/");
                for (File rootName : list = rootDir.listFiles()) {
                    String listDir = rootName.getName();
                    if (!listDir.equalsIgnoreCase(checkRoot[0])) continue;
                    filePathTemp = filePathTemp.substring(4, filePathTemp.length());
                    String destinationPath = filePathTemp + FILESEPARATOR + fileName;
                    logger.debug("restore existing file path:" + destinationPath);
                    return destinationPath;
                }
            }
            return this.restoreToDefaultPath(restoreElement, fileName, filePathTemp);
        }
        if (osType.toLowerCase().contains("windows")) {
            try {
                String responseDir = filePathTemp;
                logger.debug("inside windows restore" + filePathTemp);
                File[] systemDir = File.listRoots();
                if (filePathTemp.length() >= 3) {
                    responseDir = filePathTemp.substring(0, 3);
                } else if (filePathTemp.length() == 2) {
                    responseDir = filePathTemp + "\\";
                }
                for (File dir : systemDir) {
                    String resDir;
                    String sysDir = dir.getAbsolutePath().toLowerCase();
                    if (!sysDir.equalsIgnoreCase((resDir = responseDir.replace("/", "\\")).toLowerCase())) continue;
                    String path = filePathTemp + FILESEPARATOR + fileName;
                    File finalPath = new File(path);
                    logger.debug("restore existing file path:" + finalPath);
                    return finalPath.getAbsolutePath().replace("/", "\\");
                }
                return this.restoreToDefaultPath(restoreElement, fileName, filePathTemp);
            }
            catch (Exception e) {
                logger.error("Error to get original path...." + e.getMessage());
            }
        }
        if (osType.toLowerCase().contains("mac")) {
            String path = filePathTemp + FILESEPARATOR + fileName;
            if (path.startsWith("Macintosh" + FILESEPARATOR)) {
                path = path.substring(9);
            }
            File file = new File(path);
            return file.getAbsolutePath();
        }
        return null;
    }

    private String restoreToDefaultPath(RestoreElement restoreElement, String fileName, String filePathTemp) {
        File defaultPath = new File(DEFAULT_RESTORE_PATH);
        String downloadFolder = defaultPath.toString();
        File restoreData = null;
        if (StringUtils.isEmpty((String)restoreElement.getDevicePath()) && StringUtils.isEmpty((String)restoreElement.getFileName())) {
            logger.debug("device level restore");
            restoreData = new File(filePathTemp + FILESEPARATOR + fileName);
        } else if (!StringUtils.isEmpty((String)restoreElement.getDevicePath()) && StringUtils.isEmpty((String)restoreElement.getFileName())) {
            logger.debug("folder level restore");
            String devicePath = restoreElement.getDevicePath();
            String folderName = devicePath.substring(devicePath.lastIndexOf(47) + 1, devicePath.length());
            String subFolders = filePathTemp.substring(devicePath.length());
            String folders = folderName + subFolders;
            restoreData = new File(folders + FILESEPARATOR + fileName);
        } else if (!StringUtils.isEmpty((String)restoreElement.getDevicePath()) && !StringUtils.isEmpty((String)restoreElement.getFileName())) {
            logger.debug("file level restore");
            restoreData = new File(fileName);
        }
        String restorePath = "";
        if (restoreData != null) {
            restorePath = restoreData.toString().replace(":", "_DRIVE");
        }
        String addPath = downloadFolder.concat(FILESEPARATOR + restorePath);
        String destinationPath = addPath.replace("/", "\\");
        logger.debug("destination path:" + destinationPath);
        return destinationPath;
    }

    public String checkForDrive(String destinationPath) {
        String downloadFolder;
        String destinationPathTemp = destinationPath;
        if (osType.toLowerCase().contains("windows")) {
            destinationPathTemp = destinationPathTemp.replace("/", "\\");
            downloadFolder = System.getProperty(USER_HOME_DIR) + "\\Downloads\\Parablu_restore";
            if (!destinationPathTemp.contains(":")) {
                String defaultLocation = downloadFolder;
                return defaultLocation;
            }
        } else {
            destinationPathTemp = destinationPathTemp.replace("\\", "/");
            downloadFolder = System.getProperty(USER_HOME_DIR) + DEFAULT_RESTORE_PATH;
        }
        File checkDir = new File(destinationPathTemp);
        String absPath = checkDir.getAbsolutePath();
        File makeDir = new File(absPath);
        makeDir.mkdirs();
        if (checkDir.exists()) {
            return destinationPathTemp;
        }
        String defaultLocation = downloadFolder;
        return defaultLocation;
    }
}

