/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.tcp;

import com.parablu.epa.core.to.BackupFolderTO;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.ZMQ;

public class ListnerAdapter {
    private Logger logger = LoggerFactory.getLogger(ListnerAdapter.class);
    private String action = "action";
    private static final String EXCEPTION = "Exception : ";
    private static final int FIVE_MIN_IN_MILLI = 300000;
    private ZMQ.Context context = ZMQ.context((int)1);
    private ZMQ.Socket socket = this.context.socket(3);

    public ListnerAdapter() {
        this.socket.connect("tcp://localhost:4444");
    }

    public void deleteVsnapshot(List<BackupFolderTO> listOfFolder) {
        JSONObject obj = new JSONObject();
        obj.put((Object)this.action, (Object)"deletevss");
        JSONArray list = new JSONArray();
        for (BackupFolderTO folder : listOfFolder) {
            list.add((Object)folder.getFolderPath());
            this.logger.debug("snapfolders to delete : " + folder.getFolderPath());
        }
        obj.put((Object)"folderPaths", (Object)list);
        this.logger.debug("calling to delete");
        int requestNbr = 0;
        if (requestNbr != 1) {
            String request = obj.toJSONString();
            this.socket.send(request.getBytes(), 0);
            ZMQ.PollItem[] items = new ZMQ.PollItem[]{new ZMQ.PollItem(this.socket, 1)};
            int rc = ZMQ.poll((ZMQ.PollItem[])items, (long)300000L);
            if (rc == -1) {
                return;
            }
            if (items[0].isReadable()) {
                String reply = this.socket.recvStr();
                this.logger.debug("Received " + new String(reply) + " " + requestNbr);
            } else {
                this.logger.debug("Service TIME OUT");
            }
            return;
        }
    }

    public boolean checkForService() {
        boolean serviceAlive;
        block5: {
            serviceAlive = false;
            try {
                JSONObject obj = new JSONObject();
                obj.put((Object)this.action, (Object)"ping");
                this.logger.debug("calling to check for update");
                String request = obj.toJSONString();
                this.socket.send(request.getBytes(), 0);
                ZMQ.PollItem[] items = new ZMQ.PollItem[]{new ZMQ.PollItem(this.socket, 1)};
                int rc = ZMQ.poll((ZMQ.PollItem[])items, (long)5000L);
                if (rc == -1) {
                    return false;
                }
                if (items[0].isReadable()) {
                    String reply = this.socket.recvStr();
                    if (reply.equalsIgnoreCase(String.valueOf(200))) {
                        serviceAlive = true;
                    }
                    break block5;
                }
                this.logger.debug("TIME OUT");
                return serviceAlive;
            }
            catch (Exception e) {
                this.logger.debug(EXCEPTION + e);
            }
        }
        return serviceAlive;
    }

    public String initiateUpdateCheckFromService(String cloudIpAddress, String cloudName, String productVersion, String deviceUUID, String userProfile) {
        String updateAvailable = String.valueOf(false);
        try {
            JSONObject obj = new JSONObject();
            obj.put((Object)this.action, (Object)"checkUpdate");
            obj.put((Object)"updateIp", (Object)cloudIpAddress);
            obj.put((Object)"cloudName", (Object)cloudName);
            obj.put((Object)"productVersion", (Object)productVersion);
            obj.put((Object)"deviceUUID", (Object)deviceUUID);
            obj.put((Object)"userProfile", (Object)userProfile);
            this.logger.debug("calling to check for update");
            this.logger.debug("calling to check for update");
            String request = obj.toJSONString();
            this.socket.send(request.getBytes(), 0);
            this.logger.debug("before getting resposne");
            String reply = this.socket.recvStr();
            this.logger.debug(reply + "%%%%%%%%%%%%%%%%%%%%%%%%");
            if (reply.equalsIgnoreCase(String.valueOf(200))) {
                this.logger.debug("update is available");
                updateAvailable = String.valueOf(true);
            } else if (reply.equalsIgnoreCase(String.valueOf(203))) {
                updateAvailable = String.valueOf(false);
            }
        }
        catch (Exception e) {
            this.logger.debug(EXCEPTION + e);
        }
        return updateAvailable;
    }

    public String getServiceVersion(String userAppdata) {
        String serviceVersion;
        block5: {
            serviceVersion = "";
            try {
                JSONObject obj = new JSONObject();
                obj.put((Object)this.action, (Object)"GetVersion_StartUpdateTimer");
                obj.put((Object)"userAppdata", (Object)userAppdata);
                this.logger.debug("calling get service version and start service update");
                String request = obj.toJSONString();
                this.socket.send(request.getBytes(), 0);
                ZMQ.PollItem[] items = new ZMQ.PollItem[]{new ZMQ.PollItem(this.socket, 1)};
                int rc = ZMQ.poll((ZMQ.PollItem[])items, (long)10000L);
                if (rc == -1) {
                    return serviceVersion;
                }
                if (items[0].isReadable()) {
                    String reply = this.socket.recvStr();
                    if (StringUtils.isNotEmpty((String)reply) && !reply.equalsIgnoreCase(String.valueOf(400))) {
                        serviceVersion = reply;
                    }
                    break block5;
                }
                this.logger.debug("TIME OUT");
                return serviceVersion;
            }
            catch (Exception e) {
                this.logger.debug(EXCEPTION + e);
            }
        }
        return serviceVersion;
    }

    public void terminateConnetion() {
        this.socket.close();
    }
}

