/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.ContentType;

public class ContentInfo
implements DEREncodable {
    private ContentType contentType;
    private DERObject content;

    public ContentInfo(ContentType contentType, DERObject dERObject) {
        this.setContentType(contentType);
        this.setContent(dERObject);
    }

    public ContentInfo(BERConstructedSequence bERConstructedSequence) {
        this.contentType = ContentType.getInstance(bERConstructedSequence.getObjectAt(0));
        if (bERConstructedSequence.getSize() > 1) {
            this.content = ((BERTaggedObject)bERConstructedSequence.getObjectAt(1)).getObject();
        }
    }

    public ContentInfo(ContentInfo contentInfo) {
        this.contentType = contentInfo.contentType;
        this.content = contentInfo.content;
    }

    public static ContentInfo getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ContentInfo) {
            return (ContentInfo)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new ContentInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return ContentInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid ContentInfo");
    }

    public static ContentInfo newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ContentInfo) {
            return new ContentInfo((ContentInfo)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new ContentInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return ContentInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid ContentInfo");
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    private void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public DERObject getContent() {
        return this.content;
    }

    private void setContent(DERObject dERObject) {
        this.content = dERObject;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.contentType);
        if (this.content != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(true, 0, this.content.getDERObject()));
        }
        return bERConstructedSequence;
    }
}

