/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorAggregator;

public class CompositeNestedGeneratedValueGenerator
implements IdentifierGenerator,
Serializable,
IdentifierGeneratorAggregator {
    private final GenerationContextLocator generationContextLocator;
    private List generationPlans = new ArrayList();

    public CompositeNestedGeneratedValueGenerator(GenerationContextLocator generationContextLocator) {
        this.generationContextLocator = generationContextLocator;
    }

    public void addGeneratedValuePlan(GenerationPlan plan) {
        this.generationPlans.add(plan);
    }

    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        Serializable context = this.generationContextLocator.locateGenerationContext(session, object);
        for (GenerationPlan plan : this.generationPlans) {
            plan.execute(session, object, context);
        }
        return context;
    }

    public void registerPersistentGenerators(Map generatorMap) {
        for (GenerationPlan plan : this.generationPlans) {
            plan.registerPersistentGenerators(generatorMap);
        }
    }

    public static interface GenerationPlan {
        public void execute(SessionImplementor var1, Object var2, Object var3);

        public void registerPersistentGenerators(Map var1);
    }

    public static interface GenerationContextLocator {
        public Serializable locateGenerationContext(SessionImplementor var1, Object var2);
    }
}

