/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EncodingSniffer {
    private static final Log LOG = LogFactory.getLog(EncodingSniffer.class);
    static final String UTF16_LE = "UTF-16LE";
    static final String UTF16_BE = "UTF-16BE";
    static final String UTF8 = "UTF-8";
    private static final byte[][] COMMENT_START = new byte[][]{{60}, {33}, {45}, {45}};
    private static final byte[][] META_START = new byte[][]{{60}, {109, 77}, {101, 69}, {116, 84}, {97, 65}, {9, 10, 12, 13, 32, 47}};
    private static final byte[][] OTHER_START = new byte[][]{{60}, {33, 47, 63}};
    private static final byte[][] CHARSET_START = new byte[][]{{99, 67}, {104, 72}, {97, 65}, {114, 82}, {115, 83}, {101, 69}, {116, 84}};
    private static final Map<String, String> ENCODING_FROM_LABEL = new HashMap<String, String>();
    private static final byte[] XML_DECLARATION_PREFIX;
    private static final int SIZE_OF_HTML_CONTENT_SNIFFED = 4096;
    private static final int SIZE_OF_XML_CONTENT_SNIFFED = 512;

    private EncodingSniffer() {
    }

    public static String sniffEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        if (EncodingSniffer.isHtml(headers)) {
            return EncodingSniffer.sniffHtmlEncoding(headers, content);
        }
        if (EncodingSniffer.isXml(headers)) {
            return EncodingSniffer.sniffXmlEncoding(headers, content);
        }
        return EncodingSniffer.sniffUnknownContentTypeEncoding(headers, content);
    }

    static boolean isHtml(List<NameValuePair> headers) {
        return EncodingSniffer.contentTypeEndsWith(headers, "text/html");
    }

    static boolean isXml(List<NameValuePair> headers) {
        return EncodingSniffer.contentTypeEndsWith(headers, "text/xml", "application/xml", "text/vnd.wap.wml", "+xml");
    }

    static boolean contentTypeEndsWith(List<NameValuePair> headers, String ... contentTypeEndings) {
        for (NameValuePair pair : headers) {
            String name = pair.getName();
            if (!"content-type".equalsIgnoreCase(name)) continue;
            String value = pair.getValue();
            int i = value.indexOf(59);
            if (i != -1) {
                value = value.substring(0, i);
            }
            value = value.trim().toLowerCase(Locale.ROOT);
            for (String ending : contentTypeEndings) {
                if (!value.endsWith(ending.toLowerCase(Locale.ROOT))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static String sniffHtmlEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        String encoding = EncodingSniffer.sniffEncodingFromHttpHeaders(headers);
        if (encoding != null || content == null) {
            return encoding;
        }
        byte[] bytes = EncodingSniffer.read(content, 3);
        encoding = EncodingSniffer.sniffEncodingFromUnicodeBom(bytes);
        if (encoding != null) {
            return encoding;
        }
        bytes = EncodingSniffer.readAndPrepend(content, 4096, bytes);
        encoding = EncodingSniffer.sniffEncodingFromMetaTag(bytes);
        return encoding;
    }

    public static String sniffXmlEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        String encoding = EncodingSniffer.sniffEncodingFromHttpHeaders(headers);
        if (encoding != null || content == null) {
            return encoding;
        }
        byte[] bytes = EncodingSniffer.read(content, 3);
        encoding = EncodingSniffer.sniffEncodingFromUnicodeBom(bytes);
        if (encoding != null) {
            return encoding;
        }
        bytes = EncodingSniffer.readAndPrepend(content, 512, bytes);
        encoding = EncodingSniffer.sniffEncodingFromXmlDeclaration(bytes);
        return encoding;
    }

    public static String sniffUnknownContentTypeEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        String encoding = EncodingSniffer.sniffEncodingFromHttpHeaders(headers);
        if (encoding != null || content == null) {
            return encoding;
        }
        byte[] bytes = EncodingSniffer.read(content, 3);
        encoding = EncodingSniffer.sniffEncodingFromUnicodeBom(bytes);
        return encoding;
    }

    static String sniffEncodingFromHttpHeaders(List<NameValuePair> headers) {
        String encoding = null;
        for (NameValuePair pair : headers) {
            String value;
            String name = pair.getName();
            if (!"content-type".equalsIgnoreCase(name) || (encoding = EncodingSniffer.extractEncodingFromContentType(value = pair.getValue())) == null) continue;
            encoding = encoding.toUpperCase(Locale.ROOT);
            break;
        }
        if (encoding != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Encoding found in HTTP headers: '" + encoding + "'."));
        }
        return encoding;
    }

    static String sniffEncodingFromUnicodeBom(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String encoding = null;
        if (bytes.length > 2 && -17 == bytes[0] && -69 == bytes[1] && -65 == bytes[2]) {
            encoding = UTF8;
        } else if (bytes.length > 2 && -2 == bytes[0] && -1 == bytes[1]) {
            encoding = UTF16_BE;
        } else if (bytes.length > 2 && -1 == bytes[0] && -2 == bytes[1]) {
            encoding = UTF16_LE;
        }
        if (encoding != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Encoding found in Unicode Byte Order Mark: '" + encoding + "'."));
        }
        return encoding;
    }

    static String sniffEncodingFromMetaTag(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            Attribute att;
            block14: {
                if (EncodingSniffer.matches(bytes, i, COMMENT_START)) {
                    if ((i = EncodingSniffer.indexOfSubArray(bytes, new byte[]{45, 45, 62}, i)) == -1) break;
                    i += 2;
                    continue;
                }
                if (!EncodingSniffer.matches(bytes, i, META_START)) break block14;
                att = EncodingSniffer.getAttribute(bytes, i += META_START.length);
                while (att != null) {
                    block15: {
                        String charset;
                        block17: {
                            String value;
                            String name;
                            block16: {
                                i = att.getUpdatedIndex();
                                name = att.getName();
                                value = att.getValue();
                                if (!"charset".equals(name) && !"content".equals(name)) break block15;
                                charset = null;
                                if (!"charset".equals(name)) break block16;
                                charset = value;
                                break block17;
                            }
                            if ("content".equals(name) && (charset = EncodingSniffer.extractEncodingFromContentType(value)) == null) break block15;
                        }
                        if (UTF16_BE.equalsIgnoreCase(charset) || UTF16_LE.equalsIgnoreCase(charset)) {
                            charset = UTF8;
                        }
                        if (charset != null && EncodingSniffer.isSupportedCharset(charset)) {
                            charset = charset.toUpperCase(Locale.ROOT);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Encoding found in meta tag: '" + charset + "'."));
                            }
                            return charset;
                        }
                    }
                    att = EncodingSniffer.getAttribute(bytes, i);
                }
                continue;
            }
            if (i + 1 < bytes.length && bytes[i] == 60 && Character.isLetter(bytes[i + 1])) {
                if ((i = EncodingSniffer.skipToAnyOf(bytes, i, new byte[]{9, 10, 12, 13, 32, 62})) == -1) break;
                while ((att = EncodingSniffer.getAttribute(bytes, i)) != null) {
                    i = att.getUpdatedIndex();
                }
                continue;
            }
            if (i + 2 < bytes.length && bytes[i] == 60 && bytes[i + 1] == 47 && Character.isLetter(bytes[i + 2])) {
                Attribute attribute;
                if ((i = EncodingSniffer.skipToAnyOf(bytes, i, new byte[]{9, 10, 12, 13, 32, 62})) == -1) break;
                while ((attribute = EncodingSniffer.getAttribute(bytes, i)) != null) {
                    i = attribute.getUpdatedIndex();
                }
                continue;
            }
            if (EncodingSniffer.matches(bytes, i, OTHER_START) && (i = EncodingSniffer.skipToAnyOf(bytes, i, new byte[]{62})) == -1) break;
        }
        return null;
    }

    static Attribute getAttribute(byte[] bytes, int i) {
        byte b;
        if (i >= bytes.length) {
            return null;
        }
        while (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32 || bytes[i] == 47) {
            if (++i < bytes.length) continue;
            return null;
        }
        if (bytes[i] == 62) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        StringBuilder value = new StringBuilder();
        while (true) {
            if (i >= bytes.length) {
                return new Attribute(name.toString(), value.toString(), i);
            }
            if (bytes[i] == 61 && name.length() != 0) {
                ++i;
                break;
            }
            if (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32) {
                while (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32) {
                    if (++i < bytes.length) continue;
                    return new Attribute(name.toString(), value.toString(), i);
                }
                if (bytes[i] != 61) {
                    return new Attribute(name.toString(), value.toString(), i);
                }
                ++i;
                break;
            }
            if (bytes[i] == 47 || bytes[i] == 62) {
                return new Attribute(name.toString(), value.toString(), i);
            }
            name.append((char)bytes[i]);
            ++i;
        }
        if (i >= bytes.length) {
            return new Attribute(name.toString(), value.toString(), i);
        }
        while (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32) {
            if (++i < bytes.length) continue;
            return new Attribute(name.toString(), value.toString(), i);
        }
        if (bytes[i] == 34 || bytes[i] == 39) {
            byte b2 = bytes[i];
            ++i;
            while (i < bytes.length) {
                if (bytes[i] == b2) {
                    return new Attribute(name.toString(), value.toString(), ++i);
                }
                if (bytes[i] >= 65 && bytes[i] <= 90) {
                    byte b22 = (byte)(bytes[i] + 32);
                    value.append((char)b22);
                } else {
                    value.append((char)bytes[i]);
                }
                ++i;
            }
            return new Attribute(name.toString(), value.toString(), i);
        }
        if (bytes[i] == 62) {
            return new Attribute(name.toString(), value.toString(), i);
        }
        if (bytes[i] >= 65 && bytes[i] <= 90) {
            b = (byte)(bytes[i] + 32);
            value.append((char)b);
            ++i;
        } else {
            value.append((char)bytes[i]);
            ++i;
        }
        while (i < bytes.length) {
            if (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32 || bytes[i] == 62) {
                return new Attribute(name.toString(), value.toString(), i);
            }
            if (bytes[i] >= 65 && bytes[i] <= 90) {
                b = (byte)(bytes[i] + 32);
                value.append((char)b);
            } else {
                value.append((char)bytes[i]);
            }
            ++i;
        }
        return new Attribute(name.toString(), value.toString(), i);
    }

    static String extractEncodingFromContentType(String s) {
        String charset;
        int i;
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes(StandardCharsets.US_ASCII);
        for (i = 0; i < bytes.length; ++i) {
            if (!EncodingSniffer.matches(bytes, i, CHARSET_START)) continue;
            i += CHARSET_START.length;
            break;
        }
        if (i == bytes.length) {
            return null;
        }
        while (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32) {
            if (++i != bytes.length) continue;
            return null;
        }
        if (bytes[i] != 61) {
            return null;
        }
        if (++i == bytes.length) {
            return null;
        }
        while (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32) {
            if (++i != bytes.length) continue;
            return null;
        }
        if (bytes[i] == 34) {
            if (bytes.length <= i + 1) {
                return null;
            }
            int index = ArrayUtils.indexOf((byte[])bytes, (byte)34, (int)(i + 1));
            if (index == -1) {
                return null;
            }
            String charset2 = new String(ArrayUtils.subarray((byte[])bytes, (int)(i + 1), (int)index), StandardCharsets.US_ASCII);
            return EncodingSniffer.isSupportedCharset(charset2) ? charset2 : null;
        }
        if (bytes[i] == 39) {
            if (bytes.length <= i + 1) {
                return null;
            }
            int index = ArrayUtils.indexOf((byte[])bytes, (byte)39, (int)(i + 1));
            if (index == -1) {
                return null;
            }
            String charset3 = new String(ArrayUtils.subarray((byte[])bytes, (int)(i + 1), (int)index), StandardCharsets.US_ASCII);
            return EncodingSniffer.isSupportedCharset(charset3) ? charset3 : null;
        }
        int end = EncodingSniffer.skipToAnyOf(bytes, i, new byte[]{9, 10, 12, 13, 32, 59});
        if (end == -1) {
            end = bytes.length;
        }
        return EncodingSniffer.isSupportedCharset(charset = new String(ArrayUtils.subarray((byte[])bytes, (int)i, (int)end), StandardCharsets.US_ASCII)) ? charset : null;
    }

    static String sniffEncodingFromXmlDeclaration(byte[] bytes) {
        String declaration;
        int start;
        int index;
        String encoding = null;
        if (bytes.length > 5 && XML_DECLARATION_PREFIX[0] == bytes[0] && XML_DECLARATION_PREFIX[1] == bytes[1] && XML_DECLARATION_PREFIX[2] == bytes[2] && XML_DECLARATION_PREFIX[3] == bytes[3] && XML_DECLARATION_PREFIX[4] == bytes[4] && XML_DECLARATION_PREFIX[5] == bytes[5] && (index = ArrayUtils.indexOf((byte[])bytes, (byte)63, (int)2)) + 1 < bytes.length && bytes[index + 1] == 62 && (start = (declaration = new String(bytes, 0, index + 2, StandardCharsets.US_ASCII)).indexOf("encoding")) != -1) {
            char delimiter;
            start += 8;
            block3: while (true) {
                switch (declaration.charAt(start)) {
                    case '\"': 
                    case '\'': {
                        delimiter = declaration.charAt(start);
                        break block3;
                    }
                    default: {
                        ++start;
                        continue block3;
                    }
                }
                break;
            }
            int end = declaration.indexOf(delimiter, ++start);
            encoding = declaration.substring(start, end);
        }
        if (encoding != null && !EncodingSniffer.isSupportedCharset(encoding)) {
            encoding = null;
        }
        if (encoding != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Encoding found in XML declaration: '" + encoding + "'."));
        }
        return encoding;
    }

    static boolean isSupportedCharset(String charset) {
        try {
            return Charset.isSupported(charset);
        }
        catch (IllegalCharsetNameException e) {
            return false;
        }
    }

    static boolean matches(byte[] bytes, int i, byte[][] sought) {
        if (i + sought.length > bytes.length) {
            return false;
        }
        for (int x = 0; x < sought.length; ++x) {
            byte[] possibilities = sought[x];
            boolean match = false;
            for (int y = 0; y < possibilities.length; ++y) {
                if (bytes[i + x] != possibilities[y]) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    static int skipToAnyOf(byte[] bytes, int i, byte[] targets) {
        while (i < bytes.length && !ArrayUtils.contains((byte[])targets, (byte)bytes[i])) {
            ++i;
        }
        if (i == bytes.length) {
            i = -1;
        }
        return i;
    }

    static int indexOfSubArray(byte[] array, byte[] subarray, int startIndex) {
        for (int i = startIndex; i < array.length; ++i) {
            boolean found = true;
            if (i + subarray.length > array.length) break;
            for (int j = 0; j < subarray.length; ++j) {
                byte a = array[i + j];
                byte b = subarray[j];
                if (a == b) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    static byte[] read(InputStream content, int size) throws IOException {
        byte[] bytes = new byte[size];
        int count = content.read(bytes);
        if (count == -1) {
            bytes = new byte[]{};
        } else if (count < size) {
            byte[] smaller = new byte[count];
            System.arraycopy(bytes, 0, smaller, 0, count);
            bytes = smaller;
        }
        return bytes;
    }

    static byte[] readAndPrepend(InputStream content, int size, byte[] prefix) throws IOException {
        byte[] bytes = EncodingSniffer.read(content, size);
        byte[] joined = new byte[prefix.length + bytes.length];
        System.arraycopy(prefix, 0, joined, 0, prefix.length);
        System.arraycopy(bytes, 0, joined, prefix.length, bytes.length);
        return joined;
    }

    public static String translateEncodingLabel(String encodingLabel) {
        String enc;
        if (null == encodingLabel) {
            return null;
        }
        String encLC = encodingLabel.trim().toLowerCase(Locale.ROOT);
        if (encLC.equals(enc = ENCODING_FROM_LABEL.get(encLC))) {
            return encodingLabel;
        }
        return enc;
    }

    static {
        ENCODING_FROM_LABEL.put("unicode-1-1-utf-8", "utf-8");
        ENCODING_FROM_LABEL.put("utf-8", "utf-8");
        ENCODING_FROM_LABEL.put("utf8", "utf-8");
        ENCODING_FROM_LABEL.put("866", "ibm866");
        ENCODING_FROM_LABEL.put("cp866", "ibm866");
        ENCODING_FROM_LABEL.put("csibm866", "ibm866");
        ENCODING_FROM_LABEL.put("ibm866", "ibm866");
        ENCODING_FROM_LABEL.put("csisolatin2", "iso-8859-2");
        ENCODING_FROM_LABEL.put("iso-8859-2", "iso-8859-2");
        ENCODING_FROM_LABEL.put("iso-ir-101", "iso-8859-2");
        ENCODING_FROM_LABEL.put("iso8859-2", "iso-8859-2");
        ENCODING_FROM_LABEL.put("iso88592", "iso-8859-2");
        ENCODING_FROM_LABEL.put("iso_8859-2", "iso-8859-2");
        ENCODING_FROM_LABEL.put("iso_8859-2:1987", "iso-8859-2");
        ENCODING_FROM_LABEL.put("l2", "iso-8859-2");
        ENCODING_FROM_LABEL.put("latin2", "iso-8859-2");
        ENCODING_FROM_LABEL.put("csisolatin2", "iso-8859-3");
        ENCODING_FROM_LABEL.put("csisolatin3", "iso-8859-3");
        ENCODING_FROM_LABEL.put("iso-8859-3", "iso-8859-3");
        ENCODING_FROM_LABEL.put("iso-ir-109", "iso-8859-3");
        ENCODING_FROM_LABEL.put("iso8859-3", "iso-8859-3");
        ENCODING_FROM_LABEL.put("iso88593", "iso-8859-3");
        ENCODING_FROM_LABEL.put("iso_8859-3", "iso-8859-3");
        ENCODING_FROM_LABEL.put("iso_8859-3:1988", "iso-8859-3");
        ENCODING_FROM_LABEL.put("l3", "iso-8859-3");
        ENCODING_FROM_LABEL.put("latin3", "iso-8859-3");
        ENCODING_FROM_LABEL.put("csisolatin4", "iso-8859-4");
        ENCODING_FROM_LABEL.put("iso-8859-4", "iso-8859-4");
        ENCODING_FROM_LABEL.put("iso-ir-110", "iso-8859-4");
        ENCODING_FROM_LABEL.put("iso8859-4", "iso-8859-4");
        ENCODING_FROM_LABEL.put("iso88594", "iso-8859-4");
        ENCODING_FROM_LABEL.put("iso_8859-4", "iso-8859-4");
        ENCODING_FROM_LABEL.put("iso_8859-4:1988", "iso-8859-4");
        ENCODING_FROM_LABEL.put("l4", "iso-8859-4");
        ENCODING_FROM_LABEL.put("latin4", "iso-8859-4");
        ENCODING_FROM_LABEL.put("csisolatincyrillic", "iso-8859-5");
        ENCODING_FROM_LABEL.put("csisolatincyrillic", "iso-8859-5");
        ENCODING_FROM_LABEL.put("cyrillic", "iso-8859-5");
        ENCODING_FROM_LABEL.put("iso-8859-5", "iso-8859-5");
        ENCODING_FROM_LABEL.put("iso-ir-144", "iso-8859-5");
        ENCODING_FROM_LABEL.put("iso8859-5", "iso-8859-5");
        ENCODING_FROM_LABEL.put("iso88595", "iso-8859-5");
        ENCODING_FROM_LABEL.put("iso_8859-5", "iso-8859-5");
        ENCODING_FROM_LABEL.put("iso_8859-5:1988", "iso-8859-5");
        ENCODING_FROM_LABEL.put("arabic", "iso-8859-6");
        ENCODING_FROM_LABEL.put("asmo-708", "iso-8859-6");
        ENCODING_FROM_LABEL.put("csiso88596e", "iso-8859-6");
        ENCODING_FROM_LABEL.put("csiso88596i", "iso-8859-6");
        ENCODING_FROM_LABEL.put("csisolatinarabic", "iso-8859-6");
        ENCODING_FROM_LABEL.put("ecma-114", "iso-8859-6");
        ENCODING_FROM_LABEL.put("iso-8859-6", "iso-8859-6");
        ENCODING_FROM_LABEL.put("iso-8859-6-e", "iso-8859-6");
        ENCODING_FROM_LABEL.put("iso-8859-6-i", "iso-8859-6");
        ENCODING_FROM_LABEL.put("iso-ir-127", "iso-8859-6");
        ENCODING_FROM_LABEL.put("iso8859-6", "iso-8859-6");
        ENCODING_FROM_LABEL.put("iso88596", "iso-8859-6");
        ENCODING_FROM_LABEL.put("iso_8859-6", "iso-8859-6");
        ENCODING_FROM_LABEL.put("iso_8859-6:1987", "iso-8859-6");
        ENCODING_FROM_LABEL.put("csisolatingreek", "iso-8859-7");
        ENCODING_FROM_LABEL.put("ecma-118", "iso-8859-7");
        ENCODING_FROM_LABEL.put("elot_928", "iso-8859-7");
        ENCODING_FROM_LABEL.put("greek", "iso-8859-7");
        ENCODING_FROM_LABEL.put("greek8", "iso-8859-7");
        ENCODING_FROM_LABEL.put("iso-8859-7", "iso-8859-7");
        ENCODING_FROM_LABEL.put("iso-ir-126", "iso-8859-7");
        ENCODING_FROM_LABEL.put("iso8859-7", "iso-8859-7");
        ENCODING_FROM_LABEL.put("iso88597", "iso-8859-7");
        ENCODING_FROM_LABEL.put("iso_8859-7", "iso-8859-7");
        ENCODING_FROM_LABEL.put("iso_8859-7:1987", "iso-8859-7");
        ENCODING_FROM_LABEL.put("sun_eu_greek", "iso-8859-7");
        ENCODING_FROM_LABEL.put("csisolatingreek", "iso-8859-8");
        ENCODING_FROM_LABEL.put("csiso88598e", "iso-8859-8");
        ENCODING_FROM_LABEL.put("csisolatinhebrew", "iso-8859-8");
        ENCODING_FROM_LABEL.put("hebrew", "iso-8859-8");
        ENCODING_FROM_LABEL.put("iso-8859-8", "iso-8859-8");
        ENCODING_FROM_LABEL.put("iso-8859-8-e", "iso-8859-8");
        ENCODING_FROM_LABEL.put("iso-ir-138", "iso-8859-8");
        ENCODING_FROM_LABEL.put("iso8859-8", "iso-8859-8");
        ENCODING_FROM_LABEL.put("iso88598", "iso-8859-8");
        ENCODING_FROM_LABEL.put("iso_8859-8", "iso-8859-8");
        ENCODING_FROM_LABEL.put("iso_8859-8:1988", "iso-8859-8");
        ENCODING_FROM_LABEL.put("visual", "iso-8859-8");
        ENCODING_FROM_LABEL.put("csiso88598i", "iso-8859-8-i");
        ENCODING_FROM_LABEL.put("iso-8859-8-i", "iso-8859-8-i");
        ENCODING_FROM_LABEL.put("logical", "iso-8859-8-i");
        ENCODING_FROM_LABEL.put("csisolatin6", "iso-8859-10");
        ENCODING_FROM_LABEL.put("iso-8859-10", "iso-8859-10");
        ENCODING_FROM_LABEL.put("iso-ir-157", "iso-8859-10");
        ENCODING_FROM_LABEL.put("iso8859-10", "iso-8859-10");
        ENCODING_FROM_LABEL.put("iso885910", "iso-8859-10");
        ENCODING_FROM_LABEL.put("l6", "iso-8859-10");
        ENCODING_FROM_LABEL.put("latin6", "iso-8859-10");
        ENCODING_FROM_LABEL.put("iso-8859-13", "iso-8859-13");
        ENCODING_FROM_LABEL.put("iso8859-13", "iso-8859-13");
        ENCODING_FROM_LABEL.put("iso885913", "iso-8859-13");
        ENCODING_FROM_LABEL.put("iso-8859-14", "iso-8859-14");
        ENCODING_FROM_LABEL.put("iso8859-14", "iso-8859-14");
        ENCODING_FROM_LABEL.put("iso885914", "iso-8859-14");
        ENCODING_FROM_LABEL.put("csisolatin9", "iso-8859-15");
        ENCODING_FROM_LABEL.put("iso-8859-15", "iso-8859-15");
        ENCODING_FROM_LABEL.put("iso8859-15", "iso-8859-15");
        ENCODING_FROM_LABEL.put("iso885915", "iso-8859-15");
        ENCODING_FROM_LABEL.put("iso_8859-15", "iso-8859-15");
        ENCODING_FROM_LABEL.put("l9", "iso-8859-15");
        ENCODING_FROM_LABEL.put("iso-8859-16", "iso-8859-16");
        ENCODING_FROM_LABEL.put("cskoi8r", "koi8-r");
        ENCODING_FROM_LABEL.put("koi", "koi8-r");
        ENCODING_FROM_LABEL.put("koi8", "koi8-r");
        ENCODING_FROM_LABEL.put("koi8-r", "koi8-r");
        ENCODING_FROM_LABEL.put("koi8_r", "koi8-r");
        ENCODING_FROM_LABEL.put("koi8-u", "koi8-u");
        ENCODING_FROM_LABEL.put("csmacintosh", "macintosh");
        ENCODING_FROM_LABEL.put("mac", "macintosh");
        ENCODING_FROM_LABEL.put("macintosh", "macintosh");
        ENCODING_FROM_LABEL.put("x-mac-roman", "macintosh");
        ENCODING_FROM_LABEL.put("dos-874", "windows-874");
        ENCODING_FROM_LABEL.put("iso-8859-11", "windows-874");
        ENCODING_FROM_LABEL.put("iso8859-11", "windows-874");
        ENCODING_FROM_LABEL.put("iso885911", "windows-874");
        ENCODING_FROM_LABEL.put("tis-620", "windows-874");
        ENCODING_FROM_LABEL.put("windows-874", "windows-874");
        ENCODING_FROM_LABEL.put("cp1250", "windows-1250");
        ENCODING_FROM_LABEL.put("windows-1250", "windows-1250");
        ENCODING_FROM_LABEL.put("x-cp1250", "windows-1250");
        ENCODING_FROM_LABEL.put("cp1251", "windows-1251");
        ENCODING_FROM_LABEL.put("windows-1251", "windows-1251");
        ENCODING_FROM_LABEL.put("x-cp1251", "windows-1251");
        ENCODING_FROM_LABEL.put("ansi_x3.4-1968", "windows-1252");
        ENCODING_FROM_LABEL.put("ascii", "windows-1252");
        ENCODING_FROM_LABEL.put("cp1252", "windows-1252");
        ENCODING_FROM_LABEL.put("cp819", "windows-1252");
        ENCODING_FROM_LABEL.put("csisolatin1", "windows-1252");
        ENCODING_FROM_LABEL.put("ibm819", "windows-1252");
        ENCODING_FROM_LABEL.put("iso-8859-1", "windows-1252");
        ENCODING_FROM_LABEL.put("iso-ir-100", "windows-1252");
        ENCODING_FROM_LABEL.put("iso8859-1", "windows-1252");
        ENCODING_FROM_LABEL.put("iso88591", "windows-1252");
        ENCODING_FROM_LABEL.put("iso_8859-1", "windows-1252");
        ENCODING_FROM_LABEL.put("iso_8859-1:1987", "windows-1252");
        ENCODING_FROM_LABEL.put("l1", "windows-1252");
        ENCODING_FROM_LABEL.put("latin1", "windows-1252");
        ENCODING_FROM_LABEL.put("us-ascii", "windows-1252");
        ENCODING_FROM_LABEL.put("windows-1252", "windows-1252");
        ENCODING_FROM_LABEL.put("x-cp1252", "windows-1252");
        ENCODING_FROM_LABEL.put("cp1253", "windows-1253");
        ENCODING_FROM_LABEL.put("windows-1253", "windows-1253");
        ENCODING_FROM_LABEL.put("x-cp1253", "windows-1253");
        ENCODING_FROM_LABEL.put("cp1254", "windows-1254");
        ENCODING_FROM_LABEL.put("csisolatin5", "windows-1254");
        ENCODING_FROM_LABEL.put("iso-8859-9", "windows-1254");
        ENCODING_FROM_LABEL.put("iso-ir-148", "windows-1254");
        ENCODING_FROM_LABEL.put("iso8859-9", "windows-1254");
        ENCODING_FROM_LABEL.put("iso88599", "windows-1254");
        ENCODING_FROM_LABEL.put("iso_8859-9", "windows-1254");
        ENCODING_FROM_LABEL.put("iso_8859-9:1989", "windows-1254");
        ENCODING_FROM_LABEL.put("l5", "windows-1254");
        ENCODING_FROM_LABEL.put("latin5", "windows-1254");
        ENCODING_FROM_LABEL.put("windows-1254", "windows-1254");
        ENCODING_FROM_LABEL.put("x-cp1254", "windows-1254");
        ENCODING_FROM_LABEL.put("cp1255", "windows-1255");
        ENCODING_FROM_LABEL.put("windows-1255", "windows-1255");
        ENCODING_FROM_LABEL.put("x-cp1255", "windows-1255");
        ENCODING_FROM_LABEL.put("cp1256", "windows-1256");
        ENCODING_FROM_LABEL.put("windows-1256", "windows-1256");
        ENCODING_FROM_LABEL.put("x-cp1256", "windows-1256");
        ENCODING_FROM_LABEL.put("cp1257", "windows-1257");
        ENCODING_FROM_LABEL.put("windows-1257", "windows-1257");
        ENCODING_FROM_LABEL.put("x-cp1257", "windows-1257");
        ENCODING_FROM_LABEL.put("cp1258", "windows-1258");
        ENCODING_FROM_LABEL.put("windows-1258", "windows-1258");
        ENCODING_FROM_LABEL.put("x-cp1258", "windows-1258");
        ENCODING_FROM_LABEL.put("x-mac-cyrillic", "x-mac-cyrillic");
        ENCODING_FROM_LABEL.put("x-mac-ukrainian", "x-mac-cyrillic");
        ENCODING_FROM_LABEL.put("chinese", "gb18030");
        ENCODING_FROM_LABEL.put("csgb2312", "gb18030");
        ENCODING_FROM_LABEL.put("csiso58gb231280", "gb18030");
        ENCODING_FROM_LABEL.put("gb18030", "gb18030");
        ENCODING_FROM_LABEL.put("gb2312", "gb18030");
        ENCODING_FROM_LABEL.put("gb_2312", "gb18030");
        ENCODING_FROM_LABEL.put("gb_2312-80", "gb18030");
        ENCODING_FROM_LABEL.put("gbk", "gb18030");
        ENCODING_FROM_LABEL.put("iso-ir-58", "gb18030");
        ENCODING_FROM_LABEL.put("x-gbk", "gb18030");
        ENCODING_FROM_LABEL.put("hz-gb-2312", "hz-gb-2312");
        ENCODING_FROM_LABEL.put("big5", "big5");
        ENCODING_FROM_LABEL.put("big5-hkscs", "big5");
        ENCODING_FROM_LABEL.put("cn-big5", "big5");
        ENCODING_FROM_LABEL.put("csbig5", "big5");
        ENCODING_FROM_LABEL.put("x-x-big5", "big5");
        ENCODING_FROM_LABEL.put("cseucpkdfmtjapanese", "euc-jp");
        ENCODING_FROM_LABEL.put("euc-jp", "euc-jp");
        ENCODING_FROM_LABEL.put("x-euc-jp", "euc-jp");
        ENCODING_FROM_LABEL.put("csiso2022jp", "iso-2022-jp");
        ENCODING_FROM_LABEL.put("iso-2022-jp", "iso-2022-jp");
        ENCODING_FROM_LABEL.put("csshiftjis", "shift_jis");
        ENCODING_FROM_LABEL.put("ms_kanji", "shift_jis");
        ENCODING_FROM_LABEL.put("shift-jis", "shift_jis");
        ENCODING_FROM_LABEL.put("shift_jis", "shift_jis");
        ENCODING_FROM_LABEL.put("sjis", "shift_jis");
        ENCODING_FROM_LABEL.put("windows-31j", "shift_jis");
        ENCODING_FROM_LABEL.put("x-sjis", "shift_jis");
        ENCODING_FROM_LABEL.put("cseuckr", "euc-kr");
        ENCODING_FROM_LABEL.put("csksc56011987", "euc-kr");
        ENCODING_FROM_LABEL.put("euc-kr", "euc-kr");
        ENCODING_FROM_LABEL.put("iso-ir-149", "euc-kr");
        ENCODING_FROM_LABEL.put("korean", "euc-kr");
        ENCODING_FROM_LABEL.put("ks_c_5601-1987", "euc-kr");
        ENCODING_FROM_LABEL.put("ks_c_5601-1989", "euc-kr");
        ENCODING_FROM_LABEL.put("ksc5601", "euc-kr");
        ENCODING_FROM_LABEL.put("ksc_5601", "euc-kr");
        ENCODING_FROM_LABEL.put("windows-949", "euc-kr");
        ENCODING_FROM_LABEL.put("csiso2022kr", "replacement");
        ENCODING_FROM_LABEL.put("iso-2022-cn", "replacement");
        ENCODING_FROM_LABEL.put("iso-2022-cn-ext", "replacement");
        ENCODING_FROM_LABEL.put("iso-2022-kr", "replacement");
        ENCODING_FROM_LABEL.put("utf-16be", "utf-16be");
        ENCODING_FROM_LABEL.put("utf-16", "utf-16le");
        ENCODING_FROM_LABEL.put("utf-16le", "utf-16le");
        ENCODING_FROM_LABEL.put("x-user-defined", "x-user-defined");
        XML_DECLARATION_PREFIX = "<?xml ".getBytes(StandardCharsets.US_ASCII);
    }

    static class Attribute {
        private final String name_;
        private final String value_;
        private final int updatedIndex_;

        Attribute(String name, String value, int updatedIndex) {
            this.name_ = name;
            this.value_ = value;
            this.updatedIndex_ = updatedIndex;
        }

        String getName() {
            return this.name_;
        }

        String getValue() {
            return this.value_;
        }

        int getUpdatedIndex() {
            return this.updatedIndex_;
        }
    }
}

