/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.backupmigrateutility.service;

import com.parablu.backupmigrateutility.dao.BackUpImageDao;
import com.parablu.backupmigrateutility.dao.CMBackUpImageDao;
import com.parablu.backupmigrateutility.dao.CMMigrationMetaDataDao;
import com.parablu.backupmigrateutility.dao.DeviceDao;
import com.parablu.backupmigrateutility.domain.BackUpImage;
import com.parablu.backupmigrateutility.domain.CMBackUpImage;
import com.parablu.backupmigrateutility.domain.CMMigrationMetaData;
import com.parablu.backupmigrateutility.domain.Device;
import com.parablu.backupmigrateutility.service.MigrationService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MigrationServiceImpl
implements MigrationService {
    private static final Logger logger = LoggerFactory.getLogger(MigrationServiceImpl.class);
    private static final String COMPLETED = "COMPLETED";
    private static final String CM_SP_COLLECTION = "CAPACITY_MGMT_BACKUP_SP";
    private static final String CM_ODB_COLLECTION = "CAPACITY_MGMT_BACKUP_ODB";
    private static final String CM_OUTLOOK_COLLECTION = "CAPACITY_MGMT_BACKUP_OUTLOOK";
    @Autowired
    DeviceDao deviceDao;
    @Autowired
    CMMigrationMetaDataDao cmMigrationMetaDataDao;
    @Autowired
    CMBackUpImageDao cmBackUpImageDao;
    @Autowired
    BackUpImageDao backUpImageDao;

    public void startMigration(int threads, int documents) {
        List devices = this.deviceDao.getUniqueDeviceUUIDs();
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        logger.info("The documents which will be moved at once from one collection to other is = {}", (Object)documents);
        for (Device device : devices) {
            executorService.submit(() -> this.migrateBackupCollection(device, documents));
        }
    }

    public void restartMigration(int threads, int documents) {
        this.cmMigrationMetaDataDao.removeCmMetaData();
        this.cmBackUpImageDao.removeCmBackUpImage();
        logger.info("cleared all collections of CM_MIGRATION_META_DATA and all CAPACITY_MGMT_BACKUP and starting the migration again");
        this.startMigration(threads, documents);
    }

    private void migrateBackupCollection(Device device, int documents) {
        String deviceUUID = device.getDeviceUUID();
        logger.info("Check if there is a pending migration or if migration is started for device UUID ={}, with device type={}", (Object)deviceUUID, (Object)device.getDeviceType());
        CMMigrationMetaData cmMigrationMetaData = this.cmMigrationMetaDataDao.getMigrationMetaDataForDeviceUUID(deviceUUID);
        if (null == cmMigrationMetaData) {
            logger.info(" Migration not started for deviceUUID ={} ", (Object)deviceUUID);
            this.startBackupImageMigration(null, device, documents);
        } else {
            if (null != cmMigrationMetaData && COMPLETED.equals(cmMigrationMetaData.getStatus())) {
                logger.info(" Migration already completed for deviceUUID ={}, with backup Images document count={} ", (Object)deviceUUID, (Object)cmMigrationMetaData.getOffset());
                return;
            }
            logger.info("Migration was started for deviceUUID ={}, resuming the migration from offset = {}", (Object)deviceUUID, (Object)cmMigrationMetaData.getOffset());
            this.startBackupImageMigration(cmMigrationMetaData, device, documents);
        }
    }

    private void startBackupImageMigration(CMMigrationMetaData cmMigrationMetaData, Device device, int documents) {
        int offset = 0;
        String deviceUUID = null;
        String cmCollectionName = null;
        String backupImageCollectionName = null;
        List backUpImages = new ArrayList();
        if (cmMigrationMetaData == null) {
            deviceUUID = device.getDeviceUUID();
            if (Device.TYPE.OUTLOOK.toString().equals(device.getDeviceType())) {
                cmCollectionName = CM_OUTLOOK_COLLECTION;
            } else if (Device.TYPE.SHAREPOINT.toString().equals(device.getDeviceType())) {
                cmCollectionName = CM_SP_COLLECTION;
            } else if (Device.TYPE.ONEDRIVE.toString().equals(device.getDeviceType())) {
                cmCollectionName = CM_ODB_COLLECTION;
            }
            backupImageCollectionName = device.getDestCollection();
        }
        if (cmMigrationMetaData != null) {
            deviceUUID = cmMigrationMetaData.getDeviceUUID();
            offset = cmMigrationMetaData.getOffset();
            cmCollectionName = cmMigrationMetaData.getCapacityCollectionName();
            backupImageCollectionName = cmMigrationMetaData.getBackupImageCollectionName();
        }
        if (cmCollectionName == null) {
            return;
        }
        boolean isCompleted = false;
        while (true) {
            logger.info("For deviceUUID ={}, Taking maximum of={},  backup Images from = {}, after offset = {},  and will be inserted in ={}", new Object[]{deviceUUID, documents, backupImageCollectionName, offset, cmCollectionName});
            int totalBackUpImagesToBeMigrated = 0;
            long startTime = System.currentTimeMillis();
            if (cmMigrationMetaData != null) {
                backUpImages = this.backUpImageDao.getBackUpImageToMigrate(cmMigrationMetaData.getDeviceUUID(), backupImageCollectionName, offset, documents);
            } else if (cmMigrationMetaData == null) {
                backUpImages = this.backUpImageDao.getBackUpImageToMigrate(device.getDeviceUUID(), backupImageCollectionName, offset, documents);
            }
            logger.info("Time to get the documents={}, is={} secs", (Object)documents, (Object)((System.currentTimeMillis() - startTime) / 1000L));
            totalBackUpImagesToBeMigrated = backUpImages.size();
            logger.info("For deviceUUID ={}, total backup Image to be migrated ={} ", (Object)deviceUUID, (Object)totalBackUpImagesToBeMigrated);
            if (totalBackUpImagesToBeMigrated == 0) break;
            List cmBackUpImages = this.copyBackUpImageToCMBackUpImage(backUpImages);
            this.cmBackUpImageDao.insertCmBackUpImages(cmCollectionName, cmBackUpImages);
            logger.info("For deviceUUID ={}, Migrated total of = {}, backup Images from ={}, to={} ", new Object[]{deviceUUID, offset += totalBackUpImagesToBeMigrated, backupImageCollectionName, cmCollectionName});
            if (cmMigrationMetaData == null) {
                cmMigrationMetaData = new CMMigrationMetaData();
                cmMigrationMetaData.setCapacityCollectionName(cmCollectionName);
                cmMigrationMetaData.setBackupImageCollectionName(backupImageCollectionName);
                cmMigrationMetaData.setDeviceUUID(device.getDeviceUUID());
                cmMigrationMetaData.setOffset(offset);
                this.cmMigrationMetaDataDao.insertCmMigrationMetaData(cmMigrationMetaData);
                continue;
            }
            cmMigrationMetaData.setOffset(offset);
            this.cmMigrationMetaDataDao.updateCmMetaData(cmMigrationMetaData);
        }
        logger.info("For deviceUUID = {}, There is no documents to be migrated for device UUID = {}", (Object)deviceUUID, (Object)device.getDeviceUUID());
        isCompleted = true;
        if (isCompleted) {
            if (cmMigrationMetaData == null) {
                logger.info("For deviceUUID = {}, there is no records found, hence marking it as completed", (Object)deviceUUID);
                cmMigrationMetaData = new CMMigrationMetaData();
                cmMigrationMetaData.setCapacityCollectionName(cmCollectionName);
                cmMigrationMetaData.setBackupImageCollectionName(backupImageCollectionName);
                cmMigrationMetaData.setDeviceUUID(device.getDeviceUUID());
                cmMigrationMetaData.setStatus(COMPLETED);
                cmMigrationMetaData.setOffset(offset);
                this.cmMigrationMetaDataDao.insertCmMigrationMetaData(cmMigrationMetaData);
            } else {
                logger.info("For deviceUUID = {}, Completed the migration for Backup Files for device UUID = {}, with total migrated items ={}", new Object[]{deviceUUID, cmMigrationMetaData.getDeviceUUID(), cmMigrationMetaData.getOffset()});
                cmMigrationMetaData.setStatus(COMPLETED);
                cmMigrationMetaData.setOffset(offset);
                this.cmMigrationMetaDataDao.updateCmMetaData(cmMigrationMetaData);
            }
        }
    }

    private List<CMBackUpImage> copyBackUpImageToCMBackUpImage(List<BackUpImage> backUpImages) {
        ArrayList<CMBackUpImage> cmBackUpImages = new ArrayList<CMBackUpImage>();
        for (BackUpImage backUpImage : backUpImages) {
            CMBackUpImage cmBackUpImage = new CMBackUpImage();
            BeanUtils.copyProperties((Object)backUpImage, (Object)cmBackUpImage);
            cmBackUpImages.add(cmBackUpImage);
        }
        return cmBackUpImages;
    }
}

