/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.backupmigrateutility.dao;

import com.mongodb.bulk.BulkWriteResult;
import com.parablu.backupmigrateutility.dao.CMBackUpImageDao;
import com.parablu.backupmigrateutility.domain.CMBackUpImage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class CMBackUpImageDaoImpl
implements CMBackUpImageDao {
    private static final Logger logger = LoggerFactory.getLogger(CMBackUpImageDaoImpl.class);
    private static final String CM_SP_COLLECTION = "CAPACITY_MGMT_BACKUP_SP";
    private static final String CM_ODB_COLLECTION = "CAPACITY_MGMT_BACKUP_ODB";
    private static final String CM_OUTLOOK_COLLECTION = "CAPACITY_MGMT_BACKUP_OUTLOOK";
    @Autowired
    private MongoTemplate mongoTemplate;

    public void insertCmBackUpImages(String collectionName, List<CMBackUpImage> cmBackUpImage) {
        BulkWriteResult result = null;
        try {
            this.mongoTemplate.insert(cmBackUpImage, collectionName);
            BulkOperations bulkInsert = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, CMBackUpImage.class, collectionName);
            bulkInsert.insert(cmBackUpImage);
            result = bulkInsert.execute();
        }
        catch (Exception e) {
            logger.error("There is an error while inserting the CM BackupImage e= ", (Throwable)e);
        }
        if (result != null) {
            logger.info("Number of records inserted ={}", (Object)result.getInsertedCount());
        }
    }

    public void removeCmBackUpImage() {
        this.mongoTemplate.dropCollection(CM_SP_COLLECTION);
        this.mongoTemplate.dropCollection(CM_ODB_COLLECTION);
        this.mongoTemplate.dropCollection(CM_OUTLOOK_COLLECTION);
    }
}

