/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.springboot;

import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.OldOfficeBackupPolicy;
import com.parablu.pcbd.domain.OldUser;
import com.parablu.pcbd.domain.User;
import com.parablu.springboot.repository.CloudRepository;
import com.parablu.springboot.repository.OfficeBackupPolicyRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.data.mongo.MongoRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.util.CollectionUtils;

@SpringBootApplication
@EnableAutoConfiguration(exclude={MongoAutoConfiguration.class, MongoRepositoriesAutoConfiguration.class, MongoDataAutoConfiguration.class})
public class PolicyUpgradeLatest
implements CommandLineRunner {
    @Autowired
    OfficeBackupPolicyRepository officeBackupPolicyRepo;
    @Autowired
    CloudRepository cloudRepository;

    public static void main(String[] args) {
        SpringApplication.run(PolicyUpgradeLatest.class, (String[])args);
    }

    private boolean isExchangeBackupEnabled(Cloud cl) {
        boolean isExchangeBackupEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((CharSequence)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExchangeBackupEnabled = true;
                break;
            }
        }
        return isExchangeBackupEnabled;
    }

    private boolean isOneDriveForBusinessBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((CharSequence)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    public void run(String ... args) {
        System.out.println(".....started.....");
        PropertiesConfiguration config = null;
        try {
            config = new PropertiesConfiguration(args[0]);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        String mongoMainIP = config.getProperty("mongoMainIP").toString();
        String mongoMainPort = config.getProperty("mongoMainPort").toString();
        if (StringUtils.isEmpty((CharSequence)mongoMainIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoMainPort);
        List findAll = this.cloudRepository.findAll(mongoMainIP, mongoMainPort);
        Cloud cloud = (Cloud)findAll.get(0);
        boolean isMailEnabled = this.isExchangeBackupEnabled(cloud);
        boolean isOdbEnabled = this.isOneDriveForBusinessBackupEnabled(cloud);
        System.out.println("....cloud check completed..." + findAll.size());
        System.out.println("....cloud licence odb and mail..." + isOdbEnabled + ".." + isMailEnabled);
        List allList = this.officeBackupPolicyRepo.loadAll(mongoMainIP, mongoMainPort);
        ArrayList<String> newPolicyAppenderList = new ArrayList<String>();
        newPolicyAppenderList.add("ODB_");
        newPolicyAppenderList.add("EX_");
        for (OldOfficeBackupPolicy officeBackupPolicy : allList) {
            Object newPolicyName;
            String oldPolicyName = officeBackupPolicy.getPolicyName();
            System.out.println(".....policy name....." + oldPolicyName);
            if (oldPolicyName.startsWith("STAGING")) continue;
            if (oldPolicyName.startsWith("STATISTIC")) {
                String productType;
                OfficeBackupPolicy newPolicy;
                OfficeBackupPolicy officeBackupPolicyNew = this.officeBackupPolicyRepo.getNewPolicy("STAGING_EX_POLICY", mongoMainIP, mongoMainPort);
                if (officeBackupPolicyNew == null && isMailEnabled) {
                    newPolicy = new OfficeBackupPolicy();
                    BeanUtils.copyProperties((Object)officeBackupPolicy, (Object)newPolicy);
                    newPolicy.setId(null);
                    newPolicyName = "STAGING_EX_POLICY";
                    newPolicy.setPolicyName((String)newPolicyName);
                    productType = "Exchange";
                    newPolicy.setPolicyType(productType);
                    System.out.println((String)newPolicyName + "....new policy..." + productType);
                    this.createMailPolicy(officeBackupPolicy, newPolicy, mongoMainIP, mongoMainPort);
                }
                if ((officeBackupPolicyNew = this.officeBackupPolicyRepo.getNewPolicy("STAGING_ODB_POLICY", mongoMainIP, mongoMainPort)) == null && isOdbEnabled) {
                    newPolicy = new OfficeBackupPolicy();
                    BeanUtils.copyProperties((Object)officeBackupPolicy, (Object)newPolicy);
                    newPolicy.setId(null);
                    newPolicyName = "STAGING_ODB_POLICY";
                    newPolicy.setPolicyName((String)newPolicyName);
                    productType = "ODB";
                    newPolicy.setPolicyType(productType);
                    System.out.println((String)newPolicyName + "....new policy..." + productType);
                    this.createOdbPolicy(officeBackupPolicy, newPolicy, mongoMainIP, mongoMainPort);
                }
                List oldUsers = this.officeBackupPolicyRepo.getAllUsersForPolicyName(oldPolicyName, mongoMainIP, mongoMainPort);
                System.out.println(oldUsers.size() + "..################.oldpolicyusers .############.." + oldPolicyName);
                if (!CollectionUtils.isEmpty((Collection)oldUsers)) {
                    for (OldUser oldUser : oldUsers) {
                        DeviceBackupOverView backupOverView;
                        String newPolicyName2;
                        System.out.println("....@@@@user@@@@...." + oldUser.getUserName());
                        User user = new User();
                        BeanUtils.copyProperties((Object)oldUser, (Object)user);
                        if (isOdbEnabled) {
                            newPolicyName2 = "STAGING_ODB_POLICY";
                            System.out.println("....@@@@userisOnedriveBkpEnabled@@@@...." + newPolicyName2);
                            officeBackupPolicyNew = this.officeBackupPolicyRepo.getNewPolicy(newPolicyName2, mongoMainIP, mongoMainPort);
                            if (officeBackupPolicyNew != null && officeBackupPolicyNew.getPolicyType().equalsIgnoreCase("ODB")) {
                                user.setOneDrivePolicyName(officeBackupPolicyNew.getPolicyName());
                                backupOverView = this.officeBackupPolicyRepo.getDeviceBkpOverview(oldUser.getOdbPolicyName(), Device.TYPE.ONEDRIVE.name(), oldUser.getUserName(), mongoMainIP, mongoMainPort);
                                if (backupOverView != null) {
                                    backupOverView.setOneDrivePolicyName(officeBackupPolicyNew.getPolicyName());
                                    this.officeBackupPolicyRepo.saveOverView(backupOverView, mongoMainIP, mongoMainPort);
                                }
                            }
                        }
                        if (isMailEnabled) {
                            newPolicyName2 = "STAGING_EX_POLICY";
                            officeBackupPolicyNew = this.officeBackupPolicyRepo.getNewPolicy(newPolicyName2, mongoMainIP, mongoMainPort);
                            System.out.println("....@@@@userisExchangeBkpEnabled@@@@...." + newPolicyName2);
                            if (officeBackupPolicyNew != null && officeBackupPolicyNew.getPolicyType().equalsIgnoreCase("Exchange")) {
                                user.setExchangePolicyName(officeBackupPolicyNew.getPolicyName());
                                backupOverView = this.officeBackupPolicyRepo.getDeviceBkpOverview(oldUser.getOdbPolicyName(), Device.TYPE.OUTLOOK.name(), oldUser.getUserName(), mongoMainIP, mongoMainPort);
                                if (backupOverView != null) {
                                    backupOverView.setExchangePolicyName(officeBackupPolicyNew.getPolicyName());
                                    this.officeBackupPolicyRepo.saveOverView(backupOverView, mongoMainIP, mongoMainPort);
                                }
                            }
                        }
                        this.officeBackupPolicyRepo.saveUser(user, mongoMainIP, mongoMainPort);
                    }
                }
            } else {
                for (String newAppend : newPolicyAppenderList) {
                    newPolicyName = newAppend + oldPolicyName;
                    System.out.println("...new policyName0...." + (String)newPolicyName);
                    System.out.println("...new policyName1...." + (String)newPolicyName);
                    OfficeBackupPolicy officeBackupPolicyNew = this.officeBackupPolicyRepo.getNewPolicy((String)newPolicyName, mongoMainIP, mongoMainPort);
                    System.out.println(officeBackupPolicyNew + "...new policyName2...." + (String)newPolicyName);
                    if (officeBackupPolicyNew == null) {
                        System.out.println("....policy does not exist so create...." + (String)newPolicyName);
                        String productType = "";
                        if (newAppend.startsWith("ODB_")) {
                            productType = "ODB";
                        }
                        if (newAppend.startsWith("EX_")) {
                            productType = "Exchange";
                        }
                        OfficeBackupPolicy newPolicy = new OfficeBackupPolicy();
                        BeanUtils.copyProperties((Object)officeBackupPolicy, (Object)newPolicy);
                        newPolicy.setId(null);
                        newPolicy.setPolicyName((String)newPolicyName);
                        newPolicy.setPolicyType(productType);
                        System.out.println(productType + "....newAppend..." + newAppend);
                        System.out.println((String)newPolicyName + "....new policy..." + productType);
                        if (isMailEnabled && productType.equalsIgnoreCase("Exchange")) {
                            this.createMailPolicy(officeBackupPolicy, newPolicy, mongoMainIP, mongoMainPort);
                            continue;
                        }
                        if (!isOdbEnabled || !productType.equalsIgnoreCase("ODB")) continue;
                        this.createOdbPolicy(officeBackupPolicy, newPolicy, mongoMainIP, mongoMainPort);
                        continue;
                    }
                    System.out.println("....policy exist ..." + (String)newPolicyName);
                }
            }
            if (oldPolicyName.startsWith("STAGING")) continue;
            List oldUsers = this.officeBackupPolicyRepo.getAllUsersForPolicyName(oldPolicyName, mongoMainIP, mongoMainPort);
            System.out.println(oldUsers.size() + "..################.oldpolicyusers .############.." + oldPolicyName);
            System.out.println(oldUsers.size() + "..################.updateusers .############.." + oldPolicyName);
            this.updatePolicyForUser(oldPolicyName, oldUsers, isMailEnabled, isOdbEnabled, mongoMainIP, mongoMainPort);
        }
        System.out.println("...cloudproperties element..");
        System.out.println(".....completed....");
        System.exit(0);
    }

    private void updatePolicyForUser(String oldPolicyName, List<OldUser> oldUsers, boolean isMailEnabled, boolean isOdbEnabled, String mongoMainIP, String mongoMainPort) {
        if (!CollectionUtils.isEmpty(oldUsers)) {
            for (OldUser oldUser : oldUsers) {
                DeviceBackupOverView backupOverView;
                OfficeBackupPolicy officeBackupPolicyNew;
                String newPolicyName;
                System.out.println("....@@@@user@@@@...." + oldUser.getUserName());
                User user = new User();
                BeanUtils.copyProperties((Object)oldUser, (Object)user);
                if (isOdbEnabled) {
                    newPolicyName = "ODB_" + oldPolicyName;
                    System.out.println("....@@@@userisOnedriveBkpEnabled@@@@...." + newPolicyName);
                    officeBackupPolicyNew = this.officeBackupPolicyRepo.getNewPolicy(newPolicyName, mongoMainIP, mongoMainPort);
                    if (officeBackupPolicyNew != null && officeBackupPolicyNew.getPolicyType().equalsIgnoreCase("ODB")) {
                        user.setOneDrivePolicyName(officeBackupPolicyNew.getPolicyName());
                        backupOverView = this.officeBackupPolicyRepo.getDeviceBkpOverview(oldUser.getOdbPolicyName(), Device.TYPE.ONEDRIVE.name(), oldUser.getUserName(), mongoMainIP, mongoMainPort);
                        if (backupOverView != null) {
                            backupOverView.setOneDrivePolicyName(officeBackupPolicyNew.getPolicyName());
                            this.officeBackupPolicyRepo.saveOverView(backupOverView, mongoMainIP, mongoMainPort);
                        }
                    }
                }
                if (isMailEnabled) {
                    newPolicyName = "EX_" + oldPolicyName;
                    officeBackupPolicyNew = this.officeBackupPolicyRepo.getNewPolicy(newPolicyName, mongoMainIP, mongoMainPort);
                    System.out.println("....@@@@userisExchangeBkpEnabled@@@@...." + newPolicyName);
                    if (oldUser.getUserName().equalsIgnoreCase("mukesh.prasad@shriramproperties.com")) {
                        System.out.println("********mukesh.prasad@shriramproperties.com**** before*****");
                    }
                    if (officeBackupPolicyNew != null && officeBackupPolicyNew.getPolicyType().equalsIgnoreCase("Exchange")) {
                        if (oldUser.getUserName().equalsIgnoreCase("mukesh.prasad@shriramproperties.com")) {
                            System.out.println("********mukesh.prasad@shriramproperties.com******inside policy***");
                        }
                        user.setExchangePolicyName(officeBackupPolicyNew.getPolicyName());
                        backupOverView = this.officeBackupPolicyRepo.getDeviceBkpOverview(oldUser.getOdbPolicyName(), Device.TYPE.OUTLOOK.name(), oldUser.getUserName(), mongoMainIP, mongoMainPort);
                        if (backupOverView != null) {
                            if (oldUser.getUserName().equalsIgnoreCase("mukesh.prasad@shriramproperties.com")) {
                                System.out.println(backupOverView.getDeviceUUID() + "********mukesh.prasad@shriramproperties.com*****backupoverview not null before updating policy****" + officeBackupPolicyNew.getPolicyName());
                                System.out.println(backupOverView.getUserName() + "*****mukesh.prasad@shriramproperties.com*****backupoverview before updating policy****" + officeBackupPolicyNew.getPolicyName());
                            }
                            backupOverView.setExchangePolicyName(officeBackupPolicyNew.getPolicyName());
                            this.officeBackupPolicyRepo.saveOverView(backupOverView, mongoMainIP, mongoMainPort);
                        } else if (oldUser.getUserName().equalsIgnoreCase("mukesh.prasad@shriramproperties.com")) {
                            System.out.println("********mukesh.prasad@shriramproperties.com******empty overview***");
                        }
                    }
                }
                this.officeBackupPolicyRepo.saveUser(user, mongoMainIP, mongoMainPort);
            }
        }
    }

    private void createOdbPolicy(OldOfficeBackupPolicy officeBackupPolicy, OfficeBackupPolicy newPolicy, String mongoMainIP, String mongoMainPort) {
        ArrayList odSearchInclusionFilter;
        ArrayList odPrivacyGateway;
        ArrayList odInclusionFilter;
        ArrayList odFilterInclusionName;
        List odSchedules;
        List odExcludedFolders;
        List odBackupFolders = officeBackupPolicy.getOdBackupFolders();
        if (!CollectionUtils.isEmpty((Collection)odBackupFolders)) {
            newPolicy.setBackupFolders(new ArrayList());
            newPolicy.getBackupFolders().addAll(odBackupFolders);
        }
        if (!CollectionUtils.isEmpty((Collection)(odExcludedFolders = officeBackupPolicy.getOdExcludedFolders()))) {
            newPolicy.setExcludedFolders(new ArrayList());
            newPolicy.getExcludedFolders().addAll(odExcludedFolders);
        }
        if (!CollectionUtils.isEmpty((Collection)(odSchedules = officeBackupPolicy.getOdSchedules()))) {
            newPolicy.setSchedules(new ArrayList());
            newPolicy.getSchedules().addAll(odSchedules);
        }
        if (!CollectionUtils.isEmpty((Collection)(odFilterInclusionName = officeBackupPolicy.getOdFilterInclusionName()))) {
            newPolicy.setFilterInclusionName(new ArrayList());
            newPolicy.getFilterInclusionName().addAll(odFilterInclusionName);
        }
        if (!CollectionUtils.isEmpty((Collection)(odInclusionFilter = officeBackupPolicy.getOdInclusionFilter()))) {
            newPolicy.setInclusionFilter(new ArrayList());
            newPolicy.getInclusionFilter().addAll(odInclusionFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)(odPrivacyGateway = officeBackupPolicy.getOdPrivacyGateways()))) {
            newPolicy.setPrivacyGateways(new ArrayList());
            newPolicy.getPrivacyGateways().addAll(odPrivacyGateway);
        }
        if (!CollectionUtils.isEmpty((Collection)(odSearchInclusionFilter = officeBackupPolicy.getOdSearchInclusionFilter()))) {
            newPolicy.setSearchInclusionFilter(new ArrayList());
            newPolicy.getSearchInclusionFilter().addAll(odSearchInclusionFilter);
        }
        String odFilterType = officeBackupPolicy.getOdFilterType();
        newPolicy.setFilterType(odFilterType);
        String odMaxFileSize = officeBackupPolicy.getOdMaxFileSize();
        newPolicy.setMaxFileSize(odMaxFileSize);
        String odMsAppBluKrypt = officeBackupPolicy.getOdMsAppBluKrypt();
        newPolicy.setMsAppBluKrypt(odMsAppBluKrypt);
        int odMaxVersions = officeBackupPolicy.getOdMaxVersions();
        newPolicy.setMaxVersions(odMaxVersions);
        int odUserSizeAllowed = officeBackupPolicy.getOdUserSizeAllowed();
        newPolicy.setUserSizeAllowed(odUserSizeAllowed);
        this.officeBackupPolicyRepo.saveNewPolicy(newPolicy, mongoMainIP, mongoMainPort);
        System.out.println("******policy inserted****" + newPolicy.getPolicyName());
    }

    private void createMailPolicy(OldOfficeBackupPolicy officeBackupPolicy, OfficeBackupPolicy newPolicy, String mongoMainIP, String mongoMainPort) {
        ArrayList mailSearchInclusionFilter;
        ArrayList mailPrivacyGateway;
        ArrayList mailInclusionFilter;
        ArrayList mailFilterInclusionName;
        List mailSchedules;
        List mailExcludedFolders;
        List mailBackupFolders = officeBackupPolicy.getMailBackupFolders();
        if (!CollectionUtils.isEmpty((Collection)mailBackupFolders)) {
            newPolicy.setBackupFolders(new ArrayList());
            newPolicy.getBackupFolders().addAll(mailBackupFolders);
        }
        if (!CollectionUtils.isEmpty((Collection)(mailExcludedFolders = officeBackupPolicy.getMailExcludedFolders()))) {
            newPolicy.setExcludedFolders(new ArrayList());
            newPolicy.getExcludedFolders().addAll(mailExcludedFolders);
        }
        if (!CollectionUtils.isEmpty((Collection)(mailSchedules = officeBackupPolicy.getMailSchedules()))) {
            newPolicy.setSchedules(new ArrayList());
            newPolicy.getSchedules().addAll(mailSchedules);
        }
        if (!CollectionUtils.isEmpty((Collection)(mailFilterInclusionName = officeBackupPolicy.getMailFilterInclusionName()))) {
            newPolicy.setFilterInclusionName(new ArrayList());
            newPolicy.getFilterInclusionName().addAll(mailFilterInclusionName);
        }
        if (!CollectionUtils.isEmpty((Collection)(mailInclusionFilter = officeBackupPolicy.getMailInclusionFilter()))) {
            newPolicy.setInclusionFilter(new ArrayList());
            newPolicy.getInclusionFilter().addAll(mailInclusionFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)(mailPrivacyGateway = officeBackupPolicy.getMailPrivacyGateways()))) {
            newPolicy.setPrivacyGateways(new ArrayList());
            newPolicy.getPrivacyGateways().addAll(mailPrivacyGateway);
        }
        if (!CollectionUtils.isEmpty((Collection)(mailSearchInclusionFilter = officeBackupPolicy.getOdSearchInclusionFilter()))) {
            newPolicy.setSearchInclusionFilter(new ArrayList());
            newPolicy.getSearchInclusionFilter().addAll(mailSearchInclusionFilter);
        }
        String mailFilterType = officeBackupPolicy.getMailFilterType();
        newPolicy.setFilterType(mailFilterType);
        String mailMaxFileSize = officeBackupPolicy.getMailMaxFileSize();
        newPolicy.setMaxFileSize(mailMaxFileSize);
        String mailMsAppBluKrypt = officeBackupPolicy.getMailMsAppBluKrypt();
        newPolicy.setMsAppBluKrypt(mailMsAppBluKrypt);
        int mailMaxVersions = officeBackupPolicy.getMailMaxVersions();
        newPolicy.setMaxVersions(mailMaxVersions);
        int mailUserSizeAllowed = officeBackupPolicy.getMailUserSizeAllowed();
        newPolicy.setUserSizeAllowed(mailUserSizeAllowed);
        this.officeBackupPolicyRepo.saveNewPolicy(newPolicy, mongoMainIP, mongoMainPort);
        System.out.println("******policy inserted****" + newPolicy.getPolicyName());
    }
}

