/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDefinedFolders;
import com.parablu.pcbd.domain.UsersWOBackup;
import com.pg.graph.helper.ScheduleTO;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.MSService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class MailAutoScheduleJob
extends QuartzJobBean
implements Job {
    private MSService msService;
    private Set<String> policyUnderProcess = new HashSet<String>();
    private static Logger logger = LogManager.getLogger(MailAutoScheduleJob.class);
    private static List<OfficeBackupPolicy> officeBackupPolicyList = null;
    private TimerTask userTimerTask = null;
    private Timer userTimer = null;
    private TimerTask policyTimerTask = null;
    private Timer policyTimer = null;
    public static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";
    private Timer userBackupTimer = null;
    private TimerTask userBackupTimerTask = null;
    private static List<User> userInfoList = null;
    CompletionService<String> userPool = null;
    private static Map<String, List<User>> policyUserMap = null;
    private Set<String> userUnderProcess = new HashSet<String>();
    private Timer userPolicyBackupTimer = null;
    private TimerTask userPolicyBackupTimerTask = null;

    public void setMsService(MSService msService) {
        this.msService = msService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        logger.debug("....MailAutoScheduleJob job started...");
        ExecutorService executor = null;
        try {
            int cloudId = 1;
            Cloud cloud = this.msService.getCloud(cloudId);
            boolean isMailEnabled = this.isExchangeBackupEnabled(cloud);
            if (isMailEnabled) {
                List<OfficeBackupPolicy> policyList;
                boolean licenseActive;
                if (cloud != null) {
                    logger.debug("......cloud val...." + cloud.getCloudName());
                }
                if (!(licenseActive = this.vaildatedLicensceStatus(cloud))) {
                    logger.debug("....license inactive no crawl....");
                    Thread.sleep(1200000L);
                    return;
                }
                long threadSize = this.msService.getThreadSize(cloud.getCloudId(), cloud.getCloudName());
                if (threadSize == 0L) {
                    threadSize = PCHelperConstant.getThreadLimit();
                }
                if (!CollectionUtils.isEmpty(policyList = this.msService.getAllOfficeBackupPolicies(cloudId))) {
                    threadSize = policyList.size();
                }
                logger.debug(" threads val........" + threadSize);
                int threadSizeVal = (int)threadSize;
                executor = Executors.newFixedThreadPool(threadSizeVal);
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                ExecutorService userExecutor = Executors.newCachedThreadPool();
                this.userPool = new ExecutorCompletionService<String>(userExecutor);
                officeBackupPolicyList = new ArrayList<OfficeBackupPolicy>();
                logger.debug("... get officeBackupPolicyList list ... " + officeBackupPolicyList.size());
                this.checkThreadStatusAndStartScheduleForPolicy(cloud, executor, pool);
                for (int i = 0; i < threadSizeVal; ++i) {
                    logger.debug("Creating thread for first time policy >>>>>>>>> i value::" + i);
                    this.initiatePolicySchedules(cloud, executor, pool, true);
                }
            } else {
                logger.debug("...mail not enabled.... so sleep for 20 mins...");
                Thread.sleep(1200000L);
            }
            logger.debug(" exit upload part.........." + isMailEnabled);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" exception in MailAutoScheduleJob......." + e.getMessage());
            logger.trace("exception in MailAutoScheduleJob ......." + e);
        }
        logger.debug("....msDownload job ended...");
    }

    private boolean vaildatedLicensceStatus(Cloud cloud) {
        return cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE");
    }

    private boolean isExchangeBackupEnabled(Cloud cl) {
        boolean isExchangeBackupEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExchangeBackupEnabled = true;
                break;
            }
        }
        return isExchangeBackupEnabled;
    }

    private void initiatePolicySchedules(Cloud cloud, ExecutorService executor, CompletionService<String> pool, boolean firstTime) {
        logger.debug("starting policy schedules ............... :");
        Runnable schedulePolicyJob = () -> this.schdeuleUsersForPolicy(cloud, executor, pool, firstTime);
        pool.submit(schedulePolicyJob, "");
    }

    private void checkThreadStatusAndStartScheduleForPolicy(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.policyTimer == null) {
            this.policyTimer = new Timer();
        }
        if (this.policyTimerTask == null) {
            this.policyTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed schedule policy >>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed for schedule policy so assign new task with future>>>>>>>>>>>" + (String)future.get());
                            MailAutoScheduleJob.this.initiatePolicySchedules(cloud, executor, pool, false);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartScheduleForPolicy", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            logger.debug(".......inside checkThreadStatusAndStartScheduleForPolicy....  ");
            this.policyTimer.schedule(this.policyTimerTask, 100L, 1000L);
        }
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final CompletionService<String> pool, final List<User> usersList) {
        if (this.userTimer == null) {
            this.userTimer = new Timer();
        }
        if (this.userTimerTask == null) {
            this.userTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            MailAutoScheduleJob.this.initiateMSDeltaQueries(cloud, pool, usersList);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            logger.debug("...iniitiatecheckThreadStatusAndStartUpload...");
            this.userTimer.schedule(this.userTimerTask, 1000L, 1000L);
        }
    }

    private void initiateMSDeltaQueries(Cloud cloud, CompletionService<String> pool, List<User> usersList) {
        logger.debug("Files to backup ............... :");
        Runnable uploadJob = () -> this.uploadFiles(cloud, pool, usersList);
        pool.submit(uploadJob, "");
    }

    private void schdeuleUsersForPolicy(Cloud cloud, ExecutorService executor, CompletionService<String> pool, boolean firstTime) {
        try {
            OfficeBackupPolicy officeBackupPolicy = this.getPolicyForProcessing(cloud.getCloudId());
            logger.debug(officeBackupPolicy.getPolicyName() + "... entering scheduleusersforpolicy... ");
            if (officeBackupPolicy != null) {
                logger.debug(Thread.currentThread().getName() + "... entering scheduleusersforpolicy... " + officeBackupPolicy.getPolicyName() + "..." + Thread.currentThread().getName());
                logger.debug((MemoryStore.get((String)officeBackupPolicy.getPolicyName()) == null) + "... entering memstore... " + officeBackupPolicy.getPolicyName() + "..." + Thread.currentThread().getName());
                if (MemoryStore.get((String)officeBackupPolicy.getPolicyName()) == null) {
                    logger.debug("... is Backup allowed first.... " + officeBackupPolicy.getPolicyName());
                    boolean isBackupAllowed = this.isBackupAllowed(officeBackupPolicy, firstTime);
                    logger.debug(officeBackupPolicy.getPolicyName() + "... is Backup allowed.... " + isBackupAllowed);
                    if (isBackupAllowed) {
                        logger.debug(officeBackupPolicy.getPolicyName() + "..policyThreadname..." + MemoryStore.get((String)(officeBackupPolicy.getPolicyName() + "thread")) + "...." + Thread.currentThread().getName());
                        logger.debug("....inside schdeuleUsersForPolicy.........." + officeBackupPolicy.getPolicyName());
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        List<User> allUsersForOfficeBackupPolicy = this.msService.getAllUsersForOfficeBackupPolicy(cloud.getCloudId(), officeBackupPolicy.getPolicyName());
                        ArrayList<User> users = new ArrayList<User>();
                        for (User user : allUsersForOfficeBackupPolicy) {
                            if (!user.isExchangeBkpEnabled()) continue;
                            users.add(user);
                        }
                        if (CollectionUtils.isEmpty(users)) {
                            logger.debug("... no users available for policy.... " + officeBackupPolicy.getPolicyName());
                            this.policyUnderProcess.remove(officeBackupPolicy.getPolicyName());
                        } else {
                            logger.debug("... get users list ... " + users.size());
                            logger.debug("Creating thread for users for policy name ::" + officeBackupPolicy.getPolicyName());
                            this.initiateMSDeltaQueries(cloud, this.userPool, users);
                        }
                        logger.debug("Thread ready for next File11 .... " + officeBackupPolicyList.size());
                    }
                }
            } else {
                logger.error(".. no policy for ");
            }
            logger.debug("..completed policy..." + officeBackupPolicy.getPolicyName());
        }
        catch (Exception e) {
            logger.error("exception inside MailAutoScheduleJob .... " + e.getMessage());
            logger.trace("exception inside MailAutoScheduleJob ...." + e);
        }
        logger.error("completed users for schedule wait for next retry>>>>");
    }

    private boolean isBackupAllowed(OfficeBackupPolicy oneDriveBackupPolicy, boolean firstTime) {
        boolean isBackupAllowed = false;
        long nextSchedule = this.getNextScheduledMinute(oneDriveBackupPolicy);
        String policyName = oneDriveBackupPolicy.getPolicyName();
        if (!firstTime && nextSchedule <= 2L) {
            try {
                logger.debug(oneDriveBackupPolicy.getPolicyName() + "....wait for mins..." + nextSchedule);
                Thread.sleep(nextSchedule * 60000L);
                nextSchedule = 1L;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        logger.debug(policyName + "....after getting nextscheduel..." + nextSchedule);
        if (nextSchedule == 1L) {
            logger.debug(policyName + "... wait for backup schedule to start in 1 min for policy ..." + policyName);
            if (MemoryStore.get((String)policyName) == null) {
                logger.debug("... enable backup for policy ... " + policyName);
                MemoryStore.add((String)policyName, (Object)nextSchedule);
                if (MemoryStore.get((String)(policyName + "thread")) == null) {
                    MemoryStore.add((String)(policyName + "thread"), (Object)Thread.currentThread().getName());
                }
                isBackupAllowed = true;
            } else {
                logger.debug("... already backup enable for policy ... " + policyName);
                isBackupAllowed = false;
            }
        }
        return isBackupAllowed;
    }

    private List<OfficeBackupPolicy> getPolicyListForProcessing(int cloudId) {
        List<OfficeBackupPolicy> policyList = this.msService.getAllOfficeBackupPolicies(cloudId);
        for (OfficeBackupPolicy policy : policyList) {
            officeBackupPolicyList.add(policy);
        }
        return officeBackupPolicyList;
    }

    public void checkThreadStatusAndStartUploadForUser(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool, final ListIterator<User> iterator, final long batchStartTime, final OfficeBackupPolicy officeBackupPolicy, final OfficeBackupPolicy officeBackupPolicyFromLocal) {
        if (this.userBackupTimer == null) {
            this.userBackupTimer = new Timer();
        }
        if (this.userBackupTimerTask == null) {
            this.userBackupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.debug("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            if (iterator.hasNext()) {
                                MailAutoScheduleJob.this.processUserFiles(cloud, executor, pool, iterator, batchStartTime, officeBackupPolicy, officeBackupPolicyFromLocal);
                            } else {
                                executor.shutdown();
                                MailAutoScheduleJob.this.userBackupTimer.cancel();
                                MailAutoScheduleJob.this.userBackupTimerTask.cancel();
                                MailAutoScheduleJob.this.userBackupTimer = null;
                                MailAutoScheduleJob.this.userBackupTimerTask = null;
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.debug("Error in checkThreadStatusAndStartUpload" + e);
                        logger.debug("" + e);
                    }
                }
            };
            if (this.userBackupTimer != null && this.userBackupTimerTask != null) {
                this.userBackupTimer.schedule(this.userBackupTimerTask, 1000L, 1000L);
            }
        }
    }

    private void processUserFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool, ListIterator<User> iterator, long batchStartTime, OfficeBackupPolicy officeBackupPolicy, OfficeBackupPolicy officeBackupPolicyFromLocal) {
        logger.debug("......processUserFiles......... :");
        Runnable uploadJob = () -> this.processUser(cloud, executor, pool, iterator, batchStartTime, officeBackupPolicy, officeBackupPolicyFromLocal);
        pool.submit(uploadJob, "");
    }

    private void processUser(Cloud cloud, ExecutorService executor, CompletionService<String> pool, ListIterator<User> iterator, long batchStartTime, OfficeBackupPolicy officeBackupPolicy, OfficeBackupPolicy officeBackupPolicyFromLocal) {
        if (iterator.hasNext()) {
            User user = iterator.next();
            logger.debug(user.getOdbPolicyName() + "...mail process started user...." + user.getUserName());
            this.uploadMailsForUser(cloud, officeBackupPolicy, officeBackupPolicyFromLocal, batchStartTime, user);
            logger.debug(user.getOdbPolicyName() + "...mail process ended user...." + user.getUserName());
        }
    }

    private static Date getDateByString(String currentBkpStarted) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
        Date yourDate = format.parse(currentBkpStarted);
        yourDate.setHours(0);
        yourDate.setMinutes(0);
        return yourDate;
    }

    public void checkThreadStatusAndStartUploadForUser(Cloud cloud, ExecutorService executor, final CompletionService<String> pool) {
        if (this.userPolicyBackupTimer == null) {
            this.userPolicyBackupTimer = new Timer();
        }
        if (this.userPolicyBackupTimerTask == null) {
            this.userPolicyBackupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    logger.debug("Check the task is completed>>>>>>>>");
                    try {
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("upload for user is done so wait for the next one >>>>>>>>>>>");
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            if (this.userPolicyBackupTimer != null && this.userPolicyBackupTimerTask != null) {
                this.userPolicyBackupTimer.schedule(this.userPolicyBackupTimerTask, 1000L, 1000L);
            }
        }
    }

    private void crawlIndUserData(Cloud cloud, User user, long batchStartTime, OfficeBackupPolicy officeBackupPolicy, OfficeBackupPolicy officeBackupPolicyFromLocal) {
        logger.debug(user.getOdbPolicyName() + "...mail process started user...." + user.getUserName());
        this.uploadMailsForUser(cloud, officeBackupPolicy, officeBackupPolicyFromLocal, batchStartTime, user);
        logger.debug(user.getOdbPolicyName() + "...mail process ended user...." + user.getUserName());
    }

    private void sleep10Sec() {
        try {
            logger.debug("....wait for 10 sec...");
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void crawlUserData(Cloud cloud, ExecutorService executor, CompletionService<String> pool, List<User> finalUsersOrderToBkp, long batchStartTime, OfficeBackupPolicy officeBackupPolicy, OfficeBackupPolicy officeBackupPolicyFromLocal) {
        if (!CollectionUtils.isEmpty(finalUsersOrderToBkp)) {
            logger.debug("....iteratorsize...." + finalUsersOrderToBkp.size());
            ListIterator<User> iterator = finalUsersOrderToBkp.listIterator();
            do {
                User user = iterator.next();
                logger.debug(iterator.hasNext() + ".....user to process...." + user.getUserName());
                Runnable uploadJob = () -> this.crawlIndUserData(cloud, user, batchStartTime, officeBackupPolicy, officeBackupPolicyFromLocal);
                pool.submit(uploadJob, "");
                if (iterator.hasNext()) continue;
                this.sleep10Sec();
            } while (iterator.hasNext());
            executor.shutdown();
        } else {
            executor.shutdown();
            logger.debug(".....shutdown....");
        }
    }

    private void uploadFiles(Cloud cloud, CompletionService<String> pool1, List<User> usersListVal) {
        User getUser = usersListVal.get(0);
        OfficeBackupPolicy officeBackupPolicy = this.msService.getOfficeBackupPolicyForUserName(cloud.getCloudId(), getUser.getUserName());
        OfficeBackupPolicy officeBackupPolicyFromLocal = this.msService.getOfficeBackupPolicyFromLocal(cloud.getCloudId(), officeBackupPolicy.getPolicyName());
        logger.debug(".... before mail backup...................");
        try {
            long batchStartTime = System.currentTimeMillis();
            ArrayList<String> usersNotBackedupList = new ArrayList<String>();
            ArrayList<User> finalUsersOrderToBkp = new ArrayList<User>();
            ArrayList<User> newUsersToPriortizeBkp = new ArrayList<User>();
            ArrayList<User> userInfoListlocal = new ArrayList<User>();
            for (User user : usersListVal) {
                logger.debug("...check user....");
                logger.debug("...check user1...." + user.getUserName());
                Device device = this.msService.getMailDeviceForUserName(cloud.getCloudId(), user.getUserName());
                boolean isBackupRunningStatus = false;
                logger.debug("...check user2...." + device);
                if (device != null) {
                    try {
                        logger.debug("...check user3...." + device.getUserName());
                        BackupBatch lastBkpBatch = this.msService.getLastBackupOnly(cloud.getCloudId(), user.getUserName(), device.getDeviceUUID());
                        logger.debug("...check user4...." + lastBkpBatch);
                        if (lastBkpBatch != null) {
                            DeviceBackupOverView deviceBackupOverView;
                            String lastBkpStatus = lastBkpBatch.getStatus();
                            if (!StringUtils.isEmpty((String)lastBkpStatus)) {
                                boolean bl = isBackupRunningStatus = StringUtils.isNotEmpty((String)lastBkpStatus) && !"COMPLETED".equalsIgnoreCase(lastBkpStatus) && !"PAUSED".equalsIgnoreCase(lastBkpStatus) && !"INTERRUPTED".equalsIgnoreCase(lastBkpStatus) && !"ABORTED".equalsIgnoreCase(lastBkpStatus) && !"EXITED".equalsIgnoreCase(lastBkpStatus);
                            }
                            if (!isBackupRunningStatus && (deviceBackupOverView = this.msService.getDeviceBackupOverViewForDevice(cloud.getCloudId(), device.getDeviceUUID())) != null) {
                                Date yourDate = MailAutoScheduleJob.getDateByString(deviceBackupOverView.getLastBkpEndTime());
                                DateTime dt1 = new DateTime((Object)yourDate);
                                int lastBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)new DateTime()).getDays();
                                logger.debug(deviceBackupOverView.getLastBkpEndTime() + "....lastBkpstatus...." + user.getUserName() + "...." + lastBkpStatus + ".." + lastBkpEndDiff);
                                if (lastBkpEndDiff > 0) {
                                    newUsersToPriortizeBkp.add(user);
                                    usersNotBackedupList.add(user.getUserName());
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (usersNotBackedupList.contains(user.getUserName())) continue;
                userInfoListlocal.add(user);
            }
            int officeThreads = 50;
            if (PCHelperConstant.getCrawlThreadsLimit() > 0) {
                officeThreads = PCHelperConstant.getCrawlThreadsLimit();
            }
            logger.debug(userInfoListlocal.size() + "......newUsersToPriortizeBkp user-list...." + newUsersToPriortizeBkp.size());
            finalUsersOrderToBkp.addAll(newUsersToPriortizeBkp);
            finalUsersOrderToBkp.addAll(userInfoListlocal);
            logger.debug(userInfoListlocal.size() + "......user-list...." + newUsersToPriortizeBkp.size());
            logger.debug("......totaluser-list...." + finalUsersOrderToBkp.size());
            if (!CollectionUtils.isEmpty(finalUsersOrderToBkp)) {
                ExecutorService executor = Executors.newFixedThreadPool(officeThreads);
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                this.checkThreadStatusAndStartUploadForUser(cloud, executor, pool);
                this.crawlUserData(cloud, executor, pool, finalUsersOrderToBkp, batchStartTime, officeBackupPolicy, officeBackupPolicyFromLocal);
                while (pool.poll() != null) {
                    logger.debug("upload is still happening so wait...");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                logger.debug("...completed pool.....");
                this.userPolicyBackupTimer = null;
                this.userPolicyBackupTimerTask = null;
                executor.shutdown();
                pool = null;
            } else {
                logger.debug("...no users to process... ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("..error trying to parse user mail..." + e.getMessage());
        }
        MemoryStore.delete((String)officeBackupPolicy.getPolicyName());
        logger.debug(".... completed usersList....................");
    }

    private void uploadMailsForUser(Cloud cloud, OfficeBackupPolicy officeBackupPolicy, OfficeBackupPolicy officeBackupPolicyFromLocal, long batchStartTime, User user) {
        boolean isPolicyModified = false;
        logger.debug("....inside for mail loopss.........." + user.getUserName());
        UsersWOBackup usersWOBackup = new UsersWOBackup();
        usersWOBackup.setProductType("MAIL");
        usersWOBackup.setUserName(user.getUserName());
        usersWOBackup.setPolicyName(officeBackupPolicy.getPolicyName());
        usersWOBackup.setCreatedTime(System.currentTimeMillis());
        this.msService.saveUserBeforeBackup(usersWOBackup);
        String userName = user.getUserName();
        Device device = this.msService.getMailDeviceForUserName(cloud.getCloudId(), userName);
        if (device == null) {
            return;
        }
        RestoreEvents restoreEvents = this.msService.getRestoreEventsByUUID(cloud.getCloudId(), device.getDeviceUUID());
        if (restoreEvents != null && restoreEvents.isSuspendBackup()) {
            logger.error(".....restore is running so backup cannot continue...  ");
            return;
        }
        int cloudId = cloud.getCloudId();
        if (device != null) {
            ArrayList<BackupFolders> inclusionbackupFolders = new ArrayList<BackupFolders>();
            List<UserDefinedFolders> userDefinedFoldersList = this.msService.getAllUserDefinedInclusionFolders(cloudId, device.getDeviceUUID(), userName);
            if (!CollectionUtils.isEmpty(userDefinedFoldersList)) {
                for (UserDefinedFolders userDefinedFolders : userDefinedFoldersList) {
                    BackupFolders backupFolderElement = new BackupFolders();
                    backupFolderElement.setId(userDefinedFolders.getId());
                    backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                    inclusionbackupFolders.add(backupFolderElement);
                }
            }
            ArrayList<ExcludedFolders> exclusionbackupFolders = new ArrayList<ExcludedFolders>();
            List<UserDefinedFolders> exclusionuserDefinedFoldersList = this.msService.getAllUserDefinedExclusionFolders(cloudId, device.getDeviceUUID(), userName);
            if (!CollectionUtils.isEmpty(exclusionuserDefinedFoldersList)) {
                for (UserDefinedFolders userDefinedFolders : exclusionuserDefinedFoldersList) {
                    ExcludedFolders backupFolderElement = new ExcludedFolders();
                    backupFolderElement.setId(userDefinedFolders.getId());
                    backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                    exclusionbackupFolders.add(backupFolderElement);
                }
            }
            if (CollectionUtils.isEmpty((Collection)officeBackupPolicy.getMailBackupFolders())) {
                officeBackupPolicy.setMailBackupFolders(new ArrayList());
            }
            if (CollectionUtils.isEmpty((Collection)officeBackupPolicy.getMailExcludedFolders())) {
                officeBackupPolicy.setMailExcludedFolders(new ArrayList());
            }
            officeBackupPolicy.getMailBackupFolders().addAll(inclusionbackupFolders);
            officeBackupPolicy.getMailExcludedFolders().addAll(exclusionbackupFolders);
        }
        if (officeBackupPolicyFromLocal == null) {
            logger.debug(user.getUserName() + "..... policy local .... null..");
        }
        logger.debug(user.getUserName() + "...officeBackupPolicyFromLocal...");
        OfficeBackupPolicy officeBackupPolicyFromLoc = officeBackupPolicyFromLocal;
        try {
            if (officeBackupPolicyFromLocal == null || officeBackupPolicy.getLastModifiedTimestamp() != officeBackupPolicyFromLocal.getLastModifiedTimestamp()) {
                if (officeBackupPolicyFromLocal == null) {
                    officeBackupPolicyFromLoc = officeBackupPolicy;
                } else {
                    isPolicyModified = true;
                }
                this.msService.saveOfficeBackupPolicy(cloud.getCloudId(), officeBackupPolicy);
            }
        }
        catch (Exception e) {
            logger.error("...error trying to save local policy");
        }
        try {
            logger.debug(user.getUserName() + "users list1......................................." + user);
            logger.debug(user.isExchangeBkpEnabled() + "users list1......................................." + user.isActive());
            if (user != null && user.isActive() && user.isExchangeBkpEnabled()) {
                logger.error(user.getUserName() + " %%%%%%% mail process started for user ...");
                this.processUser(user, cloud, officeBackupPolicy, officeBackupPolicyFromLoc, isPolicyModified, batchStartTime);
                logger.error(user.getUserName() + " %%%%%%% mail process ended for user ...");
            }
            logger.debug("Thread ready for next user11 .... ");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(user.getUserName() + "exception inside MailAutoScheduleJob .... " + e.getMessage());
            logger.trace("exception inside MailAutoScheduleJob ...." + e);
        }
        this.msService.deleteUserAfterBackup(usersWOBackup);
    }

    public void processUser(User user, Cloud cloud, OfficeBackupPolicy oneDriveBackupPolicy, OfficeBackupPolicy oneDriveBackupPolicyFromLocal, boolean isPolicyModified, long batchStartTime) {
        try {
            String gateway;
            Object gateway22;
            String userName = user.getUserName();
            logger.debug("Processing " + userName);
            Device device = this.msService.getMailDeviceForUserName(cloud.getCloudId(), userName);
            if (device == null) {
                logger.debug("... no onedrive device for user... " + userName);
                return;
            }
            if (device.isBlocked() || device.isDeleted()) {
                logger.debug("... device blocked for user... " + userName);
                return;
            }
            ArrayList list = oneDriveBackupPolicy.getMailPrivacyGateways();
            HashSet<String> gateWays = new HashSet<String>();
            for (Object gateway22 : list) {
                gateWays.add(gateway22.getGatewayName());
            }
            boolean isBlukryptRunning = false;
            gateway22 = gateWays.iterator();
            while (gateway22.hasNext() && (StringUtils.isEmpty((String)(gateway = (String)gateway22.next())) || !(isBlukryptRunning = this.isBluKryptRunning(gateway)))) {
            }
            if (!isBlukryptRunning) {
                logger.debug("... blukrypt is not running .... ");
                return;
            }
            if (!PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMailMsAppBluKrypt())) {
                logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + oneDriveBackupPolicy.getMailMsAppBluKrypt());
                return;
            }
            boolean alreadyBkpStarted = this.isBkpAllowed(cloud, device, userName, oneDriveBackupPolicyFromLocal.getPolicyName());
            if (!alreadyBkpStarted) {
                boolean isFullBkp = this.isFullBkpStarted(cloud, device, userName);
                ObjectId eventHubId = this.updateEventHub(cloud, device);
                this.msService.processDeltaChangesForUserMail(user, cloud, oneDriveBackupPolicy, oneDriveBackupPolicyFromLocal, isPolicyModified, isFullBkp, eventHubId.toString(), batchStartTime);
                this.msService.updateEventHubOdStatus(cloud.getCloudId(), eventHubId);
            } else {
                logger.debug("... backup already forced....");
            }
            logger.debug(" processed user .............. " + userName);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace("" + e);
            logger.error("Exception inside MailAutoScheduleJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    private boolean isFullBkpStarted(Cloud cloud, Device device, String userName) {
        boolean fullBkpStarted = false;
        List<EventHub> list = this.msService.getEventHubForDeviceUUID(cloud.getCloudId(), device.getDeviceUUID());
        if (!CollectionUtils.isEmpty(list)) {
            for (EventHub eventHub : list) {
                if (eventHub == null || !"FULL_BACKUP".equalsIgnoreCase(eventHub.getAction())) continue;
                fullBkpStarted = true;
                break;
            }
        }
        return fullBkpStarted;
    }

    private boolean isBkpAllowed(Cloud cloud, Device device, String userName, String policyName) {
        List<ODBBackupBatch> batchlist;
        List<EventHub> list;
        boolean alreadyBkpStarted = false;
        DeviceBackupOverView deviceBackupOverView = this.msService.getDeviceBackupOverViewForDevice(cloud.getCloudId(), device.getDeviceUUID());
        logger.debug("....user backupallaowed..." + deviceBackupOverView);
        if (deviceBackupOverView != null) {
            logger.debug(userName + "....user backupallaowed..." + deviceBackupOverView.getLastBkpStatus() + "..." + deviceBackupOverView.getReason());
            if ("INTERRUPTED".equals(deviceBackupOverView.getLastBkpStatus()) && "1996".equals(deviceBackupOverView.getReason())) {
                logger.error(".....overload limit reached and deferred so wait..");
                return true;
            }
        }
        if (!CollectionUtils.isEmpty(list = this.msService.getEventHubForDeviceUUID(cloud.getCloudId(), device.getDeviceUUID()))) {
            for (EventHub eventHub : list) {
                if (eventHub == null || !"START_BACKUP".equalsIgnoreCase(eventHub.getAction()) && !"FULL_BACKUP".equalsIgnoreCase(eventHub.getAction())) continue;
                logger.debug(".....isBkpAllowed....true");
                return true;
            }
        }
        if (!CollectionUtils.isEmpty(batchlist = this.msService.getCurrentBatch(policyName, userName, device.getDeviceUUID()))) {
            logger.debug("... already batchlist is not empty  .... " + userName);
            logger.debug(".....isBkpAllowed..batchlist...true");
            return true;
        }
        return alreadyBkpStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBluKryptRunning(String blukryptName) {
        boolean isBlukryptRunning = false;
        String url = "https://" + blukryptName + "/BluKryptBuilder/ping/";
        HttpGet httpGet = null;
        HttpClient httpclient = null;
        HttpResponse result = null;
        try {
            httpGet = new HttpGet(url);
            httpclient = HttpClientUtil.getSSlConnection();
            result = httpclient.execute((HttpUriRequest)httpGet);
            int responseCode = result.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                isBlukryptRunning = true;
            }
            logger.debug(responseCode + "..." + isBlukryptRunning + "... ableto reach blukrypt ..... " + url);
        }
        catch (Exception e1) {
            logger.debug(e1.getMessage() + "...... unableto reach blukrypt ..... " + url);
        }
        finally {
            httpGet.releaseConnection();
        }
        return isBlukryptRunning;
    }

    private synchronized OfficeBackupPolicy getPolicyForProcessing(int cloudId) {
        if (CollectionUtils.isEmpty(officeBackupPolicyList) && CollectionUtils.isEmpty(officeBackupPolicyList = this.getPolicyListForProcessing(cloudId))) {
            try {
                logger.debug("...no policy to process... ");
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        logger.debug("....policy list .... " + officeBackupPolicyList.size());
        OfficeBackupPolicy oneDriveBackupPolicy = null;
        if (!CollectionUtils.isEmpty(officeBackupPolicyList)) {
            oneDriveBackupPolicy = officeBackupPolicyList.get(0);
        }
        if (oneDriveBackupPolicy != null) {
            if (this.policyUnderProcess.contains(oneDriveBackupPolicy.getPolicyName())) {
                officeBackupPolicyList.remove(oneDriveBackupPolicy);
            } else {
                this.policyUnderProcess.add(oneDriveBackupPolicy.getPolicyName());
                officeBackupPolicyList.remove(oneDriveBackupPolicy);
            }
        }
        if (oneDriveBackupPolicy == null) {
            try {
                logger.debug("... wait for next policy... ");
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.debug("...after list size....." + officeBackupPolicyList.size());
        return oneDriveBackupPolicy;
    }

    private long getNextScheduledMinute(OfficeBackupPolicy oneDriveBackupPolicy) {
        long nextScheduleMinute;
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "inside NEXT SCHEDULE TIME IN MINUTES:");
        List<ScheduleTO> list = MailAutoScheduleJob.getSchedulesList(oneDriveBackupPolicy.getMailSchedules());
        if (list == null || list.isEmpty()) {
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "..Schedule List is null or empty after retry so set default 12 mins");
            return 12L;
        }
        TreeSet<Date> dates = new TreeSet<Date>();
        MailAutoScheduleJob.getAppropriateDatesForSchedules(list, dates, 0);
        Date highestDateUpUntilNow = dates.higher(Calendar.getInstance().getTime());
        TreeSet<Date> datesToCheckPreviousSchedule = new TreeSet<Date>();
        MailAutoScheduleJob.getAppropriateDatesForSchedules(list, datesToCheckPreviousSchedule, 1);
        Date currentDate = Calendar.getInstance().getTime();
        currentDate.setSeconds(0);
        Date nextScheduleDate = highestDateUpUntilNow == null ? Collections.min(dates) : highestDateUpUntilNow;
        Calendar currentTime = Calendar.getInstance();
        currentTime.set(13, 0);
        long timeDiff = nextScheduleDate.getTime() - currentTime.getTime().getTime();
        logger.debug(oneDriveBackupPolicy.getPolicyName() + ".." + currentTime.getTime().getTime() + "...currenttime and scheduel time.." + nextScheduleDate.getTime() + "..diff..." + timeDiff);
        if (timeDiff <= 0L) {
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "...timeDiff <= 0.." + timeDiff);
            nextScheduleMinute = 1440L - TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff));
        } else {
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "...timeDiff > 0.." + timeDiff);
            nextScheduleMinute = TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff));
        }
        if (nextScheduleMinute == 0L) {
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "Next schedule minute is zero");
            nextScheduleMinute = this.getNextScheduledMinute(oneDriveBackupPolicy);
        }
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "..NEXT SCHEDULE TIME IN MINUTES:" + nextScheduleMinute);
        return nextScheduleMinute;
    }

    public static int[] toIntArray1(String input) {
        String beforeSplit = input.replaceAll("\\[|\\]|\\s", "");
        String[] split = beforeSplit.split("\\,");
        int[] result = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            result[i] = Integer.parseInt(split[i]);
        }
        return result;
    }

    private static List<ScheduleTO> getSchedulesList(List<Schedule> schedulesList) {
        ArrayList<ScheduleTO> list = new ArrayList<ScheduleTO>();
        if (!CollectionUtils.isEmpty(schedulesList)) {
            for (Schedule schedule : schedulesList) {
                ScheduleTO tempFile = new ScheduleTO();
                tempFile.setScheduleName(schedule.getScheduleName());
                tempFile.setStartTime(schedule.getTime());
                tempFile.setDayArray(schedule.getDayArray());
                tempFile.setBackupType(schedule.getBackupType());
                tempFile.setContainerName("");
                list.add(tempFile);
            }
        }
        return list;
    }

    private static void getAppropriateDatesForSchedules(List<ScheduleTO> list, NavigableSet<Date> dates, int checkPrevSchedule) {
        for (ScheduleTO scheduleTO : list) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            try {
                Date date1 = sdf.parse(scheduleTO.getStartTime());
                Calendar calendar = Calendar.getInstance();
                int dayOfWeek = calendar.get(7);
                if (CollectionUtils.isEmpty(scheduleTO.getDayArray())) continue;
                for (Integer i : scheduleTO.getDayArray()) {
                    Calendar calendar1 = Calendar.getInstance();
                    int currentSeconds = Calendar.getInstance().getTime().getSeconds();
                    if (i > dayOfWeek) {
                        if (checkPrevSchedule == 0) {
                            calendar1.add(5, i - dayOfWeek);
                            calendar1.set(11, date1.getHours());
                            calendar1.set(12, date1.getMinutes());
                            calendar1.set(13, date1.getSeconds());
                            dates.add(calendar1.getTime());
                            continue;
                        }
                        if (checkPrevSchedule != 1) continue;
                        calendar1.add(5, i - dayOfWeek - 7);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        calendar1.set(13, date1.getSeconds());
                        dates.add(calendar1.getTime());
                        continue;
                    }
                    if (i < dayOfWeek) {
                        if (checkPrevSchedule == 0) {
                            calendar1.add(5, 7 - (dayOfWeek - i));
                            calendar1.set(11, date1.getHours());
                            calendar1.set(12, date1.getMinutes());
                            calendar1.set(13, date1.getSeconds());
                            dates.add(calendar1.getTime());
                            continue;
                        }
                        if (checkPrevSchedule != 1) continue;
                        calendar1.add(5, i - dayOfWeek);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        calendar1.set(13, date1.getSeconds());
                        dates.add(calendar1.getTime());
                        continue;
                    }
                    if (i != dayOfWeek) continue;
                    calendar1.set(11, date1.getHours());
                    calendar1.set(12, date1.getMinutes());
                    calendar1.set(13, currentSeconds);
                    if (checkPrevSchedule == 0 && Calendar.getInstance().getTime().getTime() > calendar1.getTime().getTime()) {
                        calendar1.add(5, 7);
                    } else if (checkPrevSchedule == 1 && Calendar.getInstance().getTime().getTime() < calendar1.getTime().getTime()) {
                        calendar1.add(5, -7);
                    }
                    dates.add(calendar1.getTime());
                }
            }
            catch (ParseException e) {
                logger.trace("" + e);
                logger.error("Exception getting schedules " + e.getMessage());
            }
        }
    }

    public ObjectId updateEventHub(Cloud cloud, Device device) {
        logger.debug("calling updateEventHub ....");
        ObjectId eventHubId = null;
        try {
            int cloudId = cloud.getCloudId();
            String deviceUUID = device.getDeviceUUID();
            String userName = device.getUserName();
            String actionByUserName = "Schedule";
            String acctionToUserName = userName;
            logger.debug("... creating event hub....");
            EventHub eventHub = new EventHub();
            eventHub.setActionBy(actionByUserName);
            eventHub.setActionStatus(PCHelperConstant.EVENTHUB_ACTION_STATUS.CREATED.toString());
            eventHub.setActionToUserName(acctionToUserName);
            eventHub.setActionToDeviceUUID(deviceUUID);
            eventHub.setOdStatus(EventHub.ODSTATUS.STARTED.toString());
            String action = PCHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString();
            eventHub.setAction(action);
            eventHubId = this.msService.saveEventHubAction(cloudId, eventHub);
        }
        catch (Exception e) {
            logger.error("... exception trying to save eventhub ..." + e.getMessage());
        }
        return eventHubId;
    }
}

