/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDefinedFolders;
import com.pg.graph.helper.ScheduleTO;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.service.MSService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class MSDownloadJob
extends QuartzJobBean
implements Job {
    private MSService msService;
    private Set<String> userUnderProcess = new HashSet<String>();
    private Set<String> policyUnderProcess = new HashSet<String>();
    private static Logger logger = LogManager.getLogger(MSDownloadJob.class);
    private static List<OfficeBackupPolicy> officeBackupPolicyList = null;
    private TimerTask userTimerTask = null;
    private Timer userTimer = null;
    private TimerTask policyTimerTask = null;
    private Timer policyTimer = null;
    CompletionService<String> userPool = null;
    private Timer userBackupTimer = null;
    private TimerTask userBackupTimerTask = null;

    public void setMsService(MSService msService) {
        this.msService = msService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        logger.debug("....msDownload job started...");
        ExecutorService executor = null;
        try {
            int cloudId = 1;
            Cloud cloud = this.msService.getCloud(cloudId);
            boolean isOneDriveForBusinessBackupEnabled = this.isOneDriveForBusinessBackupEnabled(cloud);
            if (isOneDriveForBusinessBackupEnabled) {
                boolean licenseActive;
                long threadSize;
                if (cloud != null) {
                    logger.debug("......cloud val...." + cloud.getCloudName());
                }
                if ((threadSize = this.msService.getThreadSize(cloud.getCloudId(), cloud.getCloudName())) == 0L) {
                    threadSize = PCHelperConstant.getThreadLimit();
                }
                if (!(licenseActive = this.vaildatedLicensceStatus(cloud))) {
                    logger.debug("....license inactive no crawl....");
                    Thread.sleep(1200000L);
                    return;
                }
                List<OfficeBackupPolicy> policyList = this.msService.getAllOfficeBackupPolicies(cloudId);
                if (!CollectionUtils.isEmpty(policyList)) {
                    threadSize = policyList.size();
                }
                logger.debug(" threads val........" + threadSize);
                int threadSizeVal = (int)threadSize;
                executor = Executors.newFixedThreadPool(threadSizeVal);
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                ExecutorService userExecutor = Executors.newCachedThreadPool();
                this.userPool = new ExecutorCompletionService<String>(userExecutor);
                officeBackupPolicyList = new ArrayList<OfficeBackupPolicy>();
                logger.debug("... get officeBackupPolicyList list ... " + officeBackupPolicyList.size());
                this.checkThreadStatusAndStartScheduleForPolicy(cloud, executor, pool);
                for (int i = 0; i < threadSizeVal; ++i) {
                    logger.debug("Creating thread for first time policy >>>>>>>>> i value::" + i);
                    this.initiatePolicySchedules(cloud, executor, pool, true);
                }
            } else {
                logger.debug("...odb not enabled.... so sleep for 20 mins...");
                Thread.sleep(1200000L);
            }
            logger.debug(" exit upload part.........." + isOneDriveForBusinessBackupEnabled);
        }
        catch (Exception e) {
            logger.error(" exception in backup upload job......." + e.getMessage());
            logger.trace("exception in backup upload job ......." + e);
        }
        logger.debug("....msDownload job ended...");
    }

    private boolean vaildatedLicensceStatus(Cloud cloud) {
        return cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE");
    }

    private boolean isOneDriveForBusinessBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void initiatePolicySchedules(Cloud cloud, ExecutorService executor, CompletionService<String> pool, boolean firstTime) {
        logger.debug("starting policy schedules ............... :");
        Runnable schedulePolicyJob = () -> this.schdeuleUsersForPolicy(cloud, executor, pool, firstTime);
        pool.submit(schedulePolicyJob, "");
    }

    private void checkThreadStatusAndStartScheduleForPolicy(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.policyTimer == null) {
            this.policyTimer = new Timer();
        }
        if (this.policyTimerTask == null) {
            this.policyTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed schedule policy >>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed for schedule policy so assign new task with future>>>>>>>>>>>" + (String)future.get());
                            MSDownloadJob.this.initiatePolicySchedules(cloud, executor, pool, false);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartScheduleForPolicy", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            logger.debug(".......inside checkThreadStatusAndStartScheduleForPolicy....  ");
            this.policyTimer.schedule(this.policyTimerTask, 100L, 1000L);
        }
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final CompletionService<String> pool, final List<User> usersList) {
        if (this.userTimer == null) {
            this.userTimer = new Timer();
        }
        if (this.userTimerTask == null) {
            this.userTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            MSDownloadJob.this.initiateMSDeltaQueries(cloud, pool, usersList);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.userTimer.schedule(this.userTimerTask, 1000L, 1000L);
        }
    }

    private void initiateMSDeltaQueries(Cloud cloud, CompletionService<String> pool, List<User> usersList) {
        logger.debug("Files to backup latest............... :");
        Runnable uploadJob = () -> this.uploadFiles(cloud, pool, usersList);
        pool.submit(uploadJob, "");
    }

    private void schdeuleUsersForPolicy(Cloud cloud, ExecutorService executor, CompletionService<String> pool, boolean firstTime) {
        block8: {
            try {
                OfficeBackupPolicy oneDriveBackupPolicy = this.getPolicyForProcessing(cloud.getCloudId(), "onedrive");
                logger.debug("... entering scheduleusersforpolicy... " + oneDriveBackupPolicy);
                if (oneDriveBackupPolicy != null) {
                    logger.debug(this.policyUnderProcess.contains(oneDriveBackupPolicy.getPolicyName()) + "... entering scheduleusersforpolicy... " + oneDriveBackupPolicy);
                    if (MemoryStore.get((String)("OD_SCH_" + oneDriveBackupPolicy.getPolicyName())) != null) break block8;
                    boolean isBackupAllowed = this.isBackupAllowed(oneDriveBackupPolicy, firstTime);
                    logger.debug(oneDriveBackupPolicy.getPolicyName() + "... is Backup allowed.... " + isBackupAllowed);
                    if (!isBackupAllowed) break block8;
                    logger.debug("....inside schdeuleUsersForPolicy.........." + oneDriveBackupPolicy.getPolicyName());
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    List<User> allUsersForOfficeBackupPolicy = this.msService.getAllUsersForOfficeBackupPolicy(cloud.getCloudId(), oneDriveBackupPolicy.getPolicyName());
                    ArrayList<User> users = new ArrayList<User>();
                    for (User user : allUsersForOfficeBackupPolicy) {
                        if (!user.isOnedriveBkpEnabled()) continue;
                        users.add(user);
                    }
                    if (CollectionUtils.isEmpty(users)) {
                        logger.debug("... no users available for policy.... " + oneDriveBackupPolicy.getPolicyName());
                        this.policyUnderProcess.remove(oneDriveBackupPolicy.getPolicyName());
                    } else {
                        logger.debug("... get users list ... " + users.size());
                        logger.debug("Creating thread for users for policy name ::" + oneDriveBackupPolicy.getPolicyName());
                        MemoryStore.delete((String)("OD_SCH_" + oneDriveBackupPolicy.getPolicyName()));
                        this.initiateMSDeltaQueries(cloud, this.userPool, users);
                    }
                    logger.debug("Thread ready for next File11 .... " + officeBackupPolicyList.size());
                    break block8;
                }
                logger.error(".. no policy for ");
            }
            catch (Exception e) {
                logger.error("exception inside BackupUploadJob .... " + e.getMessage());
                logger.trace("exception inside BackupUploadJob ...." + e);
            }
        }
        logger.error("completed users for schedule wait for next retry>>>>");
    }

    private boolean isBackupAllowed(OfficeBackupPolicy oneDriveBackupPolicy, boolean firstTime) {
        boolean isBackupAllowed = false;
        long nextSchedule = MSDownloadJob.getNextScheduledMinute(oneDriveBackupPolicy);
        String policyName = oneDriveBackupPolicy.getPolicyName();
        if (!firstTime && nextSchedule <= 2L) {
            try {
                logger.debug(oneDriveBackupPolicy.getPolicyName() + "....wait for mins..." + nextSchedule);
                Thread.sleep(nextSchedule * 60000L);
                nextSchedule = 1L;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (nextSchedule == 1L) {
            logger.debug("... wait for backup schedule to start in 1 min for policy ..." + policyName);
            if (MemoryStore.get((String)("OD_SCH_" + policyName)) == null) {
                logger.debug("... enable backup for policy ... " + policyName);
                MemoryStore.add((String)("OD_SCH_" + policyName), (Object)90000);
                isBackupAllowed = true;
            } else {
                logger.debug("... already backup enable for policy ... " + policyName);
                isBackupAllowed = false;
            }
        }
        return isBackupAllowed;
    }

    private List<OfficeBackupPolicy> getPolicyListForProcessing(int cloudId, String productType) {
        List<OfficeBackupPolicy> policyList = this.msService.getAllOfficeBackupPolicies(cloudId, productType);
        for (OfficeBackupPolicy policy : policyList) {
            officeBackupPolicyList.add(policy);
        }
        return officeBackupPolicyList;
    }

    public void checkThreadStatusAndStartUploadForUser(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool, final ListIterator<User> iterator, final long batchStartTime) {
        if (this.userBackupTimer == null) {
            this.userBackupTimer = new Timer();
        }
        if (this.userBackupTimerTask == null) {
            this.userBackupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.debug("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            if (iterator.hasNext()) {
                                MSDownloadJob.this.processUserFiles(cloud, executor, pool, iterator, batchStartTime);
                            } else {
                                executor.shutdown();
                                MSDownloadJob.this.userBackupTimer.cancel();
                                MSDownloadJob.this.userBackupTimerTask.cancel();
                                MSDownloadJob.this.userBackupTimer = null;
                                MSDownloadJob.this.userBackupTimerTask = null;
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.debug("Error in checkThreadStatusAndStartUpload" + e);
                        logger.debug("" + e);
                    }
                }
            };
            if (this.userBackupTimer != null && this.userBackupTimerTask != null) {
                this.userBackupTimer.schedule(this.userBackupTimerTask, 1000L, 1000L);
            }
        }
    }

    private void processUserFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool, ListIterator<User> iterator, long batchStartTime) {
        logger.debug("......processUserFiles......... :");
        Runnable uploadJob = () -> this.processUser(cloud, executor, pool, iterator, batchStartTime);
        pool.submit(uploadJob, "");
    }

    private void processUser(Cloud cloud, ExecutorService executor, CompletionService<String> pool, ListIterator<User> iterator, long batchStartTime) {
        if (iterator.hasNext()) {
            User user = iterator.next();
            logger.debug(user.getOdbPolicyName() + "...process started user...." + user.getUserName());
            this.uploadUserFiles(cloud, user, batchStartTime);
            logger.debug(user.getOdbPolicyName() + "...process ended user...." + user.getUserName());
        } else {
            executor.shutdown();
            logger.debug(".....shutdown....");
        }
    }

    private void uploadFiles(Cloud cloud, CompletionService<String> pool1, List<User> usersList) {
        logger.debug("..start of upload files...");
        User getUser = usersList.get(0);
        logger.debug("...userpolicy...." + getUser.getOdbPolicyName());
        OfficeBackupPolicy officeBackupPolicy = this.msService.getOfficeBackupPolicyForUserName(cloud.getCloudId(), getUser.getUserName());
        logger.debug(officeBackupPolicy + "...userpolicy1...." + getUser.getOdbPolicyName());
        OfficeBackupPolicy officeBackupPolicyFromLocal = this.msService.getOfficeBackupPolicyFromLocal(cloud.getCloudId(), officeBackupPolicy.getPolicyName());
        logger.debug("...userpolicy2...." + getUser.getOdbPolicyName());
        long batchStartTime = System.currentTimeMillis();
        usersList = this.msService.getAllUsersForOfficeBackupPolicy(cloud.getCloudId(), officeBackupPolicy.getPolicyName());
        ArrayList<User> userInfoListlocal = new ArrayList<User>();
        userInfoListlocal.addAll(usersList);
        logger.debug("....policy and users..." + officeBackupPolicy.getPolicyName() + "..." + userInfoListlocal.size());
        int officeThreads = 50;
        if (PCHelperConstant.getCrawlThreadsLimit() > 0) {
            officeThreads = PCHelperConstant.getCrawlThreadsLimit();
        }
        logger.debug("......office crawlThreads1....." + officeThreads);
        ExecutorService executor = Executors.newFixedThreadPool(officeThreads);
        ListIterator<User> iterator = usersList.listIterator();
        ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
        this.checkThreadStatusAndStartUploadForUser(cloud, executor, pool, iterator, batchStartTime);
        for (int i = 0; i < officeThreads; ++i) {
            logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
            this.processUserFiles(cloud, executor, pool, iterator, batchStartTime);
        }
        try {
            logger.debug("...wait to start next process... ");
            Thread.sleep(50000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MemoryStore.delete((String)("OD_SCH_" + officeBackupPolicy.getPolicyName()));
        logger.debug(".... completed usersList....................");
    }

    private void uploadUserFiles(Cloud cloud, User user, long batchStartTime) {
        ArrayList<String> excludedFoldStr;
        ArrayList<String> backupFoldLocalStr;
        ArrayList<String> backupFoldStr;
        ArrayList excludedFoldersLocal;
        ArrayList excludedFolders;
        ArrayList backupFoldersLocal;
        ArrayList backupFolders;
        OfficeBackupPolicy officeBackupPolicy = null;
        logger.debug("....inside for loopslatest.........." + user.getUserName());
        boolean isPolicyModified = false;
        String userName = user.getUserName();
        Device device = this.msService.getODDeviceForUserName(cloud.getCloudId(), userName);
        if (device == null) {
            logger.debug("...device does not exist for user ... " + userName);
            return;
        }
        RestoreEvents restoreEvents = this.msService.getRestoreEventsByUUID(cloud.getCloudId(), device.getDeviceUUID());
        if (restoreEvents != null && restoreEvents.isSuspendBackup()) {
            logger.error(".....restore is running so backup cannot continue...  ");
            return;
        }
        int cloudId = cloud.getCloudId();
        if (officeBackupPolicy == null) {
            officeBackupPolicy = this.msService.getOfficeBackupPolicyForUserName(cloud.getCloudId(), user.getUserName());
        }
        OfficeBackupPolicy officeBackupPolicyFromLocal = this.msService.getOfficeBackupPolicyFromLocal(cloud.getCloudId(), officeBackupPolicy.getPolicyName());
        logger.debug(userName + "... policy..local.. " + officeBackupPolicyFromLocal);
        if (device != null) {
            ArrayList<Object> inclusionbackupFolders = new ArrayList<Object>();
            List<UserDefinedFolders> userDefinedFoldersList = this.msService.getAllUserDefinedInclusionFolders(cloudId, device.getDeviceUUID(), userName);
            if (!CollectionUtils.isEmpty(userDefinedFoldersList)) {
                for (UserDefinedFolders userDefinedFolders : userDefinedFoldersList) {
                    BackupFolders backupFolderElement = new BackupFolders();
                    backupFolderElement.setId(userDefinedFolders.getId());
                    backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                    inclusionbackupFolders.add(backupFolderElement);
                }
            }
            ArrayList<ExcludedFolders> exclusionbackupFolders = new ArrayList<ExcludedFolders>();
            List<UserDefinedFolders> exclusionuserDefinedFoldersList = this.msService.getAllUserDefinedExclusionFolders(cloudId, device.getDeviceUUID(), userName);
            if (!CollectionUtils.isEmpty(exclusionuserDefinedFoldersList)) {
                for (UserDefinedFolders userDefinedFolders : exclusionuserDefinedFoldersList) {
                    ExcludedFolders backupFolderElement = new ExcludedFolders();
                    backupFolderElement.setId(userDefinedFolders.getId());
                    backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                    exclusionbackupFolders.add(backupFolderElement);
                }
            }
            if (CollectionUtils.isEmpty((Collection)officeBackupPolicy.getOdBackupFolders())) {
                officeBackupPolicy.setOdBackupFolders(new ArrayList());
            }
            if (CollectionUtils.isEmpty((Collection)officeBackupPolicy.getOdExcludedFolders())) {
                officeBackupPolicy.setOdExcludedFolders(new ArrayList());
            }
            officeBackupPolicy.getOdBackupFolders().addAll(inclusionbackupFolders);
            officeBackupPolicy.getOdExcludedFolders().addAll(exclusionbackupFolders);
        }
        if (officeBackupPolicyFromLocal == null) {
            logger.debug("..... policy local .... null..");
        }
        if (officeBackupPolicyFromLocal == null || officeBackupPolicy.getLastModifiedTimestamp() != officeBackupPolicyFromLocal.getLastModifiedTimestamp()) {
            if (officeBackupPolicyFromLocal == null) {
                officeBackupPolicyFromLocal = officeBackupPolicy;
            } else {
                boolean allElementsPresent;
                isPolicyModified = false;
                backupFolders = officeBackupPolicy.getOdBackupFolders();
                backupFoldersLocal = officeBackupPolicyFromLocal.getOdBackupFolders();
                if (CollectionUtils.isEmpty((Collection)backupFolders)) {
                    backupFolders = new ArrayList();
                }
                if (CollectionUtils.isEmpty((Collection)backupFoldersLocal)) {
                    backupFoldersLocal = new ArrayList();
                }
                excludedFolders = officeBackupPolicy.getOdExcludedFolders();
                excludedFoldersLocal = officeBackupPolicyFromLocal.getOdExcludedFolders();
                if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
                    excludedFolders = new ArrayList();
                }
                if (CollectionUtils.isEmpty((Collection)excludedFoldersLocal)) {
                    excludedFoldersLocal = new ArrayList();
                }
                backupFoldStr = new ArrayList<String>();
                backupFoldLocalStr = new ArrayList<String>();
                excludedFoldStr = new ArrayList<String>();
                ArrayList<String> excludedFoldLocalStr = new ArrayList<String>();
                for (BackupFolders folders : backupFolders) {
                    backupFoldStr.add(folders.getFolderPath());
                }
                for (BackupFolders folders : backupFoldersLocal) {
                    backupFoldLocalStr.add(folders.getFolderPath());
                }
                for (BackupFolders folders : excludedFolders) {
                    excludedFoldStr.add(folders.getFolderPath());
                }
                for (BackupFolders folders : excludedFoldersLocal) {
                    excludedFoldLocalStr.add(folders.getFolderPath());
                }
                logger.debug("....folllsss........." + backupFoldStr.size() + ".." + backupFoldLocalStr.size() + "...exc.." + excludedFoldStr.size() + "..." + excludedFoldLocalStr.size());
                boolean bl = allElementsPresent = backupFoldStr.equals(backupFoldLocalStr) && excludedFoldStr.equals(excludedFoldLocalStr);
                if (!allElementsPresent) {
                    isPolicyModified = true;
                }
            }
            this.msService.saveOfficeBackupPolicy(cloud.getCloudId(), officeBackupPolicy);
        } else {
            boolean allElementsPresent;
            backupFolders = officeBackupPolicy.getOdBackupFolders();
            backupFoldersLocal = officeBackupPolicyFromLocal.getOdBackupFolders();
            if (CollectionUtils.isEmpty((Collection)backupFolders)) {
                backupFolders = new ArrayList();
            }
            if (CollectionUtils.isEmpty((Collection)backupFoldersLocal)) {
                backupFoldersLocal = new ArrayList();
            }
            excludedFolders = officeBackupPolicy.getOdExcludedFolders();
            excludedFoldersLocal = officeBackupPolicyFromLocal.getOdExcludedFolders();
            if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
                excludedFolders = new ArrayList();
            }
            if (CollectionUtils.isEmpty((Collection)excludedFoldersLocal)) {
                excludedFoldersLocal = new ArrayList();
            }
            backupFoldStr = new ArrayList();
            backupFoldLocalStr = new ArrayList();
            excludedFoldStr = new ArrayList();
            ArrayList<String> excludedFoldLocalStr = new ArrayList<String>();
            for (BackupFolders folders : backupFolders) {
                backupFoldStr.add(folders.getFolderPath());
            }
            for (BackupFolders folders : backupFoldersLocal) {
                backupFoldLocalStr.add(folders.getFolderPath());
            }
            for (BackupFolders folders : excludedFolders) {
                excludedFoldStr.add(folders.getFolderPath());
            }
            for (BackupFolders folders : excludedFoldersLocal) {
                excludedFoldLocalStr.add(folders.getFolderPath());
            }
            logger.debug("....folllsss........." + backupFoldStr.size() + ".." + backupFoldLocalStr.size() + "...exc.." + excludedFoldStr.size() + "..." + excludedFoldLocalStr.size());
            boolean bl = allElementsPresent = backupFoldStr.equals(backupFoldLocalStr) && excludedFoldStr.equals(excludedFoldLocalStr);
            if (!allElementsPresent) {
                isPolicyModified = true;
            }
        }
        try {
            if (user != null && user.isActive() && user.isOnedriveBkpEnabled()) {
                logger.debug(user.getUserName() + " %%%%%%% process started for user ...");
                this.processUser(user, cloud, officeBackupPolicy, officeBackupPolicyFromLocal, isPolicyModified, batchStartTime);
                logger.debug(user.getUserName() + " %%%%%%% process ended for user ...");
                this.userUnderProcess.remove(user.getUserName());
            }
            logger.debug(user.getUserName() + "Thread ready for next user .... " + this.userUnderProcess.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("exception inside BackupUploadJob .... " + e.getMessage());
            logger.trace("exception inside BackupUploadJob ...." + e);
        }
    }

    private static String getDateInFormat(Long deviceCreatedDate) {
        String dateStringFormat = "";
        if (deviceCreatedDate == null || deviceCreatedDate == 0L) {
            return dateStringFormat;
        }
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            Date dateD = new Date(deviceCreatedDate);
            dateStringFormat = df2.format(dateD);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateStringFormat;
    }

    public void processUser(User user, Cloud cloud, OfficeBackupPolicy oneDriveBackupPolicy, OfficeBackupPolicy oneDriveBackupPolicyFromLocal, boolean isPolicyModified, long batchStartTime) {
        try {
            String userName = user.getUserName();
            logger.debug("Processing " + userName);
            Device device = this.msService.getODDeviceForUserName(cloud.getCloudId(), userName);
            if (device == null) {
                logger.debug("... no onedrive device for user... " + userName);
                return;
            }
            if (device.isBlocked() || device.isDeleted()) {
                logger.debug("... device blocked for user... " + userName);
                return;
            }
            if (!PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getOdMsAppBluKrypt())) {
                logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + oneDriveBackupPolicy.getOdMsAppBluKrypt());
                return;
            }
            boolean alreadyBkpStarted = this.isBkpAllowed(cloud, device, userName, oneDriveBackupPolicyFromLocal.getPolicyName());
            logger.debug(userName + "....ready for backup ..." + alreadyBkpStarted + "...starttime..." + batchStartTime + "..dateinformat..." + MSDownloadJob.getDateInFormat(batchStartTime));
            if (!alreadyBkpStarted) {
                ObjectId eventHubId = this.updateEventHub(cloud, device);
                this.msService.processDeltaChangesForUserDrive(user, cloud, oneDriveBackupPolicy, oneDriveBackupPolicyFromLocal, isPolicyModified, eventHubId.toString(), batchStartTime);
                this.msService.updateEventHubOdStatus(cloud.getCloudId(), eventHubId);
            } else {
                logger.debug("... backup already forced....");
            }
            logger.debug(" processed user .............. " + userName);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside BackupUploadJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    private boolean isBkpAllowed(Cloud cloud, Device device, String userName, String policyName) {
        List<ODBBackupBatch> batchlist;
        boolean alreadyBkpStarted = false;
        DeviceBackupOverView deviceBackupOverView = this.msService.getDeviceBackupOverViewForDevice(cloud.getCloudId(), device.getDeviceUUID());
        if (deviceBackupOverView != null && "INTERRUPTED".equals(deviceBackupOverView.getLastBkpStatus()) && "1996".equals(deviceBackupOverView.getReason())) {
            logger.error(".....overload limit reached and deferred so wait..");
            return true;
        }
        List<EventHub> list = this.msService.getEventHubForDeviceUUID(cloud.getCloudId(), device.getDeviceUUID());
        if (!CollectionUtils.isEmpty(list)) {
            for (EventHub eventHub : list) {
                if (eventHub == null || !"START_BACKUP".equalsIgnoreCase(eventHub.getAction()) && !"FULL_BACKUP".equalsIgnoreCase(eventHub.getAction())) continue;
                logger.debug("... already eventhub created for users .... " + userName);
                return true;
            }
        }
        if (!CollectionUtils.isEmpty(batchlist = this.msService.getCurrentBatch(policyName, userName, device.getDeviceUUID()))) {
            logger.debug("... already batchlist is not empty  .... " + userName);
            return true;
        }
        return alreadyBkpStarted;
    }

    private synchronized OfficeBackupPolicy getPolicyForProcessing(int cloudId, String productType) {
        if (CollectionUtils.isEmpty(officeBackupPolicyList) && CollectionUtils.isEmpty(officeBackupPolicyList = this.getPolicyListForProcessing(cloudId, productType))) {
            try {
                logger.debug("...no policy to process... ");
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        logger.debug("....policy list .... " + officeBackupPolicyList.size());
        OfficeBackupPolicy oneDriveBackupPolicy = null;
        if (!CollectionUtils.isEmpty(officeBackupPolicyList)) {
            oneDriveBackupPolicy = officeBackupPolicyList.get(0);
        }
        if (oneDriveBackupPolicy != null) {
            if (this.policyUnderProcess.contains(oneDriveBackupPolicy.getPolicyName())) {
                officeBackupPolicyList.remove(oneDriveBackupPolicy);
            } else {
                this.policyUnderProcess.add(oneDriveBackupPolicy.getPolicyName());
                officeBackupPolicyList.remove(oneDriveBackupPolicy);
            }
        }
        if (oneDriveBackupPolicy == null) {
            try {
                logger.debug("... wait for next policy... ");
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.debug("...after list size....." + officeBackupPolicyList.size());
        return oneDriveBackupPolicy;
    }

    private static long getNextScheduledMinute(OfficeBackupPolicy oneDriveBackupPolicy) {
        List<ScheduleTO> list = MSDownloadJob.getSchedulesList(oneDriveBackupPolicy.getOdSchedules());
        if (list == null || list.isEmpty()) {
            logger.debug("Schedule List is null or empty after retry so set default 12 mins");
            return 12L;
        }
        TreeSet<Date> dates = new TreeSet<Date>();
        MSDownloadJob.getAppropriateDatesForSchedules(list, dates, 0);
        Date highestDateUpUntilNow = dates.higher(Calendar.getInstance().getTime());
        TreeSet<Date> datesToCheckPreviousSchedule = new TreeSet<Date>();
        MSDownloadJob.getAppropriateDatesForSchedules(list, datesToCheckPreviousSchedule, 1);
        Date currentDate = Calendar.getInstance().getTime();
        currentDate.setSeconds(0);
        Date nextScheduleDate = highestDateUpUntilNow == null ? Collections.min(dates) : highestDateUpUntilNow;
        logger.debug("Next scheduled Date:" + nextScheduleDate);
        Calendar currentTime = Calendar.getInstance();
        currentTime.set(13, 0);
        long timeDiff = nextScheduleDate.getTime() - currentTime.getTime().getTime();
        long nextScheduleMinute = timeDiff <= 0L ? 1440L - TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff)) : TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff));
        if (nextScheduleMinute == 0L) {
            logger.debug("Next schedule minute is zero");
            nextScheduleMinute = MSDownloadJob.getNextScheduledMinute(oneDriveBackupPolicy);
        }
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "..NEXT SCHEDULE TIME IN MINUTES:" + nextScheduleMinute);
        return nextScheduleMinute;
    }

    public static int[] toIntArray1(String input) {
        String beforeSplit = input.replaceAll("\\[|\\]|\\s", "");
        String[] split = beforeSplit.split("\\,");
        int[] result = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            result[i] = Integer.parseInt(split[i]);
        }
        return result;
    }

    private static List<ScheduleTO> getSchedulesList(List<Schedule> schedulesList) {
        ArrayList<ScheduleTO> list = new ArrayList<ScheduleTO>();
        if (!CollectionUtils.isEmpty(schedulesList)) {
            for (Schedule schedule : schedulesList) {
                ScheduleTO tempFile = new ScheduleTO();
                tempFile.setScheduleName(schedule.getScheduleName());
                tempFile.setStartTime(schedule.getTime());
                tempFile.setDayArray(schedule.getDayArray());
                tempFile.setBackupType(schedule.getBackupType());
                tempFile.setContainerName("");
                list.add(tempFile);
            }
        }
        return list;
    }

    private static void getAppropriateDatesForSchedules(List<ScheduleTO> list, NavigableSet<Date> dates, int checkPrevSchedule) {
        for (ScheduleTO scheduleTO : list) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            try {
                Date date1 = sdf.parse(scheduleTO.getStartTime());
                Calendar calendar = Calendar.getInstance();
                int dayOfWeek = calendar.get(7);
                if (CollectionUtils.isEmpty(scheduleTO.getDayArray())) continue;
                for (Integer i : scheduleTO.getDayArray()) {
                    Calendar calendar1 = Calendar.getInstance();
                    int currentSeconds = Calendar.getInstance().getTime().getSeconds();
                    if (i > dayOfWeek) {
                        if (checkPrevSchedule == 0) {
                            calendar1.add(5, i - dayOfWeek);
                            calendar1.set(11, date1.getHours());
                            calendar1.set(12, date1.getMinutes());
                            calendar1.set(13, date1.getSeconds());
                            dates.add(calendar1.getTime());
                            continue;
                        }
                        if (checkPrevSchedule != 1) continue;
                        calendar1.add(5, i - dayOfWeek - 7);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        calendar1.set(13, date1.getSeconds());
                        dates.add(calendar1.getTime());
                        continue;
                    }
                    if (i < dayOfWeek) {
                        if (checkPrevSchedule == 0) {
                            calendar1.add(5, 7 - (dayOfWeek - i));
                            calendar1.set(11, date1.getHours());
                            calendar1.set(12, date1.getMinutes());
                            calendar1.set(13, date1.getSeconds());
                            dates.add(calendar1.getTime());
                            continue;
                        }
                        if (checkPrevSchedule != 1) continue;
                        calendar1.add(5, i - dayOfWeek);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        calendar1.set(13, date1.getSeconds());
                        dates.add(calendar1.getTime());
                        continue;
                    }
                    if (i != dayOfWeek) continue;
                    calendar1.set(11, date1.getHours());
                    calendar1.set(12, date1.getMinutes());
                    calendar1.set(13, currentSeconds);
                    if (checkPrevSchedule == 0 && Calendar.getInstance().getTime().getTime() > calendar1.getTime().getTime()) {
                        calendar1.add(5, 7);
                    } else if (checkPrevSchedule == 1 && Calendar.getInstance().getTime().getTime() < calendar1.getTime().getTime()) {
                        calendar1.add(5, -7);
                    }
                    dates.add(calendar1.getTime());
                }
            }
            catch (ParseException e) {
                logger.trace("" + e);
                logger.error("Exception getting schedules " + e.getMessage());
            }
        }
    }

    public ObjectId updateEventHub(Cloud cloud, Device device) {
        logger.debug("calling updateEventHub ....");
        ObjectId eventHubId = null;
        try {
            int cloudId = cloud.getCloudId();
            String deviceUUID = device.getDeviceUUID();
            String userName = device.getUserName();
            String actionByUserName = "Schedule";
            String acctionToUserName = userName;
            logger.debug("... creating event hub....");
            EventHub eventHub = new EventHub();
            eventHub.setActionBy(actionByUserName);
            eventHub.setActionStatus(PCHelperConstant.EVENTHUB_ACTION_STATUS.CREATED.toString());
            eventHub.setActionToUserName(acctionToUserName);
            eventHub.setActionToDeviceUUID(deviceUUID);
            eventHub.setOdStatus(EventHub.ODSTATUS.STARTED.toString());
            String action = PCHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString();
            eventHub.setAction(action);
            eventHubId = this.msService.saveEventHubAction(cloudId, eventHub);
        }
        catch (Exception e) {
            logger.error("... exception trying to save eventhub ..." + e.getMessage());
        }
        return eventHubId;
    }
}

