/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.google.gson.JsonElement;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.httpcore.HttpClients;
import com.microsoft.graph.models.Deleted;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.DriveItemDeltaParameterSet;
import com.microsoft.graph.models.MailFolder;
import com.microsoft.graph.models.Message;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.DriveItemCollectionPage;
import com.microsoft.graph.requests.DriveItemCollectionRequest;
import com.microsoft.graph.requests.DriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemDeltaCollectionPage;
import com.microsoft.graph.requests.DriveItemDeltaCollectionRequest;
import com.microsoft.graph.requests.DriveItemDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemRequestBuilder;
import com.microsoft.graph.requests.DriveRequestBuilder;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.MailFolderCollectionPage;
import com.microsoft.graph.requests.MailFolderCollectionRequest;
import com.microsoft.graph.requests.MailFolderCollectionRequestBuilder;
import com.microsoft.graph.requests.MailFolderDeltaCollectionPage;
import com.microsoft.graph.requests.MailFolderDeltaCollectionRequest;
import com.microsoft.graph.requests.MailFolderDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.MailFolderRequestBuilder;
import com.microsoft.graph.requests.MessageDeltaCollectionPage;
import com.microsoft.graph.requests.MessageDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserRequestBuilder;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.MSUtilDao;
import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CrawlDeltaFileInfo;
import com.parablu.pcbd.domain.DeltaPath;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.FolderFileInfo;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.UserDefinedFolders;
import com.parablu.pcbd.domain.UsersWOBackup;
import com.pg.domain.DriveFileInfo;
import com.pg.graph.helper.Graph;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.MSService;
import com.pg.service.impl.BaseUploadService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.time.Duration;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.service.SyncFolderItemsScope;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.Mailbox;
import microsoft.exchange.webservices.data.search.FindFoldersResults;
import microsoft.exchange.webservices.data.search.FolderView;
import microsoft.exchange.webservices.data.sync.ChangeCollection;
import microsoft.exchange.webservices.data.sync.ItemChange;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class MSServiceImpl
extends BaseUploadService
implements MSService {
    private static Logger logger = LogManager.getLogger(MSServiceImpl.class);
    private static final String BASE_FOLDER = "Files";
    private static final String RESOURCE = "https://outlook.office365.com";
    private static final String SERVICE_ROOT = "https://graph.microsoft.com";
    private static final String IN_PLACE_ARCHIVE = "In-Place Archive/";
    private static final int[] EXPONENTIAL = new int[]{1, 3, 5, 8, 10};
    private static long expiryTimeMs;
    private static final long REFRESH_BEFORE_EXPIRY_MS;
    private static final String AUTHORITY = "https://login.microsoftonline.com/";
    private static final String EWS_URL = "https://outlook.office365.com/EWS/Exchange.asmx";
    GraphServiceClient<Request> graphServiceClient;
    private UserDao userDao;
    private DeviceDao deviceDao;
    private CloudDao cloudDao;
    private PciAuthorizationTokensDao pciAuthorizationTokensDao;
    private MSUtilDao msUtilDao;

    public GraphServiceClient<Request> getGraphServiceClient() {
        return this.graphServiceClient;
    }

    public void setGraphServiceClient(GraphServiceClient<Request> graphServiceClient) {
        this.graphServiceClient = graphServiceClient;
    }

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setPciAuthorizationTokensDao(PciAuthorizationTokensDao pciAuthorizationTokensDao) {
        this.pciAuthorizationTokensDao = pciAuthorizationTokensDao;
    }

    public void setMsUtilDao(MSUtilDao msUtilDao) {
        this.msUtilDao = msUtilDao;
    }

    @Override
    public Cloud getCloud(int cloudId) {
        Cloud cloud = this.cloudDao.getAllClouds().stream().findFirst().orElse(null);
        return cloud;
    }

    @Override
    public List<OfficeBackupPolicy> getAllOfficeBackupPolicies(int cloudId) {
        return this.msUtilDao.getAllOfficeBackupPolicies(cloudId);
    }

    @Override
    public List<com.parablu.pcbd.domain.User> getAllUsersForOfficeBackupPolicy(int cloudId, String policyName) {
        return this.userDao.getAllUsersForOfficeBackupPolicy(cloudId, policyName);
    }

    @Override
    public List<com.parablu.pcbd.domain.User> getAllUsersForOfficeBackupPolicyWOLicense(int cloudId, String policyName) {
        return this.userDao.getAllUsersForOfficeBackupPolicyWOLicense(cloudId, policyName);
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    @Override
    public void processDeltaChangesForUserDrive(com.parablu.pcbd.domain.User userObj, Cloud cloud, OfficeBackupPolicy oneDriveBackupPolicy, OfficeBackupPolicy oldBackupPolicy, boolean isPolicyModified, String eventHubId, long batchStartTime) {
        String userName = userObj.getUserName();
        int cloudId = cloud.getCloudId();
        Device device = this.deviceDao.getODDeviceForUserName(cloudId, userName);
        if (device == null) {
            logger.debug("... no onedrive device for user... " + userName);
            return;
        }
        if (device.isBlocked() || device.isDeleted()) {
            logger.debug("... device blocked for user... " + userName);
            return;
        }
        boolean isFullBackup = this.isFullBkpStarted(cloud, device, userName);
        if (this.isODBEnabled(cloud.getCloudCustomisableDetails()) && userObj != null && !userObj.isBackupTargetAssigned()) {
            logger.debug(".....backupTargetAssigned is false so return..." + userName);
            this.createBatchForTargetUnAssignedUser(cloudId, device.getDeviceUUID(), userName, oneDriveBackupPolicy, batchStartTime);
            return;
        }
        String deviceUUID = device.getDeviceUUID();
        String batchId = "";
        try {
            logger.debug(isFullBackup + ".....policy is modified........." + isPolicyModified);
            String deltaToken = device.getDeltaToken();
            if (StringUtils.isEmpty((String)device.getDeltaToken())) {
                isFullBackup = true;
            }
            if (isFullBackup) {
                deltaToken = "";
                isPolicyModified = false;
            }
            ArrayList<DriveItem> listItems = new ArrayList<DriveItem>();
            String prevDeviceToken = deltaToken;
            if (isPolicyModified) {
                listItems = new ArrayList();
                logger.debug(".... policymodified new log .... " + deviceUUID);
                deltaToken = this.findFiles(deviceUUID, "", listItems, userName, userObj.getEmailId(), cloud);
                logger.debug(listItems.size() + ".... policymodified before current policy .... " + deviceUUID);
                List<DriveItem> currentPolicyItems = this.getAllFilesForPolicy(listItems, deviceUUID, userName, cloudId, oneDriveBackupPolicy, device.getDestCollection(), false);
                logger.debug(listItems.size() + ".... policymodified before prevPolicyItems policy .... " + deviceUUID);
                List<DriveItem> prevPolicyItems = this.getAllFilesForPolicy(listItems, deviceUUID, userName, cloudId, oldBackupPolicy, device.getDestCollection(), false);
                logger.debug("......currentpolicyItemsyu ... " + currentPolicyItems.size());
                logger.debug("......prevPolicyItemsyu ... " + prevPolicyItems.size());
                ArrayList<DriveItem> newItems = new ArrayList<DriveItem>(currentPolicyItems);
                ArrayList<DriveItem> itemsToBeDeleted = new ArrayList<DriveItem>(prevPolicyItems);
                logger.debug("...sleep removed..." + newItems.size());
                logger.debug("..before getting new items...");
                List<DriveItem> finalNewITems = MSServiceImpl.getDiffItems(newItems, prevPolicyItems);
                logger.debug("..after getting new items..." + finalNewITems.size());
                List<DriveItem> finalDeleteITems = MSServiceImpl.getDiffItems(itemsToBeDeleted, currentPolicyItems);
                logger.debug("......itemsToBeDeleted ... " + finalDeleteITems.size());
                logger.debug("......finalNewITems ... " + finalNewITems.size());
                if (finalNewITems.size() == 0) {
                    ArrayList<DriveItem> listItems1 = new ArrayList<DriveItem>();
                    String predeltaToken = this.findFiles(deviceUUID, prevDeviceToken, listItems1, userName, userObj.getEmailId(), cloud);
                    List<DriveItem> finalprevDiffNewITems = MSServiceImpl.getDiffItems(listItems1, prevPolicyItems);
                    logger.debug("......listItems1 ... " + listItems1.size());
                    logger.debug("...finalprevDiffNewITems11..." + finalprevDiffNewITems.size());
                    List<DriveItem> finalprevDiffNewITems2 = MSServiceImpl.getDiffItems(prevPolicyItems, listItems1);
                    logger.debug("...finalprevDiffNewITems2..." + finalprevDiffNewITems2.size());
                    List<DriveItem> finalNewITemsprev = MSServiceImpl.getDiffItems(newItems, finalprevDiffNewITems2);
                    logger.debug("...items to be addedfromprev ... " + finalNewITemsprev.size());
                    finalNewITems.addAll(finalNewITemsprev);
                    logger.debug("......finalNewITems after comparing ... " + finalNewITems.size());
                }
                if (CollectionUtils.isEmpty(finalDeleteITems) && CollectionUtils.isEmpty(finalNewITems)) {
                    logger.debug(prevDeviceToken + "....checkingzero files case ... " + deltaToken);
                    deltaToken = this.findFiles(deviceUUID, prevDeviceToken, finalNewITems, userName, userObj.getEmailId(), cloud);
                }
                batchId = this.handleModifiedPolicyItems(finalNewITems, finalDeleteITems, deviceUUID, userName, cloudId, oneDriveBackupPolicy, device.getDestCollection(), eventHubId, batchStartTime);
            } else {
                logger.debug("... backup token.... " + deltaToken);
                ODBBackupBatch backupBatch = new ODBBackupBatch();
                backupBatch.setDeviceUUID(deviceUUID);
                backupBatch.setUserName(userName);
                backupBatch.setNoOfFiles(0L);
                backupBatch.setStatus("STARTED");
                batchId = this.msUtilDao.saveBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
                String retryToken = deltaToken;
                boolean firstCrawl = true;
                deltaToken = this.findOdFiles(deviceUUID, deltaToken, userName, oneDriveBackupPolicy, isFullBackup, device.getDestCollection(), false, backupBatch, batchId, eventHubId, userObj.getEmailId(), cloud, firstCrawl);
                firstCrawl = false;
                long totalNoOfFiles = this.msUtilDao.getTotalFilesCountByBatchId(batchId);
                if (totalNoOfFiles == 0L) {
                    logger.debug("...retrt one more time wait for 5 sec because it is 0 files...");
                    Thread.sleep(5000L);
                    logger.debug("...retrt one more time after 5 sec because it is 0 files...");
                    deltaToken = retryToken;
                    deltaToken = this.findOdFiles(deviceUUID, deltaToken, userName, oneDriveBackupPolicy, isFullBackup, device.getDestCollection(), false, backupBatch, batchId, eventHubId, userObj.getEmailId(), cloud, firstCrawl);
                    totalNoOfFiles = this.msUtilDao.getTotalFilesCountByBatchId(batchId);
                }
                long totalSizeToUpload = this.msUtilDao.getTotalSizeByBatchId(batchId);
                logger.debug("...total files and size...." + totalNoOfFiles + "...size..." + totalSizeToUpload);
                backupBatch.setId(new ObjectId(batchId));
                backupBatch.setStatus("COMPLETED");
                backupBatch.setTotalSizeToUpload(totalSizeToUpload);
                backupBatch.setNoOfFiles(totalNoOfFiles);
                backupBatch.setTotalNoOfFiles("" + totalNoOfFiles);
                logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + backupBatch.getId().toString());
                this.msUtilDao.updateBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
            }
            logger.debug(listItems.size() + "...@@@@@@@@@@@@@@@@new delta token from deltapage...." + deltaToken);
            this.deviceDao.updateDeviceDeltaToken(cloudId, device.getDeviceUUID(), deltaToken, prevDeviceToken);
        }
        catch (Error e) {
            e.printStackTrace();
            logger.error(e.getMessage() + " ...error trying to process .. user ... " + userName);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(batchId + " ...exception trying to process .. user ... " + userName);
            try {
                if (!StringUtils.isEmpty((String)batchId)) {
                    this.msUtilDao.deleteBatchFromOdServer(new ObjectId(batchId), oneDriveBackupPolicy.getPolicyName());
                    this.msUtilDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, "START_BACKUP");
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                logger.debug("...unable to delete event hub...." + deviceUUID);
            }
        }
    }

    private void createBatchForTargetUnAssignedUser(int cloudId, String deviceUUID, String userName, OfficeBackupPolicy oneDriveBackupPolicy, long batchStartTime) {
        ODBBackupBatch backupBatch = new ODBBackupBatch();
        backupBatch.setDeviceUUID(deviceUUID);
        backupBatch.setUserName(userName);
        backupBatch.setNoOfFiles(0L);
        backupBatch.setTotalNoOfFiles("0");
        backupBatch.setStatus("COMPLETED");
        backupBatch.setErrorCode("543");
        backupBatch.setBatchStartTimestamp(batchStartTime);
        String batchId = this.msUtilDao.saveBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
    }

    private static List<DriveItem> getDiffItems(List<DriveItem> newDriveItems, List<DriveItem> prevDriveItems) {
        Predicate<DriveItem> somePre = newItem -> prevDriveItems.stream().noneMatch(prevItem -> newItem.id.compareTo(prevItem.id) == 0);
        List<DriveItem> newItemsToBeAdded = ((Stream)newDriveItems.stream().parallel()).filter(somePre).collect(Collectors.toList());
        logger.debug("..itemnewlogic.. " + newItemsToBeAdded.size());
        return newItemsToBeAdded;
    }

    private static GraphServiceClient<Request> getGraphClient() {
        String authorityHost = "https://login.microsoftonline.com";
        logger.debug("...helper constant with okhttpclient ...." + PCHelperConstant.getMSClientId());
        GraphServiceClient graphClient = null;
        if (!StringUtils.isEmpty((String)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            logger.debug("....using proxy latest......");
            InetSocketAddress proxyInetAddress = new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort());
            logger.debug("....using proxy latest before createDefault 1bb......" + PCHelperConstant.getProxyHost() + "..pwd..." + PCHelperConstant.getProxyPort());
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            HttpClientOptions clientOptions = new HttpClientOptions();
            clientOptions.setProxyOptions(proxyOptions);
            logger.debug("....using proxy latest before createDefault 2a with host latest");
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            OkHttpClient httpClient = null;
            Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyInetAddress);
            logger.debug("....using proxy latest before createDefault 3a");
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().retryOnConnectionFailure(true).proxy(proxy).build();
            logger.debug("....using proxy latest before createDefault 4");
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).httpClient((Object)httpClient).buildClient();
            logger.debug("....using proxy latest before createDefault 5");
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            OkHttpClient httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().retryOnConnectionFailure(true).build();
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).httpClient((Object)httpClient).buildClient();
        }
        return graphClient;
    }

    private String getDriveIdForUser(Cloud cloud, String emailId) {
        block16: {
            Drive drive = null;
            try {
                String userId = this.getAzureUserId(emailId);
                logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
                drive = this.getDrive(MSServiceImpl.getGraphClient(), userId);
                if (drive != null) {
                    logger.debug(emailId + "....drive id for user ... " + drive.id);
                    return drive.id;
                }
            }
            catch (GraphServiceException e) {
                logger.error(" ... error trying to get token ..." + e.getResponseCode());
                if (e.getResponseCode() == 401) {
                    logger.debug("..sleep for 90 sec...");
                    try {
                        Thread.sleep(90000L);
                        return this.getDriveIdForUser(cloud, emailId);
                    }
                    catch (InterruptedException interruptedException) {
                        break block16;
                    }
                }
                if (e.getResponseCode() == 404) {
                    logger.error("... not able to access resource check right user token is mapped .... " + emailId);
                    return "404";
                }
                if (e.getResponseCode() != 429) break block16;
                logger.error(" ...inside GraphServiceException and 429 case... ");
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                boolean success = true;
                do {
                    try {
                        String userId = this.getAzureUserId(emailId);
                        logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
                        drive = this.getDrive(MSServiceImpl.getGraphClient(), userId);
                        if (drive != null) {
                            logger.debug(emailId + "....drive id for user ... " + drive.id);
                            return drive.id;
                        }
                        success = false;
                    }
                    catch (GraphServiceException ew) {
                        if (ew.getResponseCode() != 429) continue;
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        success = true;
                    }
                } while (success);
            }
            catch (Exception ee) {
                logger.error(".... exception......" + ee.getMessage());
            }
        }
        return null;
    }

    private String getAzureUserId(String emailId) {
        String userId;
        block9: {
            userId = "";
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            try {
                com.parablu.pcbd.domain.User user;
                requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
                UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)MSServiceImpl.getGraphClient().users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
                if (StringUtils.isEmpty((String)userId)) {
                    requestOptions = new ArrayList();
                    requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + emailId + "'")));
                    iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)MSServiceImpl.getGraphClient().users().buildRequest(requestOptions)).top(1).get();
                    for (User userObj : iUserCollectionPage.getCurrentPage()) {
                        logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                        userId = userObj.id;
                    }
                }
                if (StringUtils.isEmpty((String)userId) && (user = this.userDao.getUserDetailsForEmail(1, emailId)) != null) {
                    requestOptions = new ArrayList();
                    requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + user.getUserName() + "'")));
                    iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)MSServiceImpl.getGraphClient().users().buildRequest(requestOptions)).top(1).get();
                    for (User userObj : iUserCollectionPage.getCurrentPage()) {
                        logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                        userId = userObj.id;
                    }
                }
            }
            catch (GraphServiceException ee) {
                if (ee.getResponseCode() != 429) break block9;
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                userId = this.getAzureUserId(emailId);
            }
        }
        return userId;
    }

    private Drive getDrive(GraphServiceClient<Request> graphClient, String userId) {
        Drive drive;
        block4: {
            drive = null;
            try {
                drive = graphClient.users(userId).drive().buildRequest(new Option[0]).get();
            }
            catch (GraphServiceException ee) {
                logger.debug(".....error trying to get drive...." + ee.getResponseCode());
                if (ee.getResponseCode() != 429) break block4;
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                drive = this.getDrive(MSServiceImpl.getGraphClient(), userId);
            }
        }
        return drive;
    }

    private String findFiles(String deviceUUID, String deltaToken, List<DriveItem> listItems, String userName, String emailId, Cloud cloud) {
        DriveItemDeltaParameterSet driveItemDeltaParameterSet4;
        String deltaLink = "";
        DriveItemDeltaCollectionPage deltaPage = null;
        logger.debug("... before drive..." + deviceUUID);
        int cloudId = cloud.getCloudId();
        String driveId = this.getDriveIdForUser(cloud, emailId);
        if (!StringUtils.isEmpty((String)driveId) && "404".equals(driveId)) {
            return "";
        }
        DriveRequestBuilder drives = this.getDrive(cloudId, driveId);
        logger.debug(driveId + "... after drive..." + drives);
        try {
            if (!StringUtils.isEmpty((String)deltaToken)) {
                DriveItemDeltaParameterSet driveItemDeltaParameterSet2 = new DriveItemDeltaParameterSet();
                driveItemDeltaParameterSet2.token = deltaToken;
                deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)drives.root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(deltaToken).build()).buildRequest(new Option[0])).get();
            } else {
                deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)drives.root().delta().buildRequest(new Option[0])).get();
            }
        }
        catch (Error e) {
            logger.error(driveId + " ... unable to get drive so pause for 1 min ... " + userName);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.debug("... retry for drive..." + drives);
            drives = this.getDrive(cloudId, driveId);
            if (!StringUtils.isEmpty((String)deltaToken)) {
                driveItemDeltaParameterSet4 = new DriveItemDeltaParameterSet();
                driveItemDeltaParameterSet4.token = deltaToken;
                deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)drives.root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(deltaToken).build()).buildRequest(new Option[0])).get();
            } else {
                deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)drives.root().delta().buildRequest(new Option[0])).get();
            }
        }
        catch (GraphServiceException e) {
            if (e.getResponseCode() == 401) {
                logger.error(" ...inside GraphServiceException and 401 case... ");
            } else {
                logger.error(e.getResponseCode() + " ...inside GraphServiceException unable to get drive so pause for 1 min ... " + userName + "...devuuid.." + deviceUUID);
                if (e.getResponseCode() == 403) {
                    logger.debug("403...check for permisiion for user ..." + userName);
                    return deltaToken;
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException driveItemDeltaParameterSet3) {
                    // empty catch block
                }
            }
            logger.debug(deviceUUID + "... retry for drive..." + drives);
            drives = this.getDrive(cloudId, driveId);
            if (!StringUtils.isEmpty((String)deltaToken)) {
                driveItemDeltaParameterSet4 = new DriveItemDeltaParameterSet();
                driveItemDeltaParameterSet4.token = deltaToken;
                deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)drives.root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(deltaToken).build()).buildRequest(new Option[0])).get();
            } else {
                deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)drives.root().delta().buildRequest(new Option[0])).get();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ...inside Exception unable to get drive so pause for 1 min ... " + userName);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException driveItemDeltaParameterSet4) {
                // empty catch block
            }
            logger.debug("... retry for drive..." + drives);
            drives = this.getDrive(cloudId, driveId);
            if (!StringUtils.isEmpty((String)deltaToken)) {
                driveItemDeltaParameterSet4 = new DriveItemDeltaParameterSet();
                driveItemDeltaParameterSet4.token = deltaToken;
                deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)drives.root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(deltaToken).build()).buildRequest(new Option[0])).get();
            }
            deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)drives.root().delta().buildRequest(new Option[0])).get();
        }
        logger.debug("... after deltapage..." + deltaPage);
        boolean isNextPageExists = false;
        List currentPage = null;
        AbstractList requestOptions = new ArrayList();
        int i = 0;
        do {
            try {
                currentPage = deltaPage.getCurrentPage();
                logger.debug("... after currentpage...");
                listItems.addAll(currentPage);
                logger.debug(i + "... itempage size... " + currentPage.size());
                deltaLink = deltaPage.deltaLink();
                DriveItemDeltaCollectionRequestBuilder nextPage = (DriveItemDeltaCollectionRequestBuilder)deltaPage.getNextPage();
                if (deltaLink == null) {
                    logger.error("... delta link is null... " + nextPage.getRequestUrl());
                    String serviceRoot = " https://graph.microsoft.com";
                    deltaLink = ((DriveItemDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(serviceRoot, "");
                }
                deltaToken = MSServiceImpl.getDeltaToken(deltaLink);
                requestOptions = new LinkedList();
                requestOptions.add(new QueryOption("token", (Object)deltaToken));
                deltaPage = (DriveItemDeltaCollectionPage)drives.root().delta().buildRequest((List)requestOptions).get();
                logger.debug("... after currentpage deltaToken...");
                ++i;
                if (currentPage.size() <= 0 || nextPage == null) break;
                isNextPageExists = true;
            }
            catch (GraphServiceException e) {
                logger.error("... error response codecheck .... " + e.getResponseCode());
                if (e.getResponseCode() != 429 && e.getResponseCode() != 401) continue;
                logger.debug(".... retry .. after 2 mins.. ");
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                logger.error("... unable to catch exception during crawl logging in... " + ee.getMessage());
            }
        } while (isNextPageExists);
        return deltaToken;
    }

    private String findOdFiles(String deviceUUID, String deltaToken, String userName, OfficeBackupPolicy oneDriveBackupPolicy, boolean isFullBackup, String deviceDestCollection, boolean isMail, ODBBackupBatch backupBatch, String batchId, String eventHubId, String emailId, Cloud cloud, boolean firstCrawl) {
        logger.debug("... before drive..." + deviceUUID);
        try {
            deltaToken = this.getODFiles(deviceUUID, deltaToken, userName, oneDriveBackupPolicy, isFullBackup, deviceDestCollection, backupBatch, batchId, eventHubId, emailId, cloud, firstCrawl);
        }
        catch (GraphServiceException ee) {
            logger.error("...response code ....wait 2 mins.." + ee.getResponseCode());
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.debug(" graph service exception found so retry ..... ");
            deltaToken = this.getODFiles(deviceUUID, deltaToken, userName, oneDriveBackupPolicy, isFullBackup, deviceDestCollection, backupBatch, batchId, eventHubId, emailId, cloud, firstCrawl);
        }
        catch (Exception ee) {
            logger.debug(" od files exception found so retry ..... ");
            deltaToken = this.getODFiles(deviceUUID, deltaToken, userName, oneDriveBackupPolicy, isFullBackup, deviceDestCollection, backupBatch, batchId, eventHubId, emailId, cloud, firstCrawl);
        }
        return deltaToken;
    }

    private String getODFiles(String deviceUUID, String deltaToken, String userName, OfficeBackupPolicy oneDriveBackupPolicy, boolean isFullBackup, String deviceDestCollection, ODBBackupBatch backupBatch, String batchId, String eventHubId, String emailId, Cloud cloud, boolean firstCrawl) {
        LinkedList<QueryOption> requestOptions = null;
        String deltaLink = "";
        DriveItemDeltaCollectionPage deltaPage = null;
        String driveId = this.getDriveIdForUser(cloud, emailId);
        logger.error(".... user not found ..." + emailId + "..." + userName);
        if (StringUtils.isEmpty((String)driveId) || !StringUtils.isEmpty((String)driveId) && "404".equals(driveId)) {
            this.updateOverViewStatus(cloud.getCloudId(), deviceUUID, 2003);
            return deltaToken;
        }
        logger.debug(driveId + "... after drive...");
        int cloudId = cloud.getCloudId();
        try {
            if (!StringUtils.isEmpty((String)deltaToken)) {
                logger.debug("...inside delta...." + deltaToken);
                requestOptions = new LinkedList<QueryOption>();
                requestOptions.add(new QueryOption("token", (Object)deltaToken));
                deltaPage = (DriveItemDeltaCollectionPage)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(requestOptions).get();
            } else {
                logger.debug("...empty delta...." + deltaToken);
                deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get();
                logger.debug("...after empty delta...." + deltaToken);
            }
        }
        catch (Error e) {
            logger.error(deviceUUID + " ... unable to get drive so pause for 1 min ... " + userName + "..." + driveId);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.debug("... retry for drive...");
            if (!StringUtils.isEmpty((String)deltaToken)) {
                requestOptions = new LinkedList();
                requestOptions.add(new QueryOption("token", (Object)deltaToken));
                deltaPage = (DriveItemDeltaCollectionPage)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(requestOptions).get();
            } else {
                deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get();
            }
        }
        catch (GraphServiceException e) {
            logger.debug("...graph response code...." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.error(" ...inside GraphServiceException and 401 case... ");
            } else if (e.getResponseCode() == 429) {
                logger.error(" ...inside GraphServiceException and 429 case... ");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                boolean success = true;
                do {
                    try {
                        if (!StringUtils.isEmpty((String)deltaToken)) {
                            requestOptions = new LinkedList();
                            requestOptions.add(new QueryOption("token", (Object)deltaToken));
                            deltaPage = (DriveItemDeltaCollectionPage)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(requestOptions).get();
                        } else {
                            deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get();
                        }
                        success = false;
                    }
                    catch (GraphServiceException ew) {
                        if (e.getResponseCode() != 429) continue;
                        success = true;
                    }
                } while (success);
            } else {
                logger.error(e.getResponseCode() + " ...inside GraphServiceException unable to get drive so pause for 1 min ... " + userName + "...devuuid.." + deviceUUID);
                if (e.getResponseCode() == 403) {
                    logger.debug("403...check for permisiion for user ..." + userName);
                    return deltaToken;
                }
                if (e.getResponseCode() == 410) {
                    logger.debug("...token is out of sync .. so empty delta....");
                    deltaToken = "";
                    isFullBackup = true;
                }
            }
            logger.debug(driveId + "... retry for drive...");
            if (!StringUtils.isEmpty((String)deltaToken)) {
                requestOptions = new LinkedList();
                requestOptions.add(new QueryOption("token", (Object)deltaToken));
                deltaPage = (DriveItemDeltaCollectionPage)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(requestOptions).get();
            } else {
                deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ...inside Exception unable to get drive so pause for 1 min ... " + userName);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException success) {
                // empty catch block
            }
            logger.debug("... retry for drive...");
            if (!StringUtils.isEmpty((String)deltaToken)) {
                requestOptions = new LinkedList();
                requestOptions.add(new QueryOption("token", (Object)deltaToken));
                deltaPage = (DriveItemDeltaCollectionPage)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(requestOptions).get();
            }
            deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get();
        }
        logger.debug("... after deltapage..." + deltaPage);
        boolean isNextPageExists = false;
        List currentPage = null;
        int i = 0;
        int totalFiles = 0;
        int driveCheck = 0;
        boolean firstTimeCheckForFolders = true;
        String prevDeviceToken = "";
        do {
            currentPage = deltaPage.getCurrentPage();
            logger.debug("... after currentpage..." + totalFiles);
            ArrayList<DriveItem> newList = new ArrayList<DriveItem>();
            newList.addAll(currentPage);
            int noOfFiles = 0;
            noOfFiles = this.handleItemsForOd(newList, deviceUUID, userName, cloudId, oneDriveBackupPolicy, isFullBackup, deviceDestCollection, false, backupBatch, batchId, eventHubId, driveId, deltaToken, firstTimeCheckForFolders, firstCrawl);
            firstTimeCheckForFolders = false;
            logger.debug(i + "... itempage size... " + currentPage.size());
            logger.debug(noOfFiles + "...total files processedd...." + (totalFiles += noOfFiles));
            deltaLink = deltaPage.deltaLink();
            DriveItemDeltaCollectionRequestBuilder nextPage = (DriveItemDeltaCollectionRequestBuilder)deltaPage.getNextPage();
            logger.debug("....before deltalink.... " + deltaLink);
            if (deltaLink == null) {
                logger.error("... delta link is null... " + nextPage.getRequestUrl());
                String serviceRoot = " https://graph.microsoft.com";
                deltaLink = ((DriveItemDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(serviceRoot, "");
            }
            logger.debug("....after deltalink.... " + deltaLink);
            deltaToken = MSServiceImpl.getDeltaToken(deltaLink);
            logger.debug("...token...val..." + deltaToken);
            requestOptions = new LinkedList();
            requestOptions.add(new QueryOption("token", (Object)deltaToken));
            if (++driveCheck == 500) {
                logger.debug("...retry drive after 500 checks ...." + driveCheck);
                driveCheck = 0;
            }
            try {
                deltaPage = (DriveItemDeltaCollectionPage)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(requestOptions).get();
            }
            catch (GraphServiceException e) {
                logger.debug("...graph response code...." + e.getResponseCode());
                logger.error(e.getResponseCode() + " ...inside GraphServiceException unable to get drive so pause for 1 min ... " + userName + "...devuuid.." + deviceUUID);
                if (e.getResponseCode() == 429) {
                    boolean success = true;
                    do {
                        try {
                            if (!StringUtils.isEmpty((String)deltaToken)) {
                                requestOptions = new LinkedList();
                                requestOptions.add(new QueryOption("token", (Object)deltaToken));
                                deltaPage = (DriveItemDeltaCollectionPage)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(requestOptions).get();
                            } else {
                                deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get();
                            }
                            success = false;
                        }
                        catch (GraphServiceException ew) {
                            if (e.getResponseCode() != 429) continue;
                            success = true;
                        }
                    } while (success);
                } else if (e.getResponseCode() == 410) {
                    logger.debug("...token is out of sync .. so empty delta....");
                    deltaToken = "";
                    isFullBackup = true;
                    if (!StringUtils.isEmpty((String)deltaToken)) {
                        requestOptions = new LinkedList();
                        requestOptions.add(new QueryOption("token", (Object)deltaToken));
                        deltaPage = (DriveItemDeltaCollectionPage)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(requestOptions).get();
                    } else {
                        deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get();
                    }
                } else {
                    String delta = null;
                    logger.error("....check this case...." + e.getResponseCode());
                    if (delta.equalsIgnoreCase("UNKKNOWNEXCEPTION")) {
                        logger.debug("...check for null....");
                    }
                }
            }
            catch (ClientException ee) {
                try {
                    int count = 0;
                    int maxTries = 5;
                    do {
                        try {
                            logger.debug(count + "...retry iteration...." + userName);
                            Thread.sleep(EXPONENTIAL[count] * 60000);
                            deltaPage = (DriveItemDeltaCollectionPage)MSServiceImpl.getGraphClient().drives(driveId).root().delta().buildRequest(requestOptions).get();
                        }
                        catch (GraphServiceException graphServiceException) {
                        }
                        catch (ClientException clientException) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    } while (++count != maxTries && deltaPage == null);
                }
                catch (GraphServiceException graphServiceException) {
                    // empty catch block
                }
            }
            logger.debug(totalFiles + "... after currentpage deltaToken..." + noOfFiles + "....current..." + currentPage.size());
            ++i;
            if (currentPage.size() <= 0 || nextPage == null) {
                isNextPageExists = false;
                continue;
            }
            isNextPageExists = true;
            this.deviceDao.updateDeviceDeltaToken(cloudId, deviceUUID, deltaToken, prevDeviceToken);
            prevDeviceToken = deltaToken;
        } while (isNextPageExists);
        return deltaToken;
    }

    private List<String> crawlContacts(int cloudId, String userId, String userName, boolean isFullBackup) {
        ArrayList<String> list = new ArrayList<String>();
        return list;
    }

    private List<String> crawlTasks(int cloudId, String userId, String userName, boolean isFullBackup) {
        ArrayList<String> list = new ArrayList<String>();
        return list;
    }

    private HttpResponse getContacts(String accessToken, String downloadurl) throws IOException, ClientProtocolException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(downloadurl);
        httpGet.addHeader("Accept", "application/json");
        httpGet.addHeader("Authorization", "Bearer " + accessToken);
        httpGet.addHeader("Prefer", "odata.maxpagesize=40");
        HttpResponse response = client.execute((HttpUriRequest)httpGet);
        return response;
    }

    private boolean isFullBkpStarted(Cloud cloud, Device device, String userName) {
        boolean fullBkpStarted = false;
        List<EventHub> list = this.getEventHubForDeviceUUID(cloud.getCloudId(), device.getDeviceUUID());
        if (!CollectionUtils.isEmpty(list)) {
            for (EventHub eventHub : list) {
                if (eventHub == null || !"FULL_BACKUP".equalsIgnoreCase(eventHub.getAction())) continue;
                fullBkpStarted = true;
                break;
            }
        }
        return fullBkpStarted;
    }

    private static String getDeltaToken(String url1) {
        url1 = url1.substring(url1.lastIndexOf(61) + 1);
        url1 = url1.replace("'", "");
        url1 = url1.replace(")", "");
        return url1;
    }

    private int handleItemsForOd(List<DriveItem> currentPage, String deviceUUID, String userName, int cloudId, OfficeBackupPolicy oneDriveBackupPolicy, boolean isFullBackup, String deviceDestCollection, boolean isMail, ODBBackupBatch backupBatch, String batchId, String eventHubId, String driveID, String deltaToken, boolean firstTimeCheckForFolders, boolean firstCrawl) {
        int file = 0;
        int folder = 0;
        int noOfFiles = 0;
        int totalSizeToUpload = 0;
        ArrayList<DriveItem> folders = new ArrayList<DriveItem>();
        HashMap<String, String> folderMap = new HashMap<String, String>();
        for (DriveItem driveItem : currentPage) {
            Deleted deleted = driveItem.deleted;
            if (deleted != null) continue;
            if (!StringUtils.isEmpty((String)driveItem.name) && driveItem.name.equalsIgnoreCase("root")) {
                logger.debug("...rooot vaal so skip...");
                continue;
            }
            if (driveItem.folder == null) continue;
            String basePath = "";
            String itemName = driveItem.name;
            if (driveItem.folder != null && !StringUtils.isEmpty((String)itemName) && !driveItem.name.equalsIgnoreCase("root")) {
                String parentPath;
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                String newPath = parentPath + "/" + driveItem.name;
                String folderPathVal = BASE_FOLDER + newPath;
                ++folder;
                folderMap.put(folderPathVal, driveItem.id);
            }
            if (isFullBackup) continue;
            boolean allow = this.handleFolderElement(basePath, basePath, oneDriveBackupPolicy, deviceUUID, userName, cloudId);
            allow = false;
            BackUpImage backUpImage = this.msUtilDao.getBackupImageForItemId(cloudId, driveItem.id, deviceDestCollection, deviceUUID);
            if (backUpImage != null) {
                logger.debug("...already folder exists ..." + backUpImage.getFileName());
                allow = false;
            } else {
                logger.debug("...folder not exists so add ..." + driveItem.id);
            }
            if (!allow) continue;
            logger.debug("... folder allowed.... " + basePath + "..." + allow);
        }
        int i = 0;
        logger.debug("......folders.... " + folders.size());
        if (firstTimeCheckForFolders) {
            List<DriveItem> listItems = this.getModifiedFolderFiles(cloudId, deviceDestCollection, folders, deviceUUID, driveID, deltaToken);
            currentPage.addAll(listItems);
        }
        logger.debug("... files to process... " + currentPage.size());
        i = 0;
        boolean isLinkPolicyEnabled = false;
        if (oneDriveBackupPolicy != null && oneDriveBackupPolicy.isCreateLinkEnabled() && oneDriveBackupPolicy.getThreshholdLimit() > 0L) {
            isLinkPolicyEnabled = true;
        }
        for (DriveItem driveItem : currentPage) {
            ++i;
            boolean isFile = false;
            if (driveItem.file != null) {
                isFile = true;
            }
            boolean isFolder = false;
            if (driveItem.folder != null) {
                isFolder = true;
            }
            String basePath = "";
            boolean isPresent = true;
            String itemName = driveItem.name;
            logger.debug(driveItem.name + "..filetoProcess..." + driveItem.id);
            Deleted deleted = driveItem.deleted;
            logger.debug("....status...." + firstCrawl);
            if (deleted != null && firstCrawl) {
                logger.debug("....deletedstatus...." + firstCrawl);
                try {
                    BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, driveItem.id, deviceDestCollection, deviceUUID);
                    if (backUpImageold == null || isLinkPolicyEnabled) continue;
                    logger.debug("....handle deleted files case......" + driveItem.id);
                    BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                    this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                }
                catch (Exception e) {
                    logger.error(".. error trying to save deleted bkp image...." + e.getMessage());
                }
                continue;
            }
            if (!StringUtils.isEmpty((String)driveItem.name) && driveItem.name.equalsIgnoreCase("root")) {
                logger.debug("...rooot vaal so skip...");
                continue;
            }
            if (driveItem.folder != null) continue;
            if (driveItem.folder != null && !StringUtils.isEmpty((String)itemName) && !driveItem.name.equalsIgnoreCase("root")) {
                String parentPath;
                logger.debug("..folder.." + driveItem.name + "...." + driveItem.folder.childCount);
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                String newPath = parentPath + "/" + driveItem.name;
                logger.debug(parentPath + "..... folder to be added .... " + newPath);
                ++folder;
            } else if (driveItem.file != null) {
                String parentPath;
                ++file;
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
            }
            if (StringUtils.isEmpty((String)basePath)) {
                basePath = "";
            }
            if (StringUtils.isEmpty((String)itemName)) continue;
            boolean isFileAllowed = this.handleElement(basePath, itemName, driveItem.size, oneDriveBackupPolicy, deviceUUID, userName, cloudId, isMail);
            if (itemName.endsWith(".url") && driveItem.lastModifiedBy != null && driveItem.lastModifiedBy.application != null && driveItem.lastModifiedBy.application.displayName != null && driveItem.lastModifiedBy.application.displayName.contains("Parablu Inc")) continue;
            if (itemName.endsWith(".url") && driveItem.lastModifiedBy != null && driveItem.lastModifiedBy.user != null) {
                logger.debug(driveItem.lastModifiedBy.user.displayName + "....url file...." + itemName + "...");
            }
            if (!isFileAllowed) continue;
            DriveFileInfo driveFileInfo = new DriveFileInfo();
            driveFileInfo.setDeviceUUID(deviceUUID);
            String folderPath = BASE_FOLDER + basePath;
            driveFileInfo.setItemPath(folderPath);
            driveFileInfo.setItemName(itemName);
            driveFileInfo.setItemId(driveItem.id);
            driveFileInfo.setFolder(isFolder);
            driveFileInfo.setFilePresent(isPresent);
            driveFileInfo.setOperation("FILE");
            driveFileInfo.setBackupBatchId(batchId);
            driveFileInfo.setFullBackup(isFullBackup);
            if (driveItem.lastModifiedDateTime != null) {
                Date lastModifiedDateTime = Date.from(driveItem.lastModifiedDateTime.toInstant());
                driveFileInfo.setO365LastModifiedTime(lastModifiedDateTime.getTime());
            } else {
                Date createdDateTime = Date.from(driveItem.createdDateTime.toInstant());
                driveFileInfo.setO365LastModifiedTime(createdDateTime.getTime());
            }
            String folderItemId = "";
            if (folderMap.get(folderPath) != null) {
                folderItemId = (String)folderMap.get(folderPath);
            }
            driveFileInfo.setParentItemId(folderItemId);
            driveFileInfo.setUserName(userName);
            driveFileInfo.setSize(driveItem.size);
            totalSizeToUpload += driveItem.size.intValue();
            CrawlDeltaFileInfo crawlDeltaFileInfo = new CrawlDeltaFileInfo();
            BeanUtils.copyProperties((Object)driveFileInfo, (Object)crawlDeltaFileInfo);
            boolean itemSaved = this.msUtilDao.saveDriveItem(cloudId, driveFileInfo, crawlDeltaFileInfo);
            this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
            if (!itemSaved) continue;
            ++noOfFiles;
        }
        folderMap.forEach((path, itemId) -> {
            FolderFileInfo folderFileInfo = new FolderFileInfo();
            folderFileInfo.setItemId(itemId);
            folderFileInfo.setItemPath(path);
            folderFileInfo.setDeviceUUID(backupBatch.getDeviceUUID());
            this.msUtilDao.saveFolderItem(folderFileInfo);
        });
        logger.debug(folder + ".....folder + file......." + file);
        logger.debug(".....nooffiles....." + noOfFiles);
        return noOfFiles;
    }

    private static void addChildFolders(String userPrincId, List<MailFolder> sublistItems, Map<String, String> folderPathMap, MailFolder fol) {
        MailFolderCollectionPage iMailFolderCollectionPage2 = (MailFolderCollectionPage)((MailFolderCollectionRequest)((MailFolderRequestBuilder)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders().byId(fol.id)).childFolders().buildRequest(new Option[0])).get();
        boolean isNextPageExists = false;
        List mailcurrentPage = null;
        ArrayList listFolderItems = new ArrayList();
        do {
            mailcurrentPage = iMailFolderCollectionPage2.getCurrentPage();
            listFolderItems.addAll(mailcurrentPage);
            if (iMailFolderCollectionPage2.getNextPage() == null) break;
            iMailFolderCollectionPage2 = (MailFolderCollectionPage)((MailFolderCollectionRequest)((MailFolderCollectionRequestBuilder)iMailFolderCollectionPage2.getNextPage()).buildRequest(new Option[0])).get();
        } while (listFolderItems.size() > 0 && (isNextPageExists = true));
        String parentPath1 = folderPathMap.get(fol.id);
        if (StringUtils.isEmpty((String)parentPath1)) {
            String pathva = fol.displayName;
            if (!StringUtils.isEmpty((String)parentPath1)) {
                pathva = parentPath1 + "/" + fol.displayName;
            }
            folderPathMap.put(fol.id, pathva);
        }
        listFolderItems.forEach(chfol -> {
            String parentPath = (String)folderPathMap.get(chfol.parentFolderId);
            String path = MSServiceImpl.getPath(fol, chfol, parentPath);
            folderPathMap.put(chfol.id, path);
            if (chfol.childFolderCount > 0) {
                MSServiceImpl.addChildFolders(userPrincId, sublistItems, folderPathMap, chfol);
                sublistItems.addAll(listFolderItems);
            }
        });
        sublistItems.addAll(listFolderItems);
    }

    private static String getPath(MailFolder fol, MailFolder chfol, String parentPath) {
        String path = fol.displayName + "/" + chfol.displayName;
        if (!StringUtils.isEmpty((String)parentPath)) {
            path = parentPath + "/" + chfol.displayName;
        }
        return path;
    }

    private static void getItemsToBeAdded(List<DriveItem> newDriveItems, List<DriveItem> prevDriveItems) {
        ArrayList<DriveItem> newItemsToBeAdded = new ArrayList<DriveItem>();
        for (DriveItem item : newDriveItems) {
            boolean itemFound = false;
            String itemPath = "";
            if (item.parentReference != null) {
                itemPath = StringUtils.substringAfterLast((String)item.parentReference.path, (String)"root:");
            }
            logger.debug("..item.. " + item.name);
            for (DriveItem previtem : prevDriveItems) {
                logger.debug("..previtem.. " + previtem.name);
                String prevItemPath = "";
                if (previtem.parentReference != null) {
                    prevItemPath = StringUtils.substringAfterLast((String)previtem.parentReference.path, (String)"root:");
                }
                if (previtem.name == null || !item.name.equalsIgnoreCase(previtem.name) || !itemPath.equalsIgnoreCase(prevItemPath)) continue;
                itemFound = true;
                break;
            }
            if (itemFound) continue;
            newItemsToBeAdded.add(item);
        }
    }

    private static boolean isContainExactWord(String fullString, String partWord) {
        String pattern = "\\b" + partWord + "\\b";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(fullString);
        return m.find();
    }

    private void removeDeletedFolderFiles(int cloudId, String userName, String deviceUUID, Map<String, String> folderPathMap, String deviceDestCollection, String userPrincId, Map<String, String> inplaceFolderPathMap) {
        Set<String> delFolderMap = this.getDeletedFolderList(userName, folderPathMap);
        logger.debug("..folder delete size..." + delFolderMap.size());
        HashMap<String, String> deleteFolderPathMap = new HashMap<String, String>();
        HashSet<String> finalDelFolderMap = new HashSet<String>();
        for (String deleteFolder : delFolderMap) {
            if ("Deletions".equalsIgnoreCase(deleteFolder)) continue;
            logger.debug(userName + "...folder to delete...." + deleteFolder);
            String key = MSServiceImpl.getKeyFromValue(folderPathMap, deleteFolder);
            logger.debug(deleteFolder + ".......folderdelete...." + key);
            if (!StringUtils.isEmpty((String)key)) {
                MailFolder mailFolderVal = null;
                try {
                    mailFolderVal = ((MailFolderRequestBuilder)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders().byId(key)).buildRequest(new Option[0]).get();
                }
                catch (GraphServiceException e) {
                    logger.error("....folder to delete...." + userPrincId + "..fold.." + key);
                }
                catch (ClientException e) {
                    logger.error("....folder to delete...." + userPrincId + "..fold.." + key);
                }
                if (mailFolderVal != null) {
                    JsonElement jsonElement = (JsonElement)mailFolderVal.additionalDataManager().get((Object)"@removed");
                    boolean isDeleted = false;
                    if (jsonElement != null) {
                        isDeleted = true;
                    }
                    logger.debug(deleteFolder + "..is folder deleted..." + isDeleted);
                    if (isDeleted) {
                        deleteFolderPathMap.put(key, deleteFolder);
                        finalDelFolderMap.add(deleteFolder);
                    }
                }
                logger.debug("......valdelete...." + mailFolderVal);
                continue;
            }
            logger.debug("....else dleete folder ..." + deleteFolder);
            if (inplaceFolderPathMap != null && inplaceFolderPathMap.size() > 0) {
                ArrayList<String> list = new ArrayList<String>(inplaceFolderPathMap.keySet());
                if (list.contains(deleteFolder)) continue;
                logger.debug(deleteFolder + "..is folder deleted key null...");
                deleteFolderPathMap.put(key, deleteFolder);
                finalDelFolderMap.add(deleteFolder);
                continue;
            }
            logger.debug(deleteFolder + "..is folder deleted key null...");
            deleteFolderPathMap.put(key, deleteFolder);
            finalDelFolderMap.add(deleteFolder);
        }
        if (!CollectionUtils.isEmpty(finalDelFolderMap)) {
            for (String newPathVal : finalDelFolderMap) {
                BackUpImage deletedBkpImage;
                if (StringUtils.isEmpty((String)newPathVal)) continue;
                String parentpath = newPathVal;
                String child = "";
                try {
                    parentpath = newPathVal.substring(0, newPathVal.lastIndexOf(47));
                    child = newPathVal.substring(newPathVal.lastIndexOf(47));
                    child = child.replaceFirst("/", "");
                }
                catch (Exception e) {
                    logger.error("...try checking path..." + parentpath);
                }
                logger.debug("...deleting folderrep lates test..." + parentpath + "...." + child);
                if (!StringUtils.isEmpty((String)newPathVal) && (newPathVal.startsWith("In-Place Archive") || !StringUtils.isEmpty((String)parentpath) && parentpath.startsWith("recoverableitemsdeletions")) || (deletedBkpImage = this.msUtilDao.getBackupImageFolder(cloudId, parentpath, child, deviceDestCollection, deviceUUID)) != null && deletedBkpImage.isFolder() && !deletedBkpImage.isPresent()) continue;
                try {
                    try {
                        parentpath = newPathVal.substring(0, newPathVal.lastIndexOf(47));
                        child = newPathVal.substring(newPathVal.lastIndexOf(47));
                        child = child.replaceFirst("/", "");
                    }
                    catch (Exception e) {
                        logger.error("...try checking path..." + parentpath);
                    }
                    logger.debug("...deleting folderrep lates..." + parentpath + "...." + child);
                    if (deletedBkpImage == null || !deletedBkpImage.isFolder()) continue;
                    BackUpImage deletedBkpImageFold = this.convertToBkpImage(deletedBkpImage.getDeviceUUID(), deletedBkpImage);
                    this.msUtilDao.saveDeletedBackupImageForMail(cloudId, deletedBkpImageFold, deviceDestCollection);
                    this.msUtilDao.deletedeltPathForUser(deletedBkpImageFold.getDevicePath() + "/" + deletedBkpImageFold.getFileName(), userName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.debug("...unable to delete folder..." + newPathVal);
                }
            }
        }
    }

    private static void findAllSubFolders(ExchangeService service, FolderId parentFolderId, String parentPath, Map<String, String> folderPathMap) {
        try {
            FindFoldersResults foundFolders = service.findFolders(parentFolderId, new FolderView(Integer.MAX_VALUE));
            for (Folder subFolder : foundFolders) {
                String path = parentPath + "/" + subFolder.getDisplayName();
                System.out.println(path + ".....folder...." + subFolder.getDisplayName());
                folderPathMap.put(path, subFolder.getId().getUniqueId());
                MSServiceImpl.findAllSubFolders(service, subFolder.getId(), path, folderPathMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, String> getInPlaceArchiveFolders(ExchangeService service, String emailId) {
        HashMap<String, String> folderPathMapLatest = new HashMap<String, String>();
        System.out.println("...user..." + emailId);
        ArrayList<String> inplaceFolderPaths = new ArrayList<String>();
        try {
            Mailbox userMailbox = new Mailbox(emailId);
            FolderId folderId = new FolderId(WellKnownFolderName.ArchiveMsgFolderRoot, userMailbox);
            HashMap<String, String> folderPathMap = new HashMap<String, String>();
            FindFoldersResults inPlaceFolders = null;
            inPlaceFolders = service.findFolders(folderId, new FolderView(Integer.MAX_VALUE));
            LinkedList<String> inputIdsList = new LinkedList<String>();
            for (Folder folder : inPlaceFolders.getFolders()) {
                if (StringUtils.isEmpty((String)folder.getDisplayName()) || "PersonMetadata".equalsIgnoreCase(folder.getDisplayName()) || "Tasks".equalsIgnoreCase(folder.getDisplayName()) || "Calendar".equalsIgnoreCase(folder.getDisplayName())) continue;
                inputIdsList.add(folder.getId().getUniqueId());
                folderPathMap.put(folder.getDisplayName(), folder.getId().getUniqueId());
                logger.debug("foldersunderInplace..." + folder.getDisplayName());
                MSServiceImpl.findAllSubFolders(service, folder.getId(), folder.getDisplayName(), folderPathMap);
            }
            for (Map.Entry entry : folderPathMap.entrySet()) {
                String path = IN_PLACE_ARCHIVE + (String)entry.getKey();
                folderPathMapLatest.put(path, (String)entry.getValue());
                inplaceFolderPaths.add(path);
                logger.debug("...inplacefolders..." + path + "...." + (String)entry.getValue());
            }
        }
        catch (Exception e) {
            System.out.println("....error trying to get inplace archive folders ...." + e.getMessage());
        }
        return folderPathMapLatest;
    }

    private String handleMailItems(List<Message> currentPage, String deviceUUID, String userName, String emailId, int cloudId, OfficeBackupPolicy oneDriveBackupPolicy, boolean isFullBackup, String deviceDestCollection, String deltaToken, String eventHubId, long batchStartTime) {
        String userPrincId;
        int folder = 0;
        int noOfFiles = 0;
        ODBBackupBatch backupBatch = new ODBBackupBatch();
        backupBatch.setDeviceUUID(deviceUUID);
        backupBatch.setUserName(userName);
        backupBatch.setNoOfFiles((long)noOfFiles);
        backupBatch.setStatus("STARTED");
        String batchId = this.msUtilDao.saveBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
        ArrayList folders = new ArrayList();
        HashMap<String, String> folderMap = new HashMap<String, String>();
        int i = 0;
        logger.debug(userName + "......folders.... " + folders.size());
        logger.debug("... files to process... " + currentPage.size());
        i = 0;
        DeviceBackupOverView deviceBackupOverView = this.getDeviceBackupOverViewForDevice(cloudId, deviceUUID);
        boolean isNewDevice = false;
        if (deviceBackupOverView != null && StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime())) {
            isNewDevice = true;
        }
        if (StringUtils.isEmpty((String)(userPrincId = this.getAzureUserId(emailId)))) {
            logger.error(".... user not found ..." + userName);
            return "";
        }
        MailFolderCollectionRequestBuilder mailFolders = MSServiceImpl.getGraphClient().users(userPrincId).mailFolders();
        logger.debug(mailFolders + ".. mail-folders..." + userName);
        String deltaLink = "";
        MailFolderDeltaCollectionPage deltaPage = null;
        if (isFullBackup) {
            deltaToken = "";
        }
        try {
            deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)mailFolders.delta().buildRequest(new Option[0])).get();
        }
        catch (GraphServiceException e2) {
            logger.error("...error trying to get folders..... " + e2.getResponseCode());
            return "ACCESS_DENIED";
        }
        boolean isNextPageExists = false;
        List mailcurrentPage = null;
        ArrayList listFolderItems = new ArrayList();
        ArrayList<Folder> archivelistFolderItems = new ArrayList<Folder>();
        do {
            mailcurrentPage = deltaPage.getCurrentPage();
            listFolderItems.addAll(mailcurrentPage);
            deltaLink = deltaPage.deltaLink();
            if (deltaLink == null) {
                deltaLink = ((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(SERVICE_ROOT, "");
            }
            deltaToken = MSServiceImpl.getDeltaToken(deltaLink);
            if (deltaPage.getNextPage() == null) break;
            deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).buildRequest(new Option[0])).get();
            ++i;
        } while (mailcurrentPage.size() > 0 && (isNextPageExists = true));
        logger.debug(deltaToken + "...total folders.. " + listFolderItems.size());
        logger.debug(userName + "...userNameval....inplacearchive flag.... " + oneDriveBackupPolicy.isInPlaceMailArchiveEnabled());
        ArrayList sublistItems = new ArrayList();
        HashMap<String, String> folderPathMap = new HashMap<String, String>();
        String rootId = this.getRootFolderId(userPrincId);
        listFolderItems.forEach(fol -> {
            MailFolder folderval = ((MailFolderRequestBuilder)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders().byId(fol.parentFolderId)).buildRequest(new Option[0]).get();
            if (folderval.id.equalsIgnoreCase(rootId)) {
                folderPathMap.put(fol.id, fol.displayName);
            }
            if (fol.childFolderCount > 0) {
                MSServiceImpl.addChildFolders(userPrincId, sublistItems, folderPathMap, fol);
            }
        });
        deltaToken = "";
        List cloudList = this.cloudDao.getAllClouds();
        Cloud cloud = (Cloud)cloudList.get(0);
        if (cloud.getMailRecoverableItemsEnabled() == 1) {
            MailFolder mailFolder = MSServiceImpl.getGraphClient().users(userPrincId).mailFolders("recoverableitemsdeletions").buildRequest(new Option[0]).get();
            folderPathMap.put(mailFolder.id, "Recoverable Items");
            mailFolder = MSServiceImpl.getGraphClient().users(userPrincId).mailFolders("RecoverableItemsPurges").buildRequest(new Option[0]).get();
            folderPathMap.put(mailFolder.id, "Purged Items");
        }
        HashMap<String, String> inplaceFolderPathMap = new HashMap();
        if (oneDriveBackupPolicy.isInPlaceMailArchiveEnabled()) {
            String token = this.getEWSToken(cloudId);
            ExchangeService service = MSServiceImpl.getAuthenticatedService(token, emailId);
            inplaceFolderPathMap = MSServiceImpl.getInPlaceArchiveFolders(service, emailId);
        }
        HashMap deltaMap = new HashMap();
        for (Map.Entry entry : folderPathMap.entrySet()) {
            if (!isFullBackup) {
                deltaToken = this.msUtilDao.getDeltaLinkForPathAndUser((String)entry.getValue(), userName);
            }
            logger.debug("...all paths....." + (String)entry.getValue() + "...." + deltaToken);
            deltaMap.put(entry.getValue(), deltaToken);
        }
        this.removeDeletedFolderFiles(cloudId, userName, deviceUUID, folderPathMap, deviceDestCollection, userPrincId, inplaceFolderPathMap);
        int totalCount = 0;
        int n = folderPathMap.size();
        int folderProcessed = 0;
        block31: for (Map.Entry entry : folderPathMap.entrySet()) {
            String parentPath;
            ++folderProcessed;
            logger.debug((String)entry.getValue() + "..allowedpathslatest check.. ");
            String folderId = (String)entry.getKey();
            MailFolder fol2 = null;
            try {
                fol2 = MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).buildRequest(new Option[0]).get();
            }
            catch (ClientException ee) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                fol2 = MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).buildRequest(new Option[0]).get();
            }
            String actualPath = parentPath = (String)entry.getValue();
            if (((String)entry.getValue()).contains("/")) {
                String[] parentPatharr = ((String)entry.getValue()).split("/");
                parentPath = parentPatharr[0];
            }
            boolean isFileAllowed = this.handleMailElement(actualPath, parentPath, oneDriveBackupPolicy, deviceUUID, userName, cloudId, false);
            logger.debug((String)entry.getValue() + "..." + isFileAllowed);
            if (!isFileAllowed) {
                logger.debug("...path cannot be allowed... " + fol2.displayName);
                continue;
            }
            folderMap.put(fol2.displayName, fol2.id);
            totalCount += fol2.totalItemCount.intValue();
            String messagesDelta = "";
            MessageDeltaCollectionPage iMessageDeltaCollectionPage = null;
            if (deltaMap.get(entry.getValue()) != null) {
                messagesDelta = (String)deltaMap.get(entry.getValue());
                messagesDelta = MSServiceImpl.getDeltaToken(messagesDelta);
            }
            if (isFullBackup) {
                messagesDelta = "";
            }
            int j = 0;
            LinkedList<HeaderOption> requestOptions = new LinkedList<HeaderOption>();
            requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=40"));
            try {
                if (StringUtils.isEmpty((String)messagesDelta)) {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
                } else {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptions).deltaToken(messagesDelta).select("id,from,toRecipients,body,subject").get();
                    logger.debug("... old delta... ..." + messagesDelta);
                }
            }
            catch (ClientException ee) {
                logger.debug(folderId + "...fol retry..." + fol2.displayName + "..." + fol2.id);
                if (!StringUtils.isEmpty((String)ee.getMessage()) && ee.getMessage().contains("SyncStateNotFound") | ee.getMessage().contains("SyncStateInvalid")) {
                    messagesDelta = "";
                }
                boolean crawlCompleted = false;
                int jk = 0;
                do {
                    try {
                        logger.error(userPrincId + "...com.microsoft.graph.core.ClientException wait for 30sec and retry byid so try for less mails 10 as option..." + ee.getMessage());
                        logger.error(folderProcessed + "/" + n + "...foldersprocessed ..." + ee.getMessage());
                        requestOptions = new LinkedList();
                        requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=40"));
                        try {
                            Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (StringUtils.isEmpty((String)messagesDelta)) {
                            iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
                            crawlCompleted = true;
                            continue;
                        }
                        logger.debug("... old delta... ..." + messagesDelta);
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptions).deltaToken(messagesDelta).select("id,from,toRecipients,body,subject").get();
                        crawlCompleted = true;
                    }
                    catch (ClientException eee) {
                        crawlCompleted = false;
                        if (++jk != 2) continue;
                        crawlCompleted = true;
                    }
                } while (!crawlCompleted);
            }
            logger.debug("....deltapage..." + iMessageDeltaCollectionPage);
            if (iMessageDeltaCollectionPage == null) continue;
            boolean isNextPageExistsv = false;
            String messDeltaLink = "";
            String nextRequestUrl = "";
            String prevRequestUrl = "";
            List currentPage2 = null;
            do {
                try {
                    currentPage2 = iMessageDeltaCollectionPage.getCurrentPage();
                    if (currentPage2 != null) {
                        logger.debug("....files for current page lat ..." + currentPage2.size());
                    } else {
                        logger.debug("....files for current page ..nuull...");
                    }
                    String path2 = fol2.displayName;
                    if (!StringUtils.isEmpty((String)((String)folderPathMap.get(fol2.id)))) {
                        path2 = (String)folderPathMap.get(fol2.id);
                    }
                    Map mailFilterMap = oneDriveBackupPolicy.getOutlookFilters();
                    HashSet<String> messageSet = new HashSet<String>();
                    HashSet<String> deletedMessageSet = new HashSet<String>();
                    for (Message message : currentPage2) {
                        boolean isFromAllowed = true;
                        boolean isToAllowed = true;
                        boolean isSubjectAllowed = true;
                        String fromVal = "";
                        String toVal = "";
                        String subject = "";
                        if (mailFilterMap != null && mailFilterMap.size() > 0) {
                            for (Map.Entry filterEntry : mailFilterMap.entrySet()) {
                                if ("from".equalsIgnoreCase((String)filterEntry.getKey())) {
                                    fromVal = (String)filterEntry.getValue();
                                }
                                if ("to".equalsIgnoreCase((String)filterEntry.getKey())) {
                                    toVal = (String)filterEntry.getValue();
                                }
                                if (!"subject".equalsIgnoreCase((String)filterEntry.getKey())) continue;
                                subject = (String)filterEntry.getValue();
                            }
                            if (!StringUtils.isEmpty((String)fromVal)) {
                                isFromAllowed = this.fromFilterCheck(message, fromVal);
                            }
                            if (!StringUtils.isEmpty((String)toVal)) {
                                isToAllowed = this.toFilterCheck(message, toVal);
                            }
                            if (!StringUtils.isEmpty((String)subject)) {
                                String[] subjectArr = subject.split(",");
                                List<Object> subjList = new ArrayList();
                                subjList = Arrays.asList(subjectArr);
                                if (!CollectionUtils.isEmpty(subjList)) {
                                    for (String string : subjList) {
                                        logger.debug(message.subject + "....sub..." + string);
                                        if (StringUtils.isEmpty((String)message.subject) || !MSServiceImpl.isContainExactWord(message.subject.toLowerCase(), string.toLowerCase())) continue;
                                        isSubjectAllowed = false;
                                    }
                                }
                            }
                        }
                        boolean isMailAllowed = true;
                        if (!StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)subject) && !isFromAllowed) {
                            isMailAllowed = false;
                        }
                        if (!StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)subject) && !isToAllowed) {
                            isMailAllowed = false;
                        }
                        if (!StringUtils.isEmpty((String)subject) && StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal) && !isSubjectAllowed) {
                            isMailAllowed = false;
                        }
                        if (!(StringUtils.isEmpty((String)subject) || StringUtils.isEmpty((String)toVal) || StringUtils.isEmpty((String)fromVal))) {
                            isMailAllowed = isSubjectAllowed || isToAllowed || isFromAllowed;
                        }
                        if (!StringUtils.isEmpty((String)subject) && !StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal)) {
                            isMailAllowed = isSubjectAllowed || isToAllowed;
                        }
                        if (!StringUtils.isEmpty((String)subject) && !StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)toVal)) {
                            isMailAllowed = isSubjectAllowed || isFromAllowed;
                        }
                        if (!StringUtils.isEmpty((String)toVal) && !StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)subject)) {
                            logger.debug(message.subject + "...fromto condition...." + isToAllowed + ".." + isFromAllowed);
                            isMailAllowed = isToAllowed || isFromAllowed;
                        }
                        logger.debug(".......check for link....." + isFullBackup + "...." + oneDriveBackupPolicy.isCreateMailLinkEnabled());
                        if (!isMailAllowed) continue;
                        boolean mailAllow = true;
                        if (!isFullBackup) {
                            BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, message.id, deviceDestCollection, deviceUUID);
                            mailAllow = backUpImageold != null ? oneDriveBackupPolicy.isCreateMailLinkEnabled() && !backUpImageold.isMailLinkGenerated() : true;
                        }
                        boolean isDeleted = false;
                        JsonElement jsonElement = (JsonElement)message.additionalDataManager().get((Object)"@removed");
                        if (jsonElement != null) {
                            isDeleted = true;
                        }
                        if (!mailAllow && !isDeleted) continue;
                        if (isDeleted) {
                            deletedMessageSet.add(message.id);
                            continue;
                        }
                        messageSet.add(message.id);
                    }
                    logger.debug(iMessageDeltaCollectionPage.deltaLink() + "....after iteraion..." + messageSet.size());
                    int currentFiles = this.processMessageList(messageSet, deletedMessageSet, deviceUUID, userName, cloudId, oneDriveBackupPolicy, isFullBackup, batchId, folderMap, i, path2, userPrincId, deviceDestCollection, eventHubId, isNewDevice);
                    noOfFiles += currentFiles;
                    logger.debug("......delataaftercrawl....." + iMessageDeltaCollectionPage.deltaLink());
                    if (iMessageDeltaCollectionPage != null && iMessageDeltaCollectionPage.getNextPage() != null && !StringUtils.isEmpty((String)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl())) {
                        this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl());
                    }
                    if (iMessageDeltaCollectionPage.getNextPage() == null) {
                        messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                        this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, messDeltaLink);
                        continue block31;
                    }
                    messDeltaLink = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                    nextRequestUrl = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                    String deltaTokenval = MSServiceImpl.getDeltaToken(nextRequestUrl);
                    logger.debug(folderProcessed + "/" + n + "....before calling next page ..." + noOfFiles + "..noofiles...." + deltaTokenval);
                    if (StringUtils.isEmpty((String)deltaTokenval)) {
                        logger.debug(".....NODELTA...." + messDeltaLink);
                        logger.debug(fol2.displayName + "...................$$CRAWLSTATUS$$............" + userName + "............ " + j + "..." + noOfFiles + "/" + totalCount);
                        continue block31;
                    }
                    try {
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptions).deltaToken(deltaTokenval).select("id,from,toRecipients,body,subject").get();
                    }
                    catch (ClientException ee) {
                        ee.printStackTrace();
                        boolean crawlCompleted = false;
                        do {
                            try {
                                logger.error(userPrincId + "...com.microsoft.graph.core.ClientException wait for 60 sec and retry byid so try for less mails 10 as option..." + ee.getMessage());
                                logger.error(folderProcessed + "/" + n + "...foldersprocessed stacktrace ..." + noOfFiles + "......" + ee.getMessage());
                                requestOptions = new LinkedList();
                                requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=40"));
                                try {
                                    Thread.sleep(60000L);
                                }
                                catch (InterruptedException isSubjectAllowed) {
                                    // empty catch block
                                }
                                if (StringUtils.isEmpty((String)deltaTokenval)) {
                                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
                                    crawlCompleted = true;
                                    continue;
                                }
                                logger.debug("... old delta... ..." + messagesDelta);
                                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptions).deltaToken(deltaTokenval).select("id,from,toRecipients,body,subject").get();
                                crawlCompleted = true;
                            }
                            catch (GraphServiceException eee) {
                                logger.error("...graph exception retry..." + eee.getResponseCode());
                                crawlCompleted = false;
                            }
                            catch (ClientException eee) {
                                logger.error("...Client  exception retry..." + eee.getMessage());
                                crawlCompleted = false;
                            }
                        } while (!crawlCompleted);
                    }
                    logger.debug("....end of calling next page ...");
                    if (iMessageDeltaCollectionPage.getNextPage() != null && !StringUtils.isEmpty((String)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl())) {
                        nextRequestUrl = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                    }
                    if (!StringUtils.isEmpty((String)nextRequestUrl)) {
                        prevRequestUrl = nextRequestUrl;
                    }
                    ++j;
                    if (currentPage2.size() <= 0) {
                        if (messDeltaLink == null) {
                            messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                        }
                        this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, messDeltaLink);
                        continue block31;
                    }
                    isNextPageExistsv = true;
                    logger.debug(fol2.displayName + "...................$$CRAWLSTATUS$$............" + userName + "............ " + j + "..." + noOfFiles + "/" + totalCount);
                }
                catch (GraphServiceException e) {
                    if (e.getResponseCode() == 401) {
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (InterruptedException mailFilterMap) {
                            // empty catch block
                        }
                    }
                    logger.debug(e.getResponseCode() + "...token waited ..." + nextRequestUrl);
                    if (StringUtils.isEmpty((String)nextRequestUrl)) {
                        nextRequestUrl = prevRequestUrl;
                    }
                    logger.debug("....trying after 401...." + emailId + "..." + userName + "...." + folderId);
                    if (StringUtils.isEmpty((String)nextRequestUrl)) {
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
                    } else {
                        logger.debug("... old delta1... ..." + nextRequestUrl);
                        String deltaTokenval = MSServiceImpl.getDeltaToken(nextRequestUrl);
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptions).deltaToken(deltaTokenval).select("id,from,toRecipients,body,subject").get();
                    }
                    logger.debug("...token waited11 ..." + nextRequestUrl);
                }
                catch (ClientException ee) {
                    ee.printStackTrace();
                    boolean isDeltaquerySucess = false;
                    do {
                        logger.debug(folderId + "....client exception eeeee wait for 5 sec... " + ee.getMessage());
                        logger.debug(nextRequestUrl + "....nextRequestUrl eeeee prevRequestUrl... " + prevRequestUrl);
                        logger.debug("....messDeltaLink... " + messDeltaLink);
                        try {
                            Thread.sleep(5000L);
                            if (StringUtils.isEmpty((String)nextRequestUrl)) {
                                nextRequestUrl = prevRequestUrl;
                            }
                            if (StringUtils.isEmpty((String)nextRequestUrl)) {
                                logger.debug("...no nextRequestUrl....");
                                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
                            } else {
                                logger.debug("... old delta1..new. ...");
                                String deltaTokenval = MSServiceImpl.getDeltaToken(nextRequestUrl);
                                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptions).deltaToken(deltaTokenval).select("id,from,toRecipients,body,subject").get();
                            }
                            isDeltaquerySucess = true;
                        }
                        catch (Exception e) {
                            isDeltaquerySucess = false;
                        }
                    } while (!isDeltaquerySucess);
                    logger.debug("...token waited11 ..." + nextRequestUrl);
                }
                catch (Exception eee) {
                    eee.printStackTrace();
                    logger.error("..broken.... " + eee.getMessage());
                    isNextPageExistsv = false;
                }
            } while (isNextPageExistsv);
        }
        folderMap.forEach((path, itemId) -> {
            logger.debug("path  : " + path + " itemId : " + itemId);
            FolderFileInfo folderFileInfo = new FolderFileInfo();
            folderFileInfo.setItemId(itemId);
            folderFileInfo.setItemPath(path);
            folderFileInfo.setDeviceUUID(backupBatch.getDeviceUUID());
            this.msUtilDao.saveFolderItem(folderFileInfo);
        });
        try {
            logger.debug(userName + "...userNameval....inplacearchive flag.... " + oneDriveBackupPolicy.isInPlaceMailArchiveEnabled());
            if (oneDriveBackupPolicy.isInPlaceMailArchiveEnabled()) {
                noOfFiles = this.handleEWSInPlaceMailArchive(userName, emailId, cloudId, MSServiceImpl.getGraphClient().users(userPrincId), archivelistFolderItems, noOfFiles, deviceUUID, batchId, userPrincId, eventHubId, deviceDestCollection, oneDriveBackupPolicy, isFullBackup);
            }
        }
        catch (Exception e) {
            logger.error("... error trying to crawl inplacearchive ...." + e.getMessage());
        }
        backupBatch.setId(new ObjectId(batchId));
        backupBatch.setStatus("COMPLETED");
        backupBatch.setNoOfFiles((long)noOfFiles);
        backupBatch.setTotalNoOfFiles("" + noOfFiles);
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + backupBatch.getId().toString());
        this.msUtilDao.updateBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
        logger.debug(folder + ".....folder + file......." + noOfFiles);
        logger.debug(".....nooffiles....." + noOfFiles);
        return deltaToken;
    }

    private boolean toFilterCheck(Message message, String toVal) {
        boolean isToAllowed = true;
        List<Object> toList = new ArrayList();
        List toRecipients = message.toRecipients;
        if (!CollectionUtils.isEmpty((Collection)toRecipients)) {
            String[] torecArr = toVal.split(",");
            if (torecArr != null) {
                toList = Arrays.asList(torecArr);
            }
            for (Recipient torec : toRecipients) {
                if (CollectionUtils.isEmpty(toList)) continue;
                for (String string : toList) {
                    String string2 = string.replace("*", "");
                    try {
                        if (!torec.emailAddress.address.contains(string2)) continue;
                        isToAllowed = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return isToAllowed;
    }

    private boolean fromFilterCheck(Message message, String fromVal) {
        boolean isFromAllowed = true;
        String[] fromValArr = fromVal.split(",");
        List<Object> fromList = new ArrayList();
        if (fromValArr != null && !CollectionUtils.isEmpty(fromList = Arrays.asList(fromValArr))) {
            for (String string : fromList) {
                String string2 = string.replace("*", "");
                try {
                    if (!message.from.emailAddress.address.contains(string2)) continue;
                    isFromAllowed = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return isFromAllowed;
    }

    private String handleModifiedMailItems(String deviceUUID, String userName, String emailId, int cloudId, OfficeBackupPolicy oneDriveBackupPolicy, boolean isFullBackup, String deviceDestCollection, String deltaToken, String eventHubId, long batchStartTime) {
        int folder = 0;
        int noOfFiles = 0;
        ODBBackupBatch backupBatch = new ODBBackupBatch();
        backupBatch.setDeviceUUID(deviceUUID);
        backupBatch.setUserName(userName);
        backupBatch.setNoOfFiles((long)noOfFiles);
        backupBatch.setBatchStartTimestamp(batchStartTime);
        backupBatch.setStatus("STARTED");
        String batchId = this.msUtilDao.saveBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
        ArrayList folders = new ArrayList();
        HashMap<String, String> folderMap = new HashMap<String, String>();
        DeviceBackupOverView deviceBackupOverView = this.getDeviceBackupOverViewForDevice(cloudId, deviceUUID);
        boolean isNewDevice = false;
        if (deviceBackupOverView != null && StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime())) {
            isNewDevice = true;
        }
        int i = 0;
        logger.debug(userName + "......folders.... " + folders.size());
        i = 0;
        String userPrincId = this.getAzureUserId(emailId);
        if (StringUtils.isEmpty((String)userPrincId)) {
            logger.error(".... user not found ..." + userName);
            return "";
        }
        MailFolderCollectionRequestBuilder mailFolders = MSServiceImpl.getGraphClient().users(userPrincId).mailFolders();
        logger.debug(".. mail folders..." + userName);
        String deltaLink = "";
        MailFolderDeltaCollectionPage deltaPage = null;
        if (isFullBackup) {
            deltaToken = "";
        }
        deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)mailFolders.delta().buildRequest(new Option[0])).get();
        boolean isNextPageExists = false;
        List mailcurrentPage = null;
        ArrayList listFolderItems = new ArrayList();
        ArrayList<Folder> archivelistFolderItems = new ArrayList<Folder>();
        do {
            mailcurrentPage = deltaPage.getCurrentPage();
            listFolderItems.addAll(mailcurrentPage);
            deltaLink = deltaPage.deltaLink();
            if (deltaLink == null) {
                deltaLink = ((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(SERVICE_ROOT, "");
            }
            deltaToken = MSServiceImpl.getDeltaToken(deltaLink);
            if (deltaPage.getNextPage() == null) break;
            deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).buildRequest(new Option[0])).get();
            ++i;
        } while (mailcurrentPage.size() > 0 && (isNextPageExists = true));
        logger.debug(deltaToken + "...total folders.. " + listFolderItems.size());
        logger.debug(userName + "...userNameval....inplacearchive flag.... " + oneDriveBackupPolicy.isInPlaceMailArchiveEnabled());
        if (oneDriveBackupPolicy.isInPlaceMailArchiveEnabled()) {
            noOfFiles = this.handleEWSInPlaceMailArchive(userName, emailId, cloudId, MSServiceImpl.getGraphClient().users(userPrincId), archivelistFolderItems, noOfFiles, deviceUUID, batchId, userPrincId, eventHubId, deviceDestCollection, oneDriveBackupPolicy, isFullBackup);
        }
        ArrayList sublistItems = new ArrayList();
        HashMap<String, String> folderPathMap = new HashMap<String, String>();
        String rootId = this.getRootFolderId(userPrincId);
        listFolderItems.forEach(fol -> {
            MailFolder folderval = ((MailFolderRequestBuilder)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders().byId(fol.parentFolderId)).buildRequest(new Option[0]).get();
            if (folderval.id.equalsIgnoreCase(rootId)) {
                folderPathMap.put(fol.id, fol.displayName);
            }
            if (fol.childFolderCount > 0) {
                MSServiceImpl.addChildFolders(userPrincId, sublistItems, folderPathMap, fol);
            }
        });
        List cloudList = this.cloudDao.getAllClouds();
        Cloud cloud = (Cloud)cloudList.get(0);
        if (cloud.getMailRecoverableItemsEnabled() == 1) {
            MailFolder mailFolder = MSServiceImpl.getGraphClient().users(userPrincId).mailFolders("recoverableitemsdeletions").buildRequest(new Option[0]).get();
            folderPathMap.put(mailFolder.id, "Recoverable Items");
            mailFolder = MSServiceImpl.getGraphClient().users(userPrincId).mailFolders("RecoverableItemsPurges").buildRequest(new Option[0]).get();
            folderPathMap.put(mailFolder.id, "Purged Items");
        }
        deltaToken = "";
        Map<String, String> inplaceFolderPathMap = new HashMap<String, String>();
        if (oneDriveBackupPolicy.isInPlaceMailArchiveEnabled()) {
            String token = this.getEWSToken(cloudId);
            ExchangeService service = MSServiceImpl.getAuthenticatedService(token, emailId);
            inplaceFolderPathMap = MSServiceImpl.getInPlaceArchiveFolders(service, emailId);
        }
        this.removeDeletedFolderFiles(cloudId, userName, deviceUUID, folderPathMap, deviceDestCollection, userPrincId, inplaceFolderPathMap);
        HashMap deltaMap = new HashMap();
        for (Map.Entry entry : folderPathMap.entrySet()) {
            logger.debug(isFullBackup + "..." + (String)entry.getValue() + "...all delta paths....." + (String)entry.getValue());
            if (!isFullBackup) {
                deltaToken = this.msUtilDao.getDeltaLinkForPathAndUser((String)entry.getValue(), userName);
            }
            logger.debug("...all paths....." + (String)entry.getValue() + "...." + deltaToken);
            deltaMap.put(entry.getValue(), deltaToken);
        }
        int totalCount = 0;
        block14: for (Map.Entry entry : folderPathMap.entrySet()) {
            String parentPath;
            logger.debug((String)entry.getValue() + "..allowedpaths check.. ");
            MailFolder fol2 = ((MailFolderRequestBuilder)mailFolders.byId((String)entry.getKey())).buildRequest(new Option[0]).get();
            String actualPath = parentPath = (String)entry.getValue();
            if (((String)entry.getValue()).contains("/")) {
                String[] parentPatharr = ((String)entry.getValue()).split("/");
                parentPath = parentPatharr[0];
            }
            boolean isFileAllowed = this.handleMailElement(actualPath, parentPath, oneDriveBackupPolicy, deviceUUID, userName, cloudId, false);
            logger.debug((String)entry.getValue() + "..." + isFileAllowed);
            if (!isFileAllowed) {
                logger.debug("...path cannot be allowed... " + fol2.displayName);
                continue;
            }
            folderMap.put(fol2.displayName, fol2.id);
            logger.debug(fol2.displayName + "..allowedpaths.. " + fol2.totalItemCount);
            totalCount += fol2.totalItemCount.intValue();
            logger.debug(".. fol id .. " + (String)entry.getKey());
            MailFolderRequestBuilder byId = null;
            String messagesDelta = "";
            MessageDeltaCollectionPage iMessageDeltaCollectionPage = null;
            if (deltaMap.get(entry.getValue()) != null) {
                messagesDelta = (String)deltaMap.get(entry.getValue());
                if (!StringUtils.isEmpty((String)messagesDelta) && messagesDelta.startsWith(SERVICE_ROOT)) {
                    String serviceRoot = " https://graph.microsoft.com";
                    messagesDelta = messagesDelta.replaceFirst(serviceRoot, "");
                }
                messagesDelta = MSServiceImpl.getDeltaToken(messagesDelta);
            }
            LinkedList<HeaderOption> requestOptions = new LinkedList<HeaderOption>();
            requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=40"));
            try {
                byId = (MailFolderRequestBuilder)mailFolders.byId((String)entry.getKey());
                if (StringUtils.isEmpty((String)messagesDelta)) {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders((String)entry.getKey()).messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
                } else {
                    byId = null;
                    logger.debug(fol2.displayName + "... old delta... ..." + messagesDelta);
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders((String)entry.getKey()).messages().delta().buildRequest(requestOptions).deltaToken(messagesDelta).select("id,from,toRecipients,body,subject").get();
                }
            }
            catch (GraphServiceException ee) {
                if (ee.getResponseCode() == 401) {
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (StringUtils.isEmpty((String)messagesDelta)) {
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders((String)entry.getKey()).messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
                    } else {
                        logger.debug("... old delta... ..." + messagesDelta);
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders((String)entry.getKey()).messages().delta().buildRequest(requestOptions).deltaToken(messagesDelta).select("id,from,toRecipients,body,subject").get();
                    }
                }
                logger.error("...response code ..." + ee.getResponseCode());
            }
            catch (ClientException ee) {
                logger.error(byId + "...com.microsoft.graph.core.ClientException wait for 20 sec and retry byid ..." + ee.getMessage());
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (StringUtils.isEmpty((String)messagesDelta)) {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders((String)entry.getKey()).messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
                }
                logger.debug("... old delta... ..." + messagesDelta);
                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)MSServiceImpl.getGraphClient().users(userPrincId).mailFolders((String)entry.getKey()).messages().delta().buildRequest(requestOptions).deltaToken(messagesDelta).select("id,from,toRecipients,body,subject").get();
            }
            Map mailFilterMap = oneDriveBackupPolicy.getOutlookFilters();
            boolean isNextPageExistsv = false;
            int j = 0;
            String messDeltaLink = "";
            String nextRequestUrl = "";
            List currentPage2 = null;
            do {
                try {
                    currentPage2 = iMessageDeltaCollectionPage.getCurrentPage();
                    if (currentPage2 != null) {
                        logger.debug("....files for current page ..." + currentPage2.size());
                    } else {
                        logger.debug("....files for current page ..nuull...");
                    }
                    String path2 = fol2.displayName;
                    if (!StringUtils.isEmpty((String)((String)folderPathMap.get(fol2.id)))) {
                        path2 = (String)folderPathMap.get(fol2.id);
                    }
                    HashSet<String> messageSet = new HashSet<String>();
                    HashSet<String> deletedMessageSet = new HashSet<String>();
                    for (Message message : currentPage2) {
                        boolean isFromAllowed = true;
                        boolean isToAllowed = true;
                        boolean isSubjectAllowed = true;
                        logger.debug(message.subject + "......message from.21.....");
                        String fromVal = "";
                        String toVal = "";
                        String subject = "";
                        if (mailFilterMap != null && mailFilterMap.size() > 0) {
                            for (Map.Entry filterEntry : mailFilterMap.entrySet()) {
                                if ("from".equalsIgnoreCase((String)filterEntry.getKey())) {
                                    fromVal = (String)filterEntry.getValue();
                                }
                                if ("to".equalsIgnoreCase((String)filterEntry.getKey())) {
                                    toVal = (String)filterEntry.getValue();
                                }
                                if (!"subject".equalsIgnoreCase((String)filterEntry.getKey())) continue;
                                subject = (String)filterEntry.getValue();
                            }
                            logger.debug(fromVal + "......mailfilter..latest........." + toVal + "...." + subject);
                            if (!StringUtils.isEmpty((String)fromVal)) {
                                isFromAllowed = this.fromFilterCheck(message, fromVal);
                            }
                            if (!StringUtils.isEmpty((String)toVal)) {
                                isToAllowed = this.toFilterCheck(message, toVal);
                            }
                            if (!StringUtils.isEmpty((String)subject)) {
                                String[] subjectArr = subject.split(",");
                                List<Object> subjList = new ArrayList();
                                subjList = Arrays.asList(subjectArr);
                                if (!CollectionUtils.isEmpty(subjList)) {
                                    for (String string : subjList) {
                                        logger.debug(message.subject + "....sub..." + string);
                                        if (StringUtils.isEmpty((String)message.subject) || !MSServiceImpl.isContainExactWord(message.subject.toLowerCase(), string.toLowerCase())) continue;
                                        isSubjectAllowed = false;
                                    }
                                }
                            }
                        }
                        boolean isMailAllowed = true;
                        if (!StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)subject) && !isFromAllowed) {
                            isMailAllowed = false;
                        }
                        if (!StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)subject) && !isToAllowed) {
                            isMailAllowed = false;
                        }
                        if (!StringUtils.isEmpty((String)subject) && StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal) && !isSubjectAllowed) {
                            isMailAllowed = false;
                        }
                        if (!(StringUtils.isEmpty((String)subject) || StringUtils.isEmpty((String)toVal) || StringUtils.isEmpty((String)fromVal))) {
                            isMailAllowed = isSubjectAllowed || isToAllowed || isFromAllowed;
                        }
                        if (!StringUtils.isEmpty((String)subject) && !StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal)) {
                            isMailAllowed = isSubjectAllowed || isToAllowed;
                        }
                        if (!StringUtils.isEmpty((String)subject) && !StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)toVal)) {
                            isMailAllowed = isSubjectAllowed || isFromAllowed;
                        }
                        if (!StringUtils.isEmpty((String)toVal) && !StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)subject)) {
                            logger.debug(message.subject + "...fromto condition...." + isToAllowed + ".." + isFromAllowed);
                            isMailAllowed = isToAllowed || isFromAllowed;
                        }
                        if (!isMailAllowed) {
                            logger.debug(isFromAllowed + ".." + isToAllowed + ".." + isSubjectAllowed + "...subject.." + message.subject);
                            continue;
                        }
                        logger.debug(isFromAllowed + ".." + isToAllowed + ".." + isSubjectAllowed + "...subjectre.." + message.subject);
                        boolean isDeleted = false;
                        JsonElement jsonElement = (JsonElement)message.additionalDataManager().get((Object)"@removed");
                        if (jsonElement != null) {
                            isDeleted = true;
                        }
                        if (isDeleted) {
                            deletedMessageSet.add(message.id);
                            continue;
                        }
                        messageSet.add(message.id);
                    }
                    int currentFiles = this.processMessageList(messageSet, deletedMessageSet, deviceUUID, userName, cloudId, oneDriveBackupPolicy, isFullBackup, batchId, folderMap, i, path2, userPrincId, deviceDestCollection, eventHubId, isNewDevice);
                    noOfFiles += currentFiles;
                    messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                    if (iMessageDeltaCollectionPage != null && iMessageDeltaCollectionPage.getNextPage() != null && !StringUtils.isEmpty((String)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl())) {
                        this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl());
                    }
                    if (iMessageDeltaCollectionPage.getNextPage() == null) {
                        messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                        this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, messDeltaLink);
                        continue block14;
                    }
                    if ((iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get()).getNextPage() != null && !StringUtils.isEmpty((String)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl())) {
                        nextRequestUrl = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                    }
                    ++j;
                    if (currentPage2.size() <= 0) {
                        if (messDeltaLink == null) {
                            messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                        }
                        this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, messDeltaLink);
                        continue block14;
                    }
                    isNextPageExistsv = true;
                    logger.debug(fol2.displayName + ".... " + j + "..." + noOfFiles + "/" + totalCount);
                }
                catch (GraphServiceException e) {
                    if (e.getResponseCode() == 401) {
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    logger.debug("...token waited ..." + nextRequestUrl);
                    byId = this.getMailFolders(cloudId, userName, (String)entry.getKey(), MSServiceImpl.getGraphClient());
                    if (StringUtils.isEmpty((String)nextRequestUrl)) {
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)byId.messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
                    } else {
                        byId = null;
                        logger.debug("... old delta1... ..." + messDeltaLink);
                    }
                    logger.debug("...token waited11 ..." + nextRequestUrl);
                }
                catch (Exception eee) {
                    logger.error("..broken.... " + eee.getMessage());
                }
            } while (isNextPageExistsv);
        }
        if (cloud.getMailRecoverableItemsEnabled() == 1) {
            MailFolder mailFolder = MSServiceImpl.getGraphClient().users(userPrincId).mailFolders("recoverableitemsdeletions").buildRequest(new Option[0]).get();
            this.handleDeletedMails(deviceUUID, userName, emailId, cloudId, deviceDestCollection, mailFolders, mailFolder);
        }
        if (oneDriveBackupPolicy.isContactsEnabled()) {
            // empty if block
        }
        if (oneDriveBackupPolicy.isTasksEnabled()) {
            // empty if block
        }
        folderMap.forEach((path, itemId) -> {
            FolderFileInfo folderFileInfo = new FolderFileInfo();
            folderFileInfo.setItemId(itemId);
            folderFileInfo.setItemPath(path);
            folderFileInfo.setDeviceUUID(backupBatch.getDeviceUUID());
            this.msUtilDao.saveFolderItem(folderFileInfo);
        });
        backupBatch.setId(new ObjectId(batchId));
        backupBatch.setStatus("COMPLETED");
        backupBatch.setNoOfFiles((long)noOfFiles);
        backupBatch.setTotalNoOfFiles("" + noOfFiles);
        backupBatch.setBatchStartTimestamp(batchStartTime);
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + backupBatch.getId().toString());
        this.msUtilDao.updateBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
        logger.debug(folder + ".....folder + file......." + noOfFiles);
        logger.debug(".....nooffiles....." + noOfFiles);
        return deltaToken;
    }

    private Set<String> getDeletedFolderList(String userName, Map<String, String> folderPathMap) {
        HashSet<String> delFolderMap = new HashSet<String>();
        List list = this.msUtilDao.getAllDeltaLinkUser(userName);
        HashSet<String> newFolderMap = new HashSet<String>();
        for (Map.Entry<String, String> entry : folderPathMap.entrySet()) {
            newFolderMap.add(entry.getKey());
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (DeltaPath deltaPath : list) {
                if (newFolderMap.contains(deltaPath.getPath())) continue;
                delFolderMap.add(deltaPath.getPath());
            }
        }
        return delFolderMap;
    }

    private int findContacts1(String deviceUUID, String userName, int cloudId, boolean isFullBackup, int noOfFiles, String batchId, User userFound, String deviceDestCollection, String eventHubId) {
        List<String> contactsList = this.crawlContacts(cloudId, userFound.id, userName, isFullBackup);
        List oldList = this.msUtilDao.getExistingContactsList(cloudId, userName);
        ArrayList<DriveFileInfo> driveList = new ArrayList<DriveFileInfo>();
        ArrayList<CrawlDeltaFileInfo> crawldriveList = new ArrayList<CrawlDeltaFileInfo>();
        ArrayList<String> existingIds = new ArrayList<String>();
        for (String contact : contactsList) {
            boolean alreadyExists = oldList.stream().anyMatch(item -> contact.equals(item.getItemId()));
            if (alreadyExists) {
                existingIds.add(contact);
            }
            logger.debug("... contact details ... " + contact);
            DriveFileInfo driveFileInfo = new DriveFileInfo();
            driveFileInfo.setDeviceUUID(deviceUUID);
            driveFileInfo.setBackupBatchId(batchId);
            driveFileInfo.setItemPath("Contacts");
            driveFileInfo.setItemId(contact);
            driveFileInfo.setUserName(userName);
            driveFileInfo.setContact(true);
            driveFileInfo.setOperation("FILE");
            driveFileInfo.setGraphUserId(userFound.id);
            CrawlDeltaFileInfo crawlDeltaFileInfo = new CrawlDeltaFileInfo();
            BeanUtils.copyProperties((Object)driveFileInfo, (Object)crawlDeltaFileInfo);
            driveList.add(driveFileInfo);
            crawldriveList.add(crawlDeltaFileInfo);
            ++noOfFiles;
        }
        if (!CollectionUtils.isEmpty((Collection)oldList)) {
            for (CrawlDeltaFileInfo crawlDeltaFileInfo : oldList) {
                try {
                    boolean alreadyExists = existingIds.stream().anyMatch(item -> crawlDeltaFileInfo.getItemId().equals(item));
                    if (!alreadyExists) continue;
                    this.msUtilDao.deleteBackupImageForItemId(cloudId, crawlDeltaFileInfo.getItemId(), deviceDestCollection);
                    this.msUtilDao.deleteCrawlInfo(cloudId, crawlDeltaFileInfo.getId());
                }
                catch (Exception e) {
                    logger.error("... unable to delete tasks ..." + e.getMessage());
                }
            }
        }
        this.msUtilDao.saveBulkDriveItem(cloudId, driveList, crawldriveList);
        this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
        return noOfFiles;
    }

    private int findTasks1(String deviceUUID, String userName, int cloudId, boolean isFullBackup, int noOfFiles, String batchId, User userFound, String deviceDestCollection, String eventHubId) {
        List<String> contactsList = this.crawlTasks(cloudId, userFound.id, userName, isFullBackup);
        ArrayList<DriveFileInfo> driveList = new ArrayList<DriveFileInfo>();
        ArrayList<CrawlDeltaFileInfo> crawldriveList = new ArrayList<CrawlDeltaFileInfo>();
        List oldList = this.msUtilDao.getExistingTasksList(cloudId, userName);
        logger.debug("....existingids list ...");
        if (!CollectionUtils.isEmpty((Collection)oldList)) {
            logger.debug("....existingids list size..." + oldList.size());
        }
        ArrayList<String> existingIds = new ArrayList<String>();
        for (String contact : contactsList) {
            boolean alreadyExists = oldList.stream().anyMatch(item -> contact.equals(item.getItemId()));
            if (alreadyExists) {
                existingIds.add(contact);
                continue;
            }
            logger.debug(alreadyExists + "... task details1 ... " + contact);
            DriveFileInfo driveFileInfo = new DriveFileInfo();
            driveFileInfo.setDeviceUUID(deviceUUID);
            driveFileInfo.setBackupBatchId(batchId);
            driveFileInfo.setItemPath("Tasks");
            driveFileInfo.setItemId(contact);
            driveFileInfo.setUserName(userName);
            driveFileInfo.setTasks(true);
            driveFileInfo.setOperation("FILE");
            driveFileInfo.setGraphUserId(userFound.id);
            CrawlDeltaFileInfo crawlDeltaFileInfo = new CrawlDeltaFileInfo();
            BeanUtils.copyProperties((Object)driveFileInfo, (Object)crawlDeltaFileInfo);
            driveList.add(driveFileInfo);
            crawldriveList.add(crawlDeltaFileInfo);
            ++noOfFiles;
        }
        if (!CollectionUtils.isEmpty((Collection)oldList)) {
            for (CrawlDeltaFileInfo crawlDeltaFileInfo : oldList) {
                try {
                    BackUpImage backUpImageold;
                    boolean alreadyExists = existingIds.stream().anyMatch(item -> crawlDeltaFileInfo.getItemId().equals(item));
                    if (alreadyExists || (backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, crawlDeltaFileInfo.getItemId(), deviceDestCollection, deviceUUID)) == null) continue;
                    BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                    this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                    this.msUtilDao.deleteCrawlInfo(cloudId, crawlDeltaFileInfo.getId());
                }
                catch (Exception e) {
                    logger.error("... unable to delete tasks ..." + e.getMessage());
                }
            }
        }
        this.msUtilDao.saveBulkDriveItem(cloudId, driveList, crawldriveList);
        this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
        return noOfFiles;
    }

    private static List<Folder> findAllSubFolders(ExchangeService service, FolderId parentFolderId, String parentPath, List<Folder> archivelistFolderItems, Map<String, String> folderPathMap) {
        try {
            FindFoldersResults foundFolders = service.findFolders(parentFolderId, new FolderView(Integer.MAX_VALUE));
            for (Folder subFolder : foundFolders) {
                String path = IN_PLACE_ARCHIVE + parentPath + "/" + subFolder.getDisplayName();
                logger.debug("...before replacepath..." + path);
                path = path.replaceAll(IN_PLACE_ARCHIVE, "");
                for (int i = 0; i < 15; ++i) {
                    if (!path.startsWith("/")) continue;
                    path = path.replaceFirst("/", "");
                }
                logger.debug("...after replacepath..." + path);
                path = IN_PLACE_ARCHIVE + path;
                logger.debug(path + ".....folder...." + subFolder.getDisplayName());
                archivelistFolderItems.add(subFolder);
                folderPathMap.put(subFolder.getId().getUniqueId(), path);
                MSServiceImpl.findAllSubFolders(service, subFolder.getId(), path, archivelistFolderItems, folderPathMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return archivelistFolderItems;
    }

    private int handleEWSInPlaceMailArchive(String userName, String emailId, int cloudId, UserRequestBuilder users, List<Folder> archivelistFolderItems, int noOfFiles, String deviceUUID, String batchId, String userFoundId, String eventHubId, String deviceDestCollection, OfficeBackupPolicy officeBackupPolicy, boolean isFullBkp) {
        logger.debug("....handleEWSInPlaceMailArchive....." + emailId);
        ArrayList<DriveFileInfo> driveList = new ArrayList<DriveFileInfo>();
        ArrayList<CrawlDeltaFileInfo> crawldriveList = new ArrayList<CrawlDeltaFileInfo>();
        String token = this.getEWSToken(cloudId);
        ExchangeService service = MSServiceImpl.getAuthenticatedService(token, emailId);
        Mailbox userMailbox = new Mailbox(emailId);
        logger.debug(userName + "...user maillate ...." + userMailbox);
        FolderId folderId = new FolderId(WellKnownFolderName.ArchiveMsgFolderRoot, userMailbox);
        FindFoldersResults inPlaceFolders = null;
        HashMap deltaMap = new HashMap();
        HashMap<String, String> folderPathMap = new HashMap<String, String>();
        try {
            logger.debug("....before service findfolders....." + userMailbox);
            boolean isInPlaceEnabled = true;
            try {
                inPlaceFolders = service.findFolders(folderId, new FolderView(Integer.MAX_VALUE));
            }
            catch (ServiceResponseException exception) {
                Thread.sleep(15000L);
                token = this.getEWSToken(cloudId);
                service = MSServiceImpl.getAuthenticatedService(token, emailId);
                inPlaceFolders = service.findFolders(folderId, new FolderView(Integer.MAX_VALUE));
                isInPlaceEnabled = false;
            }
            if (!isInPlaceEnabled) {
                logger.error(".....inplace archive disabled ");
                return 0;
            }
            logger.debug(".....parent archive ... " + folderId.getUniqueId());
            LinkedList<String> inputIdsList = new LinkedList<String>();
            for (Folder folder : inPlaceFolders.getFolders()) {
                if (StringUtils.isEmpty((String)folder.getDisplayName()) || "PersonMetadata".equalsIgnoreCase(folder.getDisplayName()) || "Tasks".equalsIgnoreCase(folder.getDisplayName()) || "Calendar".equalsIgnoreCase(folder.getDisplayName())) continue;
                inputIdsList.add(folder.getId().getUniqueId());
                archivelistFolderItems.add(folder);
                folderPathMap.put(folder.getId().getUniqueId(), IN_PLACE_ARCHIVE + folder.getDisplayName());
                MSServiceImpl.findAllSubFolders(service, folder.getId(), folder.getDisplayName(), archivelistFolderItems, folderPathMap);
            }
            logger.debug("......inplace after ... " + archivelistFolderItems.size());
            HashSet<String> idSet = new HashSet<String>();
            int ijj = 0;
            for (Folder folder : archivelistFolderItems) {
                String parentPath;
                String folPath = (String)folderPathMap.get(folder.getId().getUniqueId());
                logger.debug("...iteratingfoldpathlatest..." + ijj + "..." + folPath);
                String actualPath = parentPath = folPath;
                if (folPath.contains("/")) {
                    String[] parentPatharr = folPath.split("/");
                    parentPath = "/" + parentPatharr[0];
                }
                logger.debug(actualPath + "..trying path...." + parentPath);
                boolean isFileAllowed = this.handleMailElement(actualPath, parentPath, officeBackupPolicy, deviceUUID, userName, cloudId, true);
                logger.debug(folPath + "..." + isFileAllowed);
                if (!isFileAllowed) {
                    logger.debug("...path cannot be allowed... " + folPath);
                    continue;
                }
                ++ijj;
                idSet.add(folder.getId().getUniqueId());
            }
            int ifol = 0;
            int ifolderFiles = 0;
            for (String folderUniqueId : idSet) {
                ifolderFiles = 0;
                boolean hasMoreItems = false;
                String folPath = (String)folderPathMap.get(folderUniqueId);
                logger.debug(++ifol + "/" + archivelistFolderItems.size() + ".... startfolder .... " + folPath);
                String syncState = "";
                if (!isFullBkp) {
                    syncState = this.msUtilDao.getDeltaLinkForPathAndUser(folPath, userName);
                }
                Iterator iterator = null;
                logger.debug(folPath + ".....delta-token....." + syncState);
                do {
                    token = this.getEWSToken(cloudId);
                    service = MSServiceImpl.getAuthenticatedService(token, emailId);
                    ChangeCollection syncFolderItems = null;
                    try {
                        syncFolderItems = service.syncFolderItems(new FolderId(folderUniqueId), PropertySet.FirstClassProperties, null, 400, SyncFolderItemsScope.NormalItems, syncState);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("...error parsing token for folder retry after 15 sec  " + folPath);
                        try {
                            Thread.sleep(45000L);
                            token = this.getEWSToken(cloudId);
                            service = MSServiceImpl.getAuthenticatedService(token, emailId);
                            syncFolderItems = service.syncFolderItems(new FolderId(folderUniqueId), PropertySet.FirstClassProperties, null, 510, SyncFolderItemsScope.NormalItems, syncState);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (syncFolderItems == null) {
                        int i = 0;
                        do {
                            try {
                                logger.debug(i + "...wait for 20 sec...." + emailId);
                                Thread.sleep(20000L);
                                token = this.getEWSToken(cloudId);
                                service = MSServiceImpl.getAuthenticatedService(token, emailId);
                                syncFolderItems = service.syncFolderItems(new FolderId(folderUniqueId), PropertySet.FirstClassProperties, null, 510, SyncFolderItemsScope.NormalItems, syncState);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        } while (syncFolderItems == null && ++i < 5);
                    }
                    if (syncFolderItems == null) continue;
                    syncState = syncFolderItems.getSyncState();
                    logger.debug(folPath + "......inplace after ... " + noOfFiles);
                    iterator = syncFolderItems.iterator();
                    hasMoreItems = iterator.hasNext();
                    int i = 0;
                    while (iterator.hasNext()) {
                        ItemChange next = (ItemChange)iterator.next();
                        Item item = next.getItem();
                        if (item == null) {
                            String deletedItemId = next.getItemId().getUniqueId();
                            logger.error("...item is deleted....." + deletedItemId);
                            BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, deletedItemId, deviceDestCollection, deviceUUID);
                            if (backUpImageold == null) continue;
                            BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                            this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                            continue;
                        }
                        logger.debug(item.getSubject() + "....item state...." + ifol + "/" + archivelistFolderItems.size());
                        DriveFileInfo driveFileInfo = new DriveFileInfo();
                        driveFileInfo.setDeviceUUID(deviceUUID);
                        driveFileInfo.setBackupBatchId(batchId);
                        driveFileInfo.setItemPath(folPath);
                        driveFileInfo.setItemId(item.getId().getUniqueId());
                        driveFileInfo.setUserName(userName);
                        driveFileInfo.setUserMailId(emailId);
                        driveFileInfo.setInPlaceArchive(true);
                        driveFileInfo.setOperation("FILE");
                        driveFileInfo.setGraphUserId(userFoundId);
                        driveList.add(driveFileInfo);
                        ++ifolderFiles;
                        CrawlDeltaFileInfo crawlDeltaFileInfo = new CrawlDeltaFileInfo();
                        BeanUtils.copyProperties((Object)driveFileInfo, (Object)crawlDeltaFileInfo);
                        crawldriveList.add(crawlDeltaFileInfo);
                        ++noOfFiles;
                        ++i;
                    }
                    logger.debug(noOfFiles + "....files processed...." + i);
                    if (service != null) {
                        service.close();
                    }
                    this.msUtilDao.updateDeltaForPathAndUser(folPath, userName, syncState);
                    logger.debug(".... before bulk save ...." + noOfFiles);
                    this.msUtilDao.saveBulkDriveItem(cloudId, driveList, crawldriveList);
                    this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
                    logger.debug(folPath + ".... after bulk save ...." + ifolderFiles);
                    crawldriveList = new ArrayList();
                    driveList = new ArrayList();
                } while (hasMoreItems);
                logger.debug(folPath + "........folderfilesews...." + ifolderFiles);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("....error trying to get inplace archive folders ...." + e.getMessage());
        }
        return noOfFiles;
    }

    private void handleDeletedMails(String deviceUUID, String userName, String emailId, int cloudId, String deviceDestCollection, MailFolderCollectionRequestBuilder mailFolders, MailFolder fol) {
        logger.debug("...handle deleted mails...");
        logger.debug(fol.displayName + "..allowedpaths.. " + fol.totalItemCount);
        MailFolderRequestBuilder byId = null;
        String messagesDelta = this.msUtilDao.getDeltaLinkForPathAndUser(fol.displayName, userName);
        messagesDelta = MSServiceImpl.getDeltaToken(messagesDelta);
        MessageDeltaCollectionPage iMessageDeltaCollectionPage = null;
        LinkedList<HeaderOption> requestOptions = new LinkedList<HeaderOption>();
        requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=40"));
        try {
            byId = (MailFolderRequestBuilder)mailFolders.byId(fol.id);
            if (StringUtils.isEmpty((String)messagesDelta)) {
                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)byId.messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
            } else {
                logger.debug(fol.displayName + "... old delta... ..." + messagesDelta);
                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)byId.messages().delta().buildRequest(requestOptions).deltaToken(messagesDelta).select("id,from,toRecipients,body,subject").get();
            }
        }
        catch (GraphServiceException ee) {
            if (ee.getResponseCode() == 401) {
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (StringUtils.isEmpty((String)messagesDelta)) {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)byId.messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
                } else {
                    logger.debug("... old delta... ..." + messagesDelta);
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)byId.messages().delta().buildRequest(requestOptions).deltaToken(messagesDelta).select("id,from,toRecipients,body,subject").get();
                }
            }
            logger.error("...response code ..." + ee.getResponseCode());
        }
        boolean isNextPageExistsv = false;
        int j = 0;
        String messDeltaLink = "";
        String nextRequestUrl = "";
        List currentPage2 = null;
        do {
            if (iMessageDeltaCollectionPage == null) continue;
            try {
                currentPage2 = iMessageDeltaCollectionPage.getCurrentPage();
                if (currentPage2 != null) {
                    logger.debug("....files for current page delete ..." + currentPage2.size());
                } else {
                    logger.debug("....files for current page ..nuull...");
                }
                for (Message deletedMessage : currentPage2) {
                    try {
                        logger.debug(".....delete file...." + deletedMessage.id);
                        BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, deletedMessage.id, deviceDestCollection, deviceUUID);
                        if (backUpImageold == null) continue;
                        BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                        this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                    }
                    catch (Exception e) {
                        logger.error(".... unable to delete..... " + e.getMessage());
                    }
                }
                messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                if (iMessageDeltaCollectionPage.getNextPage() == null) {
                    this.msUtilDao.updateDeltaForPathAndUser(fol.displayName, userName, messDeltaLink);
                    break;
                }
                if ((iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get()).getNextPage() != null && !StringUtils.isEmpty((String)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl())) {
                    nextRequestUrl = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                }
                ++j;
                if (currentPage2.size() <= 0) {
                    if (messDeltaLink == null) {
                        messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                    }
                    this.msUtilDao.updateDeltaForPathAndUser(fol.displayName, userName, messDeltaLink);
                    break;
                }
                isNextPageExistsv = true;
            }
            catch (GraphServiceException e) {
                if (e.getResponseCode() == 401) {
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                logger.debug("...token waited ..." + nextRequestUrl);
                byId = this.getMailFolders(cloudId, userName, fol.id, MSServiceImpl.getGraphClient());
                if (StringUtils.isEmpty((String)nextRequestUrl)) {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)byId.messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
                } else {
                    logger.debug("... old delta1... ..." + messDeltaLink);
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)byId.messages().delta().buildRequest(requestOptions).deltaToken(messagesDelta).select("id,from,toRecipients,body,subject").get();
                }
                logger.debug("...token waited11 ..." + nextRequestUrl);
            }
            catch (Exception eee) {
                eee.printStackTrace();
                logger.error("..broken.... " + eee.getMessage());
            }
        } while (isNextPageExistsv);
    }

    private int processMessageList(Set<String> messageSet, Set<String> deletedMessageSet, String deviceUUID, String userName, int cloudId, OfficeBackupPolicy oneDriveBackupPolicy, boolean isFullBackup, String batchId, Map<String, String> folderMap, int i, String mailPath, String graphUserId, String deviceDestCollection, String eventHubId, boolean isNewDevice) {
        ArrayList<DriveFileInfo> driveList = new ArrayList<DriveFileInfo>();
        int noOfFiles = 0;
        ArrayList<CrawlDeltaFileInfo> crawldriveList = new ArrayList<CrawlDeltaFileInfo>();
        for (String msgId : messageSet) {
            ++i;
            String basePath = "";
            boolean isPresent = true;
            BackUpImage backUpImageold = null;
            if (isNewDevice) {
                backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, msgId, deviceDestCollection, deviceUUID);
            }
            if (backUpImageold != null && !isFullBackup) {
                BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                continue;
            }
            DriveFileInfo driveFileInfo = new DriveFileInfo();
            driveFileInfo.setDeviceUUID(deviceUUID);
            String folderPath = BASE_FOLDER + basePath;
            driveFileInfo.setItemPath(mailPath);
            driveFileInfo.setItemId(msgId);
            driveFileInfo.setFolder(false);
            driveFileInfo.setFilePresent(isPresent);
            driveFileInfo.setOperation("FILE");
            driveFileInfo.setBackupBatchId(batchId);
            driveFileInfo.setMail(true);
            driveFileInfo.setFullBackup(isFullBackup);
            driveFileInfo.setGraphUserId(graphUserId);
            String folderItemId = "";
            if (folderMap.get(folderPath) != null) {
                folderItemId = folderMap.get(folderPath);
            }
            driveFileInfo.setParentItemId(folderItemId);
            driveFileInfo.setUserName(userName);
            CrawlDeltaFileInfo crawlDeltaFileInfo = new CrawlDeltaFileInfo();
            BeanUtils.copyProperties((Object)driveFileInfo, (Object)crawlDeltaFileInfo);
            driveList.add(driveFileInfo);
            crawldriveList.add(crawlDeltaFileInfo);
            ++noOfFiles;
        }
        logger.debug(noOfFiles + ".... before bulk save ...." + crawldriveList.size());
        this.msUtilDao.saveBulkDriveItem(cloudId, driveList, crawldriveList);
        this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
        logger.debug(".... after bulk save ....");
        for (String msgId : deletedMessageSet) {
            logger.debug("..deleted message list .... " + msgId);
            BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, msgId, deviceDestCollection, deviceUUID);
            if (backUpImageold == null || isFullBackup) continue;
            BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
            this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
        }
        return noOfFiles;
    }

    private String handleModifiedPolicyItems(List<DriveItem> newItems, List<DriveItem> deletedItems, String deviceUUID, String userName, int cloudId, OfficeBackupPolicy oneDriveBackupPolicy, String deviceDestCollection, String eventHubId, long batchStartTime) {
        int file = 0;
        int folder = 0;
        int noOfFiles = 0;
        int totalSizeToUpload = 0;
        ODBBackupBatch backupBatch = new ODBBackupBatch();
        backupBatch.setDeviceUUID(deviceUUID);
        backupBatch.setUserName(userName);
        backupBatch.setNoOfFiles((long)noOfFiles);
        backupBatch.setStatus("STARTED");
        String batchId = this.msUtilDao.saveBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
        ArrayList folders = new ArrayList();
        for (DriveItem deletedItem : deletedItems) {
            try {
                BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, deletedItem.id, deviceDestCollection, deviceUUID);
                if (backUpImageold == null) continue;
                BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
            }
            catch (Exception e) {
                logger.error(".... unable to delete..... " + e.getMessage());
            }
        }
        for (DriveItem driveItem : newItems) {
            String parentPath;
            logger.debug("...ssitems.val.. " + driveItem);
            boolean isFile = false;
            if (driveItem.file != null) {
                isFile = true;
            }
            boolean isFolder = false;
            if (driveItem.folder != null) {
                isFolder = true;
            }
            String basePath = "";
            boolean isPresent = true;
            String itemName = driveItem.name;
            if (!StringUtils.isEmpty((String)driveItem.name) && driveItem.name.equalsIgnoreCase("root")) {
                logger.debug("...rooot vaal so skip...");
                continue;
            }
            if (driveItem.folder != null) continue;
            if (driveItem.folder != null && !StringUtils.isEmpty((String)itemName) && !driveItem.name.equalsIgnoreCase("root")) {
                logger.debug("..folder.." + driveItem.name + "...." + driveItem.folder.childCount);
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                String newPath = parentPath + "/" + driveItem.name;
                logger.debug(parentPath + "..... folder to be added .... " + newPath);
                ++folder;
            } else if (driveItem.file != null) {
                ++file;
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
            }
            DriveFileInfo driveFileInfo = new DriveFileInfo();
            driveFileInfo.setDeviceUUID(deviceUUID);
            driveFileInfo.setItemPath(BASE_FOLDER + basePath);
            driveFileInfo.setItemName(itemName);
            driveFileInfo.setItemId(driveItem.id);
            driveFileInfo.setFolder(isFolder);
            driveFileInfo.setFilePresent(isPresent);
            driveFileInfo.setOperation("FILE");
            driveFileInfo.setBackupBatchId(batchId);
            driveFileInfo.setFullBackup(false);
            if (driveItem.parentReference != null) {
                driveFileInfo.setParentItemId(driveItem.parentReference.id);
            }
            driveFileInfo.setUserName(userName);
            driveFileInfo.setSize(driveItem.size);
            totalSizeToUpload += driveItem.size.intValue();
            CrawlDeltaFileInfo crawlDeltaFileInfo = new CrawlDeltaFileInfo();
            BeanUtils.copyProperties((Object)driveFileInfo, (Object)crawlDeltaFileInfo);
            this.msUtilDao.saveDriveItem(cloudId, driveFileInfo, crawlDeltaFileInfo);
            this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
            ++noOfFiles;
        }
        backupBatch.setId(new ObjectId(batchId));
        backupBatch.setStatus("COMPLETED");
        backupBatch.setNoOfFiles((long)noOfFiles);
        backupBatch.setTotalSizeToUpload((long)totalSizeToUpload);
        backupBatch.setTotalNoOfFiles("" + noOfFiles);
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + backupBatch.getId().toString());
        this.msUtilDao.updateBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
        logger.debug(folder + ".....folder + file......." + file);
        logger.debug(".....nooffiles....." + noOfFiles);
        return batchId;
    }

    private List<DriveItem> getAllFilesForPolicy(List<DriveItem> currentPage, String deviceUUID, String userName, int cloudId, OfficeBackupPolicy oneDriveBackupPolicy, String deviceDestCollection, boolean isMail) {
        ArrayList<DriveItem> list = new ArrayList<DriveItem>();
        int i = 0;
        for (DriveItem driveItem : currentPage) {
            String basePath = "";
            String itemName = driveItem.name;
            if (!StringUtils.isEmpty((String)driveItem.name) && driveItem.name.equalsIgnoreCase("root")) {
                logger.debug("...rooot vaal so skip...");
                continue;
            }
            if (driveItem.folder != null) continue;
            if (driveItem.folder != null && !StringUtils.isEmpty((String)itemName) && !driveItem.name.equalsIgnoreCase("root")) {
                String parentPath;
                logger.debug("..folder.." + driveItem.name + "...." + driveItem.folder.childCount);
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                String newPath = parentPath + "/" + driveItem.name;
                logger.debug(parentPath + "..... folder to be added .... " + newPath);
            } else if (driveItem.file != null) {
                String parentPath;
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
            }
            if (StringUtils.isEmpty((String)basePath)) {
                basePath = "";
            }
            boolean isFileAllowed = this.handleElement(basePath, itemName, driveItem.size, oneDriveBackupPolicy, deviceUUID, userName, cloudId, isMail);
            logger.debug("..processed files......" + ++i + "/" + currentPage.size());
            if (!isFileAllowed) continue;
            list.add(driveItem);
        }
        return list;
    }

    private List<Message> getAllMailForPolicy(List<Message> currentPage, String deviceUUID, String userName, int cloudId, OfficeBackupPolicy oneDriveBackupPolicy, String deviceDestCollection, Map<String, String> folderPathMap) {
        ArrayList<Message> list = new ArrayList<Message>();
        for (Message driveItem : currentPage) {
            logger.debug("...ssitems.val.. " + driveItem);
            if (!StringUtils.isEmpty((String)driveItem.subject) && driveItem.subject.equalsIgnoreCase("root")) {
                logger.debug("...rooot vaal so skip...");
                continue;
            }
            if (!StringUtils.isEmpty((String)driveItem.parentFolderId)) {
                boolean isFileAllowed;
                String entryValue;
                String parentPath;
                String actualPath = parentPath = (entryValue = folderPathMap.get(driveItem.parentFolderId));
                if (entryValue.contains("/")) {
                    String[] parentPatharr = entryValue.split("/");
                    parentPath = parentPatharr[0];
                }
                if (!(isFileAllowed = this.handleMailElement(actualPath, parentPath, oneDriveBackupPolicy, deviceUUID, userName, cloudId, false))) {
                    logger.debug("...file cannot be allowed... ");
                    continue;
                }
                list.add(driveItem);
                continue;
            }
            list.add(driveItem);
        }
        return list;
    }

    private List<DriveItem> getModifiedFolderFiles(int cloudId, String deviceDestCollection, List<DriveItem> folders, String deviceUUID, String driveId, String deltaToken) {
        ArrayList<DriveItem> listItems = new ArrayList<DriveItem>();
        logger.debug("....iterating getModifiedFolderFiles......");
        for (DriveItem folderItem : folders) {
            try {
                List currentPage;
                BackUpImage backUpImageold = this.msUtilDao.getBackupImageFolderForItemIdForModified(cloudId, folderItem.id, deviceDestCollection);
                logger.debug(folderItem.name + ".... folder idbaa ss .... " + folderItem.id + "....." + backUpImageold);
                if (backUpImageold != null) {
                    String newPathVal = backUpImageold.getDevicePath() + "/" + backUpImageold.getFileName();
                    logger.debug(".... bkp image latest.... " + backUpImageold.getFileName() + "..." + backUpImageold.getDevicePath());
                    String parentPath = StringUtils.substringAfterLast((String)folderItem.parentReference.path, (String)"root:");
                    logger.debug("... parentpath ... " + parentPath);
                    parentPath = StringUtils.isEmpty((String)parentPath) ? "Files/" : BASE_FOLDER + parentPath + "/";
                    String newPath = parentPath + folderItem.name;
                    boolean isPathChanged = !newPathVal.equals(newPath);
                    logger.debug(isPathChanged + "...." + newPathVal + ".... isPathChanged..." + newPath + "....." + folderItem.name);
                    if (isPathChanged) {
                        boolean isNextPageExists = false;
                        DriveItemRequestBuilder items = MSServiceImpl.getGraphClient().drives(driveId).items(folderItem.id);
                        ArrayList<Object> requestOptions = new ArrayList<Object>();
                        requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=40"));
                        if (!StringUtils.isEmpty((String)deltaToken)) {
                            requestOptions.add(new QueryOption("token", (Object)deltaToken));
                        }
                        DriveItemCollectionPage iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)items.children().buildRequest(requestOptions)).get();
                        do {
                            logger.debug(folderItem.name + "... before getting items...." + listItems.size());
                            currentPage = iDriveItemCollectionPage.getCurrentPage();
                            listItems.addAll(currentPage);
                            logger.debug(folderItem.name + "... after getting items1...." + folderItem.id + "..." + listItems.size());
                            DriveItemCollectionRequestBuilder nextPage = (DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage();
                            if (currentPage.size() <= 0 || nextPage == null) break;
                            isNextPageExists = true;
                            iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)((DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage()).buildRequest(requestOptions)).get();
                        } while (isNextPageExists);
                        logger.debug("...files under folder..." + folderItem.name + "...." + listItems.size());
                        List<DriveItem> foldlistItems = new ArrayList<DriveItem>();
                        foldlistItems = this.getSubfolderItems(cloudId, driveId, folderItem, foldlistItems, deltaToken);
                        if (!CollectionUtils.isEmpty(foldlistItems)) {
                            block7: for (DriveItem driItem : foldlistItems) {
                                isNextPageExists = false;
                                items = MSServiceImpl.getGraphClient().drives(driveId).items(driItem.id);
                                iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)items.children().buildRequest(requestOptions)).get();
                                do {
                                    logger.debug("... before getting subfolder items...." + listItems.size());
                                    currentPage = iDriveItemCollectionPage.getCurrentPage();
                                    listItems.addAll(currentPage);
                                    logger.debug(listItems.size() + "... after getting subdfolder items1...." + driItem.id + "..." + driItem.name);
                                    DriveItemCollectionRequestBuilder nextPage = (DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage();
                                    if (currentPage.size() <= 0 || nextPage == null) continue block7;
                                    isNextPageExists = true;
                                    iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)((DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage()).buildRequest(requestOptions)).get();
                                } while (isNextPageExists);
                            }
                        }
                        logger.debug("...files after subfolder..." + folderItem.name + "...." + listItems.size());
                        this.msUtilDao.deleteAllFilesUnderFolder(cloudId, newPathVal, deviceUUID, deviceDestCollection);
                        continue;
                    }
                    logger.debug("... no children foor path");
                    continue;
                }
                logger.debug(".... no images...." + folderItem.name);
                boolean isNextPageExists = false;
                DriveItemRequestBuilder items = MSServiceImpl.getGraphClient().drives(driveId).items(folderItem.id);
                ArrayList<Object> requestOptions = new ArrayList<Object>();
                requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=40"));
                if (!StringUtils.isEmpty((String)deltaToken)) {
                    requestOptions.add(new QueryOption("token", (Object)deltaToken));
                }
                DriveItemCollectionPage iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)items.children().buildRequest(requestOptions)).get();
                do {
                    logger.debug(folderItem.name + "... before getting items...." + listItems.size());
                    currentPage = iDriveItemCollectionPage.getCurrentPage();
                    listItems.addAll(currentPage);
                    logger.debug(folderItem.name + "... after getting items1...." + folderItem.id + "..." + listItems.size());
                    DriveItemCollectionRequestBuilder nextPage = (DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage();
                    if (currentPage.size() <= 0 || nextPage == null) break;
                    isNextPageExists = true;
                    iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)((DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage()).buildRequest(requestOptions)).get();
                } while (isNextPageExists);
                logger.debug("...files under folder..." + folderItem.name + "...." + listItems.size());
                List<DriveItem> foldlistItems = new ArrayList<DriveItem>();
                foldlistItems = this.getSubfolderItems(cloudId, driveId, folderItem, foldlistItems, deltaToken);
                if (!CollectionUtils.isEmpty(foldlistItems)) {
                    block10: for (DriveItem driItem : foldlistItems) {
                        isNextPageExists = false;
                        items = MSServiceImpl.getGraphClient().drives(driveId).items(driItem.id);
                        iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)items.children().buildRequest(requestOptions)).get();
                        do {
                            logger.debug("... before getting subfolder items...." + listItems.size());
                            currentPage = iDriveItemCollectionPage.getCurrentPage();
                            listItems.addAll(currentPage);
                            logger.debug(listItems.size() + "... after getting subdfolder items1...." + driItem.id + "..." + driItem.name);
                            DriveItemCollectionRequestBuilder nextPage = (DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage();
                            if (currentPage.size() <= 0 || nextPage == null) continue block10;
                            isNextPageExists = true;
                            iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)((DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage()).buildRequest(requestOptions)).get();
                        } while (isNextPageExists);
                    }
                }
                logger.debug("...files after subfolder..." + folderItem.name + "...." + listItems.size());
            }
            catch (Error e) {
                logger.error("... ERRORR...... " + e.getMessage());
            }
            catch (ClientException gg) {
                logger.error("... ERRORR...... " + gg.getMessage());
            }
            catch (RuntimeException gg) {
                logger.error("... ERRORR...... " + gg.getMessage());
            }
            catch (Exception ee) {
                logger.error("... ERRORR...... " + ee.getMessage());
            }
        }
        return listItems;
    }

    private List<DriveItem> getSubfolderItems(int cloudId, String driveId, DriveItem folderItem, List<DriveItem> foldlistItems, String deltaToken) {
        DriveItemCollectionPage foldertemCollectionPage;
        boolean isNextPageExists = false;
        DriveItemRequestBuilder items = MSServiceImpl.getGraphClient().drives(driveId).items(folderItem.id);
        ArrayList<Object> requestOptions = new ArrayList<Object>();
        requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=40"));
        if (!StringUtils.isEmpty((String)deltaToken)) {
            requestOptions.add(new QueryOption("token", (Object)deltaToken));
        }
        if ((foldertemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)items.children().buildRequest(requestOptions)).filter("Folder ne null").get()) != null) {
            do {
                logger.debug(folderItem.name + "... before getting folders...." + foldlistItems.size());
                List currentPage = foldertemCollectionPage.getCurrentPage();
                foldlistItems.addAll(currentPage);
                if (!CollectionUtils.isEmpty((Collection)currentPage)) {
                    for (DriveItem driveItem : currentPage) {
                        foldlistItems = this.getSubfolderItems(cloudId, driveId, driveItem, foldlistItems, deltaToken);
                    }
                }
                logger.debug(foldlistItems.size() + "... after getting folders...." + folderItem.id + "..." + folderItem.name);
                DriveItemCollectionRequestBuilder nextPage = (DriveItemCollectionRequestBuilder)foldertemCollectionPage.getNextPage();
                if (currentPage.size() <= 0 || nextPage == null) {
                    isNextPageExists = false;
                    continue;
                }
                isNextPageExists = true;
                foldertemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)((DriveItemCollectionRequestBuilder)foldertemCollectionPage.getNextPage()).buildRequest(requestOptions)).get();
            } while (isNextPageExists);
        }
        return foldlistItems;
    }

    private BackUpImage convertToBkpImage(String deviceUUID, BackUpImage backUpImageold) {
        BackUpImage backUpImageDeleted = new BackUpImage();
        BeanUtils.copyProperties((Object)backUpImageold, (Object)backUpImageDeleted);
        backUpImageDeleted.setId(null);
        long timeMilliSec = System.currentTimeMillis();
        backUpImageDeleted.setDevicePath(backUpImageold.getDevicePath());
        backUpImageDeleted.setFileName(backUpImageold.getFileName());
        backUpImageDeleted.setDeviceUUID(deviceUUID);
        backUpImageDeleted.setLastServerModifiedTime(timeMilliSec);
        backUpImageDeleted.setFolder(backUpImageold.isFolder());
        backUpImageDeleted.setMd5Checksum(backUpImageold.getMd5Checksum());
        backUpImageDeleted.setPresent(false);
        backUpImageDeleted.setfSPath(backUpImageold.getfSPath());
        backUpImageDeleted.setUserName(backUpImageold.getUserName());
        backUpImageDeleted.setStatus(PCHelperConstant.REVISION_STATUS.DELETED.toString());
        backUpImageDeleted.setLastClientModifiedTime(backUpImageold.getLastClientModifiedTime());
        backUpImageDeleted.setBaseBackup(false);
        backUpImageDeleted.setSize(backUpImageold.getSize());
        backUpImageDeleted.setOdItemId(backUpImageold.getOdItemId());
        backUpImageDeleted.setGatewayName(backUpImageold.getGatewayName());
        backUpImageDeleted.setSubject(backUpImageold.getSubject());
        backUpImageDeleted.setFrom(backUpImageold.getFrom());
        backUpImageDeleted.setBodyContent(backUpImageold.getBodyContent());
        backUpImageDeleted.setBccRecipients(backUpImageold.getBccRecipients());
        backUpImageDeleted.setCcRecipients(backUpImageold.getCcRecipients());
        backUpImageDeleted.setToRecipients(backUpImageold.getToRecipients());
        backUpImageDeleted.setHasAttachments(backUpImageold.isHasAttachments());
        backUpImageDeleted.setTaskSubject(backUpImageold.getTaskSubject());
        backUpImageDeleted.setTaskStartDate(backUpImageold.getTaskStartDate());
        backUpImageDeleted.setTaskReminderTime(backUpImageold.getTaskReminderTime());
        backUpImageDeleted.setTaskDueDate(backUpImageold.getTaskDueDate());
        backUpImageDeleted.setContactMobile(backUpImageold.getContactMobile());
        backUpImageDeleted.setContactAddrStreet(backUpImageold.getContactAddrStreet());
        backUpImageDeleted.setContactAddrCity(backUpImageold.getContactAddrCity());
        backUpImageDeleted.setContactAddrState(backUpImageold.getContactAddrState());
        backUpImageDeleted.setContactAddrCountry(backUpImageold.getContactAddrCountry());
        backUpImageDeleted.setContactAddrPostalCode(backUpImageold.getContactAddrPostalCode());
        backUpImageDeleted.setChunkFiles(backUpImageold.getChunkFiles());
        boolean isMail = false;
        if (backUpImageold.isMail()) {
            isMail = true;
            backUpImageDeleted.setEwsId(backUpImageold.getEwsId());
        }
        backUpImageDeleted.setMail(isMail);
        return backUpImageDeleted;
    }

    public boolean handleElement(String path, String fileName, Long fileSize, OfficeBackupPolicy oneDriveBackupPolicy, String deviceUUID, String userName, int cloudId, boolean isMail) {
        boolean skipFileBasedonSize;
        boolean allow = false;
        path = path.toLowerCase();
        fileName = fileName.toLowerCase();
        ArrayList<BackupFolders> inclusionbackupFolders = oneDriveBackupPolicy.getOdBackupFolders();
        if (CollectionUtils.isEmpty((Collection)inclusionbackupFolders)) {
            inclusionbackupFolders = new ArrayList<BackupFolders>();
        }
        this.addDeviceLevelInclusion(deviceUUID, userName, cloudId, inclusionbackupFolders);
        allow = this.checkForOdbBackupFolders(path, path, inclusionbackupFolders);
        if (!allow) {
            return allow;
        }
        ArrayList<ExcludedFolders> excludedFolders = oneDriveBackupPolicy.getOdExcludedFolders();
        if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
            excludedFolders = new ArrayList<ExcludedFolders>();
        }
        this.addDeviceLevelExclusion(deviceUUID, userName, cloudId, excludedFolders);
        allow = this.checkForPathNotExcluded(path, path, excludedFolders);
        if (!allow) {
            logger.error("... file not under excluded path..." + path);
            return allow;
        }
        allow = this.checkForExtensions(fileName, oneDriveBackupPolicy.getOdInclusionFilter(), oneDriveBackupPolicy.getOdFilterType());
        if (!allow) {
            logger.error("... file not allowed becoz of extension..." + fileName);
            return allow;
        }
        if (!isMail && (skipFileBasedonSize = MSServiceImpl.checkFileSize(fileSize, Long.parseLong(oneDriveBackupPolicy.getOdMaxFileSize())))) {
            logger.error(".. file size is bigger for onedrive..." + fileSize + "....." + oneDriveBackupPolicy.getOdMaxFileSize());
            return false;
        }
        return allow;
    }

    public boolean handleMailElement(String actualPath, String path, OfficeBackupPolicy oneDriveBackupPolicy, String deviceUUID, String userName, int cloudId, boolean inplaceArchive) {
        boolean allow = false;
        path = path.toLowerCase();
        ArrayList<BackupFolders> inclusionbackupFolders = oneDriveBackupPolicy.getMailBackupFolders();
        if (CollectionUtils.isEmpty((Collection)inclusionbackupFolders)) {
            inclusionbackupFolders = new ArrayList<BackupFolders>();
        } else {
            inclusionbackupFolders.stream().forEach(fol -> {});
        }
        this.addDeviceLevelInclusion(deviceUUID, userName, cloudId, inclusionbackupFolders);
        allow = this.checkForBackupFolders(actualPath, path, inclusionbackupFolders, inplaceArchive);
        if (!allow) {
            logger.error("... file not under backup folder path..." + path);
            return allow;
        }
        ArrayList<ExcludedFolders> excludedFolders = oneDriveBackupPolicy.getMailExcludedFolders();
        if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
            excludedFolders = new ArrayList<ExcludedFolders>();
        }
        this.addDeviceLevelExclusion(deviceUUID, userName, cloudId, excludedFolders);
        allow = this.checkForPathNotExcluded(actualPath, actualPath, excludedFolders);
        if (!allow) {
            logger.error("... file not under excluded path..." + path);
            return allow;
        }
        return allow;
    }

    public boolean handleFolderElement(String actualPath, String path, OfficeBackupPolicy oneDriveBackupPolicy, String deviceUUID, String userName, int cloudId) {
        boolean allow = false;
        path = path.toLowerCase();
        ArrayList<BackupFolders> inclusionbackupFolders = oneDriveBackupPolicy.getOdBackupFolders();
        if (CollectionUtils.isEmpty((Collection)inclusionbackupFolders)) {
            inclusionbackupFolders = new ArrayList<BackupFolders>();
        }
        this.addDeviceLevelInclusion(deviceUUID, userName, cloudId, inclusionbackupFolders);
        allow = this.checkForBackupFolders(actualPath, path, inclusionbackupFolders, false);
        if (!allow) {
            return allow;
        }
        ArrayList<ExcludedFolders> excludedFolders = oneDriveBackupPolicy.getOdExcludedFolders();
        if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
            excludedFolders = new ArrayList<ExcludedFolders>();
        }
        this.addDeviceLevelExclusion(deviceUUID, userName, cloudId, excludedFolders);
        allow = this.checkForPathNotExcluded(actualPath, path, excludedFolders);
        if (!allow) {
            return allow;
        }
        return allow;
    }

    private void addDeviceLevelExclusion(String deviceUUID, String userName, int cloudId, List<ExcludedFolders> excludedFolders) {
        List userDeviceExcludedFoldersList = this.deviceDao.getAllUserDefinedExclusionFolders(cloudId, deviceUUID, userName);
        if (!CollectionUtils.isEmpty((Collection)userDeviceExcludedFoldersList)) {
            for (UserDefinedFolders userDefinedFolders : userDeviceExcludedFoldersList) {
                ExcludedFolders backupFolderElement = new ExcludedFolders();
                backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                excludedFolders.add(backupFolderElement);
            }
        }
    }

    private void addDeviceLevelInclusion(String deviceUUID, String userName, int cloudId, List<BackupFolders> inclusionbackupFolders) {
        List userDefinedFoldersList = this.deviceDao.getAllUserDefinedInclusionFolders(cloudId, deviceUUID, userName);
        if (!CollectionUtils.isEmpty((Collection)userDefinedFoldersList)) {
            for (UserDefinedFolders userDefinedFolders : userDefinedFoldersList) {
                BackupFolders backupFolderElement = new BackupFolders();
                backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                inclusionbackupFolders.add(backupFolderElement);
            }
        }
    }

    private static boolean checkFileSize(Long fileSize, long allowedSize) {
        boolean isFileTobeSkipped = true;
        if (allowedSize != 0L && allowedSize != -1L) {
            long fileSizeinBytes = fileSize;
            float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
            if (fileSizeinMb <= (float)allowedSize) {
                isFileTobeSkipped = false;
            }
        } else if (allowedSize == -1L) {
            isFileTobeSkipped = false;
        }
        return isFileTobeSkipped;
    }

    private static String getNormalizedPath(String path) {
        String newPath = path;
        if (!newPath.endsWith("/")) {
            newPath = newPath + "/";
        }
        return newPath;
    }

    private boolean checkForBackupFolders(String actualPath, String path, List<BackupFolders> backupFolders, boolean isinPlaceArchive) {
        boolean allow = false;
        logger.debug("Checking fornn.." + path);
        if (backupFolders == null || backupFolders.size() <= 0) {
            allow = true;
        } else {
            path = this.updatePath(path);
            String newPath = MSServiceImpl.getNormalizedPath(path);
            actualPath = this.updatePath(actualPath);
            String newActualPath = MSServiceImpl.getNormalizedPath(actualPath);
            path = newPath.toLowerCase();
            actualPath = newActualPath.toLowerCase();
            logger.debug(path + "..before s trying path..." + actualPath);
            if (actualPath.contains("recoverable items") || actualPath.contains("purged items")) {
                return true;
            }
            boolean inplaceFoldersConfigured = false;
            boolean inplaceSpecifFolderAdded = false;
            for (BackupFolders folder : backupFolders) {
                if (folder == null || StringUtils.isEmpty((String)folder.getFolderPath())) continue;
                if (folder.getFolderPath().contains("In-Place Archive")) {
                    inplaceSpecifFolderAdded = true;
                }
                logger.debug(folder.getFolderPath() + "....." + folder.getFolderPath().contains("In-Place Archive") + "....inplacearchivepath...." + inplaceSpecifFolderAdded);
            }
            for (BackupFolders folder : backupFolders) {
                if (folder == null || StringUtils.isEmpty((String)folder.getFolderPath())) continue;
                if (path.contains("In-Place Archive/ex")) {
                    logger.debug("....check...alloowex....");
                }
                if (!inplaceSpecifFolderAdded && folder.getFolderPath().equals("/")) {
                    allow = true;
                    break;
                }
                if (folder.getFolderPath().contains("In-Place Archive")) {
                    inplaceFoldersConfigured = true;
                }
                if (path.contains("In-Place Archive/ex")) {
                    logger.debug("....check...alloowex1....");
                }
                String normalizedPath = MSServiceImpl.getNormalizedPath(folder.getFolderPath());
                normalizedPath = normalizedPath.toLowerCase();
                normalizedPath = this.updatePath(normalizedPath);
                if (inplaceSpecifFolderAdded && path.contains("in-place archive") && normalizedPath.equalsIgnoreCase("/") || !path.startsWith(normalizedPath) && !actualPath.equalsIgnoreCase(normalizedPath) && !actualPath.startsWith(normalizedPath)) continue;
                logger.debug(path + "..pathnormalized.." + normalizedPath);
                allow = true;
                break;
            }
            if (!allow && !inplaceFoldersConfigured && isinPlaceArchive) {
                allow = true;
            }
        }
        logger.debug(allow + "...Checking fornn3.." + path);
        return allow;
    }

    private boolean checkForOdbBackupFolders(String actualPath, String path, List<BackupFolders> backupFolders) {
        boolean allow = false;
        if (backupFolders == null || backupFolders.size() <= 0) {
            allow = true;
        } else {
            path = this.updatePath(path);
            actualPath = this.updatePath(actualPath);
            String newPath = MSServiceImpl.getNormalizedPath(path);
            String newActualPath = MSServiceImpl.getNormalizedPath(actualPath);
            path = newPath.toLowerCase();
            actualPath = newActualPath.toLowerCase();
            for (BackupFolders folder : backupFolders) {
                if (folder == null || StringUtils.isEmpty((String)folder.getFolderPath())) continue;
                if (folder.getFolderPath().equals("/")) {
                    allow = true;
                    break;
                }
                String normalizedPath = MSServiceImpl.getNormalizedPath(folder.getFolderPath());
                normalizedPath = normalizedPath.toLowerCase();
                if (!path.startsWith(normalizedPath = this.updatePath(normalizedPath)) && !actualPath.equalsIgnoreCase(normalizedPath) && !actualPath.startsWith(normalizedPath)) continue;
                allow = true;
                break;
            }
        }
        return allow;
    }

    private String updatePath(String path) {
        if (!(StringUtils.isEmpty((String)path) || path.equals("/") || path.startsWith("/"))) {
            StringBuilder str = new StringBuilder(path);
            path = str.insert(0, "/").toString();
        }
        return path;
    }

    private boolean checkForPathNotExcluded(String actualPath, String path, List<ExcludedFolders> excludedFolders) {
        boolean allow = true;
        if (excludedFolders == null || excludedFolders.size() <= 0) {
            allow = true;
        } else {
            path = MSServiceImpl.getNormalizedPath(path.toLowerCase());
            path = this.updatePath(path);
            for (ExcludedFolders excludedFolder : excludedFolders) {
                String pathInPolicy = excludedFolder.getFolderPath();
                String normalizedPath = MSServiceImpl.getNormalizedPath(pathInPolicy.toLowerCase());
                if (!path.startsWith(normalizedPath = this.updatePath(normalizedPath))) continue;
                logger.debug("Path (" + path + ") disallowed because of Rule(excludedFolders) " + excludedFolder.getFolderPath());
                allow = false;
                break;
            }
        }
        logger.debug(allow + "...Checking fornn1.." + path);
        return allow;
    }

    private boolean checkForExtensions(String fileName, List<InclusionFilter> inclusionFilterList, String filterType) {
        boolean allow = false;
        if (CollectionUtils.isEmpty(inclusionFilterList)) {
            return true;
        }
        HashSet<String> filterExtensions = new HashSet<String>();
        for (InclusionFilter inclusionFilter : inclusionFilterList) {
            String[] extensions;
            for (String ext : extensions = inclusionFilter.getExtensionName().split(",")) {
                ext = ext.toLowerCase();
                filterExtensions.add(ext);
            }
        }
        boolean allowAllextensions = filterExtensions.contains("all");
        if (filterExtensions != null && !allowAllextensions) {
            if (!StringUtils.isEmpty((String)filterType) && filterType.equalsIgnoreCase("exclusion")) {
                if (filterExtensions.size() > 0 && !filterExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
                    allow = true;
                }
            } else if (filterExtensions.size() > 0 && filterExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
                allow = true;
            }
        } else {
            allow = true;
        }
        return allow;
    }

    @Override
    public List<EventHub> getStartBackupEventHubList(int cloudId) {
        return this.msUtilDao.getStartBackupEventHubList(cloudId);
    }

    @Override
    public void deleteActionBasedOnBackupBatchStatus(int cloudId, String deviceUUID, String action) {
        this.msUtilDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, action);
    }

    @Override
    public List<EventHub> getEventHubForDeviceUUID(int cloudId, String deviceUUID) {
        return this.msUtilDao.getEventHubForDeviceUUID(cloudId, deviceUUID);
    }

    @Override
    public Device getODDeviceForUserName(int cloudId, String userName) {
        return this.deviceDao.getODDeviceForUserName(cloudId, userName);
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyForUserName(int cloudId, String userName) {
        return this.userDao.getOfficeBackupPolicyForUserName(cloudId, userName);
    }

    @Override
    public void updateEventHubOdStatus(int cloudId, ObjectId eventHubId) {
        this.msUtilDao.updateEventHubOdStatus(cloudId, eventHubId);
    }

    @Override
    public boolean isPrevBkpPaused(String actionToDeviceUUID, String policyName) {
        return this.msUtilDao.isPrevBkpPaused(actionToDeviceUUID, policyName);
    }

    @Override
    public void updatePauseBkp(String actionToDeviceUUID, String policyName) {
        this.msUtilDao.updatePauseBkp(actionToDeviceUUID, policyName);
    }

    @Override
    public com.parablu.pcbd.domain.User getUserInfo(int cloudId, String userName) {
        return this.userDao.getUserInfoByName(cloudId, "", userName);
    }

    @Override
    public long getThreadSize(int cloudId, String cloudName) {
        return this.msUtilDao.getThreadSize(cloudId, cloudName);
    }

    @Override
    public void saveOfficeBackupPolicy(int cloudId, OfficeBackupPolicy oneDriveBackupPolicy) {
        this.msUtilDao.saveOfficeBackupPolicy(cloudId, oneDriveBackupPolicy);
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyFromLocal(int cloudId, String policyName) {
        return this.msUtilDao.getOfficeBackupPolicyFromLocal(cloudId, policyName);
    }

    @Override
    public List<ODBBackupBatch> getCurrentBatch(String policyName, String userName, String deviceUUID) {
        return this.msUtilDao.getCurrentBatch(policyName, userName, deviceUUID);
    }

    private boolean isInPlaceArchiveBackupEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isInPlaceArchiveBackupEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"In-Place Archive Enabled".equalsIgnoreCase(license.getName())) continue;
            isInPlaceArchiveBackupEnabled = true;
            break;
        }
        return isInPlaceArchiveBackupEnabled;
    }

    @Override
    public void processDeltaChangesForUserMail(com.parablu.pcbd.domain.User userObj, Cloud cloud, OfficeBackupPolicy oneDriveBackupPolicy, OfficeBackupPolicy oldBackupPolicy, boolean isPolicyModified, boolean isFullBackup, String eventHubId, long batchStartTime) {
        String userName = userObj.getUserName();
        String emailId = userObj.getEmailId();
        int cloudId = cloud.getCloudId();
        Device device = this.deviceDao.getOutlookDeviceForUserName(cloudId, userName);
        if (device == null) {
            logger.debug("... no mail device for user... " + userName);
            return;
        }
        if (device.isBlocked() || device.isDeleted()) {
            logger.debug("... device blocked for user... " + userName);
            return;
        }
        String deviceUUID = device.getDeviceUUID();
        boolean isInPlaceArchiveBackupEnabled = this.isInPlaceArchiveBackupEnabled(cloud.getCloudCustomisableDetails());
        if (!isInPlaceArchiveBackupEnabled) {
            oneDriveBackupPolicy.setInPlaceMailArchiveEnabled(false);
        }
        if (this.isODBEnabled(cloud.getCloudCustomisableDetails()) && userObj != null && !userObj.isBackupTargetAssigned()) {
            logger.debug(".....backupTargetAssigned is false so return..." + userName);
            this.createBatchForTargetUnAssignedUser(cloudId, device.getDeviceUUID(), userName, oneDriveBackupPolicy, batchStartTime);
            return;
        }
        try {
            logger.debug(isFullBackup + ".....policy is modified........." + isPolicyModified);
            String deltaToken = device.getDeltaToken();
            if (isFullBackup) {
                deltaToken = "";
            }
            ArrayList<Message> listItems = new ArrayList<Message>();
            String prevDeviceToken = deltaToken;
            String userPrincId = this.getAzureUserId(emailId);
            if (StringUtils.isEmpty((String)userPrincId)) {
                logger.error(".... user not found ..." + emailId + "..." + userName);
                if (device != null) {
                    logger.debug("...device there but license disabled...");
                    this.updateOverViewStatus(cloud.getCloudId(), device.getDeviceUUID(), 2004);
                }
            }
            MailFolderCollectionRequestBuilder mailFolders = MSServiceImpl.getGraphClient().users(userPrincId).mailFolders();
            try {
                ((MailFolderDeltaCollectionRequest)mailFolders.delta().buildRequest(new Option[0])).get();
            }
            catch (GraphServiceException e2) {
                logger.error("...error-trying to get folders..... " + e2.getResponseCode());
                if (e2.getResponseCode() == 404) {
                    ODBBackupBatch backupBatch = new ODBBackupBatch();
                    backupBatch.setDeviceUUID(deviceUUID);
                    backupBatch.setUserName(userName);
                    backupBatch.setNoOfFiles(0L);
                    backupBatch.setTotalNoOfFiles("0");
                    backupBatch.setStatus("COMPLETED");
                    backupBatch.setBatchStartTimestamp(batchStartTime);
                    backupBatch.setErrorCode("544");
                    String batchId = this.msUtilDao.saveBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
                    this.userDao.updateFailedMailBox(cloudId, userName);
                }
                return;
            }
            String destCollection = device.getDestCollection();
            if (isPolicyModified) {
                listItems = new ArrayList();
                logger.debug(".... policymodified new log .... " + deviceUUID);
                this.handleModifiedMailItems(deviceUUID, userName, emailId, cloudId, oneDriveBackupPolicy, isFullBackup, destCollection, deltaToken, eventHubId, batchStartTime);
            } else {
                logger.debug(isFullBackup + "... backup token1.... " + deltaToken);
                deltaToken = this.handleMailItems(listItems, deviceUUID, userName, emailId, cloudId, oneDriveBackupPolicy, isFullBackup, destCollection, deltaToken, eventHubId, batchStartTime);
            }
            logger.debug(listItems.size() + "...@@@@@@@@@@@@@@@@new delta token from deltapage...." + deltaToken);
            this.deviceDao.updateDeviceDeltaToken(cloudId, device.getDeviceUUID(), deltaToken, prevDeviceToken);
        }
        catch (Error e) {
            e.printStackTrace();
            logger.error(e.getMessage() + " ...exception trying to process .. user ... " + userName);
            try {
                if (batchStartTime > 0L) {
                    this.msUtilDao.deleteBatchFromOdServer(deviceUUID, batchStartTime, oneDriveBackupPolicy.getPolicyName());
                    this.msUtilDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, "START_BACKUP");
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                logger.debug("...unable to delete event hub...." + deviceUUID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage() + " ...exception trying to process .. user ... " + userName);
            try {
                if (batchStartTime > 0L) {
                    this.msUtilDao.deleteBatchFromOdServer(deviceUUID, batchStartTime, oneDriveBackupPolicy.getPolicyName());
                    this.msUtilDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, "START_BACKUP");
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                logger.debug("...unable to delete event hub...." + deviceUUID);
            }
        }
    }

    private List<BackupFolders> getMailBackupFolders(OfficeBackupPolicy oneDriveBackupPolicy, OfficeBackupPolicy oldBackupPolicy) {
        List oldFolders = oldBackupPolicy.getMailBackupFolders();
        Predicate<BackupFolders> somePre = newItem -> oldFolders.stream().noneMatch(prevItem -> newItem.getFolderPath().compareTo(prevItem.getFolderPath()) == 0);
        List currentFolders = oneDriveBackupPolicy.getMailBackupFolders();
        List<BackupFolders> newFoldersToBeAdded = ((Stream)currentFolders.stream().parallel()).filter(somePre).collect(Collectors.toList());
        logger.debug("..new getMailBackupFolders.. " + newFoldersToBeAdded.size());
        return newFoldersToBeAdded;
    }

    private List<BackupFolders> getMailMatchBackupFolders(OfficeBackupPolicy oneDriveBackupPolicy, OfficeBackupPolicy oldBackupPolicy) {
        List oldFolders = oldBackupPolicy.getMailBackupFolders();
        Predicate<BackupFolders> somePre = newItem -> oldFolders.stream().anyMatch(prevItem -> newItem.getFolderPath().compareTo(prevItem.getFolderPath()) == 0);
        List currentFolders = oneDriveBackupPolicy.getMailBackupFolders();
        List<BackupFolders> newFoldersToBeAdded = ((Stream)currentFolders.stream().parallel()).filter(somePre).collect(Collectors.toList());
        logger.debug("..new getMailBackupFolders.. " + newFoldersToBeAdded.size());
        return newFoldersToBeAdded;
    }

    public MailFolderRequestBuilder getMailFolders(int cloudId, String userName, String folderName, GraphServiceClient<Request> graphClient) {
        String userId = this.getAzureUserId(userName);
        UserRequestBuilder users = graphClient.users(userId);
        MailFolderCollectionRequestBuilder mailFolders = users.mailFolders();
        return (MailFolderRequestBuilder)mailFolders.byId(folderName);
    }

    public static ExchangeService getAuthenticatedService(String token, String senderAddr) {
        ExchangeService service = null;
        try {
            service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
            service.getHttpHeaders().put("Authorization", "Bearer " + token);
            service.getHttpHeaders().put("X-AnchorMailbox", senderAddr);
            service.setUrl(new URI(EWS_URL));
            service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.PrincipalName, senderAddr));
        }
        catch (Exception e) {
            logger.error("....error trying ....." + e.getMessage());
        }
        return service;
    }

    @Override
    public ObjectId saveEventHubAction(int cloudId, EventHub eventHub) {
        return this.msUtilDao.saveEventHubAction(cloudId, eventHub);
    }

    @Override
    public void saveStatisticToDatabase(int cloudId, AuditHistory auditHistory) {
        this.msUtilDao.saveStatisticToDatabase(cloudId, auditHistory);
    }

    @Override
    public List<UserDefinedFolders> getAllUserDefinedInclusionFolders(int cloudId, String deviceUUID, String userName) {
        return this.deviceDao.getAllUserDefinedInclusionFolders(cloudId, deviceUUID, userName);
    }

    @Override
    public List<UserDefinedFolders> getAllUserDefinedExclusionFolders(int cloudId, String deviceUUID, String userName) {
        return this.deviceDao.getAllUserDefinedExclusionFolders(cloudId, deviceUUID, userName);
    }

    @Override
    public Device getMailDeviceForUserName(int cloudId, String userName) {
        return this.deviceDao.getMailDeviceForUserName(cloudId, userName);
    }

    @Override
    public RestoreEvents getRestoreEventsByUUID(int cloudId, String deviceUUID) {
        return this.deviceDao.getRestoreEventsByUUID(cloudId, deviceUUID);
    }

    @Override
    public boolean isPrevBkpDeferred(String actionToDeviceUUID, String policyName) {
        return this.msUtilDao.isPrevBkpDeferred(actionToDeviceUUID, policyName);
    }

    @Override
    public void updateDeferredBkp(String actionToDeviceUUID, String policyName) {
        this.msUtilDao.updateDeferredBkp(actionToDeviceUUID, policyName);
    }

    @Override
    public DeviceBackupOverView getDeviceBackupOverViewForDevice(int cloudId, String deviceUUID) {
        return this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
    }

    @Override
    public List<EventHub> getStartBackupEventHubListForBlukrypt(int cloudId) {
        return this.msUtilDao.getStartBackupEventHubListForBlukrypt(cloudId);
    }

    @Override
    public void removeOldEventHub(int cloudId) {
        this.msUtilDao.removeOldEventHub(cloudId);
    }

    @Override
    public void deleteEventHub(int cloudId, ObjectId eventHubId) {
        this.msUtilDao.deleteEventHub(cloudId, eventHubId);
    }

    public static String getKeyFromValue(Map<String, String> hm, Object value) {
        for (String o : hm.keySet()) {
            if (!hm.get(o).equals(value)) continue;
            return o;
        }
        return null;
    }

    private DriveRequestBuilder getDrive(int cloudId, String deviceUUID) {
        DriveRequestBuilder drives;
        block5: {
            drives = null;
            try {
                drives = MSServiceImpl.getGraphClient().drives(deviceUUID);
            }
            catch (GraphServiceException ee) {
                logger.error(ee.getMessage() + "... error in getting  graphClient.drives(driveId) ...." + deviceUUID + "...error code..." + ee.getResponseCode());
                if (ee.getResponseCode() != 429) break block5;
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                drives = this.getDrive(cloudId, deviceUUID);
            }
            catch (Error ee) {
                logger.error(ee.getMessage() + "... error in getting drives ...." + deviceUUID);
            }
        }
        return drives;
    }

    public String getEWSToken(int cloudId) {
        return this.msUtilDao.getEWSToken(cloudId);
    }

    @Override
    public List<String> getAllUsersNotBackedup(int cloudId, String policyName, String productType) {
        return this.msUtilDao.getAllUsersNotBackedup(cloudId, policyName, productType);
    }

    @Override
    public void deleteUserAfterBackup(UsersWOBackup usersWOBackup) {
        this.msUtilDao.deleteUserAfterBackup(usersWOBackup);
    }

    @Override
    public void saveUserBeforeBackup(UsersWOBackup usersWOBackup) {
        this.msUtilDao.saveUserBeforeBackup(usersWOBackup);
    }

    @Override
    public List<OfficeBackupPolicy> getAllOfficeBackupPolicies(int cloudId, String productType) {
        return this.msUtilDao.getAllOfficeBackupPolicies(cloudId, productType);
    }

    @Override
    public void updateOverViewStatus(int cloudId, String actionToDeviceUUID, int errorCode) {
        this.msUtilDao.updateOverViewStatus(cloudId, actionToDeviceUUID, errorCode);
    }

    @Override
    public List<DeviceBackupOverView> getAllOfficeOverViews(int cloudId, String userName) {
        return this.deviceDao.getAllOfficeOverViews(cloudId, userName);
    }

    public String getRootFolderId(String userId) {
        String rootFolderId;
        block11: {
            rootFolderId = "";
            String siteUrl = "https://graph.microsoft.com/v1.0/users/" + userId + "/mailFolders/msgfolderroot";
            System.out.println("...siteurl...." + siteUrl);
            try {
                Request request1 = new Request.Builder().url(siteUrl).build();
                OkHttpClient okHttpClient = Graph.getInstance1().getOkHttpClient();
                Call call1 = okHttpClient.newCall(request1);
                Response response1 = call1.execute();
                int responseCode1 = response1.code();
                System.out.println("...response code..." + responseCode1);
                String bodyStr = response1.body().string();
                System.out.println("...." + bodyStr);
                JSONObject jsonObject = new JSONObject(bodyStr);
                rootFolderId = (String)jsonObject.get("id");
            }
            catch (GraphServiceException e) {
                if (e.getResponseCode() != 429) break block11;
                logger.error(" ...inside GraphServiceException and 429 case... ");
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException okHttpClient) {
                    // empty catch block
                }
                boolean success = true;
                do {
                    try {
                        Request request1 = new Request.Builder().url(siteUrl).build();
                        OkHttpClient okHttpClient = Graph.getInstance1().getOkHttpClient();
                        Call call1 = okHttpClient.newCall(request1);
                        Response response1 = call1.execute();
                        int responseCode1 = response1.code();
                        System.out.println("...response code..." + responseCode1);
                        String bodyStr = response1.body().string();
                        System.out.println("...." + bodyStr);
                        JSONObject jsonObject = new JSONObject(bodyStr);
                        rootFolderId = (String)jsonObject.get("id");
                        success = false;
                    }
                    catch (GraphServiceException ew) {
                        if (ew.getResponseCode() != 429) continue;
                        success = true;
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Exception eee) {
                        logger.error("...error trying to get ee..." + eee.getMessage());
                    }
                } while (success);
                logger.error("GraphServiceException....", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("graph exception to delete:", (Object)e.getMessage());
            }
        }
        return rootFolderId;
    }

    @Override
    public BackupBatch getLastBackupOnly(int cloudId, String userName, String deviceUUID) {
        return this.msUtilDao.getLastBackupOnly(cloudId, userName, deviceUUID);
    }

    @Override
    public List<com.parablu.pcbd.domain.User> getAllUsers(int cloudId) {
        return this.userDao.getAllUsers(cloudId, "");
    }

    static {
        REFRESH_BEFORE_EXPIRY_MS = Duration.ofMinutes(5L).toMillis();
    }
}

