/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.MSUtilDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.MailAttachment;
import com.parablu.pcbd.domain.OutlookEmailAddress;
import com.parablu.pcbd.domain.User;
import com.pg.controller.BaseController;
import com.pg.element.BackupElement;
import com.pg.element.FileUploadDetailsElement;
import com.pg.element.OutlookEmailAddressElement;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.BackupService;
import com.pg.service.UtilService;
import com.pg.util.PathConversionHelper;
import com.pg.util.PathGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.BsonMaximumSizeExceededException;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BackupServiceImpl
implements BackupService {
    private static Logger logger = LogManager.getLogger(BackupServiceImpl.class);
    private BackUpImageDao backUpImageDao;
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    private MSUtilDao msUtilDao;
    private UserDao userDao;
    @Autowired
    private UtilService utilService;

    public UtilService getUtilService() {
        return this.utilService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public void setMsUtilDao(MSUtilDao msUtilDao) {
        this.msUtilDao = msUtilDao;
    }

    @Override
    public FileUploadDetailsElement uploadExternalFileToBackUp(int cloudId, String cloudName, BackupElement fileElement, Device device, String userUnderLegalHold, boolean isFullBackup) {
        FileUploadDetailsElement fileUploadDetailsElement = new FileUploadDetailsElement();
        ObjectId id = null;
        String fileName = null;
        String newStatus = null;
        BackUpImage backUpImage = null;
        try {
            long storageUtilized;
            this.convertToServerPath(fileElement, device);
            fileName = fileElement.getFileName();
            logger.debug(" Before calling getVersions ........device id ..." + device.getId() + " PATH " + fileElement.getFileCompletePath() + " FILE NAME " + fileName);
            boolean isMail = false;
            if (device.getOsType().equalsIgnoreCase("OUTLOOK")) {
                isMail = true;
            }
            List<BackUpImage> backUpImagesList = new ArrayList();
            logger.debug(" end of calling getVersions ..... ewsid......" + fileElement.getEwsId());
            backUpImagesList = !isMail ? this.backUpImageDao.getVersions(cloudId, cloudName, fileName, fileElement.getFileCompletePath(), device) : this.backUpImageDao.getVersionsEwsId(cloudId, cloudName, fileName, fileElement.getFileCompletePath(), device, fileElement.getEwsId());
            boolean lastRecordPresent = false;
            long prevVersionSize = 0L;
            if (!CollectionUtils.isEmpty(backUpImagesList)) {
                logger.debug("...backup images size .... " + backUpImagesList.size());
                backUpImage = (BackUpImage)backUpImagesList.get(0);
                if (backUpImage != null && !backUpImage.getStatus().equalsIgnoreCase(PCHelperConstant.REVISION_STATUS.DELETED.toString())) {
                    logger.debug(backUpImage.getDevicePath() + " *&*&*&*file already present .............." + backUpImage.getFileName());
                    lastRecordPresent = true;
                }
                for (BackUpImage bkp : backUpImagesList) {
                    if (bkp == null || bkp.getStatus().equalsIgnoreCase(PCHelperConstant.REVISION_STATUS.DELETED.toString())) continue;
                    prevVersionSize = bkp.getSize();
                    break;
                }
                logger.debug("................prevVersionSize......" + prevVersionSize);
            } else {
                logger.debug(" no versions present...............");
            }
            boolean noChange = false;
            if (lastRecordPresent) {
                noChange = this.checkIfRevisionHasBeenModified(fileElement, backUpImage);
            }
            if (lastRecordPresent && noChange) {
                String alreadyExist = "ALREADY_EXISTS";
                id = backUpImage.getId();
                if (isFullBackup) {
                    alreadyExist = id.toString();
                    List chunks = backUpImage.getChunkFiles();
                    if (!chunks.isEmpty()) {
                        for (ChunkFile chunk : chunks) {
                            String dedupVal = this.getDedupValue(backUpImage.getUserName());
                            ChunkDetail chunkDetail = null;
                            this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(backUpImage.getUserName(), dedupVal, chunk.getMd5(), backUpImage.getLastServerModifiedTime(), chunkDetail, false);
                            if (chunkDetail == null) {
                                logger.debug("................chunk detail is empty for userName " + backUpImage.getUserName() + " so search with userName case insesitive...........");
                                chunkDetail = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(backUpImage.getUserName(), dedupVal, chunk.getMd5(), backUpImage.getLastServerModifiedTime(), chunkDetail, true);
                            }
                            if (chunkDetail == null) continue;
                            chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                            this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                        }
                    }
                    backUpImage.setChunkFiles(new ArrayList());
                    backUpImage.setLastServerModifiedTime(System.currentTimeMillis());
                    backUpImage.setStoragePlace(null);
                    backUpImage.setGatewayName(fileElement.getGatewayName());
                    backUpImage.setMail(isMail);
                    if (fileElement.getAccessTime() != 0L) {
                        backUpImage.setAccessTime(fileElement.getAccessTime());
                    }
                    this.backUpImageDao.saveImageToBackUp(cloudId, backUpImage, device);
                }
                fileUploadDetailsElement.setBkpId(alreadyExist);
                return fileUploadDetailsElement;
            }
            newStatus = lastRecordPresent ? PCHelperConstant.REVISION_STATUS.MODIFIED.toString() : PCHelperConstant.REVISION_STATUS.ADDED.toString();
            logger.debug(lastRecordPresent + " ############### newStatus    " + newStatus + "....ew.." + fileElement.getEwsId());
            long fileSizeinBytes = fileElement.getSize();
            BaseController.printLogs("...fileinbytes...." + fileSizeinBytes, PCHelperConstant.isBrevityLogging());
            long filesizeInKB = fileSizeinBytes / 1024L;
            long latestVersionSize = filesizeInKB - prevVersionSize;
            if (lastRecordPresent) {
                storageUtilized = this.getStorageUtilizedAfterRevisionChange(cloudId, cloudName, backUpImage.getUserName(), filesizeInKB, backUpImagesList, userUnderLegalHold, device);
            } else {
                storageUtilized = filesizeInKB;
                latestVersionSize = filesizeInKB;
            }
            id = this.uploadExternalFile(cloudId, cloudName, fileElement, device, fileName, newStatus);
            fileUploadDetailsElement.setFileSize(storageUtilized);
            fileUploadDetailsElement.setLatestVersionSize(latestVersionSize);
            BaseController.printLogs("!!!Insert to Backup    completed  " + newStatus + " ... id.... " + id, PCHelperConstant.isBrevityLogging());
        }
        catch (ParacloudBackupException e) {
            logger.error("@ResourceFunnelException@", (Throwable)e);
            throw new ParacloudBackupException("Exception occured in uploadImpl" + (Object)((Object)e), e.getResponseCode());
        }
        catch (BsonMaximumSizeExceededException e) {
            logger.error("@Exception@", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("@Exception@", (Throwable)e);
            throw new ParacloudBackupException("Exception occured in uploadImpl" + e, 500);
        }
        if (id != null) {
            fileUploadDetailsElement.setBkpId(id.toString());
        }
        return fileUploadDetailsElement;
    }

    private void convertToServerPath(BackupElement fileElement, Device device) {
        String ostype = device.getOsType();
        boolean type = ostype != null ? ostype.equals("Android") : true;
        String convertedPath = PathConversionHelper.getServerCompatiblePath((String)fileElement.getFileCompletePath(), (boolean)type);
        if (device.isLowercasePathConversionEnabled()) {
            convertedPath = PathConversionHelper.getLowercaseConvertedPath((String)convertedPath);
        }
        fileElement.setFileCompletePath(convertedPath);
    }

    private boolean checkIfRevisionHasBeenModified(BackupElement fileElement, BackUpImage backUpImage) {
        if (backUpImage.isFolder() && fileElement.isFolder()) {
            return true;
        }
        return backUpImage.getMd5Checksum().equals(fileElement.getMd5Checksum());
    }

    public long getStorageUtilizedAfterRevisionChange(int cloudId, String cloudName, String userName, Long fileSize, List<BackUpImage> backUpImages, String userUnderLegalHold, Device device) {
        long storageUtilized = 0L;
        int currentNoOfVersions = backUpImages.stream().filter(backupImage -> !backupImage.getStatus().equalsIgnoreCase("DELETED")).collect(Collectors.toList()).size();
        boolean isUserUnderLegalHold = false;
        logger.debug(" User under legal hold from agent .... " + userUnderLegalHold);
        int maxVersionsToKeep = 2;
        storageUtilized = fileSize;
        User userByName = this.userDao.getUserByName(cloudId, userName);
        boolean isOneDriveDevice = false;
        if (!StringUtils.isEmpty((String)device.getOsType()) && Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(device.getOsType())) {
            isOneDriveDevice = true;
        }
        if (userByName != null && !StringUtils.isEmpty((String)userByName.getPolicyName())) {
            BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, userByName.getPolicyName());
            isUserUnderLegalHold = backupPolicy.isLegalHoldEnabled();
            maxVersionsToKeep = backupPolicy.getMaxVersions();
        }
        logger.debug(" Is User under legal hold .... " + isUserUnderLegalHold);
        if (isUserUnderLegalHold) {
            return storageUtilized;
        }
        logger.debug("maxVersionsToKeep..................." + maxVersionsToKeep + "current no of versions........" + currentNoOfVersions);
        if (maxVersionsToKeep == -1) {
            logger.debug("Maxversions Unlimited...................");
        } else {
            long deleteFileSize = 0L;
            List bkpImageList = backUpImages.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).collect(Collectors.toList());
            for (BackUpImage bkpImage : bkpImageList) {
                logger.debug("bkpImage " + bkpImage.getId() + " ...bkpImage...status..." + bkpImage.getStatus() + "...currentNoOfVersions.." + currentNoOfVersions);
                if (maxVersionsToKeep > currentNoOfVersions && maxVersionsToKeep != 0) break;
                if (bkpImage.isBusy()) {
                    logger.debug("bkp image is busy so don't delete:" + bkpImage.getId());
                    continue;
                }
                if (!bkpImage.getStatus().equals("DELETED")) {
                    this.removeBackupImage(bkpImage, cloudId, cloudName, device);
                    --currentNoOfVersions;
                    deleteFileSize += bkpImage.getSize();
                    continue;
                }
                this.removeBackupImage(bkpImage, cloudId, cloudName, device);
            }
            storageUtilized = fileSize - deleteFileSize;
            logger.debug(fileSize + "..." + deleteFileSize + ".........versionupdated size.... " + storageUtilized);
        }
        return storageUtilized;
    }

    private ObjectId uploadExternalFile(int cloudId, String cloudName, BackupElement fileElement, Device device, String fileName, String newStatus) throws IOException, NoSuchAlgorithmException {
        OutlookEmailAddress emailAddress;
        String intermediateUploadFolder = device.getDeviceTempPath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "backup";
        File intermediateFile = new File(intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        BackUpImage backUpImage = new BackUpImage();
        String fsPath = this.getFsPathForFile(fileElement.getMd5Checksum());
        BackupServiceImpl.convertToBackUpImage(fileElement, device.getDeviceUUID(), backUpImage, device, fileElement.isBaseBackup(), fsPath, newStatus);
        long fileSizeinBytes = fileElement.getSize();
        long filesizeInKB = fileSizeinBytes / 1024L;
        backUpImage.setSize(filesizeInKB);
        backUpImage.setSizeInBytes(fileSizeinBytes);
        backUpImage.setGatewayName(fileElement.getGatewayName());
        backUpImage.setSubject(fileElement.getSubject());
        backUpImage.setFrom(fileElement.getFrom());
        backUpImage.setBodyContent(fileElement.getBodyContent());
        backUpImage.setBccRecipients(fileElement.getBccRecipients());
        backUpImage.setCcRecipients(fileElement.getCcRecipients());
        backUpImage.setToRecipients(fileElement.getToRecipients());
        backUpImage.setHasAttachments(fileElement.isHasAttachments());
        backUpImage.setTaskSubject(fileElement.getTaskSubject());
        backUpImage.setTaskStartDate(fileElement.getTaskStartDate());
        backUpImage.setTaskReminderTime(fileElement.getTaskReminderTime());
        backUpImage.setTaskDueDate(fileElement.getTaskDueDate());
        backUpImage.setContactMobile(fileElement.getContactMobile());
        backUpImage.setContactAddrStreet(fileElement.getContactAddrStreet());
        backUpImage.setContactAddrCity(fileElement.getContactAddrCity());
        backUpImage.setContactAddrState(fileElement.getContactAddrState());
        backUpImage.setContactAddrCountry(fileElement.getContactAddrCountry());
        backUpImage.setContactAddrPostalCode(fileElement.getContactAddrPostalCode());
        logger.debug(fileElement.getO365LastModifiedTime() + "..taskkduedate..." + fileElement.getTaskDueDate());
        boolean isMail = false;
        if (device.getOsType().equalsIgnoreCase("OUTLOOK")) {
            isMail = true;
            backUpImage.setEwsId(fileElement.getEwsId());
        }
        backUpImage.setMail(isMail);
        ArrayList<MailAttachment> attachments = new ArrayList<MailAttachment>();
        if (!CollectionUtils.isEmpty((Collection)fileElement.getAttachments())) {
            for (Object elementattachment : fileElement.getAttachments()) {
                logger.debug("..mailattachment..." + elementattachment);
                MailAttachment mailAttachment = new MailAttachment();
                BeanUtils.copyProperties((Object)elementattachment, (Object)mailAttachment);
                logger.debug("..mailattachment val... ..." + elementattachment.getName());
                attachments.add(mailAttachment);
            }
            backUpImage.setAttachments(attachments);
        }
        if (fileElement.getFromEmailAddress() != null) {
            OutlookEmailAddress outlookEmailAddress = new OutlookEmailAddress();
            BeanUtils.copyProperties((Object)fileElement.getFromEmailAddress(), (Object)outlookEmailAddress);
            backUpImage.setFromEmailAddress(outlookEmailAddress);
        }
        ArrayList<OutlookEmailAddress> addresses = new ArrayList<OutlookEmailAddress>();
        if (!CollectionUtils.isEmpty((Collection)fileElement.getToRecipientsAddress())) {
            for (OutlookEmailAddressElement address : fileElement.getToRecipientsAddress()) {
                emailAddress = new OutlookEmailAddress();
                BeanUtils.copyProperties((Object)address, (Object)emailAddress);
                addresses.add(emailAddress);
            }
            backUpImage.setToRecipientsAddress(addresses);
        }
        if (!CollectionUtils.isEmpty((Collection)fileElement.getCcRecipientsAddress())) {
            addresses = new ArrayList();
            for (OutlookEmailAddressElement address : fileElement.getCcRecipientsAddress()) {
                emailAddress = new OutlookEmailAddress();
                BeanUtils.copyProperties((Object)address, (Object)emailAddress);
                addresses.add(emailAddress);
            }
            backUpImage.setCcRecipientsAddress(addresses);
        }
        if (!CollectionUtils.isEmpty((Collection)fileElement.getBccRecipientsAddress())) {
            addresses = new ArrayList();
            for (OutlookEmailAddressElement address : fileElement.getBccRecipientsAddress()) {
                emailAddress = new OutlookEmailAddress();
                BeanUtils.copyProperties((Object)address, (Object)emailAddress);
                addresses.add(emailAddress);
            }
            backUpImage.setBccRecipientsAddress(addresses);
        }
        if (fileElement.getSentDate() != null) {
            Date sentDate = null;
            try {
                SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                sentDate = f.parse(fileElement.getSentDate());
                backUpImage.setSentDate(sentDate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (!(sentDate == null && StringUtils.isEmpty((String)fileElement.getSubject()) && StringUtils.isEmpty((String)fileElement.getBodyContent()) || sentDate == null)) {
                backUpImage.setLastServerModifiedTime(sentDate.getTime());
            }
        }
        backUpImage.setLastServerModifiedTime(System.currentTimeMillis());
        return this.createRevisionForExternalBackupFile(cloudId, cloudName, intermediateFile, backUpImage, filesizeInKB, device);
    }

    private String getFsPathForFile(String md5) {
        return PathGenerator.getFsPath((String)md5);
    }

    public static void convertToBackUpImage(BackupElement fileElement, String regID, BackUpImage backUpImage, Device device, boolean isBaseBackupFolder, String fsPath, String status) {
        long timeMilliSec = System.currentTimeMillis();
        backUpImage.setDevicePath(fileElement.getFileCompletePath());
        backUpImage.setFileName(fileElement.getFileName());
        backUpImage.setDeviceUUID(device.getDeviceUUID());
        backUpImage.setLastServerModifiedTime(timeMilliSec);
        backUpImage.setFolder(fileElement.isFolder());
        backUpImage.setMd5Checksum(fileElement.getMd5Checksum());
        backUpImage.setPresent(fileElement.isPresent());
        backUpImage.setfSPath(fsPath);
        backUpImage.setStatus(status);
        backUpImage.setLastClientModifiedTime(fileElement.getLastClientModifiedTime());
        backUpImage.setBaseBackup(isBaseBackupFolder);
        backUpImage.setSize(fileElement.getSize());
        backUpImage.setOdItemId(fileElement.getOdItemId());
        backUpImage.setEwsId(fileElement.getEwsId());
        backUpImage.setOdParentItemId(fileElement.getParentItemId());
        backUpImage.setUserName(device.getUserName());
        if (fileElement.getAccessTime() != 0L) {
            backUpImage.setAccessTime(fileElement.getAccessTime());
        }
        if (!StringUtils.isEmpty((String)fileElement.getContainerName())) {
            backUpImage.setContainerName(fileElement.getContainerName());
        }
        if (!StringUtils.isEmpty((String)fileElement.getContainerType())) {
            backUpImage.setContainerType(fileElement.getContainerType());
        }
    }

    public ObjectId createRevisionForExternalBackupFile(int cloudId, String cloudName, File intermediateUploadPath, BackUpImage backUpImage, long fileSize, Device device) throws IOException {
        return this.createParentsAndSaveEntryForExternalBackup(cloudId, cloudName, backUpImage, device);
    }

    public ObjectId createParentsAndSaveEntryForExternalBackup(int cloudId, String cloudName, BackUpImage backUpImage, Device device) {
        List<BackupElement> fileElementList;
        BackUpImage parentBackUpImage = this.getParentFile(cloudId, cloudName, backUpImage, device);
        BaseController.printLogs(backUpImage.getEwsId() + "... parent file path ews.... " + backUpImage.getDevicePath(), PCHelperConstant.isBrevityLogging());
        if (!(parentBackUpImage != null && parentBackUpImage.isPresent() || (fileElementList = this.getParentfolders(cloudId, cloudName, backUpImage.getDevicePath(), device, backUpImage.getContainerName(), backUpImage.getContainerType())) == null || CollectionUtils.isEmpty(fileElementList))) {
            logger.debug("getO365LastModifiedTime1....." + backUpImage.getO365LastModifiedTime());
            this.createParentFolders(cloudId, cloudName, fileElementList, device, backUpImage.getOdParentItemId());
        }
        if (!StringUtils.isEmpty((String)backUpImage.getContainerName())) {
            this.setContainerDetailsForBackupImage(backUpImage);
        }
        logger.debug(backUpImage.getFileName() + "...getO365LastModifiedTime2....." + backUpImage.getO365LastModifiedTime());
        backUpImage.setExternalStorage(true);
        this.backUpImageDao.saveImageToBackUp(cloudId, backUpImage, device);
        BaseController.printLogs(backUpImage.getO365LastModifiedTime() + "...ewwsssiiiddd...." + backUpImage.getEwsId() + "....id... " + backUpImage.getId(), PCHelperConstant.isBrevityLogging());
        return backUpImage.getId();
    }

    public void createParentFolders(int cloudId, String cloudName, List<BackupElement> fileElementList, Device device, String parentItemId) {
        for (BackupElement fileElement : fileElementList) {
            BackUpImage oldBckupImage;
            if (fileElement.getFileCompletePath() == null) {
                oldBckupImage = this.backUpImageDao.getBackUpImageForFileWithNullPath(cloudId, cloudName, fileElement.getFileName(), device);
            } else {
                boolean readPreference = false;
                if (PCHelperConstant.isReadPreferenceFromSecondary()) {
                    logger.debug(" Readpreference to Secondary createParentFolders .......");
                    readPreference = true;
                }
                oldBckupImage = this.backUpImageDao.getBackUpImageFolder(cloudId, cloudName, fileElement.getFileName(), fileElement.getFileCompletePath(), device, readPreference, true);
            }
            if (oldBckupImage != null && oldBckupImage.isPresent()) continue;
            BackUpImage backUpImage = new BackUpImage();
            BackupServiceImpl.convertToBackUpImage(fileElement, device.getDeviceUUID(), backUpImage, device, false, PathGenerator.getFsPath((String)fileElement.getMd5Checksum()), PCHelperConstant.REVISION_STATUS.ADDED.toString());
            if (Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(device.getDeviceType())) {
                if (!"Files".equalsIgnoreCase(backUpImage.getFileName())) {
                    String path = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                    logger.debug("....before getting  path itemidfor folder ..... ");
                    String folderItemId = this.msUtilDao.getFolderItemId(path, device.getDeviceUUID());
                    logger.debug("....after path itemidfor folder ..... " + path + "...... " + folderItemId);
                    if (!StringUtils.isEmpty((String)folderItemId)) {
                        backUpImage.setOdItemId(folderItemId);
                    } else {
                        backUpImage.setOdItemId(parentItemId);
                    }
                } else {
                    backUpImage.setOdItemId("");
                }
            }
            this.backUpImageDao.saveImageToBackUpDao(cloudId, cloudName, backUpImage, device);
        }
    }

    private BackUpImage getParentFile(int cloudId, String cloudName, BackUpImage childBackUpImage, Device device) {
        String fileName;
        String parentFilePath = childBackUpImage.getDevicePath();
        if (parentFilePath == null) {
            return null;
        }
        int lastIndex = parentFilePath.lastIndexOf(47);
        if (lastIndex == -1 && "".equals(parentFilePath)) {
            return null;
        }
        if (parentFilePath.endsWith("/")) {
            parentFilePath = parentFilePath.substring(0, lastIndex);
            lastIndex = parentFilePath.lastIndexOf(47);
            fileName = parentFilePath.substring(lastIndex + 1);
        } else {
            fileName = parentFilePath.substring(lastIndex + 1);
        }
        String filePath = null;
        if (lastIndex != -1) {
            filePath = parentFilePath.substring(0, parentFilePath.length() - fileName.length() - 1);
        }
        return this.getBackUpImage(cloudId, cloudName, fileName, filePath, device, true);
    }

    public BackUpImage getBackUpImage(int cloudId, String cloudName, String fileName, String folderPath, Device device, boolean folder) {
        boolean readPreference = false;
        if (PCHelperConstant.isReadPreferenceFromSecondary()) {
            logger.debug(" Readpreference to Secondary getBackUpImage .......");
            readPreference = true;
        }
        logger.debug(".....before callinggetBackUpImageFolder.... " + folderPath + ".." + fileName);
        return this.backUpImageDao.getBackUpImageFolder(cloudId, cloudName, fileName, folderPath, device, readPreference, folder);
    }

    private List<BackupElement> getParentfolders(int cloudId, String cloudName, String parentFilePath, Device device, String containerName, String containerType) {
        BackUpImage backUpImage;
        String fileName;
        String parentFilePathTemp = parentFilePath;
        ArrayList<BackupElement> elements = new ArrayList<BackupElement>();
        BackupElement fileElement = new BackupElement();
        if (parentFilePathTemp == null) {
            return null;
        }
        int lastIndex = parentFilePathTemp.lastIndexOf(47);
        if (lastIndex == -1 && "".equals(parentFilePathTemp)) {
            return null;
        }
        if (parentFilePathTemp.endsWith("/")) {
            parentFilePathTemp = parentFilePathTemp.substring(0, lastIndex);
            lastIndex = parentFilePathTemp.lastIndexOf(47);
            fileName = parentFilePathTemp;
        } else {
            fileName = parentFilePathTemp.substring(lastIndex + 1);
        }
        String filePath = null;
        if (lastIndex != -1) {
            filePath = parentFilePathTemp.substring(0, parentFilePathTemp.length() - fileName.length() - 1);
        }
        if ((backUpImage = this.getBackUpImage(cloudId, cloudName, fileName, filePath, device, true)) != null && backUpImage.isPresent()) {
            return null;
        }
        fileElement.setFileName(fileName);
        fileElement.setFolder(true);
        if (filePath != null && filePath.isEmpty()) {
            filePath = "ROOT";
        }
        fileElement.setFileCompletePath(filePath);
        fileElement.setMd5Checksum("null");
        fileElement.setPresent(true);
        fileElement.setSize(0L);
        if (containerName != null && fileElement.getFileCompletePath() != null) {
            if (!fileElement.getFileCompletePath().endsWith(containerName)) {
                fileElement.setContainerName(null);
            } else {
                fileElement.setContainerName(containerName);
            }
        }
        elements.add(fileElement);
        List<BackupElement> elements2 = this.getParentfolders(cloudId, cloudName, fileElement.getFileCompletePath(), device, containerName, containerType);
        if (elements2 != null) {
            elements.addAll(elements2);
        }
        return elements;
    }

    private void removeBackupImage(BackUpImage toDeleteBackupImage, int cloudId, String cloudName, Device device) {
        this.backUpImageDao.deleteRevision(cloudId, cloudName, toDeleteBackupImage, device);
        List chunkFiles = toDeleteBackupImage.getChunkFiles();
        String userName = toDeleteBackupImage.getUserName();
        String dedupVal = this.getDedupValue(userName);
        block4: for (ChunkFile chunkFile : chunkFiles) {
            ChunkDetail chunkDetail = null;
            chunkDetail = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(toDeleteBackupImage.getUserName(), dedupVal, chunkFile.getMd5(), toDeleteBackupImage.getLastServerModifiedTime(), chunkDetail, false);
            if (chunkDetail == null) {
                logger.debug("................chunk detail is empty for userName " + toDeleteBackupImage.getUserName() + " so search with userName case insesitive...........");
                chunkDetail = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(toDeleteBackupImage.getUserName(), dedupVal, chunkFile.getMd5(), toDeleteBackupImage.getLastServerModifiedTime(), chunkDetail, true);
            }
            if (chunkDetail == null) continue;
            try {
                chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                logger.debug(" Chunk updated succcessfully for delete ..........");
            }
            catch (OptimisticLockingFailureException e) {
                logger.trace("" + (Object)((Object)e));
                logger.error("Exception while removing backup image :" + e.getMessage());
                int count = 0;
                int maxTries = PCHelperConstant.getMaxRetryForChunkUpdate();
                while (true) {
                    try {
                        logger.debug(" retry chunk update ..............." + chunkFile.getMd5());
                        ChunkDetail chunkDetailObj = null;
                        chunkDetailObj = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(toDeleteBackupImage.getUserName(), dedupVal, chunkFile.getMd5(), toDeleteBackupImage.getLastServerModifiedTime(), chunkDetailObj, false);
                        if (chunkDetailObj == null) {
                            logger.debug("................chunk detail is empty for userName " + toDeleteBackupImage.getUserName() + " so search with userName case insesitive...........");
                            chunkDetailObj = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(toDeleteBackupImage.getUserName(), dedupVal, chunkFile.getMd5(), toDeleteBackupImage.getLastServerModifiedTime(), chunkDetailObj, true);
                        }
                        chunkDetailObj.setRefCount(chunkDetailObj.getRefCount() - 1);
                        logger.debug(chunkFile.getMd5() + " @@@@@@ ................ retry count " + count);
                        this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
                        continue block4;
                    }
                    catch (Exception ex) {
                        logger.trace("" + ex);
                        logger.error(" ex ..." + ex.getMessage());
                        if (++count != maxTries) continue;
                    }
                    break;
                }
            }
        }
    }

    private void setContainerDetailsForBackupImage(BackUpImage backUpImage) {
        Path p = Paths.get(backUpImage.getDevicePath(), new String[0]);
        String parentFile = p.getFileName().toString();
        if (!parentFile.equalsIgnoreCase(backUpImage.getContainerName())) {
            backUpImage.setContainerName(null);
            backUpImage.setContainerType(null);
        }
    }

    private String getDedupValue(String userName) {
        String dedupVal = null;
        User userByName = this.userDao.getUserByName(1, userName);
        if (userByName != null && !StringUtils.isEmpty((String)userByName.getPolicyName())) {
            BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(1, userByName.getPolicyName());
            dedupVal = backupPolicy.getDedup();
        }
        return dedupVal;
    }
}

