/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.Cloud;
import com.pg.domain.FileInfo;
import com.pg.element.FileElement;
import com.pg.element.FileListElement;
import com.pg.element.RestoreElement;
import com.pg.exception.BlukryptClientAbortException;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.paracloud.to.DownloadTO;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncDownloadService;
import com.pg.util.ResourceFileHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SyncDownloadController {
    private static Logger logger = LogManager.getLogger(SyncDownloadController.class);
    @Autowired
    private SyncDownloadService syncDownloadService;
    @Autowired
    private UtilService utilService;
    @Autowired
    private UploadService uploadService;
    private static final String UNABLE_TO_DOWNLOAD_FILE = "  UNALBE TO DOWNLOAD FILE ";
    private static final String DOWNLOAD_FILE_COMPLETED = "  DOWNLOAD FILE  Completed ....";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/sync/restore/"}, method={RequestMethod.POST})
    public void downloadFile(@PathVariable(value="cloudName") String cloudName, @RequestBody FileListElement fileListElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(" inside restore ............... " + fileListElement);
        List list = fileListElement.getFileElementList();
        for (FileElement element : list) {
            logger.debug(" 1111 ......... " + element.getFileName());
        }
        int cloudId = 1;
        Cloud cloud = this.utilService.getCloud(cloudId);
        String restorePath = "";
        String deviceMntPath = "";
        try {
            RestoreElement restoreElement = this.getRestoreElementFromRequest(request);
            restoreElement.setCloudName(cloud.getCloudName());
            String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)restoreElement.getCloudName()) + restoreElement.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            restorePath = path + restoreElement.getRestoreBatchId() + "/";
            deviceMntPath = path;
            String userName = this.utilService.getUserNameFromDevice(cloudId, restoreElement.getDeviceUUID());
            logger.debug("##Start of full restore of device .... " + userName + " ... device .... " + restoreElement.getDeviceUUID());
            long count = list.size();
            logger.debug(count + " RESTORE-total count ........ " + restoreElement.getDevicePath());
            try {
                response.getOutputStream().println("Content-Type: multipart/form-data;boundary=--PARABLUEOF");
            }
            catch (IOException e2) {
                logger.trace("" + e2);
                logger.error("Exception When Getting Downloading File :" + e2.getMessage());
            }
            int skipValue = 0;
            long downloadedCount = 0L;
            HashMap<String, Long> fileVersionMap = new HashMap<String, Long>();
            this.syncDownloadService.restoreFilesFromCloud(cloud, restoreElement, userName, response, skipValue, count, downloadedCount, fileVersionMap, list);
            response.getOutputStream().println();
            response.getOutputStream().write("----PARABLUEOF--\r\n".getBytes());
            response.getOutputStream().close();
        }
        catch (BlukryptClientAbortException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Client aborted ........" + e.getMessage());
            response.setStatus(500);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(UNABLE_TO_DOWNLOAD_FILE + e.getMessage());
            response.setStatus(500);
        }
        finally {
            try {
                logger.debug(restorePath + " inside finally block ..... " + deviceMntPath);
                this.deleteDirs(restorePath, deviceMntPath);
                response.getOutputStream().close();
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error("Client abort exception ......" + e.getMessage());
            }
        }
        logger.debug(" download completed .... ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/sync/download/file/"}, method={RequestMethod.GET})
    public void downloadFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        BufferedInputStream inputStream = null;
        try {
            String fileName = request.getHeader("file-name");
            logger.debug("  DOWNLOAD FILE  STARTED ...." + fileName);
            String folderPath = request.getHeader("file-path");
            String deviceUUID = request.getHeader("deviceUUID");
            String userName = request.getHeader("userName");
            String syncRevisionId = request.getHeader("syncRevisionId");
            String gatewayName = request.getHeader("gatewayName");
            DownloadTO downloadTO = null;
            String saltKey = this.utilService.getEncryptionKey(1, "sync");
            logger.debug(syncRevisionId + "  SALT KEY ..................... " + saltKey);
            Cloud cloud = this.utilService.getCloud(1);
            downloadTO = this.syncDownloadService.restoreFile(cloud, cloudName, userName, fileName, folderPath, saltKey, deviceUUID, syncRevisionId, gatewayName, false, true);
            if (downloadTO != null) {
                BufferedInputStream decryptedStream = null;
                if ((decryptedStream = this.getDecryptedStreamFromDisk(downloadTO, decryptedStream)) != null) {
                    response.addHeader("file-size", String.valueOf(downloadTO.getSize()));
                    response.setStatus(200);
                    response.addHeader("fileMD5", downloadTO.getMd5());
                    response.setContentType(downloadTO.getMimeType());
                    inputStream = decryptedStream;
                    this.readStreamAndSetToResponse(response, inputStream);
                    response.setHeader("MD5", downloadTO.getMd5());
                    logger.debug(DOWNLOAD_FILE_COMPLETED + downloadTO.getMd5());
                    response.setStatus(200);
                } else if (downloadTO.getErrorCode() == null || "INVALID_ACCESS_TOKEN".equals(downloadTO.getErrorCode())) {
                    response.setStatus(204);
                }
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(UNABLE_TO_DOWNLOAD_FILE + e.getMessage());
            response.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        logger.debug(DOWNLOAD_FILE_COMPLETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/sync/portal/download/file/"}, method={RequestMethod.GET})
    public void downloadSyncPortalFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        InputStream inputStream = null;
        String browserType = request.getHeader("user-agent");
        try {
            String fileName = "";
            String syncRevisionId = "";
            String filePath = "";
            String userName = "";
            String gatewayName = "";
            String loginUserName = "";
            String fileUser = "";
            boolean isFolder = false;
            Map parameters = request.getParameterMap();
            for (String key : parameters.keySet()) {
                String[] vals;
                for (String val : vals = (String[])parameters.get(key)) {
                    logger.debug(key + "....." + val);
                    if ("fileName".equalsIgnoreCase(key)) {
                        fileName = val;
                    }
                    if ("syncRevisionId".equalsIgnoreCase(key)) {
                        syncRevisionId = val;
                    }
                    if ("filePath".equalsIgnoreCase(key)) {
                        filePath = val;
                    }
                    if ("userName".equalsIgnoreCase(key)) {
                        userName = val;
                        userName = this.decodeBase64UTFString(userName);
                    }
                    if ("gatewayName".equalsIgnoreCase(key)) {
                        gatewayName = val;
                    }
                    if ("isFolder".equalsIgnoreCase(key)) {
                        isFolder = Boolean.parseBoolean(val);
                    }
                    if ("loginUserName".equalsIgnoreCase(key)) {
                        loginUserName = val;
                        loginUserName = this.decodeBase64UTFString(loginUserName);
                    }
                    if (!"fileUser".equalsIgnoreCase(key)) continue;
                    fileUser = val;
                }
            }
            logger.debug(syncRevisionId + " Filename ..." + fileName);
            logger.debug(syncRevisionId + "  DOWNLOAD FILE  STARTED for portal1 ...." + fileName);
            if (StringUtils.isNotEmpty((String)fileName)) {
                fileName = this.decodeBase64UTFString(fileName);
            }
            if (StringUtils.isNotEmpty((String)filePath)) {
                filePath = this.decodeBase64UTFString(filePath);
            }
            String deviceUUID = "Portal";
            DownloadTO downloadTO = null;
            String saltKey = this.utilService.getEncryptionKey(1, "sync");
            Cloud cloud = this.utilService.getCloud(1);
            downloadTO = this.syncFileDownloadForPortal(cloud, cloudName, userName, fileName, filePath, saltKey, deviceUUID, syncRevisionId, gatewayName, false, response, browserType, isFolder, fileUser);
            if (downloadTO != null) {
                response.setStatus(200);
                this.saveAuditHistory(fileName, filePath, loginUserName, cloud);
            }
            if (downloadTO != null) {
                long filesizeInKB = (long)Math.ceil((double)downloadTO.getSize() / 1024.0);
                this.utilService.saveSyncOverview(1, 0L, filesizeInKB, 0L, 1L);
            }
        }
        catch (ParacloudBackupException e) {
            logger.trace("" + (Object)((Object)e));
            logger.debug(" File not found during download  ...." + e.getMessage());
            response.setStatus(449);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace("" + e);
            logger.error(UNABLE_TO_DOWNLOAD_FILE + e.getMessage());
            response.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        logger.debug(" end of  download file  Completed for portal ....");
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.error("" + e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    private void saveAuditHistory(String fileName, String filePath, String loginUserName, Cloud cloud) {
        if (!StringUtils.isEmpty((String)loginUserName)) {
            AuditHistory auditHistory = new AuditHistory();
            StringBuilder action = new StringBuilder("Downloaded file ");
            auditHistory.setAction(action.toString());
            auditHistory.setActionByUserName(loginUserName);
            auditHistory.setActionOnObject(filePath + "/" + fileName);
            auditHistory.setTimestamp(System.currentTimeMillis());
            auditHistory.setActionUsingObject("Portal");
            auditHistory.setActionType(4);
            if (filePath.substring(8).startsWith("_mc_")) {
                auditHistory.setMiniCloud(true);
                auditHistory.setMcName(SyncDownloadController.getMCName(filePath).substring(4));
                auditHistory.setActionOnObject(filePath + "/" + fileName + " inside minicloud " + SyncDownloadController.getMCName(filePath).substring(4));
            }
            logger.debug("Action type" + auditHistory.getActionType());
            this.utilService.saveAudit(cloud.getCloudId(), auditHistory);
        }
    }

    private static String getMCName(String path) {
        String[] list = path.split("/");
        if (list != null && list.length == 1) {
            return "";
        }
        return list[1];
    }

    private DownloadTO syncFileDownloadForPortal(Cloud cloud, String cloudName, String userName, String fileName, String filePath, String saltKey, String deviceUUID, String syncRevisionId, String gatewayName, boolean b, HttpServletResponse response, String browserType, boolean isFolder, String fileUser) {
        if (!isFolder) {
            return this.syncDownloadService.restoreFileForPortal(cloud, cloudName, userName, fileName, filePath, saltKey, deviceUUID, syncRevisionId, gatewayName, false, response, browserType, fileUser);
        }
        return this.syncDownloadService.restoreFolderForPortal(cloud, cloudName, userName, fileName, filePath, saltKey, deviceUUID, syncRevisionId, gatewayName, false, response, browserType, fileUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/sync/portal/view/file/"}, method={RequestMethod.GET})
    public void viewSyncPortalFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String browserType = request.getHeader("user-agent");
        InputStream inputStream = null;
        try {
            String fileName = request.getHeader("file-name");
            String syncRevisionId = request.getHeader("syncRevisionId");
            logger.debug(syncRevisionId + "  DOWNLOAD FILE  STARTED for portal1 ...." + fileName);
            String folderPath = request.getHeader("file-path");
            String deviceUUID = "Portal";
            String userName = request.getHeader("userName");
            String gatewayName = request.getHeader("gatewayName");
            DownloadTO downloadTO = null;
            String saltKey = this.utilService.getEncryptionKey(1, "sync");
            Cloud cloud = this.utilService.getCloud(1);
            downloadTO = this.syncDownloadService.restoreFileForPortal(cloud, cloudName, userName, fileName, folderPath, saltKey, deviceUUID, syncRevisionId, gatewayName, false, response, browserType, userName);
            if (downloadTO != null && downloadTO.getSize() >= 0L) {
                response.setStatus(200);
            } else {
                logger.debug("file download file input stream is null>>>>>>>>>>>$$$$$$$$$$$$ ");
                response.setStatus(449);
            }
        }
        catch (ParacloudBackupException e) {
            logger.trace("" + (Object)((Object)e));
            logger.debug(" File not found during download  ...." + e.getMessage());
            response.setStatus(449);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(UNABLE_TO_DOWNLOAD_FILE + e.getMessage());
            response.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        logger.debug(" end of  download file  Completed for portal ....");
    }

    private RestoreElement getRestoreElementFromRequest(HttpServletRequest request) {
        RestoreElement restoreElement = new RestoreElement();
        String deviceUUID = request.getHeader("deviceUUID");
        restoreElement.setDeviceUUID(deviceUUID);
        restoreElement.setRestoreBatchId(request.getHeader("batchId"));
        return restoreElement;
    }

    private void deleteDirs(String restorePath, String deviceMntPath) {
        File restoreDir;
        if (!StringUtils.isEmpty((String)restorePath) && (restoreDir = new File(restorePath)).exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)restoreDir);
            restoreDir.delete();
        }
        if (!StringUtils.isEmpty((String)deviceMntPath)) {
            String decryptPath = deviceMntPath + "decrypted";
            logger.debug(" decrypt folder delete " + decryptPath);
            File decryptPathDir = new File(decryptPath);
            if (decryptPathDir.exists()) {
                ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)decryptPathDir);
            }
        }
    }

    private BufferedInputStream getDecryptedStreamFromDisk(DownloadTO downloadTO, BufferedInputStream decryptedStream) {
        String destFile = downloadTO.getPath();
        BufferedInputStream decryptedStreamTemp = null;
        try {
            File file = new File(destFile);
            if (file.exists()) {
                decryptedStreamTemp = new BufferedInputStream(new FileInputStream(file), 1024);
                logger.debug("************************DOWNLOADED*********************************" + destFile);
            }
        }
        catch (FileNotFoundException e) {
            logger.trace("" + e);
            logger.error(e + " Unable to get decrypt file stream " + downloadTO.getPath(), (Object)e.getMessage());
        }
        return decryptedStreamTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStreamAndSetToResponse(HttpServletResponse response, InputStream inputStream) {
        try {
            int len;
            byte[] buffer = new byte[4096];
            int gcSize = 0;
            int gcThreadHold = 0x100000;
            while ((len = inputStream.read(buffer)) > 0) {
                response.getOutputStream().write(buffer, 0, len);
                if ((gcSize += len) <= gcThreadHold) continue;
                gcSize = 0;
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Reading the Stream and set to Response :" + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @RequestMapping(value={"get/fileInfo/sync/"}, method={RequestMethod.GET})
    public ResponseEntity<FileInfo> getFileInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String cloudName = request.getHeader("cloudName");
        String syncId = request.getHeader("syncId");
        logger.debug(syncId + " get/fileInfo/sync/  ..........." + cloudName);
        FileInfo fileInfo = this.uploadService.getFileFromPG("", cloudName, syncId, true);
        if (fileInfo == null) {
            logger.debug(cloudName + " file not found  ..........." + syncId);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        ResponseEntity entity = new ResponseEntity((Object)fileInfo, HttpStatus.OK);
        logger.debug(" end of get/fileInfo/sync/  ... ...........");
        return entity;
    }
}

