/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.cloudbackup;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.httpcore.HttpClients;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.parablu.cloudbackup.CloudBackupStorageBridge;
import com.parablu.cloudbackup.UploadStatus;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Components;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.pg.controller.BaseController;
import com.pg.controller.Graph;
import com.pg.domain.BackupAttempt;
import com.pg.domain.DriveFileInfo;
import com.pg.exception.BaseException;
import com.pg.exception.OverloadLimitReachedException;
import com.pg.exception.UserStorageLimitReachedException;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.ComponentSettingService;
import com.pg.service.JobConfigService;
import com.pg.service.UtilService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.CollectionUtils;

public enum StorageService {
    GETINST;

    private static final String AUTHORITY = "https://login.microsoftonline.com/";
    private static final String RESOURCE = "https://outlook.office365.com";
    private static final String IS_TOMCAT_RUNNING = "isTomcatRunning";
    private static final long DAY_IN_MS = 86400000L;
    private static final String BACKUP = "BACKUP";
    private static final String COMPLETED = "COMPLETED";
    private static final String STOPPED_BACKUP_ERROR_CODE = "1209";
    private static final String PAUSED_BACKUP_ERROR_CODE = "1208";
    public static final String INTERRUPTED_STATUS = "INTERRUPTED";
    public static final int STATUS_LICENSE_ACTIVE = 1500;
    public static final int STATUS_LICENSE_EXPIRED = 1501;
    private static final String STARTED = "STARTED";
    static final Logger logger;
    CloudBackupStorageBridge uploadService;
    UtilService utilServiceObj;
    ComponentSettingService componentSettingServiceObj;
    JobConfigService jobConfigServiceObj;
    volatile boolean shutdown = false;
    static final String BASE_FOLDER = "Files/";
    private Set<String> fileUnderProcess = new HashSet<String>();
    private Set<String> deviceUUIDUnderProcess = new HashSet<String>();
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    private Timer userDownloadTimer = null;
    private TimerTask userDownloadTimerTask = null;
    private Set<String> batchUnderProcess = new HashSet<String>();
    private static List<ODBBackupBatch> batchList;
    private static List<DriveFileInfo> batchFilesList;

    public boolean initialize(CloudBackupStorageBridge uploadService, UtilService utilService, ComponentSettingService componentSettingService, JobConfigService jobConfigService) {
        try {
            logger.debug("Storage service!");
            this.uploadService = uploadService;
            this.utilServiceObj = utilService;
            this.componentSettingServiceObj = componentSettingService;
            this.jobConfigServiceObj = jobConfigService;
            logger.info("response handler started");
        }
        catch (Exception e) {
            logger.error("Failed to start the consumer! " + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void run() {
        logger.debug("....starting storageservice .....");
        if (PCHelperConstant.getPGOverloadLimit() <= 0) {
            logger.debug("....... overload limit reachedstart .... ");
            return;
        }
        Cloud cloud = this.utilServiceObj.getCloud(1);
        boolean isExchangeBackupEnabled = this.isExchangeBackupEnabled(cloud);
        boolean isOneDriveForBusinessBackupEnabled = this.isOneDriveForBusinessBackupEnabled(cloud);
        if (isOneDriveForBusinessBackupEnabled || isExchangeBackupEnabled) {
            logger.debug("Storage service has started running! - " + Thread.currentThread().getName());
            logger.debug("...inside while loop check....onedrive.. " + isOneDriveForBusinessBackupEnabled + "..exchange.." + isExchangeBackupEnabled);
            ExecutorService executor = null;
            try {
                this.setThreads();
                long threadSize = PCHelperConstant.getPGOverloadLimit();
                logger.debug("...threads...." + threadSize);
                do {
                    if (threadSize > 0L) continue;
                    logger.debug("......wait for 5 mins and retry");
                    Thread.sleep(300000L);
                    this.setThreads();
                    threadSize = PCHelperConstant.getPGOverloadLimit();
                } while (threadSize <= 0L);
                int threadSizeVal = (int)threadSize;
                executor = Executors.newFixedThreadPool(threadSizeVal);
                batchList = this.getBatchFromList(cloud.getCloudId());
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                this.checkThreadStatusAndStartUpload(cloud, executor, pool);
                for (int i = 0; i < threadSizeVal; ++i) {
                    logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                    this.callUploadFiles(cloud, executor, pool);
                }
                logger.debug(" exit upload part..........");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(" exception in backup upload job......." + e.getMessage());
                logger.trace("exception in backup upload job ......." + e);
            }
            logger.debug("Done!");
        }
    }

    private void setThreads() {
        Properties props = null;
        try {
            ClassPathResource resource = new ClassPathResource("privacygateway.properties");
            props = PropertiesLoaderUtils.loadProperties((Resource)resource);
            logger.debug(".....componentn name ..... " + props.getProperty("componentName"));
            Components components = this.componentSettingServiceObj.getComponents(props.getProperty("componentName"), 1);
            logger.debug("getting components properties from db of" + components.getComponentName());
            Map componentProperties = components.getComponentsProperties();
            if (componentProperties.containsKey("officeDownloadThreads")) {
                String threadstr = (String)componentProperties.get("officeDownloadThreads");
                if (!StringUtils.isEmpty((String)threadstr)) {
                    long threadSize = Integer.parseInt(threadstr);
                    logger.debug("...threads from db for offfice ...." + threadSize);
                    PCHelperConstant.setOfficeThreadsValue((String)("" + threadSize));
                }
            } else {
                PCHelperConstant.setOfficeThreadsValue((String)"2");
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            logger.error("...error trying to get threads..." + ee.getMessage());
        }
    }

    private boolean isExchangeBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private boolean isOneDriveForBusinessBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void callUploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        BaseController.printLogs("Files to backup ............... :", PCHelperConstant.isBrevityLogging());
        Runnable uploadJob = () -> this.uploadFiles(cloud, executor, pool);
        pool.submit(uploadJob, "");
    }

    private void uploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        BaseController.printLogs("....inside while loop..........", PCHelperConstant.isBrevityLogging());
        ODBBackupBatch backupBatch = null;
        try {
            backupBatch = this.getBackupBatchFromOneDriveServer();
            if (backupBatch != null) {
                this.processMessage(backupBatch, cloud);
                logger.error(backupBatch.getId() + " %%%%%%% upload completed for file ...." + backupBatch.getUserName());
            }
            if (!CollectionUtils.isEmpty(batchList)) {
                logger.debug("Thread ready for next File .... " + batchList.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("exception inside storageservice .... " + e.getMessage());
            logger.trace("exception inside storageservice ...." + e);
        }
        if (backupBatch != null && backupBatch.getId() != null) {
            this.batchUnderProcess.remove(backupBatch.getId().toString());
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
        }
        logger.error("no files to upload so wait and then retry>>>>");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.callUploadFiles(cloud, executor, pool);
    }

    private int getPrevBatchErrorCode(Cloud cloud, String batchId) {
        int errorCode = 0;
        BackupBatch prevBkpBatch = this.utilServiceObj.getBackupBatchById(cloud.getCloudId(), batchId);
        if (prevBkpBatch != null && StringUtils.isNotEmpty((String)prevBkpBatch.getErrorCode()) && (prevBkpBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) || prevBkpBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE))) {
            errorCode = prevBkpBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) ? 1209 : 1208;
            logger.debug(errorCode + ".....batch status current..." + prevBkpBatch.getErrorCode());
        }
        return errorCode;
    }

    public void processMessage(ODBBackupBatch odbbackupBatch, Cloud cloudval) {
        boolean isTomcatRunning = true;
        if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
            isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
        }
        if (!isTomcatRunning) {
            logger.error("....tomcat is stopping so no process of files.......");
            return;
        }
        BackupBatch backupBatch = new BackupBatch();
        BeanUtils.copyProperties((Object)odbbackupBatch, (Object)backupBatch);
        backupBatch.setBatchStartTimestamp(odbbackupBatch.getBatchStartTimestamp());
        backupBatch.setId(odbbackupBatch.getId());
        String policyName = backupBatch.getOdbPolicyName();
        String batchId = backupBatch.getId().toString();
        int cloudId = cloudval.getCloudId();
        DeviceBackupOverView deviceBackupOverView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID());
        long batchStartTime = odbbackupBatch.getBatchStartTimestamp();
        BackupBatch pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), batchId);
        logger.debug(batchId + ".. files to process backup for id latest..... " + pbBkpBatch);
        if (pbBkpBatch != null) {
            logger.debug(".. batch details..... " + pbBkpBatch.getNoOfFiles() + "...." + pbBkpBatch.getUploadedFiles());
        } else {
            logger.debug(".. batch details null..... ");
        }
        int uploadedFiles = 0;
        int overAllPrevFiles = 0;
        long totalNoOfFiles = 0L;
        if (pbBkpBatch != null) {
            logger.debug(pbBkpBatch.getNoOfFiles() + ".. files to process backup for id..... " + pbBkpBatch.getUploadedFiles());
            String[] parts = pbBkpBatch.getUploadedFiles().split("/");
            try {
                uploadedFiles = Integer.parseInt(parts[0]);
                overAllPrevFiles = Integer.parseInt(parts[1]);
            }
            catch (Exception e) {
                logger.trace("Exception  :" + e);
                logger.error("Exception  :" + e.getMessage());
            }
        }
        logger.debug(uploadedFiles + "...overall files latest .... " + overAllPrevFiles);
        if (pbBkpBatch != null && pbBkpBatch.getNoOfFiles() > 0L) {
            totalNoOfFiles = overAllPrevFiles;
        } else {
            totalNoOfFiles = this.uploadService.getTotalFilesCountByBatchId(cloudval.getCloudId(), batchId);
            long prevdeltaItems = this.utilServiceObj.getTotalFilesCountByPrevDelta(backupBatch.getUserName());
            totalNoOfFiles += prevdeltaItems;
        }
        if (totalNoOfFiles < 0L) {
            totalNoOfFiles = this.uploadService.getTotalFilesCountByBatchId(cloudval.getCloudId(), batchId);
            long prevdeltaItems = this.utilServiceObj.getTotalFilesCountByPrevDelta(backupBatch.getUserName());
            totalNoOfFiles += prevdeltaItems;
        }
        if (pbBkpBatch == null) {
            long failedFilesCount = this.utilServiceObj.getTotaFailedlFilesFromPrevBackup(backupBatch.getDeviceUUID());
            logger.debug(failedFilesCount + "....total size to upload fdf.&*&ss*... " + totalNoOfFiles);
            if (failedFilesCount > 0L) {
                totalNoOfFiles += failedFilesCount;
            }
            logger.debug(totalNoOfFiles + "....total attempt totalNoOfFiles to upload fdf.&*&*... " + totalNoOfFiles);
            List<DriveFileInfo> failedFiles = this.uploadService.getFailedFiles(backupBatch.getDeviceUUID());
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(failedFiles)) {
                for (DriveFileInfo driveFileInfo : failedFiles) {
                    driveFileInfo.setBackupBatchId(batchId);
                    driveFileInfo.setFailedFile(true);
                    this.utilServiceObj.saveDriveFileInfo(driveFileInfo);
                    ++totalNoOfFiles;
                }
            }
        }
        if (pbBkpBatch != null) {
            backupBatch.setTotalSizeToUpload(pbBkpBatch.getTotalSizeToUpload());
            backupBatch.setBatchStartTimestamp(pbBkpBatch.getBatchStartTimestamp());
            batchStartTime = pbBkpBatch.getBatchStartTimestamp();
        }
        backupBatch.setTotalNoOfFiles("" + totalNoOfFiles);
        boolean isFirstAttempt = false;
        if (pbBkpBatch == null) {
            isFirstAttempt = true;
        }
        com.parablu.pcbd.domain.User userObj = this.utilServiceObj.getUserInfoByName(1, backupBatch.getUserName());
        int unassErrorCode = 0;
        try {
            unassErrorCode = Integer.parseInt(backupBatch.getErrorCode());
            if (userObj != null && userObj.isBackupTargetAssigned() && !userObj.isFailedMailBox()) {
                logger.debug("..user assigned back....");
                unassErrorCode = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        BackupBatch stBatch = this.startBackupBatch(backupBatch, cloudval, uploadedFiles, totalNoOfFiles, unassErrorCode, batchStartTime);
        boolean startOp = true;
        boolean overLoad = false;
        if (PCHelperConstant.getPGOverloadLimit() <= 0) {
            overLoad = true;
        }
        int licenseCode = this.vaildatedLicensceStatus(cloudval);
        boolean licenseExpired = false;
        if (licenseCode == 1501) {
            licenseExpired = true;
        }
        this.updateBatchAttempt(cloudval.getCloudId(), stBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
        isFirstAttempt = false;
        startOp = false;
        int errorCode = 0;
        if (unassErrorCode > 0) {
            errorCode = unassErrorCode;
        }
        Device device = this.utilServiceObj.getDeviceForUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID());
        boolean isMail = false;
        boolean hasMoreFiles = false;
        boolean allFilesCompleted = false;
        boolean isOneDrive = false;
        String driveId = "";
        if (Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(deviceBackupOverView.getOsType())) {
            driveId = this.getDriveIdForUser(userObj.getEmailId());
        }
        if ((pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), batchId)) != null && pbBkpBatch.getTotalNoOfFiles().equalsIgnoreCase("0")) {
            this.utilServiceObj.updateTotalNoOFFiles(cloudval.getCloudId(), batchId, totalNoOfFiles);
        }
        if (deviceBackupOverView == null) {
            logger.debug(" No overview so create deviceoverview backup ...." + backupBatch.getDeviceUUID());
            this.utilServiceObj.saveDeviceBackupOverView(cloudId, device);
            deviceBackupOverView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID());
        }
        if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            isMail = true;
        }
        if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
            isOneDrive = true;
        }
        String token = "";
        if (isMail) {
            try {
                EWSAppSetting appSetting = this.utilServiceObj.getEwsAppSettingDetail(1);
                if (appSetting != null) {
                    if (StringUtils.isEmpty((String)token)) {
                        logger.debug("..token empty  so wait for 1 min...");
                        Thread.sleep(6000L);
                    }
                    token = this.getEWSTokenFromDb(1);
                }
            }
            catch (Exception e) {
                logger.error("...unable to get ews token....");
            }
        }
        logger.debug("...before processing error code... " + errorCode);
        if (errorCode <= 0) {
            List<DriveFileInfo> list;
            boolean firstTime = true;
            int filesProcessed = 0;
            do {
                List<DriveFileInfo> prevFileInfoList;
                block81: {
                    list = new ArrayList();
                    try {
                        if (firstTime) {
                            this.utilServiceObj.getPrevBatchFailedFilesAndUpdate(backupBatch.getDeviceUUID(), batchId);
                            firstTime = false;
                        }
                        list = this.getDriveFileInfoFromListForBatchId(cloudval.getCloudId(), batchId);
                        logger.debug(filesProcessed + "....after adding failed files ...." + list.size());
                        if (isMail) {
                            logger.debug("..prev username... " + odbbackupBatch.getUserName());
                            List<DriveFileInfo> prevFileInfoList2 = this.utilServiceObj.getPrevItemsForMailBkp(odbbackupBatch.getUserName());
                            if (!org.apache.commons.collections.CollectionUtils.isEmpty(prevFileInfoList2)) {
                                list.addAll(prevFileInfoList2);
                            }
                        }
                        BaseController.printLogs(".... startednew threads... ", PCHelperConstant.isBrevityLogging());
                        int officeThreads = Integer.parseInt(PCHelperConstant.getOfficeThreadsValue());
                        officeThreads = 5;
                        logger.debug(".....office threads...." + officeThreads);
                        List<Object> threadList = new ArrayList();
                        threadList = !org.apache.commons.collections.CollectionUtils.isEmpty(list) && list.size() > officeThreads ? list.subList(0, officeThreads) : list;
                        token = this.getEWSTokenFromDb(1);
                        String driveIdVal = driveId;
                        logger.debug(threadList.size() + "...noof items to process parallely..." + list.size());
                        String deviceUUID = device.getDeviceUUID();
                        String destCollection = device.getDestCollection();
                        boolean isOneDriveVal = isOneDrive;
                        String tokenVal = token;
                        threadList.parallelStream().forEach(item -> this.uploadBatchFiles(batchId, (DriveFileInfo)item, cloudval, backupBatch, odbbackupBatch.getOdbPolicyName(), isOneDriveVal, userObj.getEmailId(), driveIdVal, tokenVal, deviceUUID, destCollection));
                        BaseController.printLogs(".... completednew threads... ", PCHelperConstant.isBrevityLogging());
                        List<DriveFileInfo> fileInfoListObj = this.getDriveFileInfoFromListForBatchId(1, batchId);
                        if (org.apache.commons.collections.CollectionUtils.isEmpty(fileInfoListObj)) {
                            logger.debug(".....allfiles completed.... ");
                            allFilesCompleted = true;
                        } else {
                            pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), batchId);
                            if (pbBkpBatch != null && (errorCode = StringUtils.isEmpty((String)pbBkpBatch.getErrorCode()) ? 0 : Integer.parseInt(pbBkpBatch.getErrorCode())) > 0) {
                            }
                        }
                        break block81;
                    }
                    catch (UserStorageLimitReachedException ee) {
                        logger.error("...UserStorageLimitReachedException.... ");
                        errorCode = 449;
                        logger.error(hasMoreFiles + "...cust error code1.... " + ee.getErrorCode() + "...error..." + errorCode);
                        if (errorCode == 449) {
                        }
                        break block81;
                    }
                    catch (OverloadLimitReachedException ee) {
                        logger.error("...OverloadLimitReachedException.... ");
                        errorCode = 1996;
                        logger.error(hasMoreFiles + "...cust error code1.... " + ee.getErrorCode() + "...error..." + errorCode);
                        if (errorCode == 1996) {
                        }
                        break block81;
                    }
                    catch (BaseException ee) {
                        ee.printStackTrace();
                        logger.error("...cust error code val.... " + ee.getErrorCode());
                        errorCode = this.getPrevBatchErrorCode(cloudval, batchId);
                        logger.error(hasMoreFiles + "...cust error code1.... " + ee.getErrorCode() + "...error..." + errorCode);
                        if (!StringUtils.isEmpty((String)ee.getErrorCode())) {
                            errorCode = Integer.parseInt(ee.getErrorCode());
                        }
                        if (errorCode == Integer.parseInt(STOPPED_BACKUP_ERROR_CODE) || errorCode == Integer.parseInt(PAUSED_BACKUP_ERROR_CODE) || errorCode == 449) break;
                        if (errorCode != 1501) break block81;
                    }
                    break;
                }
                list = this.getDriveFileInfoFromListForBatchId(cloudval.getCloudId(), batchId);
                if (!isMail || org.apache.commons.collections.CollectionUtils.isEmpty(prevFileInfoList = this.utilServiceObj.getPrevItemsForMailBkp(odbbackupBatch.getUserName()))) continue;
                list.addAll(prevFileInfoList);
            } while (hasMoreFiles = !org.apache.commons.collections.CollectionUtils.isEmpty(list));
        }
        if (allFilesCompleted && errorCode != Integer.parseInt(STOPPED_BACKUP_ERROR_CODE) && errorCode != Integer.parseInt(PAUSED_BACKUP_ERROR_CODE)) {
            BaseController.printLogs("......allfilescompleted.......", PCHelperConstant.isBrevityLogging());
            this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), errorCode);
            logger.debug(backupBatch.getTotalNoOfFiles() + "..  completed...." + backupBatch.getId());
            if (deviceBackupOverView != null && StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) {
                NotifierEmailBodyElement notifierEmailBodyElement = new NotifierEmailBodyElement();
                notifierEmailBodyElement.setCloudName(cloudval.getCloudName());
                notifierEmailBodyElement.setDeviceName(deviceBackupOverView.getDeviceName());
                notifierEmailBodyElement.setNoOfFilesBackedUp(backupBatch.getTotalNoOfFiles());
                logger.debug("...before mail..." + backupBatch.getTotalNoOfFiles());
                BackupBatch batch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), batchId);
                if (batch != null) {
                    logger.debug("...before mail batch..." + batch.getTotalNoOfFiles());
                    notifierEmailBodyElement.setNoOfFilesBackedUp(batch.getTotalNoOfFiles());
                }
                if (!StringUtils.isEmpty((String)batch.getUploadedSize())) {
                    notifierEmailBodyElement.setTotalBackupSize(StorageService.formatFileSize(Long.parseLong(batch.getUploadedSize())));
                } else {
                    notifierEmailBodyElement.setTotalBackupSize("0");
                }
                this.sendEmail("first-backup-completed", deviceBackupOverView.getUserName(), deviceBackupOverView.getUserName(), deviceBackupOverView.getEmailId(), notifierEmailBodyElement, deviceBackupOverView.getDeviceUUID());
            }
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
            long uploadedSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                uploadedSize = Long.parseLong(backupBatch.getUploadedSize());
            }
        }
        logger.debug("....error code..... " + errorCode);
        if (errorCode == Integer.parseInt(STOPPED_BACKUP_ERROR_CODE)) {
            logger.debug("......STOPPED_BACKUP_ERROR_CODE.......");
            boolean hasMoreRec = false;
            do {
                List<DriveFileInfo> fileInfoList;
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(fileInfoList = this.getDriveFileInfoFromListForBatchId(cloudval.getCloudId(), batchId))) {
                    for (DriveFileInfo item2 : fileInfoList) {
                        if (isMail) {
                            this.utilServiceObj.savePrevItemsForMailBackup(item2);
                        }
                        this.uploadService.removeDriveItem(item2.getId().toString(), isMail);
                    }
                    hasMoreRec = true;
                    continue;
                }
                hasMoreRec = false;
            } while (hasMoreRec);
            this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
            this.utilServiceObj.updatePrevDeviceDeltaToken(cloudval.getCloudId(), backupBatch.getDeviceUUID());
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), "ABORTED", backupBatch.getDeviceUUID(), errorCode);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            long uploadedSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                uploadedSize = Long.parseLong(backupBatch.getUploadedSize());
            }
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
        } else if (errorCode == 449) {
            logger.debug("... http limit reached..... ");
            this.utilServiceObj.updateBatchStatusInOdServer(backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), INTERRUPTED_STATUS, backupBatch.getDeviceUUID(), 1981);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            long uploadedSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                uploadedSize = Long.parseLong(backupBatch.getUploadedSize());
            }
            logger.debug("....user storage limit reached ss... ");
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
        } else if (errorCode == 1501) {
            logger.debug("... Cloud license Expired1..... ");
            this.utilServiceObj.updateLicenseExpiredBatchStatusInOdServer(backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), INTERRUPTED_STATUS, backupBatch.getDeviceUUID(), errorCode);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            logger.debug("... Cloud license Expired2..... ");
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
        } else if (errorCode == 1996) {
            logger.debug("... overload limit reached .... ");
            this.utilServiceObj.updateDeferedBatchStatusInOdServer(backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), INTERRUPTED_STATUS, backupBatch.getDeviceUUID(), 1996);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
            logger.debug("... overload limit reached .updated ... ");
        } else if (errorCode == Integer.parseInt(PAUSED_BACKUP_ERROR_CODE)) {
            logger.debug("... PAUSED_BACKUP_ERROR_CODE..... ");
            this.utilServiceObj.updateBatchStatusInOdServer(backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), "PAUSED", backupBatch.getDeviceUUID(), errorCode);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            long uploadedSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                uploadedSize = Long.parseLong(backupBatch.getUploadedSize());
            }
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
        } else if (unassErrorCode == 543 || unassErrorCode == 544) {
            logger.debug("... Target unassigned..... ");
            this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), INTERRUPTED_STATUS, backupBatch.getDeviceUUID(), unassErrorCode);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            long uploadedSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                uploadedSize = Long.parseLong(backupBatch.getUploadedSize());
            }
            logger.debug("... Target unassigned... ");
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
        } else if (!allFilesCompleted && StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles())) {
            logger.debug("... !allFilesCompleted && StringUtils.isEmpty(backupBatch.getTotalNoOfFiles())..... ");
            List<DriveFileInfo> fileInfoList = this.getDriveFileInfoFromListForBatchId(cloudval.getCloudId(), batchId);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(fileInfoList)) {
                this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
                this.batchUnderProcess.remove(batchId);
                this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
                this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), errorCode);
                if (deviceBackupOverView != null && StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) {
                    NotifierEmailBodyElement notifierEmailBodyElement = new NotifierEmailBodyElement();
                    notifierEmailBodyElement.setCloudName(cloudval.getCloudName());
                    notifierEmailBodyElement.setDeviceName(deviceBackupOverView.getDeviceName());
                    logger.debug("...before mail1..." + backupBatch.getTotalNoOfFiles());
                    BackupBatch batch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), batchId);
                    if (batch != null) {
                        logger.debug("...before mail batch f..." + batch.getTotalNoOfFiles());
                        notifierEmailBodyElement.setNoOfFilesBackedUp(batch.getTotalNoOfFiles());
                    }
                    if (!StringUtils.isEmpty((String)batch.getUploadedSize())) {
                        notifierEmailBodyElement.setTotalBackupSize(StorageService.formatFileSize(Long.parseLong(batch.getUploadedSize())));
                    } else {
                        notifierEmailBodyElement.setTotalBackupSize("0");
                    }
                    this.sendEmail("first-backup-completed", deviceBackupOverView.getUserName(), deviceBackupOverView.getUserName(), deviceBackupOverView.getEmailId(), notifierEmailBodyElement, deviceBackupOverView.getDeviceUUID());
                }
                long uploadedSize = 0L;
                if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                    uploadedSize = Long.parseLong(backupBatch.getUploadedSize());
                }
                this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
            }
        }
        this.utilServiceObj.deleteEventHubForDeviceUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID(), "START_BACKUP");
        boolean isMailAlreadySent = deviceBackupOverView.isStorageLimitMailSent();
        if (isMailAlreadySent) {
            logger.debug("...update mail status.... ");
            this.utilServiceObj.updateUserLimitMailSent(cloudval.getCloudId(), deviceBackupOverView.getDeviceUUID(), false);
        }
    }

    private static int deleteFile(String driveId, String itemId) {
        String fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/items/" + itemId;
        logger.debug("...delete url...." + fileUrl);
        int responseCode = 0;
        try {
            OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
            Request request = new Request.Builder().url(fileUrl).delete().build();
            Call call = okHttpClient.newCall(request);
            Response response = call.execute();
            responseCode = response.code();
            logger.debug("...deleted usinggraph...." + responseCode);
            response.close();
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException....", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("graph exception to delete:", (Object)e.getMessage());
        }
        return responseCode;
    }

    protected String encodeBase64UTFString(String value) {
        String encodedString = value;
        try {
            encodedString = new String(Base64.encodeBase64((byte[])value.getBytes()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.error("" + e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return encodedString;
    }

    public static OkHttpClient getOkHttpClient() {
        String authorityHost = "https://login.microsoftonline.com";
        OkHttpClient httpClient = null;
        if (!StringUtils.isEmpty((String)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            Authenticator proxyAuthenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)PCHelperConstant.getProxyUserName(), (String)PCHelperConstant.getProxyPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            };
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()))).proxyAuthenticator(proxyAuthenticator).build();
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().build();
        }
        return httpClient;
    }

    private double getUsedPercentage(Drive theDrive) {
        long remaining = theDrive.quota.remaining;
        long total = theDrive.quota.total;
        double percentage = (double)remaining / (double)total * 100.0;
        double usedPercent = 100.0 - percentage;
        return usedPercent;
    }

    private static Drive getDrive(GraphServiceClient<Request> graphClient, String userId) {
        Drive drive = graphClient.users(userId).drive().buildRequest(new Option[0]).get();
        return drive;
    }

    private Drive getDriveIdForUser1(Cloud cloud, String emailId) {
        Drive drive = null;
        try {
            com.parablu.pcbd.domain.User user;
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            if (StringUtils.isEmpty((String)userId)) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + emailId + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            if (StringUtils.isEmpty((String)userId) && (user = this.utilServiceObj.getUserDetailsForEmail(cloud.getCloudId(), emailId)) != null) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + user.getUserName() + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
            int retryDrive = 0;
            do {
                drive = StorageService.getDrive(graphClient, userId);
                logger.debug(++retryDrive + "....drive for user...." + drive);
                Thread.sleep(10000L);
            } while (retryDrive < 5 && drive == null || drive == null);
            if (drive != null) {
                logger.debug(emailId + "....drive id for user ... " + drive.id);
                return drive;
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    return this.getDriveIdForUser1(cloud, emailId);
                }
                catch (InterruptedException interruptedException) {
                }
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + emailId);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return drive;
    }

    private void uploadBatchFiles(String batchId, DriveFileInfo item, Cloud cloudval, BackupBatch backupBatch, String policyName, boolean isOneDrive, String emailId, String driveId, String token, String deviceUUID, String destCollection) {
        item.setBackupBatchId(batchId);
        int cloudId = cloudval.getCloudId();
        if (item.isMail()) {
            try {
                boolean fileAlreadyExists = false;
                logger.debug(item.isInPlaceArchive() + "..item-path...." + item.getItemPath());
                if (item.isInPlaceArchive()) {
                    fileAlreadyExists = true;
                } else {
                    BackUpImage bkpImage = this.utilServiceObj.getBackupImageForItemId(cloudId, item.getItemId(), destCollection, deviceUUID);
                    if (bkpImage != null) {
                        fileAlreadyExists = true;
                    }
                }
                if (fileAlreadyExists) {
                    logger.debug(item.getId().toString() + "...mail-exists...." + item.getUserName() + "...." + fileAlreadyExists + "...");
                    this.updateTotalCount(cloudval.getCloudId(), backupBatch);
                    this.updateBackupBatch(backupBatch, cloudval, 0, 0L);
                    this.uploadService.removeDriveItem(item.getId().toString(), item.isMail());
                    return;
                }
            }
            catch (Exception e) {
                logger.error("---unable to check mail dup...");
            }
        }
        logger.debug(item.getId().toString() + "...mail-exists..later1.." + item.getUserName() + "...." + item.getItemPath());
        int errorCode = 0;
        boolean isTomcatRunning = true;
        if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
            isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
        }
        if (!isTomcatRunning) {
            logger.debug("......server is stopping...");
            errorCode = 1207;
            return;
        }
        DeviceBackupOverView deviceBackupOverView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID());
        double fileSizeInMb = this.getFileSizeInMb(item.getSize());
        boolean isUserStorageLimitReached = this.utilServiceObj.isUserO365StorageLimitReached(1, fileSizeInMb, backupBatch.getUserName(), backupBatch.getDeviceUUID());
        BaseController.printLogs(fileSizeInMb + "....is user Storage limit reached ..." + isUserStorageLimitReached, PCHelperConstant.isBrevityLogging());
        if (isUserStorageLimitReached) {
            int userSizeAllowed = 0;
            Device device = this.utilServiceObj.getDeviceForUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID());
            if (device != null && device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
                userSizeAllowed = backupBatch.getOfficeBackupPolicy().getOdUserSizeAllowed();
            }
            if (device != null && device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                userSizeAllowed = backupBatch.getOfficeBackupPolicy().getMailUserSizeAllowed();
            }
            logger.debug(".... user Storage limit reached ...");
            boolean isMailAlreadySent = deviceBackupOverView.isStorageLimitMailSent();
            if (!isMailAlreadySent) {
                this.sendWarningMail(cloudval.getCloudName(), backupBatch.getUserName(), userSizeAllowed, deviceBackupOverView.getDeviceName());
                this.utilServiceObj.updateUserLimitMailSent(cloudval.getCloudId(), deviceBackupOverView.getDeviceUUID(), true);
            }
            logger.error(backupBatch.getUserName() + ".... User Storage limit reached ..... ");
            errorCode = 449;
            logger.error("....stop the backup HTTP_USER_STORAGE_LIMIT_REACHED .....");
        }
        if (errorCode == 0) {
            errorCode = this.getPrevBatchErrorCode(cloudval, batchId);
        }
        logger.debug(errorCode + "...errorcode for item.... " + batchId);
        if (errorCode == 449) {
            throw new UserStorageLimitReachedException("storage limit reached", errorCode);
        }
        int licenseCode = this.vaildatedLicensceStatus(cloudval);
        errorCode = licenseCode == 1501 ? licenseCode : 0;
        logger.debug(errorCode + "....license code ...." + licenseCode);
        if (errorCode > 0) {
            throw new BaseException("custom error", errorCode);
        }
        logger.debug(batchId + "...inside while loop after msg ... " + item);
        int statuscode = 200;
        UploadStatus status = null;
        if (PCHelperConstant.getPGOverloadLimit() <= 0) {
            logger.debug("....... overload limit reached for current threads.. .... ");
            throw new OverloadLimitReachedException("storage limit reached", errorCode);
        }
        if (errorCode <= 0) {
            try {
                status = this.downloadFile(item, driveId, token);
                if (status.getStatus() == 401) {
                    logger.debug("...ews token expired....");
                    try {
                        logger.debug("..token empty  so wait for 5 min...");
                        Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
                        token = this.getEWSTokenFromDb(1);
                    }
                    catch (Exception e) {
                        logger.error("...unable to get ews token....");
                    }
                    status = this.downloadFile(item, driveId, token);
                }
                statuscode = status.getStatus();
            }
            catch (Exception e) {
                logger.error("Failed to handle the message!", (Throwable)e);
                this.fileUnderProcess.remove(item.getItemId());
            }
            if (status != null) {
                item.setSize(Long.valueOf(status.getFileSize()));
            }
            logger.debug(statuscode + ".... before deleting batchid check..... " + backupBatch.getId() + "...size..." + item.getSize());
            if (statuscode != 200) {
                logger.debug(item.isFailedFile() + "...failed case statuscode...." + statuscode);
                if (statuscode == 555) {
                    this.updateBackupBatchFailedFile(backupBatch, cloudval, 0, 0L);
                    this.utilServiceObj.removeFailedFile(item.getId().toString());
                } else {
                    this.updateTotalCount(cloudval.getCloudId(), backupBatch);
                    this.updateBackupBatch(backupBatch, cloudval, 0, 0L);
                    logger.debug(item.isFailedFile() + "...failed case statuscode...." + statuscode);
                    if (statuscode == 409) {
                        this.utilServiceObj.removeFailedFile(item.getId().toString());
                    } else {
                        this.uploadService.addFailedFiles(item, policyName);
                    }
                }
            } else {
                this.updateBackupBatch(backupBatch, cloudval, 1, item.getSize());
            }
            this.uploadService.removeDriveItem(item.getId().toString(), item.isMail());
            if (item.isPrevDeltaItem()) {
                this.utilServiceObj.removeFileInfoForPrevDeltaItem(item.getId().toString());
            }
            logger.debug(".. batch id completed...." + backupBatch.getId());
        }
    }

    public void updateTotalCount(int cloudId, BackupBatch backupBatch) {
        this.utilServiceObj.updateBackupBatchTotalCount(cloudId, backupBatch.getId().toString());
    }

    List<DriveFileInfo> getOneDriveFileInfoFromListForBatchId(int cloudId, String batchId) {
        List<DriveFileInfo> list = this.uploadService.getOneDriveFileInfoFromListForBatchId(cloudId, batchId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return new ArrayList<DriveFileInfo>();
        }
        return list;
    }

    private UploadStatus downloadFile(DriveFileInfo item, String driveId, String token) throws InterruptedException, ExecutionException {
        logger.debug("Message started! : " + Thread.currentThread().getName() + " ...  " + item.getItemId() + "....." + item.getParentItemId());
        int statuscode = 0;
        UploadStatus uploadStatus = null;
        try {
            if (item.getOperation().equalsIgnoreCase("FILE") && !item.isFolder()) {
                HashedMap arguments = new HashedMap();
                arguments.put("itemID", item.getItemId());
                arguments.put("parentItemID", item.getParentItemId());
                logger.debug(item.getBackupBatchId() + "...from info.. " + item.getParentItemId());
                arguments.put("messageID", item.getItemId());
                arguments.put("backupBatchId", item.getBackupBatchId());
                arguments.put("userName", item.getUserName());
                arguments.put("deviceUUID", item.getDeviceUUID());
                logger.debug(item.isMail() + "..$$$$ calculated path is " + item.getItemPath());
                arguments.put("file-path", item.getItemPath());
                arguments.put("file-name", item.getItemName());
                arguments.put("driveFileInfoId", item.getId().toString());
                arguments.put("isFullBackup", item.isFullBackup());
                arguments.put("isMail", item.isMail());
                arguments.put("isContact", item.isContact());
                arguments.put("isTasks", item.isTasks());
                arguments.put("isInPlaceArchive", item.isInPlaceArchive());
                arguments.put("userMailId", item.getUserMailId());
                arguments.put("o365LastModifiedTime", item.getO365LastModifiedTime());
                arguments.put("token", token);
                logger.debug(".....o365LastModifiedTime....." + item.getO365LastModifiedTime());
                arguments.put("driveId", driveId);
                if (item.isMail() || item.isTasks() || item.isContact() || item.isInPlaceArchive()) {
                    arguments.put("graphUserId", item.getGraphUserId());
                }
                do {
                    CompletableFuture<UploadStatus> notifyService;
                    if (((uploadStatus = (notifyService = this.uploadService.notifyService((Map<String, ? super Object>)arguments, null)).get()).getStatus() != 0 || uploadStatus.getStatus() != 200 || uploadStatus.getStatus() != 234 || uploadStatus.getStatus() != 409) && uploadStatus.getStatus() != 200) {
                        logger.debug(item.getItemName() + "....differror code..." + uploadStatus.getStatus());
                    }
                    if (uploadStatus.getStatus() != 0) continue;
                    logger.debug("... error code is 0...sleep for 10 sec and retry.... ");
                    Thread.sleep(10000L);
                } while (uploadStatus.getStatus() == 0);
                logger.debug(item.getUserName() + "...............UPPLOAD STATUS ............... " + uploadStatus.getStatus());
                if (uploadStatus.getStatus() == 409) {
                    logger.debug("...............409 UPPLOAD STATUS ............... ");
                    statuscode = 234;
                }
                if (uploadStatus.getStatus() == 234) {
                    statuscode = uploadStatus.getStatus();
                }
                if (uploadStatus != null && uploadStatus.getStatus() == 200) {
                    statuscode = uploadStatus.getStatus();
                } else {
                    logger.debug("..$%$%$%$%.file failed......" + item.getItemName());
                }
            }
            logger.debug(this.shutdown + ".... item processed v... " + item.getItemName() + "....");
            logger.debug(".... item processed path and subject... " + item.getSubject() + "...." + item.getItemPath());
        }
        catch (GraphServiceException e) {
            logger.error("... error response codecheck .... " + e.getResponseCode());
            if (e.getResponseCode() == 429 || e.getResponseCode() == 401) {
                logger.debug(".... retry .. after 2 mins.. ");
                Thread.sleep(120000L);
                uploadStatus = this.downloadFile(item, driveId, token);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            logger.error(item.getItemName() + "... unable to catch exception during download 1... " + ee.getMessage());
        }
        if (uploadStatus == null) {
            uploadStatus = new UploadStatus(item.getItemId(), false, 234, 0L);
        }
        return uploadStatus;
    }

    private double getFileSizeInMb(Long fileSize) {
        if (fileSize == null) {
            return 0.0;
        }
        long filesizeInKB = (long)Math.ceil((double)fileSize.longValue() / 1024.0);
        return StorageService.getSizeinMb(filesizeInKB);
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private void sendWarningMail(String cloudName, String userName, double userStorageQuata, String deviceName) {
        try {
            logger.debug(".. user limit reached mail start....");
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/mail";
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("isInternalCall", "true");
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)userName);
            emailDetails.put("action", (Object)"backup-limit-reached");
            emailDetails.put("actionOn", (Object)userName);
            emailDetails.put("deviceName", (Object)deviceName);
            emailDetails.put("customMailMessage", (Object)String.valueOf(userStorageQuata));
            emailDetails.put("toAdmins", true);
            emailDetails.put("toUser", true);
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            logger.debug("user limit reached mail Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    private void sendEmail(String action, String actionOn, String actionBy, String emailId, NotifierEmailBodyElement bodyElement, String deviceUUID) {
        try {
            logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email12 completion...." + bodyElement.getTotalBackupSize());
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl().trim() + "/paracloud/cloud/" + bodyElement.getCloudName() + "/mail";
            logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email url with dev details s...." + url);
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("isInternalCall", "true");
            httpPost.setHeader("bkupsDone", String.valueOf(bodyElement.getNoOfFilesBackedUp()));
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)actionBy);
            emailDetails.put("action", (Object)action);
            emailDetails.put("actionOn", (Object)actionOn);
            emailDetails.put("toUser", true);
            emailDetails.put("deviceUUID", (Object)deviceUUID);
            emailDetails.put("customMailMessage", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
            emailDetails.put("deviceName", (Object)String.valueOf(bodyElement.getDeviceName()));
            emailDetails.put("totalStorageUtilized", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
            emailDetails.put("bkupsDone", (Object)String.valueOf(bodyElement.getNoOfFilesBackedUp()));
            emailDetails.put("toAdmins", true);
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            logger.debug("Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    private static String formatFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    private synchronized ODBBackupBatch getBackupBatchFromOneDriveServer() {
        ODBBackupBatch backupBatch;
        int cloudId = 1;
        BaseController.printLogs("... inside getBackupBatchFromOneDriveServer... ", PCHelperConstant.isBrevityLogging());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(batchList)) {
            this.sleep7();
            batchList = this.getBatchFromList(cloudId);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(batchList)) {
                try {
                    BaseController.printLogs("...batch Completed ... ", PCHelperConstant.isBrevityLogging());
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        }
        if ((backupBatch = batchList.get(0)) != null) {
            if (this.batchUnderProcess.contains(backupBatch.getId().toString()) || this.deviceUUIDUnderProcess.contains(backupBatch.getDeviceUUID())) {
                batchList.remove(backupBatch);
                return this.getBackupBatchFromOneDriveServer();
            }
            batchList.remove(backupBatch);
            this.batchUnderProcess.add(backupBatch.getId().toString());
            this.deviceUUIDUnderProcess.add(backupBatch.getDeviceUUID());
        }
        logger.debug("...after bkp batch list size....." + batchList.size());
        return backupBatch;
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        BaseController.printLogs("Check the task is completed>>>>>>>>", PCHelperConstant.isBrevityLogging());
                        Future future = pool.take();
                        if (future.isDone()) {
                            BaseController.printLogs("Thread is completed so assign new task>>>>>>>>>>>", PCHelperConstant.isBrevityLogging());
                            StorageService.this.callUploadFiles(cloud, executor, pool);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }

    private List<DriveFileInfo> getBatchFromList(String batchId) {
        List<DriveFileInfo> fileInfoListVal = this.getDriveFileInfoFromListForBatchId(1, batchId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(fileInfoListVal)) {
            batchFilesList = new ArrayList<DriveFileInfo>();
        } else {
            batchFilesList.addAll(fileInfoListVal);
        }
        logger.debug("...drivefilelist ...." + batchFilesList.size());
        return batchFilesList;
    }

    private List<ODBBackupBatch> getBatchFromList(int cloudId) {
        ArrayList<ODBBackupBatch> batchListVal = new ArrayList<ODBBackupBatch>();
        List<OfficeBackupPolicy> list = this.utilServiceObj.getPolicyForBluKrypt(cloudId);
        for (OfficeBackupPolicy oneDriveBackupPolicy : list) {
            List<ODBBackupBatch> batchListForPolicy = this.uploadService.getODBBatchList(cloudId, oneDriveBackupPolicy.getPolicyName());
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "....." + batchListVal.size() + "..." + batchListForPolicy.size());
            for (ODBBackupBatch backupBatch : batchListForPolicy) {
                ODBBackupBatch newBackupBatch = new ODBBackupBatch();
                BeanUtils.copyProperties((Object)backupBatch, (Object)newBackupBatch);
                newBackupBatch.setOdbPolicyName(oneDriveBackupPolicy.getPolicyName());
                newBackupBatch.setOfficeBackupPolicy(oneDriveBackupPolicy);
                batchListVal.add(newBackupBatch);
            }
        }
        if (batchList == null) {
            batchList = new ArrayList<ODBBackupBatch>();
        }
        Collections.sort(batchListVal, Comparator.comparing(ODBBackupBatch::getNoOfFiles));
        for (ODBBackupBatch backupBatch : batchListVal) {
            boolean odbEnabled = false;
            OfficeBackupPolicy oneDriveBackupPolicy = backupBatch.getOfficeBackupPolicy();
            if (!StringUtils.isEmpty((String)oneDriveBackupPolicy.getOdMsAppBluKrypt()) && PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getOdMsAppBluKrypt())) {
                odbEnabled = true;
            }
            boolean mailEnabled = false;
            if (!StringUtils.isEmpty((String)oneDriveBackupPolicy.getMailMsAppBluKrypt()) && PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMailMsAppBluKrypt())) {
                mailEnabled = true;
            }
            logger.debug(odbEnabled + "...mail enabled vs odb enabled...." + mailEnabled + "..." + backupBatch.getDeviceUUID());
            Device device = this.utilServiceObj.getDeviceForUUID(cloudId, backupBatch.getDeviceUUID());
            if (device == null || device == null) continue;
            logger.debug(backupBatch.getNoOfFiles() + "...nooffilesmail enabled vs odb enabled...." + device.getUserName());
            if (odbEnabled && device != null && Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(device.getOsType())) {
                batchList.add(backupBatch);
                continue;
            }
            if (!mailEnabled || device == null || !Device.TYPE.OUTLOOK.toString().equalsIgnoreCase(device.getOsType())) continue;
            batchList.add(backupBatch);
        }
        return batchList;
    }

    private List<ODBBackupBatch> getBatchFromList(int cloudId, int limit) {
        List<OfficeBackupPolicy> list = this.utilServiceObj.getPolicyForBluKrypt(cloudId);
        for (OfficeBackupPolicy oneDriveBackupPolicy : list) {
            List<ODBBackupBatch> batchListVal = this.uploadService.getODBBatchList(cloudId, oneDriveBackupPolicy.getPolicyName(), limit);
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "....." + batchListVal.size());
            if (batchList == null) {
                batchList = new ArrayList<ODBBackupBatch>();
            }
            for (ODBBackupBatch backupBatch : batchListVal) {
                ODBBackupBatch newBackupBatch = new ODBBackupBatch();
                BeanUtils.copyProperties((Object)backupBatch, (Object)newBackupBatch);
                newBackupBatch.setOdbPolicyName(oneDriveBackupPolicy.getPolicyName());
                newBackupBatch.setOfficeBackupPolicy(oneDriveBackupPolicy);
                batchList.add(newBackupBatch);
            }
        }
        return batchList;
    }

    private void updateBatchAndOverview(int cloudId, ObjectId backupBatchId, String status, String deviceUUID, int errorCode) {
        this.utilServiceObj.updateBackupBatch(cloudId, backupBatchId, status, errorCode);
        Device device = this.utilServiceObj.getDeviceForUUID(cloudId, deviceUUID);
        BackupBatch backupBatch = this.utilServiceObj.getBackupBatchById(cloudId, backupBatchId.toString());
        this.updateBackupOverview(cloudId, BACKUP, deviceUUID, device, backupBatch, errorCode);
    }

    private void sleep7() {
        try {
            BaseController.printLogs("... going to sleep for 2 sec..", PCHelperConstant.isBrevityLogging());
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    private List<DriveFileInfo> getDriveFileInfoFromListForBatchId(int cloudId, String batchId) {
        List<DriveFileInfo> list = this.uploadService.getDriveFileInfoFromListForBatchId(cloudId, batchId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return new ArrayList<DriveFileInfo>();
        }
        return list;
    }

    public void updateBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, Long size) {
        logger.debug("calling backup Batch ..." + backupBatchOdb.getNoOfFiles());
        try {
            int cloudId = cloud.getCloudId();
            if (size == null) {
                size = 0L;
            }
            this.utilServiceObj.updateBackupBatch(cloudId, backupBatchOdb.getId().toString(), uploadedFiles, size);
            BackupBatch backupBatch = this.utilServiceObj.getBackupBatchById(cloudId, backupBatchOdb.getId().toString());
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedFiles())) {
                String[] parts = backupBatch.getUploadedFiles().split("/");
                try {
                    Integer uploadedFilesLast = Integer.parseInt(parts[0]);
                    Integer totalUploaded = Integer.parseInt(parts[1]);
                    if (uploadedFilesLast > totalUploaded) {
                        this.utilServiceObj.updateBackupBatch(cloudId, backupBatchOdb.getId().toString(), -1, -size.longValue());
                        return;
                    }
                }
                catch (Exception e) {
                    logger.trace("Exception  :" + e);
                    logger.error("Exception  :" + e.getMessage());
                }
            }
            this.utilServiceObj.updateBackupAttempt(cloudId, backupBatch.getUploadedFiles(), backupBatchOdb.getId().toString());
            this.utilServiceObj.updateUplodedFilesInBackupOverView(cloudId, backupBatchOdb.getDeviceUUID(), uploadedFiles, size, backupBatchOdb.getTotalSizeToUpload());
            logger.debug("[backupBatch][" + backupBatchOdb.getUserName() + "][" + backupBatchOdb.getDeviceUUID() + "][" + backupBatchOdb.getId() + "][" + backupBatchOdb.getStatus() + "][" + backupBatchOdb.getBatchStartTimestamp() + "][" + backupBatchOdb.getBatchEndTimestamp() + "]");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling backup Batch ...");
    }

    public void updateBackupBatchFailedFile(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, Long size) {
        logger.debug("calling backup updateBackupBatchFailedFile ..." + backupBatchOdb.getNoOfFiles());
        try {
            int cloudId = cloud.getCloudId();
            if (size == null) {
                size = 0L;
            }
            this.utilServiceObj.updateBackupBatchFailedFile(cloudId, backupBatchOdb.getId().toString(), uploadedFiles, size);
            this.utilServiceObj.updateUplodedFilesInBackupOverView(cloudId, backupBatchOdb.getDeviceUUID(), uploadedFiles, size, backupBatchOdb.getTotalSizeToUpload());
            logger.debug("[backupBatch][" + backupBatchOdb.getUserName() + "][" + backupBatchOdb.getDeviceUUID() + "][" + backupBatchOdb.getId() + "][" + backupBatchOdb.getStatus() + "][" + backupBatchOdb.getBatchStartTimestamp() + "][" + backupBatchOdb.getBatchEndTimestamp() + "]");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling backup Batch ...");
    }

    private void updateBackupOverview(int cloudId, String jobType, String deviceUUID, Device device, BackupBatch backupBatch, int errorCode) {
        logger.debug(".... job type..... " + jobType);
        if (BACKUP.equalsIgnoreCase(jobType)) {
            DeviceBackupOverView overView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            if (overView == null) {
                logger.debug(" No device backup ....");
                this.utilServiceObj.saveDeviceBackupOverView(cloudId, device);
            } else {
                logger.debug(backupBatch + " update device backup ...." + backupBatch.getBatchStartTimestamp());
                if (StringUtils.isEmpty((String)overView.getFirstBkpStartTime())) {
                    String firstBkpStartTime = this.getDateInFormat(backupBatch.getBatchStartTimestamp());
                    overView.setFirstBkpStartTime(firstBkpStartTime);
                }
                String lastBkpStartTime = this.getDateInFormat(backupBatch.getBatchStartTimestamp());
                overView.setLastBkpStartTime(lastBkpStartTime);
                if (backupBatch.getBatchEndTimestamp() > 0L) {
                    overView.setLastBkpEndTime(this.getDateInFormat(backupBatch.getBatchEndTimestamp()));
                } else {
                    overView.setLastBkpEndTime(this.getDateInFormat(System.currentTimeMillis()));
                }
                overView.setLastBkpStatus(backupBatch.getStatus());
                overView.setTotalNoOfFiles(backupBatch.getTotalNoOfFiles());
                logger.debug("TotalNoOfFiles : " + backupBatch.getTotalNoOfFiles() + " UploadedFiles : " + backupBatch.getUploadedFiles());
                overView.setNoOfFilesRemaining(this.getNoOfFilesRemaining(backupBatch.getTotalNoOfFiles(), backupBatch.getUploadedFiles()));
                logger.debug(overView.getNoOfSuccessfulBackups() + "Backup/Restore Status*" + backupBatch.getStatus() + "**");
                logger.debug(errorCode + "...noofsuccessfulbkps... " + overView.getNoOfSuccessfulBackups());
                if (COMPLETED.equalsIgnoreCase(backupBatch.getStatus())) {
                    String lastSuccessfulBkp = this.getDateInFormat(backupBatch.getBatchEndTimestamp());
                    overView.setLastSuccessfulBkp(lastSuccessfulBkp);
                    overView.setLastSuccessfulBackupStartTime(backupBatch.getBatchStartTimestamp());
                    overView.setLastSuccessfulBackupEndTime(backupBatch.getBatchEndTimestamp());
                    logger.debug(device.getUserName() + " @#@# Backup  Completed ........." + device.getDeviceName());
                    logger.debug("...totalfilllll....." + backupBatch.getUploadedFiles() + "..." + backupBatch.getTotalNoOfFiles());
                    long noOfSuccessfulBackups = overView.getNoOfSuccessfulBackups();
                    overView.setNoOfSuccessfulBackups(noOfSuccessfulBackups + 1L);
                    if (StringUtils.isEmpty((String)overView.getFirstBkpEndTime())) {
                        logger.debug(" ..firstbkp empty....");
                        Long firstBkpEndTime = this.utilServiceObj.getFirstBackupEndDate(cloudId, device.getUserName(), device.getDeviceUUID());
                        logger.debug(" ..firstbkp empty...." + firstBkpEndTime);
                        if (firstBkpEndTime != null) {
                            String firstSuccessfulEndBkp = this.getDateInFormat(firstBkpEndTime);
                            overView.setFirstBkpEndTime(firstSuccessfulEndBkp);
                        } else {
                            overView.setFirstBkpEndTime(lastSuccessfulBkp);
                        }
                        if (StringUtils.isNotEmpty((String)backupBatch.getUploadedSize())) {
                            overView.setFirstFullBkpTotalSizeOfFiles(Long.parseLong(backupBatch.getUploadedSize()) / 1024L);
                        } else {
                            overView.setFirstFullBkpTotalSizeOfFiles(0L);
                        }
                        overView.setFirstFullBkpNoOfFiles(this.getActualUploadedFiles(backupBatch.getUploadedFiles()));
                    }
                    if (StringUtils.isNotEmpty((String)backupBatch.getUploadedSize())) {
                        overView.setLastSucessfulBkpTotalSizeOfFiles(Long.parseLong(backupBatch.getUploadedSize()) / 1024L);
                    } else {
                        overView.setLastSucessfulBkpTotalSizeOfFiles(0L);
                    }
                    overView.setLastSucessfulBkpNoOfFiles(this.getActualUploadedFiles(backupBatch.getUploadedFiles()));
                    overView.setCurrentlyRunningBkpNoOfFiles(0L);
                    overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
                }
                overView.setReason(backupBatch.getErrorCode());
                if (!StringUtils.isEmpty((String)backupBatch.getStatus()) && backupBatch.getStatus().equals("ABORTED")) {
                    overView.setCurrentlyRunningBkpNoOfFiles(0L);
                    overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
                }
                overView.setTotalSizeToUpload(backupBatch.getTotalSizeToUpload());
                logger.debug("...end noofsuccessfulbkps... " + overView.getNoOfSuccessfulBackups());
                this.utilServiceObj.updateDeviceBackupOverView(cloudId, overView);
            }
        }
    }

    long getActualUploadedFiles(String uploadedFiles) {
        if (StringUtils.isEmpty((String)uploadedFiles)) {
            uploadedFiles = "0/0";
        }
        String[] parts = uploadedFiles.split("/");
        return Long.parseLong(parts[0]);
    }

    public BackupBatch startBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, long totalFiles, int errorCode, long batchStartTimestamp) {
        String cloudName = cloud.getCloudName();
        logger.debug("calling start backup Batch ..." + uploadedFiles);
        BackupBatch backupBatch = new BackupBatch();
        try {
            int tot;
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            String jobType = BACKUP;
            String totalNoOfFiles = "" + backupBatchOdb.getNoOfFiles();
            String deviceUUID = backupBatchOdb.getDeviceUUID();
            logger.debug(" ************ " + backupBatchOdb.getErrorCode());
            Device device = this.utilServiceObj.getDeviceForUUID(cloudId, deviceUUID);
            if (!StringUtils.isEmpty((String)totalNoOfFiles) && (long)(tot = Integer.parseInt(totalNoOfFiles)) < totalFiles) {
                totalNoOfFiles = "" + totalFiles;
            }
            backupBatch.setId(backupBatchOdb.getId());
            backupBatch.setUserName(backupBatchOdb.getUserName());
            backupBatch.setDeviceName(backupBatchOdb.getDeviceName());
            backupBatch.setDeviceUUID(deviceUUID);
            backupBatch.setStatus(STARTED);
            backupBatch.setJobType(jobType);
            backupBatch.setBatchStartTimestamp(batchStartTimestamp);
            backupBatch.setTotalNoOfFiles(totalNoOfFiles);
            backupBatch.setUploadedFiles(uploadedFiles + "/" + totalNoOfFiles);
            backupBatch.setDeviceName(device.getDeviceName());
            backupBatch.setBatchEndTimestamp(System.currentTimeMillis());
            backupBatch.setNoOfFiles(totalFiles);
            backupBatch.setErrorCode(backupBatchOdb.getErrorCode());
            backupBatch.setTotalSizeToUpload(backupBatchOdb.getTotalSizeToUpload());
            this.utilServiceObj.saveBackupBatch(cloudId, backupBatch);
            logger.debug(backupBatchOdb.getErrorCode() + ".... sleep for 7 sec..." + backupBatch.getBatchStartTimestamp());
            logger.debug("[backupBatch][" + backupBatch.getUserName() + "][" + backupBatch.getDeviceUUID() + "][" + backupBatch.getId() + "][" + backupBatch.getStatus() + "][" + backupBatch.getBatchStartTimestamp() + "][" + backupBatch.getBatchEndTimestamp() + "]");
            logger.debug(" before updateoverview..");
            this.updateBackupOverview(cloudId, jobType, deviceUUID, device, backupBatch, errorCode);
            this.utilServiceObj.deleteEventHubForDeviceUUID(cloudId, deviceUUID, "START_BACKUP");
            logger.debug(" after updateoverview..");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling method backup Batch ...");
        return backupBatch;
    }

    private void updateBatchAttempt(int cloudId, BackupBatch batch, boolean isFirstAttempt, boolean startOp, boolean overLoad, boolean licenseExpired) {
        block20: {
            try {
                BackupBatch backupBatch = this.utilServiceObj.getBackupBatchById(cloudId, batch.getId().toString());
                if (backupBatch != null) {
                    logger.debug(isFirstAttempt + "........updateBatchAttempt.status........" + backupBatch.getStatus());
                    if (isFirstAttempt) {
                        BackupAttempt attempt = new BackupAttempt();
                        BeanUtils.copyProperties((Object)backupBatch, (Object)attempt);
                        attempt.setBatchId(backupBatch.getId().toString());
                        attempt.setId(null);
                        attempt.setErrorCode("0");
                        this.utilServiceObj.saveBackupAttempt(cloudId, attempt);
                        break block20;
                    }
                    if (overLoad || licenseExpired) {
                        BackupAttempt bkpAttempt = this.utilServiceObj.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
                        logger.debug(backupBatch.getErrorCode() + "........overLoad........" + bkpAttempt);
                        if (bkpAttempt != null) {
                            logger.debug(backupBatch.getUploadedFiles() + "........overLoad.attempt......." + bkpAttempt.getUploadedSize());
                            if (licenseExpired) {
                                bkpAttempt.setErrorCode("1501");
                            } else {
                                bkpAttempt.setErrorCode("1996");
                            }
                            bkpAttempt.setUploadedSize(bkpAttempt.getUploadedSize());
                            bkpAttempt.setStatus(INTERRUPTED_STATUS);
                            bkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                            bkpAttempt.setUploadedFiles(backupBatch.getUploadedFiles());
                            this.utilServiceObj.saveBackupAttempt(cloudId, bkpAttempt);
                        }
                        break block20;
                    }
                    if (!backupBatch.getStatus().equals(STARTED)) {
                        BackupAttempt bkpAttempt = this.utilServiceObj.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
                        logger.debug(backupBatch.getErrorCode() + ".........attempt vla........" + bkpAttempt.toString());
                        if (bkpAttempt != null) {
                            if (bkpAttempt.getStatus().equalsIgnoreCase("SCANNING")) {
                                bkpAttempt.setErrorCode("0");
                            } else {
                                bkpAttempt.setErrorCode(backupBatch.getErrorCode());
                            }
                            bkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
                            bkpAttempt.setStatus(backupBatch.getStatus());
                            bkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                            bkpAttempt.setUploadedFiles(backupBatch.getUploadedFiles());
                            bkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
                            this.utilServiceObj.saveBackupAttempt(cloudId, bkpAttempt);
                        }
                        if (bkpAttempt != null && startOp && bkpAttempt.getStatus().equalsIgnoreCase(STARTED)) {
                            logger.debug("...update code ..." + backupBatch.getErrorCode());
                            this.utilServiceObj.updateAttemptForRestart(cloudId, bkpAttempt.getId(), backupBatch.getErrorCode());
                        }
                        break block20;
                    }
                    BackupAttempt attempt = this.utilServiceObj.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
                    logger.debug(startOp + "..." + attempt.getStatus() + ".........attempt..new logic......" + attempt.toString());
                    if (attempt != null) {
                        BackupAttempt lastBkpAttempt = new BackupAttempt();
                        BeanUtils.copyProperties((Object)backupBatch, (Object)lastBkpAttempt);
                        lastBkpAttempt.setBatchStartTimestamp(System.currentTimeMillis());
                        lastBkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                        lastBkpAttempt.setNoOfFiles(0L);
                        lastBkpAttempt.setTotalNoOfFiles(0L);
                        lastBkpAttempt.setBatchId(backupBatch.getId().toString());
                        lastBkpAttempt.setId(null);
                        String currentUploadedFilesStatus = "";
                        int uploadedFiles = 0;
                        int updatedUploadedFiles = 0;
                        if (StringUtils.isEmpty((String)lastBkpAttempt.getUploadedFiles())) {
                            currentUploadedFilesStatus = uploadedFiles + "/" + lastBkpAttempt.getTotalNoOfFiles();
                        } else {
                            String[] parts = backupBatch.getUploadedFiles().split("/");
                            try {
                                Integer prevBkpFiles = Integer.parseInt(parts[0]);
                                if (prevBkpFiles != null) {
                                    updatedUploadedFiles = uploadedFiles + prevBkpFiles;
                                }
                                currentUploadedFilesStatus = updatedUploadedFiles + "/" + lastBkpAttempt.getTotalNoOfFiles();
                            }
                            catch (Exception e) {
                                logger.trace("Exception  :" + e);
                                logger.error("Exception  :" + e.getMessage());
                            }
                        }
                        logger.debug(backupBatch.getUploadedFiles() + ".......currentUploadedFilesStatus......" + currentUploadedFilesStatus);
                        logger.debug(lastBkpAttempt.getId() + ".......currentUploadedFilesStatus backupbatch......" + backupBatch.getStatus());
                        lastBkpAttempt.setUploadedFiles(backupBatch.getUploadedFiles());
                        lastBkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
                        lastBkpAttempt.setStatus(backupBatch.getStatus());
                        this.utilServiceObj.saveBackupAttempt(cloudId, lastBkpAttempt);
                    }
                    if (attempt != null && startOp && attempt.getStatus().equalsIgnoreCase(STARTED)) {
                        this.utilServiceObj.updateAttemptForRestart(cloudId, attempt.getId(), backupBatch.getErrorCode());
                    }
                    break block20;
                }
                logger.debug("...else attempt..... ");
            }
            catch (Exception e) {
                logger.trace("Error failed to save BackupAttempt ..." + e);
                logger.error("Error failed to save BackupAttempt ..." + e);
            }
        }
    }

    private String getNoOfFilesRemaining(String totalNoOfFilesFromBatch, String uploadedFilesBatchTemp) {
        String uploadedFilesBatch = uploadedFilesBatchTemp;
        Integer noOfFilesRemaining = 0;
        logger.debug(" Files ********************** " + uploadedFilesBatch);
        if (StringUtils.isEmpty((String)uploadedFilesBatch)) {
            uploadedFilesBatch = "0/" + totalNoOfFilesFromBatch;
        }
        String[] parts = uploadedFilesBatch.split("/");
        try {
            Integer actualNoOfFiles = Integer.parseInt(parts[1]);
            Integer noOfFilesBackedup = Integer.parseInt(parts[0]);
            noOfFilesRemaining = actualNoOfFiles - noOfFilesBackedup;
        }
        catch (Exception e) {
            logger.trace("Exception  :" + e);
            logger.error("Exception  :" + e.getMessage());
        }
        return noOfFilesRemaining.toString();
    }

    private String getDateInFormat(Long deviceCreatedDate) {
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date dateD = new Date(deviceCreatedDate);
        return df2.format(dateD);
    }

    private int vaildatedLicensceStatus(Cloud cloud) {
        if (cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE")) {
            return 1500;
        }
        return 1501;
    }

    private GraphServiceClient<Request> getGraphClient() {
        String authorityHost = "https://login.microsoftonline.com";
        logger.debug("...helper constant ...." + PCHelperConstant.getMSClientId());
        GraphServiceClient graphClient = null;
        if (!StringUtils.isEmpty((String)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            logger.debug("....using proxy latest......");
            InetSocketAddress proxyInetAddress = new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort());
            logger.debug("....using proxy latest before createDefault 1bb......" + PCHelperConstant.getProxyHost() + "..pwd..." + PCHelperConstant.getProxyPort());
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            HttpClientOptions clientOptions = new HttpClientOptions();
            clientOptions.setProxyOptions(proxyOptions);
            logger.debug("....using proxy latest before createDefault 2a with host latest");
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            OkHttpClient httpClient = null;
            Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyInetAddress);
            logger.debug("....using proxy latest before createDefault 3a");
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(proxy).build();
            logger.debug("....using proxy latest before createDefault 4");
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).httpClient((Object)httpClient).buildClient();
            logger.debug("....using proxy latest before createDefault 5");
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).buildClient();
        }
        return graphClient;
    }

    private String getDriveIdForUser(String emailId) {
        Drive drive = null;
        try {
            com.parablu.pcbd.domain.User user;
            GraphServiceClient<Request> graphClient = Graph.getInstance().getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            if (StringUtils.isEmpty((String)userId)) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + emailId + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            if (StringUtils.isEmpty((String)userId) && (user = this.utilServiceObj.getUserDetailsForEmail(1, emailId)) != null) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + user.getUserName() + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
            int retryDrive = 0;
            do {
                drive = StorageService.getDrive(graphClient, userId);
                logger.debug(++retryDrive + "....drive for user...." + drive);
                Thread.sleep(10000L);
            } while (retryDrive < 5 && drive == null || drive == null);
            if (drive != null) {
                logger.debug(emailId + "....drive id for user ... " + drive.id);
                return drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    return this.getDriveIdForUser(emailId);
                }
                catch (InterruptedException interruptedException) {
                }
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + emailId);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return null;
    }

    public static synchronized String getEWSAccesToken1(EWSAppSetting ewsAppSetting) {
        String accessToken = "";
        try {
            long now = System.currentTimeMillis();
            ExecutorService es = Executors.newFixedThreadPool(2);
            AuthenticationContext context = new AuthenticationContext(AUTHORITY + ewsAppSetting.getTenantId(), false, es);
            AuthenticationCallback<AuthenticationResult> callback = new AuthenticationCallback<AuthenticationResult>(){

                public void onSuccess(AuthenticationResult result) {
                    logger.debug("received token");
                }

                public void onFailure(Throwable exc) {
                    throw new RuntimeException(exc);
                }
            };
            logger.debug("requesting token..val");
            Future future = context.acquireToken(RESOURCE, new ClientCredential(ewsAppSetting.getClientId(), ewsAppSetting.getClientSecretKey()), (AuthenticationCallback)callback);
            logger.debug("requesting token..val1");
            AuthenticationResult result = (AuthenticationResult)future.get(30L, TimeUnit.SECONDS);
            accessToken = result.getAccessToken();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception", (Throwable)e);
            logger.debug(".....sleep for 5 secs.....");
            try {
                Thread.sleep(5000L);
                accessToken = StorageService.getEWSAccesToken1(ewsAppSetting);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        MemoryStore.add((String)"tokenExpired", (Object)false);
        return accessToken;
    }

    public String getEWSTokenFromDb(int cloudId) {
        String token = this.utilServiceObj.getEWSToken(cloudId);
        return token;
    }

    static {
        logger = LogManager.getLogger(StorageService.class);
        batchList = null;
        batchFilesList = null;
    }

    class NotifierEmailBodyElement {
        private int cloudId;
        private String cloudName;
        private String userName;
        private String deviceName;
        private String restoreDeviceName;
        private String restoreFolder;
        private String noOfFilesBackedUp;
        private String totalBackupSize;
        private boolean notifyAllAdmins;

        NotifierEmailBodyElement() {
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public String getRestoreDeviceName() {
            return this.restoreDeviceName;
        }

        public void setRestoreDeviceName(String restoreDeviceName) {
            this.restoreDeviceName = restoreDeviceName;
        }

        public String getRestoreFolder() {
            return this.restoreFolder;
        }

        public void setRestoreFolder(String restoreFolder) {
            this.restoreFolder = restoreFolder;
        }

        public String getTotalBackupSize() {
            return this.totalBackupSize;
        }

        public void setTotalBackupSize(String totalBackupSize) {
            this.totalBackupSize = totalBackupSize;
        }

        public String getNoOfFilesBackedUp() {
            return this.noOfFilesBackedUp;
        }

        public void setNoOfFilesBackedUp(String noOfFilesBackedUp) {
            this.noOfFilesBackedUp = noOfFilesBackedUp;
        }

        public boolean isNotifyAllAdmins() {
            return this.notifyAllAdmins;
        }

        public void setNotifyAllAdmins(boolean notifyAllAdmins) {
            this.notifyAllAdmins = notifyAllAdmins;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public int getCloudId() {
            return this.cloudId;
        }

        public void setCloudId(int cloudId) {
            this.cloudId = cloudId;
        }

        public String getCloudName() {
            return this.cloudName;
        }

        public void setCloudName(String cloudName) {
            this.cloudName = cloudName;
        }
    }
}

