/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcsd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcsd.dao.SyncPolicyDao;
import com.parablu.pcsd.domain.SyncPolicy;
import java.util.Collection;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class SyncPolicyDaoImpl
implements SyncPolicyDao {
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String SYNC_POLICY_NAME = "policyName";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveSyncPolicy(int cloudId, String cloudName, SyncPolicy syncPolicy) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)syncPolicy);
    }

    @Override
    public SyncPolicy getSyncPolicy(int cloudId, String cloudName, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)SYNC_POLICY_NAME).is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (SyncPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), SyncPolicy.class);
    }

    @Override
    public List<SyncPolicy> getAllSyncPolicy(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongotemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongotemplate.find(query, SyncPolicy.class);
    }

    @Override
    public List<SyncPolicy> getAllSyncPoliciesWithPagination(int cloudId, int pagNum) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (pagNum != 0) {
            query.skip((long)(pagNum * PCHelperConstant.getReportDisplayRecords()));
        }
        query.limit(PCHelperConstant.getReportDisplayRecords());
        MongoTemplate mongotemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongotemplate.find(query, SyncPolicy.class);
    }

    @Override
    public long getSyncPoliciesCount(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, SyncPolicy.class);
    }

    @Override
    public List<SyncPolicy> getSyncPolicyForFilterId(int cloudId, String cloudName, ObjectId id) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"inclusionFilter.$id").is((Object)id)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), SyncPolicy.class);
    }

    @Override
    public boolean checkIfSyncPolicyNameExists(int cloudId, String syncPolicyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)SYNC_POLICY_NAME).is((Object)syncPolicyName)});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, SyncPolicy.class);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public long getSyncPoliciesForPolicyNameCount(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false), Criteria.where((String)SYNC_POLICY_NAME).in(policyNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, SyncPolicy.class);
    }

    @Override
    public List<SyncPolicy> getAllSyncPoliciesWithPagination(int cloudId, List<String> policyNames, int pagNum) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false), Criteria.where((String)SYNC_POLICY_NAME).in(policyNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (pagNum != 0) {
            query.skip((long)(pagNum * PCHelperConstant.getReportDisplayRecords()));
        }
        query.limit(PCHelperConstant.getReportDisplayRecords());
        MongoTemplate mongotemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongotemplate.find(query, SyncPolicy.class);
    }
}

