/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.ReadPreference;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.pcbd.dao.UserMiniCloudMappingDao;
import com.parablu.pcbd.domain.MiniCloudGroupMapping;
import com.parablu.pcbd.domain.UserCloudAccessControl;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class UserMiniCloudMappingDaoImpl
implements UserMiniCloudMappingDao {
    private static final String MINI_CLOUD_FK = "miniCloudFK";
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String USER_FK = "userFK";

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveMiniCloud(int cloudId, String cloudName, UserCloudAccessControl accessControl) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)accessControl);
    }

    @Override
    public UserCloudAccessControl getMiniCloudByName(int cloudId, String cloudName, ObjectId userId, ObjectId miniCloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_FK).is((Object)userId), Criteria.where((String)MINI_CLOUD_FK).is((Object)miniCloudId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoForCloud = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (UserCloudAccessControl)mongoForCloud.findOne(query, UserCloudAccessControl.class);
    }

    @Override
    public void deleteUserCloudAccessControlMapping(int cloudId, String cloudName, UserCloudAccessControl ucas) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove((Object)ucas);
    }

    @Override
    public List<UserCloudAccessControl> getAccessControlMappingsByUser(int cloudId, String cloudName, ObjectId userId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_FK).is((Object)userId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        MongoTemplate mongoForCloud = paracloudMongoTemplate;
        return mongoForCloud.find(query, UserCloudAccessControl.class);
    }

    @Override
    public List<UserCloudAccessControl> getAccessControlMappingsByMiniCloud(int cloudId, String cloudName, ObjectId miniCloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)MINI_CLOUD_FK).is((Object)miniCloudId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoForCloud = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoForCloud.find(query, UserCloudAccessControl.class);
    }

    @Override
    public void deleteUserCloudAccessControlMappingWithUserFK(int cloudId, String cloudName, ObjectId userId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_FK).is((Object)userId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoForCloud = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoForCloud.remove(query, UserCloudAccessControl.class);
    }

    @Override
    public List<MiniCloudGroupMapping> getGroupMappingsByMiniCloud(int cloudId, ObjectId miniCloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"miniCloud.$id").is((Object)miniCloudId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoForCloud = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoForCloud.find(query, MiniCloudGroupMapping.class);
    }

    @Override
    public void deleteGroupMCMapping(int cloudId, MiniCloudGroupMapping miniCloudGroupMapping) {
        MongoTemplate mongoForCloud = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoForCloud.remove((Object)miniCloudGroupMapping);
    }

    @Override
    public void deleteUserAccessForMinicloud(int cloudId, ObjectId miniCloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)MINI_CLOUD_FK).is((Object)miniCloudId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoForCloud = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoForCloud.findAllAndRemove(query, UserCloudAccessControl.class);
    }

    @Override
    public void deleteUserAccessForMinicloudExceptOwner(int cloudId, ObjectId mcId, ObjectId userId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)MINI_CLOUD_FK).is((Object)mcId), Criteria.where((String)USER_FK).ne((Object)userId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoForCloud = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoForCloud.findAllAndRemove(query, UserCloudAccessControl.class);
    }

    @Override
    public List<UserCloudAccessControl> getAllUserAccessForMinicloudExceptOwner(int cloudId, ObjectId mcId, ObjectId userId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)MINI_CLOUD_FK).is((Object)mcId), Criteria.where((String)USER_FK).ne((Object)userId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoForCloud = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoForCloud.find(query, UserCloudAccessControl.class);
    }
}

