/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.SharedFileImageDao;
import com.parablu.pcbd.domain.ExternalRestoreFileImage;
import com.parablu.pcbd.domain.SharedFileImage;
import com.parablu.pcbd.domain.SharedFileImageHistory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class SharedFileImageDaoImpl
implements SharedFileImageDao {
    private static Logger logger = LogManager.getLogger(SharedFileImageDaoImpl.class);
    private MongoOperations mongoOps;
    private static final String CLOUD_NAME = "cloudName";
    private static final String USER_NAME = "userName";
    private static final String ACCESS_TIME_STAMP = "accessTimeStamp";
    private static final String FILE_NAME = "fileName";
    private static final String DEVICE_PATH = "devicePath";

    public MongoOperations getMongoOps() {
        return this.mongoOps;
    }

    public void setMongoOps(MongoOperations mongoOps) {
        this.mongoOps = mongoOps;
    }

    @Override
    public void saveFileImage(SharedFileImage fileImage) {
        this.mongoOps.save((Object)fileImage);
    }

    @Override
    public void saveExternalRestoreFileImage(ExternalRestoreFileImage externalRestoreFileImage) {
        this.mongoOps.save((Object)externalRestoreFileImage);
    }

    @Override
    public SharedFileImage getSharedFileImage(String cloudName, String key12, String key14, String key18, String key20) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"key12").is((Object)key12), Criteria.where((String)"key14").is((Object)key14), Criteria.where((String)"key18").is((Object)key18), Criteria.where((String)"key20").is((Object)key20)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (SharedFileImage)this.mongoOps.findOne(query, SharedFileImage.class);
    }

    @Override
    public SharedFileImage getSharedFileImageByCloud(String cloudName, String miniCloudName, String devicePath, String fileName) {
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)CLOUD_NAME).is((Object)cloudName)});
        list.add(criteria);
        if (!StringUtils.isEmpty((String)miniCloudName)) {
            Criteria mcCriteria = Criteria.where((String)"miniCloudName").is((Object)miniCloudName);
            list.add(mcCriteria);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return (SharedFileImage)this.mongoOps.findOne(query, SharedFileImage.class);
    }

    @Override
    public SharedFileImage getSharedFileImageByCloudAndDeviceUUID(String cloudName, String deviceUUID, String devicePath, String fileName) {
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)CLOUD_NAME).is((Object)cloudName), Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        list.add(criteria);
        Query query = new Query((CriteriaDefinition)criteria);
        return (SharedFileImage)this.mongoOps.findOne(query, SharedFileImage.class);
    }

    @Override
    public void deleteFileImage(SharedFileImage fileImage) {
        this.mongoOps.remove((Object)fileImage);
    }

    @Override
    public List<SharedFileImage> getAllSharedFileImages(String cloudName, String userName, List<String> miniclouds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CLOUD_NAME).is((Object)cloudName), Criteria.where((String)"miniCloudName").in(miniclouds)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoOps.find(query, SharedFileImage.class);
    }

    @Override
    public List<SharedFileImage> getAllSharedFileImages(String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CLOUD_NAME).is((Object)cloudName)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoOps.find(query, SharedFileImage.class);
    }

    @Override
    public void deleteSharedFileImage(String cloudName, String fileName, String devicePath) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CLOUD_NAME).is((Object)cloudName), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
        Query query = new Query((CriteriaDefinition)criteria);
        List fileImages = this.mongoOps.find(query, SharedFileImage.class);
        HashSet<String> imageIds = new HashSet<String>();
        for (SharedFileImage fileImage : fileImages) {
            imageIds.add(fileImage.getId().toString());
        }
        logger.debug(" delete sharedfile images .............. " + imageIds.size());
        if (!CollectionUtils.isEmpty(imageIds)) {
            this.mongoOps.remove(query, SharedFileImage.class);
            try {
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)"sharedImageId").in(imageIds)});
                query = new Query((CriteriaDefinition)criteria);
                this.mongoOps.remove(query, SharedFileImageHistory.class);
            }
            catch (Exception e) {
                logger.trace(" Exception  :" + e);
                logger.error(" Exception  :" + e.getMessage());
            }
        }
    }

    @Override
    public void deleteSharedFileImages(List<ObjectId> idList) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(idList)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoOps.remove(query, SharedFileImage.class);
    }

    @Override
    public void saveShareAH(SharedFileImageHistory sharedFileImageHistory) {
        this.mongoOps.save((Object)sharedFileImageHistory);
    }

    @Override
    public List<SharedFileImageHistory> getAllShareAH(String cloudName, String devicePath, String fileName, String userName, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CLOUD_NAME).is((Object)cloudName)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.limit(PCHelperConstant.getReportDisplayRecords());
        query.with(new Sort(Sort.Direction.DESC, new String[]{ACCESS_TIME_STAMP}));
        return this.mongoOps.find(query, SharedFileImageHistory.class);
    }

    @Override
    public void updateSharedFileImage(SharedFileImage sharedFileImage) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"key12").is((Object)sharedFileImage.getKey12()), Criteria.where((String)"key14").is((Object)sharedFileImage.getKey14()), Criteria.where((String)"key18").is((Object)sharedFileImage.getKey18()), Criteria.where((String)"key20").is((Object)sharedFileImage.getKey20())});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("validUntil", (Object)sharedFileImage.getValidUntil());
        update.set("passwordHash", (Object)sharedFileImage.getPasswordHash());
        update.set("isDownload", (Object)sharedFileImage.isDownload());
        update.set("isView", (Object)sharedFileImage.isView());
        update.set("passwordProtected", (Object)sharedFileImage.isPasswordProtected());
        this.mongoOps.findAndModify(query, update, SharedFileImage.class);
    }

    @Override
    public void updateSharedFileImageTOMailList(SharedFileImage sharedFileImage) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)sharedFileImage.getId())});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("toEmailList", (Object)sharedFileImage.getToEmailList());
        update.set("downloadLink", (Object)sharedFileImage.getDownloadLink());
        this.mongoOps.findAndModify(query, update, SharedFileImage.class);
    }

    @Override
    public List<SharedFileImage> getAllMySharedFileImages(String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CLOUD_NAME).is((Object)cloudName)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoOps.find(query, SharedFileImage.class);
    }

    @Override
    public List<SharedFileImageHistory> getAllShareAH(String cloudName, String userName, long startDay, long endDay, int skipValue) {
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CLOUD_NAME).is((Object)cloudName), Criteria.where((String)ACCESS_TIME_STAMP).gte((Object)startDay), Criteria.where((String)ACCESS_TIME_STAMP).lte((Object)endDay)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)CLOUD_NAME).is((Object)cloudName), Criteria.where((String)ACCESS_TIME_STAMP).gte((Object)startDay), Criteria.where((String)ACCESS_TIME_STAMP).lte((Object)endDay)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != 0) {
            query.skip((long)(skipValue * 1000));
            query.limit(1000);
        } else {
            query.limit(1000);
        }
        query.with(new Sort(Sort.Direction.DESC, new String[]{ACCESS_TIME_STAMP}));
        return this.mongoOps.find(query, SharedFileImageHistory.class);
    }

    @Override
    public List<SharedFileImageHistory> getAllShareAH(String cloudName, String userName, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CLOUD_NAME).is((Object)cloudName)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.limit(PCHelperConstant.getReportDisplayRecords());
        query.with(new Sort(Sort.Direction.DESC, new String[]{ACCESS_TIME_STAMP}));
        return this.mongoOps.find(query, SharedFileImageHistory.class);
    }

    @Override
    public long getAllShareAH(String cloudName, String devicePath, String fileName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CLOUD_NAME).is((Object)cloudName)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoOps.count(query, SharedFileImageHistory.class);
    }

    @Override
    public long getAllShareAH(String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CLOUD_NAME).is((Object)cloudName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{ACCESS_TIME_STAMP}));
        return this.mongoOps.count(query, SharedFileImageHistory.class);
    }

    @Override
    public List<SharedFileImage> getAllSharedFilesWithLinkExpiry() {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"linkExpiryAlertsEnabled").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoOps.find(query, SharedFileImage.class);
    }
}

