/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.ReportConfigDao;
import com.parablu.pcbd.domain.ReportConfig;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class ReportConfigDaoImpl
implements ReportConfigDao {
    private ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static Logger logger = LogManager.getLogger(ReportConfigDaoImpl.class);

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public List<ReportConfig> getReportConfig(int cloudId) {
        logger.debug("ReportConfigDaoImp start fetching");
        try {
            Query query = new Query();
            return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, ReportConfig.class);
        }
        catch (Exception e) {
            logger.trace("EXCEPTION" + e);
            logger.error("EXCEPTION" + e.getMessage());
            return null;
        }
    }

    @Override
    public void saveReportConfig(ReportConfig reportConfig, int cloudId) {
        logger.debug("ReportConfigDaoImp Saving Started");
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)reportConfig);
        logger.debug("ReportConfigDaoImp Saving Finished");
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    @Override
    public ReportConfig getReportConfigBySchedulerName(int cloudId, String schedulerName) {
        logger.debug("ReportConfigDaoImp start fetching for schedulerName :" + schedulerName);
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)("properties." + schedulerName)).exists(true)});
            Query query = new Query((CriteriaDefinition)criteria);
            return (ReportConfig)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, ReportConfig.class);
        }
        catch (Exception e) {
            logger.trace("EXCEPTION" + e);
            logger.error("EXCEPTION" + e.getMessage());
            return null;
        }
    }
}

