/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.element.MSAppBluKryptElement;
import com.parablu.paracloud.element.PrivacyGatewayElement;
import com.parablu.pcbd.dao.PrivacyGateWayDao;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.BluVault;
import com.parablu.pcbd.domain.MSAppBluKrypt;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.Policy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.PrivacyGatewayProperties;
import com.parablu.pcsd.domain.SyncPolicy;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PrivacyGateWayDaoImpl
implements PrivacyGateWayDao {
    private static Logger logger = LogManager.getLogger(PrivacyGateWayDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String GATEWY_NAME = "gatewayName";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public List<PrivacyGateway> getAllGateways(int cloudId) {
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAll(PrivacyGateway.class);
    }

    @Override
    public void saveorUpdateGateway(int cloudId, PrivacyGatewayElement element) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)GATEWY_NAME).is((Object)element.getGatewayName());
        Query query = new Query((CriteriaDefinition)criteria);
        PrivacyGateway org = (PrivacyGateway)mongoTemplate.findOne(query, PrivacyGateway.class);
        PrivacyGatewayProperties paracloudProperties = (PrivacyGatewayProperties)mongoTemplate.findOne(new Query(), PrivacyGatewayProperties.class);
        if (paracloudProperties != null && !CollectionUtils.isEmpty(paracloudProperties.getComponentsProperties())) {
            if (org == null) {
                PrivacyGateway gateway = new PrivacyGateway();
                BeanUtils.copyProperties((Object)element, (Object)gateway);
                gateway.setComponentsProperties(paracloudProperties.getComponentsProperties());
                mongoTemplate.save((Object)gateway);
            } else {
                org.setType(element.getType());
                org.setActive(element.isActive());
                logger.debug("....org......" + org.isActive());
                mongoTemplate.save((Object)org);
            }
        } else {
            logger.debug("BluvaultProperties is empty so don't save");
        }
    }

    @Override
    public void saveGateway(int cloudId, PrivacyGateway element) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)element);
    }

    @Override
    public void saveBluVault(int cloudId, BluVault element) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)element);
    }

    public PrivacyGateway getGateway(int cloudId, String gatewayname) {
        Criteria criteria = Criteria.where((String)GATEWY_NAME).is((Object)gatewayname);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (PrivacyGateway)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), PrivacyGateway.class);
    }

    @Override
    public List<String> deleteGateway(int cloudId, String gatewayName) {
        PrivacyGateway gateway = this.getGateway(cloudId, gatewayName);
        List<PrivacyGateway> gatewayList = this.getAllGateways(cloudId);
        ArrayList<String> mapedPolicies = new ArrayList<String>();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"privacyGateways").in(new Object[]{gateway});
        Query query = new Query((CriteriaDefinition)criteria);
        ArrayList policies = new ArrayList();
        List backupPolicies = mongoTemplate.find(query, BackupPolicy.class);
        List syncPolicies = mongoTemplate.find(query, SyncPolicy.class);
        policies.addAll(backupPolicies);
        policies.addAll(syncPolicies);
        if (CollectionUtils.isEmpty(policies) && gatewayList.size() > 1) {
            criteria = Criteria.where((String)GATEWY_NAME).is((Object)gatewayName);
            query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.remove(query, PrivacyGateway.class);
            return mapedPolicies;
        }
        for (Policy policy : policies) {
            mapedPolicies.add(policy.getPolicyName());
        }
        return mapedPolicies;
    }

    @Override
    public boolean isGateWayNameExist(int cloudId, String gatewayName) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        PrivacyGateway gateWay = (PrivacyGateway)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)GATEWY_NAME).is((Object)gatewayName))), PrivacyGateway.class);
        return !StringUtils.isEmpty((Object)gateWay);
    }

    @Override
    public boolean isMSAppBluKryptExist(int cloudId, String host) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSAppBluKrypt msAppBluKrypt = (MSAppBluKrypt)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"host").is((Object)host))), MSAppBluKrypt.class);
        return !StringUtils.isEmpty((Object)msAppBluKrypt);
    }

    @Override
    public void saveorUpdateMSAppBlukrypt(int cloudId, MSAppBluKryptElement msAppBluKryptElement) {
        Query query;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSAppBluKrypt org = (MSAppBluKrypt)mongoTemplate.findOne(query = new Query(), MSAppBluKrypt.class);
        if (org == null) {
            MSAppBluKrypt gateway = new MSAppBluKrypt();
            BeanUtils.copyProperties((Object)msAppBluKryptElement, (Object)gateway);
            mongoTemplate.save((Object)gateway);
        } else {
            ObjectId id = org.getId();
            BeanUtils.copyProperties((Object)msAppBluKryptElement, (Object)org);
            org.setId(id);
            mongoTemplate.save((Object)org);
        }
    }

    @Override
    public List<MSAppBluKrypt> getAllMSAppBlukrypt(int cloudId) {
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAll(MSAppBluKrypt.class);
    }

    @Override
    public List<String> deleteMSBluKrypt(int cloudId, String host) {
        MSAppBluKrypt gateway = this.getMSBluKrypt(cloudId, host);
        List<MSAppBluKrypt> gatewayList = this.getAllMSAppBlukrypt(cloudId);
        ArrayList<String> mapedPolicies = new ArrayList<String>();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"msAppBluKrypt").is((Object)gateway.getHost());
        Query query = new Query((CriteriaDefinition)criteria);
        ArrayList policies = new ArrayList();
        List backupPolicies = mongoTemplate.find(query, OfficeBackupPolicy.class);
        policies.addAll(backupPolicies);
        if (CollectionUtils.isEmpty(policies) && gatewayList.size() > 1) {
            criteria = Criteria.where((String)"host").is((Object)host);
            query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.remove(query, MSAppBluKrypt.class);
            return mapedPolicies;
        }
        for (OfficeBackupPolicy policy : policies) {
            mapedPolicies.add(policy.getPolicyName());
        }
        return mapedPolicies;
    }

    public MSAppBluKrypt getMSBluKrypt(int cloudId, String host) {
        Criteria criteria = Criteria.where((String)"host").is((Object)host);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MSAppBluKrypt)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), MSAppBluKrypt.class);
    }

    @Override
    public PrivacyGateway getPrivacyGateway(int cloudId, String gatewayName) {
        Criteria criteria = Criteria.where((String)GATEWY_NAME).is((Object)gatewayName);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (PrivacyGateway)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), PrivacyGateway.class);
    }

    @Override
    public BluVault getBluVault(int cloudId, String gatewayName) {
        Criteria criteria = Criteria.where((String)"bluVaultName").is((Object)gatewayName);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BluVault)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BluVault.class);
    }
}

