/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.PortalPropertiesDao;
import com.parablu.pcbd.domain.PortalProperties;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class PortalPropertiesDaoImpl
implements PortalPropertiesDao {
    public static final String PORTAL_BRANDING_COLLECTION_NAME = "PORTAL_BRANDING_ITEMS";
    public static final String CUSTOM_MAILS_COLLECTION_NAME = "CUSTOM_EMAIL_TEMPLATE";
    private static final String PARABLU001_DB = "parablu001";
    private static final String PARABLU_DB = "parablu";
    private static Logger logger = LogManager.getLogger(PortalPropertiesDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public PortalProperties getPortalProperties(int cloudId, String componentName) {
        Criteria criteria = Criteria.where((String)"componentName").is((Object)componentName);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (PortalProperties)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), PortalProperties.class);
    }

    @Override
    public void savePortalProperties(int cloudId, PortalProperties portalPropertes) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)portalPropertes);
    }

    public MongoClient getMongoClient(String collectionName) {
        ServerAddress address = new ServerAddress(PCHelperConstant.getPropertyValueDBHost().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort().trim()));
        MongoCredential credential = MongoCredential.createCredential((String)"neil", (String)collectionName, (char[])PARABLU_DB.toCharArray());
        MongoClientOptions options = new MongoClientOptions.Builder().build();
        MongoClient client = new MongoClient(Arrays.asList(new ServerAddress(PCHelperConstant.getPropertyValueDBHost1().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort1().trim())), new ServerAddress(PCHelperConstant.getPropertyValueDBHost2().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort2().trim())), new ServerAddress(PCHelperConstant.getPropertyValueDBHost3().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort3().trim()))), credential, options);
        return client;
    }

    @Override
    public void saveBrandingItem(String filePath, String fileName) {
        logger.debug("..filePath....." + filePath + "..........fileName....ss...." + fileName);
        MongoClient client = this.getMongoClient();
        DB db = client.getDB(PARABLU001_DB);
        String collectionName = PORTAL_BRANDING_COLLECTION_NAME;
        if (fileName.equalsIgnoreCase("emails.xml")) {
            collectionName = CUSTOM_MAILS_COLLECTION_NAME;
        }
        logger.debug("...saving..Coll..." + collectionName);
        File brandingFile = new File(filePath + "/" + fileName);
        GridFS gfs = new GridFS(db, collectionName);
        try {
            gfs.remove((DBObject)gfs.findOne(fileName));
        }
        catch (Exception e1) {
            logger.debug("failed to remove existing data" + e1);
            logger.error("failed to remove existing data......" + e1.getMessage());
        }
        gfs = new GridFS(db, collectionName);
        try {
            GridFSInputFile gfsFile = gfs.createFile(brandingFile);
            gfsFile.setFilename(fileName);
            gfsFile.save();
        }
        catch (IOException e) {
            logger.debug("failed to save" + e);
            logger.error("failed to save......" + e.getMessage());
        }
    }

    @Override
    public boolean getBrandingItem(String distinationPath, String fileName) {
        MongoClient client = this.getMongoClient();
        DB db = client.getDB(PARABLU001_DB);
        String collectioName = PORTAL_BRANDING_COLLECTION_NAME;
        if (fileName.equalsIgnoreCase("emails.xml")) {
            collectioName = CUSTOM_MAILS_COLLECTION_NAME;
        }
        GridFS gfs = new GridFS(db, collectioName);
        GridFSDBFile imageForOutput = gfs.findOne(fileName);
        try {
            logger.debug(".......fileName" + fileName + "..." + distinationPath + "..." + collectioName);
            imageForOutput.writeTo(distinationPath + "/" + fileName);
            return true;
        }
        catch (IOException e) {
            logger.debug("failed to get" + e);
            logger.error("failed to get......" + e.getMessage());
            return false;
        }
    }

    private MongoClient getMongoClient() {
        MongoCredential credential = MongoCredential.createCredential((String)"neil", (String)PARABLU001_DB, (char[])PARABLU001_DB.toCharArray());
        MongoClientOptions options = MongoClientOptions.builder().build();
        MongoClient client = new MongoClient(Arrays.asList(new ServerAddress(PCHelperConstant.getPropertyValueDBHost1().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort1().trim())), new ServerAddress(PCHelperConstant.getPropertyValueDBHost2().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort2().trim())), new ServerAddress(PCHelperConstant.getPropertyValueDBHost3().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort3().trim()))), credential, options);
        return client;
    }
}

