/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.PersonDao;
import com.parablu.pcbd.domain.AdCredentials;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Person;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.domain.SyncPolicy;
import java.io.IOException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.Name;
import javax.naming.directory.SearchControls;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.ldap.AuthenticationException;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.control.PagedResultsCookie;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.util.CollectionUtils;

public class PersonDaoImpl
implements PersonDao {
    private static final String SYNC_CON = "sync";
    private static final String BACKUP = "backup";
    private static final String SYNC = "Sync";
    private static final String BKP = "Bkp";
    private static final String BKP_SYNC = "Bkp-Sync";
    private static final Logger logger = LogManager.getLogger(PersonDaoImpl.class);
    private static final String ALGO = "AES";
    private static final byte[] keyValue = new byte[]{101, 56, 53, 100, 54, 98, 97, 99, 50, 102, 52, 56, 101, 100, 53, 89};
    private String cName;
    private LdapTemplate ldapTemplate;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String OBJECT_CLASS = "objectclass";
    private static final String PERSON = "person";
    private static final String MEMBER_OF = "memberOf";
    private static final String LOADING_CONFIGURATION = "  Loading configuration i ***************** ";
    private static final String ACTIVE = "active";
    private static final String USER_NOT_FOUND = " USER NOT FOUND ....... ";
    private static final String EXCEPTION = " Exception  :";
    private static final String USERACCOUNTCONTROL = "userAccountControl";
    private static final String USERPRINCIPALNAME = "userPrincipalName";
    private static final int AD_CONNECTION_FAILED = 400;

    public String getCName() {
        return this.cName;
    }

    public void setCName(String cName) {
        this.cName = cName;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
        this.ldapTemplate.setIgnorePartialResultException(true);
    }

    protected ContextMapper getContextMapper() {
        return new PersonContextMapper();
    }

    protected Name buildDn(Person person) {
        return this.buildDn(person.getFullName(), person.getCompany(), person.getCountry());
    }

    protected Name buildDn(String fullname, String company, String country) {
        DistinguishedName dn = new DistinguishedName();
        dn.add("c", country);
        dn.add("ou", company);
        dn.add("cn", fullname);
        return dn;
    }

    protected void mapToContext(Person person, DirContextOperations context) {
        context.setAttributeValues(OBJECT_CLASS, (Object[])new String[]{"top", PERSON});
        context.setAttributeValue("cn", (Object)person.getFullName());
        context.setAttributeValue("sn", (Object)person.getLastName());
        context.setAttributeValue("description", (Object)person.getDescription());
    }

    @Override
    public Object[] authenticate(String userName, String password) {
        Object[] objArr = new Object[2];
        List<AdCredentials> adCredentialList = this.getAllAdCredentials(1);
        boolean isAuthenticated = false;
        adCredentialList.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(adCredentialList)) {
            for (AdCredentials adCredentials : adCredentialList) {
                logger.debug(" from database using adcredentials........." + adCredentials.getAdBase());
                isAuthenticated = this.authenticateWithADCredentials(userName, password, adCredentials);
                logger.debug(" is authenticated from ad credentials....... " + isAuthenticated);
                if (!StringUtils.isEmpty((String)adCredentials.getAdGroupName())) {
                    objArr[1] = adCredentials.getAdProductType();
                }
                if (!isAuthenticated) continue;
                break;
            }
        } else {
            logger.error("no credentials defined for AD .....");
        }
        String licenseEnabled = "";
        if (isAuthenticated) {
            AdCredentials backupAdGroupCredentials = this.getBackupAdGroupCredential(adCredentialList);
            AdCredentials syncAdGroupCredentials = this.getSyncAdGroupCredential(adCredentialList);
            if (backupAdGroupCredentials != null && !StringUtils.isEmpty((String)backupAdGroupCredentials.getAdGroupName()) || syncAdGroupCredentials != null && !StringUtils.isEmpty((String)syncAdGroupCredentials.getAdGroupName())) {
                Person bkpPerson = this.getPersonUsingADCredentials(userName, backupAdGroupCredentials);
                Person syncPerson = this.getPersonUsingADCredentials(userName, syncAdGroupCredentials);
                if (bkpPerson != null && syncPerson != null) {
                    licenseEnabled = BKP_SYNC;
                } else if (bkpPerson != null) {
                    licenseEnabled = BKP;
                } else if (syncPerson != null) {
                    licenseEnabled = SYNC;
                }
            }
        }
        objArr[0] = isAuthenticated;
        objArr[1] = licenseEnabled;
        return objArr;
    }

    private AdCredentials getBackupAdGroupCredential(List<AdCredentials> adCredentialList) {
        AdCredentials backupAdCredentials = null;
        for (AdCredentials adCredentials : adCredentialList) {
            if (adCredentials == null || !StringUtils.isEmpty((String)adCredentials.getAdGroupName()) || !StringUtils.isNotEmpty((String)adCredentials.getAdProductType()) || !adCredentials.getAdProductType().equalsIgnoreCase(BACKUP)) continue;
            backupAdCredentials = adCredentials;
        }
        return backupAdCredentials;
    }

    private AdCredentials getSyncAdGroupCredential(List<AdCredentials> adCredentialList) {
        AdCredentials backupAdCredentials = null;
        for (AdCredentials adCredentials : adCredentialList) {
            if (adCredentials == null || !StringUtils.isEmpty((String)adCredentials.getAdGroupName()) || !StringUtils.isNotEmpty((String)adCredentials.getAdProductType()) || !adCredentials.getAdProductType().equalsIgnoreCase(SYNC_CON)) continue;
            backupAdCredentials = adCredentials;
        }
        return backupAdCredentials;
    }

    private boolean authenticateWithADCredentials(String userName, String password, AdCredentials adCredentials) {
        boolean isAuthenticated = false;
        try {
            String cnName = adCredentials.getAdCn();
            LdapTemplate ldapTemplateObj = this.createTemplateWithAdCredentials(adCredentials);
            this.setLdapTemplate(ldapTemplateObj);
            if (ldapTemplateObj == null) {
                return false;
            }
            AndFilter filter = new AndFilter();
            OrFilter emailOrNameFilter = new OrFilter();
            emailOrNameFilter.or((Filter)new EqualsFilter(cnName, userName)).or((Filter)new EqualsFilter(USERPRINCIPALNAME, userName));
            filter.and((Filter)new EqualsFilter(OBJECT_CLASS, PERSON)).and((Filter)emailOrNameFilter);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setTimeLimit(100000);
            ldapTemplateObj.setIgnorePartialResultException(true);
            cnName = adCredentials.getAdCn();
            this.setCName(cnName);
            String ouForMigration = adCredentials.getAdGroupName();
            if (StringUtils.isEmpty((String)ouForMigration)) {
                isAuthenticated = ldapTemplateObj.authenticate((Name)DistinguishedName.EMPTY_PATH, filter.toString(), password);
            } else {
                filter.and((Filter)new EqualsFilter(MEMBER_OF, ouForMigration));
                logger.debug(filter.toString() + "..authenticating inside parablu ou distinguishedName........." + ouForMigration);
                isAuthenticated = ldapTemplateObj.authenticate((Name)DistinguishedName.EMPTY_PATH, filter.toString(), password);
            }
        }
        catch (Exception e) {
            logger.trace("Exception :" + e);
            logger.error(isAuthenticated + "ERRRROR Authenticating ............" + password + "..msg..." + e.getMessage());
            isAuthenticated = false;
        }
        return isAuthenticated;
    }

    public String[] findLdapGroupUsers(String groupName) {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setTimeLimit(100000);
        AndFilter filter = new AndFilter();
        String cnName = PCHelperConstant.getAdCn();
        filter.and((Filter)new EqualsFilter(OBJECT_CLASS, "group")).and((Filter)new EqualsFilter(cnName, groupName));
        List list = this.ldapTemplate.search((Name)DistinguishedName.EMPTY_PATH, filter.toString(), new ContextMapper(){

            public Object mapFromContext(Object ctx) {
                DirContextAdapter adapter = (DirContextAdapter)ctx;
                return adapter.getStringAttributes("member");
            }
        });
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new String[0];
        }
        return (String[])list.get(0);
    }

    public boolean authenticateWithOtherADConfig(String userName, String password) {
        Properties props = this.loadProperties();
        boolean isAuthenticated = false;
        LdapTemplate appConfiguredLdapTemplate = this.ldapTemplate;
        int noOfMultiAdConfiguration = this.getNoOfMultiAdConfiguration(props);
        for (int i = 1; i <= noOfMultiAdConfiguration; ++i) {
            LdapTemplate ldapTemplate1 = this.createTemplateUsingContext(props, i);
            if (ldapTemplate1 == null) continue;
            this.setLdapTemplate(ldapTemplate1);
            logger.debug(LOADING_CONFIGURATION + i);
            try {
                SearchControls controls = new SearchControls();
                controls.setSearchScope(2);
                controls.setTimeLimit(100000);
                ldapTemplate1.setIgnorePartialResultException(true);
                AndFilter filter = new AndFilter();
                String cnName = props.getProperty("adCn" + i);
                filter.and((Filter)new EqualsFilter(OBJECT_CLASS, PERSON)).and((Filter)new EqualsFilter(cnName, userName));
                isAuthenticated = ldapTemplate1.authenticate((Name)DistinguishedName.EMPTY_PATH, filter.toString(), password);
            }
            catch (Exception e) {
                logger.trace("ERRRROR Authenticating template1 ............" + e);
                logger.error(isAuthenticated + "ERRRROR Authenticating template1 ............" + password);
            }
            if (isAuthenticated) break;
        }
        this.setLdapTemplate(appConfiguredLdapTemplate);
        return isAuthenticated;
    }

    private LdapTemplate createTemplateUsingContext(Properties props, int i) {
        String adUrl = props.getProperty("adurl" + i);
        String adBase = props.getProperty("adBase" + i);
        String adUserDN = props.getProperty("adUserDn" + i);
        String adPassword = props.getProperty("adPassword" + i);
        if (StringUtils.isEmpty((String)adUrl) || StringUtils.isEmpty((String)adBase) || StringUtils.isEmpty((String)adUserDN) || StringUtils.isEmpty((String)adPassword)) {
            logger.debug(" Multiple ad configuration values are missing for  " + i);
            return null;
        }
        LdapContextSource ctxSrc = new LdapContextSource();
        ctxSrc.setUrl(adUrl);
        ctxSrc.setBase(adBase);
        ctxSrc.setUserDn(adUserDN);
        ctxSrc.setPassword(adPassword);
        ctxSrc.afterPropertiesSet();
        return new LdapTemplate((ContextSource)ctxSrc);
    }

    private LdapTemplate createTemplateWithAdCredentials(AdCredentials adCredentials) {
        String adUrl = adCredentials.getAdUrl();
        String adBase = adCredentials.getAdBase();
        String adUserDN = adCredentials.getUserDn();
        String adPassword = adCredentials.getAdPassword();
        if (StringUtils.isEmpty((String)adUrl) || StringUtils.isEmpty((String)adBase) || StringUtils.isEmpty((String)adUserDN) || StringUtils.isEmpty((String)adPassword)) {
            logger.debug(" Multiple ad configuration values are missing for  " + adCredentials);
            return null;
        }
        LdapContextSource ctxSrc = new LdapContextSource();
        ctxSrc.setUrl(adUrl);
        ctxSrc.setBase(adBase);
        ctxSrc.setUserDn(adUserDN);
        ctxSrc.setPassword(PersonDaoImpl.decrypt(adPassword));
        ctxSrc.afterPropertiesSet();
        return new LdapTemplate((ContextSource)ctxSrc);
    }

    private Properties loadProperties() {
        Properties props = null;
        try {
            ClassPathResource resource = new ClassPathResource("pb-cloudproperty.properties");
            props = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            logger.debug("  ********************EXCEPTION while trying to load " + e);
        }
        return props;
    }

    @Override
    public Person getPerson(String userName) {
        Person person = null;
        List<AdCredentials> adCredentialList = this.getAllAdCredentials(1);
        adCredentialList.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(adCredentialList)) {
            for (AdCredentials adCredentials : adCredentialList) {
                logger.debug(adCredentials.getUserDn() + " getPersonUsingADCredentials ....... " + adCredentials.getAdBase());
                Person tempPerson = this.getPersonUsingUserNameORMail(userName, adCredentials);
                if (tempPerson == null) continue;
                if (person == null) {
                    person = tempPerson;
                    continue;
                }
                if (person.getAdGroupType().equalsIgnoreCase(tempPerson.getAdGroupType())) continue;
                person.setAdGroupType("both");
            }
        } else {
            logger.error("no credentials defined for AD.....");
        }
        return person;
    }

    @Override
    public Person getPersonBasedOnProductTye(String userName, String productType) {
        Person person = null;
        List<AdCredentials> adCredentialList = this.getAllAdCredentials(1);
        adCredentialList.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(adCredentialList)) {
            for (AdCredentials adCredentials : adCredentialList) {
                if (adCredentials.getAdProductType().equalsIgnoreCase(productType) && (person = this.getPersonUsingUserNameORMail(userName, adCredentials)) != null) break;
            }
        } else {
            logger.error("no credentials defined for AD.....");
        }
        return person;
    }

    private Person getPersonUsingADCredentials(String userName, AdCredentials adCredentials) {
        Person person = null;
        LdapTemplate ldapTemplateFromSpring = this.ldapTemplate;
        try {
            List users;
            LdapTemplate ldapTemplateObj = this.createTemplateWithAdCredentials(adCredentials);
            if (ldapTemplateObj == null) {
                return null;
            }
            this.setLdapTemplate(ldapTemplateObj);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setTimeLimit(100000);
            AndFilter filter = new AndFilter();
            String cnName = adCredentials.getAdCn();
            filter.and((Filter)new EqualsFilter(OBJECT_CLASS, PERSON)).and((Filter)new EqualsFilter(cnName, userName));
            this.setCName(cnName);
            String ouForMigration = adCredentials.getAdGroupName();
            this.ldapTemplate.setIgnorePartialResultException(true);
            if (!StringUtils.isEmpty((String)ouForMigration)) {
                filter.and((Filter)new EqualsFilter(MEMBER_OF, ouForMigration));
                String nameBase = "";
                if (StringUtils.isEmpty((String)nameBase)) {
                    nameBase = PCHelperConstant.getAdGroupNameForMigration();
                }
                users = this.ldapTemplate.search(nameBase, filter.toString(), controls, this.getContextMapper());
            } else {
                users = this.ldapTemplate.search((Name)DistinguishedName.EMPTY_PATH, filter.toString(), controls, this.getContextMapper());
            }
            if (!CollectionUtils.isEmpty((Collection)users)) {
                person = (Person)users.get(0);
                person.setAdGroupType(adCredentials.getAdProductType());
            }
            logger.debug(filter.toString() + " end of getPersonUsingADCredentials ....... " + userName);
        }
        catch (Exception e) {
            logger.trace("Excpetion :" + e);
            logger.error(adCredentials.getUserDn() + " USER NOT FOUND using adcredentials ....... " + userName + "....message..." + e.getMessage());
            this.setLdapTemplate(ldapTemplateFromSpring);
        }
        return person;
    }

    public List<String> getAllUsers(int cloudId) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        long count = paracloudMongoTemplate.count(query, User.class);
        ArrayList<String> userNameList = new ArrayList<String>();
        ArrayList userList = new ArrayList();
        logger.error("total users ...... " + count);
        int size = 1000;
        int skipValue = 0;
        while (size == 1000) {
            query.skip((long)(skipValue * 1000));
            query.limit(1000);
            List users = paracloudMongoTemplate.find(query, User.class);
            if (!CollectionUtils.isEmpty((Collection)users)) {
                size = users.size();
                userList.addAll(users);
                logger.error(++skipValue + " no of users... " + size);
                continue;
            }
            size = 0;
        }
        userList.removeAll(Collections.singleton(null));
        logger.error(count + " end of user query... " + userList.size());
        for (User user : userList) {
            userNameList.add(user.getUserName());
        }
        return userNameList;
    }

    @Override
    public List<String> checkIfEmailIsValidOrNot(List<String> userEmails) {
        ArrayList<String> validEmails = new ArrayList<String>();
        for (String email : userEmails) {
            Person person = null;
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setTimeLimit(100000);
            AndFilter filter = new AndFilter();
            filter.and((Filter)new EqualsFilter(OBJECT_CLASS, PERSON)).and((Filter)new EqualsFilter(USERPRINCIPALNAME, email));
            try {
                this.ldapTemplate.setIgnorePartialResultException(true);
                List users = this.ldapTemplate.search((Name)DistinguishedName.EMPTY_PATH, filter.toString(), controls, this.getContextMapper());
                if (!CollectionUtils.isEmpty((Collection)users)) {
                    person = (Person)users.get(0);
                }
                if (person == null) {
                    person = this.getPersonForTemplateUsingOtherADConfig(email);
                }
            }
            catch (Exception e) {
                logger.debug(USER_NOT_FOUND + email);
                logger.trace(EXCEPTION + e);
                person = this.getPersonEmailForTemplateUsingOtherADConfig(email);
            }
            if (person == null) continue;
            validEmails.add(person.getEmailId());
        }
        return validEmails;
    }

    @Override
    public List<Person> findUsersInGroup(String groupName) {
        ArrayList<Person> personList = new ArrayList<Person>();
        try {
            logger.debug(" get group name ");
            String[] list = this.findLdapGroupUsers(groupName);
            ArrayList<String> cnNames = new ArrayList<String>();
            for (String an : list) {
                String str = an;
                String cnNameVal = str.substring(3, str.indexOf(44));
                if (org.springframework.util.StringUtils.isEmpty((Object)cnNameVal)) continue;
                cnNames.add(cnNameVal);
            }
            for (String cname : cnNames) {
                Person person = this.getPerson(cname);
                if (person == null) continue;
                personList.add(person);
            }
            logger.debug(" personList ............. " + personList.size());
        }
        catch (Exception ex) {
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
        return personList;
    }

    private Person getPersonForTemplateUsingOtherADConfig(String userName) {
        Person person = null;
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setTimeLimit(100000);
        Properties props = this.loadProperties();
        int noOfMultiAdConfiguration = this.getNoOfMultiAdConfiguration(props);
        LdapTemplate ldapTemplateFromSpring = this.ldapTemplate;
        for (int i = 1; i <= noOfMultiAdConfiguration; ++i) {
            LdapTemplate ldapTemplate1 = this.createTemplateUsingContext(props, i);
            if (ldapTemplate1 == null) {
                logger.debug(" USER NOT FOUND  could not configure ad missing values ....... ");
                return null;
            }
            this.setLdapTemplate(ldapTemplate1);
            try {
                ldapTemplate1.setIgnorePartialResultException(true);
                AndFilter filter = new AndFilter();
                String cnName = props.getProperty("adCn" + i);
                logger.debug(cnName + LOADING_CONFIGURATION + i);
                filter.and((Filter)new EqualsFilter(OBJECT_CLASS, PERSON)).and((Filter)new EqualsFilter(cnName, userName));
                List users = ldapTemplate1.search((Name)DistinguishedName.EMPTY_PATH, filter.toString(), controls, this.getContextMapper());
                if (!CollectionUtils.isEmpty((Collection)users)) {
                    person = (Person)users.get(0);
                }
            }
            catch (Exception e) {
                logger.debug(" USER NOT FOUND in Other AD ....... " + userName);
                logger.trace(EXCEPTION + e);
            }
            if (person != null) break;
        }
        this.setLdapTemplate(ldapTemplateFromSpring);
        return person;
    }

    private Person getPersonEmailForTemplateUsingOtherADConfig(String mail) {
        Person person = null;
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setTimeLimit(100000);
        Properties props = this.loadProperties();
        int noOfMultiAdConfiguration = this.getNoOfMultiAdConfiguration(props);
        LdapTemplate ldapTemplateFromSpring = this.ldapTemplate;
        for (int i = 1; i <= noOfMultiAdConfiguration; ++i) {
            LdapTemplate ldapTemplate1 = this.createTemplateUsingContext(props, i);
            if (ldapTemplate1 == null) {
                logger.debug(" USER NOT FOUND  could not configure ad missing values ....... ");
                return null;
            }
            this.setLdapTemplate(ldapTemplate1);
            try {
                ldapTemplate1.setIgnorePartialResultException(true);
                AndFilter filter = new AndFilter();
                String cnName = props.getProperty("adCn" + i);
                logger.debug(cnName + LOADING_CONFIGURATION + i);
                filter.and((Filter)new EqualsFilter(OBJECT_CLASS, PERSON)).and((Filter)new EqualsFilter(USERPRINCIPALNAME, mail));
                List users = ldapTemplate1.search((Name)DistinguishedName.EMPTY_PATH, filter.toString(), controls, this.getContextMapper());
                if (!CollectionUtils.isEmpty((Collection)users)) {
                    person = (Person)users.get(0);
                }
            }
            catch (Exception e) {
                logger.debug(" USER NOT FOUND in Other AD ....... " + mail);
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
            if (person != null) break;
        }
        this.setLdapTemplate(ldapTemplateFromSpring);
        return person;
    }

    private int getNoOfMultiAdConfiguration(Properties props) {
        int multiAdConfiguration = 0;
        String noOfMultiAdConfiguration = props.getProperty("noOfMultiADConfig");
        if (!StringUtils.isEmpty((String)noOfMultiAdConfiguration)) {
            multiAdConfiguration = Integer.parseInt(noOfMultiAdConfiguration);
        }
        logger.debug(" NoOf multidb config ....... " + multiAdConfiguration);
        return multiAdConfiguration;
    }

    @Override
    public List<Person> searchPersonByEmail(String searchBy) {
        List<Person> users = new ArrayList<Person>();
        List<AdCredentials> adCredentialList = this.getAllAdCredentials(1);
        adCredentialList.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(adCredentialList)) {
            AdCredentials adCredentials;
            Iterator<AdCredentials> iterator = adCredentialList.iterator();
            while (iterator.hasNext() && CollectionUtils.isEmpty(users = this.getPersonsByEmail(searchBy, users, adCredentials = iterator.next()))) {
            }
        } else {
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setTimeLimit(100000);
            AndFilter filter = new AndFilter();
            logger.debug("Search by String>>>>." + searchBy);
            filter.and((Filter)new EqualsFilter(OBJECT_CLASS, PERSON)).and((Filter)new EqualsFilter(USERPRINCIPALNAME, searchBy + "*"));
            String filterBy = "(&(objectclass=person)(userPrincipalName=" + searchBy + "*))";
            try {
                this.ldapTemplate.setIgnorePartialResultException(true);
                users = this.ldapTemplate.search((Name)DistinguishedName.EMPTY_PATH, filterBy, controls, this.getContextMapper());
                if (users != null) {
                    logger.debug("Users List after search>>>>>>>>>>" + users.size());
                }
                logger.debug("Before printing the emailIds>>>>>>");
                for (Person user : users) {
                    logger.debug("user name:" + user.getFullName());
                    logger.debug("email id:" + user.getEmailId());
                }
            }
            catch (Exception e) {
                logger.debug(USER_NOT_FOUND + searchBy);
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
        return users;
    }

    private List<Person> getPersonsByEmail(String searchBy, List<Person> users1, AdCredentials adCredentials) {
        List users = users1;
        LdapTemplate ldapTemplateObj = this.createTemplateWithAdCredentials(adCredentials);
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setTimeLimit(100000);
        logger.debug("Search by getPersonsByEmail>>>>." + searchBy);
        String filterBy = "(&(objectclass=person))";
        try {
            ldapTemplateObj.setIgnorePartialResultException(true);
            users = ldapTemplateObj.search((Name)DistinguishedName.EMPTY_PATH, filterBy, controls, this.getContextMapper());
            if (users != null) {
                logger.debug("Users List after search>>>>>>>>>>" + users.size());
            }
        }
        catch (Exception e) {
            logger.debug(USER_NOT_FOUND + searchBy);
            logger.trace(EXCEPTION + e);
        }
        return users;
    }

    @Override
    public Person getPersonUsingUserNameORMail(String userName, AdCredentials adCredentials) {
        Person person = null;
        LdapTemplate ldapTemplateFromSpring = this.ldapTemplate;
        try {
            List users;
            LdapTemplate ldapTemplateObj = this.createTemplateWithAdCredentials(adCredentials);
            if (ldapTemplateObj == null) {
                return null;
            }
            this.setLdapTemplate(ldapTemplateObj);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setTimeLimit(100000);
            AndFilter filter = new AndFilter();
            String cnName = adCredentials.getAdCn();
            filter = userName.contains("@") ? filter.and((Filter)new EqualsFilter(USERPRINCIPALNAME, userName)) : filter.and((Filter)new EqualsFilter(OBJECT_CLASS, PERSON)).and((Filter)new EqualsFilter(cnName, userName));
            this.setCName(cnName);
            String filterBy = "(&(objectclass=person)(userPrincipalName=" + userName + "*))";
            String ouForMigration = adCredentials.getAdGroupName();
            this.ldapTemplate.setIgnorePartialResultException(true);
            if (!StringUtils.isEmpty((String)ouForMigration)) {
                filter.and((Filter)new EqualsFilter(MEMBER_OF, ouForMigration));
                String nameBase = "";
                if (StringUtils.isEmpty((String)nameBase)) {
                    nameBase = PCHelperConstant.getAdGroupNameForMigration();
                }
                users = this.ldapTemplate.search(nameBase, filter.toString(), controls, this.getContextMapper());
            } else {
                users = this.ldapTemplate.search((Name)DistinguishedName.EMPTY_PATH, filter.toString(), controls, this.getContextMapper());
            }
            if (!CollectionUtils.isEmpty((Collection)users)) {
                person = (Person)users.get(0);
                person.setAdGroupType(adCredentials.getAdProductType());
                logger.debug(filterBy + " end of getPersonUsingADCredentials ....... " + person.getAdGroupType());
            }
        }
        catch (Exception e) {
            logger.trace("Excpetion :" + e);
            logger.error(adCredentials.getUserDn() + " USER NOT FOUND using adcredentials ....... " + userName + "....message..." + e.getMessage());
            this.setLdapTemplate(ldapTemplateFromSpring);
        }
        return person;
    }

    @Override
    public Person getPersonWithoutCn(String userName, AdCredentials adCredentials) {
        Person person = null;
        LdapTemplate ldapTemplateFromSpring = this.ldapTemplate;
        try {
            List users;
            LdapTemplate ldapTemplateObj = this.createTemplateWithAdCredentials(adCredentials);
            if (ldapTemplateObj == null) {
                return null;
            }
            this.setLdapTemplate(ldapTemplateObj);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setTimeLimit(100000);
            AndFilter filter = new AndFilter();
            String cnName = "cn";
            filter = userName.contains("@") ? filter.and((Filter)new EqualsFilter(USERPRINCIPALNAME, userName)) : filter.and((Filter)new EqualsFilter(OBJECT_CLASS, PERSON)).and((Filter)new EqualsFilter(cnName, userName));
            this.setCName(cnName);
            String filterBy = "(&(objectclass=person)(userPrincipalName=" + userName + "*))";
            String ouForMigration = adCredentials.getAdGroupName();
            this.ldapTemplate.setIgnorePartialResultException(true);
            if (!StringUtils.isEmpty((String)ouForMigration)) {
                filter.and((Filter)new EqualsFilter(MEMBER_OF, ouForMigration));
                String nameBase = "";
                if (StringUtils.isEmpty((String)nameBase)) {
                    nameBase = PCHelperConstant.getAdGroupNameForMigration();
                }
                users = this.ldapTemplate.search(nameBase, filter.toString(), controls, this.getContextMapper());
            } else {
                users = this.ldapTemplate.search((Name)DistinguishedName.EMPTY_PATH, filter.toString(), controls, this.getContextMapper());
            }
            if (!CollectionUtils.isEmpty((Collection)users)) {
                person = (Person)users.get(0);
                person.setAdGroupType(adCredentials.getAdProductType());
                logger.debug(filterBy + " end of getPersonUsingADCredentials ....... " + person.getAdGroupType());
            }
        }
        catch (CommunicationException e) {
            logger.trace("Excpetion :" + (Object)((Object)e));
            logger.error(adCredentials.getUserDn() + " Unable to establish communiction with server ....... " + userName + "....message..." + e.getMessage());
            this.setLdapTemplate(ldapTemplateFromSpring);
            throw new BaseException("Communiation Exception");
        }
        catch (AuthenticationException e) {
            logger.trace("Excpetion :" + (Object)((Object)e));
            logger.error(adCredentials.getUserDn() + " USER NOT FOUND using adcredentials ....... " + userName + "....message..." + e.getMessage());
            this.setLdapTemplate(ldapTemplateFromSpring);
            throw new BaseException("Authentication Exception");
        }
        catch (Exception e) {
            logger.trace("Excpetion :" + e);
            logger.error(adCredentials.getUserDn() + " USER NOT FOUND using adcredentials ....... " + userName + "....message..." + e.getMessage());
            this.setLdapTemplate(ldapTemplateFromSpring);
            throw new BaseException(e.getMessage());
        }
        return person;
    }

    @Override
    public void saveAD(int cloudId, AdCredentials adCredentials) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        AdCredentials prevObj = this.getADForUserDN(cloudId, adCredentials.getUserDn());
        if (!StringUtils.isEmpty((String)adCredentials.getAdGroupName())) {
            prevObj = this.getADForUserDN(cloudId, adCredentials.getUserDn(), adCredentials.getAdProductType());
        }
        if (prevObj != null) {
            prevObj.setAdBase(adCredentials.getAdBase());
            prevObj.setAdCn(adCredentials.getAdCn());
            prevObj.setAdPassword(adCredentials.getAdPassword());
            prevObj.setAdUrl(adCredentials.getAdUrl());
            prevObj.setAdGroupName(adCredentials.getAdGroupName());
            prevObj.setAdProductType(adCredentials.getAdProductType());
            mongoTemplate.save((Object)prevObj);
        } else {
            mongoTemplate.save((Object)adCredentials);
        }
    }

    public AdCredentials getADForUserDN(int cloudId, String userDn, String adProductType) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userDn").is((Object)userDn), Criteria.where((String)"adProductType").is((Object)adProductType)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (AdCredentials)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), AdCredentials.class);
    }

    @Override
    public AdCredentials getADForUserDN(int cloudId, String userDn) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userDn").is((Object)userDn)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (AdCredentials)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), AdCredentials.class);
    }

    @Override
    public AdCredentials getADForId(int cloudId, ObjectId id) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (AdCredentials)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), AdCredentials.class);
    }

    @Override
    public List<AdCredentials> getAllAdCredentials(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(AdCredentials.class);
    }

    @Override
    public void deleteADCredential(int cloudId, String userDn) {
        AdCredentials adCredentials = this.getADForUserDN(cloudId, userDn);
        if (adCredentials != null) {
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.remove((Object)adCredentials);
        }
    }

    public static String decrypt(String encryptedData) {
        String decryptedValue = "";
        try {
            Key key = PersonDaoImpl.generateKey();
            Cipher c = Cipher.getInstance(ALGO);
            c.init(2, key);
            byte[] decordedValue = DatatypeConverter.parseBase64Binary((String)encryptedData);
            byte[] decValue = c.doFinal(decordedValue);
            decryptedValue = new String(decValue);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return decryptedValue;
    }

    private static Key generateKey() throws Exception {
        return new SecretKeySpec(keyValue, ALGO);
    }

    public BackupPolicy getBackupPolicy(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }

    public SyncPolicy getSyncPolicy(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (SyncPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), SyncPolicy.class);
    }

    public void saveStatisticToDatabase(int cloudId, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)audit);
    }

    public int validateUserRestrictions(int cloudId, int noOfUsersAllowed) {
        if ((long)noOfUsersAllowed <= this.countOfPresentUsers(cloudId, true)) {
            return 1503;
        }
        return 1500;
    }

    public long countOfPresentUsers(int cloudId, boolean active) {
        Criteria criteria = Criteria.where((String)ACTIVE).is((Object)active);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    public int validateSyncUserRestrictions(int cloudId, int noOfSyncUsersAllowed) {
        if ((long)noOfSyncUsersAllowed <= this.countOfPresentSyncUsers(cloudId, true)) {
            return 1503;
        }
        return 1500;
    }

    public int validateBackupUserRestrictions(int cloudId, int noOfBackupUsersAllowed) {
        if ((long)noOfBackupUsersAllowed <= this.countOfPresentBackupUsers(cloudId, true)) {
            return 1525;
        }
        return 1500;
    }

    public void saveUser(int cloudId, User user) {
        user.setLastModifiedTimestamp(Long.toString(System.currentTimeMillis()));
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)user);
    }

    public long countOfPresentSyncUsers(int cloudId, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"syncEnabled").is((Object)active)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    public long countOfPresentBackupUsers(int cloudId, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"backupEnabled").is((Object)active)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    public User getUserByName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    public void updateUserDelete(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex(Pattern.compile("^" + userName + "$", 2)), Criteria.where((String)"localUser").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(ACTIVE, (Object)false);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public void editAD(int cloudId, AdCredentials adCredentials) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        AdCredentials prevObj = this.getADForId(cloudId, adCredentials.getId());
        if (prevObj != null) {
            prevObj.setAdBase(adCredentials.getAdBase());
            prevObj.setAdCn(adCredentials.getAdCn());
            prevObj.setAdPassword(adCredentials.getAdPassword());
            prevObj.setAdUrl(adCredentials.getAdUrl());
            prevObj.setAdGroupName(adCredentials.getAdGroupName());
            prevObj.setAdProductType(adCredentials.getAdProductType());
            mongoTemplate.save((Object)prevObj);
        }
    }

    @Override
    public List<Person> getAllPersonByGroupName(AdCredentials adCredentials, String groupName) {
        ArrayList<Person> personList = new ArrayList<Person>();
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setTimeLimit(100000);
        AndFilter filter = new AndFilter();
        String cnName = adCredentials.getAdCn();
        logger.debug("FILTER........." + filter);
        LdapTemplate ldapTemplateObj = this.createTemplateWithAdCredentials(adCredentials);
        this.setLdapTemplate(ldapTemplateObj);
        this.ldapTemplate.setIgnorePartialResultException(true);
        cnName = adCredentials.getAdCn();
        this.setCName(cnName);
        String ouForMigration = adCredentials.getAdGroupName();
        filter.and((Filter)new EqualsFilter(MEMBER_OF, ouForMigration));
        PagedResultsCookie cookie = null;
        String page = null;
        do {
            try {
                if (page != null) {
                    cookie = new PagedResultsCookie(Hex.decodeHex((char[])page.toCharArray()));
                }
                PagedResultsDirContextProcessor processor = new PagedResultsDirContextProcessor(1000, cookie);
                List users = new ArrayList();
                users = this.ldapTemplate.search((Name)DistinguishedName.EMPTY_PATH, filter.toString(), controls, this.getContextMapper(), (DirContextProcessor)processor);
                logger.debug("...personslists...." + users.size());
                personList.addAll(users);
                logger.debug(personList.size() + "...personslists1...." + users.size());
                cookie = processor.getCookie();
                page = cookie != null && cookie.getCookie() != null ? new String(Hex.encodeHex((byte[])cookie.getCookie())) : null;
                logger.debug(page + ".....cookie val...." + cookie + "...cookie...." + processor.getCookie().getCookie());
            }
            catch (Exception e) {
                logger.error("..issue in pagination of ad ..." + e.getMessage());
                page = null;
            }
        } while (page != null);
        return personList;
    }

    private Person getPersonWithCn(String userName) {
        Person person = null;
        List<AdCredentials> adCredentialList = this.getAllAdCredentials(1);
        adCredentialList.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(adCredentialList)) {
            for (AdCredentials adCredentials : adCredentialList) {
                logger.debug(adCredentials.getUserDn() + " getPersonUsingADCredentials ....... " + adCredentials.getAdBase());
                Person tempPerson = this.getPersonUsingUserNameWithCn(userName, adCredentials);
                if (tempPerson != null) {
                    if (person == null) {
                        person = tempPerson;
                        continue;
                    }
                    if (person.getAdGroupType().equalsIgnoreCase(tempPerson.getAdGroupType())) continue;
                    person.setAdGroupType("both");
                    continue;
                }
                logger.debug("............");
            }
        } else {
            logger.error("no credentials defined for AD.....");
        }
        return person;
    }

    public Person getPersonUsingUserNameWithCn(String userName, AdCredentials adCredentials) {
        Person person = null;
        LdapTemplate ldapTemplateFromSpring = this.ldapTemplate;
        try {
            List users;
            LdapTemplate ldapTemplateObj = this.createTemplateWithAdCredentials(adCredentials);
            if (ldapTemplateObj == null) {
                return null;
            }
            this.setLdapTemplate(ldapTemplateObj);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setTimeLimit(100000);
            AndFilter filter = new AndFilter();
            String cnName = "cn";
            logger.debug(cnName + "...User Name...:" + userName);
            filter = userName.contains("@") ? filter.and((Filter)new EqualsFilter(USERPRINCIPALNAME, userName)) : filter.and((Filter)new EqualsFilter(OBJECT_CLASS, PERSON)).and((Filter)new EqualsFilter(cnName, userName));
            cnName = adCredentials.getAdCn();
            this.setCName(cnName);
            String filterBy = "(&(objectclass=person)(userPrincipalName=" + userName + "*))";
            String ouForMigration = adCredentials.getAdGroupName();
            this.ldapTemplate.setIgnorePartialResultException(true);
            if (!StringUtils.isEmpty((String)ouForMigration)) {
                filter.and((Filter)new EqualsFilter(MEMBER_OF, ouForMigration));
                String nameBase = "";
                if (StringUtils.isEmpty((String)nameBase)) {
                    nameBase = PCHelperConstant.getAdGroupNameForMigration();
                }
                users = this.ldapTemplate.search(nameBase, filter.toString(), controls, this.getContextMapper());
            } else {
                users = this.ldapTemplate.search((Name)DistinguishedName.EMPTY_PATH, filter.toString(), controls, this.getContextMapper());
            }
            if (!CollectionUtils.isEmpty((Collection)users)) {
                person = (Person)users.get(0);
                person.setAdGroupType(adCredentials.getAdProductType());
                logger.debug(filterBy + " end of getPersonUsingADCredentials ....... " + person.getAdGroupType());
            }
        }
        catch (Exception e) {
            logger.trace("Excpetion :" + e);
            logger.error(adCredentials.getUserDn() + " USER NOT FOUND using adcredentials ....... " + userName + "....message..." + e.getMessage());
            this.setLdapTemplate(ldapTemplateFromSpring);
            throw new BaseException(e.getMessage());
        }
        return person;
    }

    @Override
    public Person getPersonByUserName(String userName) {
        Person person = null;
        List<AdCredentials> adCredentialList = this.getAllAdCredentials(1);
        adCredentialList.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(adCredentialList)) {
            for (AdCredentials adCredentials : adCredentialList) {
                logger.debug(adCredentials.getUserDn() + " getPersonUsingADCredentials ....... " + adCredentials.getAdBase());
                Person tempPerson = this.getPersonUsingUserName(userName, adCredentials);
                if (tempPerson != null) {
                    if (person == null) {
                        person = tempPerson;
                        continue;
                    }
                    if (person.getAdGroupType().equalsIgnoreCase(tempPerson.getAdGroupType())) continue;
                    person.setAdGroupType("both");
                    continue;
                }
                logger.debug("............");
            }
        } else {
            logger.error("no credentials defined for AD.....");
        }
        return person;
    }

    @Override
    public Person getPersonByUserNameForSync(String userName) {
        Person person = null;
        List<AdCredentials> adCredentialList = this.getAllAdCredentials(1);
        adCredentialList.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(adCredentialList)) {
            for (AdCredentials adCredentials : adCredentialList) {
                logger.debug(adCredentials.getUserDn() + " getPersonUsingADCredentials ....... " + adCredentials.getAdBase());
                Person tempPerson = this.getPersonByUserNameForSync(userName, adCredentials);
                if (tempPerson != null) {
                    if (person == null) {
                        person = tempPerson;
                        continue;
                    }
                    if (person.getAdGroupType().equalsIgnoreCase(tempPerson.getAdGroupType())) continue;
                    person.setAdGroupType("both");
                    continue;
                }
                logger.debug("............");
            }
        } else {
            logger.error("no credentials defined for AD.....");
            throw new BaseException("no credentials defined for AD", 400);
        }
        return person;
    }

    public Person getPersonUsingUserName(String userName, AdCredentials adCredentials) {
        Person person = null;
        LdapTemplate ldapTemplateFromSpring = this.ldapTemplate;
        try {
            List users;
            LdapTemplate ldapTemplateObj = this.createTemplateWithAdCredentials(adCredentials);
            if (ldapTemplateObj == null) {
                return null;
            }
            this.setLdapTemplate(ldapTemplateObj);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setTimeLimit(100000);
            AndFilter filter = new AndFilter();
            String cnName = adCredentials.getAdCn();
            logger.debug(cnName + "...User Name...:" + userName);
            filter = filter.and((Filter)new EqualsFilter(OBJECT_CLASS, PERSON)).and((Filter)new EqualsFilter(cnName, userName));
            this.setCName(cnName);
            String filterBy = "(&(objectclass=person)(userPrincipalName=" + userName + "*))";
            String ouForMigration = adCredentials.getAdGroupName();
            this.ldapTemplate.setIgnorePartialResultException(true);
            if (!StringUtils.isEmpty((String)ouForMigration)) {
                filter.and((Filter)new EqualsFilter(MEMBER_OF, ouForMigration));
                String nameBase = "";
                if (StringUtils.isEmpty((String)nameBase)) {
                    nameBase = PCHelperConstant.getAdGroupNameForMigration();
                }
                users = this.ldapTemplate.search(nameBase, filter.toString(), controls, this.getContextMapper());
            } else {
                users = this.ldapTemplate.search((Name)DistinguishedName.EMPTY_PATH, filter.toString(), controls, this.getContextMapper());
            }
            if (!CollectionUtils.isEmpty((Collection)users)) {
                person = (Person)users.get(0);
                person.setAdGroupType(adCredentials.getAdProductType());
                logger.debug(filterBy + " end of getPersonUsingADCredentials ....... " + person.getAdGroupType());
            }
        }
        catch (Exception e) {
            logger.trace("Excpetion :" + e);
            logger.error(adCredentials.getUserDn() + " USER NOT FOUND using adcredentials ....... " + userName + "....message..." + e.getMessage());
            this.setLdapTemplate(ldapTemplateFromSpring);
        }
        return person;
    }

    public Person getPersonByUserNameForSync(String userName, AdCredentials adCredentials) {
        Person person = null;
        LdapTemplate ldapTemplateFromSpring = this.ldapTemplate;
        try {
            List users;
            LdapTemplate ldapTemplateObj = this.createTemplateWithAdCredentials(adCredentials);
            if (ldapTemplateObj == null) {
                return null;
            }
            this.setLdapTemplate(ldapTemplateObj);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setTimeLimit(100000);
            AndFilter filter = new AndFilter();
            String cnName = adCredentials.getAdCn();
            logger.debug(cnName + "...User Name...:" + userName);
            filter = filter.and((Filter)new EqualsFilter(OBJECT_CLASS, PERSON)).and((Filter)new EqualsFilter(cnName, userName));
            this.setCName(cnName);
            String filterBy = "(&(objectclass=person)(userPrincipalName=" + userName + "*))";
            String ouForMigration = adCredentials.getAdGroupName();
            this.ldapTemplate.setIgnorePartialResultException(true);
            if (!StringUtils.isEmpty((String)ouForMigration)) {
                filter.and((Filter)new EqualsFilter(MEMBER_OF, ouForMigration));
                String nameBase = "";
                if (StringUtils.isEmpty((String)nameBase)) {
                    nameBase = PCHelperConstant.getAdGroupNameForMigration();
                }
                users = this.ldapTemplate.search(nameBase, filter.toString(), controls, this.getContextMapper());
            } else {
                users = this.ldapTemplate.search((Name)DistinguishedName.EMPTY_PATH, filter.toString(), controls, this.getContextMapper());
            }
            if (!CollectionUtils.isEmpty((Collection)users)) {
                person = (Person)users.get(0);
                person.setAdGroupType(adCredentials.getAdProductType());
                logger.debug(filterBy + " end of getPersonUsingADCredentials ....... " + person.getAdGroupType());
            }
        }
        catch (Exception e) {
            logger.trace("Excpetion :" + e);
            logger.error(adCredentials.getUserDn() + " USER NOT FOUND using adcredentials ....... " + userName + "....message..." + e.getMessage());
            this.setLdapTemplate(ldapTemplateFromSpring);
            throw new BaseException(e.getMessage(), 400);
        }
        return person;
    }

    private class PersonContextMapper
    extends AbstractContextMapper {
        private PersonContextMapper() {
        }

        public Object doMapFromContext(DirContextOperations context) {
            Person person = new Person();
            String cnName = PCHelperConstant.getAdCn();
            if (!StringUtils.isEmpty((String)PersonDaoImpl.this.getCName())) {
                cnName = PersonDaoImpl.this.getCName();
            }
            logger.debug(PersonDaoImpl.this.getCName() + "  CNAME inside context mapper ......... " + cnName);
            person.setFullName(context.getStringAttribute(cnName));
            person.setFirstName(context.getStringAttribute("givenName"));
            person.setLastName(context.getStringAttribute("sn"));
            person.setDescription(context.getStringAttribute("description"));
            String adEmailConfig = PCHelperConstant.getAdEmailConfig();
            if (StringUtils.isEmpty((String)adEmailConfig) || adEmailConfig.equalsIgnoreCase(PersonDaoImpl.USERPRINCIPALNAME)) {
                person.setEmailId(context.getStringAttribute(PersonDaoImpl.USERPRINCIPALNAME));
            } else if (adEmailConfig.equalsIgnoreCase("mail")) {
                person.setEmailId(context.getStringAttribute("mail"));
            } else {
                String userPrincipalName = context.getStringAttribute(PersonDaoImpl.USERPRINCIPALNAME);
                String userName = userPrincipalName.substring(0, userPrincipalName.indexOf("@"));
                adEmailConfig = adEmailConfig.replace("@", "");
                StringBuilder adEmailId = new StringBuilder();
                adEmailId.append(userName);
                adEmailId.append("@");
                adEmailId.append(adEmailConfig);
                person.setEmailId(adEmailId.toString());
            }
            if (StringUtils.isEmpty((String)person.getFirstName()) || StringUtils.isEmpty((String)person.getLastName())) {
                logger.debug("********** Ad First Name or Last Name is empty ***********");
                person.setDisplayName(context.getStringAttribute("displayName"));
            } else {
                logger.debug("********** Ad First Name and Last Name is not empty ***********");
                person.setDisplayName(person.getFirstName() + " " + person.getLastName());
            }
            person.setOrganizationalUnit(context.getStringAttribute("distinguishedName"));
            person.setLocation(context.getStringAttribute("physicalDeliveryOfficeName"));
            person.setDepartment(context.getStringAttribute("department"));
            logger.debug("....status....... " + context.getStringAttribute(PersonDaoImpl.USERACCOUNTCONTROL));
            boolean accountStatus = true;
            if (!StringUtils.isEmpty((String)context.getStringAttribute(PersonDaoImpl.USERACCOUNTCONTROL)) && ("514".equals(context.getStringAttribute(PersonDaoImpl.USERACCOUNTCONTROL)) || "66050".equals(context.getStringAttribute(PersonDaoImpl.USERACCOUNTCONTROL)))) {
                accountStatus = false;
            }
            person.setAccountStatus(accountStatus);
            logger.debug(person.getDepartment() + "............" + person.getLocation() + ".... end of loading  person ... " + context.getStringAttribute(PersonDaoImpl.USERPRINCIPALNAME));
            return person;
        }
    }
}

