/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.domain.CloudStorageType;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.Proxy;
import com.parablu.pcbd.domain.User;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PciAuthorizationTokensDaoImpl
implements PciAuthorizationTokensDao {
    private static Logger logger = LogManager.getLogger(PciAuthorizationTokensDaoImpl.class);
    private static final String TOKEN_URL = "https://login.windows.net/common/oauth2/token";
    private static final String UTF_8 = "UTF-8";
    private static final String REFRESH_TOKEN = "refresh_token";
    public static final String CONTENT_TYPE = "Content-Type";
    private static final String EXCEPTION = " Exception  :";
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String USER_ID = "userId";

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void savePciAuthorizationTokens(int cloudId, String cloudName, PciAuthorizationTokens pciAuthorizationTokens) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)pciAuthorizationTokens);
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokensForUserId(int cloudId, String cloudName, ObjectId userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_ID).is((Object)userId));
        return (PciAuthorizationTokens)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, PciAuthorizationTokens.class);
    }

    @Override
    public void saveCloudStorageType(int cloudId, String cloudName, CloudStorageType cloudStorageType) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)cloudStorageType);
    }

    @Override
    public CloudStorageType getCloudStorageTypeByName(int cloudId, String cloudName, String name) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        return (CloudStorageType)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, CloudStorageType.class);
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokensForServiceAccount(int cloudId, String cloudName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"serviceAccount").is((Object)true));
        return (PciAuthorizationTokens)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, PciAuthorizationTokens.class);
    }

    @Override
    public List<PciAuthorizationTokens> getAllPciAuthorizationTokens(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(PciAuthorizationTokens.class);
    }

    @Override
    public void deletePciAuthorizationTokensForUserId(int cloudId, String cloudName, ObjectId userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_ID).is((Object)userId));
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove(query, PciAuthorizationTokens.class);
    }

    @Override
    public void updatePciAuthorizationTokensForUserId(int cloudId, String cloudName, ObjectId userId, String accessToken, String refreshToken) {
        Criteria criteria = Criteria.where((String)USER_ID).is((Object)userId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("accessToken", (Object)accessToken);
        update.set("refreshToken", (Object)refreshToken);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, PciAuthorizationTokens.class);
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokensForUserName(int cloudId, String userName) {
        PciAuthorizationTokens pciAuthorizationTokens = null;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex(Pattern.compile("^" + userName + "$", 2)), criteria.orOperator(new Criteria[]{Criteria.where((String)"deleted").is((Object)false), Criteria.where((String)"deleted").exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        if (user != null) {
            query = new Query((CriteriaDefinition)Criteria.where((String)USER_ID).is((Object)user.getUserId()));
            pciAuthorizationTokens = (PciAuthorizationTokens)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, PciAuthorizationTokens.class);
        }
        return pciAuthorizationTokens;
    }

    @Override
    public String getAccessTokenForODBBackup(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSGTokens msgToken = (MSGTokens)mongoTemplate.findOne(new Query(), MSGTokens.class);
        String accessToken = null;
        if (msgToken != null) {
            accessToken = msgToken.getAccessToken();
        }
        return accessToken;
    }

    @Override
    public boolean updateTokenForODBBackup(int cloudId) {
        boolean tokenUpdated = false;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSGTokens msgToken = (MSGTokens)mongoTemplate.findOne(new Query(), MSGTokens.class);
        if (msgToken == null) {
            logger.error("....no token available.........");
            return tokenUpdated;
        }
        String accessToken = "";
        String refreshToken = "";
        CloseableHttpClient httpclient = null;
        HttpPost httPost = null;
        CloseableHttpResponse result = null;
        logger.debug("  updateTokenForODBBackup.....................................");
        try {
            String line;
            Proxy proxy = this.getProxy(1);
            if (proxy != null || !StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                logger.debug("host :" + PCHelperConstant.getProxyHost());
                logger.debug("port :" + PCHelperConstant.getProxyPort());
                HttpHost proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
            } else {
                httpclient = HttpClients.custom().build();
            }
            String loginUrl = TOKEN_URL;
            httPost = new HttpPost(loginUrl);
            logger.debug("...loginUrl..." + loginUrl);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("grant_type", REFRESH_TOKEN));
            params.add(new BasicNameValuePair("client_id", msgToken.getClientId()));
            params.add(new BasicNameValuePair(REFRESH_TOKEN, msgToken.getRefreshToken()));
            params.add(new BasicNameValuePair("client_secret", msgToken.getClientSecret()));
            httPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, UTF_8));
            httPost.setHeader(CONTENT_TYPE, "application/x-www-form-urlencoded");
            result = httpclient.execute((HttpUriRequest)httPost);
            int httpResponseCode = result.getStatusLine().getStatusCode();
            logger.debug("......getAccessTokenAndUpdateInDB....." + httpResponseCode);
            if (httpResponseCode == 400) {
                logger.error("TOKEN has expired so remap the token...... ");
                return false;
            }
            InputStream inputStream = result.getEntity().getContent();
            BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder response = new StringBuilder("");
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
            rd.close();
            JSONObject jsonObject = new JSONObject(response.toString());
            accessToken = jsonObject.optString("access_token");
            refreshToken = jsonObject.optString(REFRESH_TOKEN);
            this.updateMSGToken(cloudId, accessToken, refreshToken);
            tokenUpdated = true;
        }
        catch (Exception e) {
            logger.error("...unable to update access token.........");
        }
        return tokenUpdated;
    }

    public Proxy getProxy(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List proxies = mongoTemplate.findAll(Proxy.class);
        if (CollectionUtils.isEmpty((Collection)proxies)) {
            return null;
        }
        return (Proxy)proxies.get(0);
    }

    private void updateMSGToken(int cloudId, String accessToken, String refreshToken) {
        Query query = new Query();
        Update update = new Update();
        update.set("accessToken", (Object)accessToken);
        update.set("refreshToken", (Object)refreshToken);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, MSGTokens.class);
    }

    @Override
    public void saveMSGTokens(int cloudId, MSGTokens msgTokens) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSGTokens findOne = (MSGTokens)mongoTemplate.findOne(new Query(), MSGTokens.class);
        if (findOne != null) {
            mongoTemplate.remove((Object)findOne);
        }
        mongoTemplate.save((Object)msgTokens);
    }

    @Override
    public MSGTokens getMSGTokens(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MSGTokens)mongoTemplate.findOne(new Query(), MSGTokens.class);
    }

    @Override
    public MSGTokens getMSGTokensForUserId(int cloudId, ObjectId userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_ID).is((Object)userId));
        return (MSGTokens)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, MSGTokens.class);
    }

    @Override
    public MSAppSetting getMSAppSettingsDetails(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MSAppSetting)mongoTemplate.findOne(new Query(), MSAppSetting.class);
    }
}

