/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.ReadPreference;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.CloudSettings;
import com.parablu.pcbd.domain.FileRevision;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class ExternalStorageBackupFileDaoImpl
implements ExternalStorageBackupFileDao {
    public static final String USER_NAME = "userName";
    public static final String CHUNK_DETAIL = "CHUNK_DETAIL";
    public static final int CHUNK_TOTAL_DB_COUNT = PCHelperConstant.getChunkTotalBuckets();
    Logger logger = LogManager.getLogger(ExternalStorageBackupFileDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String PRIVACY_GATEWAY_OD = "privacy_gateway_od_";
    private static final String EXCEPTION = " Exception  :";
    private static final String PRIVACY_GATEWAY_SYNC = "privacy_gateway_sync_";
    private static final String CLOUD_NAME = "cloudName>>>:";
    private static final String CLOUD_ID = "cloud id>>>";
    private static final String CHUNCK_FILES = "chunkFiles";
    private static final String MAC = "Macintosh";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveBackupFileInfo(int cloudId, String cloudName, String userName, BackupFile backupFile) {
        String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.createCollectionIfNotExists(tableName, mongoTemplate);
        mongoTemplate.insert((Object)backupFile, tableName);
    }

    private void createCollectionIfNotExists(String tableName, MongoTemplate mongoTemplate) {
        try {
            if (!mongoTemplate.collectionExists(tableName)) {
                mongoTemplate.createCollection(tableName);
            }
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
    }

    @Override
    public BackupFile getBackupFile(int cloudId, String cloudName, String userName, String id) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)new ObjectId(id)));
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
        return backupFile;
    }

    @Override
    public void saveSyncFileInfo(int cloudId, String cloudName, String userName, BackupFile backupFile) {
        String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.createCollectionIfNotExists(tableName, mongoTemplate);
        this.logger.debug("before saving to sync db>>>>>>>>>>>");
        mongoTemplate.save((Object)backupFile, tableName);
    }

    @Override
    public BackupFile getSyncFile(int cloudId, String cloudName, String userName, String id) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
        return backupFile;
    }

    @Override
    public void deleteBackupFile(int cloudId, String cloudName, String userName, String id) {
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
            mongoTemplate.remove(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
    }

    @Override
    public void deleteTableForUser(int cloudId, String cloudName, String userName) {
        String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug("Deleting the table for user....." + userName);
        if (mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.dropCollection(tableName);
        }
    }

    @Override
    public List<BackupFile> getBackupFilesForGivenPathAndFileName(int cloudId, String cloudName, String userName, String folderPath1, String fileName) {
        String folderPath = folderPath1;
        List backupFiles = null;
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            if (!folderPath.startsWith(MAC)) {
                String devicePathSeparator = "\\";
                folderPath = folderPath.replace("/", devicePathSeparator);
            }
            this.logger.debug("FolderPATH>>>>>>>>>>>" + folderPath);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"filePath").is((Object)folderPath), Criteria.where((String)"fileName").is((Object)fileName)});
            Query query = new Query((CriteriaDefinition)criteria);
            backupFiles = mongoTemplate.find(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
        return backupFiles;
    }

    @Override
    public void markBackupFiletoDelete(int cloudId, String cloudName, String userName, String id) {
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
            Update update = new Update();
            update.set("deleted", (Object)true);
            mongoTemplate.findAndModify(query, update, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
    }

    public List<BackupFile> getBackupFiles1(int cloudId, String cloudName, String userName, int skipValue) {
        List backupFiles = null;
        try {
            this.logger.debug(CLOUD_ID + cloudId + CLOUD_NAME + cloudName + "skipValue>>" + skipValue);
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            tableName = tableName.toUpperCase();
            Query query = new Query();
            if (skipValue != 0 && skipValue != -1) {
                query.skip((long)(skipValue * 300));
                query.limit(300);
            } else {
                query.limit(300);
            }
            backupFiles = mongoTemplate.find(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.trace(" !!!!! ERROR TRYING TO getBackupFile ...." + e);
            this.logger.error("  !!!!! ERROR TRYING TO getBackupFile ...." + e.getMessage());
        }
        return backupFiles;
    }

    @Override
    public List<BackupFile> getBackupFiles(int cloudId, String cloudName, String userName, int skipValue) {
        ArrayList<BackupFile> backupFiles = new ArrayList<BackupFile>();
        try {
            this.logger.debug(CLOUD_ID + cloudId + CLOUD_NAME + cloudName + "skipValue>>" + skipValue);
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            tableName = tableName.toUpperCase();
            MongoCollection collection = mongoTemplate.getCollection(tableName);
            this.logger.debug("Collection mycol selected successfully");
            Bson searchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)CHUNCK_FILES, (Object)new Document("$exists", (Object)Boolean.TRUE)), Filters.eq((String)CHUNCK_FILES, (Object)new Document("$size", (Object)1))});
            FindIterable iterable = skipValue != 0 && skipValue != -1 ? collection.find(searchQuery).skip(skipValue * 300).limit(300) : collection.find(searchQuery).limit(300);
            MongoCursor cursor = iterable.iterator();
            while (cursor.hasNext()) {
                Document next = (Document)cursor.next();
                BackupFile backupFile = (BackupFile)mongoTemplate.getConverter().read(BackupFile.class, (Object)next);
                backupFiles.add(backupFile);
            }
            cursor.close();
        }
        catch (Exception e) {
            this.logger.trace(" !!!!! ERROR TRYING TO getBackupFile ...." + e);
        }
        return backupFiles;
    }

    @Override
    public long getCountOfTheTable(int cloudId, String cloudName, String userName) {
        long count = 0L;
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            tableName = tableName.toUpperCase();
            MongoCollection collection = mongoTemplate.getCollection(tableName);
            count = collection.countDocuments();
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
        return count;
    }

    @Override
    public BackupFile getBackupFileForDedupBackupId(int cloudId, String cloudName, String userName, String dedupBackupId) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"dedupBackupId").is((Object)dedupBackupId));
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
        return backupFile;
    }

    @Override
    public BackupFile getLastBackupFile(int cloudId, String cloudName, String userName) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query();
            query.with(new Sort(Sort.Direction.DESC, new String[]{"id"}));
            query.limit(1);
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
        return backupFile;
    }

    @Override
    public BackUpImage getLastBackupImageFile(int cloudId, String userName) {
        BackUpImage backupFile = null;
        try {
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2)), Criteria.where((String)"storagePlace").exists(true)});
            Query query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
            query.limit(1);
            backupFile = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
        return backupFile;
    }

    @Override
    public int getchunkFileCountForGivenPath(int cloudId, String cloudName, String userName, String cloudStoragePath) {
        long fileCount = 0L;
        try {
            long count;
            this.logger.debug(CLOUD_ID + cloudId + CLOUD_NAME + cloudName);
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            tableName = tableName.toUpperCase();
            MongoCollection collection = mongoTemplate.getCollection(tableName);
            this.logger.debug("Collection mycol selected successfully");
            Bson statusQuery = Filters.eq((String)"cloudStoragePath", (Object)cloudStoragePath);
            Bson fields = Filters.eq((String)"$elemMatch", (Object)statusQuery);
            Bson query = Filters.eq((String)CHUNCK_FILES, (Object)fields);
            fileCount = count = collection.countDocuments(query);
            this.logger.debug("Collection chunkfile success AND COUNT>>>>" + fileCount);
        }
        catch (Exception e) {
            this.logger.trace(" !!!!! ERROR TRYING TO get chunkfile count ...." + e);
        }
        return (int)fileCount;
    }

    @Override
    public void saveChunksForBackup(int cloudId, ObjectId backupId, List<ChunkFile> chunkFiles, boolean isCompressed) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        Query query = new Query((CriteriaDefinition)criteria);
        BackUpImage bkpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
        if (bkpImage != null) {
            bkpImage.setChunkFiles(new ArrayList<ChunkFile>());
            bkpImage.getChunkFiles().addAll(chunkFiles);
            bkpImage.setCompressed(isCompressed);
            mongoTemplate.save((Object)bkpImage);
        }
    }

    @Override
    public void saveChunkDetail(int cloudId, ChunkDetail chunkDetail) {
        Query query;
        ChunkDetail chunkDetailObj;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String collectionName = "";
        if (chunkDetail.getId() != null && (chunkDetailObj = (ChunkDetail)mongoTemplate.findOne(query = new Query((CriteriaDefinition)Criteria.where((String)"md5").is((Object)chunkDetail.getMd5())), ChunkDetail.class, CHUNK_DETAIL)) != null) {
            collectionName = CHUNK_DETAIL;
        }
        if (StringUtils.isEmpty((String)collectionName)) {
            collectionName = this.getChunkNewCollectionName(chunkDetail);
            this.createChunkIndex(mongoTemplate, collectionName);
        }
        this.logger.debug(collectionName + "...." + chunkDetail.getId());
        mongoTemplate.save((Object)chunkDetail, collectionName);
    }

    @Override
    public void updateChunkDetail(int cloudId, ChunkDetail chunkDetail) {
        ChunkDetail chunkDetailObj;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String collectionName = "";
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)chunkDetail.getId()));
        if (chunkDetail.getId() != null && (chunkDetailObj = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, CHUNK_DETAIL)) != null) {
            collectionName = CHUNK_DETAIL;
        }
        if (StringUtils.isEmpty((String)collectionName)) {
            collectionName = this.getChunkNewCollectionName(chunkDetail);
            this.createChunkIndex(mongoTemplate, collectionName);
        }
        Update update = new Update();
        update.set("refCount", (Object)chunkDetail.getRefCount());
        mongoTemplate.updateFirst(query, update, ChunkDetail.class, collectionName);
    }

    private void createChunkIndex(MongoTemplate mongoTemplate, String collectionName) {
        MongoCollection chunkCollection = mongoTemplate.getCollection(collectionName);
        chunkCollection.createIndex(Indexes.ascending((String[])new String[]{"md5"}));
    }

    private String getChunkNewCollectionName(ChunkDetail chunkDetail) {
        int hashCode = Arrays.hashCode(chunkDetail.getMd5().getBytes());
        int chunkDetailDest = Math.abs(hashCode % CHUNK_TOTAL_DB_COUNT);
        return "CHUNK_DETAIL_" + chunkDetailDest;
    }

    @Override
    public ChunkDetail getChunkDetailForMd5(int cloudId, String md5) {
        String dest;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug("MD5 for searching in chunk table is>>" + md5);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        Query query = new Query((CriteriaDefinition)criteria);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        ChunkDetail chunkDetail = null;
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (chunkDetail = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, dest = iterator.next())) == null) {
        }
        if (chunkDetail == null) {
            this.logger.debug("Chunk Detail is nulll>>>>>>inside dao impl");
        }
        return chunkDetail;
    }

    @Override
    public ChunkDetail getChunkDetailForMd5AndUserName(int cloudId, String md5, String userName, boolean checkWithUserCaseSensitive) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug("MD5 for searching in chunk table is>>" + md5 + " and userName" + userName);
        Criteria criteria = new Criteria();
        if (checkWithUserCaseSensitive) {
            this.logger.debug(".................Inside new chunk query with userName case insensitive..........");
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        } else {
            this.logger.debug(".................Inside old chunk query ..........");
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        ArrayList chunkDetailList = new ArrayList();
        ChunkDetail chunkDetail = null;
        for (String dest : queryTablesList) {
            List chunkDetailByDB = mongoTemplate.find(query, ChunkDetail.class, dest);
            if (CollectionUtils.isEmpty((Collection)chunkDetailByDB)) continue;
            chunkDetailList.addAll(chunkDetailByDB);
        }
        if (CollectionUtils.isEmpty(chunkDetailList)) {
            this.logger.debug("chunkDetailList is null");
            return chunkDetail;
        }
        this.logger.debug("chunkDetailList fount :" + chunkDetailList.size());
        chunkDetail = chunkDetailList.stream().filter(chunk -> !chunk.isDeleteProcessStarted() && !chunk.isPreEntry() && Objects.nonNull(chunk.getRefCount()) && chunk.getRefCount() > 0).findFirst().orElse(null);
        if (chunkDetail == null) {
            this.logger.debug("chunk detail is null....");
            return chunkDetail;
        }
        return chunkDetail;
    }

    private List<String> getChunkDetailCollections(String md5) {
        ArrayList<String> queryTablesList = new ArrayList<String>();
        if (PCHelperConstant.isChunkCollectionQueryRequired()) {
            queryTablesList.add(CHUNK_DETAIL);
        }
        int hashCode = Arrays.hashCode(md5.getBytes());
        int chunkDetailDest = Math.abs(hashCode % CHUNK_TOTAL_DB_COUNT);
        queryTablesList.add("CHUNK_DETAIL_" + chunkDetailDest);
        return queryTablesList;
    }

    @Override
    public BackUpImage getBackupImageForId(int cloudId, String id) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public void deleteUnReferencedChunks(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"refCount").is((Object)0)});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, ChunkDetail.class);
    }

    @Override
    public void deleteRevision(int cloudId, String cloudName, FileRevision fileRevision) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove((Object)fileRevision);
    }

    @Override
    public List<ChunkDetail> getUnReferencedChunks(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"refCount").is((Object)0)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(500);
        return mongoTemplate.find(query, ChunkDetail.class);
    }

    @Override
    public void deleteUnReferencedChunks(int cloudId, List<ObjectId> objectIds) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(objectIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, ChunkDetail.class);
    }

    @Override
    public List<BackupFile> getAllSyncFiles(int cloudId, String cloudName, String userName, List<ObjectId> sharedIds) {
        List backupFiles = null;
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"id").nin(sharedIds)});
            Query query = new Query((CriteriaDefinition)criteria);
            query.limit(500);
            backupFiles = mongoTemplate.find(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.trace("get sync file:" + e);
        }
        return backupFiles;
    }

    @Override
    public void deleteSyncFiles(int cloudId, List<ObjectId> objectIds, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
        tableName = tableName.toUpperCase();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(objectIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, BackupFile.class, tableName);
    }

    @Override
    public FileRevision getSyncFileByUserName(int cloudId, String cloudName, String userName, List<ObjectId> allMySharedFilesIds) {
        FileRevision fileRevision = null;
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"id").nin(allMySharedFilesIds)});
            Query query = new Query((CriteriaDefinition)criteria);
            fileRevision = (FileRevision)mongoTemplate.findOne(query, FileRevision.class, tableName);
        }
        catch (Exception e) {
            this.logger.trace("get sync file:" + e);
        }
        return fileRevision;
    }

    @Override
    public BackupFile getSyncFileByUserNameFileNameandFilePath(int cloudId, String cloudName, String userName, String fileName, String filePath) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"filePath").is((Object)filePath), Criteria.where((String)"fileName").is((Object)fileName)});
            Query query = new Query((CriteriaDefinition)criteria);
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.trace("get sync file:" + e);
        }
        return backupFile;
    }

    @Override
    public ChunkDetail getChunkDetailForMd5(int cloudId, String md5, String dedupType, String userName, boolean isUpload, boolean checkWithUserCaseSensitive) {
        if (!StringUtils.isEmpty((String)dedupType) && dedupType.equalsIgnoreCase(DEDUP.DISABLED.toString())) {
            return null;
        }
        String dedupTypeVal = StringUtils.isEmpty((String)dedupType) ? DEDUP.GLOBAL.toString() : dedupType;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (DEDUP.USER.toString().equalsIgnoreCase(dedupTypeVal)) {
            if (checkWithUserCaseSensitive) {
                this.logger.debug(".................Inside new chunk query with userName case insensitive..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
            } else {
                this.logger.debug(".................Inside old chunk query ..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName)});
            }
        }
        if (DEDUP.GLOBAL.toString().equalsIgnoreCase(dedupTypeVal)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        long timeMillisec = System.currentTimeMillis();
        this.logger.debug("#####Before Getting chunk details for MD5###" + md5);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        List<Object> chunkDetailList = new ArrayList();
        ChunkDetail chunkDetail = null;
        for (String dest : queryTablesList) {
            List chunkDetailByDB = mongoTemplate.find(query, ChunkDetail.class, dest);
            if (CollectionUtils.isEmpty((Collection)chunkDetailByDB)) continue;
            chunkDetailList.addAll(chunkDetailByDB);
        }
        if (CollectionUtils.isEmpty(chunkDetailList)) {
            this.logger.debug("chunkDetailList is null");
            return chunkDetail;
        }
        CloudSettings cloudSettings = this.getCloudSettings(cloudId);
        if (cloudSettings != null && cloudSettings.getDedupStartTime() != 0L) {
            chunkDetailList = chunkDetailList.stream().filter(chunkDetail1 -> chunkDetail1.getChunkCreatedTime() > cloudSettings.getDedupStartTime()).collect(Collectors.toList());
        }
        this.logger.debug("chunkDetailList found :" + chunkDetailList.size());
        chunkDetail = chunkDetailList.stream().filter(chunk -> !chunk.isDeleteProcessStarted() && !chunk.isPreEntry() && Objects.nonNull(chunk.getRefCount()) && chunk.getRefCount() > 0).findFirst().orElse(null);
        long afterTimeMillisec = System.currentTimeMillis();
        this.logger.debug(chunkDetail + "... findone query MD5 for searching in chunk table is>>" + md5 + "...." + (afterTimeMillisec - timeMillisec));
        return chunkDetail;
    }

    @Override
    public ChunkDetail getChunkDetailForMd5ForRestore(int cloudId, String md5, String dedupType, String userName, boolean isUpload, boolean checkWithUserCaseSensitive) {
        if (!StringUtils.isEmpty((String)dedupType) && dedupType.equalsIgnoreCase(DEDUP.DISABLED.toString())) {
            String string = DEDUP.DISABLED.toString();
        }
        String dedupTypeVal = StringUtils.isEmpty((String)dedupType) ? DEDUP.GLOBAL.toString() : dedupType;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (DEDUP.USER.toString().equalsIgnoreCase(dedupTypeVal) || DEDUP.DISABLED.toString().equalsIgnoreCase(dedupTypeVal)) {
            if (checkWithUserCaseSensitive) {
                this.logger.debug(".................Inside new chunk query with userName case insensitive..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
            } else {
                this.logger.debug(".................Inside old chunk query ..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName)});
            }
        }
        if (DEDUP.GLOBAL.toString().equalsIgnoreCase(dedupTypeVal)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        long timeMillisec = System.currentTimeMillis();
        this.logger.debug("#####Before Getting chunk details for MD5###" + md5);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        return this.getChunkDetailByFilteringDedupStrtTime(cloudId, md5, mongoTemplate, query, timeMillisec, queryTablesList, isUpload);
    }

    @Override
    public CloudSettings getCloudSettings(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        return (CloudSettings)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), CloudSettings.class);
    }

    private ChunkDetail getChunkDetailByFilteringDedupStrtTime(int cloudId, String md5, MongoTemplate mongoTemplate, Query query, long timeMillisec, List<String> queryTablesList, boolean isUpload) {
        ChunkDetail chunkDetail = null;
        ArrayList chunkDetailList = new ArrayList();
        for (String dest : queryTablesList) {
            List chunkDetailByDB = mongoTemplate.find(query, ChunkDetail.class, dest);
            if (CollectionUtils.isEmpty((Collection)chunkDetailByDB)) continue;
            chunkDetailList.addAll(chunkDetailByDB);
        }
        if (!CollectionUtils.isEmpty(chunkDetailList)) {
            CloudSettings cloudSettings = this.getCloudSettings(cloudId);
            chunkDetail = isUpload && cloudSettings != null && cloudSettings.getDedupStartTime() != 0L ? (ChunkDetail)chunkDetailList.stream().filter(chunkDetail1 -> chunkDetail1.getChunkCreatedTime() > cloudSettings.getDedupStartTime()).findFirst().orElse(null) : (ChunkDetail)chunkDetailList.get(0);
        }
        long afterTimeMillisec = System.currentTimeMillis();
        this.logger.debug(chunkDetail + "... findone query MD5 for searching in chunk table is>>" + md5 + "...." + (afterTimeMillisec - timeMillisec));
        return chunkDetail;
    }

    @Override
    public List<ChunkDetail> getChunkDetailListForMd5(int cloudId, String md5, String dedupType, String userName, boolean isUpload, boolean checkWithUserCaseSensitive) {
        if (!StringUtils.isEmpty((String)dedupType) && dedupType.equalsIgnoreCase(DEDUP.DISABLED.toString())) {
            return null;
        }
        String dedupTypeVal = StringUtils.isEmpty((String)dedupType) ? DEDUP.GLOBAL.toString() : dedupType;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (DEDUP.USER.toString().equalsIgnoreCase(dedupTypeVal)) {
            if (checkWithUserCaseSensitive) {
                this.logger.debug(".................Inside new chunk query with userName case insensitive..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
            } else {
                this.logger.debug(".................Inside old chunk query ..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName)});
            }
        }
        if (DEDUP.GLOBAL.toString().equalsIgnoreCase(dedupTypeVal)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        }
        Criteria clientDedupCri = Criteria.where((String)"preEntry").is((Object)false);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{clientDedupCri, criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        this.logger.debug("#####Before Getting chunk details for MD5###" + md5);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        ArrayList<ChunkDetail> chunkDetailList = new ArrayList<ChunkDetail>();
        for (String dest : queryTablesList) {
            List chunkDetailByDB = mongoTemplate.find(query, ChunkDetail.class, dest);
            if (CollectionUtils.isEmpty((Collection)chunkDetailByDB)) continue;
            chunkDetailList.addAll(chunkDetailByDB);
        }
        return chunkDetailList;
    }

    static enum DEDUP {
        DISABLED,
        USER,
        GLOBAL;

    }
}

