/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.BasicDBObject;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.DeviceBackupJobDao;
import com.parablu.pcbd.domain.DeviceBackupJob;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DeviceBackupJobDaoImpl
implements DeviceBackupJobDao {
    private static Logger logger = LogManager.getLogger(DeviceBackupJobDaoImpl.class);
    @Resource
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void registerJob(DeviceBackupJob deviceBackupJob, int cloudId) {
        logger.debug("registerJob(DeviceBackupJob deviceBackupJob, int cloudId) > BEGIN");
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)deviceBackupJob);
        logger.debug("registerJob(DeviceBackupJob deviceBackupJob, int cloudId) > END");
    }

    @Override
    public DeviceBackupJob getDeviceBackupJob(int cloudId, String deviceUUID, ObjectId jobId) {
        logger.debug("DeviceBackupJob getDeviceBackupJob(int cloudId, String deviceUUID, String containerName) > BEGIN");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"deviceUUID").is((Object)deviceUUID).and("id").is((Object)jobId);
        Query query = new Query((CriteriaDefinition)criteria);
        DeviceBackupJob deviceBackupJob = (DeviceBackupJob)mongoTemplate.findOne(query, DeviceBackupJob.class);
        logger.debug("DeviceBackupJob getDeviceBackupJob(int cloudId, String deviceUUID, String containerName) > BEFORE RETURN > deviceBackupJob > " + deviceBackupJob);
        return deviceBackupJob;
    }

    @Override
    public List<DeviceBackupJob> getAllOngoingBackupJobs(int cloudId, String deviceUUID, int skipValue, String status) {
        logger.debug("getAllOngoingBackupJobs(int cloudId, String deviceUUID, int skipValue) > BEGIN");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"status").regex(Pattern.compile(status, 2));
        if (!"all".equalsIgnoreCase(deviceUUID)) {
            criteria = criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastUpdatedTimeStamp"}));
        List deviceBackupJobs = mongoTemplate.find(query, DeviceBackupJob.class);
        logger.debug("getAllOngoingBackupJobs(int cloudId, String deviceUUID, int skipValue) > BEFORE RETURN");
        return deviceBackupJobs;
    }

    @Override
    public long getRawDataUsage(int cloudId) {
        logger.debug("long getRawDataUsage(int cloudId) > BEGIN > cloudID > " + cloudId);
        long size = 0L;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        TypedAggregation aggregation = Aggregation.newAggregation(DeviceBackupJob.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"status"}).sum("backupSizeOnDiskInBytes").as("rawDataSize")});
        AggregationResults aggResult = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        for (BasicDBObject basicDBObject : aggResult) {
            String jobType = (String)basicDBObject.get("_id");
            if (!"completed".equalsIgnoreCase(jobType)) continue;
            logger.debug("getRawDataUsage(int cloudId) > jobType > " + jobType);
            size = Long.valueOf(basicDBObject.get("rawDataSize").toString());
            logger.debug("getRawDataUsage(int cloudId) > Size > " + size);
            return size;
        }
        logger.debug("long getRawDataUsage(int cloudId) > BEFORE RETURN  > size > " + size);
        return size;
    }
}

