/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.CalloutScriptDao;
import com.parablu.pcbd.domain.CalloutScript;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class CalloutScriptDaoImpl
implements CalloutScriptDao {
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveCalloutScript(int cloudId, String cloudName, CalloutScript calloutScript) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)calloutScript);
    }

    @Override
    public CalloutScript getCalloutScript(int cloudId, String cloudName, String scriptName, List<String> scriptArgs) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"scriptName").is((Object)scriptName), Criteria.where((String)"scriptArgs").is(scriptArgs)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (CalloutScript)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), CalloutScript.class);
    }

    @Override
    public List<CalloutScript> getAllCalloutScript(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(CalloutScript.class);
    }

    @Override
    public void deleteCalloutScriptForPolicyId(int cloudId, String cloudName, List<ObjectId> idList) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"backupFolderId").in(idList)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(new Query((CriteriaDefinition)criteria), CalloutScript.class);
    }
}

