/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.DBRef;
import com.mongodb.ReadPreference;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.KeyValueElement;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackUpImageStatistics;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.DeletedBackupFile;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.ExternalStorageFileImage;
import com.parablu.pcbd.domain.FileInfo;
import com.parablu.pcbd.domain.LatestDeviceBackupInfo;
import com.parablu.pcbd.domain.ReBackUpImage;
import com.parablu.pcbd.domain.User;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class BackUpImageDaoImpl
implements BackUpImageDao {
    Logger logger = LogManager.getLogger(BackUpImageDaoImpl.class);
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String DEVICE = "device";
    private static final String FILE_NAME = "fileName";
    private static final String DEVICE_PATH = "devicePath";
    private static final String LAST_SERVER_MODIFIED_TIME = "lastServerModifiedTime";
    private static final String SENT_DATE = "sentDate";
    private static final String PRESENT = "present";
    private static final String BACKUP = "BACKUP";
    private static final String DEVICE_ID = "device.$id";
    private static final String BLOCKED = "blocked";
    private static final String STATUS = "status";
    private static final String USER_NAME = "userName";
    private static final String ACTIVE = "active";
    private static final String DEVICE_NAME = "deviceName";
    private static final String DELETED = "DELETED";
    private static final String MD5_CHECK_SUM = "md5Checksum";
    private static final String END_MD5_GET_BACKUP_FILE_FOR_MD5_WITHOUT_USER_NAME = " @@@@ENDMD5 getBackupFileForMd5s without username ";
    private static final String FILE_EXTENSION = "fileExtension";
    private static final String COUNT = "count";
    private static final String DEVICE_UUID = "deviceUUID";
    private static final String FOLDER = "folder";
    public static final String BACKUP_PG = "backup_pg";
    private MongoOperations mongoOps;

    public MongoOperations getMongoOps() {
        return this.mongoOps;
    }

    public void setMongoOps(MongoOperations mongoOps) {
        this.mongoOps = mongoOps;
    }

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveImageToBackUpDao(int cloudId, String cloudName, BackUpImage backUpImage, Device device) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String destCollection = device.getDestCollection();
        if (backUpImage.getId() != null) {
            List<String> bkpCollectionList = this.getBackupCollectionList(device);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backUpImage.getId())});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            for (String dest : bkpCollectionList) {
                BackUpImage backUpImageObj = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest);
                if (backUpImageObj == null) continue;
                destCollection = dest;
                break;
            }
        }
        if (StringUtils.isNotEmpty((String)destCollection)) {
            mongoTemplate.save((Object)backUpImage, destCollection);
        } else {
            mongoTemplate.save((Object)backUpImage);
        }
    }

    @Override
    public void saveImageToBackUp(int cloudId, BackUpImage backUpImage, boolean isWriteConcernReplicaSafe) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backUpImage);
    }

    @Override
    public void removeListOfEntriesFromTable(int cloudId, String cloudName, List<String> backUpImagePathList, Device device) {
        String namedQuery = "delete from BackUpImage backUpImage where concat_ws('/',backUpImage.backUpImageUQ.devicePath,backUpImage.backUpImageUQ.fileName) in (:pathList) and backUpImage.backUpImageUQ.device.deviceId=:device";
        Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery(namedQuery);
        query.setParameterList("pathList", backUpImagePathList);
        query.executeUpdate();
    }

    @Override
    public BackUpImage getBackUpImageForFile(int cloudId, String cloudName, String fileName, String devicePath, String deviceUUID, boolean readPreference) {
        Device device = this.getDeviceForDeviceUUID(cloudId, deviceUUID);
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)devicePath)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (readPreference) {
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        }
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            BackUpImage backUpImageObj = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest);
            if (backUpImageObj == null) continue;
            return backUpImageObj;
        }
        return null;
    }

    @Override
    public List<BackUpImage> getListOfEntriesExceptGivenListFromTable(int cloudId, String cloudName, List<String> backUpImagePathList, Device device) {
        String namedQuery = "from BackUpImage backUpImage where concat_ws('/',backUpImage.backUpImageUQ.devicePath,backUpImage.backUpImageUQ.fileName) not in (:pathList) and backUpImage.backUpImageUQ.device.deviceId=:device";
        Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery(namedQuery);
        query.setParameterList("pathList", backUpImagePathList);
        return query.list();
    }

    @Override
    public List<BackUpImage> getAllBackUpDataForDevice(int cloudId, String cloudName, Device device1) {
        Device device = this.getDeviceForId(cloudId, device1.getId());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public void removeEntryFromTable(int cloudId, String cloudName, BackUpImage backUpImage) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backUpImage);
    }

    @Override
    public List<BackUpImage> getChildrenByFolder(int cloudId, String cloudName, String folderPath, Device device, boolean restoreDeletedFile) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List<BackUpImage> backupImageList = this.getAggregatedBackupImages(cloudId, mongoTemplate, folderPath, device, restoreDeletedFile);
        backupImageList = this.getFilteredBackupImageListByGrouping(backupImageList, restoreDeletedFile);
        return backupImageList;
    }

    private List<ObjectId> getAggregatedBackupIdsForMail(int cloudId, MongoTemplate mongoTemplate, String folderPath, Device device, boolean restoreDeletedFile) {
        Criteria criteria = new Criteria();
        String deviceUUID = device.getDeviceUUID();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FOLDER).is((Object)false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{SENT_DATE}));
        ArrayList stateStatsList = new ArrayList();
        List result = mongoTemplate.find(query, BackUpImage.class, device.getDestCollection());
        stateStatsList.addAll(result);
        ArrayList<ObjectId> listOfObjectIds = new ArrayList<ObjectId>();
        for (BackUpImage dbObject : stateStatsList) {
            String fileName = dbObject.getFileName();
            String devicePath = dbObject.getDevicePath();
            Date sentDate = dbObject.getSentDate();
            this.logger.debug("  sentDate get id .... " + dbObject + "fileName..." + fileName);
            BackUpImage backUpImage = this.getBackUpImageForMail(cloudId, device, mongoTemplate, fileName, devicePath, sentDate);
            if (backUpImage == null) continue;
            listOfObjectIds.add(backUpImage.getId());
        }
        return listOfObjectIds;
    }

    private List<ObjectId> getAggregatedBackupIds(int cloudId, MongoTemplate mongoTemplate, String folderPath, Device device, boolean restoreDeletedFile) {
        Criteria criteria = new Criteria();
        String deviceUUID = device.getDeviceUUID();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        ArrayList stateStatsList = new ArrayList();
        for (String string : bkpCollectionList) {
            List result = mongoTemplate.find(query, BackUpImage.class, string);
            stateStatsList.addAll(result);
        }
        ArrayList<ObjectId> listOfObjectIds = new ArrayList<ObjectId>();
        for (BackUpImage dbObject : stateStatsList) {
            Long lastServerModifiedTime;
            String devicePath;
            String fileName = dbObject.getFileName();
            BackUpImage backUpImage = this.getBackUpImageForFile(cloudId, device, mongoTemplate, fileName, devicePath = dbObject.getDevicePath(), lastServerModifiedTime = Long.valueOf(dbObject.getLastServerModifiedTime()));
            if (backUpImage == null) continue;
            listOfObjectIds.add(backUpImage.getId());
        }
        if (this.isDeviceQueryCheckEnabled(cloudId)) {
            this.logger.debug("INSIDE getAggregatedBackupIds for device query...................");
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true)});
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
            TypedAggregation typedAggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
            ArrayList stateStatsListForDevice = new ArrayList();
            for (String dest : bkpCollectionList) {
                AggregationResults resultForDevice = mongoTemplate.aggregate(typedAggregation, dest, Document.class);
                List list = resultForDevice.getMappedResults();
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                stateStatsListForDevice.addAll(list);
            }
            for (Document dbObject : stateStatsListForDevice) {
                Long lastServerModifiedTime;
                String devicePath;
                String fileName = dbObject.get((Object)FILE_NAME).toString();
                BackUpImage backUpImage = this.getBackUpImageForFile(cloudId, device, mongoTemplate, fileName, devicePath = dbObject.get((Object)DEVICE_PATH).toString(), lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME));
                if (backUpImage == null) continue;
                listOfObjectIds.add(backUpImage.getId());
            }
        }
        return listOfObjectIds;
    }

    private List<BackUpImage> getAggregatedBackupImages(int cloudId, MongoTemplate mongoTemplate, String folderPath, Device device, boolean restoreDeletedFile) {
        this.logger.debug("get folder list for agent..." + folderPath);
        Criteria criteria = new Criteria();
        String deviceUUID = device.getDeviceUUID();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        ArrayList<BackUpImage> stateStatsList = new ArrayList<BackUpImage>();
        for (String dest : bkpCollectionList) {
            List result = mongoTemplate.find(query, BackUpImage.class, dest);
            this.logger.debug("after folder list for agent..." + folderPath);
            stateStatsList.addAll(result);
        }
        return stateStatsList;
    }

    @Override
    public List<BackUpImage> getBaseChildrenByDevice(int cloudId, String cloudName, Device device, boolean isrestoreDeletedFile) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List<ObjectId> listOfBackupIds = this.getAggregatedBackupIdsForRoot(cloudId, mongoTemplate, device, isrestoreDeletedFile);
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        List<BackUpImage> backupList = new ArrayList<BackUpImage>();
        for (String dest : bkpCollectionList) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
            org.springframework.data.mongodb.core.query.Query query1 = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            List list = mongoTemplate.find(query1, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backupList.addAll(list);
        }
        this.logger.debug("@@@before filtering backup list ........... " + backupList.size());
        backupList = this.getFilteredListForDevice(backupList, device);
        if (this.isDeviceQueryCheckEnabled(cloudId)) {
            this.logger.debug("@@@Before getFilteredListForDevice........... " + backupList.size());
            backupList = this.getFilteredBackupImageListByGrouping(backupList, isrestoreDeletedFile);
            this.logger.debug("@@@After getFilteredListForDevice........... " + backupList.size());
        }
        backupList = this.getFilteredBackupImageListByGrouping(backupList, isrestoreDeletedFile);
        return backupList;
    }

    @Override
    public List<BackUpImage> getBaseChildrenByDeviceandTimeStamp(int cloudId, String cloudName, Device device, String serverModifiedTime) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        long modifiedTime = Long.parseLong(serverModifiedTime);
        List<ObjectId> listOfBackupIds = this.getAggregatedBackupIdsForRoot(cloudId, mongoTemplate, device, true);
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        List<BackUpImage> backupList = new ArrayList<BackUpImage>();
        for (String dest : bkpCollectionList) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
            org.springframework.data.mongodb.core.query.Query query1 = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            List list = mongoTemplate.find(query1, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            for (BackUpImage backUpImage : list) {
                if (backUpImage.getLastServerModifiedTime() > modifiedTime) continue;
                backupList.add(backUpImage);
            }
        }
        if (!CollectionUtils.isEmpty(backupList)) {
            this.logger.debug("@@@before filtering backup list ........... " + backupList.size());
            backupList = this.getFilteredListForDevice(backupList, device);
            if (this.isDeviceQueryCheckEnabled(cloudId)) {
                this.logger.debug("@@@Before getFilteredListForDevice........... " + backupList.size());
                backupList = this.getFilteredBackupImageListByGrouping(backupList, true);
                this.logger.debug("@@@After getFilteredListForDevice........... " + backupList.size());
            }
            backupList = this.getFilteredBackupImageListByGrouping(backupList, true);
            return backupList;
        }
        return new ArrayList<BackUpImage>();
    }

    @Override
    public List<BackUpImage> getChildrenByFolderandModifiedTimeStampForAgent(int cloudId, String cloudName, String folderPath, Device device, boolean isExternalStorage, String serverModifiedTime) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long modifiedTimeStamp = Long.parseLong(serverModifiedTime);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List<BackUpImage> backupList = new ArrayList<BackUpImage>();
        List<ObjectId> listOfBackupIds = this.getAggregatedBackupIdsForAgentRestore(cloudId, mongoTemplate, folderPath, device, isExternalStorage, true);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
        org.springframework.data.mongodb.core.query.Query query1 = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query1.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            List list = mongoTemplate.find(query1, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            for (BackUpImage backUpImage : list) {
                if (backUpImage.getLastServerModifiedTime() > modifiedTimeStamp) continue;
                backupList.add(backUpImage);
            }
        }
        if (!CollectionUtils.isEmpty(backupList)) {
            backupList = this.getFilteredBackupImageListByGrouping(backupList, true);
            return backupList;
        }
        return new ArrayList<BackUpImage>();
    }

    @Override
    public List<BackUpImage> getRestBackupFilesForGivenPathfromBackupImage(int cloudId, String cloudName, String folderPath, Device device, boolean isExternalStorage, String serverModifiedTime, boolean restoreDeletedFiles) {
        List<Object> list = new ArrayList();
        ArrayList<BackUpImage> bkpImages = new ArrayList<BackUpImage>();
        long modifiedTime = 0L;
        if (!org.springframework.util.StringUtils.isEmpty((Object)serverModifiedTime)) {
            modifiedTime = Long.parseLong(serverModifiedTime);
        }
        this.logger.debug("File list based on time stamp .................... " + modifiedTime);
        try {
            this.logger.debug("RESTORE-QUERY ..getBackupFilesForGivenPathfromBackupImage..........");
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            List<String> queryTablesList = this.getBackupCollectionList(device);
            for (String string : queryTablesList) {
                List results = mongoTemplate.find(query, BackUpImage.class, string);
                if (CollectionUtils.isEmpty((Collection)results)) continue;
                list.addAll(results);
            }
            if (modifiedTime != 0L) {
                if (!CollectionUtils.isEmpty(list)) {
                    for (BackUpImage backUpImage : list) {
                        if (backUpImage.getLastServerModifiedTime() > modifiedTime) continue;
                        bkpImages.add(backUpImage);
                    }
                }
            } else {
                bkpImages.addAll(list);
            }
            this.logger.debug("....count of list..." + list.size());
            list = this.getFilteredLatestVersionBackupImageList(bkpImages, restoreDeletedFiles);
            this.logger.debug("....count of list after ..." + list.size());
            this.logger.error("##End getBackupFilesForGivenPathfromBackupImage ..........");
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(" Exception while getting filefrom backupimage:" + e.getMessage());
            return null;
        }
        return list;
    }

    private List<ObjectId> getAggregatedBackupIdsForRoot(int cloudId, MongoTemplate mongoTemplate, Device device, boolean restoreDeletedFiles) {
        Criteria criteria = new Criteria();
        String deviceUUID = device.getDeviceUUID();
        this.logger.debug("----------ID-----------*************************8" + device.getDeviceName());
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).exists(false)});
        ArrayList resultList = new ArrayList();
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String string : bkpCollectionList) {
            TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, LAST_SERVER_MODIFIED_TIME})});
            AggregationResults result = mongoTemplate.aggregate(aggregation, string, Document.class);
            List stateStatsList = result.getMappedResults();
            if (CollectionUtils.isEmpty((Collection)stateStatsList)) continue;
            resultList.addAll(stateStatsList);
        }
        ArrayList<ObjectId> listOfObjectIds = new ArrayList<ObjectId>();
        this.logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^" + resultList.size());
        for (Document dbObject : resultList) {
            String fileName = dbObject.get((Object)"_id").toString();
            this.logger.debug("555555555%%%%%%%%%%%%%%%%" + fileName);
            Long lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME);
            BackUpImage backUpImage = this.getBackUpImageForFileForRoot(cloudId, mongoTemplate, fileName, device, lastServerModifiedTime);
            if (backUpImage == null) continue;
            listOfObjectIds.add(backUpImage.getId());
            this.logger.debug("----------ID------------" + backUpImage.getId());
        }
        if (this.isDeviceQueryCheckEnabled(cloudId)) {
            this.logger.debug("Inside device query.......");
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).exists(false)});
            TypedAggregation typedAggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, LAST_SERVER_MODIFIED_TIME})});
            ArrayList stateStatsListForDeviceUUID = new ArrayList();
            for (String dest : bkpCollectionList) {
                AggregationResults resultForDeviceUUID = mongoTemplate.aggregate(typedAggregation, dest, Document.class);
                List results = resultForDeviceUUID.getMappedResults();
                if (CollectionUtils.isEmpty((Collection)results)) continue;
                stateStatsListForDeviceUUID.addAll(results);
            }
            for (Document dbObject : stateStatsListForDeviceUUID) {
                String fileName = dbObject.get((Object)"_id").toString();
                this.logger.debug("555555555%%%%%%%%%%%%%%%%" + fileName);
                Long lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME);
                BackUpImage backUpImage = this.getBackUpImageForFileForRoot(cloudId, mongoTemplate, fileName, device, lastServerModifiedTime);
                if (backUpImage == null) continue;
                listOfObjectIds.add(backUpImage.getId());
            }
        }
        return listOfObjectIds;
    }

    private List<ObjectId> getAggregatedBackupIdsForRoot(int cloudId, MongoTemplate mongoTemplate, Device device, int skipValue, int recordsCount, boolean isrestoreDeletedFile) {
        Criteria criteria = new Criteria();
        String deviceUUID = device.getDeviceUUID();
        this.logger.debug("----------ID-----------*************************8" + device.getDeviceName());
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).exists(false)});
        ArrayList resultList = new ArrayList();
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String string : bkpCollectionList) {
            TypedAggregation aggregation = null;
            aggregation = skipValue != 0 ? Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, LAST_SERVER_MODIFIED_TIME}), Aggregation.skip((long)((long)skipValue * (long)recordsCount)), Aggregation.limit((long)recordsCount)}) : Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, LAST_SERVER_MODIFIED_TIME}), Aggregation.limit((long)recordsCount)});
            AggregationResults result = mongoTemplate.aggregate(aggregation, string, Document.class);
            List stateStatsList = result.getMappedResults();
            if (CollectionUtils.isEmpty((Collection)stateStatsList)) continue;
            resultList.addAll(stateStatsList);
        }
        ArrayList<ObjectId> listOfObjectIds = new ArrayList<ObjectId>();
        this.logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^" + resultList.size());
        for (Document dbObject : resultList) {
            String fileName = dbObject.get((Object)"_id").toString();
            this.logger.debug("555555555%%%%%%%%%%%%%%%%" + fileName);
            Long lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME);
            BackUpImage backUpImage = this.getBackUpImageForFileForRoot(cloudId, mongoTemplate, fileName, device, lastServerModifiedTime);
            if (backUpImage == null) continue;
            listOfObjectIds.add(backUpImage.getId());
            this.logger.debug("----------ID------------" + backUpImage.getId());
        }
        if (this.isDeviceQueryCheckEnabled(cloudId)) {
            this.logger.debug("Inside device query.......");
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).exists(false)});
            TypedAggregation typedAggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, LAST_SERVER_MODIFIED_TIME})});
            ArrayList stateStatsListForDeviceUUID = new ArrayList();
            for (String dest : bkpCollectionList) {
                AggregationResults resultForDeviceUUID = mongoTemplate.aggregate(typedAggregation, dest, Document.class);
                List results = resultForDeviceUUID.getMappedResults();
                if (CollectionUtils.isEmpty((Collection)results)) continue;
                stateStatsListForDeviceUUID.addAll(results);
            }
            for (Document dbObject : stateStatsListForDeviceUUID) {
                String fileName = dbObject.get((Object)"_id").toString();
                this.logger.debug("555555555%%%%%%%%%%%%%%%%" + fileName);
                Long lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME);
                BackUpImage backUpImage = this.getBackUpImageForFileForRoot(cloudId, mongoTemplate, fileName, device, lastServerModifiedTime);
                if (backUpImage == null) continue;
                listOfObjectIds.add(backUpImage.getId());
            }
        }
        return listOfObjectIds;
    }

    private List<String> getBackupCollectionList(Device device) {
        ArrayList<String> bkpCollectionList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)device.getDestCollection())) {
            bkpCollectionList.add(device.getDestCollection());
        }
        return bkpCollectionList;
    }

    private List<BackUpImage> getFilteredListForDevice(List<BackUpImage> backupList, Device device) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backupList) {
            if (backUpImage == null) continue;
            if (backUpImage.getDevice() == null) {
                if (!backUpImage.getDeviceUUID().equals(device.getDeviceUUID())) continue;
                filteredBackUpImages.add(backUpImage);
                continue;
            }
            if (!backUpImage.getDevice().getId().equals((Object)device.getId())) continue;
            filteredBackUpImages.add(backUpImage);
        }
        return filteredBackUpImages;
    }

    private List<BackUpImage> getAllLatestBackup(MongoOperations mongoTemplate, List<ObjectId> listOfBackupIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    private Device getDeviceForId(int cloudId, ObjectId deviceId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)deviceId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Device device = (Device)mongoTemplate.findOne(query, Device.class);
        if (device == null) {
            this.logger.debug(" device does not exists ........... ");
        }
        return device;
    }

    @Override
    public List<BackUpImage> getVersions(int cloudId, String cloudName, String fileName, String devicePath, Device device, boolean readPreference) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<BackUpImage> versions = this.getAggregatedBackupImagesForVersions(mongoTemplate, devicePath, fileName, device);
        return versions;
    }

    private List<BackUpImage> getAggregatedBackupImagesForVersions(MongoTemplate mongoTemplate, String folderPath, String fileName, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        return this.getBackupIMagesForVersions(mongoTemplate, device, (TypedAggregation<BackUpImage>)aggregation);
    }

    private List<BackUpImage> getBackupIMagesForVersions(MongoTemplate mongoTemplate, Device device, TypedAggregation<BackUpImage> aggregation) {
        ArrayList stateStatsList = new ArrayList();
        List<BackUpImage> backupImages = new ArrayList<BackUpImage>();
        List<String> queryTablesList = this.getBackupCollectionList(device);
        try {
            for (String dest : queryTablesList) {
                this.logger.debug("Before the aggregation....");
                AggregationResults result = mongoTemplate.aggregate(aggregation, dest, Document.class);
                this.logger.debug("After the aggregation......");
                List resultList = result.getMappedResults();
                if (CollectionUtils.isEmpty((Collection)resultList)) continue;
                stateStatsList.addAll(resultList);
            }
            this.logger.debug("result set:" + stateStatsList);
            for (Document dbObject : stateStatsList) {
                Long lastServerModifiedTime;
                String devicePath;
                String fileName = dbObject.get((Object)FILE_NAME).toString();
                BackUpImage backUpImage = this.getBackUpImageForFile(1, device, mongoTemplate, fileName, devicePath = dbObject.get((Object)DEVICE_PATH).toString(), lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME));
                if (backUpImage == null) continue;
                backupImages.add(backUpImage);
            }
            backupImages = this.getFilteredBackupImageListForVersions(backupImages);
        }
        catch (Exception e) {
            this.logger.error("exception in getting the versions..", (Throwable)e);
        }
        return backupImages;
    }

    @Override
    public List<BackUpImage> getVersionsFilesToDelete(int cloudId, String cloudName, String fileName, String devicePath, Device device) {
        String deviceUUID = device.getDeviceUUID();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        ArrayList<BackUpImage> backUpImages = new ArrayList<BackUpImage>();
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            List list = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backUpImages.addAll(list);
        }
        this.logger.debug("size before getFilteredBackupImageListForVersions " + backUpImages.size());
        return backUpImages;
    }

    @Override
    public List<BackUpImage> getAllVersionsOfChildren(int cloudId, String cloudName, String devicePath, ObjectId deviceId) {
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(devicePath);
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), pathLikeCriteria});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        List bkplist = mongoTemplate.find(query, BackUpImage.class);
        if (this.isDeviceQueryCheckEnabled(cloudId)) {
            this.logger.debug("Inside getAllVersionsOfChildren and device query");
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{pathLikeCriteria});
            query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            bkplist.addAll(mongoTemplate.find(query, BackUpImage.class));
        }
        return bkplist;
    }

    @Override
    public List<BackUpImage> getLatestFiles(int cloudId, String cloudName, ObjectId deviceId, int isExternalStorage) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)PRESENT).is((Object)true)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME}), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        List<BackUpImage> resList = this.getBackupImagesForRestore(cloudId, (TypedAggregation<BackUpImage>)aggregation, device, null);
        resList = isExternalStorage == 1 ? this.getFilteredBackupImageListOnlyStoragePlaceExists(resList) : this.getFilteredBackupImageList(resList);
        return resList;
    }

    @Override
    public List<BackUpImage> getLatestFiles(int cloudId, String cloudName, ObjectId deviceId, String devicePath, String fileName, boolean isExtrnalStorage) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        this.logger.error("##Start Trying to restore using user .........." + devicePath);
        ArrayList<Long> consolidatedTimeStamps = new ArrayList<Long>();
        Criteria pathLikeCriteria = new Criteria();
        pathLikeCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
        List<Long> listOfObjectIds = this.getLatestTimeStampForDevicePath(cloudId, device, pathLikeCriteria);
        consolidatedTimeStamps.addAll(listOfObjectIds);
        this.logger.error("##End Trying to get devicepath list andoperator .........." + listOfObjectIds.size());
        pathLikeCriteria = new Criteria();
        pathLikeCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).regex("^" + devicePath + "/", "i")});
        listOfObjectIds = this.getLatestTimeStampForDevicePath(cloudId, device, pathLikeCriteria);
        consolidatedTimeStamps.addAll(listOfObjectIds);
        this.logger.error("##End Trying to get devicepath regex list  .........." + listOfObjectIds.size());
        List<BackUpImage> resList = this.getBackupImagesForRestoreForLatestModifiedTime(cloudId, consolidatedTimeStamps, device);
        if (isExtrnalStorage) {
            resList = this.getFilteredBackupImageListForStoragePlaceExists(resList);
        }
        return resList;
    }

    private List<BackUpImage> getBackupImagesForRestoreForLatestModifiedTime(int cloudId, List<Long> listOfObjectIds, Device device) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MongoCollection collection = mongoTemplate.getCollection(BACKUP);
        Bson searchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)LAST_SERVER_MODIFIED_TIME, (Object)new Document("$in", listOfObjectIds)), Filters.eq((String)DEVICE_ID, (Object)device.getId())});
        ArrayList<BackUpImage> bkpList = new ArrayList<BackUpImage>();
        FindIterable find = collection.find(searchQuery);
        MongoCursor cursor = find.iterator();
        if (cursor.hasNext()) {
            Document next = (Document)cursor.next();
            BackUpImage backUpImage = (BackUpImage)mongoTemplate.getConverter().read(BackUpImage.class, (Object)next);
            bkpList.add(backUpImage);
        }
        this.logger.debug("Converted final list ................... " + bkpList.size());
        cursor.close();
        return bkpList;
    }

    private List<Long> getLatestTimeStampForDevicePath(int cloudId, Device device, Criteria pathLikeCriteria) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), pathLikeCriteria, Criteria.where((String)PRESENT).is((Object)true)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        AggregationResults result = mongoTemplate.aggregate(aggregation, Document.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<Long> listOfObjectIds = new ArrayList<Long>();
        for (Document dbObject : stateStatsList) {
            listOfObjectIds.add((Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME));
        }
        return listOfObjectIds;
    }

    private List<BackUpImage> getBackupImagesForRestore(int cloudId, TypedAggregation<BackUpImage> aggregation, Device device, Criteria pathLikeCriteria) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.error("$$Before Aggregation .......");
        AggregationResults result = mongoTemplate.aggregate(aggregation, Document.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<Long> listOfObjectIds = new ArrayList<Long>();
        for (Document dbObject : stateStatsList) {
            listOfObjectIds.add((Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME));
        }
        this.logger.error("$$End of Aggregation ......." + listOfObjectIds.size());
        Criteria criteria = new Criteria();
        org.springframework.data.mongodb.core.query.Query query = null;
        if (device != null && pathLikeCriteria != null) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).in(listOfObjectIds)});
            query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        } else if (device != null) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)LAST_SERVER_MODIFIED_TIME).in(listOfObjectIds), Criteria.where((String)DEVICE).is((Object)device)});
            query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        } else if (pathLikeCriteria == null) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)LAST_SERVER_MODIFIED_TIME).in(listOfObjectIds)});
            query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        }
        mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getLatestFiles(int cloudId, String cloudName, Device device, boolean present) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME}), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        List<BackUpImage> resList = this.getBackupImagesForRestore(cloudId, (TypedAggregation<BackUpImage>)aggregation, device, null);
        resList = this.getFilteredBackupImageList(resList, present);
        return resList;
    }

    @Override
    public List<BackUpImage> getAllLatestFiles(int cloudId, String cloudName, ObjectId deviceId) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME}), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        List<BackUpImage> list = this.getBackupImagesForRestore(cloudId, (TypedAggregation<BackUpImage>)aggregation, device, null);
        list = this.getFilteredBackupImageList(list);
        return list;
    }

    @Override
    public List<BackUpImage> getBaseFolders(int cloudId, String cloudName, ObjectId deviceId) {
        return new ArrayList<BackUpImage>();
    }

    @Override
    public Long getTotalSizeUsed(int cloudId, String cloudName) {
        Long totalSizeUsed = 0L;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List deviceBackupOverViewList = mongoTemplate.findAll(DeviceBackupOverView.class);
        for (DeviceBackupOverView deviceBackupOverView : deviceBackupOverViewList) {
            if (deviceBackupOverView == null) continue;
            totalSizeUsed = totalSizeUsed + deviceBackupOverView.getStorageUtilized();
        }
        this.logger.debug(" TOTAL Size in cloud ............... " + totalSizeUsed);
        return totalSizeUsed;
    }

    @Override
    public void deleteRevision(int cloudId, String cloudName, BackUpImage backUpImage) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"backUpImage.$id").is((Object)backUpImage.getId())});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.findAndRemove(query, ExternalStorageFileImage.class);
        criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backUpImage.getId())});
        query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(1);
        this.logger.debug(" %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   " + backUpImage.getId());
        paracloudMongoTemplate.remove((Object)backUpImage);
    }

    @Override
    public List<BackUpImage> getAllOlderRevisionsExcludingCurrentRevision(int cloudId, String cloudName, String deletedStatus, long timestamp) {
        String sql = "select r1.* from BACKUP r1 where r1.REVISION_ID NOT IN (select r.REVISION_ID from BACKUP r INNER JOIN (select FILE_NAME,DEVICE_PATH,REVISION_STATUS, max(SERVER_TIMESTAMP) as MAX_SERVER_TIMESTAMP from BACKUP group by FILE_NAME,DEVICE_PATH) rmax on r.FILE_NAME=rmax.FILE_NAME and r.DEVICE_PATH=rmax.DEVICE_PATH  and r.SERVER_TIMESTAMP = rmax.MAX_SERVER_TIMESTAMP ) and r1.SERVER_TIMESTAMP <:timestamp ;";
        SQLQuery query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createSQLQuery(sql).addEntity(BackUpImage.class);
        query.setParameter("timestamp", (Object)timestamp);
        return query.list();
    }

    @Override
    public List<Device> getAllBackedUpDevice(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        List list = mongoTemplate.find(query, Device.class);
        ArrayList<Device> existingDeviceList = new ArrayList<Device>();
        List deviceBackupOverViews = mongoTemplate.findAll(DeviceBackupOverView.class);
        HashMap<String, DeviceBackupOverView> overViewMap = new HashMap<String, DeviceBackupOverView>();
        for (DeviceBackupOverView overView : deviceBackupOverViews) {
            overViewMap.put(overView.getDeviceUUID(), overView);
        }
        for (Device device : list) {
            DeviceBackupOverView bkpOverView = (DeviceBackupOverView)overViewMap.get(device.getDeviceUUID());
            if (bkpOverView == null) continue;
            existingDeviceList.add(device);
        }
        return existingDeviceList;
    }

    @Override
    public List<BackUpImage> getLatestFiles(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME}), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        List<BackUpImage> resList = this.getBackupImagesForRestore(cloudId, (TypedAggregation<BackUpImage>)aggregation, null, null);
        resList = this.getFilteredBackupImageList(resList);
        return resList;
    }

    @Override
    public List<BackUpImage> getAllLatestFiles(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME}), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        List<BackUpImage> resList = this.getBackupImagesForRestore(cloudId, (TypedAggregation<BackUpImage>)aggregation, null, null);
        resList = this.getFilteredBackupImageList(resList);
        return resList;
    }

    @Override
    public List<Object[]> getAllRevisionsStartingFrom(int cloudId, String cloudName, List<String> deviceUUIDs, List<String> fileNames, List<String> devicePaths, boolean present, int versionOffset) {
        return new ArrayList<Object[]>();
    }

    @Override
    public Long getCountOfAllLatestRevisions(int cloudId, String cloudName, String status, long revisionCount) {
        String sql = "select count(*) from BACKUP b INNER JOIN (select REVISION_ID,FILE_NAME, DEVICE_PATH, DEVICE_FK, max(SERVER_TIMESTAMP) as MAX_SERVER_TIMESTAMP,count(REVISION_ID) as REVISION_COUNT from BACKUP where REVISION_STATUS!=:status group by FILE_NAME,DEVICE_PATH,DEVICE_FK ) bmax on b.REVISION_ID =bmax.REVISION_ID  and b.SERVER_TIMESTAMP = bmax.MAX_SERVER_TIMESTAMP  and bmax.REVISION_COUNT>:revisionCount";
        SQLQuery query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createSQLQuery(sql);
        query.setParameter(STATUS, (Object)status);
        query.setParameter("revisionCount", (Object)revisionCount);
        return ((BigInteger)query.uniqueResult()).longValue();
    }

    @Override
    public List<BackUpImage> getAllLatestFiles(int cloudId, String cloudName, String status, long revisionCount, int offset, int limit) {
        String sql = "select b.* from BACKUP b INNER JOIN (select REVISION_ID,FILE_NAME, DEVICE_PATH, DEVICE_FK, max(SERVER_TIMESTAMP) as MAX_SERVER_TIMESTAMP,count(REVISION_ID) as REVISION_COUNT from BACKUP where REVISION_STATUS!=:status group by FILE_NAME,DEVICE_PATH,DEVICE_FK ) bmax on b.SERVER_TIMESTAMP = bmax.MAX_SERVER_TIMESTAMP and bmax.REVISION_COUNT>:revisionCount";
        SQLQuery query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createSQLQuery(sql).addEntity(BackUpImage.class);
        query.setParameter(STATUS, (Object)status);
        query.setParameter("revisionCount", (Object)revisionCount);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.list();
    }

    @Override
    public List<BackUpImage> getAllBackups(int cloudId, String cloudName, List<Long> backupIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(backupIds)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getVersionsForNullPath(int cloudId, String cloudName, String fileName, ObjectId deviceId) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is(null), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        String destCollection = device.getDestCollection();
        return mongoTemplate.find(query, BackUpImage.class, destCollection);
    }

    @Override
    public long getCountOfBackupDevices(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false), Criteria.where((String)"deviceType").ne((Object)"ONEDRIVE")});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, DeviceBackupOverView.class);
    }

    @Override
    public Integer validateBackupDevice(int cloudId, String cloudName, String deviceUUID) {
        DeviceBackupOverView deviceBackupOverView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
        if (deviceBackupOverView != null) {
            return new Integer(1);
        }
        return null;
    }

    private DeviceBackupOverView getDeviceBkpOverviewForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (DeviceBackupOverView)mongoTemplate.findOne(query, DeviceBackupOverView.class);
    }

    @Override
    public BackUpImage getBackUpImageForFileWithNullPath(int cloudId, String cloudName, String fileName, String deviceUUID) {
        Device deviceObj = this.getDeviceForDeviceUUID(cloudId, deviceUUID);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)deviceObj), Criteria.where((String)DEVICE_PATH).is(null), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getAllFilesForDeviceId(int cloudId, String cloudName, ObjectId deviceId) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<BackUpImage> backupList = mongoTemplate.find(query, BackUpImage.class);
        backupList = this.getFilteredBackupImageList(backupList);
        return backupList;
    }

    @Override
    public List<BackUpImage> getAllFilesForExternalStorageUpload(int cloudId, String cloudName, ObjectId deviceId, List<Long> alreadyBackedUpIds) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (!CollectionUtils.isEmpty(alreadyBackedUpIds)) {
            Criteria criteria3 = Criteria.where((String)"id").nin(alreadyBackedUpIds);
            list.add(criteria3);
        }
        Criteria criteria4 = Criteria.where((String)DEVICE).is((Object)device);
        list.add(criteria4);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<BackUpImage> backupList = mongoTemplate.find(query, BackUpImage.class);
        backupList = this.getFilteredBackupImageListWithoutFolders(backupList);
        return backupList;
    }

    @Override
    public List<BackUpImage> getBackedUpFolders(int cloudId, String cloudName, ObjectId deviceId) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<BackUpImage> backupList = mongoTemplate.find(query, BackUpImage.class);
        backupList = this.getFilteredBackupImageListWithoutFolders(backupList);
        return backupList;
    }

    @Override
    public List<BackUpImage> getAllFilesForUserName(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i")});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(500);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    public List<String> getAllActiveUsers(int cloudId, List<String> existingUserNames) {
        Criteria criteria = new Criteria();
        if (!CollectionUtils.isEmpty(existingUserNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)USER_NAME).nin(existingUserNames)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, User.class);
        ArrayList<String> userNames = new ArrayList<String>();
        for (User user : list) {
            userNames.add(user.getUserName());
        }
        return userNames;
    }

    public List<String> getAllActiveUsers(int cloudId, List<String> existingUserNames, int skipValue) {
        Criteria criteria = new Criteria();
        if (!CollectionUtils.isEmpty(existingUserNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)USER_NAME).nin(existingUserNames)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, User.class);
        ArrayList<String> userNames = new ArrayList<String>();
        for (User user : list) {
            userNames.add(user.getUserName());
        }
        return userNames;
    }

    @Override
    public List<Object[]> getDeviceHistoryElement(int cloudId, String cloudName, String userName, String deviceName) {
        Object[] arr;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria criteria2 = Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i");
            list.add(criteria2);
        }
        if (!StringUtils.isEmpty((String)deviceName)) {
            List<ObjectId> idList = this.getDeviceIDsForName(cloudId, deviceName);
            Criteria criteria3 = Criteria.where((String)DEVICE_ID).in(idList);
            list.add(criteria3);
        }
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE}).sum("size").as("size"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME, DEVICE}), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE, PRESENT}), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, Document.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<String> existingUserNames = new ArrayList<String>();
        ArrayList<ObjectId> existingDeviceIds = new ArrayList<ObjectId>();
        for (Object dbObject : stateStatsList) {
            boolean isPresent = false;
            if (dbObject.get((Object)PRESENT) != null) {
                isPresent = Boolean.parseBoolean(dbObject.get((Object)PRESENT).toString());
            }
            if (!isPresent) continue;
            arr = new Object[3];
            arr[0] = dbObject.get((Object)"size");
            String userName2 = dbObject.get((Object)USER_NAME).toString();
            arr[2] = userName2;
            DBRef dbRef = (DBRef)dbObject.get((Object)DEVICE);
            String deviceId = dbRef.getId().toString();
            Device device = this.getDeviceForId(cloudId, deviceId);
            String deviceName2 = device.getDeviceName();
            arr[1] = deviceName2;
            if (StringUtils.isEmpty((String)deviceName) && StringUtils.isEmpty((String)userName)) {
                existingDeviceIds.add(device.getId());
                existingUserNames.add(userName2);
            }
            list1.add(arr);
        }
        if (StringUtils.isEmpty((String)deviceName) && StringUtils.isEmpty((String)userName)) {
            List<String> userNames = this.getAllActiveUsers(cloudId, existingUserNames);
            for (String userNameVal : userNames) {
                arr = new Object[3];
                arr[0] = new Long(0L);
                arr[2] = userNameVal;
                arr[1] = "";
                list1.add(arr);
            }
            List<Device> devices = this.getActiveDeviceNames(cloudId, existingDeviceIds);
            for (Device deviceNameVal : devices) {
                Object[] arr2 = new Object[3];
                arr2[0] = new Long(0L);
                arr2[2] = deviceNameVal.getUserName();
                arr2[1] = deviceNameVal.getDeviceName();
                list1.add(arr2);
            }
        }
        return list1;
    }

    @Override
    public List<Object[]> getDeviceHistoryElement(int cloudId, String cloudName, String deviceName) {
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((String)deviceName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).regex("^" + deviceName + "$", "i"), Criteria.where((String)BLOCKED).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List deviceList = mongoTemplate.find(query, Device.class);
        for (Device device : deviceList) {
            if (device == null || StringUtils.isEmpty((String)device.getUserName())) continue;
            Object[] arr = new Object[4];
            arr[0] = new Long(0L);
            arr[2] = device.getUserName();
            arr[1] = device.getDeviceName();
            arr[3] = device.getDeviceCreatedDate();
            list1.add(arr);
        }
        return list1;
    }

    @Override
    public List<Object[]> getUserHistoryElement(int cloudId, String cloudName, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria criteria2 = Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i");
            list.add(criteria2);
        }
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE, PRESENT}).sum("size").as("size"), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE, PRESENT})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, Document.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<String> existingUserNames = new ArrayList<String>();
        for (Document dbObject : stateStatsList) {
            Object[] arr = new Object[4];
            boolean isPresent = false;
            this.logger.debug("present object.." + dbObject.get((Object)PRESENT).toString());
            if (dbObject.get((Object)PRESENT) != null) {
                isPresent = Boolean.parseBoolean(dbObject.get((Object)PRESENT).toString());
            }
            if (!isPresent) continue;
            arr[0] = dbObject.get((Object)"size");
            String userName2 = dbObject.get((Object)USER_NAME).toString();
            arr[2] = userName2;
            DBRef dbRef = (DBRef)dbObject.get((Object)DEVICE);
            if (dbRef == null) continue;
            String deviceId = dbRef.getId().toString();
            Device device = this.getDeviceForId(cloudId, deviceId);
            User user = this.getUserInfoByName(cloudId, cloudName, userName2);
            if (user == null || device == null || device.isBlocked()) continue;
            String deviceName2 = device.getDeviceName();
            arr[1] = deviceName2;
            if (StringUtils.isEmpty((String)userName)) {
                existingUserNames.add(userName2);
            }
            arr[3] = device.getDeviceCreatedDate();
            list1.add(arr);
        }
        if (StringUtils.isEmpty((String)userName)) {
            List<String> userNames = this.getAllActiveUsers(cloudId, existingUserNames);
            for (String userNameVal : userNames) {
                Object[] arr = new Object[4];
                arr[0] = new Long(0L);
                arr[2] = userNameVal;
                arr[1] = "";
                arr[3] = "";
                list1.add(arr);
            }
        }
        return list1;
    }

    @Override
    public List<Object[]> getUserHistoryElement(int cloudId, String cloudName, String userName, Map<String, User> userMap, Map<String, Device> deviceIdMap) {
        Object[] arr;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = new Criteria();
        ArrayList list = new ArrayList();
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE, PRESENT}).sum("size").as("size"), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE, PRESENT})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, Document.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<String> existingUserNames = new ArrayList<String>();
        for (Document dbObject : stateStatsList) {
            boolean isPresent = false;
            if (dbObject.get((Object)"isPresent") != null) {
                isPresent = Boolean.parseBoolean(dbObject.get((Object)PRESENT).toString());
            }
            if (!isPresent) continue;
            arr = new Object[4];
            arr[0] = dbObject.get((Object)"size");
            String userName2 = dbObject.get((Object)USER_NAME).toString();
            arr[2] = userName2;
            DBRef dbRef = (DBRef)dbObject.get((Object)DEVICE);
            if (dbRef == null) continue;
            String deviceId = dbRef.getId().toString();
            Device device = deviceIdMap.get(deviceId);
            User user = userMap.get(userName2);
            if (user == null || device == null || device.isBlocked()) continue;
            String deviceName2 = device.getDeviceName();
            arr[1] = deviceName2;
            if (StringUtils.isEmpty((String)userName)) {
                existingUserNames.add(userName2);
            }
            arr[3] = device.getDeviceCreatedDate();
            list1.add(arr);
        }
        if (StringUtils.isEmpty((String)userName)) {
            List<String> userNames = this.getAllActiveUsers(cloudId, existingUserNames);
            for (String userNameVal : userNames) {
                arr = new Object[4];
                arr[0] = new Long(0L);
                arr[2] = userNameVal;
                arr[1] = "";
                arr[3] = "";
                list1.add(arr);
            }
        }
        return list1;
    }

    public User getUserInfoByName(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)ACTIVE).is((Object)true)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    private List<Device> getActiveDeviceNames(int cloudId, List<ObjectId> existingIds) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria deviceCriteria = new Criteria();
        if (CollectionUtils.isEmpty(existingIds)) {
            deviceCriteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false)});
        } else {
            deviceCriteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false), Criteria.where((String)"id").nin(existingIds)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)deviceCriteria);
        return mongoTemplate.find(query, Device.class);
    }

    @Override
    public List<Object[]> getTotalSizeUsed(int cloudId, String cloudName, String userName, String deviceName, int skipValue) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)STATUS).ne((Object)DELETED);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        list.add(criteria1);
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria criteria2 = Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i");
            list.add(criteria2);
        }
        if (!StringUtils.isEmpty((String)deviceName)) {
            List<ObjectId> idList = this.getDeviceIDsForName(cloudId, deviceName);
            Criteria criteria3 = Criteria.where((String)DEVICE_ID).in(idList);
            list.add(criteria3);
        }
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE}).sum("size").as("size"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME, DEVICE}), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE}), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME})});
        if (StringUtils.isEmpty((String)deviceName) && StringUtils.isEmpty((String)userName)) {
            aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE}).sum("size").as("size"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME, DEVICE}), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE}), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME}), Aggregation.limit((long)PCHelperConstant.getReportDisplayRecords())});
        }
        if (skipValue != 0 && StringUtils.isEmpty((String)deviceName) && StringUtils.isEmpty((String)userName)) {
            aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE}).sum("size").as("size"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME, DEVICE}), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE}), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME}), Aggregation.skip((int)(skipValue * PCHelperConstant.getReportDisplayRecords())), Aggregation.limit((long)PCHelperConstant.getReportDisplayRecords())});
        }
        AggregationResults result = mongoTemplate.aggregate(aggregation, Document.class);
        List stateStatsList = result.getMappedResults();
        for (Document dbObject : stateStatsList) {
            Object[] arr = new Object[3];
            arr[0] = dbObject.get((Object)"size");
            arr[1] = dbObject.get((Object)USER_NAME);
            DBRef dbRef = (DBRef)dbObject.get((Object)DEVICE);
            String deviceId = dbRef.getId().toString();
            Device device = this.getDeviceForId(cloudId, deviceId);
            if (device == null) continue;
            arr[2] = device.getDeviceName();
            list1.add(arr);
        }
        return list1;
    }

    @Override
    public Long getTotalSizeUsedForUser(int cloudId, String userName) {
        return 0L;
    }

    private Device getDeviceForDeviceId(int cloudId, ObjectId deviceId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)deviceId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Device)mongoTemplate.findOne(query, Device.class);
    }

    @Override
    public void deleteBackupFile(int cloudId, String cloudName, ObjectId backupId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndRemove(query, BackUpImage.class);
    }

    @Override
    public ObjectId getBackupIDForDedupifiedFile(int cloudId, String cloudName, String userName, String md5checksum) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)MD5_CHECK_SUM).is((Object)md5checksum)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            BackUpImage backUpImage = (BackUpImage)list.get(0);
            return backUpImage.getId();
        }
        return null;
    }

    @Override
    public List<BackUpImage> getBackupImageForMd5s(int cloudId, String userName, List<String> md5checksums) {
        return this.getBackupFileForMd5s(cloudId, userName, md5checksums);
    }

    @Override
    public List<KeyValueElement> getBackupImageForDedupifiedFiles(int cloudId, String cloudName, String userName, List<String> md5checksums) {
        List<BackUpImage> list = this.getBackupFileForMd5s(cloudId, userName, md5checksums);
        ArrayList<KeyValueElement> md5AndBackupIds = new ArrayList<KeyValueElement>();
        for (BackUpImage backUpImage : list) {
            if (backUpImage.isFolder()) continue;
            KeyValueElement element = new KeyValueElement();
            element.setKey(backUpImage.getMd5Checksum());
            element.setValue(backUpImage.getId().toString());
            md5AndBackupIds.add(element);
        }
        return md5AndBackupIds;
    }

    private List<BackUpImage> getBackupFileForMd5s(int cloudId, String userName, List<String> md5checksums) {
        this.logger.debug(md5checksums.size() + " @@@@STARTMD5 getBackupFileForMd5s without username  ");
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)MD5_CHECK_SUM).in(md5checksums), Criteria.where((String)STATUS).ne((Object)DELETED)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{MD5_CHECK_SUM}).min(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{MD5_CHECK_SUM, LAST_SERVER_MODIFIED_TIME})});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        AggregationResults result = mongoTemplate.aggregate(aggregation, Document.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<Long> listOfObjectIds = new ArrayList<Long>();
        for (Document dbObject : stateStatsList) {
            listOfObjectIds.add((Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME));
        }
        this.logger.debug("TOTAL deduped files Size ..... " + listOfObjectIds.size());
        criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LAST_SERVER_MODIFIED_TIME).in(listOfObjectIds)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        List list = mongoTemplate.find(query, BackUpImage.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            this.logger.debug(" @@@@ENDMD5 getBackupFileForMd5s without username 0");
        } else {
            this.logger.debug(END_MD5_GET_BACKUP_FILE_FOR_MD5_WITHOUT_USER_NAME + list.size());
        }
        return list;
    }

    @Override
    public List<BackUpImage> getBackupImageForMd5WithUserName(int cloudId, String userName, List<String> md5checksums) {
        this.logger.debug(" @@@@STARTMD5 with username !!!!! ");
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)MD5_CHECK_SUM).in(md5checksums)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class);
        this.logger.debug(" @@@@ENDMD5 with username !!!!! ");
        return list;
    }

    @Override
    public BackUpImage getBackupImageForDeviceUUID(int cloudId, String cloudName, String fileName, String devicePath, String deviceUUID) {
        Device device = this.getDeviceForDeviceUUID(cloudId, deviceUUID);
        this.logger.debug(deviceUUID + "......" + devicePath + "..." + fileName + "....." + device);
        if (device != null) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
            query.limit(1);
            List<String> bkpCollectionList = this.getBackupCollectionList(device);
            for (String dest : bkpCollectionList) {
                MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
                BackUpImage backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest);
                if (backUpImage == null) continue;
                return backUpImage;
            }
        }
        return null;
    }

    private Device getDeviceForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Device)mongoTemplate.findOne(query, Device.class);
    }

    private List<Device> getDeviceForDeviceNameAndUserName(int cloudId, String deviceName, String userName) {
        User user = this.getUserInfoByName(cloudId, "", userName);
        Criteria criteria = new Criteria();
        if (user != null) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).is((Object)deviceName), Criteria.where((String)USER_NAME).is((Object)user.getUserName()), Criteria.where((String)BLOCKED).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).is((Object)deviceName), Criteria.where((String)BLOCKED).is((Object)false)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, Device.class);
    }

    private Device getDeviceForId(int cloudId, String deviceID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)deviceID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Device)mongoTemplate.findOne(query, Device.class);
    }

    @Override
    public long getStorageUsedForDevice(int cloudId, String cloudName, String deviceName, String userName) {
        Long total = 0L;
        List<Device> list = this.getDeviceForDeviceNameAndUserName(cloudId, deviceName, userName);
        for (Device device : list) {
            DeviceBackupOverView backupOverView;
            if (device == null || (backupOverView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID())) == null) continue;
            total = total + backupOverView.getStorageUtilized();
        }
        return total;
    }

    @Override
    public void saveBackupStatistics(int cloudId, String cloudName, BackUpImageStatistics imageStatistics) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)imageStatistics);
    }

    @Override
    public void deleteStatisticsForUser(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i")});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, BackUpImageStatistics.class);
    }

    @Override
    public List<Object[]> getStatisticsForBackup(int cloudId, String cloudName, String userName, String deviceName) {
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria userCriteria = Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i");
            list.add(userCriteria);
        }
        if (!StringUtils.isEmpty((String)deviceName)) {
            Criteria deviceCriteria = Criteria.where((String)DEVICE_NAME).is((Object)deviceName);
            list.add(deviceCriteria);
        }
        Criteria criteria = new Criteria();
        if (!list.isEmpty()) {
            criteria.andOperator(list.toArray(new Criteria[list.size()]));
        }
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImageStatistics.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, FILE_EXTENSION, DEVICE_NAME}).sum("size").as("size").count().as(COUNT), Aggregation.project((String[])new String[]{USER_NAME, FILE_EXTENSION, "size", DEVICE_NAME, COUNT})});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        AggregationResults result = mongoTemplate.aggregate(aggregation, Document.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<Object[]> objectList = new ArrayList<Object[]>();
        for (Document dbObject : stateStatsList) {
            Object[] arr = new Object[]{dbObject.get((Object)USER_NAME), dbObject.get((Object)FILE_EXTENSION), dbObject.get((Object)"size"), dbObject.get((Object)DEVICE_NAME), dbObject.get((Object)COUNT)};
            objectList.add(arr);
        }
        return objectList;
    }

    private List<ObjectId> getDeviceIDsForName(int cloudId, String deviceName) {
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((String)deviceName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).is((Object)deviceName)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List devices = mongoTemplate.find(query, Device.class);
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        for (Device device : devices) {
            objectIds.add(device.getId());
        }
        return objectIds;
    }

    @Override
    public void updateAzureFileStatusinBackupImageTable(int cloudId, String cloudName, ObjectId backupId, String storagePlace) {
        Criteria criteria = Criteria.where((String)"id").is((Object)backupId);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("storagePlace", (Object)storagePlace);
        update.set(LAST_SERVER_MODIFIED_TIME, (Object)System.currentTimeMillis());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, BackUpImage.class);
    }

    private BackUpImage getBackUpImageForFile(int cloudId, Device device, MongoTemplate mongoTemplate, String fileName, String devicePath, Long serverModifiedTime) {
        List list;
        String deviceUUID = device.getDeviceUUID();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).is((Object)serverModifiedTime)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(1);
        ArrayList backUpImageList = new ArrayList();
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            list = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backUpImageList.addAll(list);
        }
        if (this.isDeviceQueryCheckEnabled(cloudId)) {
            this.logger.debug("Inside device query.........");
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).is((Object)serverModifiedTime), Criteria.where((String)DEVICE_UUID).exists(false)});
            query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            query.limit(1);
            for (String dest : bkpCollectionList) {
                list = mongoTemplate.find(query, BackUpImage.class, dest);
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                backUpImageList.addAll(list);
            }
        }
        if (!CollectionUtils.isEmpty(backUpImageList)) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    private BackUpImage getBackUpImageForMail(int cloudId, Device device, MongoTemplate mongoTemplate, String fileName, String devicePath, Date sentDate) {
        String deviceUUID = device.getDeviceUUID();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)SENT_DATE).is((Object)sentDate)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(1);
        ArrayList backUpImageList = new ArrayList();
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            List list = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backUpImageList.addAll(list);
        }
        if (!CollectionUtils.isEmpty(backUpImageList)) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    private BackUpImage getBackUpImageForFileForRoot(int cloudId, MongoTemplate mongoTemplate, String fileName, Device device, Long serverModifiedTime) {
        Criteria criteria = new Criteria();
        String deviceUUID = device.getDeviceUUID();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).exists(false), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).is((Object)serverModifiedTime)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(1);
        ArrayList backUpImageList = new ArrayList();
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            List resultList = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)resultList)) continue;
            backUpImageList.addAll(resultList);
        }
        this.logger.debug("getBackUpImageForFileForRoot backUpImageList size :" + backUpImageList.size());
        if (this.isDeviceQueryCheckEnabled(cloudId)) {
            this.logger.debug("Inside getBackUpImageForFileForRoot for device QUERY");
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).exists(false), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).is((Object)serverModifiedTime), Criteria.where((String)DEVICE_UUID).exists(false)});
            query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            query.limit(1);
            for (String dest : bkpCollectionList) {
                List list = mongoTemplate.find(query, BackUpImage.class, dest);
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                backUpImageList.addAll(list);
            }
        }
        if (!CollectionUtils.isEmpty(backUpImageList)) {
            this.logger.debug("<<<<<<<>>>>>>>>>>>>>>>>>>>>>" + backUpImageList.size());
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    @Override
    public long getStorageUsedByUser(int cloudId, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Long totalSizeUsed = 0L;
        User user = this.getUserInfoByName(cloudId, "", userName);
        if (user != null) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false), Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            List list = mongoTemplate.find(query, Device.class);
            for (Device device : list) {
                DeviceBackupOverView backupOverView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
                if (backupOverView == null) continue;
                totalSizeUsed = totalSizeUsed + backupOverView.getStorageUtilized();
            }
        }
        return totalSizeUsed;
    }

    @Override
    public long getTotalSizeUsedByUserForDevice(int cloudId, String userName, ObjectId deviceId) {
        DeviceBackupOverView backupOverView;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long totalSizeUsed = 0L;
        Criteria criteria = Criteria.where((String)"id").is((Object)deviceId);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Device device = (Device)mongoTemplate.findOne(query, Device.class);
        if (device != null && (backupOverView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID())) != null) {
            totalSizeUsed = backupOverView.getStorageUtilized();
        }
        return totalSizeUsed;
    }

    @Override
    public List<Object[]> getDeviceHistoryElement(int cloudId, String cloudName, String deviceName, int skipValue) {
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((String)deviceName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).regex("^" + deviceName + "$", "i"), Criteria.where((String)BLOCKED).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        this.logger.debug("   Skip value in getDeviceHistoryElement ... aggregation ... " + skipValue);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List deviceList = mongoTemplate.find(query, Device.class);
        for (Device device : deviceList) {
            if (device == null || StringUtils.isEmpty((String)device.getUserName())) continue;
            Object[] arr = new Object[4];
            arr[0] = new Long(0L);
            arr[2] = device.getUserName();
            arr[1] = device.getDeviceName();
            arr[3] = device.getDeviceCreatedDate();
            list1.add(arr);
        }
        return list1;
    }

    @Override
    public List<Object[]> getUserHistoryElement(int cloudId, String cloudName, String userName, int skipValue) {
        Object[] arr;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria criteria2 = Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i");
            list.add(criteria2);
        }
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE}).sum("size").as("size"), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE}), Aggregation.limit((long)PCHelperConstant.getReportDisplayRecords())});
        this.logger.debug("   Skip value in getUserHistoryElement ... aggregation ... " + skipValue);
        if (skipValue != 0 && skipValue != -1) {
            aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE}).sum("size").as("size"), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE, PRESENT}), Aggregation.skip((int)(skipValue * PCHelperConstant.getReportDisplayRecords())), Aggregation.limit((long)PCHelperConstant.getReportDisplayRecords())});
        }
        AggregationResults result = mongoTemplate.aggregate(aggregation, Document.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<String> existingUserNames = new ArrayList<String>();
        for (Document dbObject : stateStatsList) {
            boolean isPresent = false;
            if (dbObject.get((Object)PRESENT) != null) {
                isPresent = Boolean.parseBoolean(dbObject.get((Object)PRESENT).toString());
            }
            if (!isPresent) continue;
            arr = new Object[4];
            arr[0] = dbObject.get((Object)"size");
            String userName2 = dbObject.get((Object)USER_NAME).toString();
            arr[2] = userName2;
            DBRef dbRef = (DBRef)dbObject.get((Object)DEVICE);
            if (dbRef == null) continue;
            String deviceId = dbRef.getId().toString();
            Device device = this.getDeviceForId(cloudId, deviceId);
            User user = this.getUserInfoByName(cloudId, cloudName, userName2);
            if (user == null || device == null || device.isBlocked()) continue;
            String deviceName2 = device.getDeviceName();
            arr[1] = deviceName2;
            if (StringUtils.isEmpty((String)userName)) {
                existingUserNames.add(userName2);
            }
            arr[3] = device.getDeviceCreatedDate();
            list1.add(arr);
        }
        if (StringUtils.isEmpty((String)userName)) {
            List<String> userNames = this.getAllActiveUsers(cloudId, existingUserNames, skipValue);
            for (String userNameVal : userNames) {
                arr = new Object[4];
                arr[0] = new Long(0L);
                arr[2] = userNameVal;
                arr[1] = "";
                arr[3] = "";
                list1.add(arr);
            }
        }
        return list1;
    }

    @Override
    public void deleteBackupImagesForUser(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i")});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getChildrenByFolderForAgent(int cloudId, String cloudName, String folderPath, Device device, boolean isExternalStorage, boolean restoreDeletedFiles) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List<BackUpImage> backupImageList = this.getAggregatedBackupImages(cloudId, mongoTemplate, folderPath, device, restoreDeletedFiles);
        this.logger.debug(".....DeviceType......." + device.getDeviceType());
        backupImageList = device.getDeviceType().equalsIgnoreCase("OUTLOOK") ? this.getFilteredBackupImageListByGroupingForMail(backupImageList, restoreDeletedFiles) : this.getFilteredBackupImageListByGrouping(backupImageList, restoreDeletedFiles);
        return backupImageList;
    }

    private List<ObjectId> getAggregatedBackupIdsForAgentRestore(int cloudId, MongoTemplate mongoTemplate, String folderPath, Device device, boolean isExternalStorage, boolean restoreDeletedFiles) {
        String deviceUUID = device.getDeviceUUID();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        ArrayList backupList = new ArrayList();
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String string : bkpCollectionList) {
            List result = mongoTemplate.find(query, BackUpImage.class, string);
            backupList.addAll(result);
        }
        ArrayList<ObjectId> listOfObjectIds = new ArrayList<ObjectId>();
        for (BackUpImage dbObject : backupList) {
            Long lastServerModifiedTime;
            String devicePath;
            String fileName = dbObject.getFileName();
            BackUpImage backUpImage = this.getBackUpImageForFile(cloudId, device, mongoTemplate, fileName, devicePath = dbObject.getDevicePath(), lastServerModifiedTime = Long.valueOf(dbObject.getLastServerModifiedTime()));
            if (backUpImage == null) continue;
            listOfObjectIds.add(backUpImage.getId());
        }
        if (this.isDeviceQueryCheckEnabled(cloudId)) {
            this.logger.debug("Inside device query");
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)DEVICE_UUID).exists(false)});
            TypedAggregation typedAggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{DEVICE_PATH, FILE_NAME}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{DEVICE_PATH, FILE_NAME, LAST_SERVER_MODIFIED_TIME})});
            ArrayList stateStatsListForDeviceUUID = new ArrayList();
            for (String dest : bkpCollectionList) {
                AggregationResults resultForDeviceUUID = mongoTemplate.aggregate(typedAggregation, dest, Document.class);
                List list = resultForDeviceUUID.getMappedResults();
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                stateStatsListForDeviceUUID.addAll(list);
            }
            for (Document dbObject : stateStatsListForDeviceUUID) {
                String fileName = dbObject.get((Object)FILE_NAME).toString();
                String devicePath = dbObject.get((Object)DEVICE_PATH).toString();
                Long lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME);
                this.logger.debug("   get id .... " + dbObject + "fileName..." + fileName);
                BackUpImage backUpImage = this.getBackUpImageForFile(cloudId, device, mongoTemplate, fileName, devicePath, lastServerModifiedTime);
                if (backUpImage == null) continue;
                listOfObjectIds.add(backUpImage.getId());
            }
        }
        return listOfObjectIds;
    }

    private List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backUpImages) {
            if (!backUpImage.isPresent()) continue;
            filteredBackUpImages.add(backUpImage);
        }
        return filteredBackUpImages;
    }

    private List<BackUpImage> getFilteredLatestVersionBackupImageList(List<BackUpImage> backUpImages, boolean restoreDeletedFiles) {
        this.logger.debug("Inside grouping backup images....");
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        ArrayList deltedBackUpImages = new ArrayList();
        ArrayList<BackUpImage> deletedBackUpImagesList = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        for (BackUpImage filteredBackUpImage : filteredBackUpImages) {
            if (filteredBackUpImage.isPresent()) {
                filteredBackUpImagesList.add(filteredBackUpImage);
                continue;
            }
            deletedBackUpImagesList.add(filteredBackUpImage);
        }
        if (restoreDeletedFiles) {
            for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
                entry.getValue().entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).filter(p1 -> p1.isPresent()).findFirst().get()));
            }
            for (BackUpImage bkpimage : deletedBackUpImagesList) {
                for (BackUpImage bkpimage1 : deltedBackUpImages) {
                    if (!bkpimage.getFileName().equals(bkpimage1.getFileName()) || !bkpimage.getDevicePath().equals(bkpimage1.getDevicePath())) continue;
                    bkpimage1.setPresent(false);
                    filteredBackUpImagesList.add(bkpimage1);
                }
            }
        }
        return filteredBackUpImagesList;
    }

    @Override
    public List<Object[]> getTotalSizeUsed(int cloudId, String cloudName, String userName, String deviceName) {
        return null;
    }

    private List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages, boolean present) {
        String presentString = String.valueOf(present);
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backUpImages) {
            String presentVal = String.valueOf(backUpImage.isPresent());
            if (!presentVal.equals(presentString)) continue;
            filteredBackUpImages.add(backUpImage);
        }
        return filteredBackUpImages;
    }

    private List<BackUpImage> getFilteredBackupImageListWithoutFolders(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backUpImages) {
            if (!backUpImage.isPresent() || backUpImage.isFolder()) continue;
            filteredBackUpImages.add(backUpImage);
        }
        return filteredBackUpImages;
    }

    private List<BackUpImage> getFilteredBackupImageListOnlyStoragePlaceExists(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backUpImages) {
            if (!backUpImage.isPresent() || backUpImage.getStoragePlace() == null) continue;
            filteredBackUpImages.add(backUpImage);
        }
        return filteredBackUpImages;
    }

    private List<BackUpImage> getFilteredBackupImageListForStoragePlaceExists(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backUpImages) {
            if (backUpImage.getStoragePlace() == null) continue;
            filteredBackUpImages.add(backUpImage);
        }
        return filteredBackUpImages;
    }

    @Override
    public void saveBackupImageInBatch(int cloudId, List<BackUpImage> backUpImages, String destCollection) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug("@@@@ INSERT in batcheslater .........." + backUpImages.size() + "..coll..." + destCollection);
        backUpImages.parallelStream().forEach(bkpImage -> {
            if (StringUtils.isEmpty((String)destCollection)) {
                mongoTemplate.save(bkpImage);
            } else {
                mongoTemplate.save(bkpImage, destCollection);
            }
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)bkpImage.getDeviceUUID()), Criteria.where((String)"isDecoupled").is((Object)false)});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            Update update = new Update();
            update.inc("latestVersionsSize", (Number)(-bkpImage.getSize()));
            mongoTemplate.updateFirst(query, update, LatestDeviceBackupInfo.class);
        });
    }

    @Override
    public List<BackUpImage> getBackupImageForServerModifiedTime(int cloudId, List<Long> serverModifiedTimes) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LAST_SERVER_MODIFIED_TIME).in(serverModifiedTimes)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<ObjectId> getListOfDeletedBackupIds(int cloudId, String userName, List<ObjectId> backupIds) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug("backup ids List>>>>>>>>>>" + backupIds.size());
        List<BackUpImage> backupFileList = this.getAllLatestBackup((MongoOperations)mongoTemplate, backupIds);
        this.logger.debug("backupFileList>>>>>>>>>>" + backupFileList.size());
        List<ObjectId> backupIdListFromBackupImage = this.getListOfBackupIdStrings(backupFileList);
        Collection retainedList = org.apache.commons.collections.CollectionUtils.retainAll(backupIdListFromBackupImage, backupIds);
        this.logger.debug(" retained backupFileList size>>>>>>>>>>" + retainedList.size());
        backupIds.removeAll(retainedList);
        this.logger.debug("backup ids List>>>>>>>>>>#############" + backupIds.size());
        return backupIds;
    }

    private List<ObjectId> getListOfBackupIdStrings(List<BackUpImage> backupFileList) {
        ArrayList<ObjectId> backupIdsFromBackupImage = new ArrayList<ObjectId>();
        if (backupFileList != null) {
            for (BackUpImage backUpImage : backupFileList) {
                backupIdsFromBackupImage.add(backUpImage.getId());
            }
        }
        return backupIdsFromBackupImage;
    }

    @Override
    public BackUpImage getParentBackupFileForMd5(int cloudId, String userName, String md5checksum) {
        this.logger.debug(md5checksum + " @@@@STARTMD5 getBackupFileForMd5s without username  ");
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)MD5_CHECK_SUM).exists(true), Criteria.where((String)STATUS).ne((Object)DELETED), Criteria.where((String)MD5_CHECK_SUM).is((Object)md5checksum)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{MD5_CHECK_SUM}).min(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{MD5_CHECK_SUM, LAST_SERVER_MODIFIED_TIME})});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        AggregationResults result = mongoTemplate.aggregate(aggregation, Document.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<Long> listOfObjectIds = new ArrayList<Long>();
        for (Document dbObject : stateStatsList) {
            listOfObjectIds.add((Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME));
        }
        this.logger.debug("TOTAL deduped files Size ..... " + listOfObjectIds.size());
        criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LAST_SERVER_MODIFIED_TIME).in(listOfObjectIds)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        BackUpImage list = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
        if (list != null) {
            this.logger.debug(" @@@@ENDMD5 getBackupFileForMd5s without username 0");
        } else {
            this.logger.debug(END_MD5_GET_BACKUP_FILE_FOR_MD5_WITHOUT_USER_NAME + list);
        }
        return list;
    }

    @Override
    public BackUpImage getBackupFileForID(int cloudId, ObjectId backupId, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        BackUpImage backupFile = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
        if (backupFile != null) {
            backupFile = this.getParentBackupFileForMd5(1, userName, backupFile.getMd5Checksum());
        }
        return backupFile;
    }

    @Override
    public BackUpImage getBackupFileForIDForValidate(int cloudId, String backupId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public List<ChunkFile> getChunkFileNamesForId(int cloudId, String cloudName, String userName, String backupId) {
        String tableName = "privacy_gateway_od_" + cloudName + "_" + userName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        ArrayList<ChunkFile> chunkFiles = new ArrayList();
        MongoCollection collection = mongoTemplate.getCollection(tableName);
        Bson searchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)new ObjectId(backupId))});
        ArrayList bkpList = new ArrayList();
        FindIterable find = collection.find(searchQuery);
        MongoCursor cursor = find.iterator();
        if (cursor.hasNext()) {
            Document next = (Document)cursor.next();
            chunkFiles = BackUpImageDaoImpl.getChunkFiles(next);
        }
        this.logger.debug("Converted final list ................... " + bkpList.size());
        cursor.close();
        return chunkFiles;
    }

    private static List<ChunkFile> getChunkFiles(Document dbObject) {
        List list = (List)dbObject.get((Object)"chunkFiles");
        ArrayList<ChunkFile> chunkFiles = new ArrayList<ChunkFile>();
        for (Document chunk : list) {
            Object cloudStoragePath = chunk.get((Object)"cloudStoragePath");
            Object size = chunk.get((Object)"size");
            ChunkFile chunkFile = new ChunkFile();
            chunkFile.setFileId(chunk.get((Object)"fileId").toString());
            chunkFile.setFileName(chunk.get((Object)FILE_NAME).toString());
            if (chunk.get((Object)"fSPath") != null) {
                chunkFile.setfSPath(chunk.get((Object)"fSPath").toString());
            }
            chunkFile.setUploadedTimeStamp((Long)chunk.get((Object)"uploadedTimeStamp"));
            if (cloudStoragePath != null) {
                chunkFile.setCloudStoragePath(cloudStoragePath.toString());
            }
            if (size != null) {
                chunkFile.setSize((Long)size);
            }
            chunkFiles.add(chunkFile);
        }
        return chunkFiles;
    }

    @Override
    public void removeReBkpByIds(int cloudId, List<ObjectId> removeReBkpByIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(removeReBkpByIds)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, ReBackUpImage.class);
    }

    @Override
    public BackUpImage getBackupFileForID(int cloudId, ObjectId backupId, Device device) {
        this.logger.debug("backupImage id" + backupId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug(DEVICE + device.getDestCollection());
        BackUpImage backUpImage = new BackUpImage();
        backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, device.getDestCollection());
        return backUpImage;
    }

    @Override
    public String getBackupIDForMd5(int cloudId, String userName, String md5checksum) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String tableName = BACKUP;
        ArrayList<BackUpImage> list = new ArrayList<BackUpImage>();
        String backupId = "";
        MongoCollection collection = mongoTemplate.getCollection(tableName);
        Bson searchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)MD5_CHECK_SUM, (Object)md5checksum)});
        ArrayList bkpList = new ArrayList();
        FindIterable find = collection.find(searchQuery);
        MongoCursor cursor = find.iterator();
        if (cursor.hasNext()) {
            Document next = (Document)cursor.next();
            BackUpImage backUpImage = (BackUpImage)mongoTemplate.getConverter().read(BackUpImage.class, (Object)next);
            if (backUpImage != null) {
                list.add(backUpImage);
            }
        }
        this.logger.debug("Converted final list ................... " + bkpList.size());
        cursor.close();
        if (!CollectionUtils.isEmpty(list)) {
            Collections.sort(list, new Comparator<BackUpImage>(){

                @Override
                public int compare(BackUpImage c1, BackUpImage c2) {
                    long t2;
                    long t1 = c2.getLastServerModifiedTime();
                    if (t1 < (t2 = c1.getLastServerModifiedTime())) {
                        return 1;
                    }
                    if (t1 == t2) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
        if (!CollectionUtils.isEmpty(list)) {
            BackUpImage backupImage = (BackUpImage)list.get(0);
            backupId = backupImage.getId().toString();
        }
        return backupId;
    }

    @Override
    public List<BackUpImage> getContainerChildren(int cloudId, String containerName, Device device) {
        this.logger.debug("getVersionsForServerBackup(int cloudId, String containerName, Device device) > BEGIN");
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)"containerName").is((Object)containerName)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME}), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        List<BackUpImage> resList = this.getBackupImagesForRestore(cloudId, (TypedAggregation<BackUpImage>)aggregation, null, null);
        resList = this.getFilteredBackupImageList(resList);
        return resList;
    }

    @Override
    public void bulkDeleteBackupFiles(int cloudId, String cloudName, List<ObjectId> backupIds, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(backupIds)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, BackUpImage.class);
        if (device == null) {
            mongoTemplate.remove(query, BackUpImage.class);
        } else {
            mongoTemplate.remove(query, BackUpImage.class, device.getDestCollection());
        }
    }

    @Override
    public List<BackUpImage> getAllFilesForDevice(int cloudId, String cloudName, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID())});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(500);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        ArrayList<BackUpImage> backupList = new ArrayList<BackUpImage>();
        for (String dest : bkpCollectionList) {
            List backupImagesList = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)backupImagesList)) continue;
            backupList.addAll(backupImagesList);
        }
        return backupList;
    }

    @Override
    public BackUpImage getBackupImageForDevice(int cloudId, String backupID, Device device) {
        this.logger.error("#$$$$$  inside getting device uuid for backupID>>>");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            BackUpImage image = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest);
            if (image == null) continue;
            return image;
        }
        return null;
    }

    @Override
    public BackUpImage getBackupImageForDevicePath(int cloudId, String cloudName, String fileName, String devicePath) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getAllMyBackupSharedFiles(int cloudId, String cloudName, String userName, List<Device> deviceList) {
        ArrayList<BackUpImage> sharedFiles = new ArrayList<BackUpImage>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"sharedBy").exists(true), Criteria.where((String)"sharedBy").is((Object)userName), Criteria.where((String)PRESENT).is((Object)true)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<String> bkpCollectionList = new ArrayList<String>();
        for (Device device : deviceList) {
            bkpCollectionList.addAll(this.getBackupCollectionList(device));
        }
        Set set = bkpCollectionList.stream().collect(Collectors.toSet());
        for (String dest : set) {
            List backupImagesList = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)backupImagesList)) continue;
            sharedFiles.addAll(backupImagesList);
        }
        return sharedFiles;
    }

    @Override
    public List<ReBackUpImage> getFilesForReBackup(int cloudId, String deviceId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceId").is((Object)deviceId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(500);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ReBackUpImage.class);
    }

    @Override
    public void deleteFileInRebackupAndBackup(int cloudId, ObjectId backupId) {
        Device device;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String pgCollectionName = BACKUP_PG.toUpperCase();
        ReBackUpImage rebkp = (ReBackUpImage)mongoTemplate.findOne(query, ReBackUpImage.class);
        if (rebkp != null && !StringUtils.isEmpty((String)rebkp.getDeviceId()) && (device = this.getDeviceForDeviceId(cloudId, new ObjectId(rebkp.getDeviceId()))) != null) {
            this.logger.debug("device.getDestCollection()..." + device.getDestCollection());
            BackUpImage bkpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, device.getDestCollection());
            if (bkpImage != null) {
                this.updateDeleteFileSizeDeviceBackupOverView(cloudId, device.getDeviceUUID(), -bkpImage.getSize());
                mongoTemplate.remove(query, BackUpImage.class, device.getDestCollection());
            }
            mongoTemplate.remove(query, ReBackUpImage.class);
            this.logger.debug(backupId + "...File deleted in PG and " + device.getDestCollection() + "...Collection...");
            mongoTemplate.remove(query, FileInfo.class, pgCollectionName);
        }
    }

    private void updateDeleteFileSizeDeviceBackupOverView(int cloudId, String deviceUUID, Long size) {
        if (size != null) {
            Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            Update update = new Update();
            update.inc("storageUtilized", (Number)size);
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)"isDecoupled").is((Object)false)});
            query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            update.inc("latestVersionsSize", (Number)size);
            mongoTemplate.updateFirst(query, update, LatestDeviceBackupInfo.class);
        }
    }

    @Override
    public List<BackUpImage> getLatestFoldersRecursive(int cloudId, String cloudName, Device device, String devicePath) {
        List<BackUpImage> resList = new ArrayList<BackUpImage>();
        try {
            boolean retry;
            String deviceUUID = device.getDeviceUUID();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            int retryCount = 0;
            do {
                retry = false;
                try {
                    ArrayList<BackUpImage> backupImages = new ArrayList<BackUpImage>();
                    this.logger.error("##getting folders recursive device path: .........." + devicePath);
                    Criteria pathLikeCriteria = new Criteria();
                    if (!StringUtils.isEmpty((String)devicePath)) {
                        pathLikeCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
                    } else {
                        pathLikeCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).exists(false), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
                    }
                    org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)pathLikeCriteria);
                    List<String> bkpCollectionList = this.getBackupCollectionList(device);
                    for (String dest : bkpCollectionList) {
                        List backupImagesList = mongoTemplate.find(query, BackUpImage.class, dest);
                        if (CollectionUtils.isEmpty((Collection)backupImagesList)) continue;
                        backupImages.addAll(backupImagesList);
                    }
                    if (this.isDeviceQueryCheckEnabled(cloudId)) {
                        Criteria pathLikeCriteriaForDeviceUUID = new Criteria();
                        if (!StringUtils.isEmpty((String)devicePath)) {
                            pathLikeCriteriaForDeviceUUID.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
                        } else {
                            pathLikeCriteriaForDeviceUUID.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).exists(false), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
                        }
                        org.springframework.data.mongodb.core.query.Query queryForDeviceUUID = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)pathLikeCriteriaForDeviceUUID);
                        for (String dest : bkpCollectionList) {
                            List backupImagesList = mongoTemplate.find(queryForDeviceUUID, BackUpImage.class, dest);
                            if (CollectionUtils.isEmpty((Collection)backupImagesList)) continue;
                            backupImages.addAll(backupImagesList);
                        }
                        this.logger.error("##End Trying to get devicepath list andoperator .........." + backupImages.size());
                    }
                    resList = this.getFilteredBackupImageListByGrouping(backupImages, true);
                    this.logger.error("##End Result list after grouping.........." + resList.size());
                }
                catch (Exception e) {
                    retry = true;
                    ++retryCount;
                    this.logger.debug("insode mongo db exception whule getting folder list so sleep and retry######");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e1) {
                        this.logger.debug("InterruptedException" + e1.getMessage());
                        this.logger.debug("InterruptedException" + e1);
                    }
                    this.logger.trace("" + e);
                    this.logger.error("Exception while getting latest files:" + e.getMessage());
                    if (retryCount != 3) continue;
                    return null;
                }
            } while (retry && retryCount < 3);
        }
        catch (Exception e) {
            this.logger.debug("" + e.getMessage());
            this.logger.debug("" + e);
        }
        this.logger.debug("result list size>>>>" + resList.size());
        return resList;
    }

    private List<BackUpImage> getFilteredBackupImageListByGrouping(List<BackUpImage> backUpImages, boolean restoreDeletedFiles) {
        this.logger.debug("Inside grouping backup images");
        this.logger.debug(restoreDeletedFiles + "...Inside grouping backup images..." + backUpImages.size());
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        ArrayList deltedBackUpImages = new ArrayList();
        ArrayList<BackUpImage> deletedBackUpImagesList = new ArrayList<BackUpImage>();
        backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getFileName)).entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        this.logger.debug("..overall mapsize...." + map.size());
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        for (BackUpImage filteredBackUpImage : filteredBackUpImages) {
            if (filteredBackUpImage.isPresent()) {
                filteredBackUpImagesList.add(filteredBackUpImage);
                continue;
            }
            deletedBackUpImagesList.add(filteredBackUpImage);
        }
        this.logger.debug(deletedBackUpImagesList.size() + "...filtered list ..." + filteredBackUpImagesList.size());
        if (restoreDeletedFiles) {
            backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getFileName)).entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).filter(p1 -> p1.isPresent()).findFirst().orElse(null)));
            Map<String, Map<String, List<BackUpImage>>> map1 = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
            for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map1.entrySet()) {
                entry.getValue().entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).filter(p1 -> p1.isPresent()).findFirst().orElse(null)));
            }
            this.logger.debug(deltedBackUpImages.size() + "...delelted new..." + deletedBackUpImagesList.size());
            for (BackUpImage bkpimage : deletedBackUpImagesList) {
                for (BackUpImage bkpimage1 : deltedBackUpImages) {
                    if (bkpimage1 == null) continue;
                    if (StringUtils.isEmpty((String)bkpimage1.getFileName())) {
                        bkpimage1.setFileName("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage.getFileName())) {
                        bkpimage.setFileName("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage1.getDevicePath())) {
                        bkpimage1.setDevicePath("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage.getDevicePath())) {
                        bkpimage.setDevicePath("");
                    }
                    if (!bkpimage.getFileName().equals(bkpimage1.getFileName()) || !bkpimage.getDevicePath().equals(bkpimage1.getDevicePath())) continue;
                    bkpimage1.setPresent(false);
                    filteredBackUpImagesList.add(bkpimage1);
                }
            }
        }
        return filteredBackUpImagesList;
    }

    private List<BackUpImage> getFilteredBackupImageListByGroupingForMail(List<BackUpImage> backUpImages, boolean restoreDeletedFiles) {
        this.logger.debug(restoreDeletedFiles + "...Inside grouping backup images..." + backUpImages.size());
        List<Object> folderBackUpImages = new ArrayList();
        folderBackUpImages = backUpImages.stream().filter(f -> f.isFolder()).collect(Collectors.toList());
        List<Object> fileBackUpImages = new ArrayList();
        fileBackUpImages = backUpImages.stream().filter(f -> !f.isFolder()).collect(Collectors.toList());
        backUpImages = fileBackUpImages;
        Comparator<BackUpImage> compareByName = new Comparator<BackUpImage>(){

            @Override
            public int compare(BackUpImage o1, BackUpImage o2) {
                return o1.getFileName().compareTo(o2.getFileName());
            }
        };
        Map<String, List<BackUpImage>> foldermap = folderBackUpImages.stream().filter(p -> p.isFolder()).collect(Collectors.groupingBy(BackUpImage::getFileName));
        ArrayList filteredFolderBackUpImages = new ArrayList();
        foldermap.entrySet().stream().forEach(p -> filteredFolderBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        ArrayList<BackUpImage> filteredfolderBackUpImages = new ArrayList<BackUpImage>();
        ArrayList<BackUpImage> delefolderBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage filteredBackUpImage : filteredFolderBackUpImages) {
            if (filteredBackUpImage.isPresent()) {
                filteredfolderBackUpImages.add(filteredBackUpImage);
                continue;
            }
            delefolderBackUpImages.add(filteredBackUpImage);
        }
        Collections.sort(filteredfolderBackUpImages, compareByName);
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        ArrayList deltedBackUpImages = new ArrayList();
        ArrayList<BackUpImage> deletedBackUpImagesList = new ArrayList<BackUpImage>();
        Map<String, List<BackUpImage>> map = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getOdItemId));
        int i = 0;
        map.entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        for (Object filteredBackUpImage : filteredBackUpImages) {
            if (((BackUpImage)filteredBackUpImage).isPresent()) {
                ++i;
                filteredBackUpImagesList.add((BackUpImage)filteredBackUpImage);
                continue;
            }
            deletedBackUpImagesList.add((BackUpImage)filteredBackUpImage);
        }
        this.logger.debug(deletedBackUpImagesList.size() + "...filtered list ..." + filteredBackUpImagesList.size());
        if (restoreDeletedFiles) {
            backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getFileName)).entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).filter(p1 -> p1.isPresent()).findFirst().orElse(null)));
            Map<String, Map<String, List<BackUpImage>>> map1 = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getOdItemId)));
            for (Map.Entry entry : map1.entrySet()) {
                ((Map)entry.getValue()).entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).filter(p1 -> p1.isPresent()).findFirst().orElse(null)));
            }
            this.logger.debug(deltedBackUpImages.size() + "...delelted new..." + deletedBackUpImagesList.size());
            for (BackUpImage backUpImage : deletedBackUpImagesList) {
                this.logger.debug(filteredBackUpImagesList.size() + "...trying file...." + backUpImage.getFileName());
                for (BackUpImage bkpimage1 : deltedBackUpImages) {
                    if (bkpimage1 == null) continue;
                    if (StringUtils.isEmpty((String)bkpimage1.getFileName())) {
                        bkpimage1.setFileName("");
                    }
                    if (StringUtils.isEmpty((String)backUpImage.getFileName())) {
                        backUpImage.setFileName("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage1.getDevicePath())) {
                        bkpimage1.setDevicePath("");
                    }
                    if (StringUtils.isEmpty((String)backUpImage.getDevicePath())) {
                        backUpImage.setDevicePath("");
                    }
                    if (!backUpImage.getFileName().equals(bkpimage1.getFileName()) || !backUpImage.getDevicePath().equals(bkpimage1.getDevicePath())) continue;
                    bkpimage1.setPresent(false);
                    filteredBackUpImagesList.add(bkpimage1);
                }
            }
        }
        Comparator reverseComparator = (c1, c2) -> {
            if (c1.getSentDate() == null || c2.getSentDate() == null) {
                return 0;
            }
            return c2.getSentDate().compareTo(c1.getSentDate());
        };
        Collections.sort(filteredBackUpImagesList, reverseComparator);
        ArrayList<BackUpImage> overAllList = new ArrayList<BackUpImage>();
        overAllList.addAll(filteredfolderBackUpImages);
        overAllList.addAll(filteredBackUpImagesList);
        return overAllList;
    }

    private List<BackUpImage> getFilteredBackupImageListByGroupingForMailForDeleted(List<BackUpImage> backUpImages, boolean restoreDeletedFiles) {
        this.logger.debug(restoreDeletedFiles + "...Inside getFilteredBackupImageListByGroupingForMailForDeleted..." + backUpImages.size());
        List<Object> folderBackUpImages = new ArrayList();
        folderBackUpImages = backUpImages.stream().filter(f -> f.isFolder()).collect(Collectors.toList());
        List<Object> fileBackUpImages = new ArrayList();
        fileBackUpImages = backUpImages.stream().filter(f -> !f.isFolder()).collect(Collectors.toList());
        backUpImages = fileBackUpImages;
        Comparator<BackUpImage> compareByName = new Comparator<BackUpImage>(){

            @Override
            public int compare(BackUpImage o1, BackUpImage o2) {
                return o1.getFileName().compareTo(o2.getFileName());
            }
        };
        Map<String, List<BackUpImage>> foldermap = folderBackUpImages.stream().filter(p -> p.isFolder()).collect(Collectors.groupingBy(BackUpImage::getFileName));
        ArrayList filteredFolderBackUpImages = new ArrayList();
        foldermap.entrySet().stream().forEach(p -> filteredFolderBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        ArrayList<BackUpImage> filteredfolderBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage filteredBackUpImage : filteredFolderBackUpImages) {
            filteredfolderBackUpImages.add(filteredBackUpImage);
        }
        Collections.sort(filteredfolderBackUpImages, compareByName);
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        ArrayList deltedBackUpImages = new ArrayList();
        ArrayList deletedBackUpImagesList = new ArrayList();
        Map<String, List<BackUpImage>> map = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getOdItemId));
        int i = 0;
        map.entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        for (BackUpImage filteredBackUpImage : filteredBackUpImages) {
            if (filteredBackUpImage.isPresent()) continue;
            ++i;
            filteredBackUpImagesList.add(filteredBackUpImage);
        }
        this.logger.debug(deletedBackUpImagesList.size() + "...filtered list ..." + filteredBackUpImagesList.size());
        Comparator reverseComparator = (c1, c2) -> {
            if (c1.getSentDate() == null || c2.getSentDate() == null) {
                return 0;
            }
            return c2.getSentDate().compareTo(c1.getSentDate());
        };
        Collections.sort(filteredBackUpImagesList, reverseComparator);
        ArrayList<BackUpImage> overAllList = new ArrayList<BackUpImage>();
        overAllList.addAll(filteredfolderBackUpImages);
        overAllList.addAll(filteredBackUpImagesList);
        return overAllList;
    }

    private List<BackUpImage> getFilteredBackupImageListForVersions(List<BackUpImage> backUpImages) {
        this.logger.debug("Inside grouping backup images For versions");
        ArrayList iterateList = new ArrayList();
        backUpImages.stream().collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getLastServerModifiedTime)).entrySet().stream().forEach(p -> iterateList.add(((List)p.getValue()).stream().findFirst().get()));
        List<BackUpImage> filteredBackUpImages = iterateList.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).collect(Collectors.toList());
        return filteredBackUpImages;
    }

    public boolean isDeviceQueryCheckEnabled(int cloudId) {
        List cloudProps = this.mongoOps.findAll(CloudProperties.class);
        if (cloudProps != null && !cloudProps.isEmpty()) {
            return ((CloudProperties)cloudProps.get(0)).isDeviceQueryCheckEnabled();
        }
        return false;
    }

    @Override
    public void deleteBackupFile(int cloudId, String cloudName, BackUpImage backupImage, Device device) {
        this.logger.debug("backupImage id" + backupImage.getId());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupImage.getId())});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug(DEVICE + device.getDestCollection());
        if (device == null) {
            mongoTemplate.remove(query, BackUpImage.class);
        } else {
            mongoTemplate.remove(query, BackUpImage.class, device.getDestCollection());
        }
    }

    @Override
    public void saveDeletedBackupFileInDB(int cloudId, String cloudName, DeletedBackupFile deletedBackupFile, Device device) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug("deletedBackupFile saving in db");
        mongoTemplate.save((Object)deletedBackupFile);
    }

    @Override
    public List<BackUpImage> getVersionsForAllFolder(int cloudId, String folderName, Device device) {
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).is((Object)folderName);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)FOLDER).is((Object)true), pathLikeCriteria});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String destCollection = device.getDestCollection();
        return mongoTemplate.find(query, BackUpImage.class, destCollection);
    }

    @Override
    public DeletedBackupFile getDeletedBkpFileByUserAndDeviceUUID(int cloudId, String userName, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)FOLDER).is((Object)true)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DeletedBackupFile deletedBkpFile = (DeletedBackupFile)mongoTemplate.findOne(query, DeletedBackupFile.class);
        return deletedBkpFile;
    }

    @Override
    public DeletedBackupFile getDeletedBkpFileByUserName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DeletedBackupFile deletedBkpFile = (DeletedBackupFile)mongoTemplate.findOne(query, DeletedBackupFile.class);
        return deletedBkpFile;
    }

    @Override
    public BackUpImage getBackupimgaeByUserNameAndDevice(int cloudId, String userName, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String destCollection = device.getDestCollection();
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, destCollection);
    }

    @Override
    public List<BackUpImage> getBaseChildrenByDevice(int cloudId, String cloudName, Device device, int skipValue, int recordsCount, boolean isrestoreDeletedFile, boolean isMail) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List<ObjectId> listOfBackupIds = this.getAggregatedBackupIdsForRoot(cloudId, mongoTemplate, device, isrestoreDeletedFile);
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        List<BackUpImage> backupList = new ArrayList<BackUpImage>();
        for (String dest : bkpCollectionList) {
            List list;
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
            org.springframework.data.mongodb.core.query.Query query1 = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            if (isMail) {
                query1.with(new Sort(Sort.Direction.DESC, new String[]{SENT_DATE}));
            } else {
                query1.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
            }
            if (CollectionUtils.isEmpty((Collection)(list = mongoTemplate.find(query1, BackUpImage.class, dest)))) continue;
            backupList.addAll(list);
        }
        this.logger.debug("@@@before filtering backup list ........... " + backupList.size());
        backupList = this.getFilteredListForDevice(backupList, device);
        if (this.isDeviceQueryCheckEnabled(cloudId)) {
            this.logger.debug("@@@Before getFilteredListForDevice........... " + backupList.size());
            backupList = this.getFilteredBackupImageListByGrouping(backupList, isrestoreDeletedFile);
            this.logger.debug("@@@After getFilteredListForDevice........... " + backupList.size());
        }
        backupList = this.getFilteredBackupImageListByGrouping(backupList, isrestoreDeletedFile);
        return backupList;
    }

    @Override
    public List<BackUpImage> getChildrenByFolder(int cloudId, String cloudName, String folderPath, Device device, int skipValue, int recordsCount, boolean isMail, boolean isrestoreDeletedFile) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        ArrayList backupImageFolderList = new ArrayList();
        this.logger.debug(".....getchildrenByFolder...." + skipValue);
        if (isMail) {
            // empty if block
        }
        this.logger.debug("###########################Latest#################backupImageFolderList set to null#########################################################");
        List<Object> listOfBackupIds = new ArrayList();
        List<BackUpImage> backupImageList = new ArrayList<BackUpImage>();
        if (!isMail) {
            List list;
            listOfBackupIds = this.getAggregatedBackupIds(cloudId, mongoTemplate, folderPath, device, isrestoreDeletedFile);
            this.logger.debug(skipValue + "...after backupIds latest..." + listOfBackupIds.size());
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
            org.springframework.data.mongodb.core.query.Query query1 = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            if (isMail) {
                query1.with(new Sort(Sort.Direction.DESC, new String[]{SENT_DATE}));
            } else {
                query1.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
            }
            this.logger.debug(listOfBackupIds.size() + "....query limit for mails..." + skipValue + "..." + recordsCount);
            if (skipValue != 0) {
                query1.skip((long)(skipValue * recordsCount));
            }
            if (recordsCount != 0) {
                query1.limit(recordsCount);
            }
            if (!CollectionUtils.isEmpty((Collection)(list = mongoTemplate.find(query1, BackUpImage.class, device.getDestCollection())))) {
                backupImageList.addAll(list);
            }
        }
        this.logger.debug("...without sorting..ismail or not........." + isMail);
        if (isMail) {
            backupImageList = isrestoreDeletedFile ? this.getFilteredBackupImageListByGroupingForMailForDeleted(backupImageList, isrestoreDeletedFile) : this.getFilteredBackupImageListByGroupingForMail(backupImageList, isrestoreDeletedFile);
        } else {
            if (this.isDeviceQueryCheckEnabled(cloudId)) {
                this.logger.debug("BEFORE getFilteredBackupImageListByGrouping size " + backupImageList.size());
                backupImageList = this.getFilteredBackupImageListByGrouping(backupImageList, isrestoreDeletedFile);
                this.logger.debug("AFTER getFilteredBackupImageListByGrouping size " + backupImageList.size());
            }
            backupImageList = this.getFilteredBackupImageListByGrouping(backupImageList, isrestoreDeletedFile);
        }
        ArrayList<BackUpImage> overAllList = new ArrayList<BackUpImage>();
        overAllList.addAll(backupImageFolderList);
        overAllList.addAll(backupImageList);
        return overAllList;
    }

    @Override
    public List<BackUpImage> getMailChildrenByFolder(int cloudId, String cloudName, String folderPath, Device device, int skipValue, int recordsCount, boolean isrestoreDeletedFile, AtomicInteger nextCur, AtomicInteger prevCur, boolean desc, boolean incre12, String curOperation) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        int orgSkipValue = skipValue;
        this.logger.debug(".....getchildrenByFolder...." + skipValue);
        boolean prev = "prev".equalsIgnoreCase(curOperation);
        boolean next = "next".equalsIgnoreCase(curOperation);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        if (skipValue <= 0) {
            skipValue = 0;
            if (prev) {
                curOperation = "first";
                prev = false;
            }
            if (next) {
                curOperation = "last";
                next = false;
            }
        }
        if (!desc) {
            if (prev) {
                curOperation = "next";
                next = true;
                prev = false;
            } else if (next) {
                next = false;
                prev = true;
                curOperation = "prev";
            }
        }
        int orgNextCur = nextCur.get();
        this.logger.debug(skipValue + ".....operation...." + curOperation + "...." + desc + "...reccoubnt..." + recordsCount);
        if (prev) {
            skipValue -= recordsCount;
        }
        this.logger.debug(isrestoreDeletedFile + ".....after cond prev...." + curOperation + "...." + desc);
        if ("first".equalsIgnoreCase(curOperation)) {
            desc = true;
        }
        if ("last".equalsIgnoreCase(curOperation)) {
            desc = false;
        }
        this.logger.debug(skipValue + "###################Latest#############backupImageFolderList set to null test latest######################" + desc);
        List<BackUpImage> backupImageList = new ArrayList();
        Criteria criteria = new Criteria();
        String deviceUUID = device.getDeviceUUID();
        if (isrestoreDeletedFile) {
            Criteria fileCriteria = new Criteria();
            fileCriteria.andOperator(new Criteria[]{Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)false)});
            Criteria orCriteria = new Criteria();
            if (!desc) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), fileCriteria});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), fileCriteria});
            }
        } else if (!desc) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FOLDER).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FOLDER).is((Object)false)});
        }
        List<Object> folderList = new ArrayList();
        if (skipValue == 0) {
            folderList = this.getFolderForMail(folderPath, device, orgSkipValue, recordsCount, mongoTemplate, isrestoreDeletedFile);
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        if (desc) {
            query.with(new Sort(Sort.Direction.DESC, new String[]{SENT_DATE}));
        } else {
            query.with(new Sort(Sort.Direction.ASC, new String[]{SENT_DATE}));
        }
        if (skipValue > 0) {
            query.skip((long)skipValue);
        }
        query.limit(recordsCount);
        this.logger.debug("...beforequery.." + device.getDestCollection());
        backupImageList = mongoTemplate.find(query, BackUpImage.class, device.getDestCollection());
        this.logger.debug("...endquery");
        int totalCount = backupImageList.size();
        this.logger.debug(skipValue + "..without sort.immmediate bakuplist ...." + backupImageList.size());
        backupImageList = isrestoreDeletedFile ? this.getFilteredBackupImageListByGroupingForMailForDeleted(backupImageList, isrestoreDeletedFile) : this.getFilteredBackupImageListByGroupingForMail(backupImageList, isrestoreDeletedFile);
        folderList = isrestoreDeletedFile ? this.getFilteredBackupImageListByGroupingForMailForDeleted(folderList, isrestoreDeletedFile) : this.getFilteredBackupImageListByGroupingForMail(folderList, isrestoreDeletedFile);
        boolean allRecordsFound = false;
        int limit = recordsCount - backupImageList.size();
        this.logger.debug("..incre and order lat..." + desc + "...folder.before limits..." + limit + "...." + recordsCount + "...." + backupImageList.size());
        this.logger.debug(totalCount + "..incre and order..." + recordsCount + "..." + limit);
        if (totalCount == recordsCount && limit > 0) {
            if (skipValue <= 0) {
                skipValue = recordsCount;
            }
            if (prev) {
                skipValue -= limit;
            }
            this.logger.debug("....Before retrying assignedskip...." + skipValue + "...lim.." + limit);
            do {
                org.springframework.data.mongodb.core.query.Query queryObj = new org.springframework.data.mongodb.core.query.Query();
                queryObj.addCriteria((CriteriaDefinition)criteria);
                if (desc) {
                    queryObj.with(new Sort(Sort.Direction.DESC, new String[]{FOLDER}).and(new Sort(Sort.Direction.DESC, new String[]{SENT_DATE})));
                } else {
                    queryObj.with(new Sort(Sort.Direction.ASC, new String[]{FOLDER}).and(new Sort(Sort.Direction.ASC, new String[]{SENT_DATE})));
                }
                if (skipValue > 0) {
                    queryObj.skip((long)skipValue);
                }
                queryObj.limit(limit);
                this.logger.debug(backupImageList.size() + "..before rembackupImageList..limitvalue.." + limit);
                List rembackupImageList = mongoTemplate.find(queryObj, BackUpImage.class, device.getDestCollection());
                this.logger.debug(desc + "......after querying...rembackupImageList..." + limit + ".....limit..." + rembackupImageList.size() + "...." + skipValue);
                List<BackUpImage> filteredRembackupImageList = this.getFilteredBackupImageListByGroupingForMail(rembackupImageList, isrestoreDeletedFile);
                this.logger.debug(backupImageList.size() + "......filteredRembackupImageList......" + filteredRembackupImageList.size());
                backupImageList.addAll(filteredRembackupImageList);
                this.logger.debug("....Before retrying ...." + skipValue + "...lim.." + limit);
                if ("next".equalsIgnoreCase(curOperation)) {
                    skipValue += limit;
                } else if (prev && backupImageList.size() != recordsCount) {
                    skipValue -= limit;
                } else if ("first".equalsIgnoreCase(curOperation) || "last".equalsIgnoreCase(curOperation)) {
                    skipValue += limit;
                }
                if (CollectionUtils.isEmpty((Collection)rembackupImageList) || backupImageList.size() == recordsCount) {
                    allRecordsFound = true;
                } else {
                    limit -= filteredRembackupImageList.size();
                }
                this.logger.debug(desc + "......inside remaining list...." + limit + "....filterd...." + filteredRembackupImageList.size() + "...." + skipValue);
            } while (!allRecordsFound);
        } else {
            this.logger.debug(totalCount + ".&&&&&&&&&&&&&&&&&&&&&&& records found &&&&&&&&&&&&&&&&&&&" + recordsCount + "..im..." + backupImageList.size() + "..." + curOperation);
            if (totalCount < recordsCount) {
                this.logger.debug("set same skip...." + skipValue);
                nextCur.set(orgSkipValue);
            }
            if (backupImageList.size() == recordsCount && ("next".equalsIgnoreCase(curOperation) || "first".equalsIgnoreCase(curOperation) || "last".equalsIgnoreCase(curOperation))) {
                skipValue += recordsCount;
            }
        }
        this.logger.debug(".&&&&&&&&&&&&&&&&&&&&&&& CHANGE VALUES &&&&&&&&&&&&&&&&&&&" + skipValue);
        this.logger.debug("...query order..." + desc + "...next..." + nextCur.get());
        if (!CollectionUtils.isEmpty(backupImageList)) {
            nextCur.set(skipValue);
        }
        if (totalCount < recordsCount) {
            this.logger.debug("set same skip...." + skipValue);
            nextCur.set(orgSkipValue);
        }
        if (prev) {
            prevCur.set(skipValue);
        } else {
            prevCur.set(orgNextCur);
        }
        if (prev) {
            nextCur.set(orgNextCur);
        }
        this.logger.debug(nextCur.get() + "...query result after filtering...." + backupImageList.size() + "...skip..." + skipValue + "..." + recordsCount);
        this.logger.debug(".&&&&&&&&&&&&&&&&&&&&&&& after CHANGE VALUES &&&&&&&&&&&&&&&&&&&" + skipValue);
        this.logger.debug(nextCur.get() + "...query result prev and next .....");
        ArrayList<BackUpImage> overAllList = new ArrayList<BackUpImage>();
        overAllList.addAll(folderList);
        overAllList.addAll(backupImageList);
        Comparator reverseComparator = (c1, c2) -> {
            if (c1.getSentDate() == null || c2.getSentDate() == null) {
                return 0;
            }
            return c2.getSentDate().compareTo(c1.getSentDate());
        };
        Collections.sort(overAllList, reverseComparator);
        return overAllList;
    }

    private int getSkipValue(int skipValue, int recordsCount, boolean desc, String curOperation) {
        if ("next".equalsIgnoreCase(curOperation)) {
            skipValue = desc ? (skipValue += recordsCount) : (skipValue -= recordsCount);
        }
        if ("prev".equalsIgnoreCase(curOperation)) {
            skipValue = desc ? (skipValue -= recordsCount) : (skipValue += recordsCount);
        }
        return skipValue;
    }

    private List<BackUpImage> getFolderForMail(String folderPath, Device device, int skipValue, int recordsCount, MongoTemplate mongoTemplate, boolean isrestoreDeletedFile) {
        List list;
        ArrayList<BackUpImage> backupImageFolderList = new ArrayList<BackUpImage>();
        Criteria criteria = new Criteria();
        if (isrestoreDeletedFile) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FOLDER).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)FOLDER).is((Object)true)});
        }
        org.springframework.data.mongodb.core.query.Query query1 = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query1.with(new Sort(Sort.Direction.ASC, new String[]{FILE_NAME}));
        if (skipValue != 0) {
            query1.skip((long)(skipValue * recordsCount));
        }
        if (recordsCount != 0) {
            query1.limit(recordsCount);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = mongoTemplate.find(query1, BackUpImage.class, device.getDestCollection())))) {
            backupImageFolderList.addAll(list);
        }
        if (!CollectionUtils.isEmpty(backupImageFolderList)) {
            if (backupImageFolderList.size() == recordsCount) {
                backupImageFolderList.sort(Comparator.comparing(BackUpImage::getFileName));
                return backupImageFolderList;
            }
            this.logger.debug("...more folders to process....");
            backupImageFolderList.sort(Comparator.comparing(BackUpImage::getFileName));
        }
        return backupImageFolderList;
    }

    @Override
    public BackUpImage getMailBackUpImageInfo(int cloudId, Device device, ObjectId backupId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId), Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID())});
        org.springframework.data.mongodb.core.query.Query query1 = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return (BackUpImage)mongoTemplate.findOne(query1, BackUpImage.class, device.getDestCollection());
    }

    @Override
    public long getTotalMails(int cloudId, String devicePath, Device device, boolean isrestoreDeletedFile) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)PRESENT).is((Object)true)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.count(query, BackUpImage.class, device.getDestCollection());
    }

    @Override
    public List<BackUpImage> getLatestFoldersRecursiveWithoutStatus(int cloudId, String cloudName, Device device, String devicePath) {
        List<BackUpImage> resList = new ArrayList<BackUpImage>();
        try {
            boolean retry;
            String deviceUUID = device.getDeviceUUID();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            int retryCount = 0;
            do {
                retry = false;
                try {
                    ArrayList<BackUpImage> backupImages = new ArrayList<BackUpImage>();
                    this.logger.error("##getting folders recursive device path: .........." + devicePath);
                    Criteria pathLikeCriteria = new Criteria();
                    if (!StringUtils.isEmpty((String)devicePath)) {
                        pathLikeCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
                    } else {
                        pathLikeCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).exists(false), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
                    }
                    org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)pathLikeCriteria);
                    List<String> bkpCollectionList = this.getBackupCollectionList(device);
                    for (String dest : bkpCollectionList) {
                        List backupImagesList = mongoTemplate.find(query, BackUpImage.class, dest);
                        if (CollectionUtils.isEmpty((Collection)backupImagesList)) continue;
                        backupImages.addAll(backupImagesList);
                    }
                    if (this.isDeviceQueryCheckEnabled(cloudId)) {
                        Criteria pathLikeCriteriaForDeviceUUID = new Criteria();
                        if (!StringUtils.isEmpty((String)devicePath)) {
                            pathLikeCriteriaForDeviceUUID.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)true)});
                        } else {
                            pathLikeCriteriaForDeviceUUID.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).exists(false), Criteria.where((String)FOLDER).is((Object)true)});
                        }
                        org.springframework.data.mongodb.core.query.Query queryForDeviceUUID = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)pathLikeCriteriaForDeviceUUID);
                        for (String dest : bkpCollectionList) {
                            List backupImagesList = mongoTemplate.find(queryForDeviceUUID, BackUpImage.class, dest);
                            if (CollectionUtils.isEmpty((Collection)backupImagesList)) continue;
                            backupImages.addAll(backupImagesList);
                        }
                        this.logger.error("##End Trying to get devicepath list andoperator .........." + backupImages.size());
                    }
                    resList = this.getFilteredBackupImageListByGrouping(backupImages, true);
                    this.logger.error("##End Result list after grouping.........." + resList.size());
                }
                catch (Exception e) {
                    retry = true;
                    ++retryCount;
                    this.logger.debug("insode mongo db exception whule getting folder list so sleep and retry######");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e1) {
                        this.logger.debug("InterruptedException" + e1.getMessage());
                        this.logger.debug("InterruptedException" + e1);
                    }
                    this.logger.trace("" + e);
                    this.logger.error("Exception while getting latest files:" + e.getMessage());
                    if (retryCount != 3) continue;
                    return null;
                }
            } while (retry && retryCount < 3);
        }
        catch (Exception e) {
            this.logger.debug("" + e.getMessage());
            this.logger.debug("" + e);
        }
        this.logger.debug("result list size>>>>" + resList.size());
        return resList;
    }

    @Override
    public List<BackUpImage> getAllChildFilesOfFolder(int cloudId, String devicePath, Device device, List<ObjectId> ids) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
        Criteria andCreiteria = new Criteria();
        andCreiteria.andOperator(new Criteria[]{Criteria.where((String)"id").nin(ids), criteria});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)andCreiteria);
        return mongoTemplate.find(query, BackUpImage.class, device.getDestCollection());
    }

    @Override
    public long getTotalMailsWithoutFolder(int cloudId, String devicePath, Device device, boolean isrestoreDeletedFile) {
        Criteria criteria = new Criteria();
        if (isrestoreDeletedFile) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)PRESENT).is((Object)true)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.count(query, BackUpImage.class, device.getDestCollection());
    }

    @Override
    public long getTotalMailFolderForPath(int cloudId, String devicePath, Device device, boolean isrestoreDeletedFile) {
        Criteria criteria = new Criteria();
        if (isrestoreDeletedFile) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.count(query, BackUpImage.class, device.getDestCollection());
    }
}

